#!/usr/bin/env node
// Xiaomi Outbound Call Skill - Bundled with esbuild

"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __commonJS = (cb, mod) => function __require() {
  return mod || (0, cb[__getOwnPropNames(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
};
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// node_modules/ms/index.js
var require_ms = __commonJS({
  "node_modules/ms/index.js"(exports2, module2) {
    var s = 1e3;
    var m = s * 60;
    var h = m * 60;
    var d = h * 24;
    var w = d * 7;
    var y = d * 365.25;
    module2.exports = function(val, options) {
      options = options || {};
      var type = typeof val;
      if (type === "string" && val.length > 0) {
        return parse(val);
      } else if (type === "number" && isFinite(val)) {
        return options.long ? fmtLong(val) : fmtShort(val);
      }
      throw new Error(
        "val is not a non-empty string or a valid number. val=" + JSON.stringify(val)
      );
    };
    function parse(str) {
      str = String(str);
      if (str.length > 100) {
        return;
      }
      var match = /^(-?(?:\d+)?\.?\d+) *(milliseconds?|msecs?|ms|seconds?|secs?|s|minutes?|mins?|m|hours?|hrs?|h|days?|d|weeks?|w|years?|yrs?|y)?$/i.exec(
        str
      );
      if (!match) {
        return;
      }
      var n = parseFloat(match[1]);
      var type = (match[2] || "ms").toLowerCase();
      switch (type) {
        case "years":
        case "year":
        case "yrs":
        case "yr":
        case "y":
          return n * y;
        case "weeks":
        case "week":
        case "w":
          return n * w;
        case "days":
        case "day":
        case "d":
          return n * d;
        case "hours":
        case "hour":
        case "hrs":
        case "hr":
        case "h":
          return n * h;
        case "minutes":
        case "minute":
        case "mins":
        case "min":
        case "m":
          return n * m;
        case "seconds":
        case "second":
        case "secs":
        case "sec":
        case "s":
          return n * s;
        case "milliseconds":
        case "millisecond":
        case "msecs":
        case "msec":
        case "ms":
          return n;
        default:
          return void 0;
      }
    }
    function fmtShort(ms) {
      var msAbs = Math.abs(ms);
      if (msAbs >= d) {
        return Math.round(ms / d) + "d";
      }
      if (msAbs >= h) {
        return Math.round(ms / h) + "h";
      }
      if (msAbs >= m) {
        return Math.round(ms / m) + "m";
      }
      if (msAbs >= s) {
        return Math.round(ms / s) + "s";
      }
      return ms + "ms";
    }
    function fmtLong(ms) {
      var msAbs = Math.abs(ms);
      if (msAbs >= d) {
        return plural(ms, msAbs, d, "day");
      }
      if (msAbs >= h) {
        return plural(ms, msAbs, h, "hour");
      }
      if (msAbs >= m) {
        return plural(ms, msAbs, m, "minute");
      }
      if (msAbs >= s) {
        return plural(ms, msAbs, s, "second");
      }
      return ms + " ms";
    }
    function plural(ms, msAbs, n, name) {
      var isPlural = msAbs >= n * 1.5;
      return Math.round(ms / n) + " " + name + (isPlural ? "s" : "");
    }
  }
});

// node_modules/debug/src/common.js
var require_common = __commonJS({
  "node_modules/debug/src/common.js"(exports2, module2) {
    function setup(env) {
      createDebug.debug = createDebug;
      createDebug.default = createDebug;
      createDebug.coerce = coerce;
      createDebug.disable = disable;
      createDebug.enable = enable;
      createDebug.enabled = enabled;
      createDebug.humanize = require_ms();
      createDebug.destroy = destroy;
      Object.keys(env).forEach((key) => {
        createDebug[key] = env[key];
      });
      createDebug.names = [];
      createDebug.skips = [];
      createDebug.formatters = {};
      function selectColor(namespace) {
        let hash = 0;
        for (let i = 0; i < namespace.length; i++) {
          hash = (hash << 5) - hash + namespace.charCodeAt(i);
          hash |= 0;
        }
        return createDebug.colors[Math.abs(hash) % createDebug.colors.length];
      }
      createDebug.selectColor = selectColor;
      function createDebug(namespace) {
        let prevTime;
        let enableOverride = null;
        let namespacesCache;
        let enabledCache;
        function debug(...args) {
          if (!debug.enabled) {
            return;
          }
          const self2 = debug;
          const curr = Number(/* @__PURE__ */ new Date());
          const ms = curr - (prevTime || curr);
          self2.diff = ms;
          self2.prev = prevTime;
          self2.curr = curr;
          prevTime = curr;
          args[0] = createDebug.coerce(args[0]);
          if (typeof args[0] !== "string") {
            args.unshift("%O");
          }
          let index = 0;
          args[0] = args[0].replace(/%([a-zA-Z%])/g, (match, format) => {
            if (match === "%%") {
              return "%";
            }
            index++;
            const formatter = createDebug.formatters[format];
            if (typeof formatter === "function") {
              const val = args[index];
              match = formatter.call(self2, val);
              args.splice(index, 1);
              index--;
            }
            return match;
          });
          createDebug.formatArgs.call(self2, args);
          const logFn = self2.log || createDebug.log;
          logFn.apply(self2, args);
        }
        debug.namespace = namespace;
        debug.useColors = createDebug.useColors();
        debug.color = createDebug.selectColor(namespace);
        debug.extend = extend;
        debug.destroy = createDebug.destroy;
        Object.defineProperty(debug, "enabled", {
          enumerable: true,
          configurable: false,
          get: () => {
            if (enableOverride !== null) {
              return enableOverride;
            }
            if (namespacesCache !== createDebug.namespaces) {
              namespacesCache = createDebug.namespaces;
              enabledCache = createDebug.enabled(namespace);
            }
            return enabledCache;
          },
          set: (v) => {
            enableOverride = v;
          }
        });
        if (typeof createDebug.init === "function") {
          createDebug.init(debug);
        }
        return debug;
      }
      function extend(namespace, delimiter) {
        const newDebug = createDebug(this.namespace + (typeof delimiter === "undefined" ? ":" : delimiter) + namespace);
        newDebug.log = this.log;
        return newDebug;
      }
      function enable(namespaces) {
        createDebug.save(namespaces);
        createDebug.namespaces = namespaces;
        createDebug.names = [];
        createDebug.skips = [];
        const split = (typeof namespaces === "string" ? namespaces : "").trim().replace(/\s+/g, ",").split(",").filter(Boolean);
        for (const ns of split) {
          if (ns[0] === "-") {
            createDebug.skips.push(ns.slice(1));
          } else {
            createDebug.names.push(ns);
          }
        }
      }
      function matchesTemplate(search, template) {
        let searchIndex = 0;
        let templateIndex = 0;
        let starIndex = -1;
        let matchIndex = 0;
        while (searchIndex < search.length) {
          if (templateIndex < template.length && (template[templateIndex] === search[searchIndex] || template[templateIndex] === "*")) {
            if (template[templateIndex] === "*") {
              starIndex = templateIndex;
              matchIndex = searchIndex;
              templateIndex++;
            } else {
              searchIndex++;
              templateIndex++;
            }
          } else if (starIndex !== -1) {
            templateIndex = starIndex + 1;
            matchIndex++;
            searchIndex = matchIndex;
          } else {
            return false;
          }
        }
        while (templateIndex < template.length && template[templateIndex] === "*") {
          templateIndex++;
        }
        return templateIndex === template.length;
      }
      function disable() {
        const namespaces = [
          ...createDebug.names,
          ...createDebug.skips.map((namespace) => "-" + namespace)
        ].join(",");
        createDebug.enable("");
        return namespaces;
      }
      function enabled(name) {
        for (const skip of createDebug.skips) {
          if (matchesTemplate(name, skip)) {
            return false;
          }
        }
        for (const ns of createDebug.names) {
          if (matchesTemplate(name, ns)) {
            return true;
          }
        }
        return false;
      }
      function coerce(val) {
        if (val instanceof Error) {
          return val.stack || val.message;
        }
        return val;
      }
      function destroy() {
        console.warn("Instance method `debug.destroy()` is deprecated and no longer does anything. It will be removed in the next major version of `debug`.");
      }
      createDebug.enable(createDebug.load());
      return createDebug;
    }
    module2.exports = setup;
  }
});

// node_modules/debug/src/browser.js
var require_browser = __commonJS({
  "node_modules/debug/src/browser.js"(exports2, module2) {
    exports2.formatArgs = formatArgs;
    exports2.save = save;
    exports2.load = load;
    exports2.useColors = useColors;
    exports2.storage = localstorage();
    exports2.destroy = /* @__PURE__ */ (() => {
      let warned = false;
      return () => {
        if (!warned) {
          warned = true;
          console.warn("Instance method `debug.destroy()` is deprecated and no longer does anything. It will be removed in the next major version of `debug`.");
        }
      };
    })();
    exports2.colors = [
      "#0000CC",
      "#0000FF",
      "#0033CC",
      "#0033FF",
      "#0066CC",
      "#0066FF",
      "#0099CC",
      "#0099FF",
      "#00CC00",
      "#00CC33",
      "#00CC66",
      "#00CC99",
      "#00CCCC",
      "#00CCFF",
      "#3300CC",
      "#3300FF",
      "#3333CC",
      "#3333FF",
      "#3366CC",
      "#3366FF",
      "#3399CC",
      "#3399FF",
      "#33CC00",
      "#33CC33",
      "#33CC66",
      "#33CC99",
      "#33CCCC",
      "#33CCFF",
      "#6600CC",
      "#6600FF",
      "#6633CC",
      "#6633FF",
      "#66CC00",
      "#66CC33",
      "#9900CC",
      "#9900FF",
      "#9933CC",
      "#9933FF",
      "#99CC00",
      "#99CC33",
      "#CC0000",
      "#CC0033",
      "#CC0066",
      "#CC0099",
      "#CC00CC",
      "#CC00FF",
      "#CC3300",
      "#CC3333",
      "#CC3366",
      "#CC3399",
      "#CC33CC",
      "#CC33FF",
      "#CC6600",
      "#CC6633",
      "#CC9900",
      "#CC9933",
      "#CCCC00",
      "#CCCC33",
      "#FF0000",
      "#FF0033",
      "#FF0066",
      "#FF0099",
      "#FF00CC",
      "#FF00FF",
      "#FF3300",
      "#FF3333",
      "#FF3366",
      "#FF3399",
      "#FF33CC",
      "#FF33FF",
      "#FF6600",
      "#FF6633",
      "#FF9900",
      "#FF9933",
      "#FFCC00",
      "#FFCC33"
    ];
    function useColors() {
      if (typeof window !== "undefined" && window.process && (window.process.type === "renderer" || window.process.__nwjs)) {
        return true;
      }
      if (typeof navigator !== "undefined" && navigator.userAgent && navigator.userAgent.toLowerCase().match(/(edge|trident)\/(\d+)/)) {
        return false;
      }
      let m;
      return typeof document !== "undefined" && document.documentElement && document.documentElement.style && document.documentElement.style.WebkitAppearance || // Is firebug? http://stackoverflow.com/a/398120/376773
      typeof window !== "undefined" && window.console && (window.console.firebug || window.console.exception && window.console.table) || // Is firefox >= v31?
      // https://developer.mozilla.org/en-US/docs/Tools/Web_Console#Styling_messages
      typeof navigator !== "undefined" && navigator.userAgent && (m = navigator.userAgent.toLowerCase().match(/firefox\/(\d+)/)) && parseInt(m[1], 10) >= 31 || // Double check webkit in userAgent just in case we are in a worker
      typeof navigator !== "undefined" && navigator.userAgent && navigator.userAgent.toLowerCase().match(/applewebkit\/(\d+)/);
    }
    function formatArgs(args) {
      args[0] = (this.useColors ? "%c" : "") + this.namespace + (this.useColors ? " %c" : " ") + args[0] + (this.useColors ? "%c " : " ") + "+" + module2.exports.humanize(this.diff);
      if (!this.useColors) {
        return;
      }
      const c = "color: " + this.color;
      args.splice(1, 0, c, "color: inherit");
      let index = 0;
      let lastC = 0;
      args[0].replace(/%[a-zA-Z%]/g, (match) => {
        if (match === "%%") {
          return;
        }
        index++;
        if (match === "%c") {
          lastC = index;
        }
      });
      args.splice(lastC, 0, c);
    }
    exports2.log = console.debug || console.log || (() => {
    });
    function save(namespaces) {
      try {
        if (namespaces) {
          exports2.storage.setItem("debug", namespaces);
        } else {
          exports2.storage.removeItem("debug");
        }
      } catch (error) {
      }
    }
    function load() {
      let r;
      try {
        r = exports2.storage.getItem("debug") || exports2.storage.getItem("DEBUG");
      } catch (error) {
      }
      if (!r && typeof process !== "undefined" && "env" in process) {
        r = process.env.DEBUG;
      }
      return r;
    }
    function localstorage() {
      try {
        return localStorage;
      } catch (error) {
      }
    }
    module2.exports = require_common()(exports2);
    var { formatters } = module2.exports;
    formatters.j = function(v) {
      try {
        return JSON.stringify(v);
      } catch (error) {
        return "[UnexpectedJSONParseError]: " + error.message;
      }
    };
  }
});

// node_modules/debug/src/node.js
var require_node = __commonJS({
  "node_modules/debug/src/node.js"(exports2, module2) {
    var tty = require("tty");
    var util = require("util");
    exports2.init = init;
    exports2.log = log;
    exports2.formatArgs = formatArgs;
    exports2.save = save;
    exports2.load = load;
    exports2.useColors = useColors;
    exports2.destroy = util.deprecate(
      () => {
      },
      "Instance method `debug.destroy()` is deprecated and no longer does anything. It will be removed in the next major version of `debug`."
    );
    exports2.colors = [6, 2, 3, 4, 5, 1];
    try {
      const supportsColor = require("supports-color");
      if (supportsColor && (supportsColor.stderr || supportsColor).level >= 2) {
        exports2.colors = [
          20,
          21,
          26,
          27,
          32,
          33,
          38,
          39,
          40,
          41,
          42,
          43,
          44,
          45,
          56,
          57,
          62,
          63,
          68,
          69,
          74,
          75,
          76,
          77,
          78,
          79,
          80,
          81,
          92,
          93,
          98,
          99,
          112,
          113,
          128,
          129,
          134,
          135,
          148,
          149,
          160,
          161,
          162,
          163,
          164,
          165,
          166,
          167,
          168,
          169,
          170,
          171,
          172,
          173,
          178,
          179,
          184,
          185,
          196,
          197,
          198,
          199,
          200,
          201,
          202,
          203,
          204,
          205,
          206,
          207,
          208,
          209,
          214,
          215,
          220,
          221
        ];
      }
    } catch (error) {
    }
    exports2.inspectOpts = Object.keys(process.env).filter((key) => {
      return /^debug_/i.test(key);
    }).reduce((obj, key) => {
      const prop = key.substring(6).toLowerCase().replace(/_([a-z])/g, (_, k) => {
        return k.toUpperCase();
      });
      let val = process.env[key];
      if (/^(yes|on|true|enabled)$/i.test(val)) {
        val = true;
      } else if (/^(no|off|false|disabled)$/i.test(val)) {
        val = false;
      } else if (val === "null") {
        val = null;
      } else {
        val = Number(val);
      }
      obj[prop] = val;
      return obj;
    }, {});
    function useColors() {
      return "colors" in exports2.inspectOpts ? Boolean(exports2.inspectOpts.colors) : tty.isatty(process.stderr.fd);
    }
    function formatArgs(args) {
      const { namespace: name, useColors: useColors2 } = this;
      if (useColors2) {
        const c = this.color;
        const colorCode = "\x1B[3" + (c < 8 ? c : "8;5;" + c);
        const prefix = `  ${colorCode};1m${name} \x1B[0m`;
        args[0] = prefix + args[0].split("\n").join("\n" + prefix);
        args.push(colorCode + "m+" + module2.exports.humanize(this.diff) + "\x1B[0m");
      } else {
        args[0] = getDate() + name + " " + args[0];
      }
    }
    function getDate() {
      if (exports2.inspectOpts.hideDate) {
        return "";
      }
      return (/* @__PURE__ */ new Date()).toISOString() + " ";
    }
    function log(...args) {
      return process.stderr.write(util.formatWithOptions(exports2.inspectOpts, ...args) + "\n");
    }
    function save(namespaces) {
      if (namespaces) {
        process.env.DEBUG = namespaces;
      } else {
        delete process.env.DEBUG;
      }
    }
    function load() {
      return process.env.DEBUG;
    }
    function init(debug) {
      debug.inspectOpts = {};
      const keys = Object.keys(exports2.inspectOpts);
      for (let i = 0; i < keys.length; i++) {
        debug.inspectOpts[keys[i]] = exports2.inspectOpts[keys[i]];
      }
    }
    module2.exports = require_common()(exports2);
    var { formatters } = module2.exports;
    formatters.o = function(v) {
      this.inspectOpts.colors = this.useColors;
      return util.inspect(v, this.inspectOpts).split("\n").map((str) => str.trim()).join(" ");
    };
    formatters.O = function(v) {
      this.inspectOpts.colors = this.useColors;
      return util.inspect(v, this.inspectOpts);
    };
  }
});

// node_modules/debug/src/index.js
var require_src = __commonJS({
  "node_modules/debug/src/index.js"(exports2, module2) {
    if (typeof process === "undefined" || process.type === "renderer" || process.browser === true || process.__nwjs) {
      module2.exports = require_browser();
    } else {
      module2.exports = require_node();
    }
  }
});

// node_modules/httpx/lib/index.js
var require_lib = __commonJS({
  "node_modules/httpx/lib/index.js"(exports2) {
    "use strict";
    var zlib = require("zlib");
    var http = require("http");
    var https = require("https");
    var parse = require("url").parse;
    var format = require("url").format;
    var debugBody = require_src()("httpx:body");
    var debugHeader = require_src()("httpx:header");
    var httpAgent = new http.Agent({ keepAlive: true });
    var httpsAgent = new https.Agent({ keepAlive: true });
    var TIMEOUT = 3e3;
    var READ_TIMER = /* @__PURE__ */ Symbol("TIMER::READ_TIMER");
    var READ_TIME_OUT = /* @__PURE__ */ Symbol("TIMER::READ_TIME_OUT");
    var READ_TIMER_START_AT = /* @__PURE__ */ Symbol("TIMER::READ_TIMER_START_AT");
    function decompress(response) {
      switch (response.headers["content-encoding"]) {
        // or, just use zlib.createUnzip() to handle both cases
        case "gzip":
          return response.pipe(zlib.createGunzip());
        case "deflate":
          return response.pipe(zlib.createInflate());
        default:
          return response;
      }
    }
    var append = function(err, name, message) {
      err.name = name + err.name;
      err.message = `${message}. ${err.message}`;
      return err;
    };
    var isNumber = function(num) {
      return num !== null && !isNaN(num);
    };
    exports2.request = function(url, opts) {
      opts || (opts = {});
      const parsed = typeof url === "string" ? parse(url) : url;
      let readTimeout, connectTimeout;
      if (isNumber(opts.readTimeout) || isNumber(opts.connectTimeout)) {
        readTimeout = isNumber(opts.readTimeout) ? Number(opts.readTimeout) : TIMEOUT;
        connectTimeout = isNumber(opts.connectTimeout) ? Number(opts.connectTimeout) : TIMEOUT;
      } else if (isNumber(opts.timeout)) {
        readTimeout = connectTimeout = Number(opts.timeout);
      } else {
        readTimeout = connectTimeout = TIMEOUT;
      }
      const isHttps = parsed.protocol === "https:";
      const method = (opts.method || "GET").toUpperCase();
      const defaultAgent = isHttps ? httpsAgent : httpAgent;
      const agent = opts.agent || defaultAgent;
      var options = {
        host: parsed.hostname || "localhost",
        path: parsed.path || "/",
        method,
        port: parsed.port || (parsed.protocol === "https:" ? 443 : 80),
        agent,
        headers: opts.headers || {},
        // ssl config
        key: opts.key || "",
        cert: opts.cert || "",
        ca: opts.ca || "",
        // connect timerout
        timeout: connectTimeout
      };
      if (isHttps && typeof opts.rejectUnauthorized !== "undefined") {
        options.rejectUnauthorized = opts.rejectUnauthorized;
      }
      if (opts.compression) {
        options.headers["accept-encoding"] = "gzip,deflate";
      }
      const httplib = isHttps ? https : http;
      if (typeof opts.beforeRequest === "function") {
        options = opts.beforeRequest(options);
      }
      return new Promise((resolve2, reject) => {
        const request = httplib.request(options);
        const body = opts.data;
        var fulfilled = (response) => {
          if (debugHeader.enabled) {
            const requestHeaders = response.req._header;
            requestHeaders.split("\r\n").forEach((line) => {
              debugHeader("> %s", line);
            });
            debugHeader("< HTTP/%s %s %s", response.httpVersion, response.statusCode, response.statusMessage);
            Object.keys(response.headers).forEach((key) => {
              debugHeader("< %s: %s", key, response.headers[key]);
            });
          }
          resolve2(response);
        };
        var rejected = (err) => {
          err.message += `${method} ${format(parsed)} failed.`;
          if (request.socket && request.socket[READ_TIMER]) {
            clearTimeout(request.socket[READ_TIMER]);
          }
          reject(err);
        };
        var abort = (err) => {
          request.abort();
          rejected(err);
        };
        const startResponseTimer = function(socket) {
          const timer = setTimeout(() => {
            if (socket[READ_TIMER]) {
              clearTimeout(socket[READ_TIMER]);
              socket[READ_TIMER] = null;
            }
            var err = new Error();
            var message = `ReadTimeout(${readTimeout})`;
            abort(append(err, "RequestTimeout", message));
          }, readTimeout);
          socket[READ_TIME_OUT] = readTimeout;
          socket[READ_TIMER] = timer;
          socket[READ_TIMER_START_AT] = Date.now();
          timer.unref();
        };
        if (!body || "string" === typeof body || body instanceof Buffer) {
          if (debugBody.enabled) {
            if (!body) {
              debugBody("<no request body>");
            } else if ("string" === typeof body) {
              debugBody(body);
            } else {
              debugBody(`Buffer <ignored>, Buffer length: ${body.length}`);
            }
          }
          request.end(body);
        } else if ("function" === typeof body.pipe) {
          body.pipe(request);
          if (debugBody.enabled) {
            debugBody("<request body is a stream>");
          }
          body.once("error", (err) => {
            abort(append(err, "HttpX", "Stream occor error"));
          });
        }
        request.on("timeout", () => {
          var err = new Error();
          err.name = "RequestTimeoutError";
          err.message = `ConnectTimeout: Connect ${url} failed.`;
          request.destroy();
          reject(err);
        });
        request.on("response", fulfilled);
        request.on("error", rejected);
        request.once("socket", function(socket) {
          if (socket.readyState === "opening") {
            socket.once("connect", function() {
              startResponseTimer(socket);
            });
          } else {
            startResponseTimer(socket);
          }
        });
      });
    };
    exports2.read = function(response, encoding) {
      const readable = decompress(response);
      return new Promise((resolve2, reject) => {
        const socket = response.socket || response.client;
        const makeReadTimeoutError = () => {
          const req = response.req;
          var err = new Error();
          err.name = "RequestTimeoutError";
          err.message = `ReadTimeout: ${socket[READ_TIME_OUT]}. ${req.method} ${req.path} failed.`;
          return err;
        };
        let readTimer;
        const oldReadTimer = socket[READ_TIMER];
        if (!oldReadTimer) {
          reject(makeReadTimeoutError());
          return;
        }
        const remainTime = socket[READ_TIME_OUT] - (Date.now() - socket[READ_TIMER_START_AT]);
        clearTimeout(oldReadTimer);
        if (remainTime <= 0) {
          reject(makeReadTimeoutError());
          return;
        }
        readTimer = setTimeout(function() {
          reject(makeReadTimeoutError());
        }, remainTime);
        var onError, onData, onEnd;
        var cleanup = function() {
          readable.removeListener("error", onError);
          readable.removeListener("data", onData);
          readable.removeListener("end", onEnd);
          if (readTimer) {
            clearTimeout(readTimer);
          }
        };
        const bufs = [];
        var size = 0;
        onData = function(buf) {
          bufs.push(buf);
          size += buf.length;
        };
        onError = function(err) {
          cleanup();
          reject(err);
        };
        onEnd = function() {
          cleanup();
          var buff = Buffer.concat(bufs, size);
          debugBody("");
          if (encoding) {
            const result = buff.toString(encoding);
            debugBody(result);
            return resolve2(result);
          }
          if (debugBody.enabled) {
            debugBody(buff.toString());
          }
          resolve2(buff);
        };
        readable.on("error", onError);
        readable.on("data", onData);
        readable.on("end", onEnd);
      });
    };
    function readyToRead(readable) {
      return new Promise((resolve2, reject) => {
        var onReadable, onEnd, onError;
        var cleanup = function() {
          readable.removeListener("error", onError);
          readable.removeListener("end", onEnd);
          readable.removeListener("readable", onReadable);
        };
        onReadable = function() {
          cleanup();
          resolve2(false);
        };
        onEnd = function() {
          cleanup();
          resolve2(true);
        };
        onError = function(err) {
          cleanup();
          reject(err);
        };
        readable.once("readable", onReadable);
        readable.once("end", onEnd);
        readable.once("error", onError);
      });
    }
    var Event = class {
      constructor(id, event, data, retry) {
        this.id = id;
        this.event = event;
        this.data = data;
        this.retry = retry;
      }
    };
    exports2.Event = Event;
    var DATA_PREFIX = "data:";
    var EVENT_PREFIX = "event:";
    var ID_PREFIX = "id:";
    var RETRY_PREFIX = "retry:";
    function isDigitsOnly(str) {
      for (let i = 0; i < str.length; i++) {
        const c = str.charAt(i);
        if (c < "0" || c > "9") {
          return false;
        }
      }
      return str.length > 0;
    }
    function tryGetEvents(head, chunk) {
      const all = head + chunk;
      let start = 0;
      const events = [];
      for (let i = 0; i < all.length - 1; i++) {
        const c = all[i];
        const c2 = all[i + 1];
        if (c === "\n" && c2 === "\n") {
          const part = all.substring(start, i);
          const lines = part.split("\n");
          const event = new Event();
          lines.forEach((line) => {
            if (line.startsWith(DATA_PREFIX)) {
              event.data = line.substring(DATA_PREFIX.length).trim();
            } else if (line.startsWith(EVENT_PREFIX)) {
              event.event = line.substring(EVENT_PREFIX.length).trim();
            } else if (line.startsWith(ID_PREFIX)) {
              event.id = line.substring(ID_PREFIX.length).trim();
            } else if (line.startsWith(RETRY_PREFIX)) {
              const retry = line.substring(RETRY_PREFIX.length).trim();
              if (isDigitsOnly(retry)) {
                event.retry = parseInt(retry, 10);
              }
            } else if (line.startsWith(":")) {
            }
          });
          events.push(event);
          start = i + 2;
        }
      }
      const rest = all.substring(start);
      return [events, rest];
    }
    exports2.readAsSSE = async function* (response) {
      const readable = decompress(response);
      const socket = response.socket || response.client;
      clearTimeout(socket[READ_TIMER]);
      let rest = "";
      while (true) {
        const ended = await readyToRead(readable);
        if (ended) {
          return;
        }
        let chunk;
        while (null !== (chunk = readable.read())) {
          const [events, remain] = tryGetEvents(rest, chunk.toString());
          rest = remain;
          if (events && events.length > 0) {
            for (const event of events) {
              yield event;
            }
          }
        }
      }
    };
  }
});

// node_modules/@darabonba/typescript/dist/retry.js
var require_retry = __commonJS({
  "node_modules/@darabonba/typescript/dist/retry.js"(exports2) {
    "use strict";
    var __extends = exports2 && exports2.__extends || /* @__PURE__ */ (function() {
      var extendStatics = function(d, b) {
        extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function(d2, b2) {
          d2.__proto__ = b2;
        } || function(d2, b2) {
          for (var p in b2) if (Object.prototype.hasOwnProperty.call(b2, p)) d2[p] = b2[p];
        };
        return extendStatics(d, b);
      };
      return function(d, b) {
        if (typeof b !== "function" && b !== null)
          throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() {
          this.constructor = d;
        }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
      };
    })();
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.getBackoffDelay = exports2.shouldRetry = exports2.RetryPolicyContext = exports2.RetryOptions = exports2.RetryCondition = exports2.BackoffPolicy = void 0;
    var MAX_DELAY_TIME = 120 * 1e3;
    var MIN_DELAY_TIME = 100;
    var BackoffPolicy = (
      /** @class */
      (function() {
        function BackoffPolicy2(option) {
          this.policy = option.policy;
        }
        BackoffPolicy2.prototype.getDelayTime = function(ctx) {
          throw Error("un-implement");
        };
        BackoffPolicy2.newBackoffPolicy = function(option) {
          switch (option.policy) {
            case "Fixed":
              return new FixedBackoffPolicy(option);
            case "Random":
              return new RandomBackoffPolicy(option);
            case "Exponential":
              return new ExponentialBackoffPolicy(option);
            case "EqualJitter":
            case "ExponentialWithEqualJitter":
              return new EqualJitterBackoffPolicy(option);
            case "FullJitter":
            case "ExponentialWithFullJitter":
              return new FullJitterBackoffPolicy(option);
          }
        };
        return BackoffPolicy2;
      })()
    );
    exports2.BackoffPolicy = BackoffPolicy;
    var FixedBackoffPolicy = (
      /** @class */
      (function(_super) {
        __extends(FixedBackoffPolicy2, _super);
        function FixedBackoffPolicy2(option) {
          var _this = _super.call(this, option) || this;
          _this.period = option.period;
          return _this;
        }
        FixedBackoffPolicy2.prototype.getDelayTime = function(ctx) {
          return this.period;
        };
        return FixedBackoffPolicy2;
      })(BackoffPolicy)
    );
    var RandomBackoffPolicy = (
      /** @class */
      (function(_super) {
        __extends(RandomBackoffPolicy2, _super);
        function RandomBackoffPolicy2(option) {
          var _this = _super.call(this, option) || this;
          _this.period = option.period;
          _this.cap = option.cap || 20 * 1e3;
          return _this;
        }
        RandomBackoffPolicy2.prototype.getDelayTime = function(ctx) {
          var randomTime = Math.floor(Math.random() * (ctx.retriesAttempted * this.period));
          if (randomTime > this.cap) {
            return this.cap;
          }
          return randomTime;
        };
        return RandomBackoffPolicy2;
      })(BackoffPolicy)
    );
    var ExponentialBackoffPolicy = (
      /** @class */
      (function(_super) {
        __extends(ExponentialBackoffPolicy2, _super);
        function ExponentialBackoffPolicy2(option) {
          var _this = _super.call(this, option) || this;
          _this.period = option.period;
          _this.cap = option.cap || 3 * 24 * 60 * 60 * 1e3;
          return _this;
        }
        ExponentialBackoffPolicy2.prototype.getDelayTime = function(ctx) {
          var randomTime = Math.pow(2, ctx.retriesAttempted * this.period);
          if (randomTime > this.cap) {
            return this.cap;
          }
          return randomTime;
        };
        return ExponentialBackoffPolicy2;
      })(BackoffPolicy)
    );
    var EqualJitterBackoffPolicy = (
      /** @class */
      (function(_super) {
        __extends(EqualJitterBackoffPolicy2, _super);
        function EqualJitterBackoffPolicy2(option) {
          var _this = _super.call(this, option) || this;
          _this.period = option.period;
          _this.cap = option.cap || 3 * 24 * 60 * 60 * 1e3;
          return _this;
        }
        EqualJitterBackoffPolicy2.prototype.getDelayTime = function(ctx) {
          var ceil = Math.min(this.cap, Math.pow(2, ctx.retriesAttempted * this.period));
          return ceil / 2 + Math.floor(Math.random() * (ceil / 2 + 1));
        };
        return EqualJitterBackoffPolicy2;
      })(BackoffPolicy)
    );
    var FullJitterBackoffPolicy = (
      /** @class */
      (function(_super) {
        __extends(FullJitterBackoffPolicy2, _super);
        function FullJitterBackoffPolicy2(option) {
          var _this = _super.call(this, option) || this;
          _this.period = option.period;
          _this.cap = option.cap || 3 * 24 * 60 * 60 * 1e3;
          return _this;
        }
        FullJitterBackoffPolicy2.prototype.getDelayTime = function(ctx) {
          var ceil = Math.min(this.cap, Math.pow(2, ctx.retriesAttempted * this.period));
          return Math.floor(Math.random() * ceil);
        };
        return FullJitterBackoffPolicy2;
      })(BackoffPolicy)
    );
    var RetryCondition = (
      /** @class */
      /* @__PURE__ */ (function() {
        function RetryCondition2(condition) {
          this.maxAttempts = condition.maxAttempts;
          this.backoff = condition.backoff && BackoffPolicy.newBackoffPolicy(condition.backoff);
          this.exception = condition.exception;
          this.errorCode = condition.errorCode;
          this.maxDelay = condition.maxDelay;
        }
        return RetryCondition2;
      })()
    );
    exports2.RetryCondition = RetryCondition;
    var RetryOptions = (
      /** @class */
      /* @__PURE__ */ (function() {
        function RetryOptions2(options) {
          this.retryable = options.retryable;
          this.retryCondition = (options.retryCondition || []).map(function(condition) {
            return new RetryCondition(condition);
          });
          this.noRetryCondition = (options.noRetryCondition || []).map(function(condition) {
            return new RetryCondition(condition);
          });
        }
        return RetryOptions2;
      })()
    );
    exports2.RetryOptions = RetryOptions;
    var RetryPolicyContext = (
      /** @class */
      /* @__PURE__ */ (function() {
        function RetryPolicyContext2(options) {
          this.key = options.key;
          this.retriesAttempted = options.retriesAttempted || 0;
          this.httpRequest = options.httpRequest || null;
          this.httpResponse = options.httpResponse || null;
          this.exception = options.exception || null;
        }
        return RetryPolicyContext2;
      })()
    );
    exports2.RetryPolicyContext = RetryPolicyContext;
    function shouldRetry(options, ctx) {
      if (ctx.retriesAttempted === 0) {
        return true;
      }
      if (!options || !options.retryable) {
        return false;
      }
      var retriesAttempted = ctx.retriesAttempted;
      var ex = ctx.exception;
      var conditions = options.noRetryCondition;
      for (var i = 0; i < conditions.length; i++) {
        var condition = conditions[i];
        if (condition.exception.includes(ex.name) || condition.errorCode.includes(ex.code)) {
          return false;
        }
      }
      conditions = options.retryCondition;
      for (var i = 0; i < conditions.length; i++) {
        var condition = conditions[i];
        if (!condition.exception.includes(ex.name) && !condition.errorCode.includes(ex.code)) {
          continue;
        }
        if (retriesAttempted >= condition.maxAttempts) {
          return false;
        }
        return true;
      }
      return false;
    }
    exports2.shouldRetry = shouldRetry;
    function getBackoffDelay(options, ctx) {
      var ex = ctx.exception;
      var conditions = options.retryCondition;
      for (var i = 0; i < conditions.length; i++) {
        var condition = conditions[i];
        if (!condition.exception.includes(ex.name) && !condition.errorCode.includes(ex.code)) {
          continue;
        }
        var maxDelay = condition.maxDelay || MAX_DELAY_TIME;
        var retryAfter = ctx.exception.retryAfter;
        if (retryAfter !== void 0) {
          return Math.min(retryAfter, maxDelay);
        }
        if (!condition.backoff) {
          return MIN_DELAY_TIME;
        }
        return Math.min(condition.backoff.getDelayTime(ctx), maxDelay);
      }
      return MIN_DELAY_TIME;
    }
    exports2.getBackoffDelay = getBackoffDelay;
  }
});

// node_modules/@darabonba/typescript/dist/error.js
var require_error = __commonJS({
  "node_modules/@darabonba/typescript/dist/error.js"(exports2) {
    "use strict";
    var __extends = exports2 && exports2.__extends || /* @__PURE__ */ (function() {
      var extendStatics = function(d, b) {
        extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function(d2, b2) {
          d2.__proto__ = b2;
        } || function(d2, b2) {
          for (var p in b2) if (Object.prototype.hasOwnProperty.call(b2, p)) d2[p] = b2[p];
        };
        return extendStatics(d, b);
      };
      return function(d, b) {
        if (typeof b !== "function" && b !== null)
          throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() {
          this.constructor = d;
        }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
      };
    })();
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.newUnretryableError = exports2.newError = exports2.retryError = exports2.ResponseError = exports2.BaseError = void 0;
    var retry_1 = require_retry();
    var BaseError = (
      /** @class */
      (function(_super) {
        __extends(BaseError2, _super);
        function BaseError2(map) {
          var _this = _super.call(this, "".concat(map.code, ": ").concat(map.message)) || this;
          _this.name = "BaseError";
          _this.code = map.code;
          return _this;
        }
        return BaseError2;
      })(Error)
    );
    exports2.BaseError = BaseError;
    var ResponseError = (
      /** @class */
      (function(_super) {
        __extends(ResponseError2, _super);
        function ResponseError2(map) {
          var _this = _super.call(this, map) || this;
          _this.name = "ResponseError";
          _this.data = map.data;
          _this.description = map.description;
          _this.retryAfter = map.retryAfter;
          _this.accessDeniedDetail = map.accessDeniedDetail;
          if (_this.data && _this.data.statusCode) {
            _this.statusCode = Number(_this.data.statusCode);
          }
          return _this;
        }
        return ResponseError2;
      })(BaseError)
    );
    exports2.ResponseError = ResponseError;
    var UnretryableError = (
      /** @class */
      (function(_super) {
        __extends(UnretryableError2, _super);
        function UnretryableError2(message) {
          var _this = _super.call(this, message) || this;
          _this.name = "UnretryableError";
          return _this;
        }
        return UnretryableError2;
      })(Error)
    );
    var RetryError = (
      /** @class */
      (function(_super) {
        __extends(RetryError2, _super);
        function RetryError2(message) {
          var _this = _super.call(this, message) || this;
          _this.name = "RetryError";
          return _this;
        }
        return RetryError2;
      })(Error)
    );
    function retryError(request, response) {
      var e = new RetryError("");
      e.data = {
        request,
        response
      };
      return e;
    }
    exports2.retryError = retryError;
    function newError(data) {
      return new ResponseError(data);
    }
    exports2.newError = newError;
    function newUnretryableError(ctx) {
      if (ctx instanceof retry_1.RetryPolicyContext && ctx.exception) {
        return ctx.exception;
      } else {
        var e = new UnretryableError("");
        e.data = {
          lastRequest: ctx
        };
        return e;
      }
    }
    exports2.newUnretryableError = newUnretryableError;
  }
});

// node_modules/@alicloud/tea-typescript/dist/tea.js
var require_tea = __commonJS({
  "node_modules/@alicloud/tea-typescript/dist/tea.js"(exports2) {
    "use strict";
    var __extends = exports2 && exports2.__extends || /* @__PURE__ */ (function() {
      var extendStatics = function(d, b) {
        extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function(d2, b2) {
          d2.__proto__ = b2;
        } || function(d2, b2) {
          for (var p in b2) if (b2.hasOwnProperty(p)) d2[p] = b2[p];
        };
        return extendStatics(d, b);
      };
      return function(d, b) {
        extendStatics(d, b);
        function __() {
          this.constructor = d;
        }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
      };
    })();
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      Object.defineProperty(o, k2, { enumerable: true, get: function() {
        return m[k];
      } });
    }) : (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      o[k2] = m[k];
    }));
    var __setModuleDefault = exports2 && exports2.__setModuleDefault || (Object.create ? (function(o, v) {
      Object.defineProperty(o, "default", { enumerable: true, value: v });
    }) : function(o, v) {
      o["default"] = v;
    });
    var __importStar = exports2 && exports2.__importStar || function(mod) {
      if (mod && mod.__esModule) return mod;
      var result = {};
      if (mod != null) {
        for (var k in mod) if (k !== "default" && Object.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
      }
      __setModuleDefault(result, mod);
      return result;
    };
    var __awaiter = exports2 && exports2.__awaiter || function(thisArg, _arguments, P, generator) {
      function adopt(value) {
        return value instanceof P ? value : new P(function(resolve2) {
          resolve2(value);
        });
      }
      return new (P || (P = Promise))(function(resolve2, reject) {
        function fulfilled(value) {
          try {
            step(generator.next(value));
          } catch (e) {
            reject(e);
          }
        }
        function rejected(value) {
          try {
            step(generator["throw"](value));
          } catch (e) {
            reject(e);
          }
        }
        function step(result) {
          result.done ? resolve2(result.value) : adopt(result.value).then(fulfilled, rejected);
        }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
      });
    };
    var __generator = exports2 && exports2.__generator || function(thisArg, body) {
      var _ = { label: 0, sent: function() {
        if (t[0] & 1) throw t[1];
        return t[1];
      }, trys: [], ops: [] }, f, y, t, g;
      return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() {
        return this;
      }), g;
      function verb(n) {
        return function(v) {
          return step([n, v]);
        };
      }
      function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
          if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
          if (y = 0, t) op = [op[0] & 2, t.value];
          switch (op[0]) {
            case 0:
            case 1:
              t = op;
              break;
            case 4:
              _.label++;
              return { value: op[1], done: false };
            case 5:
              _.label++;
              y = op[1];
              op = [0];
              continue;
            case 7:
              op = _.ops.pop();
              _.trys.pop();
              continue;
            default:
              if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) {
                _ = 0;
                continue;
              }
              if (op[0] === 3 && (!t || op[1] > t[0] && op[1] < t[3])) {
                _.label = op[1];
                break;
              }
              if (op[0] === 6 && _.label < t[1]) {
                _.label = t[1];
                t = op;
                break;
              }
              if (t && _.label < t[2]) {
                _.label = t[2];
                _.ops.push(op);
                break;
              }
              if (t[2]) _.ops.pop();
              _.trys.pop();
              continue;
          }
          op = body.call(thisArg, _);
        } catch (e) {
          op = [6, e];
          y = 0;
        } finally {
          f = t = 0;
        }
        if (op[0] & 5) throw op[1];
        return { value: op[0] ? op[1] : void 0, done: true };
      }
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.isRetryable = exports2.retryError = exports2.newUnretryableError = exports2.getBackoffTime = exports2.allowRetry = exports2.sleep = exports2.cast = exports2.Model = exports2.toMap = exports2.newError = exports2.doAction = exports2.Response = exports2.Request = exports2.BytesReadable = void 0;
    var querystring = __importStar(require("querystring"));
    var http_1 = require("http");
    var https_1 = require("https");
    var stream_1 = require("stream");
    var httpx = __importStar(require_lib());
    var url_1 = require("url");
    var BytesReadable = (
      /** @class */
      (function(_super) {
        __extends(BytesReadable2, _super);
        function BytesReadable2(value) {
          var _this = _super.call(this) || this;
          if (typeof value === "string") {
            _this.value = Buffer.from(value);
          } else if (Buffer.isBuffer(value)) {
            _this.value = value;
          }
          return _this;
        }
        BytesReadable2.prototype._read = function() {
          this.push(this.value);
          this.push(null);
        };
        return BytesReadable2;
      })(stream_1.Readable)
    );
    exports2.BytesReadable = BytesReadable;
    var Request = (
      /** @class */
      /* @__PURE__ */ (function() {
        function Request2() {
          this.headers = {};
          this.query = {};
        }
        return Request2;
      })()
    );
    exports2.Request = Request;
    var Response = (
      /** @class */
      (function() {
        function Response2(httpResponse) {
          this.statusCode = httpResponse.statusCode;
          this.statusMessage = httpResponse.statusMessage;
          this.headers = this.convertHeaders(httpResponse.headers);
          this.body = httpResponse;
        }
        Response2.prototype.convertHeaders = function(headers) {
          var results = {};
          var keys = Object.keys(headers);
          for (var index = 0; index < keys.length; index++) {
            var key = keys[index];
            results[key] = headers[key];
          }
          return results;
        };
        Response2.prototype.readBytes = function() {
          return __awaiter(this, void 0, void 0, function() {
            var buff;
            return __generator(this, function(_a) {
              switch (_a.label) {
                case 0:
                  return [4, httpx.read(this.body, "")];
                case 1:
                  buff = _a.sent();
                  return [2, buff];
              }
            });
          });
        };
        return Response2;
      })()
    );
    exports2.Response = Response;
    function buildURL(request) {
      var url = request.protocol + "://" + request.headers["host"];
      if (request.port) {
        url += ":" + request.port;
      }
      url += "" + request.pathname;
      var urlInfo = url_1.parse(url);
      if (request.query && Object.keys(request.query).length > 0) {
        if (urlInfo.query) {
          url += "&" + querystring.stringify(request.query);
        } else {
          url += "?" + querystring.stringify(request.query);
        }
      }
      return url;
    }
    function isModelClass(t) {
      if (!t) {
        return false;
      }
      return typeof t.types === "function" && typeof t.names === "function";
    }
    function doAction(request, runtime) {
      if (runtime === void 0) {
        runtime = null;
      }
      return __awaiter(this, void 0, void 0, function() {
        var url, method, options, agentOptions, response;
        return __generator(this, function(_a) {
          switch (_a.label) {
            case 0:
              url = buildURL(request);
              method = (request.method || "GET").toUpperCase();
              options = {
                method,
                headers: request.headers
              };
              if (method !== "GET" && method !== "HEAD") {
                options.data = request.body;
              }
              if (runtime) {
                if (typeof runtime.timeout !== "undefined") {
                  options.timeout = Number(runtime.timeout);
                }
                if (typeof runtime.readTimeout !== "undefined") {
                  options.readTimeout = Number(runtime.readTimeout);
                }
                if (typeof runtime.connectTimeout !== "undefined") {
                  options.connectTimeout = Number(runtime.connectTimeout);
                }
                if (typeof runtime.ignoreSSL !== "undefined") {
                  options.rejectUnauthorized = !runtime.ignoreSSL;
                }
                if (typeof runtime.key !== "undefined") {
                  options.key = String(runtime.key);
                }
                if (typeof runtime.cert !== "undefined") {
                  options.cert = String(runtime.cert);
                }
                if (typeof runtime.ca !== "undefined") {
                  options.ca = String(runtime.ca);
                }
                agentOptions = {
                  keepAlive: true
                };
                if (typeof runtime.keepAlive !== "undefined") {
                  agentOptions.keepAlive = runtime.keepAlive;
                  if (request.protocol && request.protocol.toLowerCase() === "https") {
                    options.agent = new https_1.Agent(agentOptions);
                  } else {
                    options.agent = new http_1.Agent(agentOptions);
                  }
                }
              }
              return [4, httpx.request(url, options)];
            case 1:
              response = _a.sent();
              return [2, new Response(response)];
          }
        });
      });
    }
    exports2.doAction = doAction;
    var ResponseError = (
      /** @class */
      (function(_super) {
        __extends(ResponseError2, _super);
        function ResponseError2(map) {
          var _this = _super.call(this, map.code + ": " + map.message) || this;
          _this.code = map.code;
          _this.data = map.data;
          _this.description = map.description;
          _this.accessDeniedDetail = map.accessDeniedDetail;
          if (_this.data && _this.data.statusCode) {
            _this.statusCode = Number(_this.data.statusCode);
          }
          return _this;
        }
        return ResponseError2;
      })(Error)
    );
    function newError(data) {
      return new ResponseError(data);
    }
    exports2.newError = newError;
    function getValue(type, value) {
      if (typeof type === "string") {
        return value;
      }
      if (type.type === "array") {
        if (!Array.isArray(value)) {
          throw new Error("expect: array, actual: " + typeof value);
        }
        return value.map(function(item) {
          return getValue(type.itemType, item);
        });
      }
      if (typeof type === "function") {
        if (isModelClass(type)) {
          return new type(value);
        }
        return value;
      }
      return value;
    }
    function toMap(value) {
      if (value === void 0) {
        value = void 0;
      }
      if (typeof value === "undefined" || value == null) {
        return null;
      }
      if (value instanceof Model) {
        return value.toMap();
      }
      if (typeof value.toMap === "function") {
        return value.toMap();
      }
      if (Array.isArray(value)) {
        return value.map(function(item) {
          return toMap(item);
        });
      }
      return value;
    }
    exports2.toMap = toMap;
    var Model = (
      /** @class */
      (function() {
        function Model2(map) {
          var _this = this;
          if (map == null) {
            return;
          }
          var clz = this.constructor;
          var names = clz.names();
          var types = clz.types();
          Object.keys(names).forEach((function(name) {
            var value = map[name];
            if (value === void 0 || value === null) {
              return;
            }
            var type = types[name];
            _this[name] = getValue(type, value);
          }));
        }
        Model2.prototype.toMap = function() {
          var _this = this;
          var map = {};
          var clz = this.constructor;
          var names = clz.names();
          Object.keys(names).forEach((function(name) {
            var originName = names[name];
            var value = _this[name];
            if (typeof value === "undefined" || value == null) {
              return;
            }
            map[originName] = toMap(value);
          }));
          return map;
        };
        return Model2;
      })()
    );
    exports2.Model = Model;
    function cast(obj, t) {
      if (!obj) {
        throw new Error("can not cast to Map");
      }
      if (typeof obj !== "object") {
        throw new Error("can not cast to Map");
      }
      var map = obj;
      var clz = t.constructor;
      var names = clz.names();
      var types = clz.types();
      Object.keys(names).forEach(function(key) {
        var originName = names[key];
        var value = map[originName];
        var type = types[key];
        if (typeof value === "undefined" || value == null) {
          return;
        }
        if (typeof type === "string") {
          if (type === "Readable" || type === "map" || type === "Buffer" || type === "any" || typeof value === type) {
            t[key] = value;
            return;
          }
          if (type === "string" && (typeof value === "number" || typeof value === "boolean")) {
            t[key] = value.toString();
            return;
          }
          if (type === "boolean") {
            if (value === 1 || value === 0) {
              t[key] = !!value;
              return;
            }
            if (value === "true" || value === "false") {
              t[key] = value === "true";
              return;
            }
          }
          if (type === "number" && typeof value === "string") {
            if (value.match(/^\d*$/)) {
              t[key] = parseInt(value);
              return;
            }
            if (value.match(/^[\.\d]*$/)) {
              t[key] = parseFloat(value);
              return;
            }
          }
          throw new Error("type of " + key + " is mismatch, expect " + type + ", but " + typeof value);
        } else if (type.type === "map") {
          if (!(value instanceof Object)) {
            throw new Error("type of " + key + " is mismatch, expect object, but " + typeof value);
          }
          t[key] = value;
        } else if (type.type === "array") {
          if (!Array.isArray(value)) {
            throw new Error("type of " + key + " is mismatch, expect array, but " + typeof value);
          }
          if (typeof type.itemType === "function") {
            t[key] = value.map(function(d) {
              if (isModelClass(type.itemType)) {
                return cast(d, new type.itemType({}));
              }
              return d;
            });
          } else {
            t[key] = value;
          }
        } else if (typeof type === "function") {
          if (!(value instanceof Object)) {
            throw new Error("type of " + key + " is mismatch, expect object, but " + typeof value);
          }
          if (isModelClass(type)) {
            t[key] = cast(value, new type({}));
            return;
          }
          t[key] = value;
        } else {
        }
      });
      return t;
    }
    exports2.cast = cast;
    function sleep(ms) {
      return new Promise(function(resolve2) {
        setTimeout(resolve2, ms);
      });
    }
    exports2.sleep = sleep;
    function allowRetry(retry, retryTimes, startTime) {
      if (retryTimes === 0) {
        return true;
      }
      if (retry.retryable !== true) {
        return false;
      }
      if (retry.policy === "never") {
        return false;
      }
      if (retry.policy === "always") {
        return true;
      }
      if (retry.policy === "simple") {
        return retryTimes < retry["maxAttempts"];
      }
      if (retry.policy === "timeout") {
        return Date.now() - startTime < retry.timeout;
      }
      if (retry.maxAttempts && typeof retry.maxAttempts === "number") {
        return retry.maxAttempts >= retryTimes;
      }
      return false;
    }
    exports2.allowRetry = allowRetry;
    function getBackoffTime(backoff, retryTimes) {
      if (retryTimes === 0) {
        return 0;
      }
      if (backoff.policy === "no") {
        return 0;
      }
      if (backoff.policy === "fixed") {
        return backoff.period;
      }
      if (backoff.policy === "random") {
        var min = backoff["minPeriod"];
        var max = backoff["maxPeriod"];
        return min + (max - min) * Math.random();
      }
      if (backoff.policy === "exponential") {
        var init = backoff.initial;
        var multiplier = backoff.multiplier;
        var time = init * Math.pow(1 + multiplier, retryTimes - 1);
        var max = backoff.max;
        return Math.min(time, max);
      }
      if (backoff.policy === "exponential_random") {
        var init = backoff.initial;
        var multiplier = backoff.multiplier;
        var time = init * Math.pow(1 + multiplier, retryTimes - 1);
        var max = backoff.max;
        return Math.min(time * (0.5 + Math.random()), max);
      }
      return 0;
    }
    exports2.getBackoffTime = getBackoffTime;
    var UnretryableError = (
      /** @class */
      (function(_super) {
        __extends(UnretryableError2, _super);
        function UnretryableError2(message) {
          var _this = _super.call(this, message) || this;
          _this.name = "UnretryableError";
          return _this;
        }
        return UnretryableError2;
      })(Error)
    );
    function newUnretryableError(request) {
      var e = new UnretryableError("");
      e.data = {
        lastRequest: request
      };
      return e;
    }
    exports2.newUnretryableError = newUnretryableError;
    var RetryError = (
      /** @class */
      (function(_super) {
        __extends(RetryError2, _super);
        function RetryError2(message) {
          var _this = _super.call(this, message) || this;
          _this.name = "RetryError";
          return _this;
        }
        return RetryError2;
      })(Error)
    );
    function retryError(request, response) {
      var e = new RetryError("");
      e.data = {
        request,
        response
      };
      return e;
    }
    exports2.retryError = retryError;
    function isRetryable(err) {
      if (typeof err === "undefined" || err === null) {
        return false;
      }
      return err.name === "RetryError";
    }
    exports2.isRetryable = isRetryable;
  }
});

// node_modules/@darabonba/typescript/dist/core.js
var require_core = __commonJS({
  "node_modules/@darabonba/typescript/dist/core.js"(exports2) {
    "use strict";
    var __extends = exports2 && exports2.__extends || /* @__PURE__ */ (function() {
      var extendStatics = function(d, b) {
        extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function(d2, b2) {
          d2.__proto__ = b2;
        } || function(d2, b2) {
          for (var p in b2) if (Object.prototype.hasOwnProperty.call(b2, p)) d2[p] = b2[p];
        };
        return extendStatics(d, b);
      };
      return function(d, b) {
        if (typeof b !== "function" && b !== null)
          throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() {
          this.constructor = d;
        }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
      };
    })();
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    }) : (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      o[k2] = m[k];
    }));
    var __setModuleDefault = exports2 && exports2.__setModuleDefault || (Object.create ? (function(o, v) {
      Object.defineProperty(o, "default", { enumerable: true, value: v });
    }) : function(o, v) {
      o["default"] = v;
    });
    var __importStar = exports2 && exports2.__importStar || function(mod) {
      if (mod && mod.__esModule) return mod;
      var result = {};
      if (mod != null) {
        for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
      }
      __setModuleDefault(result, mod);
      return result;
    };
    var __awaiter = exports2 && exports2.__awaiter || function(thisArg, _arguments, P, generator) {
      function adopt(value) {
        return value instanceof P ? value : new P(function(resolve2) {
          resolve2(value);
        });
      }
      return new (P || (P = Promise))(function(resolve2, reject) {
        function fulfilled(value) {
          try {
            step(generator.next(value));
          } catch (e) {
            reject(e);
          }
        }
        function rejected(value) {
          try {
            step(generator["throw"](value));
          } catch (e) {
            reject(e);
          }
        }
        function step(result) {
          result.done ? resolve2(result.value) : adopt(result.value).then(fulfilled, rejected);
        }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
      });
    };
    var __generator = exports2 && exports2.__generator || function(thisArg, body) {
      var _ = { label: 0, sent: function() {
        if (t[0] & 1) throw t[1];
        return t[1];
      }, trys: [], ops: [] }, f, y, t, g;
      return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() {
        return this;
      }), g;
      function verb(n) {
        return function(v) {
          return step([n, v]);
        };
      }
      function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
          if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
          if (y = 0, t) op = [op[0] & 2, t.value];
          switch (op[0]) {
            case 0:
            case 1:
              t = op;
              break;
            case 4:
              _.label++;
              return { value: op[1], done: false };
            case 5:
              _.label++;
              y = op[1];
              op = [0];
              continue;
            case 7:
              op = _.ops.pop();
              _.trys.pop();
              continue;
            default:
              if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) {
                _ = 0;
                continue;
              }
              if (op[0] === 3 && (!t || op[1] > t[0] && op[1] < t[3])) {
                _.label = op[1];
                break;
              }
              if (op[0] === 6 && _.label < t[1]) {
                _.label = t[1];
                t = op;
                break;
              }
              if (t && _.label < t[2]) {
                _.label = t[2];
                _.ops.push(op);
                break;
              }
              if (t[2]) _.ops.pop();
              _.trys.pop();
              continue;
          }
          op = body.call(thisArg, _);
        } catch (e) {
          op = [6, e];
          y = 0;
        } finally {
          f = t = 0;
        }
        if (op[0] & 5) throw op[1];
        return { value: op[0] ? op[1] : void 0, done: true };
      }
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.isRetryable = exports2.getBackoffTime = exports2.allowRetry = exports2.cast = exports2.RuntimeOptions = exports2.ExtendsParameters = exports2.FileField = exports2.Model = exports2.toMap = exports2.doAction = exports2.Response = exports2.Request = exports2.BytesReadable = void 0;
    var querystring = __importStar(require("querystring"));
    var http_1 = require("http");
    var https_1 = require("https");
    var stream_1 = require("stream");
    var httpx = __importStar(require_lib());
    var url_1 = require("url");
    var retry_1 = require_retry();
    var error_1 = require_error();
    var $tea = __importStar(require_tea());
    var BytesReadable = (
      /** @class */
      (function(_super) {
        __extends(BytesReadable2, _super);
        function BytesReadable2(value) {
          var _this = _super.call(this) || this;
          if (typeof value === "string") {
            _this.value = Buffer.from(value);
          } else if (Buffer.isBuffer(value)) {
            _this.value = value;
          }
          return _this;
        }
        BytesReadable2.prototype._read = function() {
          this.push(this.value);
          this.push(null);
        };
        return BytesReadable2;
      })(stream_1.Readable)
    );
    exports2.BytesReadable = BytesReadable;
    var Request = (
      /** @class */
      /* @__PURE__ */ (function() {
        function Request2() {
          this.headers = {};
          this.query = {};
        }
        return Request2;
      })()
    );
    exports2.Request = Request;
    var Response = (
      /** @class */
      (function() {
        function Response2(httpResponse) {
          this.statusCode = httpResponse.statusCode;
          this.statusMessage = httpResponse.statusMessage;
          this.headers = this.convertHeaders(httpResponse.headers);
          this.body = httpResponse;
        }
        Response2.prototype.convertHeaders = function(headers) {
          var results = {};
          var keys = Object.keys(headers);
          for (var index = 0; index < keys.length; index++) {
            var key = keys[index];
            results[key] = headers[key];
          }
          return results;
        };
        Response2.prototype.readBytes = function() {
          return __awaiter(this, void 0, void 0, function() {
            var buff;
            return __generator(this, function(_a) {
              switch (_a.label) {
                case 0:
                  return [4, httpx.read(this.body, "")];
                case 1:
                  buff = _a.sent();
                  return [2, buff];
              }
            });
          });
        };
        return Response2;
      })()
    );
    exports2.Response = Response;
    function buildURL(request) {
      var url = "".concat(request.protocol, "://").concat(request.headers["host"]);
      if (request.port) {
        url += ":".concat(request.port);
      }
      url += "".concat(request.pathname);
      var urlInfo = (0, url_1.parse)(url);
      if (request.query && Object.keys(request.query).length > 0) {
        if (urlInfo.query) {
          url += "&".concat(querystring.stringify(request.query));
        } else {
          url += "?".concat(querystring.stringify(request.query));
        }
      }
      return url;
    }
    function isModelClass(t) {
      if (!t) {
        return false;
      }
      return typeof t.types === "function" && typeof t.names === "function";
    }
    function doAction(request, runtime) {
      if (runtime === void 0) {
        runtime = null;
      }
      return __awaiter(this, void 0, void 0, function() {
        var url, method, options, agentOptions, response;
        return __generator(this, function(_a) {
          switch (_a.label) {
            case 0:
              url = buildURL(request);
              method = (request.method || "GET").toUpperCase();
              options = {
                method,
                headers: request.headers
              };
              if (method !== "GET" && method !== "HEAD") {
                options.data = request.body;
              }
              if (runtime) {
                if (typeof runtime.timeout !== "undefined") {
                  options.timeout = Number(runtime.timeout);
                }
                if (typeof runtime.readTimeout !== "undefined") {
                  options.readTimeout = Number(runtime.readTimeout);
                }
                if (typeof runtime.connectTimeout !== "undefined") {
                  options.connectTimeout = Number(runtime.connectTimeout);
                }
                if (typeof runtime.ignoreSSL !== "undefined") {
                  options.rejectUnauthorized = !runtime.ignoreSSL;
                }
                if (typeof runtime.key !== "undefined") {
                  options.key = String(runtime.key);
                }
                if (typeof runtime.cert !== "undefined") {
                  options.cert = String(runtime.cert);
                }
                if (typeof runtime.ca !== "undefined") {
                  options.ca = String(runtime.ca);
                }
                agentOptions = {
                  keepAlive: true
                };
                if (typeof runtime.keepAlive !== "undefined") {
                  agentOptions.keepAlive = runtime.keepAlive;
                  if (request.protocol && request.protocol.toLowerCase() === "https") {
                    options.agent = new https_1.Agent(agentOptions);
                  } else {
                    options.agent = new http_1.Agent(agentOptions);
                  }
                }
              }
              return [4, httpx.request(url, options)];
            case 1:
              response = _a.sent();
              return [2, new Response(response)];
          }
        });
      });
    }
    exports2.doAction = doAction;
    function getValue(type, value) {
      if (typeof type === "string") {
        return value;
      }
      if (type.type === "array") {
        if (!Array.isArray(value)) {
          throw new Error("expect: array, actual: ".concat(typeof value));
        }
        return value.map(function(item) {
          return getValue(type.itemType, item);
        });
      }
      if (typeof type === "function") {
        if (isModelClass(type)) {
          return new type(value);
        }
        return value;
      }
      return value;
    }
    function toMap(value, withoutStream) {
      if (value === void 0) {
        value = void 0;
      }
      if (withoutStream === void 0) {
        withoutStream = false;
      }
      if (typeof value === "undefined" || value == null) {
        return null;
      }
      if (value instanceof Model) {
        return value.toMap(withoutStream);
      }
      if (typeof value.toMap === "function") {
        return value.toMap(withoutStream);
      }
      if (Array.isArray(value)) {
        return value.map(function(item) {
          return toMap(item, withoutStream);
        });
      }
      if (withoutStream && (value instanceof stream_1.Readable || value instanceof stream_1.Writable)) {
        return null;
      }
      return value;
    }
    exports2.toMap = toMap;
    var Model = (
      /** @class */
      (function(_super) {
        __extends(Model2, _super);
        function Model2(map) {
          var _this = _super.call(this) || this;
          if (map == null) {
            return _this;
          }
          var clz = _this.constructor;
          var names = clz.names();
          var types = clz.types();
          Object.keys(names).forEach((function(name) {
            var value = map[name];
            if (value === void 0 || value === null) {
              return;
            }
            var type = types[name];
            _this[name] = getValue(type, value);
          }));
          return _this;
        }
        Model2.prototype.validate = function() {
        };
        Model2.prototype.copyWithoutStream = function() {
          var map = this.toMap(true);
          var clz = this.constructor;
          return new clz(map);
        };
        Model2.prototype.toMap = function(withoutStream) {
          var _this = this;
          if (withoutStream === void 0) {
            withoutStream = false;
          }
          var map = {};
          var clz = this.constructor;
          var names = clz.names();
          Object.keys(names).forEach((function(name) {
            var originName = names[name];
            var value = _this[name];
            if (typeof value === "undefined" || value == null) {
              return;
            }
            map[originName] = toMap(value, withoutStream);
          }));
          return map;
        };
        Model2.validateRequired = function(key, value) {
          if (value === null || typeof value === "undefined") {
            throw new error_1.BaseError({
              code: "SDK.ValidateError",
              message: "".concat(key, " is required.")
            });
          }
        };
        Model2.validateMaxLength = function(key, value, max) {
          if (value === null || typeof value === "undefined") {
            return;
          }
          if (value.length > max) {
            throw new error_1.BaseError({
              code: "SDK.ValidateError",
              message: "".concat(key, " is exceed max-length: ").concat(max, ".")
            });
          }
        };
        Model2.validateMinLength = function(key, value, min) {
          if (value === null || typeof value === "undefined") {
            return;
          }
          if (value.length < min) {
            throw new error_1.BaseError({
              code: "SDK.ValidateError",
              message: "".concat(key, " is exceed min-length: ").concat(min, ".")
            });
          }
        };
        Model2.validateMaximum = function(key, value, max) {
          if (value === null || typeof value === "undefined") {
            return;
          }
          if (value > max) {
            throw new error_1.BaseError({
              code: "SDK.ValidateError",
              message: "".concat(key, " cannot be greater than ").concat(max, ".")
            });
          }
        };
        Model2.validateMinimum = function(key, value, min) {
          if (value === null || typeof value === "undefined") {
            return;
          }
          if (value < min) {
            throw new error_1.BaseError({
              code: "SDK.ValidateError",
              message: "".concat(key, " cannot be less than ").concat(min, ".")
            });
          }
        };
        Model2.validatePattern = function(key, value, val) {
          if (value === null || typeof value === "undefined") {
            return;
          }
          var reg = new RegExp(val);
          if (!reg.test(value)) {
            throw new error_1.BaseError({
              code: "SDK.ValidateError",
              message: "".concat(key, " is not match ").concat(val, ".")
            });
          }
        };
        Model2.validateArray = function(data) {
          if (data === null || typeof data === "undefined") {
            return;
          }
          data.map(function(ele) {
            if (!ele) {
              return;
            }
            if (ele instanceof Model2 || typeof ele.validate === "function") {
              ele.validate();
            } else if (Array.isArray(ele)) {
              Model2.validateArray(ele);
            } else if (ele instanceof Object) {
              Model2.validateMap(ele);
            }
          });
        };
        Model2.validateMap = function(data) {
          if (data === null || typeof data === "undefined") {
            return;
          }
          Object.keys(data).map(function(key) {
            var ele = data[key];
            if (!ele) {
              return;
            }
            if (ele instanceof Model2 || typeof ele.validate === "function") {
              ele.validate();
            } else if (Array.isArray(ele)) {
              Model2.validateArray(ele);
            } else if (ele instanceof Object) {
              Model2.validateMap(ele);
            }
          });
        };
        return Model2;
      })($tea.Model)
    );
    exports2.Model = Model;
    var FileField = (
      /** @class */
      (function(_super) {
        __extends(FileField2, _super);
        function FileField2(map) {
          return _super.call(this, map) || this;
        }
        FileField2.names = function() {
          return {
            filename: "filename",
            contentType: "contentType",
            content: "content"
          };
        };
        FileField2.types = function() {
          return {
            filename: "string",
            contentType: "string",
            content: "Readable"
          };
        };
        return FileField2;
      })(Model)
    );
    exports2.FileField = FileField;
    var ExtendsParameters = (
      /** @class */
      (function(_super) {
        __extends(ExtendsParameters2, _super);
        function ExtendsParameters2(map) {
          return _super.call(this, map) || this;
        }
        ExtendsParameters2.names = function() {
          return {
            headers: "headers",
            queries: "queries"
          };
        };
        ExtendsParameters2.types = function() {
          return {
            headers: { "type": "map", "keyType": "string", "valueType": "string" },
            queries: { "type": "map", "keyType": "string", "valueType": "string" }
          };
        };
        return ExtendsParameters2;
      })($tea.Model)
    );
    exports2.ExtendsParameters = ExtendsParameters;
    var RuntimeOptions2 = (
      /** @class */
      (function(_super) {
        __extends(RuntimeOptions3, _super);
        function RuntimeOptions3(map) {
          return _super.call(this, map) || this;
        }
        RuntimeOptions3.names = function() {
          return {
            autoretry: "autoretry",
            ignoreSSL: "ignoreSSL",
            key: "key",
            cert: "cert",
            ca: "ca",
            maxAttempts: "max_attempts",
            backoffPolicy: "backoff_policy",
            backoffPeriod: "backoff_period",
            readTimeout: "readTimeout",
            connectTimeout: "connectTimeout",
            httpProxy: "httpProxy",
            httpsProxy: "httpsProxy",
            noProxy: "noProxy",
            maxIdleConns: "maxIdleConns",
            keepAlive: "keepAlive",
            extendsParameters: "extendsParameters"
          };
        };
        RuntimeOptions3.types = function() {
          return {
            retryOptions: retry_1.RetryOptions,
            autoretry: "boolean",
            ignoreSSL: "boolean",
            key: "string",
            cert: "string",
            ca: "string",
            maxAttempts: "number",
            backoffPolicy: "string",
            backoffPeriod: "number",
            readTimeout: "number",
            connectTimeout: "number",
            httpProxy: "string",
            httpsProxy: "string",
            noProxy: "string",
            maxIdleConns: "number",
            keepAlive: "boolean",
            extendsParameters: ExtendsParameters
          };
        };
        return RuntimeOptions3;
      })($tea.Model)
    );
    exports2.RuntimeOptions = RuntimeOptions2;
    function cast(obj, t) {
      if (!obj) {
        throw new Error("can not cast to Map");
      }
      if (typeof obj !== "object") {
        throw new Error("can not cast to Map");
      }
      var map = obj;
      var clz = t.constructor;
      var names = clz.names();
      var types = clz.types();
      Object.keys(names).forEach(function(key) {
        var originName = names[key];
        var value = map[originName];
        var type = types[key];
        if (typeof value === "undefined" || value == null) {
          return;
        }
        if (typeof type === "string") {
          if (type === "Readable" || type === "Writable" || type === "map" || type === "Buffer" || type === "any" || typeof value === type) {
            t[key] = value;
            return;
          }
          if (type === "string" && (typeof value === "number" || typeof value === "boolean")) {
            t[key] = value.toString();
            return;
          }
          if (type === "boolean") {
            if (value === 1 || value === 0) {
              t[key] = !!value;
              return;
            }
            if (value === "true" || value === "false") {
              t[key] = value === "true";
              return;
            }
          }
          if (type === "number" && typeof value === "string") {
            if (value.match(/^\d*$/)) {
              t[key] = parseInt(value);
              return;
            }
            if (value.match(/^[\.\d]*$/)) {
              t[key] = parseFloat(value);
              return;
            }
          }
          throw new Error("type of ".concat(key, " is mismatch, expect ").concat(type, ", but ").concat(typeof value));
        } else if (type.type === "map") {
          if (!(value instanceof Object)) {
            throw new Error("type of ".concat(key, " is mismatch, expect object, but ").concat(typeof value));
          }
          t[key] = value;
        } else if (type.type === "array") {
          if (!Array.isArray(value)) {
            throw new Error("type of ".concat(key, " is mismatch, expect array, but ").concat(typeof value));
          }
          if (typeof type.itemType === "function") {
            t[key] = value.map(function(d) {
              if (isModelClass(type.itemType)) {
                return cast(d, new type.itemType({}));
              }
              return d;
            });
          } else {
            t[key] = value;
          }
        } else if (typeof type === "function") {
          if (!(value instanceof Object)) {
            throw new Error("type of ".concat(key, " is mismatch, expect object, but ").concat(typeof value));
          }
          if (isModelClass(type)) {
            t[key] = cast(value, new type({}));
            return;
          }
          t[key] = value;
        } else {
        }
      });
      return t;
    }
    exports2.cast = cast;
    function allowRetry(retry, retryTimes, startTime) {
      if (retryTimes === 0) {
        return true;
      }
      if (retry.retryable !== true) {
        return false;
      }
      if (retry.policy === "never") {
        return false;
      }
      if (retry.policy === "always") {
        return true;
      }
      if (retry.policy === "simple") {
        return retryTimes < retry["maxAttempts"];
      }
      if (retry.policy === "timeout") {
        return Date.now() - startTime < retry.timeout;
      }
      if (retry.maxAttempts && typeof retry.maxAttempts === "number") {
        return retry.maxAttempts >= retryTimes;
      }
      return false;
    }
    exports2.allowRetry = allowRetry;
    function getBackoffTime(backoff, retryTimes) {
      if (retryTimes === 0) {
        return 0;
      }
      if (backoff.policy === "no") {
        return 0;
      }
      if (backoff.policy === "fixed") {
        return backoff.period;
      }
      if (backoff.policy === "random") {
        var min = backoff["minPeriod"];
        var max = backoff["maxPeriod"];
        return min + (max - min) * Math.random();
      }
      if (backoff.policy === "exponential") {
        var init = backoff.initial;
        var multiplier = backoff.multiplier;
        var time = init * Math.pow(1 + multiplier, retryTimes - 1);
        var max = backoff.max;
        return Math.min(time, max);
      }
      if (backoff.policy === "exponential_random") {
        var init = backoff.initial;
        var multiplier = backoff.multiplier;
        var time = init * Math.pow(1 + multiplier, retryTimes - 1);
        var max = backoff.max;
        return Math.min(time * (0.5 + Math.random()), max);
      }
      return 0;
    }
    exports2.getBackoffTime = getBackoffTime;
    function isRetryable(err) {
      if (typeof err === "undefined" || err === null) {
        return false;
      }
      return err.name === "RetryError";
    }
    exports2.isRetryable = isRetryable;
  }
});

// node_modules/moment/moment.js
var require_moment = __commonJS({
  "node_modules/moment/moment.js"(exports2, module2) {
    (function(global2, factory) {
      typeof exports2 === "object" && typeof module2 !== "undefined" ? module2.exports = factory() : typeof define === "function" && define.amd ? define(factory) : global2.moment = factory();
    })(exports2, (function() {
      "use strict";
      var hookCallback;
      function hooks() {
        return hookCallback.apply(null, arguments);
      }
      function setHookCallback(callback) {
        hookCallback = callback;
      }
      function isArray(input) {
        return input instanceof Array || Object.prototype.toString.call(input) === "[object Array]";
      }
      function isObject(input) {
        return input != null && Object.prototype.toString.call(input) === "[object Object]";
      }
      function hasOwnProp(a, b) {
        return Object.prototype.hasOwnProperty.call(a, b);
      }
      function isObjectEmpty(obj) {
        if (Object.getOwnPropertyNames) {
          return Object.getOwnPropertyNames(obj).length === 0;
        } else {
          var k;
          for (k in obj) {
            if (hasOwnProp(obj, k)) {
              return false;
            }
          }
          return true;
        }
      }
      function isUndefined(input) {
        return input === void 0;
      }
      function isNumber(input) {
        return typeof input === "number" || Object.prototype.toString.call(input) === "[object Number]";
      }
      function isDate(input) {
        return input instanceof Date || Object.prototype.toString.call(input) === "[object Date]";
      }
      function map(arr, fn) {
        var res = [], i, arrLen = arr.length;
        for (i = 0; i < arrLen; ++i) {
          res.push(fn(arr[i], i));
        }
        return res;
      }
      function extend(a, b) {
        for (var i in b) {
          if (hasOwnProp(b, i)) {
            a[i] = b[i];
          }
        }
        if (hasOwnProp(b, "toString")) {
          a.toString = b.toString;
        }
        if (hasOwnProp(b, "valueOf")) {
          a.valueOf = b.valueOf;
        }
        return a;
      }
      function createUTC(input, format2, locale2, strict) {
        return createLocalOrUTC(input, format2, locale2, strict, true).utc();
      }
      function defaultParsingFlags() {
        return {
          empty: false,
          unusedTokens: [],
          unusedInput: [],
          overflow: -2,
          charsLeftOver: 0,
          nullInput: false,
          invalidEra: null,
          invalidMonth: null,
          invalidFormat: false,
          userInvalidated: false,
          iso: false,
          parsedDateParts: [],
          era: null,
          meridiem: null,
          rfc2822: false,
          weekdayMismatch: false
        };
      }
      function getParsingFlags(m) {
        if (m._pf == null) {
          m._pf = defaultParsingFlags();
        }
        return m._pf;
      }
      var some;
      if (Array.prototype.some) {
        some = Array.prototype.some;
      } else {
        some = function(fun) {
          var t = Object(this), len = t.length >>> 0, i;
          for (i = 0; i < len; i++) {
            if (i in t && fun.call(this, t[i], i, t)) {
              return true;
            }
          }
          return false;
        };
      }
      function isValid(m) {
        var flags = null, parsedParts = false, isNowValid = m._d && !isNaN(m._d.getTime());
        if (isNowValid) {
          flags = getParsingFlags(m);
          parsedParts = some.call(flags.parsedDateParts, function(i) {
            return i != null;
          });
          isNowValid = flags.overflow < 0 && !flags.empty && !flags.invalidEra && !flags.invalidMonth && !flags.invalidWeekday && !flags.weekdayMismatch && !flags.nullInput && !flags.invalidFormat && !flags.userInvalidated && (!flags.meridiem || flags.meridiem && parsedParts);
          if (m._strict) {
            isNowValid = isNowValid && flags.charsLeftOver === 0 && flags.unusedTokens.length === 0 && flags.bigHour === void 0;
          }
        }
        if (Object.isFrozen == null || !Object.isFrozen(m)) {
          m._isValid = isNowValid;
        } else {
          return isNowValid;
        }
        return m._isValid;
      }
      function createInvalid(flags) {
        var m = createUTC(NaN);
        if (flags != null) {
          extend(getParsingFlags(m), flags);
        } else {
          getParsingFlags(m).userInvalidated = true;
        }
        return m;
      }
      var momentProperties = hooks.momentProperties = [], updateInProgress = false;
      function copyConfig(to2, from2) {
        var i, prop, val, momentPropertiesLen = momentProperties.length;
        if (!isUndefined(from2._isAMomentObject)) {
          to2._isAMomentObject = from2._isAMomentObject;
        }
        if (!isUndefined(from2._i)) {
          to2._i = from2._i;
        }
        if (!isUndefined(from2._f)) {
          to2._f = from2._f;
        }
        if (!isUndefined(from2._l)) {
          to2._l = from2._l;
        }
        if (!isUndefined(from2._strict)) {
          to2._strict = from2._strict;
        }
        if (!isUndefined(from2._tzm)) {
          to2._tzm = from2._tzm;
        }
        if (!isUndefined(from2._isUTC)) {
          to2._isUTC = from2._isUTC;
        }
        if (!isUndefined(from2._offset)) {
          to2._offset = from2._offset;
        }
        if (!isUndefined(from2._pf)) {
          to2._pf = getParsingFlags(from2);
        }
        if (!isUndefined(from2._locale)) {
          to2._locale = from2._locale;
        }
        if (momentPropertiesLen > 0) {
          for (i = 0; i < momentPropertiesLen; i++) {
            prop = momentProperties[i];
            val = from2[prop];
            if (!isUndefined(val)) {
              to2[prop] = val;
            }
          }
        }
        return to2;
      }
      function Moment(config2) {
        copyConfig(this, config2);
        this._d = new Date(config2._d != null ? config2._d.getTime() : NaN);
        if (!this.isValid()) {
          this._d = /* @__PURE__ */ new Date(NaN);
        }
        if (updateInProgress === false) {
          updateInProgress = true;
          hooks.updateOffset(this);
          updateInProgress = false;
        }
      }
      function isMoment(obj) {
        return obj instanceof Moment || obj != null && obj._isAMomentObject != null;
      }
      function warn(msg) {
        if (hooks.suppressDeprecationWarnings === false && typeof console !== "undefined" && console.warn) {
          console.warn("Deprecation warning: " + msg);
        }
      }
      function deprecate(msg, fn) {
        var firstTime = true;
        return extend(function() {
          if (hooks.deprecationHandler != null) {
            hooks.deprecationHandler(null, msg);
          }
          if (firstTime) {
            var args = [], arg, i, key, argLen = arguments.length;
            for (i = 0; i < argLen; i++) {
              arg = "";
              if (typeof arguments[i] === "object") {
                arg += "\n[" + i + "] ";
                for (key in arguments[0]) {
                  if (hasOwnProp(arguments[0], key)) {
                    arg += key + ": " + arguments[0][key] + ", ";
                  }
                }
                arg = arg.slice(0, -2);
              } else {
                arg = arguments[i];
              }
              args.push(arg);
            }
            warn(
              msg + "\nArguments: " + Array.prototype.slice.call(args).join("") + "\n" + new Error().stack
            );
            firstTime = false;
          }
          return fn.apply(this, arguments);
        }, fn);
      }
      var deprecations = {};
      function deprecateSimple(name, msg) {
        if (hooks.deprecationHandler != null) {
          hooks.deprecationHandler(name, msg);
        }
        if (!deprecations[name]) {
          warn(msg);
          deprecations[name] = true;
        }
      }
      hooks.suppressDeprecationWarnings = false;
      hooks.deprecationHandler = null;
      function isFunction(input) {
        return typeof Function !== "undefined" && input instanceof Function || Object.prototype.toString.call(input) === "[object Function]";
      }
      function set(config2) {
        var prop, i;
        for (i in config2) {
          if (hasOwnProp(config2, i)) {
            prop = config2[i];
            if (isFunction(prop)) {
              this[i] = prop;
            } else {
              this["_" + i] = prop;
            }
          }
        }
        this._config = config2;
        this._dayOfMonthOrdinalParseLenient = new RegExp(
          (this._dayOfMonthOrdinalParse.source || this._ordinalParse.source) + "|" + /\d{1,2}/.source
        );
      }
      function mergeConfigs(parentConfig, childConfig) {
        var res = extend({}, parentConfig), prop;
        for (prop in childConfig) {
          if (hasOwnProp(childConfig, prop)) {
            if (isObject(parentConfig[prop]) && isObject(childConfig[prop])) {
              res[prop] = {};
              extend(res[prop], parentConfig[prop]);
              extend(res[prop], childConfig[prop]);
            } else if (childConfig[prop] != null) {
              res[prop] = childConfig[prop];
            } else {
              delete res[prop];
            }
          }
        }
        for (prop in parentConfig) {
          if (hasOwnProp(parentConfig, prop) && !hasOwnProp(childConfig, prop) && isObject(parentConfig[prop])) {
            res[prop] = extend({}, res[prop]);
          }
        }
        return res;
      }
      function Locale(config2) {
        if (config2 != null) {
          this.set(config2);
        }
      }
      var keys;
      if (Object.keys) {
        keys = Object.keys;
      } else {
        keys = function(obj) {
          var i, res = [];
          for (i in obj) {
            if (hasOwnProp(obj, i)) {
              res.push(i);
            }
          }
          return res;
        };
      }
      var defaultCalendar = {
        sameDay: "[Today at] LT",
        nextDay: "[Tomorrow at] LT",
        nextWeek: "dddd [at] LT",
        lastDay: "[Yesterday at] LT",
        lastWeek: "[Last] dddd [at] LT",
        sameElse: "L"
      };
      function calendar(key, mom, now2) {
        var output = this._calendar[key] || this._calendar["sameElse"];
        return isFunction(output) ? output.call(mom, now2) : output;
      }
      function zeroFill(number, targetLength, forceSign) {
        var absNumber = "" + Math.abs(number), zerosToFill = targetLength - absNumber.length, sign2 = number >= 0;
        return (sign2 ? forceSign ? "+" : "" : "-") + Math.pow(10, Math.max(0, zerosToFill)).toString().substr(1) + absNumber;
      }
      var formattingTokens = /(\[[^\[]*\])|(\\)?([Hh]mm(ss)?|Mo|MM?M?M?|Do|DDDo|DD?D?D?|ddd?d?|do?|w[o|w]?|W[o|W]?|Qo?|N{1,5}|YYYYYY|YYYYY|YYYY|YY|y{2,4}|yo?|gg(ggg?)?|GG(GGG?)?|e|E|a|A|hh?|HH?|kk?|mm?|ss?|S{1,9}|x|X|zz?|ZZ?|.)/g, localFormattingTokens = /(\[[^\[]*\])|(\\)?(LTS|LT|LL?L?L?|l{1,4})/g, formatFunctions = {}, formatTokenFunctions = {};
      function addFormatToken(token2, padded, ordinal2, callback) {
        var func = callback;
        if (typeof callback === "string") {
          func = function() {
            return this[callback]();
          };
        }
        if (token2) {
          formatTokenFunctions[token2] = func;
        }
        if (padded) {
          formatTokenFunctions[padded[0]] = function() {
            return zeroFill(func.apply(this, arguments), padded[1], padded[2]);
          };
        }
        if (ordinal2) {
          formatTokenFunctions[ordinal2] = function() {
            return this.localeData().ordinal(
              func.apply(this, arguments),
              token2
            );
          };
        }
      }
      function removeFormattingTokens(input) {
        if (input.match(/\[[\s\S]/)) {
          return input.replace(/^\[|\]$/g, "");
        }
        return input.replace(/\\/g, "");
      }
      function makeFormatFunction(format2) {
        var array = format2.match(formattingTokens), i, length;
        for (i = 0, length = array.length; i < length; i++) {
          if (formatTokenFunctions[array[i]]) {
            array[i] = formatTokenFunctions[array[i]];
          } else {
            array[i] = removeFormattingTokens(array[i]);
          }
        }
        return function(mom) {
          var output = "", i2;
          for (i2 = 0; i2 < length; i2++) {
            output += isFunction(array[i2]) ? array[i2].call(mom, format2) : array[i2];
          }
          return output;
        };
      }
      function formatMoment(m, format2) {
        if (!m.isValid()) {
          return m.localeData().invalidDate();
        }
        format2 = expandFormat(format2, m.localeData());
        formatFunctions[format2] = formatFunctions[format2] || makeFormatFunction(format2);
        return formatFunctions[format2](m);
      }
      function expandFormat(format2, locale2) {
        var i = 5;
        function replaceLongDateFormatTokens(input) {
          return locale2.longDateFormat(input) || input;
        }
        localFormattingTokens.lastIndex = 0;
        while (i >= 0 && localFormattingTokens.test(format2)) {
          format2 = format2.replace(
            localFormattingTokens,
            replaceLongDateFormatTokens
          );
          localFormattingTokens.lastIndex = 0;
          i -= 1;
        }
        return format2;
      }
      var defaultLongDateFormat = {
        LTS: "h:mm:ss A",
        LT: "h:mm A",
        L: "MM/DD/YYYY",
        LL: "MMMM D, YYYY",
        LLL: "MMMM D, YYYY h:mm A",
        LLLL: "dddd, MMMM D, YYYY h:mm A"
      };
      function longDateFormat(key) {
        var format2 = this._longDateFormat[key], formatUpper = this._longDateFormat[key.toUpperCase()];
        if (format2 || !formatUpper) {
          return format2;
        }
        this._longDateFormat[key] = formatUpper.match(formattingTokens).map(function(tok) {
          if (tok === "MMMM" || tok === "MM" || tok === "DD" || tok === "dddd") {
            return tok.slice(1);
          }
          return tok;
        }).join("");
        return this._longDateFormat[key];
      }
      var defaultInvalidDate = "Invalid date";
      function invalidDate() {
        return this._invalidDate;
      }
      var defaultOrdinal = "%d", defaultDayOfMonthOrdinalParse = /\d{1,2}/;
      function ordinal(number) {
        return this._ordinal.replace("%d", number);
      }
      var defaultRelativeTime = {
        future: "in %s",
        past: "%s ago",
        s: "a few seconds",
        ss: "%d seconds",
        m: "a minute",
        mm: "%d minutes",
        h: "an hour",
        hh: "%d hours",
        d: "a day",
        dd: "%d days",
        w: "a week",
        ww: "%d weeks",
        M: "a month",
        MM: "%d months",
        y: "a year",
        yy: "%d years"
      };
      function relativeTime(number, withoutSuffix, string, isFuture) {
        var output = this._relativeTime[string];
        return isFunction(output) ? output(number, withoutSuffix, string, isFuture) : output.replace(/%d/i, number);
      }
      function pastFuture(diff2, output) {
        var format2 = this._relativeTime[diff2 > 0 ? "future" : "past"];
        return isFunction(format2) ? format2(output) : format2.replace(/%s/i, output);
      }
      var aliases = {
        D: "date",
        dates: "date",
        date: "date",
        d: "day",
        days: "day",
        day: "day",
        e: "weekday",
        weekdays: "weekday",
        weekday: "weekday",
        E: "isoWeekday",
        isoweekdays: "isoWeekday",
        isoweekday: "isoWeekday",
        DDD: "dayOfYear",
        dayofyears: "dayOfYear",
        dayofyear: "dayOfYear",
        h: "hour",
        hours: "hour",
        hour: "hour",
        ms: "millisecond",
        milliseconds: "millisecond",
        millisecond: "millisecond",
        m: "minute",
        minutes: "minute",
        minute: "minute",
        M: "month",
        months: "month",
        month: "month",
        Q: "quarter",
        quarters: "quarter",
        quarter: "quarter",
        s: "second",
        seconds: "second",
        second: "second",
        gg: "weekYear",
        weekyears: "weekYear",
        weekyear: "weekYear",
        GG: "isoWeekYear",
        isoweekyears: "isoWeekYear",
        isoweekyear: "isoWeekYear",
        w: "week",
        weeks: "week",
        week: "week",
        W: "isoWeek",
        isoweeks: "isoWeek",
        isoweek: "isoWeek",
        y: "year",
        years: "year",
        year: "year"
      };
      function normalizeUnits(units) {
        return typeof units === "string" ? aliases[units] || aliases[units.toLowerCase()] : void 0;
      }
      function normalizeObjectUnits(inputObject) {
        var normalizedInput = {}, normalizedProp, prop;
        for (prop in inputObject) {
          if (hasOwnProp(inputObject, prop)) {
            normalizedProp = normalizeUnits(prop);
            if (normalizedProp) {
              normalizedInput[normalizedProp] = inputObject[prop];
            }
          }
        }
        return normalizedInput;
      }
      var priorities = {
        date: 9,
        day: 11,
        weekday: 11,
        isoWeekday: 11,
        dayOfYear: 4,
        hour: 13,
        millisecond: 16,
        minute: 14,
        month: 8,
        quarter: 7,
        second: 15,
        weekYear: 1,
        isoWeekYear: 1,
        week: 5,
        isoWeek: 5,
        year: 1
      };
      function getPrioritizedUnits(unitsObj) {
        var units = [], u;
        for (u in unitsObj) {
          if (hasOwnProp(unitsObj, u)) {
            units.push({ unit: u, priority: priorities[u] });
          }
        }
        units.sort(function(a, b) {
          return a.priority - b.priority;
        });
        return units;
      }
      var match1 = /\d/, match2 = /\d\d/, match3 = /\d{3}/, match4 = /\d{4}/, match6 = /[+-]?\d{6}/, match1to2 = /\d\d?/, match3to4 = /\d\d\d\d?/, match5to6 = /\d\d\d\d\d\d?/, match1to3 = /\d{1,3}/, match1to4 = /\d{1,4}/, match1to6 = /[+-]?\d{1,6}/, matchUnsigned = /\d+/, matchSigned = /[+-]?\d+/, matchOffset = /Z|[+-]\d\d:?\d\d/gi, matchShortOffset = /Z|[+-]\d\d(?::?\d\d)?/gi, matchTimestamp = /[+-]?\d+(\.\d{1,3})?/, matchWord = /[0-9]{0,256}['a-z\u00A0-\u05FF\u0700-\uD7FF\uF900-\uFDCF\uFDF0-\uFF07\uFF10-\uFFEF]{1,256}|[\u0600-\u06FF\/]{1,256}(\s*?[\u0600-\u06FF]{1,256}){1,2}/i, match1to2NoLeadingZero = /^[1-9]\d?/, match1to2HasZero = /^([1-9]\d|\d)/, regexes;
      regexes = {};
      function addRegexToken(token2, regex, strictRegex) {
        regexes[token2] = isFunction(regex) ? regex : function(isStrict, localeData2) {
          return isStrict && strictRegex ? strictRegex : regex;
        };
      }
      function getParseRegexForToken(token2, config2) {
        if (!hasOwnProp(regexes, token2)) {
          return new RegExp(unescapeFormat(token2));
        }
        return regexes[token2](config2._strict, config2._locale);
      }
      function unescapeFormat(s) {
        return regexEscape(
          s.replace("\\", "").replace(
            /\\(\[)|\\(\])|\[([^\]\[]*)\]|\\(.)/g,
            function(matched, p1, p2, p3, p4) {
              return p1 || p2 || p3 || p4;
            }
          )
        );
      }
      function regexEscape(s) {
        return s.replace(/[-\/\\^$*+?.()|[\]{}]/g, "\\$&");
      }
      function absFloor(number) {
        if (number < 0) {
          return Math.ceil(number) || 0;
        } else {
          return Math.floor(number);
        }
      }
      function toInt(argumentForCoercion) {
        var coercedNumber = +argumentForCoercion, value = 0;
        if (coercedNumber !== 0 && isFinite(coercedNumber)) {
          value = absFloor(coercedNumber);
        }
        return value;
      }
      var tokens = {};
      function addParseToken(token2, callback) {
        var i, func = callback, tokenLen;
        if (typeof token2 === "string") {
          token2 = [token2];
        }
        if (isNumber(callback)) {
          func = function(input, array) {
            array[callback] = toInt(input);
          };
        }
        tokenLen = token2.length;
        for (i = 0; i < tokenLen; i++) {
          tokens[token2[i]] = func;
        }
      }
      function addWeekParseToken(token2, callback) {
        addParseToken(token2, function(input, array, config2, token3) {
          config2._w = config2._w || {};
          callback(input, config2._w, config2, token3);
        });
      }
      function addTimeToArrayFromToken(token2, input, config2) {
        if (input != null && hasOwnProp(tokens, token2)) {
          tokens[token2](input, config2._a, config2, token2);
        }
      }
      function isLeapYear(year) {
        return year % 4 === 0 && year % 100 !== 0 || year % 400 === 0;
      }
      var YEAR = 0, MONTH = 1, DATE = 2, HOUR = 3, MINUTE = 4, SECOND = 5, MILLISECOND = 6, WEEK = 7, WEEKDAY = 8;
      addFormatToken("Y", 0, 0, function() {
        var y = this.year();
        return y <= 9999 ? zeroFill(y, 4) : "+" + y;
      });
      addFormatToken(0, ["YY", 2], 0, function() {
        return this.year() % 100;
      });
      addFormatToken(0, ["YYYY", 4], 0, "year");
      addFormatToken(0, ["YYYYY", 5], 0, "year");
      addFormatToken(0, ["YYYYYY", 6, true], 0, "year");
      addRegexToken("Y", matchSigned);
      addRegexToken("YY", match1to2, match2);
      addRegexToken("YYYY", match1to4, match4);
      addRegexToken("YYYYY", match1to6, match6);
      addRegexToken("YYYYYY", match1to6, match6);
      addParseToken(["YYYYY", "YYYYYY"], YEAR);
      addParseToken("YYYY", function(input, array) {
        array[YEAR] = input.length === 2 ? hooks.parseTwoDigitYear(input) : toInt(input);
      });
      addParseToken("YY", function(input, array) {
        array[YEAR] = hooks.parseTwoDigitYear(input);
      });
      addParseToken("Y", function(input, array) {
        array[YEAR] = parseInt(input, 10);
      });
      function daysInYear(year) {
        return isLeapYear(year) ? 366 : 365;
      }
      hooks.parseTwoDigitYear = function(input) {
        return toInt(input) + (toInt(input) > 68 ? 1900 : 2e3);
      };
      var getSetYear = makeGetSet("FullYear", true);
      function getIsLeapYear() {
        return isLeapYear(this.year());
      }
      function makeGetSet(unit, keepTime) {
        return function(value) {
          if (value != null) {
            set$1(this, unit, value);
            hooks.updateOffset(this, keepTime);
            return this;
          } else {
            return get(this, unit);
          }
        };
      }
      function get(mom, unit) {
        if (!mom.isValid()) {
          return NaN;
        }
        var d = mom._d, isUTC = mom._isUTC;
        switch (unit) {
          case "Milliseconds":
            return isUTC ? d.getUTCMilliseconds() : d.getMilliseconds();
          case "Seconds":
            return isUTC ? d.getUTCSeconds() : d.getSeconds();
          case "Minutes":
            return isUTC ? d.getUTCMinutes() : d.getMinutes();
          case "Hours":
            return isUTC ? d.getUTCHours() : d.getHours();
          case "Date":
            return isUTC ? d.getUTCDate() : d.getDate();
          case "Day":
            return isUTC ? d.getUTCDay() : d.getDay();
          case "Month":
            return isUTC ? d.getUTCMonth() : d.getMonth();
          case "FullYear":
            return isUTC ? d.getUTCFullYear() : d.getFullYear();
          default:
            return NaN;
        }
      }
      function set$1(mom, unit, value) {
        var d, isUTC, year, month, date;
        if (!mom.isValid() || isNaN(value)) {
          return;
        }
        d = mom._d;
        isUTC = mom._isUTC;
        switch (unit) {
          case "Milliseconds":
            return void (isUTC ? d.setUTCMilliseconds(value) : d.setMilliseconds(value));
          case "Seconds":
            return void (isUTC ? d.setUTCSeconds(value) : d.setSeconds(value));
          case "Minutes":
            return void (isUTC ? d.setUTCMinutes(value) : d.setMinutes(value));
          case "Hours":
            return void (isUTC ? d.setUTCHours(value) : d.setHours(value));
          case "Date":
            return void (isUTC ? d.setUTCDate(value) : d.setDate(value));
          // case 'Day': // Not real
          //    return void (isUTC ? d.setUTCDay(value) : d.setDay(value));
          // case 'Month': // Not used because we need to pass two variables
          //     return void (isUTC ? d.setUTCMonth(value) : d.setMonth(value));
          case "FullYear":
            break;
          // See below ...
          default:
            return;
        }
        year = value;
        month = mom.month();
        date = mom.date();
        date = date === 29 && month === 1 && !isLeapYear(year) ? 28 : date;
        void (isUTC ? d.setUTCFullYear(year, month, date) : d.setFullYear(year, month, date));
      }
      function stringGet(units) {
        units = normalizeUnits(units);
        if (isFunction(this[units])) {
          return this[units]();
        }
        return this;
      }
      function stringSet(units, value) {
        if (typeof units === "object") {
          units = normalizeObjectUnits(units);
          var prioritized = getPrioritizedUnits(units), i, prioritizedLen = prioritized.length;
          for (i = 0; i < prioritizedLen; i++) {
            this[prioritized[i].unit](units[prioritized[i].unit]);
          }
        } else {
          units = normalizeUnits(units);
          if (isFunction(this[units])) {
            return this[units](value);
          }
        }
        return this;
      }
      function mod(n, x) {
        return (n % x + x) % x;
      }
      var indexOf;
      if (Array.prototype.indexOf) {
        indexOf = Array.prototype.indexOf;
      } else {
        indexOf = function(o) {
          var i;
          for (i = 0; i < this.length; ++i) {
            if (this[i] === o) {
              return i;
            }
          }
          return -1;
        };
      }
      function daysInMonth(year, month) {
        if (isNaN(year) || isNaN(month)) {
          return NaN;
        }
        var modMonth = mod(month, 12);
        year += (month - modMonth) / 12;
        return modMonth === 1 ? isLeapYear(year) ? 29 : 28 : 31 - modMonth % 7 % 2;
      }
      addFormatToken("M", ["MM", 2], "Mo", function() {
        return this.month() + 1;
      });
      addFormatToken("MMM", 0, 0, function(format2) {
        return this.localeData().monthsShort(this, format2);
      });
      addFormatToken("MMMM", 0, 0, function(format2) {
        return this.localeData().months(this, format2);
      });
      addRegexToken("M", match1to2, match1to2NoLeadingZero);
      addRegexToken("MM", match1to2, match2);
      addRegexToken("MMM", function(isStrict, locale2) {
        return locale2.monthsShortRegex(isStrict);
      });
      addRegexToken("MMMM", function(isStrict, locale2) {
        return locale2.monthsRegex(isStrict);
      });
      addParseToken(["M", "MM"], function(input, array) {
        array[MONTH] = toInt(input) - 1;
      });
      addParseToken(["MMM", "MMMM"], function(input, array, config2, token2) {
        var month = config2._locale.monthsParse(input, token2, config2._strict);
        if (month != null) {
          array[MONTH] = month;
        } else {
          getParsingFlags(config2).invalidMonth = input;
        }
      });
      var defaultLocaleMonths = "January_February_March_April_May_June_July_August_September_October_November_December".split(
        "_"
      ), defaultLocaleMonthsShort = "Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec".split("_"), MONTHS_IN_FORMAT = /D[oD]?(\[[^\[\]]*\]|\s)+MMMM?/, defaultMonthsShortRegex = matchWord, defaultMonthsRegex = matchWord;
      function localeMonths(m, format2) {
        if (!m) {
          return isArray(this._months) ? this._months : this._months["standalone"];
        }
        return isArray(this._months) ? this._months[m.month()] : this._months[(this._months.isFormat || MONTHS_IN_FORMAT).test(format2) ? "format" : "standalone"][m.month()];
      }
      function localeMonthsShort(m, format2) {
        if (!m) {
          return isArray(this._monthsShort) ? this._monthsShort : this._monthsShort["standalone"];
        }
        return isArray(this._monthsShort) ? this._monthsShort[m.month()] : this._monthsShort[MONTHS_IN_FORMAT.test(format2) ? "format" : "standalone"][m.month()];
      }
      function handleStrictParse(monthName, format2, strict) {
        var i, ii, mom, llc = monthName.toLocaleLowerCase();
        if (!this._monthsParse) {
          this._monthsParse = [];
          this._longMonthsParse = [];
          this._shortMonthsParse = [];
          for (i = 0; i < 12; ++i) {
            mom = createUTC([2e3, i]);
            this._shortMonthsParse[i] = this.monthsShort(
              mom,
              ""
            ).toLocaleLowerCase();
            this._longMonthsParse[i] = this.months(mom, "").toLocaleLowerCase();
          }
        }
        if (strict) {
          if (format2 === "MMM") {
            ii = indexOf.call(this._shortMonthsParse, llc);
            return ii !== -1 ? ii : null;
          } else {
            ii = indexOf.call(this._longMonthsParse, llc);
            return ii !== -1 ? ii : null;
          }
        } else {
          if (format2 === "MMM") {
            ii = indexOf.call(this._shortMonthsParse, llc);
            if (ii !== -1) {
              return ii;
            }
            ii = indexOf.call(this._longMonthsParse, llc);
            return ii !== -1 ? ii : null;
          } else {
            ii = indexOf.call(this._longMonthsParse, llc);
            if (ii !== -1) {
              return ii;
            }
            ii = indexOf.call(this._shortMonthsParse, llc);
            return ii !== -1 ? ii : null;
          }
        }
      }
      function localeMonthsParse(monthName, format2, strict) {
        var i, mom, regex;
        if (this._monthsParseExact) {
          return handleStrictParse.call(this, monthName, format2, strict);
        }
        if (!this._monthsParse) {
          this._monthsParse = [];
          this._longMonthsParse = [];
          this._shortMonthsParse = [];
        }
        for (i = 0; i < 12; i++) {
          mom = createUTC([2e3, i]);
          if (strict && !this._longMonthsParse[i]) {
            this._longMonthsParse[i] = new RegExp(
              "^" + this.months(mom, "").replace(".", "") + "$",
              "i"
            );
            this._shortMonthsParse[i] = new RegExp(
              "^" + this.monthsShort(mom, "").replace(".", "") + "$",
              "i"
            );
          }
          if (!strict && !this._monthsParse[i]) {
            regex = "^" + this.months(mom, "") + "|^" + this.monthsShort(mom, "");
            this._monthsParse[i] = new RegExp(regex.replace(".", ""), "i");
          }
          if (strict && format2 === "MMMM" && this._longMonthsParse[i].test(monthName)) {
            return i;
          } else if (strict && format2 === "MMM" && this._shortMonthsParse[i].test(monthName)) {
            return i;
          } else if (!strict && this._monthsParse[i].test(monthName)) {
            return i;
          }
        }
      }
      function setMonth(mom, value) {
        if (!mom.isValid()) {
          return mom;
        }
        if (typeof value === "string") {
          if (/^\d+$/.test(value)) {
            value = toInt(value);
          } else {
            value = mom.localeData().monthsParse(value);
            if (!isNumber(value)) {
              return mom;
            }
          }
        }
        var month = value, date = mom.date();
        date = date < 29 ? date : Math.min(date, daysInMonth(mom.year(), month));
        void (mom._isUTC ? mom._d.setUTCMonth(month, date) : mom._d.setMonth(month, date));
        return mom;
      }
      function getSetMonth(value) {
        if (value != null) {
          setMonth(this, value);
          hooks.updateOffset(this, true);
          return this;
        } else {
          return get(this, "Month");
        }
      }
      function getDaysInMonth() {
        return daysInMonth(this.year(), this.month());
      }
      function monthsShortRegex(isStrict) {
        if (this._monthsParseExact) {
          if (!hasOwnProp(this, "_monthsRegex")) {
            computeMonthsParse.call(this);
          }
          if (isStrict) {
            return this._monthsShortStrictRegex;
          } else {
            return this._monthsShortRegex;
          }
        } else {
          if (!hasOwnProp(this, "_monthsShortRegex")) {
            this._monthsShortRegex = defaultMonthsShortRegex;
          }
          return this._monthsShortStrictRegex && isStrict ? this._monthsShortStrictRegex : this._monthsShortRegex;
        }
      }
      function monthsRegex(isStrict) {
        if (this._monthsParseExact) {
          if (!hasOwnProp(this, "_monthsRegex")) {
            computeMonthsParse.call(this);
          }
          if (isStrict) {
            return this._monthsStrictRegex;
          } else {
            return this._monthsRegex;
          }
        } else {
          if (!hasOwnProp(this, "_monthsRegex")) {
            this._monthsRegex = defaultMonthsRegex;
          }
          return this._monthsStrictRegex && isStrict ? this._monthsStrictRegex : this._monthsRegex;
        }
      }
      function computeMonthsParse() {
        function cmpLenRev(a, b) {
          return b.length - a.length;
        }
        var shortPieces = [], longPieces = [], mixedPieces = [], i, mom, shortP, longP;
        for (i = 0; i < 12; i++) {
          mom = createUTC([2e3, i]);
          shortP = regexEscape(this.monthsShort(mom, ""));
          longP = regexEscape(this.months(mom, ""));
          shortPieces.push(shortP);
          longPieces.push(longP);
          mixedPieces.push(longP);
          mixedPieces.push(shortP);
        }
        shortPieces.sort(cmpLenRev);
        longPieces.sort(cmpLenRev);
        mixedPieces.sort(cmpLenRev);
        this._monthsRegex = new RegExp("^(" + mixedPieces.join("|") + ")", "i");
        this._monthsShortRegex = this._monthsRegex;
        this._monthsStrictRegex = new RegExp(
          "^(" + longPieces.join("|") + ")",
          "i"
        );
        this._monthsShortStrictRegex = new RegExp(
          "^(" + shortPieces.join("|") + ")",
          "i"
        );
      }
      function createDate(y, m, d, h, M, s, ms) {
        var date;
        if (y < 100 && y >= 0) {
          date = new Date(y + 400, m, d, h, M, s, ms);
          if (isFinite(date.getFullYear())) {
            date.setFullYear(y);
          }
        } else {
          date = new Date(y, m, d, h, M, s, ms);
        }
        return date;
      }
      function createUTCDate(y) {
        var date, args;
        if (y < 100 && y >= 0) {
          args = Array.prototype.slice.call(arguments);
          args[0] = y + 400;
          date = new Date(Date.UTC.apply(null, args));
          if (isFinite(date.getUTCFullYear())) {
            date.setUTCFullYear(y);
          }
        } else {
          date = new Date(Date.UTC.apply(null, arguments));
        }
        return date;
      }
      function firstWeekOffset(year, dow, doy) {
        var fwd = 7 + dow - doy, fwdlw = (7 + createUTCDate(year, 0, fwd).getUTCDay() - dow) % 7;
        return -fwdlw + fwd - 1;
      }
      function dayOfYearFromWeeks(year, week, weekday, dow, doy) {
        var localWeekday = (7 + weekday - dow) % 7, weekOffset = firstWeekOffset(year, dow, doy), dayOfYear = 1 + 7 * (week - 1) + localWeekday + weekOffset, resYear, resDayOfYear;
        if (dayOfYear <= 0) {
          resYear = year - 1;
          resDayOfYear = daysInYear(resYear) + dayOfYear;
        } else if (dayOfYear > daysInYear(year)) {
          resYear = year + 1;
          resDayOfYear = dayOfYear - daysInYear(year);
        } else {
          resYear = year;
          resDayOfYear = dayOfYear;
        }
        return {
          year: resYear,
          dayOfYear: resDayOfYear
        };
      }
      function weekOfYear(mom, dow, doy) {
        var weekOffset = firstWeekOffset(mom.year(), dow, doy), week = Math.floor((mom.dayOfYear() - weekOffset - 1) / 7) + 1, resWeek, resYear;
        if (week < 1) {
          resYear = mom.year() - 1;
          resWeek = week + weeksInYear(resYear, dow, doy);
        } else if (week > weeksInYear(mom.year(), dow, doy)) {
          resWeek = week - weeksInYear(mom.year(), dow, doy);
          resYear = mom.year() + 1;
        } else {
          resYear = mom.year();
          resWeek = week;
        }
        return {
          week: resWeek,
          year: resYear
        };
      }
      function weeksInYear(year, dow, doy) {
        var weekOffset = firstWeekOffset(year, dow, doy), weekOffsetNext = firstWeekOffset(year + 1, dow, doy);
        return (daysInYear(year) - weekOffset + weekOffsetNext) / 7;
      }
      addFormatToken("w", ["ww", 2], "wo", "week");
      addFormatToken("W", ["WW", 2], "Wo", "isoWeek");
      addRegexToken("w", match1to2, match1to2NoLeadingZero);
      addRegexToken("ww", match1to2, match2);
      addRegexToken("W", match1to2, match1to2NoLeadingZero);
      addRegexToken("WW", match1to2, match2);
      addWeekParseToken(
        ["w", "ww", "W", "WW"],
        function(input, week, config2, token2) {
          week[token2.substr(0, 1)] = toInt(input);
        }
      );
      function localeWeek(mom) {
        return weekOfYear(mom, this._week.dow, this._week.doy).week;
      }
      var defaultLocaleWeek = {
        dow: 0,
        // Sunday is the first day of the week.
        doy: 6
        // The week that contains Jan 6th is the first week of the year.
      };
      function localeFirstDayOfWeek() {
        return this._week.dow;
      }
      function localeFirstDayOfYear() {
        return this._week.doy;
      }
      function getSetWeek(input) {
        var week = this.localeData().week(this);
        return input == null ? week : this.add((input - week) * 7, "d");
      }
      function getSetISOWeek(input) {
        var week = weekOfYear(this, 1, 4).week;
        return input == null ? week : this.add((input - week) * 7, "d");
      }
      addFormatToken("d", 0, "do", "day");
      addFormatToken("dd", 0, 0, function(format2) {
        return this.localeData().weekdaysMin(this, format2);
      });
      addFormatToken("ddd", 0, 0, function(format2) {
        return this.localeData().weekdaysShort(this, format2);
      });
      addFormatToken("dddd", 0, 0, function(format2) {
        return this.localeData().weekdays(this, format2);
      });
      addFormatToken("e", 0, 0, "weekday");
      addFormatToken("E", 0, 0, "isoWeekday");
      addRegexToken("d", match1to2);
      addRegexToken("e", match1to2);
      addRegexToken("E", match1to2);
      addRegexToken("dd", function(isStrict, locale2) {
        return locale2.weekdaysMinRegex(isStrict);
      });
      addRegexToken("ddd", function(isStrict, locale2) {
        return locale2.weekdaysShortRegex(isStrict);
      });
      addRegexToken("dddd", function(isStrict, locale2) {
        return locale2.weekdaysRegex(isStrict);
      });
      addWeekParseToken(["dd", "ddd", "dddd"], function(input, week, config2, token2) {
        var weekday = config2._locale.weekdaysParse(input, token2, config2._strict);
        if (weekday != null) {
          week.d = weekday;
        } else {
          getParsingFlags(config2).invalidWeekday = input;
        }
      });
      addWeekParseToken(["d", "e", "E"], function(input, week, config2, token2) {
        week[token2] = toInt(input);
      });
      function parseWeekday(input, locale2) {
        if (typeof input !== "string") {
          return input;
        }
        if (!isNaN(input)) {
          return parseInt(input, 10);
        }
        input = locale2.weekdaysParse(input);
        if (typeof input === "number") {
          return input;
        }
        return null;
      }
      function parseIsoWeekday(input, locale2) {
        if (typeof input === "string") {
          return locale2.weekdaysParse(input) % 7 || 7;
        }
        return isNaN(input) ? null : input;
      }
      function shiftWeekdays(ws, n) {
        return ws.slice(n, 7).concat(ws.slice(0, n));
      }
      var defaultLocaleWeekdays = "Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday".split("_"), defaultLocaleWeekdaysShort = "Sun_Mon_Tue_Wed_Thu_Fri_Sat".split("_"), defaultLocaleWeekdaysMin = "Su_Mo_Tu_We_Th_Fr_Sa".split("_"), defaultWeekdaysRegex = matchWord, defaultWeekdaysShortRegex = matchWord, defaultWeekdaysMinRegex = matchWord;
      function localeWeekdays(m, format2) {
        var weekdays = isArray(this._weekdays) ? this._weekdays : this._weekdays[m && m !== true && this._weekdays.isFormat.test(format2) ? "format" : "standalone"];
        return m === true ? shiftWeekdays(weekdays, this._week.dow) : m ? weekdays[m.day()] : weekdays;
      }
      function localeWeekdaysShort(m) {
        return m === true ? shiftWeekdays(this._weekdaysShort, this._week.dow) : m ? this._weekdaysShort[m.day()] : this._weekdaysShort;
      }
      function localeWeekdaysMin(m) {
        return m === true ? shiftWeekdays(this._weekdaysMin, this._week.dow) : m ? this._weekdaysMin[m.day()] : this._weekdaysMin;
      }
      function handleStrictParse$1(weekdayName, format2, strict) {
        var i, ii, mom, llc = weekdayName.toLocaleLowerCase();
        if (!this._weekdaysParse) {
          this._weekdaysParse = [];
          this._shortWeekdaysParse = [];
          this._minWeekdaysParse = [];
          for (i = 0; i < 7; ++i) {
            mom = createUTC([2e3, 1]).day(i);
            this._minWeekdaysParse[i] = this.weekdaysMin(
              mom,
              ""
            ).toLocaleLowerCase();
            this._shortWeekdaysParse[i] = this.weekdaysShort(
              mom,
              ""
            ).toLocaleLowerCase();
            this._weekdaysParse[i] = this.weekdays(mom, "").toLocaleLowerCase();
          }
        }
        if (strict) {
          if (format2 === "dddd") {
            ii = indexOf.call(this._weekdaysParse, llc);
            return ii !== -1 ? ii : null;
          } else if (format2 === "ddd") {
            ii = indexOf.call(this._shortWeekdaysParse, llc);
            return ii !== -1 ? ii : null;
          } else {
            ii = indexOf.call(this._minWeekdaysParse, llc);
            return ii !== -1 ? ii : null;
          }
        } else {
          if (format2 === "dddd") {
            ii = indexOf.call(this._weekdaysParse, llc);
            if (ii !== -1) {
              return ii;
            }
            ii = indexOf.call(this._shortWeekdaysParse, llc);
            if (ii !== -1) {
              return ii;
            }
            ii = indexOf.call(this._minWeekdaysParse, llc);
            return ii !== -1 ? ii : null;
          } else if (format2 === "ddd") {
            ii = indexOf.call(this._shortWeekdaysParse, llc);
            if (ii !== -1) {
              return ii;
            }
            ii = indexOf.call(this._weekdaysParse, llc);
            if (ii !== -1) {
              return ii;
            }
            ii = indexOf.call(this._minWeekdaysParse, llc);
            return ii !== -1 ? ii : null;
          } else {
            ii = indexOf.call(this._minWeekdaysParse, llc);
            if (ii !== -1) {
              return ii;
            }
            ii = indexOf.call(this._weekdaysParse, llc);
            if (ii !== -1) {
              return ii;
            }
            ii = indexOf.call(this._shortWeekdaysParse, llc);
            return ii !== -1 ? ii : null;
          }
        }
      }
      function localeWeekdaysParse(weekdayName, format2, strict) {
        var i, mom, regex;
        if (this._weekdaysParseExact) {
          return handleStrictParse$1.call(this, weekdayName, format2, strict);
        }
        if (!this._weekdaysParse) {
          this._weekdaysParse = [];
          this._minWeekdaysParse = [];
          this._shortWeekdaysParse = [];
          this._fullWeekdaysParse = [];
        }
        for (i = 0; i < 7; i++) {
          mom = createUTC([2e3, 1]).day(i);
          if (strict && !this._fullWeekdaysParse[i]) {
            this._fullWeekdaysParse[i] = new RegExp(
              "^" + this.weekdays(mom, "").replace(".", "\\.?") + "$",
              "i"
            );
            this._shortWeekdaysParse[i] = new RegExp(
              "^" + this.weekdaysShort(mom, "").replace(".", "\\.?") + "$",
              "i"
            );
            this._minWeekdaysParse[i] = new RegExp(
              "^" + this.weekdaysMin(mom, "").replace(".", "\\.?") + "$",
              "i"
            );
          }
          if (!this._weekdaysParse[i]) {
            regex = "^" + this.weekdays(mom, "") + "|^" + this.weekdaysShort(mom, "") + "|^" + this.weekdaysMin(mom, "");
            this._weekdaysParse[i] = new RegExp(regex.replace(".", ""), "i");
          }
          if (strict && format2 === "dddd" && this._fullWeekdaysParse[i].test(weekdayName)) {
            return i;
          } else if (strict && format2 === "ddd" && this._shortWeekdaysParse[i].test(weekdayName)) {
            return i;
          } else if (strict && format2 === "dd" && this._minWeekdaysParse[i].test(weekdayName)) {
            return i;
          } else if (!strict && this._weekdaysParse[i].test(weekdayName)) {
            return i;
          }
        }
      }
      function getSetDayOfWeek(input) {
        if (!this.isValid()) {
          return input != null ? this : NaN;
        }
        var day = get(this, "Day");
        if (input != null) {
          input = parseWeekday(input, this.localeData());
          return this.add(input - day, "d");
        } else {
          return day;
        }
      }
      function getSetLocaleDayOfWeek(input) {
        if (!this.isValid()) {
          return input != null ? this : NaN;
        }
        var weekday = (this.day() + 7 - this.localeData()._week.dow) % 7;
        return input == null ? weekday : this.add(input - weekday, "d");
      }
      function getSetISODayOfWeek(input) {
        if (!this.isValid()) {
          return input != null ? this : NaN;
        }
        if (input != null) {
          var weekday = parseIsoWeekday(input, this.localeData());
          return this.day(this.day() % 7 ? weekday : weekday - 7);
        } else {
          return this.day() || 7;
        }
      }
      function weekdaysRegex(isStrict) {
        if (this._weekdaysParseExact) {
          if (!hasOwnProp(this, "_weekdaysRegex")) {
            computeWeekdaysParse.call(this);
          }
          if (isStrict) {
            return this._weekdaysStrictRegex;
          } else {
            return this._weekdaysRegex;
          }
        } else {
          if (!hasOwnProp(this, "_weekdaysRegex")) {
            this._weekdaysRegex = defaultWeekdaysRegex;
          }
          return this._weekdaysStrictRegex && isStrict ? this._weekdaysStrictRegex : this._weekdaysRegex;
        }
      }
      function weekdaysShortRegex(isStrict) {
        if (this._weekdaysParseExact) {
          if (!hasOwnProp(this, "_weekdaysRegex")) {
            computeWeekdaysParse.call(this);
          }
          if (isStrict) {
            return this._weekdaysShortStrictRegex;
          } else {
            return this._weekdaysShortRegex;
          }
        } else {
          if (!hasOwnProp(this, "_weekdaysShortRegex")) {
            this._weekdaysShortRegex = defaultWeekdaysShortRegex;
          }
          return this._weekdaysShortStrictRegex && isStrict ? this._weekdaysShortStrictRegex : this._weekdaysShortRegex;
        }
      }
      function weekdaysMinRegex(isStrict) {
        if (this._weekdaysParseExact) {
          if (!hasOwnProp(this, "_weekdaysRegex")) {
            computeWeekdaysParse.call(this);
          }
          if (isStrict) {
            return this._weekdaysMinStrictRegex;
          } else {
            return this._weekdaysMinRegex;
          }
        } else {
          if (!hasOwnProp(this, "_weekdaysMinRegex")) {
            this._weekdaysMinRegex = defaultWeekdaysMinRegex;
          }
          return this._weekdaysMinStrictRegex && isStrict ? this._weekdaysMinStrictRegex : this._weekdaysMinRegex;
        }
      }
      function computeWeekdaysParse() {
        function cmpLenRev(a, b) {
          return b.length - a.length;
        }
        var minPieces = [], shortPieces = [], longPieces = [], mixedPieces = [], i, mom, minp, shortp, longp;
        for (i = 0; i < 7; i++) {
          mom = createUTC([2e3, 1]).day(i);
          minp = regexEscape(this.weekdaysMin(mom, ""));
          shortp = regexEscape(this.weekdaysShort(mom, ""));
          longp = regexEscape(this.weekdays(mom, ""));
          minPieces.push(minp);
          shortPieces.push(shortp);
          longPieces.push(longp);
          mixedPieces.push(minp);
          mixedPieces.push(shortp);
          mixedPieces.push(longp);
        }
        minPieces.sort(cmpLenRev);
        shortPieces.sort(cmpLenRev);
        longPieces.sort(cmpLenRev);
        mixedPieces.sort(cmpLenRev);
        this._weekdaysRegex = new RegExp("^(" + mixedPieces.join("|") + ")", "i");
        this._weekdaysShortRegex = this._weekdaysRegex;
        this._weekdaysMinRegex = this._weekdaysRegex;
        this._weekdaysStrictRegex = new RegExp(
          "^(" + longPieces.join("|") + ")",
          "i"
        );
        this._weekdaysShortStrictRegex = new RegExp(
          "^(" + shortPieces.join("|") + ")",
          "i"
        );
        this._weekdaysMinStrictRegex = new RegExp(
          "^(" + minPieces.join("|") + ")",
          "i"
        );
      }
      function hFormat() {
        return this.hours() % 12 || 12;
      }
      function kFormat() {
        return this.hours() || 24;
      }
      addFormatToken("H", ["HH", 2], 0, "hour");
      addFormatToken("h", ["hh", 2], 0, hFormat);
      addFormatToken("k", ["kk", 2], 0, kFormat);
      addFormatToken("hmm", 0, 0, function() {
        return "" + hFormat.apply(this) + zeroFill(this.minutes(), 2);
      });
      addFormatToken("hmmss", 0, 0, function() {
        return "" + hFormat.apply(this) + zeroFill(this.minutes(), 2) + zeroFill(this.seconds(), 2);
      });
      addFormatToken("Hmm", 0, 0, function() {
        return "" + this.hours() + zeroFill(this.minutes(), 2);
      });
      addFormatToken("Hmmss", 0, 0, function() {
        return "" + this.hours() + zeroFill(this.minutes(), 2) + zeroFill(this.seconds(), 2);
      });
      function meridiem(token2, lowercase) {
        addFormatToken(token2, 0, 0, function() {
          return this.localeData().meridiem(
            this.hours(),
            this.minutes(),
            lowercase
          );
        });
      }
      meridiem("a", true);
      meridiem("A", false);
      function matchMeridiem(isStrict, locale2) {
        return locale2._meridiemParse;
      }
      addRegexToken("a", matchMeridiem);
      addRegexToken("A", matchMeridiem);
      addRegexToken("H", match1to2, match1to2HasZero);
      addRegexToken("h", match1to2, match1to2NoLeadingZero);
      addRegexToken("k", match1to2, match1to2NoLeadingZero);
      addRegexToken("HH", match1to2, match2);
      addRegexToken("hh", match1to2, match2);
      addRegexToken("kk", match1to2, match2);
      addRegexToken("hmm", match3to4);
      addRegexToken("hmmss", match5to6);
      addRegexToken("Hmm", match3to4);
      addRegexToken("Hmmss", match5to6);
      addParseToken(["H", "HH"], HOUR);
      addParseToken(["k", "kk"], function(input, array, config2) {
        var kInput = toInt(input);
        array[HOUR] = kInput === 24 ? 0 : kInput;
      });
      addParseToken(["a", "A"], function(input, array, config2) {
        config2._isPm = config2._locale.isPM(input);
        config2._meridiem = input;
      });
      addParseToken(["h", "hh"], function(input, array, config2) {
        array[HOUR] = toInt(input);
        getParsingFlags(config2).bigHour = true;
      });
      addParseToken("hmm", function(input, array, config2) {
        var pos = input.length - 2;
        array[HOUR] = toInt(input.substr(0, pos));
        array[MINUTE] = toInt(input.substr(pos));
        getParsingFlags(config2).bigHour = true;
      });
      addParseToken("hmmss", function(input, array, config2) {
        var pos1 = input.length - 4, pos2 = input.length - 2;
        array[HOUR] = toInt(input.substr(0, pos1));
        array[MINUTE] = toInt(input.substr(pos1, 2));
        array[SECOND] = toInt(input.substr(pos2));
        getParsingFlags(config2).bigHour = true;
      });
      addParseToken("Hmm", function(input, array, config2) {
        var pos = input.length - 2;
        array[HOUR] = toInt(input.substr(0, pos));
        array[MINUTE] = toInt(input.substr(pos));
      });
      addParseToken("Hmmss", function(input, array, config2) {
        var pos1 = input.length - 4, pos2 = input.length - 2;
        array[HOUR] = toInt(input.substr(0, pos1));
        array[MINUTE] = toInt(input.substr(pos1, 2));
        array[SECOND] = toInt(input.substr(pos2));
      });
      function localeIsPM(input) {
        return (input + "").toLowerCase().charAt(0) === "p";
      }
      var defaultLocaleMeridiemParse = /[ap]\.?m?\.?/i, getSetHour = makeGetSet("Hours", true);
      function localeMeridiem(hours2, minutes2, isLower) {
        if (hours2 > 11) {
          return isLower ? "pm" : "PM";
        } else {
          return isLower ? "am" : "AM";
        }
      }
      var baseConfig = {
        calendar: defaultCalendar,
        longDateFormat: defaultLongDateFormat,
        invalidDate: defaultInvalidDate,
        ordinal: defaultOrdinal,
        dayOfMonthOrdinalParse: defaultDayOfMonthOrdinalParse,
        relativeTime: defaultRelativeTime,
        months: defaultLocaleMonths,
        monthsShort: defaultLocaleMonthsShort,
        week: defaultLocaleWeek,
        weekdays: defaultLocaleWeekdays,
        weekdaysMin: defaultLocaleWeekdaysMin,
        weekdaysShort: defaultLocaleWeekdaysShort,
        meridiemParse: defaultLocaleMeridiemParse
      };
      var locales = {}, localeFamilies = {}, globalLocale;
      function commonPrefix(arr1, arr2) {
        var i, minl = Math.min(arr1.length, arr2.length);
        for (i = 0; i < minl; i += 1) {
          if (arr1[i] !== arr2[i]) {
            return i;
          }
        }
        return minl;
      }
      function normalizeLocale(key) {
        return key ? key.toLowerCase().replace("_", "-") : key;
      }
      function chooseLocale(names) {
        var i = 0, j, next, locale2, split;
        while (i < names.length) {
          split = normalizeLocale(names[i]).split("-");
          j = split.length;
          next = normalizeLocale(names[i + 1]);
          next = next ? next.split("-") : null;
          while (j > 0) {
            locale2 = loadLocale(split.slice(0, j).join("-"));
            if (locale2) {
              return locale2;
            }
            if (next && next.length >= j && commonPrefix(split, next) >= j - 1) {
              break;
            }
            j--;
          }
          i++;
        }
        return globalLocale;
      }
      function isLocaleNameSane(name) {
        return !!(name && name.match("^[^/\\\\]*$"));
      }
      function loadLocale(name) {
        var oldLocale = null, aliasedRequire;
        if (locales[name] === void 0 && typeof module2 !== "undefined" && module2 && module2.exports && isLocaleNameSane(name)) {
          try {
            oldLocale = globalLocale._abbr;
            aliasedRequire = require;
            aliasedRequire("./locale/" + name);
            getSetGlobalLocale(oldLocale);
          } catch (e) {
            locales[name] = null;
          }
        }
        return locales[name];
      }
      function getSetGlobalLocale(key, values) {
        var data;
        if (key) {
          if (isUndefined(values)) {
            data = getLocale(key);
          } else {
            data = defineLocale(key, values);
          }
          if (data) {
            globalLocale = data;
          } else {
            if (typeof console !== "undefined" && console.warn) {
              console.warn(
                "Locale " + key + " not found. Did you forget to load it?"
              );
            }
          }
        }
        return globalLocale._abbr;
      }
      function defineLocale(name, config2) {
        if (config2 !== null) {
          var locale2, parentConfig = baseConfig;
          config2.abbr = name;
          if (locales[name] != null) {
            deprecateSimple(
              "defineLocaleOverride",
              "use moment.updateLocale(localeName, config) to change an existing locale. moment.defineLocale(localeName, config) should only be used for creating a new locale See http://momentjs.com/guides/#/warnings/define-locale/ for more info."
            );
            parentConfig = locales[name]._config;
          } else if (config2.parentLocale != null) {
            if (locales[config2.parentLocale] != null) {
              parentConfig = locales[config2.parentLocale]._config;
            } else {
              locale2 = loadLocale(config2.parentLocale);
              if (locale2 != null) {
                parentConfig = locale2._config;
              } else {
                if (!localeFamilies[config2.parentLocale]) {
                  localeFamilies[config2.parentLocale] = [];
                }
                localeFamilies[config2.parentLocale].push({
                  name,
                  config: config2
                });
                return null;
              }
            }
          }
          locales[name] = new Locale(mergeConfigs(parentConfig, config2));
          if (localeFamilies[name]) {
            localeFamilies[name].forEach(function(x) {
              defineLocale(x.name, x.config);
            });
          }
          getSetGlobalLocale(name);
          return locales[name];
        } else {
          delete locales[name];
          return null;
        }
      }
      function updateLocale(name, config2) {
        if (config2 != null) {
          var locale2, tmpLocale, parentConfig = baseConfig;
          if (locales[name] != null && locales[name].parentLocale != null) {
            locales[name].set(mergeConfigs(locales[name]._config, config2));
          } else {
            tmpLocale = loadLocale(name);
            if (tmpLocale != null) {
              parentConfig = tmpLocale._config;
            }
            config2 = mergeConfigs(parentConfig, config2);
            if (tmpLocale == null) {
              config2.abbr = name;
            }
            locale2 = new Locale(config2);
            locale2.parentLocale = locales[name];
            locales[name] = locale2;
          }
          getSetGlobalLocale(name);
        } else {
          if (locales[name] != null) {
            if (locales[name].parentLocale != null) {
              locales[name] = locales[name].parentLocale;
              if (name === getSetGlobalLocale()) {
                getSetGlobalLocale(name);
              }
            } else if (locales[name] != null) {
              delete locales[name];
            }
          }
        }
        return locales[name];
      }
      function getLocale(key) {
        var locale2;
        if (key && key._locale && key._locale._abbr) {
          key = key._locale._abbr;
        }
        if (!key) {
          return globalLocale;
        }
        if (!isArray(key)) {
          locale2 = loadLocale(key);
          if (locale2) {
            return locale2;
          }
          key = [key];
        }
        return chooseLocale(key);
      }
      function listLocales() {
        return keys(locales);
      }
      function checkOverflow(m) {
        var overflow, a = m._a;
        if (a && getParsingFlags(m).overflow === -2) {
          overflow = a[MONTH] < 0 || a[MONTH] > 11 ? MONTH : a[DATE] < 1 || a[DATE] > daysInMonth(a[YEAR], a[MONTH]) ? DATE : a[HOUR] < 0 || a[HOUR] > 24 || a[HOUR] === 24 && (a[MINUTE] !== 0 || a[SECOND] !== 0 || a[MILLISECOND] !== 0) ? HOUR : a[MINUTE] < 0 || a[MINUTE] > 59 ? MINUTE : a[SECOND] < 0 || a[SECOND] > 59 ? SECOND : a[MILLISECOND] < 0 || a[MILLISECOND] > 999 ? MILLISECOND : -1;
          if (getParsingFlags(m)._overflowDayOfYear && (overflow < YEAR || overflow > DATE)) {
            overflow = DATE;
          }
          if (getParsingFlags(m)._overflowWeeks && overflow === -1) {
            overflow = WEEK;
          }
          if (getParsingFlags(m)._overflowWeekday && overflow === -1) {
            overflow = WEEKDAY;
          }
          getParsingFlags(m).overflow = overflow;
        }
        return m;
      }
      var extendedIsoRegex = /^\s*((?:[+-]\d{6}|\d{4})-(?:\d\d-\d\d|W\d\d-\d|W\d\d|\d\d\d|\d\d))(?:(T| )(\d\d(?::\d\d(?::\d\d(?:[.,]\d+)?)?)?)([+-]\d\d(?::?\d\d)?|\s*Z)?)?$/, basicIsoRegex = /^\s*((?:[+-]\d{6}|\d{4})(?:\d\d\d\d|W\d\d\d|W\d\d|\d\d\d|\d\d|))(?:(T| )(\d\d(?:\d\d(?:\d\d(?:[.,]\d+)?)?)?)([+-]\d\d(?::?\d\d)?|\s*Z)?)?$/, tzRegex = /Z|[+-]\d\d(?::?\d\d)?/, isoDates = [
        ["YYYYYY-MM-DD", /[+-]\d{6}-\d\d-\d\d/],
        ["YYYY-MM-DD", /\d{4}-\d\d-\d\d/],
        ["GGGG-[W]WW-E", /\d{4}-W\d\d-\d/],
        ["GGGG-[W]WW", /\d{4}-W\d\d/, false],
        ["YYYY-DDD", /\d{4}-\d{3}/],
        ["YYYY-MM", /\d{4}-\d\d/, false],
        ["YYYYYYMMDD", /[+-]\d{10}/],
        ["YYYYMMDD", /\d{8}/],
        ["GGGG[W]WWE", /\d{4}W\d{3}/],
        ["GGGG[W]WW", /\d{4}W\d{2}/, false],
        ["YYYYDDD", /\d{7}/],
        ["YYYYMM", /\d{6}/, false],
        ["YYYY", /\d{4}/, false]
      ], isoTimes = [
        ["HH:mm:ss.SSSS", /\d\d:\d\d:\d\d\.\d+/],
        ["HH:mm:ss,SSSS", /\d\d:\d\d:\d\d,\d+/],
        ["HH:mm:ss", /\d\d:\d\d:\d\d/],
        ["HH:mm", /\d\d:\d\d/],
        ["HHmmss.SSSS", /\d\d\d\d\d\d\.\d+/],
        ["HHmmss,SSSS", /\d\d\d\d\d\d,\d+/],
        ["HHmmss", /\d\d\d\d\d\d/],
        ["HHmm", /\d\d\d\d/],
        ["HH", /\d\d/]
      ], aspNetJsonRegex = /^\/?Date\((-?\d+)/i, rfc2822 = /^(?:(Mon|Tue|Wed|Thu|Fri|Sat|Sun),?\s)?(\d{1,2})\s(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)\s(\d{2,4})\s(\d\d):(\d\d)(?::(\d\d))?\s(?:(UT|GMT|[ECMP][SD]T)|([Zz])|([+-]\d{4}))$/, obsOffsets = {
        UT: 0,
        GMT: 0,
        EDT: -4 * 60,
        EST: -5 * 60,
        CDT: -5 * 60,
        CST: -6 * 60,
        MDT: -6 * 60,
        MST: -7 * 60,
        PDT: -7 * 60,
        PST: -8 * 60
      };
      function configFromISO(config2) {
        var i, l, string = config2._i, match = extendedIsoRegex.exec(string) || basicIsoRegex.exec(string), allowTime, dateFormat, timeFormat, tzFormat, isoDatesLen = isoDates.length, isoTimesLen = isoTimes.length;
        if (match) {
          getParsingFlags(config2).iso = true;
          for (i = 0, l = isoDatesLen; i < l; i++) {
            if (isoDates[i][1].exec(match[1])) {
              dateFormat = isoDates[i][0];
              allowTime = isoDates[i][2] !== false;
              break;
            }
          }
          if (dateFormat == null) {
            config2._isValid = false;
            return;
          }
          if (match[3]) {
            for (i = 0, l = isoTimesLen; i < l; i++) {
              if (isoTimes[i][1].exec(match[3])) {
                timeFormat = (match[2] || " ") + isoTimes[i][0];
                break;
              }
            }
            if (timeFormat == null) {
              config2._isValid = false;
              return;
            }
          }
          if (!allowTime && timeFormat != null) {
            config2._isValid = false;
            return;
          }
          if (match[4]) {
            if (tzRegex.exec(match[4])) {
              tzFormat = "Z";
            } else {
              config2._isValid = false;
              return;
            }
          }
          config2._f = dateFormat + (timeFormat || "") + (tzFormat || "");
          configFromStringAndFormat(config2);
        } else {
          config2._isValid = false;
        }
      }
      function extractFromRFC2822Strings(yearStr, monthStr, dayStr, hourStr, minuteStr, secondStr) {
        var result = [
          untruncateYear(yearStr),
          defaultLocaleMonthsShort.indexOf(monthStr),
          parseInt(dayStr, 10),
          parseInt(hourStr, 10),
          parseInt(minuteStr, 10)
        ];
        if (secondStr) {
          result.push(parseInt(secondStr, 10));
        }
        return result;
      }
      function untruncateYear(yearStr) {
        var year = parseInt(yearStr, 10);
        if (year <= 49) {
          return 2e3 + year;
        } else if (year <= 999) {
          return 1900 + year;
        }
        return year;
      }
      function preprocessRFC2822(s) {
        return s.replace(/\([^()]*\)|[\n\t]/g, " ").replace(/(\s\s+)/g, " ").replace(/^\s\s*/, "").replace(/\s\s*$/, "");
      }
      function checkWeekday(weekdayStr, parsedInput, config2) {
        if (weekdayStr) {
          var weekdayProvided = defaultLocaleWeekdaysShort.indexOf(weekdayStr), weekdayActual = new Date(
            parsedInput[0],
            parsedInput[1],
            parsedInput[2]
          ).getDay();
          if (weekdayProvided !== weekdayActual) {
            getParsingFlags(config2).weekdayMismatch = true;
            config2._isValid = false;
            return false;
          }
        }
        return true;
      }
      function calculateOffset(obsOffset, militaryOffset, numOffset) {
        if (obsOffset) {
          return obsOffsets[obsOffset];
        } else if (militaryOffset) {
          return 0;
        } else {
          var hm = parseInt(numOffset, 10), m = hm % 100, h = (hm - m) / 100;
          return h * 60 + m;
        }
      }
      function configFromRFC2822(config2) {
        var match = rfc2822.exec(preprocessRFC2822(config2._i)), parsedArray;
        if (match) {
          parsedArray = extractFromRFC2822Strings(
            match[4],
            match[3],
            match[2],
            match[5],
            match[6],
            match[7]
          );
          if (!checkWeekday(match[1], parsedArray, config2)) {
            return;
          }
          config2._a = parsedArray;
          config2._tzm = calculateOffset(match[8], match[9], match[10]);
          config2._d = createUTCDate.apply(null, config2._a);
          config2._d.setUTCMinutes(config2._d.getUTCMinutes() - config2._tzm);
          getParsingFlags(config2).rfc2822 = true;
        } else {
          config2._isValid = false;
        }
      }
      function configFromString(config2) {
        var matched = aspNetJsonRegex.exec(config2._i);
        if (matched !== null) {
          config2._d = /* @__PURE__ */ new Date(+matched[1]);
          return;
        }
        configFromISO(config2);
        if (config2._isValid === false) {
          delete config2._isValid;
        } else {
          return;
        }
        configFromRFC2822(config2);
        if (config2._isValid === false) {
          delete config2._isValid;
        } else {
          return;
        }
        if (config2._strict) {
          config2._isValid = false;
        } else {
          hooks.createFromInputFallback(config2);
        }
      }
      hooks.createFromInputFallback = deprecate(
        "value provided is not in a recognized RFC2822 or ISO format. moment construction falls back to js Date(), which is not reliable across all browsers and versions. Non RFC2822/ISO date formats are discouraged. Please refer to http://momentjs.com/guides/#/warnings/js-date/ for more info.",
        function(config2) {
          config2._d = /* @__PURE__ */ new Date(config2._i + (config2._useUTC ? " UTC" : ""));
        }
      );
      function defaults(a, b, c) {
        if (a != null) {
          return a;
        }
        if (b != null) {
          return b;
        }
        return c;
      }
      function currentDateArray(config2) {
        var nowValue = new Date(hooks.now());
        if (config2._useUTC) {
          return [
            nowValue.getUTCFullYear(),
            nowValue.getUTCMonth(),
            nowValue.getUTCDate()
          ];
        }
        return [nowValue.getFullYear(), nowValue.getMonth(), nowValue.getDate()];
      }
      function configFromArray(config2) {
        var i, date, input = [], currentDate, expectedWeekday, yearToUse;
        if (config2._d) {
          return;
        }
        currentDate = currentDateArray(config2);
        if (config2._w && config2._a[DATE] == null && config2._a[MONTH] == null) {
          dayOfYearFromWeekInfo(config2);
        }
        if (config2._dayOfYear != null) {
          yearToUse = defaults(config2._a[YEAR], currentDate[YEAR]);
          if (config2._dayOfYear > daysInYear(yearToUse) || config2._dayOfYear === 0) {
            getParsingFlags(config2)._overflowDayOfYear = true;
          }
          date = createUTCDate(yearToUse, 0, config2._dayOfYear);
          config2._a[MONTH] = date.getUTCMonth();
          config2._a[DATE] = date.getUTCDate();
        }
        for (i = 0; i < 3 && config2._a[i] == null; ++i) {
          config2._a[i] = input[i] = currentDate[i];
        }
        for (; i < 7; i++) {
          config2._a[i] = input[i] = config2._a[i] == null ? i === 2 ? 1 : 0 : config2._a[i];
        }
        if (config2._a[HOUR] === 24 && config2._a[MINUTE] === 0 && config2._a[SECOND] === 0 && config2._a[MILLISECOND] === 0) {
          config2._nextDay = true;
          config2._a[HOUR] = 0;
        }
        config2._d = (config2._useUTC ? createUTCDate : createDate).apply(
          null,
          input
        );
        expectedWeekday = config2._useUTC ? config2._d.getUTCDay() : config2._d.getDay();
        if (config2._tzm != null) {
          config2._d.setUTCMinutes(config2._d.getUTCMinutes() - config2._tzm);
        }
        if (config2._nextDay) {
          config2._a[HOUR] = 24;
        }
        if (config2._w && typeof config2._w.d !== "undefined" && config2._w.d !== expectedWeekday) {
          getParsingFlags(config2).weekdayMismatch = true;
        }
      }
      function dayOfYearFromWeekInfo(config2) {
        var w, weekYear, week, weekday, dow, doy, temp, weekdayOverflow, curWeek;
        w = config2._w;
        if (w.GG != null || w.W != null || w.E != null) {
          dow = 1;
          doy = 4;
          weekYear = defaults(
            w.GG,
            config2._a[YEAR],
            weekOfYear(createLocal(), 1, 4).year
          );
          week = defaults(w.W, 1);
          weekday = defaults(w.E, 1);
          if (weekday < 1 || weekday > 7) {
            weekdayOverflow = true;
          }
        } else {
          dow = config2._locale._week.dow;
          doy = config2._locale._week.doy;
          curWeek = weekOfYear(createLocal(), dow, doy);
          weekYear = defaults(w.gg, config2._a[YEAR], curWeek.year);
          week = defaults(w.w, curWeek.week);
          if (w.d != null) {
            weekday = w.d;
            if (weekday < 0 || weekday > 6) {
              weekdayOverflow = true;
            }
          } else if (w.e != null) {
            weekday = w.e + dow;
            if (w.e < 0 || w.e > 6) {
              weekdayOverflow = true;
            }
          } else {
            weekday = dow;
          }
        }
        if (week < 1 || week > weeksInYear(weekYear, dow, doy)) {
          getParsingFlags(config2)._overflowWeeks = true;
        } else if (weekdayOverflow != null) {
          getParsingFlags(config2)._overflowWeekday = true;
        } else {
          temp = dayOfYearFromWeeks(weekYear, week, weekday, dow, doy);
          config2._a[YEAR] = temp.year;
          config2._dayOfYear = temp.dayOfYear;
        }
      }
      hooks.ISO_8601 = function() {
      };
      hooks.RFC_2822 = function() {
      };
      function configFromStringAndFormat(config2) {
        if (config2._f === hooks.ISO_8601) {
          configFromISO(config2);
          return;
        }
        if (config2._f === hooks.RFC_2822) {
          configFromRFC2822(config2);
          return;
        }
        config2._a = [];
        getParsingFlags(config2).empty = true;
        var string = "" + config2._i, i, parsedInput, tokens2, token2, skipped, stringLength = string.length, totalParsedInputLength = 0, era, tokenLen;
        tokens2 = expandFormat(config2._f, config2._locale).match(formattingTokens) || [];
        tokenLen = tokens2.length;
        for (i = 0; i < tokenLen; i++) {
          token2 = tokens2[i];
          parsedInput = (string.match(getParseRegexForToken(token2, config2)) || [])[0];
          if (parsedInput) {
            skipped = string.substr(0, string.indexOf(parsedInput));
            if (skipped.length > 0) {
              getParsingFlags(config2).unusedInput.push(skipped);
            }
            string = string.slice(
              string.indexOf(parsedInput) + parsedInput.length
            );
            totalParsedInputLength += parsedInput.length;
          }
          if (formatTokenFunctions[token2]) {
            if (parsedInput) {
              getParsingFlags(config2).empty = false;
            } else {
              getParsingFlags(config2).unusedTokens.push(token2);
            }
            addTimeToArrayFromToken(token2, parsedInput, config2);
          } else if (config2._strict && !parsedInput) {
            getParsingFlags(config2).unusedTokens.push(token2);
          }
        }
        getParsingFlags(config2).charsLeftOver = stringLength - totalParsedInputLength;
        if (string.length > 0) {
          getParsingFlags(config2).unusedInput.push(string);
        }
        if (config2._a[HOUR] <= 12 && getParsingFlags(config2).bigHour === true && config2._a[HOUR] > 0) {
          getParsingFlags(config2).bigHour = void 0;
        }
        getParsingFlags(config2).parsedDateParts = config2._a.slice(0);
        getParsingFlags(config2).meridiem = config2._meridiem;
        config2._a[HOUR] = meridiemFixWrap(
          config2._locale,
          config2._a[HOUR],
          config2._meridiem
        );
        era = getParsingFlags(config2).era;
        if (era !== null) {
          config2._a[YEAR] = config2._locale.erasConvertYear(era, config2._a[YEAR]);
        }
        configFromArray(config2);
        checkOverflow(config2);
      }
      function meridiemFixWrap(locale2, hour, meridiem2) {
        var isPm;
        if (meridiem2 == null) {
          return hour;
        }
        if (locale2.meridiemHour != null) {
          return locale2.meridiemHour(hour, meridiem2);
        } else if (locale2.isPM != null) {
          isPm = locale2.isPM(meridiem2);
          if (isPm && hour < 12) {
            hour += 12;
          }
          if (!isPm && hour === 12) {
            hour = 0;
          }
          return hour;
        } else {
          return hour;
        }
      }
      function configFromStringAndArray(config2) {
        var tempConfig, bestMoment, scoreToBeat, i, currentScore, validFormatFound, bestFormatIsValid = false, configfLen = config2._f.length;
        if (configfLen === 0) {
          getParsingFlags(config2).invalidFormat = true;
          config2._d = /* @__PURE__ */ new Date(NaN);
          return;
        }
        for (i = 0; i < configfLen; i++) {
          currentScore = 0;
          validFormatFound = false;
          tempConfig = copyConfig({}, config2);
          if (config2._useUTC != null) {
            tempConfig._useUTC = config2._useUTC;
          }
          tempConfig._f = config2._f[i];
          configFromStringAndFormat(tempConfig);
          if (isValid(tempConfig)) {
            validFormatFound = true;
          }
          currentScore += getParsingFlags(tempConfig).charsLeftOver;
          currentScore += getParsingFlags(tempConfig).unusedTokens.length * 10;
          getParsingFlags(tempConfig).score = currentScore;
          if (!bestFormatIsValid) {
            if (scoreToBeat == null || currentScore < scoreToBeat || validFormatFound) {
              scoreToBeat = currentScore;
              bestMoment = tempConfig;
              if (validFormatFound) {
                bestFormatIsValid = true;
              }
            }
          } else {
            if (currentScore < scoreToBeat) {
              scoreToBeat = currentScore;
              bestMoment = tempConfig;
            }
          }
        }
        extend(config2, bestMoment || tempConfig);
      }
      function configFromObject(config2) {
        if (config2._d) {
          return;
        }
        var i = normalizeObjectUnits(config2._i), dayOrDate = i.day === void 0 ? i.date : i.day;
        config2._a = map(
          [i.year, i.month, dayOrDate, i.hour, i.minute, i.second, i.millisecond],
          function(obj) {
            return obj && parseInt(obj, 10);
          }
        );
        configFromArray(config2);
      }
      function createFromConfig(config2) {
        var res = new Moment(checkOverflow(prepareConfig(config2)));
        if (res._nextDay) {
          res.add(1, "d");
          res._nextDay = void 0;
        }
        return res;
      }
      function prepareConfig(config2) {
        var input = config2._i, format2 = config2._f;
        config2._locale = config2._locale || getLocale(config2._l);
        if (input === null || format2 === void 0 && input === "") {
          return createInvalid({ nullInput: true });
        }
        if (typeof input === "string") {
          config2._i = input = config2._locale.preparse(input);
        }
        if (isMoment(input)) {
          return new Moment(checkOverflow(input));
        } else if (isDate(input)) {
          config2._d = input;
        } else if (isArray(format2)) {
          configFromStringAndArray(config2);
        } else if (format2) {
          configFromStringAndFormat(config2);
        } else {
          configFromInput(config2);
        }
        if (!isValid(config2)) {
          config2._d = null;
        }
        return config2;
      }
      function configFromInput(config2) {
        var input = config2._i;
        if (isUndefined(input)) {
          config2._d = new Date(hooks.now());
        } else if (isDate(input)) {
          config2._d = new Date(input.valueOf());
        } else if (typeof input === "string") {
          configFromString(config2);
        } else if (isArray(input)) {
          config2._a = map(input.slice(0), function(obj) {
            return parseInt(obj, 10);
          });
          configFromArray(config2);
        } else if (isObject(input)) {
          configFromObject(config2);
        } else if (isNumber(input)) {
          config2._d = new Date(input);
        } else {
          hooks.createFromInputFallback(config2);
        }
      }
      function createLocalOrUTC(input, format2, locale2, strict, isUTC) {
        var c = {};
        if (format2 === true || format2 === false) {
          strict = format2;
          format2 = void 0;
        }
        if (locale2 === true || locale2 === false) {
          strict = locale2;
          locale2 = void 0;
        }
        if (isObject(input) && isObjectEmpty(input) || isArray(input) && input.length === 0) {
          input = void 0;
        }
        c._isAMomentObject = true;
        c._useUTC = c._isUTC = isUTC;
        c._l = locale2;
        c._i = input;
        c._f = format2;
        c._strict = strict;
        return createFromConfig(c);
      }
      function createLocal(input, format2, locale2, strict) {
        return createLocalOrUTC(input, format2, locale2, strict, false);
      }
      var prototypeMin = deprecate(
        "moment().min is deprecated, use moment.max instead. http://momentjs.com/guides/#/warnings/min-max/",
        function() {
          var other = createLocal.apply(null, arguments);
          if (this.isValid() && other.isValid()) {
            return other < this ? this : other;
          } else {
            return createInvalid();
          }
        }
      ), prototypeMax = deprecate(
        "moment().max is deprecated, use moment.min instead. http://momentjs.com/guides/#/warnings/min-max/",
        function() {
          var other = createLocal.apply(null, arguments);
          if (this.isValid() && other.isValid()) {
            return other > this ? this : other;
          } else {
            return createInvalid();
          }
        }
      );
      function pickBy(fn, moments) {
        var res, i;
        if (moments.length === 1 && isArray(moments[0])) {
          moments = moments[0];
        }
        if (!moments.length) {
          return createLocal();
        }
        res = moments[0];
        for (i = 1; i < moments.length; ++i) {
          if (!moments[i].isValid() || moments[i][fn](res)) {
            res = moments[i];
          }
        }
        return res;
      }
      function min() {
        var args = [].slice.call(arguments, 0);
        return pickBy("isBefore", args);
      }
      function max() {
        var args = [].slice.call(arguments, 0);
        return pickBy("isAfter", args);
      }
      var now = function() {
        return Date.now ? Date.now() : +/* @__PURE__ */ new Date();
      };
      var ordering = [
        "year",
        "quarter",
        "month",
        "week",
        "day",
        "hour",
        "minute",
        "second",
        "millisecond"
      ];
      function isDurationValid(m) {
        var key, unitHasDecimal = false, i, orderLen = ordering.length;
        for (key in m) {
          if (hasOwnProp(m, key) && !(indexOf.call(ordering, key) !== -1 && (m[key] == null || !isNaN(m[key])))) {
            return false;
          }
        }
        for (i = 0; i < orderLen; ++i) {
          if (m[ordering[i]]) {
            if (unitHasDecimal) {
              return false;
            }
            if (parseFloat(m[ordering[i]]) !== toInt(m[ordering[i]])) {
              unitHasDecimal = true;
            }
          }
        }
        return true;
      }
      function isValid$1() {
        return this._isValid;
      }
      function createInvalid$1() {
        return createDuration(NaN);
      }
      function Duration(duration) {
        var normalizedInput = normalizeObjectUnits(duration), years2 = normalizedInput.year || 0, quarters = normalizedInput.quarter || 0, months2 = normalizedInput.month || 0, weeks2 = normalizedInput.week || normalizedInput.isoWeek || 0, days2 = normalizedInput.day || 0, hours2 = normalizedInput.hour || 0, minutes2 = normalizedInput.minute || 0, seconds2 = normalizedInput.second || 0, milliseconds2 = normalizedInput.millisecond || 0;
        this._isValid = isDurationValid(normalizedInput);
        this._milliseconds = +milliseconds2 + seconds2 * 1e3 + // 1000
        minutes2 * 6e4 + // 1000 * 60
        hours2 * 1e3 * 60 * 60;
        this._days = +days2 + weeks2 * 7;
        this._months = +months2 + quarters * 3 + years2 * 12;
        this._data = {};
        this._locale = getLocale();
        this._bubble();
      }
      function isDuration(obj) {
        return obj instanceof Duration;
      }
      function absRound(number) {
        if (number < 0) {
          return Math.round(-1 * number) * -1;
        } else {
          return Math.round(number);
        }
      }
      function compareArrays(array1, array2, dontConvert) {
        var len = Math.min(array1.length, array2.length), lengthDiff = Math.abs(array1.length - array2.length), diffs = 0, i;
        for (i = 0; i < len; i++) {
          if (dontConvert && array1[i] !== array2[i] || !dontConvert && toInt(array1[i]) !== toInt(array2[i])) {
            diffs++;
          }
        }
        return diffs + lengthDiff;
      }
      function offset(token2, separator) {
        addFormatToken(token2, 0, 0, function() {
          var offset2 = this.utcOffset(), sign2 = "+";
          if (offset2 < 0) {
            offset2 = -offset2;
            sign2 = "-";
          }
          return sign2 + zeroFill(~~(offset2 / 60), 2) + separator + zeroFill(~~offset2 % 60, 2);
        });
      }
      offset("Z", ":");
      offset("ZZ", "");
      addRegexToken("Z", matchShortOffset);
      addRegexToken("ZZ", matchShortOffset);
      addParseToken(["Z", "ZZ"], function(input, array, config2) {
        config2._useUTC = true;
        config2._tzm = offsetFromString(matchShortOffset, input);
      });
      var chunkOffset = /([\+\-]|\d\d)/gi;
      function offsetFromString(matcher, string) {
        var matches = (string || "").match(matcher), chunk, parts, minutes2;
        if (matches === null) {
          return null;
        }
        chunk = matches[matches.length - 1] || [];
        parts = (chunk + "").match(chunkOffset) || ["-", 0, 0];
        minutes2 = +(parts[1] * 60) + toInt(parts[2]);
        return minutes2 === 0 ? 0 : parts[0] === "+" ? minutes2 : -minutes2;
      }
      function cloneWithOffset(input, model) {
        var res, diff2;
        if (model._isUTC) {
          res = model.clone();
          diff2 = (isMoment(input) || isDate(input) ? input.valueOf() : createLocal(input).valueOf()) - res.valueOf();
          res._d.setTime(res._d.valueOf() + diff2);
          hooks.updateOffset(res, false);
          return res;
        } else {
          return createLocal(input).local();
        }
      }
      function getDateOffset(m) {
        return -Math.round(m._d.getTimezoneOffset());
      }
      hooks.updateOffset = function() {
      };
      function getSetOffset(input, keepLocalTime, keepMinutes) {
        var offset2 = this._offset || 0, localAdjust;
        if (!this.isValid()) {
          return input != null ? this : NaN;
        }
        if (input != null) {
          if (typeof input === "string") {
            input = offsetFromString(matchShortOffset, input);
            if (input === null) {
              return this;
            }
          } else if (Math.abs(input) < 16 && !keepMinutes) {
            input = input * 60;
          }
          if (!this._isUTC && keepLocalTime) {
            localAdjust = getDateOffset(this);
          }
          this._offset = input;
          this._isUTC = true;
          if (localAdjust != null) {
            this.add(localAdjust, "m");
          }
          if (offset2 !== input) {
            if (!keepLocalTime || this._changeInProgress) {
              addSubtract(
                this,
                createDuration(input - offset2, "m"),
                1,
                false
              );
            } else if (!this._changeInProgress) {
              this._changeInProgress = true;
              hooks.updateOffset(this, true);
              this._changeInProgress = null;
            }
          }
          return this;
        } else {
          return this._isUTC ? offset2 : getDateOffset(this);
        }
      }
      function getSetZone(input, keepLocalTime) {
        if (input != null) {
          if (typeof input !== "string") {
            input = -input;
          }
          this.utcOffset(input, keepLocalTime);
          return this;
        } else {
          return -this.utcOffset();
        }
      }
      function setOffsetToUTC(keepLocalTime) {
        return this.utcOffset(0, keepLocalTime);
      }
      function setOffsetToLocal(keepLocalTime) {
        if (this._isUTC) {
          this.utcOffset(0, keepLocalTime);
          this._isUTC = false;
          if (keepLocalTime) {
            this.subtract(getDateOffset(this), "m");
          }
        }
        return this;
      }
      function setOffsetToParsedOffset() {
        if (this._tzm != null) {
          this.utcOffset(this._tzm, false, true);
        } else if (typeof this._i === "string") {
          var tZone = offsetFromString(matchOffset, this._i);
          if (tZone != null) {
            this.utcOffset(tZone);
          } else {
            this.utcOffset(0, true);
          }
        }
        return this;
      }
      function hasAlignedHourOffset(input) {
        if (!this.isValid()) {
          return false;
        }
        input = input ? createLocal(input).utcOffset() : 0;
        return (this.utcOffset() - input) % 60 === 0;
      }
      function isDaylightSavingTime() {
        return this.utcOffset() > this.clone().month(0).utcOffset() || this.utcOffset() > this.clone().month(5).utcOffset();
      }
      function isDaylightSavingTimeShifted() {
        if (!isUndefined(this._isDSTShifted)) {
          return this._isDSTShifted;
        }
        var c = {}, other;
        copyConfig(c, this);
        c = prepareConfig(c);
        if (c._a) {
          other = c._isUTC ? createUTC(c._a) : createLocal(c._a);
          this._isDSTShifted = this.isValid() && compareArrays(c._a, other.toArray()) > 0;
        } else {
          this._isDSTShifted = false;
        }
        return this._isDSTShifted;
      }
      function isLocal() {
        return this.isValid() ? !this._isUTC : false;
      }
      function isUtcOffset() {
        return this.isValid() ? this._isUTC : false;
      }
      function isUtc() {
        return this.isValid() ? this._isUTC && this._offset === 0 : false;
      }
      var aspNetRegex = /^(-|\+)?(?:(\d*)[. ])?(\d+):(\d+)(?::(\d+)(\.\d*)?)?$/, isoRegex = /^(-|\+)?P(?:([-+]?[0-9,.]*)Y)?(?:([-+]?[0-9,.]*)M)?(?:([-+]?[0-9,.]*)W)?(?:([-+]?[0-9,.]*)D)?(?:T(?:([-+]?[0-9,.]*)H)?(?:([-+]?[0-9,.]*)M)?(?:([-+]?[0-9,.]*)S)?)?$/;
      function createDuration(input, key) {
        var duration = input, match = null, sign2, ret, diffRes;
        if (isDuration(input)) {
          duration = {
            ms: input._milliseconds,
            d: input._days,
            M: input._months
          };
        } else if (isNumber(input) || !isNaN(+input)) {
          duration = {};
          if (key) {
            duration[key] = +input;
          } else {
            duration.milliseconds = +input;
          }
        } else if (match = aspNetRegex.exec(input)) {
          sign2 = match[1] === "-" ? -1 : 1;
          duration = {
            y: 0,
            d: toInt(match[DATE]) * sign2,
            h: toInt(match[HOUR]) * sign2,
            m: toInt(match[MINUTE]) * sign2,
            s: toInt(match[SECOND]) * sign2,
            ms: toInt(absRound(match[MILLISECOND] * 1e3)) * sign2
            // the millisecond decimal point is included in the match
          };
        } else if (match = isoRegex.exec(input)) {
          sign2 = match[1] === "-" ? -1 : 1;
          duration = {
            y: parseIso(match[2], sign2),
            M: parseIso(match[3], sign2),
            w: parseIso(match[4], sign2),
            d: parseIso(match[5], sign2),
            h: parseIso(match[6], sign2),
            m: parseIso(match[7], sign2),
            s: parseIso(match[8], sign2)
          };
        } else if (duration == null) {
          duration = {};
        } else if (typeof duration === "object" && ("from" in duration || "to" in duration)) {
          diffRes = momentsDifference(
            createLocal(duration.from),
            createLocal(duration.to)
          );
          duration = {};
          duration.ms = diffRes.milliseconds;
          duration.M = diffRes.months;
        }
        ret = new Duration(duration);
        if (isDuration(input) && hasOwnProp(input, "_locale")) {
          ret._locale = input._locale;
        }
        if (isDuration(input) && hasOwnProp(input, "_isValid")) {
          ret._isValid = input._isValid;
        }
        return ret;
      }
      createDuration.fn = Duration.prototype;
      createDuration.invalid = createInvalid$1;
      function parseIso(inp, sign2) {
        var res = inp && parseFloat(inp.replace(",", "."));
        return (isNaN(res) ? 0 : res) * sign2;
      }
      function positiveMomentsDifference(base, other) {
        var res = {};
        res.months = other.month() - base.month() + (other.year() - base.year()) * 12;
        if (base.clone().add(res.months, "M").isAfter(other)) {
          --res.months;
        }
        res.milliseconds = +other - +base.clone().add(res.months, "M");
        return res;
      }
      function momentsDifference(base, other) {
        var res;
        if (!(base.isValid() && other.isValid())) {
          return { milliseconds: 0, months: 0 };
        }
        other = cloneWithOffset(other, base);
        if (base.isBefore(other)) {
          res = positiveMomentsDifference(base, other);
        } else {
          res = positiveMomentsDifference(other, base);
          res.milliseconds = -res.milliseconds;
          res.months = -res.months;
        }
        return res;
      }
      function createAdder(direction, name) {
        return function(val, period) {
          var dur, tmp;
          if (period !== null && !isNaN(+period)) {
            deprecateSimple(
              name,
              "moment()." + name + "(period, number) is deprecated. Please use moment()." + name + "(number, period). See http://momentjs.com/guides/#/warnings/add-inverted-param/ for more info."
            );
            tmp = val;
            val = period;
            period = tmp;
          }
          dur = createDuration(val, period);
          addSubtract(this, dur, direction);
          return this;
        };
      }
      function addSubtract(mom, duration, isAdding, updateOffset) {
        var milliseconds2 = duration._milliseconds, days2 = absRound(duration._days), months2 = absRound(duration._months);
        if (!mom.isValid()) {
          return;
        }
        updateOffset = updateOffset == null ? true : updateOffset;
        if (months2) {
          setMonth(mom, get(mom, "Month") + months2 * isAdding);
        }
        if (days2) {
          set$1(mom, "Date", get(mom, "Date") + days2 * isAdding);
        }
        if (milliseconds2) {
          mom._d.setTime(mom._d.valueOf() + milliseconds2 * isAdding);
        }
        if (updateOffset) {
          hooks.updateOffset(mom, days2 || months2);
        }
      }
      var add = createAdder(1, "add"), subtract = createAdder(-1, "subtract");
      function isString(input) {
        return typeof input === "string" || input instanceof String;
      }
      function isMomentInput(input) {
        return isMoment(input) || isDate(input) || isString(input) || isNumber(input) || isNumberOrStringArray(input) || isMomentInputObject(input) || input === null || input === void 0;
      }
      function isMomentInputObject(input) {
        var objectTest = isObject(input) && !isObjectEmpty(input), propertyTest = false, properties = [
          "years",
          "year",
          "y",
          "months",
          "month",
          "M",
          "days",
          "day",
          "d",
          "dates",
          "date",
          "D",
          "hours",
          "hour",
          "h",
          "minutes",
          "minute",
          "m",
          "seconds",
          "second",
          "s",
          "milliseconds",
          "millisecond",
          "ms"
        ], i, property, propertyLen = properties.length;
        for (i = 0; i < propertyLen; i += 1) {
          property = properties[i];
          propertyTest = propertyTest || hasOwnProp(input, property);
        }
        return objectTest && propertyTest;
      }
      function isNumberOrStringArray(input) {
        var arrayTest = isArray(input), dataTypeTest = false;
        if (arrayTest) {
          dataTypeTest = input.filter(function(item) {
            return !isNumber(item) && isString(input);
          }).length === 0;
        }
        return arrayTest && dataTypeTest;
      }
      function isCalendarSpec(input) {
        var objectTest = isObject(input) && !isObjectEmpty(input), propertyTest = false, properties = [
          "sameDay",
          "nextDay",
          "lastDay",
          "nextWeek",
          "lastWeek",
          "sameElse"
        ], i, property;
        for (i = 0; i < properties.length; i += 1) {
          property = properties[i];
          propertyTest = propertyTest || hasOwnProp(input, property);
        }
        return objectTest && propertyTest;
      }
      function getCalendarFormat(myMoment, now2) {
        var diff2 = myMoment.diff(now2, "days", true);
        return diff2 < -6 ? "sameElse" : diff2 < -1 ? "lastWeek" : diff2 < 0 ? "lastDay" : diff2 < 1 ? "sameDay" : diff2 < 2 ? "nextDay" : diff2 < 7 ? "nextWeek" : "sameElse";
      }
      function calendar$1(time, formats) {
        if (arguments.length === 1) {
          if (!arguments[0]) {
            time = void 0;
            formats = void 0;
          } else if (isMomentInput(arguments[0])) {
            time = arguments[0];
            formats = void 0;
          } else if (isCalendarSpec(arguments[0])) {
            formats = arguments[0];
            time = void 0;
          }
        }
        var now2 = time || createLocal(), sod = cloneWithOffset(now2, this).startOf("day"), format2 = hooks.calendarFormat(this, sod) || "sameElse", output = formats && (isFunction(formats[format2]) ? formats[format2].call(this, now2) : formats[format2]);
        return this.format(
          output || this.localeData().calendar(format2, this, createLocal(now2))
        );
      }
      function clone() {
        return new Moment(this);
      }
      function isAfter(input, units) {
        var localInput = isMoment(input) ? input : createLocal(input);
        if (!(this.isValid() && localInput.isValid())) {
          return false;
        }
        units = normalizeUnits(units) || "millisecond";
        if (units === "millisecond") {
          return this.valueOf() > localInput.valueOf();
        } else {
          return localInput.valueOf() < this.clone().startOf(units).valueOf();
        }
      }
      function isBefore(input, units) {
        var localInput = isMoment(input) ? input : createLocal(input);
        if (!(this.isValid() && localInput.isValid())) {
          return false;
        }
        units = normalizeUnits(units) || "millisecond";
        if (units === "millisecond") {
          return this.valueOf() < localInput.valueOf();
        } else {
          return this.clone().endOf(units).valueOf() < localInput.valueOf();
        }
      }
      function isBetween(from2, to2, units, inclusivity) {
        var localFrom = isMoment(from2) ? from2 : createLocal(from2), localTo = isMoment(to2) ? to2 : createLocal(to2);
        if (!(this.isValid() && localFrom.isValid() && localTo.isValid())) {
          return false;
        }
        inclusivity = inclusivity || "()";
        return (inclusivity[0] === "(" ? this.isAfter(localFrom, units) : !this.isBefore(localFrom, units)) && (inclusivity[1] === ")" ? this.isBefore(localTo, units) : !this.isAfter(localTo, units));
      }
      function isSame(input, units) {
        var localInput = isMoment(input) ? input : createLocal(input), inputMs;
        if (!(this.isValid() && localInput.isValid())) {
          return false;
        }
        units = normalizeUnits(units) || "millisecond";
        if (units === "millisecond") {
          return this.valueOf() === localInput.valueOf();
        } else {
          inputMs = localInput.valueOf();
          return this.clone().startOf(units).valueOf() <= inputMs && inputMs <= this.clone().endOf(units).valueOf();
        }
      }
      function isSameOrAfter(input, units) {
        return this.isSame(input, units) || this.isAfter(input, units);
      }
      function isSameOrBefore(input, units) {
        return this.isSame(input, units) || this.isBefore(input, units);
      }
      function diff(input, units, asFloat) {
        var that, zoneDelta, output;
        if (!this.isValid()) {
          return NaN;
        }
        that = cloneWithOffset(input, this);
        if (!that.isValid()) {
          return NaN;
        }
        zoneDelta = (that.utcOffset() - this.utcOffset()) * 6e4;
        units = normalizeUnits(units);
        switch (units) {
          case "year":
            output = monthDiff(this, that) / 12;
            break;
          case "month":
            output = monthDiff(this, that);
            break;
          case "quarter":
            output = monthDiff(this, that) / 3;
            break;
          case "second":
            output = (this - that) / 1e3;
            break;
          // 1000
          case "minute":
            output = (this - that) / 6e4;
            break;
          // 1000 * 60
          case "hour":
            output = (this - that) / 36e5;
            break;
          // 1000 * 60 * 60
          case "day":
            output = (this - that - zoneDelta) / 864e5;
            break;
          // 1000 * 60 * 60 * 24, negate dst
          case "week":
            output = (this - that - zoneDelta) / 6048e5;
            break;
          // 1000 * 60 * 60 * 24 * 7, negate dst
          default:
            output = this - that;
        }
        return asFloat ? output : absFloor(output);
      }
      function monthDiff(a, b) {
        if (a.date() < b.date()) {
          return -monthDiff(b, a);
        }
        var wholeMonthDiff = (b.year() - a.year()) * 12 + (b.month() - a.month()), anchor = a.clone().add(wholeMonthDiff, "months"), anchor2, adjust;
        if (b - anchor < 0) {
          anchor2 = a.clone().add(wholeMonthDiff - 1, "months");
          adjust = (b - anchor) / (anchor - anchor2);
        } else {
          anchor2 = a.clone().add(wholeMonthDiff + 1, "months");
          adjust = (b - anchor) / (anchor2 - anchor);
        }
        return -(wholeMonthDiff + adjust) || 0;
      }
      hooks.defaultFormat = "YYYY-MM-DDTHH:mm:ssZ";
      hooks.defaultFormatUtc = "YYYY-MM-DDTHH:mm:ss[Z]";
      function toString() {
        return this.clone().locale("en").format("ddd MMM DD YYYY HH:mm:ss [GMT]ZZ");
      }
      function toISOString(keepOffset) {
        if (!this.isValid()) {
          return null;
        }
        var utc = keepOffset !== true, m = utc ? this.clone().utc() : this;
        if (m.year() < 0 || m.year() > 9999) {
          return formatMoment(
            m,
            utc ? "YYYYYY-MM-DD[T]HH:mm:ss.SSS[Z]" : "YYYYYY-MM-DD[T]HH:mm:ss.SSSZ"
          );
        }
        if (isFunction(Date.prototype.toISOString)) {
          if (utc) {
            return this.toDate().toISOString();
          } else {
            return new Date(this.valueOf() + this.utcOffset() * 60 * 1e3).toISOString().replace("Z", formatMoment(m, "Z"));
          }
        }
        return formatMoment(
          m,
          utc ? "YYYY-MM-DD[T]HH:mm:ss.SSS[Z]" : "YYYY-MM-DD[T]HH:mm:ss.SSSZ"
        );
      }
      function inspect() {
        if (!this.isValid()) {
          return "moment.invalid(/* " + this._i + " */)";
        }
        var func = "moment", zone = "", prefix, year, datetime, suffix;
        if (!this.isLocal()) {
          func = this.utcOffset() === 0 ? "moment.utc" : "moment.parseZone";
          zone = "Z";
        }
        prefix = "[" + func + '("]';
        year = 0 <= this.year() && this.year() <= 9999 ? "YYYY" : "YYYYYY";
        datetime = "-MM-DD[T]HH:mm:ss.SSS";
        suffix = zone + '[")]';
        return this.format(prefix + year + datetime + suffix);
      }
      function format(inputString) {
        if (!inputString) {
          inputString = this.isUtc() ? hooks.defaultFormatUtc : hooks.defaultFormat;
        }
        var output = formatMoment(this, inputString);
        return this.localeData().postformat(output);
      }
      function from(time, withoutSuffix) {
        if (this.isValid() && (isMoment(time) && time.isValid() || createLocal(time).isValid())) {
          return createDuration({ to: this, from: time }).locale(this.locale()).humanize(!withoutSuffix);
        } else {
          return this.localeData().invalidDate();
        }
      }
      function fromNow(withoutSuffix) {
        return this.from(createLocal(), withoutSuffix);
      }
      function to(time, withoutSuffix) {
        if (this.isValid() && (isMoment(time) && time.isValid() || createLocal(time).isValid())) {
          return createDuration({ from: this, to: time }).locale(this.locale()).humanize(!withoutSuffix);
        } else {
          return this.localeData().invalidDate();
        }
      }
      function toNow(withoutSuffix) {
        return this.to(createLocal(), withoutSuffix);
      }
      function locale(key) {
        var newLocaleData;
        if (key === void 0) {
          return this._locale._abbr;
        } else {
          newLocaleData = getLocale(key);
          if (newLocaleData != null) {
            this._locale = newLocaleData;
          }
          return this;
        }
      }
      var lang = deprecate(
        "moment().lang() is deprecated. Instead, use moment().localeData() to get the language configuration. Use moment().locale() to change languages.",
        function(key) {
          if (key === void 0) {
            return this.localeData();
          } else {
            return this.locale(key);
          }
        }
      );
      function localeData() {
        return this._locale;
      }
      var MS_PER_SECOND = 1e3, MS_PER_MINUTE = 60 * MS_PER_SECOND, MS_PER_HOUR = 60 * MS_PER_MINUTE, MS_PER_400_YEARS = (365 * 400 + 97) * 24 * MS_PER_HOUR;
      function mod$1(dividend, divisor) {
        return (dividend % divisor + divisor) % divisor;
      }
      function localStartOfDate(y, m, d) {
        if (y < 100 && y >= 0) {
          return new Date(y + 400, m, d) - MS_PER_400_YEARS;
        } else {
          return new Date(y, m, d).valueOf();
        }
      }
      function utcStartOfDate(y, m, d) {
        if (y < 100 && y >= 0) {
          return Date.UTC(y + 400, m, d) - MS_PER_400_YEARS;
        } else {
          return Date.UTC(y, m, d);
        }
      }
      function startOf(units) {
        var time, startOfDate;
        units = normalizeUnits(units);
        if (units === void 0 || units === "millisecond" || !this.isValid()) {
          return this;
        }
        startOfDate = this._isUTC ? utcStartOfDate : localStartOfDate;
        switch (units) {
          case "year":
            time = startOfDate(this.year(), 0, 1);
            break;
          case "quarter":
            time = startOfDate(
              this.year(),
              this.month() - this.month() % 3,
              1
            );
            break;
          case "month":
            time = startOfDate(this.year(), this.month(), 1);
            break;
          case "week":
            time = startOfDate(
              this.year(),
              this.month(),
              this.date() - this.weekday()
            );
            break;
          case "isoWeek":
            time = startOfDate(
              this.year(),
              this.month(),
              this.date() - (this.isoWeekday() - 1)
            );
            break;
          case "day":
          case "date":
            time = startOfDate(this.year(), this.month(), this.date());
            break;
          case "hour":
            time = this._d.valueOf();
            time -= mod$1(
              time + (this._isUTC ? 0 : this.utcOffset() * MS_PER_MINUTE),
              MS_PER_HOUR
            );
            break;
          case "minute":
            time = this._d.valueOf();
            time -= mod$1(time, MS_PER_MINUTE);
            break;
          case "second":
            time = this._d.valueOf();
            time -= mod$1(time, MS_PER_SECOND);
            break;
        }
        this._d.setTime(time);
        hooks.updateOffset(this, true);
        return this;
      }
      function endOf(units) {
        var time, startOfDate;
        units = normalizeUnits(units);
        if (units === void 0 || units === "millisecond" || !this.isValid()) {
          return this;
        }
        startOfDate = this._isUTC ? utcStartOfDate : localStartOfDate;
        switch (units) {
          case "year":
            time = startOfDate(this.year() + 1, 0, 1) - 1;
            break;
          case "quarter":
            time = startOfDate(
              this.year(),
              this.month() - this.month() % 3 + 3,
              1
            ) - 1;
            break;
          case "month":
            time = startOfDate(this.year(), this.month() + 1, 1) - 1;
            break;
          case "week":
            time = startOfDate(
              this.year(),
              this.month(),
              this.date() - this.weekday() + 7
            ) - 1;
            break;
          case "isoWeek":
            time = startOfDate(
              this.year(),
              this.month(),
              this.date() - (this.isoWeekday() - 1) + 7
            ) - 1;
            break;
          case "day":
          case "date":
            time = startOfDate(this.year(), this.month(), this.date() + 1) - 1;
            break;
          case "hour":
            time = this._d.valueOf();
            time += MS_PER_HOUR - mod$1(
              time + (this._isUTC ? 0 : this.utcOffset() * MS_PER_MINUTE),
              MS_PER_HOUR
            ) - 1;
            break;
          case "minute":
            time = this._d.valueOf();
            time += MS_PER_MINUTE - mod$1(time, MS_PER_MINUTE) - 1;
            break;
          case "second":
            time = this._d.valueOf();
            time += MS_PER_SECOND - mod$1(time, MS_PER_SECOND) - 1;
            break;
        }
        this._d.setTime(time);
        hooks.updateOffset(this, true);
        return this;
      }
      function valueOf() {
        return this._d.valueOf() - (this._offset || 0) * 6e4;
      }
      function unix() {
        return Math.floor(this.valueOf() / 1e3);
      }
      function toDate() {
        return new Date(this.valueOf());
      }
      function toArray() {
        var m = this;
        return [
          m.year(),
          m.month(),
          m.date(),
          m.hour(),
          m.minute(),
          m.second(),
          m.millisecond()
        ];
      }
      function toObject() {
        var m = this;
        return {
          years: m.year(),
          months: m.month(),
          date: m.date(),
          hours: m.hours(),
          minutes: m.minutes(),
          seconds: m.seconds(),
          milliseconds: m.milliseconds()
        };
      }
      function toJSON() {
        return this.isValid() ? this.toISOString() : null;
      }
      function isValid$2() {
        return isValid(this);
      }
      function parsingFlags() {
        return extend({}, getParsingFlags(this));
      }
      function invalidAt() {
        return getParsingFlags(this).overflow;
      }
      function creationData() {
        return {
          input: this._i,
          format: this._f,
          locale: this._locale,
          isUTC: this._isUTC,
          strict: this._strict
        };
      }
      addFormatToken("N", 0, 0, "eraAbbr");
      addFormatToken("NN", 0, 0, "eraAbbr");
      addFormatToken("NNN", 0, 0, "eraAbbr");
      addFormatToken("NNNN", 0, 0, "eraName");
      addFormatToken("NNNNN", 0, 0, "eraNarrow");
      addFormatToken("y", ["y", 1], "yo", "eraYear");
      addFormatToken("y", ["yy", 2], 0, "eraYear");
      addFormatToken("y", ["yyy", 3], 0, "eraYear");
      addFormatToken("y", ["yyyy", 4], 0, "eraYear");
      addRegexToken("N", matchEraAbbr);
      addRegexToken("NN", matchEraAbbr);
      addRegexToken("NNN", matchEraAbbr);
      addRegexToken("NNNN", matchEraName);
      addRegexToken("NNNNN", matchEraNarrow);
      addParseToken(
        ["N", "NN", "NNN", "NNNN", "NNNNN"],
        function(input, array, config2, token2) {
          var era = config2._locale.erasParse(input, token2, config2._strict);
          if (era) {
            getParsingFlags(config2).era = era;
          } else {
            getParsingFlags(config2).invalidEra = input;
          }
        }
      );
      addRegexToken("y", matchUnsigned);
      addRegexToken("yy", matchUnsigned);
      addRegexToken("yyy", matchUnsigned);
      addRegexToken("yyyy", matchUnsigned);
      addRegexToken("yo", matchEraYearOrdinal);
      addParseToken(["y", "yy", "yyy", "yyyy"], YEAR);
      addParseToken(["yo"], function(input, array, config2, token2) {
        var match;
        if (config2._locale._eraYearOrdinalRegex) {
          match = input.match(config2._locale._eraYearOrdinalRegex);
        }
        if (config2._locale.eraYearOrdinalParse) {
          array[YEAR] = config2._locale.eraYearOrdinalParse(input, match);
        } else {
          array[YEAR] = parseInt(input, 10);
        }
      });
      function localeEras(m, format2) {
        var i, l, date, eras = this._eras || getLocale("en")._eras;
        for (i = 0, l = eras.length; i < l; ++i) {
          switch (typeof eras[i].since) {
            case "string":
              date = hooks(eras[i].since).startOf("day");
              eras[i].since = date.valueOf();
              break;
          }
          switch (typeof eras[i].until) {
            case "undefined":
              eras[i].until = Infinity;
              break;
            case "string":
              date = hooks(eras[i].until).startOf("day").valueOf();
              eras[i].until = date.valueOf();
              break;
          }
        }
        return eras;
      }
      function localeErasParse(eraName, format2, strict) {
        var i, l, eras = this.eras(), name, abbr, narrow;
        eraName = eraName.toUpperCase();
        for (i = 0, l = eras.length; i < l; ++i) {
          name = eras[i].name.toUpperCase();
          abbr = eras[i].abbr.toUpperCase();
          narrow = eras[i].narrow.toUpperCase();
          if (strict) {
            switch (format2) {
              case "N":
              case "NN":
              case "NNN":
                if (abbr === eraName) {
                  return eras[i];
                }
                break;
              case "NNNN":
                if (name === eraName) {
                  return eras[i];
                }
                break;
              case "NNNNN":
                if (narrow === eraName) {
                  return eras[i];
                }
                break;
            }
          } else if ([name, abbr, narrow].indexOf(eraName) >= 0) {
            return eras[i];
          }
        }
      }
      function localeErasConvertYear(era, year) {
        var dir = era.since <= era.until ? 1 : -1;
        if (year === void 0) {
          return hooks(era.since).year();
        } else {
          return hooks(era.since).year() + (year - era.offset) * dir;
        }
      }
      function getEraName() {
        var i, l, val, eras = this.localeData().eras();
        for (i = 0, l = eras.length; i < l; ++i) {
          val = this.clone().startOf("day").valueOf();
          if (eras[i].since <= val && val <= eras[i].until) {
            return eras[i].name;
          }
          if (eras[i].until <= val && val <= eras[i].since) {
            return eras[i].name;
          }
        }
        return "";
      }
      function getEraNarrow() {
        var i, l, val, eras = this.localeData().eras();
        for (i = 0, l = eras.length; i < l; ++i) {
          val = this.clone().startOf("day").valueOf();
          if (eras[i].since <= val && val <= eras[i].until) {
            return eras[i].narrow;
          }
          if (eras[i].until <= val && val <= eras[i].since) {
            return eras[i].narrow;
          }
        }
        return "";
      }
      function getEraAbbr() {
        var i, l, val, eras = this.localeData().eras();
        for (i = 0, l = eras.length; i < l; ++i) {
          val = this.clone().startOf("day").valueOf();
          if (eras[i].since <= val && val <= eras[i].until) {
            return eras[i].abbr;
          }
          if (eras[i].until <= val && val <= eras[i].since) {
            return eras[i].abbr;
          }
        }
        return "";
      }
      function getEraYear() {
        var i, l, dir, val, eras = this.localeData().eras();
        for (i = 0, l = eras.length; i < l; ++i) {
          dir = eras[i].since <= eras[i].until ? 1 : -1;
          val = this.clone().startOf("day").valueOf();
          if (eras[i].since <= val && val <= eras[i].until || eras[i].until <= val && val <= eras[i].since) {
            return (this.year() - hooks(eras[i].since).year()) * dir + eras[i].offset;
          }
        }
        return this.year();
      }
      function erasNameRegex(isStrict) {
        if (!hasOwnProp(this, "_erasNameRegex")) {
          computeErasParse.call(this);
        }
        return isStrict ? this._erasNameRegex : this._erasRegex;
      }
      function erasAbbrRegex(isStrict) {
        if (!hasOwnProp(this, "_erasAbbrRegex")) {
          computeErasParse.call(this);
        }
        return isStrict ? this._erasAbbrRegex : this._erasRegex;
      }
      function erasNarrowRegex(isStrict) {
        if (!hasOwnProp(this, "_erasNarrowRegex")) {
          computeErasParse.call(this);
        }
        return isStrict ? this._erasNarrowRegex : this._erasRegex;
      }
      function matchEraAbbr(isStrict, locale2) {
        return locale2.erasAbbrRegex(isStrict);
      }
      function matchEraName(isStrict, locale2) {
        return locale2.erasNameRegex(isStrict);
      }
      function matchEraNarrow(isStrict, locale2) {
        return locale2.erasNarrowRegex(isStrict);
      }
      function matchEraYearOrdinal(isStrict, locale2) {
        return locale2._eraYearOrdinalRegex || matchUnsigned;
      }
      function computeErasParse() {
        var abbrPieces = [], namePieces = [], narrowPieces = [], mixedPieces = [], i, l, erasName, erasAbbr, erasNarrow, eras = this.eras();
        for (i = 0, l = eras.length; i < l; ++i) {
          erasName = regexEscape(eras[i].name);
          erasAbbr = regexEscape(eras[i].abbr);
          erasNarrow = regexEscape(eras[i].narrow);
          namePieces.push(erasName);
          abbrPieces.push(erasAbbr);
          narrowPieces.push(erasNarrow);
          mixedPieces.push(erasName);
          mixedPieces.push(erasAbbr);
          mixedPieces.push(erasNarrow);
        }
        this._erasRegex = new RegExp("^(" + mixedPieces.join("|") + ")", "i");
        this._erasNameRegex = new RegExp("^(" + namePieces.join("|") + ")", "i");
        this._erasAbbrRegex = new RegExp("^(" + abbrPieces.join("|") + ")", "i");
        this._erasNarrowRegex = new RegExp(
          "^(" + narrowPieces.join("|") + ")",
          "i"
        );
      }
      addFormatToken(0, ["gg", 2], 0, function() {
        return this.weekYear() % 100;
      });
      addFormatToken(0, ["GG", 2], 0, function() {
        return this.isoWeekYear() % 100;
      });
      function addWeekYearFormatToken(token2, getter) {
        addFormatToken(0, [token2, token2.length], 0, getter);
      }
      addWeekYearFormatToken("gggg", "weekYear");
      addWeekYearFormatToken("ggggg", "weekYear");
      addWeekYearFormatToken("GGGG", "isoWeekYear");
      addWeekYearFormatToken("GGGGG", "isoWeekYear");
      addRegexToken("G", matchSigned);
      addRegexToken("g", matchSigned);
      addRegexToken("GG", match1to2, match2);
      addRegexToken("gg", match1to2, match2);
      addRegexToken("GGGG", match1to4, match4);
      addRegexToken("gggg", match1to4, match4);
      addRegexToken("GGGGG", match1to6, match6);
      addRegexToken("ggggg", match1to6, match6);
      addWeekParseToken(
        ["gggg", "ggggg", "GGGG", "GGGGG"],
        function(input, week, config2, token2) {
          week[token2.substr(0, 2)] = toInt(input);
        }
      );
      addWeekParseToken(["gg", "GG"], function(input, week, config2, token2) {
        week[token2] = hooks.parseTwoDigitYear(input);
      });
      function getSetWeekYear(input) {
        return getSetWeekYearHelper.call(
          this,
          input,
          this.week(),
          this.weekday() + this.localeData()._week.dow,
          this.localeData()._week.dow,
          this.localeData()._week.doy
        );
      }
      function getSetISOWeekYear(input) {
        return getSetWeekYearHelper.call(
          this,
          input,
          this.isoWeek(),
          this.isoWeekday(),
          1,
          4
        );
      }
      function getISOWeeksInYear() {
        return weeksInYear(this.year(), 1, 4);
      }
      function getISOWeeksInISOWeekYear() {
        return weeksInYear(this.isoWeekYear(), 1, 4);
      }
      function getWeeksInYear() {
        var weekInfo = this.localeData()._week;
        return weeksInYear(this.year(), weekInfo.dow, weekInfo.doy);
      }
      function getWeeksInWeekYear() {
        var weekInfo = this.localeData()._week;
        return weeksInYear(this.weekYear(), weekInfo.dow, weekInfo.doy);
      }
      function getSetWeekYearHelper(input, week, weekday, dow, doy) {
        var weeksTarget;
        if (input == null) {
          return weekOfYear(this, dow, doy).year;
        } else {
          weeksTarget = weeksInYear(input, dow, doy);
          if (week > weeksTarget) {
            week = weeksTarget;
          }
          return setWeekAll.call(this, input, week, weekday, dow, doy);
        }
      }
      function setWeekAll(weekYear, week, weekday, dow, doy) {
        var dayOfYearData = dayOfYearFromWeeks(weekYear, week, weekday, dow, doy), date = createUTCDate(dayOfYearData.year, 0, dayOfYearData.dayOfYear);
        this.year(date.getUTCFullYear());
        this.month(date.getUTCMonth());
        this.date(date.getUTCDate());
        return this;
      }
      addFormatToken("Q", 0, "Qo", "quarter");
      addRegexToken("Q", match1);
      addParseToken("Q", function(input, array) {
        array[MONTH] = (toInt(input) - 1) * 3;
      });
      function getSetQuarter(input) {
        return input == null ? Math.ceil((this.month() + 1) / 3) : this.month((input - 1) * 3 + this.month() % 3);
      }
      addFormatToken("D", ["DD", 2], "Do", "date");
      addRegexToken("D", match1to2, match1to2NoLeadingZero);
      addRegexToken("DD", match1to2, match2);
      addRegexToken("Do", function(isStrict, locale2) {
        return isStrict ? locale2._dayOfMonthOrdinalParse || locale2._ordinalParse : locale2._dayOfMonthOrdinalParseLenient;
      });
      addParseToken(["D", "DD"], DATE);
      addParseToken("Do", function(input, array) {
        array[DATE] = toInt(input.match(match1to2)[0]);
      });
      var getSetDayOfMonth = makeGetSet("Date", true);
      addFormatToken("DDD", ["DDDD", 3], "DDDo", "dayOfYear");
      addRegexToken("DDD", match1to3);
      addRegexToken("DDDD", match3);
      addParseToken(["DDD", "DDDD"], function(input, array, config2) {
        config2._dayOfYear = toInt(input);
      });
      function getSetDayOfYear(input) {
        var dayOfYear = Math.round(
          (this.clone().startOf("day") - this.clone().startOf("year")) / 864e5
        ) + 1;
        return input == null ? dayOfYear : this.add(input - dayOfYear, "d");
      }
      addFormatToken("m", ["mm", 2], 0, "minute");
      addRegexToken("m", match1to2, match1to2HasZero);
      addRegexToken("mm", match1to2, match2);
      addParseToken(["m", "mm"], MINUTE);
      var getSetMinute = makeGetSet("Minutes", false);
      addFormatToken("s", ["ss", 2], 0, "second");
      addRegexToken("s", match1to2, match1to2HasZero);
      addRegexToken("ss", match1to2, match2);
      addParseToken(["s", "ss"], SECOND);
      var getSetSecond = makeGetSet("Seconds", false);
      addFormatToken("S", 0, 0, function() {
        return ~~(this.millisecond() / 100);
      });
      addFormatToken(0, ["SS", 2], 0, function() {
        return ~~(this.millisecond() / 10);
      });
      addFormatToken(0, ["SSS", 3], 0, "millisecond");
      addFormatToken(0, ["SSSS", 4], 0, function() {
        return this.millisecond() * 10;
      });
      addFormatToken(0, ["SSSSS", 5], 0, function() {
        return this.millisecond() * 100;
      });
      addFormatToken(0, ["SSSSSS", 6], 0, function() {
        return this.millisecond() * 1e3;
      });
      addFormatToken(0, ["SSSSSSS", 7], 0, function() {
        return this.millisecond() * 1e4;
      });
      addFormatToken(0, ["SSSSSSSS", 8], 0, function() {
        return this.millisecond() * 1e5;
      });
      addFormatToken(0, ["SSSSSSSSS", 9], 0, function() {
        return this.millisecond() * 1e6;
      });
      addRegexToken("S", match1to3, match1);
      addRegexToken("SS", match1to3, match2);
      addRegexToken("SSS", match1to3, match3);
      var token, getSetMillisecond;
      for (token = "SSSS"; token.length <= 9; token += "S") {
        addRegexToken(token, matchUnsigned);
      }
      function parseMs(input, array) {
        array[MILLISECOND] = toInt(("0." + input) * 1e3);
      }
      for (token = "S"; token.length <= 9; token += "S") {
        addParseToken(token, parseMs);
      }
      getSetMillisecond = makeGetSet("Milliseconds", false);
      addFormatToken("z", 0, 0, "zoneAbbr");
      addFormatToken("zz", 0, 0, "zoneName");
      function getZoneAbbr() {
        return this._isUTC ? "UTC" : "";
      }
      function getZoneName() {
        return this._isUTC ? "Coordinated Universal Time" : "";
      }
      var proto = Moment.prototype;
      proto.add = add;
      proto.calendar = calendar$1;
      proto.clone = clone;
      proto.diff = diff;
      proto.endOf = endOf;
      proto.format = format;
      proto.from = from;
      proto.fromNow = fromNow;
      proto.to = to;
      proto.toNow = toNow;
      proto.get = stringGet;
      proto.invalidAt = invalidAt;
      proto.isAfter = isAfter;
      proto.isBefore = isBefore;
      proto.isBetween = isBetween;
      proto.isSame = isSame;
      proto.isSameOrAfter = isSameOrAfter;
      proto.isSameOrBefore = isSameOrBefore;
      proto.isValid = isValid$2;
      proto.lang = lang;
      proto.locale = locale;
      proto.localeData = localeData;
      proto.max = prototypeMax;
      proto.min = prototypeMin;
      proto.parsingFlags = parsingFlags;
      proto.set = stringSet;
      proto.startOf = startOf;
      proto.subtract = subtract;
      proto.toArray = toArray;
      proto.toObject = toObject;
      proto.toDate = toDate;
      proto.toISOString = toISOString;
      proto.inspect = inspect;
      if (typeof Symbol !== "undefined" && Symbol.for != null) {
        proto[/* @__PURE__ */ Symbol.for("nodejs.util.inspect.custom")] = function() {
          return "Moment<" + this.format() + ">";
        };
      }
      proto.toJSON = toJSON;
      proto.toString = toString;
      proto.unix = unix;
      proto.valueOf = valueOf;
      proto.creationData = creationData;
      proto.eraName = getEraName;
      proto.eraNarrow = getEraNarrow;
      proto.eraAbbr = getEraAbbr;
      proto.eraYear = getEraYear;
      proto.year = getSetYear;
      proto.isLeapYear = getIsLeapYear;
      proto.weekYear = getSetWeekYear;
      proto.isoWeekYear = getSetISOWeekYear;
      proto.quarter = proto.quarters = getSetQuarter;
      proto.month = getSetMonth;
      proto.daysInMonth = getDaysInMonth;
      proto.week = proto.weeks = getSetWeek;
      proto.isoWeek = proto.isoWeeks = getSetISOWeek;
      proto.weeksInYear = getWeeksInYear;
      proto.weeksInWeekYear = getWeeksInWeekYear;
      proto.isoWeeksInYear = getISOWeeksInYear;
      proto.isoWeeksInISOWeekYear = getISOWeeksInISOWeekYear;
      proto.date = getSetDayOfMonth;
      proto.day = proto.days = getSetDayOfWeek;
      proto.weekday = getSetLocaleDayOfWeek;
      proto.isoWeekday = getSetISODayOfWeek;
      proto.dayOfYear = getSetDayOfYear;
      proto.hour = proto.hours = getSetHour;
      proto.minute = proto.minutes = getSetMinute;
      proto.second = proto.seconds = getSetSecond;
      proto.millisecond = proto.milliseconds = getSetMillisecond;
      proto.utcOffset = getSetOffset;
      proto.utc = setOffsetToUTC;
      proto.local = setOffsetToLocal;
      proto.parseZone = setOffsetToParsedOffset;
      proto.hasAlignedHourOffset = hasAlignedHourOffset;
      proto.isDST = isDaylightSavingTime;
      proto.isLocal = isLocal;
      proto.isUtcOffset = isUtcOffset;
      proto.isUtc = isUtc;
      proto.isUTC = isUtc;
      proto.zoneAbbr = getZoneAbbr;
      proto.zoneName = getZoneName;
      proto.dates = deprecate(
        "dates accessor is deprecated. Use date instead.",
        getSetDayOfMonth
      );
      proto.months = deprecate(
        "months accessor is deprecated. Use month instead",
        getSetMonth
      );
      proto.years = deprecate(
        "years accessor is deprecated. Use year instead",
        getSetYear
      );
      proto.zone = deprecate(
        "moment().zone is deprecated, use moment().utcOffset instead. http://momentjs.com/guides/#/warnings/zone/",
        getSetZone
      );
      proto.isDSTShifted = deprecate(
        "isDSTShifted is deprecated. See http://momentjs.com/guides/#/warnings/dst-shifted/ for more information",
        isDaylightSavingTimeShifted
      );
      function createUnix(input) {
        return createLocal(input * 1e3);
      }
      function createInZone() {
        return createLocal.apply(null, arguments).parseZone();
      }
      function preParsePostFormat(string) {
        return string;
      }
      var proto$1 = Locale.prototype;
      proto$1.calendar = calendar;
      proto$1.longDateFormat = longDateFormat;
      proto$1.invalidDate = invalidDate;
      proto$1.ordinal = ordinal;
      proto$1.preparse = preParsePostFormat;
      proto$1.postformat = preParsePostFormat;
      proto$1.relativeTime = relativeTime;
      proto$1.pastFuture = pastFuture;
      proto$1.set = set;
      proto$1.eras = localeEras;
      proto$1.erasParse = localeErasParse;
      proto$1.erasConvertYear = localeErasConvertYear;
      proto$1.erasAbbrRegex = erasAbbrRegex;
      proto$1.erasNameRegex = erasNameRegex;
      proto$1.erasNarrowRegex = erasNarrowRegex;
      proto$1.months = localeMonths;
      proto$1.monthsShort = localeMonthsShort;
      proto$1.monthsParse = localeMonthsParse;
      proto$1.monthsRegex = monthsRegex;
      proto$1.monthsShortRegex = monthsShortRegex;
      proto$1.week = localeWeek;
      proto$1.firstDayOfYear = localeFirstDayOfYear;
      proto$1.firstDayOfWeek = localeFirstDayOfWeek;
      proto$1.weekdays = localeWeekdays;
      proto$1.weekdaysMin = localeWeekdaysMin;
      proto$1.weekdaysShort = localeWeekdaysShort;
      proto$1.weekdaysParse = localeWeekdaysParse;
      proto$1.weekdaysRegex = weekdaysRegex;
      proto$1.weekdaysShortRegex = weekdaysShortRegex;
      proto$1.weekdaysMinRegex = weekdaysMinRegex;
      proto$1.isPM = localeIsPM;
      proto$1.meridiem = localeMeridiem;
      function get$1(format2, index, field, setter) {
        var locale2 = getLocale(), utc = createUTC().set(setter, index);
        return locale2[field](utc, format2);
      }
      function listMonthsImpl(format2, index, field) {
        if (isNumber(format2)) {
          index = format2;
          format2 = void 0;
        }
        format2 = format2 || "";
        if (index != null) {
          return get$1(format2, index, field, "month");
        }
        var i, out = [];
        for (i = 0; i < 12; i++) {
          out[i] = get$1(format2, i, field, "month");
        }
        return out;
      }
      function listWeekdaysImpl(localeSorted, format2, index, field) {
        if (typeof localeSorted === "boolean") {
          if (isNumber(format2)) {
            index = format2;
            format2 = void 0;
          }
          format2 = format2 || "";
        } else {
          format2 = localeSorted;
          index = format2;
          localeSorted = false;
          if (isNumber(format2)) {
            index = format2;
            format2 = void 0;
          }
          format2 = format2 || "";
        }
        var locale2 = getLocale(), shift = localeSorted ? locale2._week.dow : 0, i, out = [];
        if (index != null) {
          return get$1(format2, (index + shift) % 7, field, "day");
        }
        for (i = 0; i < 7; i++) {
          out[i] = get$1(format2, (i + shift) % 7, field, "day");
        }
        return out;
      }
      function listMonths(format2, index) {
        return listMonthsImpl(format2, index, "months");
      }
      function listMonthsShort(format2, index) {
        return listMonthsImpl(format2, index, "monthsShort");
      }
      function listWeekdays(localeSorted, format2, index) {
        return listWeekdaysImpl(localeSorted, format2, index, "weekdays");
      }
      function listWeekdaysShort(localeSorted, format2, index) {
        return listWeekdaysImpl(localeSorted, format2, index, "weekdaysShort");
      }
      function listWeekdaysMin(localeSorted, format2, index) {
        return listWeekdaysImpl(localeSorted, format2, index, "weekdaysMin");
      }
      getSetGlobalLocale("en", {
        eras: [
          {
            since: "0001-01-01",
            until: Infinity,
            offset: 1,
            name: "Anno Domini",
            narrow: "AD",
            abbr: "AD"
          },
          {
            since: "0000-12-31",
            until: -Infinity,
            offset: 1,
            name: "Before Christ",
            narrow: "BC",
            abbr: "BC"
          }
        ],
        dayOfMonthOrdinalParse: /\d{1,2}(th|st|nd|rd)/,
        ordinal: function(number) {
          var b = number % 10, output = toInt(number % 100 / 10) === 1 ? "th" : b === 1 ? "st" : b === 2 ? "nd" : b === 3 ? "rd" : "th";
          return number + output;
        }
      });
      hooks.lang = deprecate(
        "moment.lang is deprecated. Use moment.locale instead.",
        getSetGlobalLocale
      );
      hooks.langData = deprecate(
        "moment.langData is deprecated. Use moment.localeData instead.",
        getLocale
      );
      var mathAbs = Math.abs;
      function abs() {
        var data = this._data;
        this._milliseconds = mathAbs(this._milliseconds);
        this._days = mathAbs(this._days);
        this._months = mathAbs(this._months);
        data.milliseconds = mathAbs(data.milliseconds);
        data.seconds = mathAbs(data.seconds);
        data.minutes = mathAbs(data.minutes);
        data.hours = mathAbs(data.hours);
        data.months = mathAbs(data.months);
        data.years = mathAbs(data.years);
        return this;
      }
      function addSubtract$1(duration, input, value, direction) {
        var other = createDuration(input, value);
        duration._milliseconds += direction * other._milliseconds;
        duration._days += direction * other._days;
        duration._months += direction * other._months;
        return duration._bubble();
      }
      function add$1(input, value) {
        return addSubtract$1(this, input, value, 1);
      }
      function subtract$1(input, value) {
        return addSubtract$1(this, input, value, -1);
      }
      function absCeil(number) {
        if (number < 0) {
          return Math.floor(number);
        } else {
          return Math.ceil(number);
        }
      }
      function bubble() {
        var milliseconds2 = this._milliseconds, days2 = this._days, months2 = this._months, data = this._data, seconds2, minutes2, hours2, years2, monthsFromDays;
        if (!(milliseconds2 >= 0 && days2 >= 0 && months2 >= 0 || milliseconds2 <= 0 && days2 <= 0 && months2 <= 0)) {
          milliseconds2 += absCeil(monthsToDays(months2) + days2) * 864e5;
          days2 = 0;
          months2 = 0;
        }
        data.milliseconds = milliseconds2 % 1e3;
        seconds2 = absFloor(milliseconds2 / 1e3);
        data.seconds = seconds2 % 60;
        minutes2 = absFloor(seconds2 / 60);
        data.minutes = minutes2 % 60;
        hours2 = absFloor(minutes2 / 60);
        data.hours = hours2 % 24;
        days2 += absFloor(hours2 / 24);
        monthsFromDays = absFloor(daysToMonths(days2));
        months2 += monthsFromDays;
        days2 -= absCeil(monthsToDays(monthsFromDays));
        years2 = absFloor(months2 / 12);
        months2 %= 12;
        data.days = days2;
        data.months = months2;
        data.years = years2;
        return this;
      }
      function daysToMonths(days2) {
        return days2 * 4800 / 146097;
      }
      function monthsToDays(months2) {
        return months2 * 146097 / 4800;
      }
      function as(units) {
        if (!this.isValid()) {
          return NaN;
        }
        var days2, months2, milliseconds2 = this._milliseconds;
        units = normalizeUnits(units);
        if (units === "month" || units === "quarter" || units === "year") {
          days2 = this._days + milliseconds2 / 864e5;
          months2 = this._months + daysToMonths(days2);
          switch (units) {
            case "month":
              return months2;
            case "quarter":
              return months2 / 3;
            case "year":
              return months2 / 12;
          }
        } else {
          days2 = this._days + Math.round(monthsToDays(this._months));
          switch (units) {
            case "week":
              return days2 / 7 + milliseconds2 / 6048e5;
            case "day":
              return days2 + milliseconds2 / 864e5;
            case "hour":
              return days2 * 24 + milliseconds2 / 36e5;
            case "minute":
              return days2 * 1440 + milliseconds2 / 6e4;
            case "second":
              return days2 * 86400 + milliseconds2 / 1e3;
            // Math.floor prevents floating point math errors here
            case "millisecond":
              return Math.floor(days2 * 864e5) + milliseconds2;
            default:
              throw new Error("Unknown unit " + units);
          }
        }
      }
      function makeAs(alias) {
        return function() {
          return this.as(alias);
        };
      }
      var asMilliseconds = makeAs("ms"), asSeconds = makeAs("s"), asMinutes = makeAs("m"), asHours = makeAs("h"), asDays = makeAs("d"), asWeeks = makeAs("w"), asMonths = makeAs("M"), asQuarters = makeAs("Q"), asYears = makeAs("y"), valueOf$1 = asMilliseconds;
      function clone$1() {
        return createDuration(this);
      }
      function get$2(units) {
        units = normalizeUnits(units);
        return this.isValid() ? this[units + "s"]() : NaN;
      }
      function makeGetter(name) {
        return function() {
          return this.isValid() ? this._data[name] : NaN;
        };
      }
      var milliseconds = makeGetter("milliseconds"), seconds = makeGetter("seconds"), minutes = makeGetter("minutes"), hours = makeGetter("hours"), days = makeGetter("days"), months = makeGetter("months"), years = makeGetter("years");
      function weeks() {
        return absFloor(this.days() / 7);
      }
      var round = Math.round, thresholds = {
        ss: 44,
        // a few seconds to seconds
        s: 45,
        // seconds to minute
        m: 45,
        // minutes to hour
        h: 22,
        // hours to day
        d: 26,
        // days to month/week
        w: null,
        // weeks to month
        M: 11
        // months to year
      };
      function substituteTimeAgo(string, number, withoutSuffix, isFuture, locale2) {
        return locale2.relativeTime(number || 1, !!withoutSuffix, string, isFuture);
      }
      function relativeTime$1(posNegDuration, withoutSuffix, thresholds2, locale2) {
        var duration = createDuration(posNegDuration).abs(), seconds2 = round(duration.as("s")), minutes2 = round(duration.as("m")), hours2 = round(duration.as("h")), days2 = round(duration.as("d")), months2 = round(duration.as("M")), weeks2 = round(duration.as("w")), years2 = round(duration.as("y")), a = seconds2 <= thresholds2.ss && ["s", seconds2] || seconds2 < thresholds2.s && ["ss", seconds2] || minutes2 <= 1 && ["m"] || minutes2 < thresholds2.m && ["mm", minutes2] || hours2 <= 1 && ["h"] || hours2 < thresholds2.h && ["hh", hours2] || days2 <= 1 && ["d"] || days2 < thresholds2.d && ["dd", days2];
        if (thresholds2.w != null) {
          a = a || weeks2 <= 1 && ["w"] || weeks2 < thresholds2.w && ["ww", weeks2];
        }
        a = a || months2 <= 1 && ["M"] || months2 < thresholds2.M && ["MM", months2] || years2 <= 1 && ["y"] || ["yy", years2];
        a[2] = withoutSuffix;
        a[3] = +posNegDuration > 0;
        a[4] = locale2;
        return substituteTimeAgo.apply(null, a);
      }
      function getSetRelativeTimeRounding(roundingFunction) {
        if (roundingFunction === void 0) {
          return round;
        }
        if (typeof roundingFunction === "function") {
          round = roundingFunction;
          return true;
        }
        return false;
      }
      function getSetRelativeTimeThreshold(threshold, limit) {
        if (thresholds[threshold] === void 0) {
          return false;
        }
        if (limit === void 0) {
          return thresholds[threshold];
        }
        thresholds[threshold] = limit;
        if (threshold === "s") {
          thresholds.ss = limit - 1;
        }
        return true;
      }
      function humanize(argWithSuffix, argThresholds) {
        if (!this.isValid()) {
          return this.localeData().invalidDate();
        }
        var withSuffix = false, th = thresholds, locale2, output;
        if (typeof argWithSuffix === "object") {
          argThresholds = argWithSuffix;
          argWithSuffix = false;
        }
        if (typeof argWithSuffix === "boolean") {
          withSuffix = argWithSuffix;
        }
        if (typeof argThresholds === "object") {
          th = Object.assign({}, thresholds, argThresholds);
          if (argThresholds.s != null && argThresholds.ss == null) {
            th.ss = argThresholds.s - 1;
          }
        }
        locale2 = this.localeData();
        output = relativeTime$1(this, !withSuffix, th, locale2);
        if (withSuffix) {
          output = locale2.pastFuture(+this, output);
        }
        return locale2.postformat(output);
      }
      var abs$1 = Math.abs;
      function sign(x) {
        return (x > 0) - (x < 0) || +x;
      }
      function toISOString$1() {
        if (!this.isValid()) {
          return this.localeData().invalidDate();
        }
        var seconds2 = abs$1(this._milliseconds) / 1e3, days2 = abs$1(this._days), months2 = abs$1(this._months), minutes2, hours2, years2, s, total = this.asSeconds(), totalSign, ymSign, daysSign, hmsSign;
        if (!total) {
          return "P0D";
        }
        minutes2 = absFloor(seconds2 / 60);
        hours2 = absFloor(minutes2 / 60);
        seconds2 %= 60;
        minutes2 %= 60;
        years2 = absFloor(months2 / 12);
        months2 %= 12;
        s = seconds2 ? seconds2.toFixed(3).replace(/\.?0+$/, "") : "";
        totalSign = total < 0 ? "-" : "";
        ymSign = sign(this._months) !== sign(total) ? "-" : "";
        daysSign = sign(this._days) !== sign(total) ? "-" : "";
        hmsSign = sign(this._milliseconds) !== sign(total) ? "-" : "";
        return totalSign + "P" + (years2 ? ymSign + years2 + "Y" : "") + (months2 ? ymSign + months2 + "M" : "") + (days2 ? daysSign + days2 + "D" : "") + (hours2 || minutes2 || seconds2 ? "T" : "") + (hours2 ? hmsSign + hours2 + "H" : "") + (minutes2 ? hmsSign + minutes2 + "M" : "") + (seconds2 ? hmsSign + s + "S" : "");
      }
      var proto$2 = Duration.prototype;
      proto$2.isValid = isValid$1;
      proto$2.abs = abs;
      proto$2.add = add$1;
      proto$2.subtract = subtract$1;
      proto$2.as = as;
      proto$2.asMilliseconds = asMilliseconds;
      proto$2.asSeconds = asSeconds;
      proto$2.asMinutes = asMinutes;
      proto$2.asHours = asHours;
      proto$2.asDays = asDays;
      proto$2.asWeeks = asWeeks;
      proto$2.asMonths = asMonths;
      proto$2.asQuarters = asQuarters;
      proto$2.asYears = asYears;
      proto$2.valueOf = valueOf$1;
      proto$2._bubble = bubble;
      proto$2.clone = clone$1;
      proto$2.get = get$2;
      proto$2.milliseconds = milliseconds;
      proto$2.seconds = seconds;
      proto$2.minutes = minutes;
      proto$2.hours = hours;
      proto$2.days = days;
      proto$2.weeks = weeks;
      proto$2.months = months;
      proto$2.years = years;
      proto$2.humanize = humanize;
      proto$2.toISOString = toISOString$1;
      proto$2.toString = toISOString$1;
      proto$2.toJSON = toISOString$1;
      proto$2.locale = locale;
      proto$2.localeData = localeData;
      proto$2.toIsoString = deprecate(
        "toIsoString() is deprecated. Please use toISOString() instead (notice the capitals)",
        toISOString$1
      );
      proto$2.lang = lang;
      addFormatToken("X", 0, 0, "unix");
      addFormatToken("x", 0, 0, "valueOf");
      addRegexToken("x", matchSigned);
      addRegexToken("X", matchTimestamp);
      addParseToken("X", function(input, array, config2) {
        config2._d = new Date(parseFloat(input) * 1e3);
      });
      addParseToken("x", function(input, array, config2) {
        config2._d = new Date(toInt(input));
      });
      hooks.version = "2.30.1";
      setHookCallback(createLocal);
      hooks.fn = proto;
      hooks.min = min;
      hooks.max = max;
      hooks.now = now;
      hooks.utc = createUTC;
      hooks.unix = createUnix;
      hooks.months = listMonths;
      hooks.isDate = isDate;
      hooks.locale = getSetGlobalLocale;
      hooks.invalid = createInvalid;
      hooks.duration = createDuration;
      hooks.isMoment = isMoment;
      hooks.weekdays = listWeekdays;
      hooks.parseZone = createInZone;
      hooks.localeData = getLocale;
      hooks.isDuration = isDuration;
      hooks.monthsShort = listMonthsShort;
      hooks.weekdaysMin = listWeekdaysMin;
      hooks.defineLocale = defineLocale;
      hooks.updateLocale = updateLocale;
      hooks.locales = listLocales;
      hooks.weekdaysShort = listWeekdaysShort;
      hooks.normalizeUnits = normalizeUnits;
      hooks.relativeTimeRounding = getSetRelativeTimeRounding;
      hooks.relativeTimeThreshold = getSetRelativeTimeThreshold;
      hooks.calendarFormat = getCalendarFormat;
      hooks.prototype = proto;
      hooks.HTML5_FMT = {
        DATETIME_LOCAL: "YYYY-MM-DDTHH:mm",
        // <input type="datetime-local" />
        DATETIME_LOCAL_SECONDS: "YYYY-MM-DDTHH:mm:ss",
        // <input type="datetime-local" step="1" />
        DATETIME_LOCAL_MS: "YYYY-MM-DDTHH:mm:ss.SSS",
        // <input type="datetime-local" step="0.001" />
        DATE: "YYYY-MM-DD",
        // <input type="date" />
        TIME: "HH:mm",
        // <input type="time" />
        TIME_SECONDS: "HH:mm:ss",
        // <input type="time" step="1" />
        TIME_MS: "HH:mm:ss.SSS",
        // <input type="time" step="0.001" />
        WEEK: "GGGG-[W]WW",
        // <input type="week" />
        MONTH: "YYYY-MM"
        // <input type="month" />
      };
      return hooks;
    }));
  }
});

// node_modules/@darabonba/typescript/dist/date.js
var require_date = __commonJS({
  "node_modules/@darabonba/typescript/dist/date.js"(exports2) {
    "use strict";
    var __importDefault = exports2 && exports2.__importDefault || function(mod) {
      return mod && mod.__esModule ? mod : { "default": mod };
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    var moment_1 = __importDefault(require_moment());
    var TeaDate = (
      /** @class */
      (function() {
        function TeaDate2(date) {
          this.date = (0, moment_1.default)(date);
        }
        TeaDate2.prototype.format = function(layout) {
          layout = layout.replace(/y/g, "Y").replace(/d/g, "D").replace(/h/g, "H").replace(/a/g, "A").replace(/E/g, "d");
          return this.date.format(layout);
        };
        TeaDate2.prototype.unix = function() {
          return this.date.unix();
        };
        TeaDate2.prototype.sub = function(amount, unit) {
          var date = (0, moment_1.default)(this.date).subtract(unit, amount);
          return new TeaDate2(date);
        };
        TeaDate2.prototype.add = function(amount, unit) {
          var date = (0, moment_1.default)(this.date).add(unit, amount);
          return new TeaDate2(date);
        };
        TeaDate2.prototype.diff = function(amount, diffDate) {
          return this.date.diff(diffDate.date, amount);
        };
        TeaDate2.prototype.hour = function() {
          return this.date.hour();
        };
        TeaDate2.prototype.minute = function() {
          return this.date.minute();
        };
        TeaDate2.prototype.second = function() {
          return this.date.second();
        };
        TeaDate2.prototype.month = function() {
          return this.date.month() + 1;
        };
        TeaDate2.prototype.year = function() {
          return this.date.year();
        };
        TeaDate2.prototype.dayOfMonth = function() {
          return this.date.date();
        };
        TeaDate2.prototype.dayOfWeek = function() {
          var weekday = this.date.weekday();
          if (weekday === 0) {
            return 7;
          }
          return weekday + 1;
        };
        TeaDate2.prototype.weekOfMonth = function() {
          var startWeek = (0, moment_1.default)(this.date).startOf("month").week();
          var dateWeek = this.date.week();
          if (this.date.weekday() === 0) {
            dateWeek = dateWeek - 1;
          }
          if (dateWeek === 0 && this.date.date() > 1) {
            return this.sub("day", 1).weekOfMonth();
          }
          var monthWeek = dateWeek - startWeek;
          if (monthWeek < 0) {
            return 1;
          }
          return monthWeek + 1;
        };
        TeaDate2.prototype.weekOfYear = function() {
          var weekday = this.date.weekday();
          var week = this.date.week();
          if (weekday === 0 && week === 1 && this.date.date() > 1) {
            return this.sub("day", 1).weekOfYear();
          }
          return this.date.week();
        };
        return TeaDate2;
      })()
    );
    exports2.default = TeaDate;
  }
});

// node_modules/@darabonba/typescript/dist/file.js
var require_file = __commonJS({
  "node_modules/@darabonba/typescript/dist/file.js"(exports2) {
    "use strict";
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    }) : (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      o[k2] = m[k];
    }));
    var __setModuleDefault = exports2 && exports2.__setModuleDefault || (Object.create ? (function(o, v) {
      Object.defineProperty(o, "default", { enumerable: true, value: v });
    }) : function(o, v) {
      o["default"] = v;
    });
    var __importStar = exports2 && exports2.__importStar || function(mod) {
      if (mod && mod.__esModule) return mod;
      var result = {};
      if (mod != null) {
        for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
      }
      __setModuleDefault(result, mod);
      return result;
    };
    var __awaiter = exports2 && exports2.__awaiter || function(thisArg, _arguments, P, generator) {
      function adopt(value) {
        return value instanceof P ? value : new P(function(resolve2) {
          resolve2(value);
        });
      }
      return new (P || (P = Promise))(function(resolve2, reject) {
        function fulfilled(value) {
          try {
            step(generator.next(value));
          } catch (e) {
            reject(e);
          }
        }
        function rejected(value) {
          try {
            step(generator["throw"](value));
          } catch (e) {
            reject(e);
          }
        }
        function step(result) {
          result.done ? resolve2(result.value) : adopt(result.value).then(fulfilled, rejected);
        }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
      });
    };
    var __generator = exports2 && exports2.__generator || function(thisArg, body) {
      var _ = { label: 0, sent: function() {
        if (t[0] & 1) throw t[1];
        return t[1];
      }, trys: [], ops: [] }, f, y, t, g;
      return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() {
        return this;
      }), g;
      function verb(n) {
        return function(v) {
          return step([n, v]);
        };
      }
      function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
          if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
          if (y = 0, t) op = [op[0] & 2, t.value];
          switch (op[0]) {
            case 0:
            case 1:
              t = op;
              break;
            case 4:
              _.label++;
              return { value: op[1], done: false };
            case 5:
              _.label++;
              y = op[1];
              op = [0];
              continue;
            case 7:
              op = _.ops.pop();
              _.trys.pop();
              continue;
            default:
              if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) {
                _ = 0;
                continue;
              }
              if (op[0] === 3 && (!t || op[1] > t[0] && op[1] < t[3])) {
                _.label = op[1];
                break;
              }
              if (op[0] === 6 && _.label < t[1]) {
                _.label = t[1];
                t = op;
                break;
              }
              if (t && _.label < t[2]) {
                _.label = t[2];
                _.ops.push(op);
                break;
              }
              if (t[2]) _.ops.pop();
              _.trys.pop();
              continue;
          }
          op = body.call(thisArg, _);
        } catch (e) {
          op = [6, e];
          y = 0;
        } finally {
          f = t = 0;
        }
        if (op[0] & 5) throw op[1];
        return { value: op[0] ? op[1] : void 0, done: true };
      }
    };
    var __importDefault = exports2 && exports2.__importDefault || function(mod) {
      return mod && mod.__esModule ? mod : { "default": mod };
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    var fs2 = __importStar(require("fs"));
    var util = __importStar(require("util"));
    var date_1 = __importDefault(require_date());
    var exists = util.promisify(fs2.exists);
    var stat = util.promisify(fs2.stat);
    var read = util.promisify(fs2.read);
    var write = util.promisify(fs2.write);
    var open = util.promisify(fs2.open);
    var close = util.promisify(fs2.close);
    var TeaFile = (
      /** @class */
      (function() {
        function TeaFile2(path2) {
          this._path = path2;
          this._position = 0;
        }
        TeaFile2.prototype.path = function() {
          return this._path;
        };
        TeaFile2.prototype.createTime = function() {
          return __awaiter(this, void 0, void 0, function() {
            var _a;
            return __generator(this, function(_b) {
              switch (_b.label) {
                case 0:
                  if (!!this._stat) return [3, 2];
                  _a = this;
                  return [4, stat(this._path)];
                case 1:
                  _a._stat = _b.sent();
                  _b.label = 2;
                case 2:
                  return [2, new date_1.default(this._stat.birthtime)];
              }
            });
          });
        };
        TeaFile2.prototype.modifyTime = function() {
          return __awaiter(this, void 0, void 0, function() {
            var _a;
            return __generator(this, function(_b) {
              switch (_b.label) {
                case 0:
                  if (!!this._stat) return [3, 2];
                  _a = this;
                  return [4, stat(this._path)];
                case 1:
                  _a._stat = _b.sent();
                  _b.label = 2;
                case 2:
                  return [2, new date_1.default(this._stat.mtime)];
              }
            });
          });
        };
        TeaFile2.prototype.length = function() {
          return __awaiter(this, void 0, void 0, function() {
            var _a;
            return __generator(this, function(_b) {
              switch (_b.label) {
                case 0:
                  if (!!this._stat) return [3, 2];
                  _a = this;
                  return [4, stat(this._path)];
                case 1:
                  _a._stat = _b.sent();
                  _b.label = 2;
                case 2:
                  return [2, this._stat.size];
              }
            });
          });
        };
        TeaFile2.prototype.read = function(size) {
          return __awaiter(this, void 0, void 0, function() {
            var _a, buf, _b, bytesRead, buffer;
            return __generator(this, function(_c) {
              switch (_c.label) {
                case 0:
                  if (!!this._fd) return [3, 2];
                  _a = this;
                  return [4, open(this._path, "a+")];
                case 1:
                  _a._fd = _c.sent();
                  _c.label = 2;
                case 2:
                  buf = Buffer.alloc(size);
                  return [4, read(this._fd, buf, 0, size, this._position)];
                case 3:
                  _b = _c.sent(), bytesRead = _b.bytesRead, buffer = _b.buffer;
                  if (!bytesRead) {
                    return [2, null];
                  }
                  this._position += bytesRead;
                  return [2, buffer];
              }
            });
          });
        };
        TeaFile2.prototype.write = function(data) {
          return __awaiter(this, void 0, void 0, function() {
            var _a, _b;
            return __generator(this, function(_c) {
              switch (_c.label) {
                case 0:
                  if (!!this._fd) return [3, 2];
                  _a = this;
                  return [4, open(this._path, "a+")];
                case 1:
                  _a._fd = _c.sent();
                  _c.label = 2;
                case 2:
                  return [4, write(this._fd, data)];
                case 3:
                  _c.sent();
                  _b = this;
                  return [4, stat(this._path)];
                case 4:
                  _b._stat = _c.sent();
                  return [
                    2
                    /*return*/
                  ];
              }
            });
          });
        };
        TeaFile2.prototype.close = function() {
          return __awaiter(this, void 0, void 0, function() {
            return __generator(this, function(_a) {
              switch (_a.label) {
                case 0:
                  if (!this._fd) {
                    return [
                      2
                      /*return*/
                    ];
                  }
                  return [4, close(this._fd)];
                case 1:
                  _a.sent();
                  return [
                    2
                    /*return*/
                  ];
              }
            });
          });
        };
        TeaFile2.exists = function(path2) {
          return __awaiter(this, void 0, void 0, function() {
            return __generator(this, function(_a) {
              switch (_a.label) {
                case 0:
                  return [4, exists(path2)];
                case 1:
                  return [2, _a.sent()];
              }
            });
          });
        };
        TeaFile2.createReadStream = function(path2) {
          return fs2.createReadStream(path2);
        };
        TeaFile2.createWriteStream = function(path2) {
          return fs2.createWriteStream(path2);
        };
        return TeaFile2;
      })()
    );
    exports2.default = TeaFile;
  }
});

// node_modules/@darabonba/typescript/dist/form.js
var require_form = __commonJS({
  "node_modules/@darabonba/typescript/dist/form.js"(exports2) {
    "use strict";
    var __extends = exports2 && exports2.__extends || /* @__PURE__ */ (function() {
      var extendStatics = function(d, b) {
        extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function(d2, b2) {
          d2.__proto__ = b2;
        } || function(d2, b2) {
          for (var p in b2) if (Object.prototype.hasOwnProperty.call(b2, p)) d2[p] = b2[p];
        };
        return extendStatics(d, b);
      };
      return function(d, b) {
        if (typeof b !== "function" && b !== null)
          throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() {
          this.constructor = d;
        }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
      };
    })();
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.FileFormStream = void 0;
    var stream_1 = require("stream");
    var querystring_1 = require("querystring");
    var FileFormStream = (
      /** @class */
      (function(_super) {
        __extends(FileFormStream2, _super);
        function FileFormStream2(form, boundary) {
          var _this = _super.call(this) || this;
          _this.form = form;
          _this.keys = Object.keys(form);
          _this.index = 0;
          _this.boundary = boundary;
          _this.streaming = false;
          return _this;
        }
        FileFormStream2.prototype._read = function() {
          var _this = this;
          if (this.streaming) {
            return;
          }
          var separator = this.boundary;
          if (this.index < this.keys.length) {
            var name_1 = this.keys[this.index];
            var fieldValue = this.form[name_1];
            if (typeof fieldValue.filename === "string" && typeof fieldValue.contentType === "string" && fieldValue.content instanceof stream_1.Readable) {
              var body = "--".concat(separator, "\r\n") + 'Content-Disposition: form-data; name="'.concat(name_1, '"; filename="').concat(fieldValue.filename, '"\r\n') + "Content-Type: ".concat(fieldValue.contentType, "\r\n\r\n");
              this.push(Buffer.from(body));
              this.streaming = true;
              fieldValue.content.on("data", function(chunk) {
                _this.push(chunk);
              });
              fieldValue.content.on("end", function() {
                _this.index++;
                _this.streaming = false;
                _this.push("");
              });
            } else {
              this.push(Buffer.from("--".concat(separator, "\r\n") + 'Content-Disposition: form-data; name="'.concat(name_1, '"\r\n\r\n') + "".concat(fieldValue, "\r\n")));
              this.index++;
            }
          } else {
            this.push(Buffer.from("\r\n--".concat(separator, "--\r\n")));
            this.push(null);
          }
        };
        return FileFormStream2;
      })(stream_1.Readable)
    );
    exports2.FileFormStream = FileFormStream;
    var Form = (
      /** @class */
      (function() {
        function Form2() {
        }
        Form2.getBoundary = function() {
          return "boundary" + Math.random().toString(16).slice(-12);
        };
        Form2.toFileForm = function(form, boundary) {
          return new FileFormStream(form, boundary);
        };
        Form2.toFormString = function(data) {
          return (0, querystring_1.stringify)(data);
        };
        return Form2;
      })()
    );
    exports2.default = Form;
  }
});

// node_modules/lodash/lodash.js
var require_lodash = __commonJS({
  "node_modules/lodash/lodash.js"(exports2, module2) {
    (function() {
      var undefined2;
      var VERSION = "4.17.23";
      var LARGE_ARRAY_SIZE = 200;
      var CORE_ERROR_TEXT = "Unsupported core-js use. Try https://npms.io/search?q=ponyfill.", FUNC_ERROR_TEXT = "Expected a function", INVALID_TEMPL_VAR_ERROR_TEXT = "Invalid `variable` option passed into `_.template`";
      var HASH_UNDEFINED = "__lodash_hash_undefined__";
      var MAX_MEMOIZE_SIZE = 500;
      var PLACEHOLDER = "__lodash_placeholder__";
      var CLONE_DEEP_FLAG = 1, CLONE_FLAT_FLAG = 2, CLONE_SYMBOLS_FLAG = 4;
      var COMPARE_PARTIAL_FLAG = 1, COMPARE_UNORDERED_FLAG = 2;
      var WRAP_BIND_FLAG = 1, WRAP_BIND_KEY_FLAG = 2, WRAP_CURRY_BOUND_FLAG = 4, WRAP_CURRY_FLAG = 8, WRAP_CURRY_RIGHT_FLAG = 16, WRAP_PARTIAL_FLAG = 32, WRAP_PARTIAL_RIGHT_FLAG = 64, WRAP_ARY_FLAG = 128, WRAP_REARG_FLAG = 256, WRAP_FLIP_FLAG = 512;
      var DEFAULT_TRUNC_LENGTH = 30, DEFAULT_TRUNC_OMISSION = "...";
      var HOT_COUNT = 800, HOT_SPAN = 16;
      var LAZY_FILTER_FLAG = 1, LAZY_MAP_FLAG = 2, LAZY_WHILE_FLAG = 3;
      var INFINITY = 1 / 0, MAX_SAFE_INTEGER = 9007199254740991, MAX_INTEGER = 17976931348623157e292, NAN = 0 / 0;
      var MAX_ARRAY_LENGTH = 4294967295, MAX_ARRAY_INDEX = MAX_ARRAY_LENGTH - 1, HALF_MAX_ARRAY_LENGTH = MAX_ARRAY_LENGTH >>> 1;
      var wrapFlags = [
        ["ary", WRAP_ARY_FLAG],
        ["bind", WRAP_BIND_FLAG],
        ["bindKey", WRAP_BIND_KEY_FLAG],
        ["curry", WRAP_CURRY_FLAG],
        ["curryRight", WRAP_CURRY_RIGHT_FLAG],
        ["flip", WRAP_FLIP_FLAG],
        ["partial", WRAP_PARTIAL_FLAG],
        ["partialRight", WRAP_PARTIAL_RIGHT_FLAG],
        ["rearg", WRAP_REARG_FLAG]
      ];
      var argsTag = "[object Arguments]", arrayTag = "[object Array]", asyncTag = "[object AsyncFunction]", boolTag = "[object Boolean]", dateTag = "[object Date]", domExcTag = "[object DOMException]", errorTag = "[object Error]", funcTag = "[object Function]", genTag = "[object GeneratorFunction]", mapTag = "[object Map]", numberTag = "[object Number]", nullTag = "[object Null]", objectTag = "[object Object]", promiseTag = "[object Promise]", proxyTag = "[object Proxy]", regexpTag = "[object RegExp]", setTag = "[object Set]", stringTag = "[object String]", symbolTag = "[object Symbol]", undefinedTag = "[object Undefined]", weakMapTag = "[object WeakMap]", weakSetTag = "[object WeakSet]";
      var arrayBufferTag = "[object ArrayBuffer]", dataViewTag = "[object DataView]", float32Tag = "[object Float32Array]", float64Tag = "[object Float64Array]", int8Tag = "[object Int8Array]", int16Tag = "[object Int16Array]", int32Tag = "[object Int32Array]", uint8Tag = "[object Uint8Array]", uint8ClampedTag = "[object Uint8ClampedArray]", uint16Tag = "[object Uint16Array]", uint32Tag = "[object Uint32Array]";
      var reEmptyStringLeading = /\b__p \+= '';/g, reEmptyStringMiddle = /\b(__p \+=) '' \+/g, reEmptyStringTrailing = /(__e\(.*?\)|\b__t\)) \+\n'';/g;
      var reEscapedHtml = /&(?:amp|lt|gt|quot|#39);/g, reUnescapedHtml = /[&<>"']/g, reHasEscapedHtml = RegExp(reEscapedHtml.source), reHasUnescapedHtml = RegExp(reUnescapedHtml.source);
      var reEscape = /<%-([\s\S]+?)%>/g, reEvaluate = /<%([\s\S]+?)%>/g, reInterpolate = /<%=([\s\S]+?)%>/g;
      var reIsDeepProp = /\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/, reIsPlainProp = /^\w*$/, rePropName = /[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g;
      var reRegExpChar = /[\\^$.*+?()[\]{}|]/g, reHasRegExpChar = RegExp(reRegExpChar.source);
      var reTrimStart = /^\s+/;
      var reWhitespace = /\s/;
      var reWrapComment = /\{(?:\n\/\* \[wrapped with .+\] \*\/)?\n?/, reWrapDetails = /\{\n\/\* \[wrapped with (.+)\] \*/, reSplitDetails = /,? & /;
      var reAsciiWord = /[^\x00-\x2f\x3a-\x40\x5b-\x60\x7b-\x7f]+/g;
      var reForbiddenIdentifierChars = /[()=,{}\[\]\/\s]/;
      var reEscapeChar = /\\(\\)?/g;
      var reEsTemplate = /\$\{([^\\}]*(?:\\.[^\\}]*)*)\}/g;
      var reFlags = /\w*$/;
      var reIsBadHex = /^[-+]0x[0-9a-f]+$/i;
      var reIsBinary = /^0b[01]+$/i;
      var reIsHostCtor = /^\[object .+?Constructor\]$/;
      var reIsOctal = /^0o[0-7]+$/i;
      var reIsUint = /^(?:0|[1-9]\d*)$/;
      var reLatin = /[\xc0-\xd6\xd8-\xf6\xf8-\xff\u0100-\u017f]/g;
      var reNoMatch = /($^)/;
      var reUnescapedString = /['\n\r\u2028\u2029\\]/g;
      var rsAstralRange = "\\ud800-\\udfff", rsComboMarksRange = "\\u0300-\\u036f", reComboHalfMarksRange = "\\ufe20-\\ufe2f", rsComboSymbolsRange = "\\u20d0-\\u20ff", rsComboRange = rsComboMarksRange + reComboHalfMarksRange + rsComboSymbolsRange, rsDingbatRange = "\\u2700-\\u27bf", rsLowerRange = "a-z\\xdf-\\xf6\\xf8-\\xff", rsMathOpRange = "\\xac\\xb1\\xd7\\xf7", rsNonCharRange = "\\x00-\\x2f\\x3a-\\x40\\x5b-\\x60\\x7b-\\xbf", rsPunctuationRange = "\\u2000-\\u206f", rsSpaceRange = " \\t\\x0b\\f\\xa0\\ufeff\\n\\r\\u2028\\u2029\\u1680\\u180e\\u2000\\u2001\\u2002\\u2003\\u2004\\u2005\\u2006\\u2007\\u2008\\u2009\\u200a\\u202f\\u205f\\u3000", rsUpperRange = "A-Z\\xc0-\\xd6\\xd8-\\xde", rsVarRange = "\\ufe0e\\ufe0f", rsBreakRange = rsMathOpRange + rsNonCharRange + rsPunctuationRange + rsSpaceRange;
      var rsApos = "['\u2019]", rsAstral = "[" + rsAstralRange + "]", rsBreak = "[" + rsBreakRange + "]", rsCombo = "[" + rsComboRange + "]", rsDigits = "\\d+", rsDingbat = "[" + rsDingbatRange + "]", rsLower = "[" + rsLowerRange + "]", rsMisc = "[^" + rsAstralRange + rsBreakRange + rsDigits + rsDingbatRange + rsLowerRange + rsUpperRange + "]", rsFitz = "\\ud83c[\\udffb-\\udfff]", rsModifier = "(?:" + rsCombo + "|" + rsFitz + ")", rsNonAstral = "[^" + rsAstralRange + "]", rsRegional = "(?:\\ud83c[\\udde6-\\uddff]){2}", rsSurrPair = "[\\ud800-\\udbff][\\udc00-\\udfff]", rsUpper = "[" + rsUpperRange + "]", rsZWJ = "\\u200d";
      var rsMiscLower = "(?:" + rsLower + "|" + rsMisc + ")", rsMiscUpper = "(?:" + rsUpper + "|" + rsMisc + ")", rsOptContrLower = "(?:" + rsApos + "(?:d|ll|m|re|s|t|ve))?", rsOptContrUpper = "(?:" + rsApos + "(?:D|LL|M|RE|S|T|VE))?", reOptMod = rsModifier + "?", rsOptVar = "[" + rsVarRange + "]?", rsOptJoin = "(?:" + rsZWJ + "(?:" + [rsNonAstral, rsRegional, rsSurrPair].join("|") + ")" + rsOptVar + reOptMod + ")*", rsOrdLower = "\\d*(?:1st|2nd|3rd|(?![123])\\dth)(?=\\b|[A-Z_])", rsOrdUpper = "\\d*(?:1ST|2ND|3RD|(?![123])\\dTH)(?=\\b|[a-z_])", rsSeq = rsOptVar + reOptMod + rsOptJoin, rsEmoji = "(?:" + [rsDingbat, rsRegional, rsSurrPair].join("|") + ")" + rsSeq, rsSymbol = "(?:" + [rsNonAstral + rsCombo + "?", rsCombo, rsRegional, rsSurrPair, rsAstral].join("|") + ")";
      var reApos = RegExp(rsApos, "g");
      var reComboMark = RegExp(rsCombo, "g");
      var reUnicode = RegExp(rsFitz + "(?=" + rsFitz + ")|" + rsSymbol + rsSeq, "g");
      var reUnicodeWord = RegExp([
        rsUpper + "?" + rsLower + "+" + rsOptContrLower + "(?=" + [rsBreak, rsUpper, "$"].join("|") + ")",
        rsMiscUpper + "+" + rsOptContrUpper + "(?=" + [rsBreak, rsUpper + rsMiscLower, "$"].join("|") + ")",
        rsUpper + "?" + rsMiscLower + "+" + rsOptContrLower,
        rsUpper + "+" + rsOptContrUpper,
        rsOrdUpper,
        rsOrdLower,
        rsDigits,
        rsEmoji
      ].join("|"), "g");
      var reHasUnicode = RegExp("[" + rsZWJ + rsAstralRange + rsComboRange + rsVarRange + "]");
      var reHasUnicodeWord = /[a-z][A-Z]|[A-Z]{2}[a-z]|[0-9][a-zA-Z]|[a-zA-Z][0-9]|[^a-zA-Z0-9 ]/;
      var contextProps = [
        "Array",
        "Buffer",
        "DataView",
        "Date",
        "Error",
        "Float32Array",
        "Float64Array",
        "Function",
        "Int8Array",
        "Int16Array",
        "Int32Array",
        "Map",
        "Math",
        "Object",
        "Promise",
        "RegExp",
        "Set",
        "String",
        "Symbol",
        "TypeError",
        "Uint8Array",
        "Uint8ClampedArray",
        "Uint16Array",
        "Uint32Array",
        "WeakMap",
        "_",
        "clearTimeout",
        "isFinite",
        "parseInt",
        "setTimeout"
      ];
      var templateCounter = -1;
      var typedArrayTags = {};
      typedArrayTags[float32Tag] = typedArrayTags[float64Tag] = typedArrayTags[int8Tag] = typedArrayTags[int16Tag] = typedArrayTags[int32Tag] = typedArrayTags[uint8Tag] = typedArrayTags[uint8ClampedTag] = typedArrayTags[uint16Tag] = typedArrayTags[uint32Tag] = true;
      typedArrayTags[argsTag] = typedArrayTags[arrayTag] = typedArrayTags[arrayBufferTag] = typedArrayTags[boolTag] = typedArrayTags[dataViewTag] = typedArrayTags[dateTag] = typedArrayTags[errorTag] = typedArrayTags[funcTag] = typedArrayTags[mapTag] = typedArrayTags[numberTag] = typedArrayTags[objectTag] = typedArrayTags[regexpTag] = typedArrayTags[setTag] = typedArrayTags[stringTag] = typedArrayTags[weakMapTag] = false;
      var cloneableTags = {};
      cloneableTags[argsTag] = cloneableTags[arrayTag] = cloneableTags[arrayBufferTag] = cloneableTags[dataViewTag] = cloneableTags[boolTag] = cloneableTags[dateTag] = cloneableTags[float32Tag] = cloneableTags[float64Tag] = cloneableTags[int8Tag] = cloneableTags[int16Tag] = cloneableTags[int32Tag] = cloneableTags[mapTag] = cloneableTags[numberTag] = cloneableTags[objectTag] = cloneableTags[regexpTag] = cloneableTags[setTag] = cloneableTags[stringTag] = cloneableTags[symbolTag] = cloneableTags[uint8Tag] = cloneableTags[uint8ClampedTag] = cloneableTags[uint16Tag] = cloneableTags[uint32Tag] = true;
      cloneableTags[errorTag] = cloneableTags[funcTag] = cloneableTags[weakMapTag] = false;
      var deburredLetters = {
        // Latin-1 Supplement block.
        "\xC0": "A",
        "\xC1": "A",
        "\xC2": "A",
        "\xC3": "A",
        "\xC4": "A",
        "\xC5": "A",
        "\xE0": "a",
        "\xE1": "a",
        "\xE2": "a",
        "\xE3": "a",
        "\xE4": "a",
        "\xE5": "a",
        "\xC7": "C",
        "\xE7": "c",
        "\xD0": "D",
        "\xF0": "d",
        "\xC8": "E",
        "\xC9": "E",
        "\xCA": "E",
        "\xCB": "E",
        "\xE8": "e",
        "\xE9": "e",
        "\xEA": "e",
        "\xEB": "e",
        "\xCC": "I",
        "\xCD": "I",
        "\xCE": "I",
        "\xCF": "I",
        "\xEC": "i",
        "\xED": "i",
        "\xEE": "i",
        "\xEF": "i",
        "\xD1": "N",
        "\xF1": "n",
        "\xD2": "O",
        "\xD3": "O",
        "\xD4": "O",
        "\xD5": "O",
        "\xD6": "O",
        "\xD8": "O",
        "\xF2": "o",
        "\xF3": "o",
        "\xF4": "o",
        "\xF5": "o",
        "\xF6": "o",
        "\xF8": "o",
        "\xD9": "U",
        "\xDA": "U",
        "\xDB": "U",
        "\xDC": "U",
        "\xF9": "u",
        "\xFA": "u",
        "\xFB": "u",
        "\xFC": "u",
        "\xDD": "Y",
        "\xFD": "y",
        "\xFF": "y",
        "\xC6": "Ae",
        "\xE6": "ae",
        "\xDE": "Th",
        "\xFE": "th",
        "\xDF": "ss",
        // Latin Extended-A block.
        "\u0100": "A",
        "\u0102": "A",
        "\u0104": "A",
        "\u0101": "a",
        "\u0103": "a",
        "\u0105": "a",
        "\u0106": "C",
        "\u0108": "C",
        "\u010A": "C",
        "\u010C": "C",
        "\u0107": "c",
        "\u0109": "c",
        "\u010B": "c",
        "\u010D": "c",
        "\u010E": "D",
        "\u0110": "D",
        "\u010F": "d",
        "\u0111": "d",
        "\u0112": "E",
        "\u0114": "E",
        "\u0116": "E",
        "\u0118": "E",
        "\u011A": "E",
        "\u0113": "e",
        "\u0115": "e",
        "\u0117": "e",
        "\u0119": "e",
        "\u011B": "e",
        "\u011C": "G",
        "\u011E": "G",
        "\u0120": "G",
        "\u0122": "G",
        "\u011D": "g",
        "\u011F": "g",
        "\u0121": "g",
        "\u0123": "g",
        "\u0124": "H",
        "\u0126": "H",
        "\u0125": "h",
        "\u0127": "h",
        "\u0128": "I",
        "\u012A": "I",
        "\u012C": "I",
        "\u012E": "I",
        "\u0130": "I",
        "\u0129": "i",
        "\u012B": "i",
        "\u012D": "i",
        "\u012F": "i",
        "\u0131": "i",
        "\u0134": "J",
        "\u0135": "j",
        "\u0136": "K",
        "\u0137": "k",
        "\u0138": "k",
        "\u0139": "L",
        "\u013B": "L",
        "\u013D": "L",
        "\u013F": "L",
        "\u0141": "L",
        "\u013A": "l",
        "\u013C": "l",
        "\u013E": "l",
        "\u0140": "l",
        "\u0142": "l",
        "\u0143": "N",
        "\u0145": "N",
        "\u0147": "N",
        "\u014A": "N",
        "\u0144": "n",
        "\u0146": "n",
        "\u0148": "n",
        "\u014B": "n",
        "\u014C": "O",
        "\u014E": "O",
        "\u0150": "O",
        "\u014D": "o",
        "\u014F": "o",
        "\u0151": "o",
        "\u0154": "R",
        "\u0156": "R",
        "\u0158": "R",
        "\u0155": "r",
        "\u0157": "r",
        "\u0159": "r",
        "\u015A": "S",
        "\u015C": "S",
        "\u015E": "S",
        "\u0160": "S",
        "\u015B": "s",
        "\u015D": "s",
        "\u015F": "s",
        "\u0161": "s",
        "\u0162": "T",
        "\u0164": "T",
        "\u0166": "T",
        "\u0163": "t",
        "\u0165": "t",
        "\u0167": "t",
        "\u0168": "U",
        "\u016A": "U",
        "\u016C": "U",
        "\u016E": "U",
        "\u0170": "U",
        "\u0172": "U",
        "\u0169": "u",
        "\u016B": "u",
        "\u016D": "u",
        "\u016F": "u",
        "\u0171": "u",
        "\u0173": "u",
        "\u0174": "W",
        "\u0175": "w",
        "\u0176": "Y",
        "\u0177": "y",
        "\u0178": "Y",
        "\u0179": "Z",
        "\u017B": "Z",
        "\u017D": "Z",
        "\u017A": "z",
        "\u017C": "z",
        "\u017E": "z",
        "\u0132": "IJ",
        "\u0133": "ij",
        "\u0152": "Oe",
        "\u0153": "oe",
        "\u0149": "'n",
        "\u017F": "s"
      };
      var htmlEscapes = {
        "&": "&amp;",
        "<": "&lt;",
        ">": "&gt;",
        '"': "&quot;",
        "'": "&#39;"
      };
      var htmlUnescapes = {
        "&amp;": "&",
        "&lt;": "<",
        "&gt;": ">",
        "&quot;": '"',
        "&#39;": "'"
      };
      var stringEscapes = {
        "\\": "\\",
        "'": "'",
        "\n": "n",
        "\r": "r",
        "\u2028": "u2028",
        "\u2029": "u2029"
      };
      var freeParseFloat = parseFloat, freeParseInt = parseInt;
      var freeGlobal = typeof global == "object" && global && global.Object === Object && global;
      var freeSelf = typeof self == "object" && self && self.Object === Object && self;
      var root = freeGlobal || freeSelf || Function("return this")();
      var freeExports = typeof exports2 == "object" && exports2 && !exports2.nodeType && exports2;
      var freeModule = freeExports && typeof module2 == "object" && module2 && !module2.nodeType && module2;
      var moduleExports = freeModule && freeModule.exports === freeExports;
      var freeProcess = moduleExports && freeGlobal.process;
      var nodeUtil = (function() {
        try {
          var types = freeModule && freeModule.require && freeModule.require("util").types;
          if (types) {
            return types;
          }
          return freeProcess && freeProcess.binding && freeProcess.binding("util");
        } catch (e) {
        }
      })();
      var nodeIsArrayBuffer = nodeUtil && nodeUtil.isArrayBuffer, nodeIsDate = nodeUtil && nodeUtil.isDate, nodeIsMap = nodeUtil && nodeUtil.isMap, nodeIsRegExp = nodeUtil && nodeUtil.isRegExp, nodeIsSet = nodeUtil && nodeUtil.isSet, nodeIsTypedArray = nodeUtil && nodeUtil.isTypedArray;
      function apply(func, thisArg, args) {
        switch (args.length) {
          case 0:
            return func.call(thisArg);
          case 1:
            return func.call(thisArg, args[0]);
          case 2:
            return func.call(thisArg, args[0], args[1]);
          case 3:
            return func.call(thisArg, args[0], args[1], args[2]);
        }
        return func.apply(thisArg, args);
      }
      function arrayAggregator(array, setter, iteratee, accumulator) {
        var index = -1, length = array == null ? 0 : array.length;
        while (++index < length) {
          var value = array[index];
          setter(accumulator, value, iteratee(value), array);
        }
        return accumulator;
      }
      function arrayEach(array, iteratee) {
        var index = -1, length = array == null ? 0 : array.length;
        while (++index < length) {
          if (iteratee(array[index], index, array) === false) {
            break;
          }
        }
        return array;
      }
      function arrayEachRight(array, iteratee) {
        var length = array == null ? 0 : array.length;
        while (length--) {
          if (iteratee(array[length], length, array) === false) {
            break;
          }
        }
        return array;
      }
      function arrayEvery(array, predicate) {
        var index = -1, length = array == null ? 0 : array.length;
        while (++index < length) {
          if (!predicate(array[index], index, array)) {
            return false;
          }
        }
        return true;
      }
      function arrayFilter(array, predicate) {
        var index = -1, length = array == null ? 0 : array.length, resIndex = 0, result = [];
        while (++index < length) {
          var value = array[index];
          if (predicate(value, index, array)) {
            result[resIndex++] = value;
          }
        }
        return result;
      }
      function arrayIncludes(array, value) {
        var length = array == null ? 0 : array.length;
        return !!length && baseIndexOf(array, value, 0) > -1;
      }
      function arrayIncludesWith(array, value, comparator) {
        var index = -1, length = array == null ? 0 : array.length;
        while (++index < length) {
          if (comparator(value, array[index])) {
            return true;
          }
        }
        return false;
      }
      function arrayMap(array, iteratee) {
        var index = -1, length = array == null ? 0 : array.length, result = Array(length);
        while (++index < length) {
          result[index] = iteratee(array[index], index, array);
        }
        return result;
      }
      function arrayPush(array, values) {
        var index = -1, length = values.length, offset = array.length;
        while (++index < length) {
          array[offset + index] = values[index];
        }
        return array;
      }
      function arrayReduce(array, iteratee, accumulator, initAccum) {
        var index = -1, length = array == null ? 0 : array.length;
        if (initAccum && length) {
          accumulator = array[++index];
        }
        while (++index < length) {
          accumulator = iteratee(accumulator, array[index], index, array);
        }
        return accumulator;
      }
      function arrayReduceRight(array, iteratee, accumulator, initAccum) {
        var length = array == null ? 0 : array.length;
        if (initAccum && length) {
          accumulator = array[--length];
        }
        while (length--) {
          accumulator = iteratee(accumulator, array[length], length, array);
        }
        return accumulator;
      }
      function arraySome(array, predicate) {
        var index = -1, length = array == null ? 0 : array.length;
        while (++index < length) {
          if (predicate(array[index], index, array)) {
            return true;
          }
        }
        return false;
      }
      var asciiSize = baseProperty("length");
      function asciiToArray(string) {
        return string.split("");
      }
      function asciiWords(string) {
        return string.match(reAsciiWord) || [];
      }
      function baseFindKey(collection, predicate, eachFunc) {
        var result;
        eachFunc(collection, function(value, key, collection2) {
          if (predicate(value, key, collection2)) {
            result = key;
            return false;
          }
        });
        return result;
      }
      function baseFindIndex(array, predicate, fromIndex, fromRight) {
        var length = array.length, index = fromIndex + (fromRight ? 1 : -1);
        while (fromRight ? index-- : ++index < length) {
          if (predicate(array[index], index, array)) {
            return index;
          }
        }
        return -1;
      }
      function baseIndexOf(array, value, fromIndex) {
        return value === value ? strictIndexOf(array, value, fromIndex) : baseFindIndex(array, baseIsNaN, fromIndex);
      }
      function baseIndexOfWith(array, value, fromIndex, comparator) {
        var index = fromIndex - 1, length = array.length;
        while (++index < length) {
          if (comparator(array[index], value)) {
            return index;
          }
        }
        return -1;
      }
      function baseIsNaN(value) {
        return value !== value;
      }
      function baseMean(array, iteratee) {
        var length = array == null ? 0 : array.length;
        return length ? baseSum(array, iteratee) / length : NAN;
      }
      function baseProperty(key) {
        return function(object) {
          return object == null ? undefined2 : object[key];
        };
      }
      function basePropertyOf(object) {
        return function(key) {
          return object == null ? undefined2 : object[key];
        };
      }
      function baseReduce(collection, iteratee, accumulator, initAccum, eachFunc) {
        eachFunc(collection, function(value, index, collection2) {
          accumulator = initAccum ? (initAccum = false, value) : iteratee(accumulator, value, index, collection2);
        });
        return accumulator;
      }
      function baseSortBy(array, comparer) {
        var length = array.length;
        array.sort(comparer);
        while (length--) {
          array[length] = array[length].value;
        }
        return array;
      }
      function baseSum(array, iteratee) {
        var result, index = -1, length = array.length;
        while (++index < length) {
          var current = iteratee(array[index]);
          if (current !== undefined2) {
            result = result === undefined2 ? current : result + current;
          }
        }
        return result;
      }
      function baseTimes(n, iteratee) {
        var index = -1, result = Array(n);
        while (++index < n) {
          result[index] = iteratee(index);
        }
        return result;
      }
      function baseToPairs(object, props) {
        return arrayMap(props, function(key) {
          return [key, object[key]];
        });
      }
      function baseTrim(string) {
        return string ? string.slice(0, trimmedEndIndex(string) + 1).replace(reTrimStart, "") : string;
      }
      function baseUnary(func) {
        return function(value) {
          return func(value);
        };
      }
      function baseValues(object, props) {
        return arrayMap(props, function(key) {
          return object[key];
        });
      }
      function cacheHas(cache, key) {
        return cache.has(key);
      }
      function charsStartIndex(strSymbols, chrSymbols) {
        var index = -1, length = strSymbols.length;
        while (++index < length && baseIndexOf(chrSymbols, strSymbols[index], 0) > -1) {
        }
        return index;
      }
      function charsEndIndex(strSymbols, chrSymbols) {
        var index = strSymbols.length;
        while (index-- && baseIndexOf(chrSymbols, strSymbols[index], 0) > -1) {
        }
        return index;
      }
      function countHolders(array, placeholder) {
        var length = array.length, result = 0;
        while (length--) {
          if (array[length] === placeholder) {
            ++result;
          }
        }
        return result;
      }
      var deburrLetter = basePropertyOf(deburredLetters);
      var escapeHtmlChar = basePropertyOf(htmlEscapes);
      function escapeStringChar(chr) {
        return "\\" + stringEscapes[chr];
      }
      function getValue(object, key) {
        return object == null ? undefined2 : object[key];
      }
      function hasUnicode(string) {
        return reHasUnicode.test(string);
      }
      function hasUnicodeWord(string) {
        return reHasUnicodeWord.test(string);
      }
      function iteratorToArray(iterator) {
        var data, result = [];
        while (!(data = iterator.next()).done) {
          result.push(data.value);
        }
        return result;
      }
      function mapToArray(map) {
        var index = -1, result = Array(map.size);
        map.forEach(function(value, key) {
          result[++index] = [key, value];
        });
        return result;
      }
      function overArg(func, transform) {
        return function(arg) {
          return func(transform(arg));
        };
      }
      function replaceHolders(array, placeholder) {
        var index = -1, length = array.length, resIndex = 0, result = [];
        while (++index < length) {
          var value = array[index];
          if (value === placeholder || value === PLACEHOLDER) {
            array[index] = PLACEHOLDER;
            result[resIndex++] = index;
          }
        }
        return result;
      }
      function setToArray(set) {
        var index = -1, result = Array(set.size);
        set.forEach(function(value) {
          result[++index] = value;
        });
        return result;
      }
      function setToPairs(set) {
        var index = -1, result = Array(set.size);
        set.forEach(function(value) {
          result[++index] = [value, value];
        });
        return result;
      }
      function strictIndexOf(array, value, fromIndex) {
        var index = fromIndex - 1, length = array.length;
        while (++index < length) {
          if (array[index] === value) {
            return index;
          }
        }
        return -1;
      }
      function strictLastIndexOf(array, value, fromIndex) {
        var index = fromIndex + 1;
        while (index--) {
          if (array[index] === value) {
            return index;
          }
        }
        return index;
      }
      function stringSize(string) {
        return hasUnicode(string) ? unicodeSize(string) : asciiSize(string);
      }
      function stringToArray(string) {
        return hasUnicode(string) ? unicodeToArray(string) : asciiToArray(string);
      }
      function trimmedEndIndex(string) {
        var index = string.length;
        while (index-- && reWhitespace.test(string.charAt(index))) {
        }
        return index;
      }
      var unescapeHtmlChar = basePropertyOf(htmlUnescapes);
      function unicodeSize(string) {
        var result = reUnicode.lastIndex = 0;
        while (reUnicode.test(string)) {
          ++result;
        }
        return result;
      }
      function unicodeToArray(string) {
        return string.match(reUnicode) || [];
      }
      function unicodeWords(string) {
        return string.match(reUnicodeWord) || [];
      }
      var runInContext = (function runInContext2(context) {
        context = context == null ? root : _.defaults(root.Object(), context, _.pick(root, contextProps));
        var Array2 = context.Array, Date2 = context.Date, Error2 = context.Error, Function2 = context.Function, Math2 = context.Math, Object2 = context.Object, RegExp2 = context.RegExp, String2 = context.String, TypeError2 = context.TypeError;
        var arrayProto = Array2.prototype, funcProto = Function2.prototype, objectProto = Object2.prototype;
        var coreJsData = context["__core-js_shared__"];
        var funcToString = funcProto.toString;
        var hasOwnProperty = objectProto.hasOwnProperty;
        var idCounter = 0;
        var maskSrcKey = (function() {
          var uid = /[^.]+$/.exec(coreJsData && coreJsData.keys && coreJsData.keys.IE_PROTO || "");
          return uid ? "Symbol(src)_1." + uid : "";
        })();
        var nativeObjectToString = objectProto.toString;
        var objectCtorString = funcToString.call(Object2);
        var oldDash = root._;
        var reIsNative = RegExp2(
          "^" + funcToString.call(hasOwnProperty).replace(reRegExpChar, "\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, "$1.*?") + "$"
        );
        var Buffer2 = moduleExports ? context.Buffer : undefined2, Symbol2 = context.Symbol, Uint8Array2 = context.Uint8Array, allocUnsafe = Buffer2 ? Buffer2.allocUnsafe : undefined2, getPrototype = overArg(Object2.getPrototypeOf, Object2), objectCreate = Object2.create, propertyIsEnumerable = objectProto.propertyIsEnumerable, splice = arrayProto.splice, spreadableSymbol = Symbol2 ? Symbol2.isConcatSpreadable : undefined2, symIterator = Symbol2 ? Symbol2.iterator : undefined2, symToStringTag = Symbol2 ? Symbol2.toStringTag : undefined2;
        var defineProperty = (function() {
          try {
            var func = getNative(Object2, "defineProperty");
            func({}, "", {});
            return func;
          } catch (e) {
          }
        })();
        var ctxClearTimeout = context.clearTimeout !== root.clearTimeout && context.clearTimeout, ctxNow = Date2 && Date2.now !== root.Date.now && Date2.now, ctxSetTimeout = context.setTimeout !== root.setTimeout && context.setTimeout;
        var nativeCeil = Math2.ceil, nativeFloor = Math2.floor, nativeGetSymbols = Object2.getOwnPropertySymbols, nativeIsBuffer = Buffer2 ? Buffer2.isBuffer : undefined2, nativeIsFinite = context.isFinite, nativeJoin = arrayProto.join, nativeKeys = overArg(Object2.keys, Object2), nativeMax = Math2.max, nativeMin = Math2.min, nativeNow = Date2.now, nativeParseInt = context.parseInt, nativeRandom = Math2.random, nativeReverse = arrayProto.reverse;
        var DataView = getNative(context, "DataView"), Map = getNative(context, "Map"), Promise2 = getNative(context, "Promise"), Set2 = getNative(context, "Set"), WeakMap = getNative(context, "WeakMap"), nativeCreate = getNative(Object2, "create");
        var metaMap = WeakMap && new WeakMap();
        var realNames = {};
        var dataViewCtorString = toSource(DataView), mapCtorString = toSource(Map), promiseCtorString = toSource(Promise2), setCtorString = toSource(Set2), weakMapCtorString = toSource(WeakMap);
        var symbolProto = Symbol2 ? Symbol2.prototype : undefined2, symbolValueOf = symbolProto ? symbolProto.valueOf : undefined2, symbolToString = symbolProto ? symbolProto.toString : undefined2;
        function lodash(value) {
          if (isObjectLike(value) && !isArray(value) && !(value instanceof LazyWrapper)) {
            if (value instanceof LodashWrapper) {
              return value;
            }
            if (hasOwnProperty.call(value, "__wrapped__")) {
              return wrapperClone(value);
            }
          }
          return new LodashWrapper(value);
        }
        var baseCreate = /* @__PURE__ */ (function() {
          function object() {
          }
          return function(proto) {
            if (!isObject(proto)) {
              return {};
            }
            if (objectCreate) {
              return objectCreate(proto);
            }
            object.prototype = proto;
            var result2 = new object();
            object.prototype = undefined2;
            return result2;
          };
        })();
        function baseLodash() {
        }
        function LodashWrapper(value, chainAll) {
          this.__wrapped__ = value;
          this.__actions__ = [];
          this.__chain__ = !!chainAll;
          this.__index__ = 0;
          this.__values__ = undefined2;
        }
        lodash.templateSettings = {
          /**
           * Used to detect `data` property values to be HTML-escaped.
           *
           * @memberOf _.templateSettings
           * @type {RegExp}
           */
          "escape": reEscape,
          /**
           * Used to detect code to be evaluated.
           *
           * @memberOf _.templateSettings
           * @type {RegExp}
           */
          "evaluate": reEvaluate,
          /**
           * Used to detect `data` property values to inject.
           *
           * @memberOf _.templateSettings
           * @type {RegExp}
           */
          "interpolate": reInterpolate,
          /**
           * Used to reference the data object in the template text.
           *
           * @memberOf _.templateSettings
           * @type {string}
           */
          "variable": "",
          /**
           * Used to import variables into the compiled template.
           *
           * @memberOf _.templateSettings
           * @type {Object}
           */
          "imports": {
            /**
             * A reference to the `lodash` function.
             *
             * @memberOf _.templateSettings.imports
             * @type {Function}
             */
            "_": lodash
          }
        };
        lodash.prototype = baseLodash.prototype;
        lodash.prototype.constructor = lodash;
        LodashWrapper.prototype = baseCreate(baseLodash.prototype);
        LodashWrapper.prototype.constructor = LodashWrapper;
        function LazyWrapper(value) {
          this.__wrapped__ = value;
          this.__actions__ = [];
          this.__dir__ = 1;
          this.__filtered__ = false;
          this.__iteratees__ = [];
          this.__takeCount__ = MAX_ARRAY_LENGTH;
          this.__views__ = [];
        }
        function lazyClone() {
          var result2 = new LazyWrapper(this.__wrapped__);
          result2.__actions__ = copyArray(this.__actions__);
          result2.__dir__ = this.__dir__;
          result2.__filtered__ = this.__filtered__;
          result2.__iteratees__ = copyArray(this.__iteratees__);
          result2.__takeCount__ = this.__takeCount__;
          result2.__views__ = copyArray(this.__views__);
          return result2;
        }
        function lazyReverse() {
          if (this.__filtered__) {
            var result2 = new LazyWrapper(this);
            result2.__dir__ = -1;
            result2.__filtered__ = true;
          } else {
            result2 = this.clone();
            result2.__dir__ *= -1;
          }
          return result2;
        }
        function lazyValue() {
          var array = this.__wrapped__.value(), dir = this.__dir__, isArr = isArray(array), isRight = dir < 0, arrLength = isArr ? array.length : 0, view = getView(0, arrLength, this.__views__), start = view.start, end = view.end, length = end - start, index = isRight ? end : start - 1, iteratees = this.__iteratees__, iterLength = iteratees.length, resIndex = 0, takeCount = nativeMin(length, this.__takeCount__);
          if (!isArr || !isRight && arrLength == length && takeCount == length) {
            return baseWrapperValue(array, this.__actions__);
          }
          var result2 = [];
          outer:
            while (length-- && resIndex < takeCount) {
              index += dir;
              var iterIndex = -1, value = array[index];
              while (++iterIndex < iterLength) {
                var data = iteratees[iterIndex], iteratee2 = data.iteratee, type = data.type, computed = iteratee2(value);
                if (type == LAZY_MAP_FLAG) {
                  value = computed;
                } else if (!computed) {
                  if (type == LAZY_FILTER_FLAG) {
                    continue outer;
                  } else {
                    break outer;
                  }
                }
              }
              result2[resIndex++] = value;
            }
          return result2;
        }
        LazyWrapper.prototype = baseCreate(baseLodash.prototype);
        LazyWrapper.prototype.constructor = LazyWrapper;
        function Hash(entries) {
          var index = -1, length = entries == null ? 0 : entries.length;
          this.clear();
          while (++index < length) {
            var entry = entries[index];
            this.set(entry[0], entry[1]);
          }
        }
        function hashClear() {
          this.__data__ = nativeCreate ? nativeCreate(null) : {};
          this.size = 0;
        }
        function hashDelete(key) {
          var result2 = this.has(key) && delete this.__data__[key];
          this.size -= result2 ? 1 : 0;
          return result2;
        }
        function hashGet(key) {
          var data = this.__data__;
          if (nativeCreate) {
            var result2 = data[key];
            return result2 === HASH_UNDEFINED ? undefined2 : result2;
          }
          return hasOwnProperty.call(data, key) ? data[key] : undefined2;
        }
        function hashHas(key) {
          var data = this.__data__;
          return nativeCreate ? data[key] !== undefined2 : hasOwnProperty.call(data, key);
        }
        function hashSet(key, value) {
          var data = this.__data__;
          this.size += this.has(key) ? 0 : 1;
          data[key] = nativeCreate && value === undefined2 ? HASH_UNDEFINED : value;
          return this;
        }
        Hash.prototype.clear = hashClear;
        Hash.prototype["delete"] = hashDelete;
        Hash.prototype.get = hashGet;
        Hash.prototype.has = hashHas;
        Hash.prototype.set = hashSet;
        function ListCache(entries) {
          var index = -1, length = entries == null ? 0 : entries.length;
          this.clear();
          while (++index < length) {
            var entry = entries[index];
            this.set(entry[0], entry[1]);
          }
        }
        function listCacheClear() {
          this.__data__ = [];
          this.size = 0;
        }
        function listCacheDelete(key) {
          var data = this.__data__, index = assocIndexOf(data, key);
          if (index < 0) {
            return false;
          }
          var lastIndex = data.length - 1;
          if (index == lastIndex) {
            data.pop();
          } else {
            splice.call(data, index, 1);
          }
          --this.size;
          return true;
        }
        function listCacheGet(key) {
          var data = this.__data__, index = assocIndexOf(data, key);
          return index < 0 ? undefined2 : data[index][1];
        }
        function listCacheHas(key) {
          return assocIndexOf(this.__data__, key) > -1;
        }
        function listCacheSet(key, value) {
          var data = this.__data__, index = assocIndexOf(data, key);
          if (index < 0) {
            ++this.size;
            data.push([key, value]);
          } else {
            data[index][1] = value;
          }
          return this;
        }
        ListCache.prototype.clear = listCacheClear;
        ListCache.prototype["delete"] = listCacheDelete;
        ListCache.prototype.get = listCacheGet;
        ListCache.prototype.has = listCacheHas;
        ListCache.prototype.set = listCacheSet;
        function MapCache(entries) {
          var index = -1, length = entries == null ? 0 : entries.length;
          this.clear();
          while (++index < length) {
            var entry = entries[index];
            this.set(entry[0], entry[1]);
          }
        }
        function mapCacheClear() {
          this.size = 0;
          this.__data__ = {
            "hash": new Hash(),
            "map": new (Map || ListCache)(),
            "string": new Hash()
          };
        }
        function mapCacheDelete(key) {
          var result2 = getMapData(this, key)["delete"](key);
          this.size -= result2 ? 1 : 0;
          return result2;
        }
        function mapCacheGet(key) {
          return getMapData(this, key).get(key);
        }
        function mapCacheHas(key) {
          return getMapData(this, key).has(key);
        }
        function mapCacheSet(key, value) {
          var data = getMapData(this, key), size2 = data.size;
          data.set(key, value);
          this.size += data.size == size2 ? 0 : 1;
          return this;
        }
        MapCache.prototype.clear = mapCacheClear;
        MapCache.prototype["delete"] = mapCacheDelete;
        MapCache.prototype.get = mapCacheGet;
        MapCache.prototype.has = mapCacheHas;
        MapCache.prototype.set = mapCacheSet;
        function SetCache(values2) {
          var index = -1, length = values2 == null ? 0 : values2.length;
          this.__data__ = new MapCache();
          while (++index < length) {
            this.add(values2[index]);
          }
        }
        function setCacheAdd(value) {
          this.__data__.set(value, HASH_UNDEFINED);
          return this;
        }
        function setCacheHas(value) {
          return this.__data__.has(value);
        }
        SetCache.prototype.add = SetCache.prototype.push = setCacheAdd;
        SetCache.prototype.has = setCacheHas;
        function Stack(entries) {
          var data = this.__data__ = new ListCache(entries);
          this.size = data.size;
        }
        function stackClear() {
          this.__data__ = new ListCache();
          this.size = 0;
        }
        function stackDelete(key) {
          var data = this.__data__, result2 = data["delete"](key);
          this.size = data.size;
          return result2;
        }
        function stackGet(key) {
          return this.__data__.get(key);
        }
        function stackHas(key) {
          return this.__data__.has(key);
        }
        function stackSet(key, value) {
          var data = this.__data__;
          if (data instanceof ListCache) {
            var pairs = data.__data__;
            if (!Map || pairs.length < LARGE_ARRAY_SIZE - 1) {
              pairs.push([key, value]);
              this.size = ++data.size;
              return this;
            }
            data = this.__data__ = new MapCache(pairs);
          }
          data.set(key, value);
          this.size = data.size;
          return this;
        }
        Stack.prototype.clear = stackClear;
        Stack.prototype["delete"] = stackDelete;
        Stack.prototype.get = stackGet;
        Stack.prototype.has = stackHas;
        Stack.prototype.set = stackSet;
        function arrayLikeKeys(value, inherited) {
          var isArr = isArray(value), isArg = !isArr && isArguments(value), isBuff = !isArr && !isArg && isBuffer(value), isType = !isArr && !isArg && !isBuff && isTypedArray(value), skipIndexes = isArr || isArg || isBuff || isType, result2 = skipIndexes ? baseTimes(value.length, String2) : [], length = result2.length;
          for (var key in value) {
            if ((inherited || hasOwnProperty.call(value, key)) && !(skipIndexes && // Safari 9 has enumerable `arguments.length` in strict mode.
            (key == "length" || // Node.js 0.10 has enumerable non-index properties on buffers.
            isBuff && (key == "offset" || key == "parent") || // PhantomJS 2 has enumerable non-index properties on typed arrays.
            isType && (key == "buffer" || key == "byteLength" || key == "byteOffset") || // Skip index properties.
            isIndex(key, length)))) {
              result2.push(key);
            }
          }
          return result2;
        }
        function arraySample(array) {
          var length = array.length;
          return length ? array[baseRandom(0, length - 1)] : undefined2;
        }
        function arraySampleSize(array, n) {
          return shuffleSelf(copyArray(array), baseClamp(n, 0, array.length));
        }
        function arrayShuffle(array) {
          return shuffleSelf(copyArray(array));
        }
        function assignMergeValue(object, key, value) {
          if (value !== undefined2 && !eq(object[key], value) || value === undefined2 && !(key in object)) {
            baseAssignValue(object, key, value);
          }
        }
        function assignValue(object, key, value) {
          var objValue = object[key];
          if (!(hasOwnProperty.call(object, key) && eq(objValue, value)) || value === undefined2 && !(key in object)) {
            baseAssignValue(object, key, value);
          }
        }
        function assocIndexOf(array, key) {
          var length = array.length;
          while (length--) {
            if (eq(array[length][0], key)) {
              return length;
            }
          }
          return -1;
        }
        function baseAggregator(collection, setter, iteratee2, accumulator) {
          baseEach(collection, function(value, key, collection2) {
            setter(accumulator, value, iteratee2(value), collection2);
          });
          return accumulator;
        }
        function baseAssign(object, source) {
          return object && copyObject(source, keys(source), object);
        }
        function baseAssignIn(object, source) {
          return object && copyObject(source, keysIn(source), object);
        }
        function baseAssignValue(object, key, value) {
          if (key == "__proto__" && defineProperty) {
            defineProperty(object, key, {
              "configurable": true,
              "enumerable": true,
              "value": value,
              "writable": true
            });
          } else {
            object[key] = value;
          }
        }
        function baseAt(object, paths) {
          var index = -1, length = paths.length, result2 = Array2(length), skip = object == null;
          while (++index < length) {
            result2[index] = skip ? undefined2 : get(object, paths[index]);
          }
          return result2;
        }
        function baseClamp(number, lower, upper) {
          if (number === number) {
            if (upper !== undefined2) {
              number = number <= upper ? number : upper;
            }
            if (lower !== undefined2) {
              number = number >= lower ? number : lower;
            }
          }
          return number;
        }
        function baseClone(value, bitmask, customizer, key, object, stack) {
          var result2, isDeep = bitmask & CLONE_DEEP_FLAG, isFlat = bitmask & CLONE_FLAT_FLAG, isFull = bitmask & CLONE_SYMBOLS_FLAG;
          if (customizer) {
            result2 = object ? customizer(value, key, object, stack) : customizer(value);
          }
          if (result2 !== undefined2) {
            return result2;
          }
          if (!isObject(value)) {
            return value;
          }
          var isArr = isArray(value);
          if (isArr) {
            result2 = initCloneArray(value);
            if (!isDeep) {
              return copyArray(value, result2);
            }
          } else {
            var tag = getTag(value), isFunc = tag == funcTag || tag == genTag;
            if (isBuffer(value)) {
              return cloneBuffer(value, isDeep);
            }
            if (tag == objectTag || tag == argsTag || isFunc && !object) {
              result2 = isFlat || isFunc ? {} : initCloneObject(value);
              if (!isDeep) {
                return isFlat ? copySymbolsIn(value, baseAssignIn(result2, value)) : copySymbols(value, baseAssign(result2, value));
              }
            } else {
              if (!cloneableTags[tag]) {
                return object ? value : {};
              }
              result2 = initCloneByTag(value, tag, isDeep);
            }
          }
          stack || (stack = new Stack());
          var stacked = stack.get(value);
          if (stacked) {
            return stacked;
          }
          stack.set(value, result2);
          if (isSet(value)) {
            value.forEach(function(subValue) {
              result2.add(baseClone(subValue, bitmask, customizer, subValue, value, stack));
            });
          } else if (isMap(value)) {
            value.forEach(function(subValue, key2) {
              result2.set(key2, baseClone(subValue, bitmask, customizer, key2, value, stack));
            });
          }
          var keysFunc = isFull ? isFlat ? getAllKeysIn : getAllKeys : isFlat ? keysIn : keys;
          var props = isArr ? undefined2 : keysFunc(value);
          arrayEach(props || value, function(subValue, key2) {
            if (props) {
              key2 = subValue;
              subValue = value[key2];
            }
            assignValue(result2, key2, baseClone(subValue, bitmask, customizer, key2, value, stack));
          });
          return result2;
        }
        function baseConforms(source) {
          var props = keys(source);
          return function(object) {
            return baseConformsTo(object, source, props);
          };
        }
        function baseConformsTo(object, source, props) {
          var length = props.length;
          if (object == null) {
            return !length;
          }
          object = Object2(object);
          while (length--) {
            var key = props[length], predicate = source[key], value = object[key];
            if (value === undefined2 && !(key in object) || !predicate(value)) {
              return false;
            }
          }
          return true;
        }
        function baseDelay(func, wait, args) {
          if (typeof func != "function") {
            throw new TypeError2(FUNC_ERROR_TEXT);
          }
          return setTimeout2(function() {
            func.apply(undefined2, args);
          }, wait);
        }
        function baseDifference(array, values2, iteratee2, comparator) {
          var index = -1, includes2 = arrayIncludes, isCommon = true, length = array.length, result2 = [], valuesLength = values2.length;
          if (!length) {
            return result2;
          }
          if (iteratee2) {
            values2 = arrayMap(values2, baseUnary(iteratee2));
          }
          if (comparator) {
            includes2 = arrayIncludesWith;
            isCommon = false;
          } else if (values2.length >= LARGE_ARRAY_SIZE) {
            includes2 = cacheHas;
            isCommon = false;
            values2 = new SetCache(values2);
          }
          outer:
            while (++index < length) {
              var value = array[index], computed = iteratee2 == null ? value : iteratee2(value);
              value = comparator || value !== 0 ? value : 0;
              if (isCommon && computed === computed) {
                var valuesIndex = valuesLength;
                while (valuesIndex--) {
                  if (values2[valuesIndex] === computed) {
                    continue outer;
                  }
                }
                result2.push(value);
              } else if (!includes2(values2, computed, comparator)) {
                result2.push(value);
              }
            }
          return result2;
        }
        var baseEach = createBaseEach(baseForOwn);
        var baseEachRight = createBaseEach(baseForOwnRight, true);
        function baseEvery(collection, predicate) {
          var result2 = true;
          baseEach(collection, function(value, index, collection2) {
            result2 = !!predicate(value, index, collection2);
            return result2;
          });
          return result2;
        }
        function baseExtremum(array, iteratee2, comparator) {
          var index = -1, length = array.length;
          while (++index < length) {
            var value = array[index], current = iteratee2(value);
            if (current != null && (computed === undefined2 ? current === current && !isSymbol(current) : comparator(current, computed))) {
              var computed = current, result2 = value;
            }
          }
          return result2;
        }
        function baseFill(array, value, start, end) {
          var length = array.length;
          start = toInteger(start);
          if (start < 0) {
            start = -start > length ? 0 : length + start;
          }
          end = end === undefined2 || end > length ? length : toInteger(end);
          if (end < 0) {
            end += length;
          }
          end = start > end ? 0 : toLength(end);
          while (start < end) {
            array[start++] = value;
          }
          return array;
        }
        function baseFilter(collection, predicate) {
          var result2 = [];
          baseEach(collection, function(value, index, collection2) {
            if (predicate(value, index, collection2)) {
              result2.push(value);
            }
          });
          return result2;
        }
        function baseFlatten(array, depth, predicate, isStrict, result2) {
          var index = -1, length = array.length;
          predicate || (predicate = isFlattenable);
          result2 || (result2 = []);
          while (++index < length) {
            var value = array[index];
            if (depth > 0 && predicate(value)) {
              if (depth > 1) {
                baseFlatten(value, depth - 1, predicate, isStrict, result2);
              } else {
                arrayPush(result2, value);
              }
            } else if (!isStrict) {
              result2[result2.length] = value;
            }
          }
          return result2;
        }
        var baseFor = createBaseFor();
        var baseForRight = createBaseFor(true);
        function baseForOwn(object, iteratee2) {
          return object && baseFor(object, iteratee2, keys);
        }
        function baseForOwnRight(object, iteratee2) {
          return object && baseForRight(object, iteratee2, keys);
        }
        function baseFunctions(object, props) {
          return arrayFilter(props, function(key) {
            return isFunction(object[key]);
          });
        }
        function baseGet(object, path2) {
          path2 = castPath(path2, object);
          var index = 0, length = path2.length;
          while (object != null && index < length) {
            object = object[toKey(path2[index++])];
          }
          return index && index == length ? object : undefined2;
        }
        function baseGetAllKeys(object, keysFunc, symbolsFunc) {
          var result2 = keysFunc(object);
          return isArray(object) ? result2 : arrayPush(result2, symbolsFunc(object));
        }
        function baseGetTag(value) {
          if (value == null) {
            return value === undefined2 ? undefinedTag : nullTag;
          }
          return symToStringTag && symToStringTag in Object2(value) ? getRawTag(value) : objectToString(value);
        }
        function baseGt(value, other) {
          return value > other;
        }
        function baseHas(object, key) {
          return object != null && hasOwnProperty.call(object, key);
        }
        function baseHasIn(object, key) {
          return object != null && key in Object2(object);
        }
        function baseInRange(number, start, end) {
          return number >= nativeMin(start, end) && number < nativeMax(start, end);
        }
        function baseIntersection(arrays, iteratee2, comparator) {
          var includes2 = comparator ? arrayIncludesWith : arrayIncludes, length = arrays[0].length, othLength = arrays.length, othIndex = othLength, caches = Array2(othLength), maxLength = Infinity, result2 = [];
          while (othIndex--) {
            var array = arrays[othIndex];
            if (othIndex && iteratee2) {
              array = arrayMap(array, baseUnary(iteratee2));
            }
            maxLength = nativeMin(array.length, maxLength);
            caches[othIndex] = !comparator && (iteratee2 || length >= 120 && array.length >= 120) ? new SetCache(othIndex && array) : undefined2;
          }
          array = arrays[0];
          var index = -1, seen = caches[0];
          outer:
            while (++index < length && result2.length < maxLength) {
              var value = array[index], computed = iteratee2 ? iteratee2(value) : value;
              value = comparator || value !== 0 ? value : 0;
              if (!(seen ? cacheHas(seen, computed) : includes2(result2, computed, comparator))) {
                othIndex = othLength;
                while (--othIndex) {
                  var cache = caches[othIndex];
                  if (!(cache ? cacheHas(cache, computed) : includes2(arrays[othIndex], computed, comparator))) {
                    continue outer;
                  }
                }
                if (seen) {
                  seen.push(computed);
                }
                result2.push(value);
              }
            }
          return result2;
        }
        function baseInverter(object, setter, iteratee2, accumulator) {
          baseForOwn(object, function(value, key, object2) {
            setter(accumulator, iteratee2(value), key, object2);
          });
          return accumulator;
        }
        function baseInvoke(object, path2, args) {
          path2 = castPath(path2, object);
          object = parent(object, path2);
          var func = object == null ? object : object[toKey(last(path2))];
          return func == null ? undefined2 : apply(func, object, args);
        }
        function baseIsArguments(value) {
          return isObjectLike(value) && baseGetTag(value) == argsTag;
        }
        function baseIsArrayBuffer(value) {
          return isObjectLike(value) && baseGetTag(value) == arrayBufferTag;
        }
        function baseIsDate(value) {
          return isObjectLike(value) && baseGetTag(value) == dateTag;
        }
        function baseIsEqual(value, other, bitmask, customizer, stack) {
          if (value === other) {
            return true;
          }
          if (value == null || other == null || !isObjectLike(value) && !isObjectLike(other)) {
            return value !== value && other !== other;
          }
          return baseIsEqualDeep(value, other, bitmask, customizer, baseIsEqual, stack);
        }
        function baseIsEqualDeep(object, other, bitmask, customizer, equalFunc, stack) {
          var objIsArr = isArray(object), othIsArr = isArray(other), objTag = objIsArr ? arrayTag : getTag(object), othTag = othIsArr ? arrayTag : getTag(other);
          objTag = objTag == argsTag ? objectTag : objTag;
          othTag = othTag == argsTag ? objectTag : othTag;
          var objIsObj = objTag == objectTag, othIsObj = othTag == objectTag, isSameTag = objTag == othTag;
          if (isSameTag && isBuffer(object)) {
            if (!isBuffer(other)) {
              return false;
            }
            objIsArr = true;
            objIsObj = false;
          }
          if (isSameTag && !objIsObj) {
            stack || (stack = new Stack());
            return objIsArr || isTypedArray(object) ? equalArrays(object, other, bitmask, customizer, equalFunc, stack) : equalByTag(object, other, objTag, bitmask, customizer, equalFunc, stack);
          }
          if (!(bitmask & COMPARE_PARTIAL_FLAG)) {
            var objIsWrapped = objIsObj && hasOwnProperty.call(object, "__wrapped__"), othIsWrapped = othIsObj && hasOwnProperty.call(other, "__wrapped__");
            if (objIsWrapped || othIsWrapped) {
              var objUnwrapped = objIsWrapped ? object.value() : object, othUnwrapped = othIsWrapped ? other.value() : other;
              stack || (stack = new Stack());
              return equalFunc(objUnwrapped, othUnwrapped, bitmask, customizer, stack);
            }
          }
          if (!isSameTag) {
            return false;
          }
          stack || (stack = new Stack());
          return equalObjects(object, other, bitmask, customizer, equalFunc, stack);
        }
        function baseIsMap(value) {
          return isObjectLike(value) && getTag(value) == mapTag;
        }
        function baseIsMatch(object, source, matchData, customizer) {
          var index = matchData.length, length = index, noCustomizer = !customizer;
          if (object == null) {
            return !length;
          }
          object = Object2(object);
          while (index--) {
            var data = matchData[index];
            if (noCustomizer && data[2] ? data[1] !== object[data[0]] : !(data[0] in object)) {
              return false;
            }
          }
          while (++index < length) {
            data = matchData[index];
            var key = data[0], objValue = object[key], srcValue = data[1];
            if (noCustomizer && data[2]) {
              if (objValue === undefined2 && !(key in object)) {
                return false;
              }
            } else {
              var stack = new Stack();
              if (customizer) {
                var result2 = customizer(objValue, srcValue, key, object, source, stack);
              }
              if (!(result2 === undefined2 ? baseIsEqual(srcValue, objValue, COMPARE_PARTIAL_FLAG | COMPARE_UNORDERED_FLAG, customizer, stack) : result2)) {
                return false;
              }
            }
          }
          return true;
        }
        function baseIsNative(value) {
          if (!isObject(value) || isMasked(value)) {
            return false;
          }
          var pattern = isFunction(value) ? reIsNative : reIsHostCtor;
          return pattern.test(toSource(value));
        }
        function baseIsRegExp(value) {
          return isObjectLike(value) && baseGetTag(value) == regexpTag;
        }
        function baseIsSet(value) {
          return isObjectLike(value) && getTag(value) == setTag;
        }
        function baseIsTypedArray(value) {
          return isObjectLike(value) && isLength(value.length) && !!typedArrayTags[baseGetTag(value)];
        }
        function baseIteratee(value) {
          if (typeof value == "function") {
            return value;
          }
          if (value == null) {
            return identity;
          }
          if (typeof value == "object") {
            return isArray(value) ? baseMatchesProperty(value[0], value[1]) : baseMatches(value);
          }
          return property(value);
        }
        function baseKeys(object) {
          if (!isPrototype(object)) {
            return nativeKeys(object);
          }
          var result2 = [];
          for (var key in Object2(object)) {
            if (hasOwnProperty.call(object, key) && key != "constructor") {
              result2.push(key);
            }
          }
          return result2;
        }
        function baseKeysIn(object) {
          if (!isObject(object)) {
            return nativeKeysIn(object);
          }
          var isProto = isPrototype(object), result2 = [];
          for (var key in object) {
            if (!(key == "constructor" && (isProto || !hasOwnProperty.call(object, key)))) {
              result2.push(key);
            }
          }
          return result2;
        }
        function baseLt(value, other) {
          return value < other;
        }
        function baseMap(collection, iteratee2) {
          var index = -1, result2 = isArrayLike(collection) ? Array2(collection.length) : [];
          baseEach(collection, function(value, key, collection2) {
            result2[++index] = iteratee2(value, key, collection2);
          });
          return result2;
        }
        function baseMatches(source) {
          var matchData = getMatchData(source);
          if (matchData.length == 1 && matchData[0][2]) {
            return matchesStrictComparable(matchData[0][0], matchData[0][1]);
          }
          return function(object) {
            return object === source || baseIsMatch(object, source, matchData);
          };
        }
        function baseMatchesProperty(path2, srcValue) {
          if (isKey(path2) && isStrictComparable(srcValue)) {
            return matchesStrictComparable(toKey(path2), srcValue);
          }
          return function(object) {
            var objValue = get(object, path2);
            return objValue === undefined2 && objValue === srcValue ? hasIn(object, path2) : baseIsEqual(srcValue, objValue, COMPARE_PARTIAL_FLAG | COMPARE_UNORDERED_FLAG);
          };
        }
        function baseMerge(object, source, srcIndex, customizer, stack) {
          if (object === source) {
            return;
          }
          baseFor(source, function(srcValue, key) {
            stack || (stack = new Stack());
            if (isObject(srcValue)) {
              baseMergeDeep(object, source, key, srcIndex, baseMerge, customizer, stack);
            } else {
              var newValue = customizer ? customizer(safeGet(object, key), srcValue, key + "", object, source, stack) : undefined2;
              if (newValue === undefined2) {
                newValue = srcValue;
              }
              assignMergeValue(object, key, newValue);
            }
          }, keysIn);
        }
        function baseMergeDeep(object, source, key, srcIndex, mergeFunc, customizer, stack) {
          var objValue = safeGet(object, key), srcValue = safeGet(source, key), stacked = stack.get(srcValue);
          if (stacked) {
            assignMergeValue(object, key, stacked);
            return;
          }
          var newValue = customizer ? customizer(objValue, srcValue, key + "", object, source, stack) : undefined2;
          var isCommon = newValue === undefined2;
          if (isCommon) {
            var isArr = isArray(srcValue), isBuff = !isArr && isBuffer(srcValue), isTyped = !isArr && !isBuff && isTypedArray(srcValue);
            newValue = srcValue;
            if (isArr || isBuff || isTyped) {
              if (isArray(objValue)) {
                newValue = objValue;
              } else if (isArrayLikeObject(objValue)) {
                newValue = copyArray(objValue);
              } else if (isBuff) {
                isCommon = false;
                newValue = cloneBuffer(srcValue, true);
              } else if (isTyped) {
                isCommon = false;
                newValue = cloneTypedArray(srcValue, true);
              } else {
                newValue = [];
              }
            } else if (isPlainObject(srcValue) || isArguments(srcValue)) {
              newValue = objValue;
              if (isArguments(objValue)) {
                newValue = toPlainObject(objValue);
              } else if (!isObject(objValue) || isFunction(objValue)) {
                newValue = initCloneObject(srcValue);
              }
            } else {
              isCommon = false;
            }
          }
          if (isCommon) {
            stack.set(srcValue, newValue);
            mergeFunc(newValue, srcValue, srcIndex, customizer, stack);
            stack["delete"](srcValue);
          }
          assignMergeValue(object, key, newValue);
        }
        function baseNth(array, n) {
          var length = array.length;
          if (!length) {
            return;
          }
          n += n < 0 ? length : 0;
          return isIndex(n, length) ? array[n] : undefined2;
        }
        function baseOrderBy(collection, iteratees, orders) {
          if (iteratees.length) {
            iteratees = arrayMap(iteratees, function(iteratee2) {
              if (isArray(iteratee2)) {
                return function(value) {
                  return baseGet(value, iteratee2.length === 1 ? iteratee2[0] : iteratee2);
                };
              }
              return iteratee2;
            });
          } else {
            iteratees = [identity];
          }
          var index = -1;
          iteratees = arrayMap(iteratees, baseUnary(getIteratee()));
          var result2 = baseMap(collection, function(value, key, collection2) {
            var criteria = arrayMap(iteratees, function(iteratee2) {
              return iteratee2(value);
            });
            return { "criteria": criteria, "index": ++index, "value": value };
          });
          return baseSortBy(result2, function(object, other) {
            return compareMultiple(object, other, orders);
          });
        }
        function basePick(object, paths) {
          return basePickBy(object, paths, function(value, path2) {
            return hasIn(object, path2);
          });
        }
        function basePickBy(object, paths, predicate) {
          var index = -1, length = paths.length, result2 = {};
          while (++index < length) {
            var path2 = paths[index], value = baseGet(object, path2);
            if (predicate(value, path2)) {
              baseSet(result2, castPath(path2, object), value);
            }
          }
          return result2;
        }
        function basePropertyDeep(path2) {
          return function(object) {
            return baseGet(object, path2);
          };
        }
        function basePullAll(array, values2, iteratee2, comparator) {
          var indexOf2 = comparator ? baseIndexOfWith : baseIndexOf, index = -1, length = values2.length, seen = array;
          if (array === values2) {
            values2 = copyArray(values2);
          }
          if (iteratee2) {
            seen = arrayMap(array, baseUnary(iteratee2));
          }
          while (++index < length) {
            var fromIndex = 0, value = values2[index], computed = iteratee2 ? iteratee2(value) : value;
            while ((fromIndex = indexOf2(seen, computed, fromIndex, comparator)) > -1) {
              if (seen !== array) {
                splice.call(seen, fromIndex, 1);
              }
              splice.call(array, fromIndex, 1);
            }
          }
          return array;
        }
        function basePullAt(array, indexes) {
          var length = array ? indexes.length : 0, lastIndex = length - 1;
          while (length--) {
            var index = indexes[length];
            if (length == lastIndex || index !== previous) {
              var previous = index;
              if (isIndex(index)) {
                splice.call(array, index, 1);
              } else {
                baseUnset(array, index);
              }
            }
          }
          return array;
        }
        function baseRandom(lower, upper) {
          return lower + nativeFloor(nativeRandom() * (upper - lower + 1));
        }
        function baseRange(start, end, step, fromRight) {
          var index = -1, length = nativeMax(nativeCeil((end - start) / (step || 1)), 0), result2 = Array2(length);
          while (length--) {
            result2[fromRight ? length : ++index] = start;
            start += step;
          }
          return result2;
        }
        function baseRepeat(string, n) {
          var result2 = "";
          if (!string || n < 1 || n > MAX_SAFE_INTEGER) {
            return result2;
          }
          do {
            if (n % 2) {
              result2 += string;
            }
            n = nativeFloor(n / 2);
            if (n) {
              string += string;
            }
          } while (n);
          return result2;
        }
        function baseRest(func, start) {
          return setToString(overRest(func, start, identity), func + "");
        }
        function baseSample(collection) {
          return arraySample(values(collection));
        }
        function baseSampleSize(collection, n) {
          var array = values(collection);
          return shuffleSelf(array, baseClamp(n, 0, array.length));
        }
        function baseSet(object, path2, value, customizer) {
          if (!isObject(object)) {
            return object;
          }
          path2 = castPath(path2, object);
          var index = -1, length = path2.length, lastIndex = length - 1, nested = object;
          while (nested != null && ++index < length) {
            var key = toKey(path2[index]), newValue = value;
            if (key === "__proto__" || key === "constructor" || key === "prototype") {
              return object;
            }
            if (index != lastIndex) {
              var objValue = nested[key];
              newValue = customizer ? customizer(objValue, key, nested) : undefined2;
              if (newValue === undefined2) {
                newValue = isObject(objValue) ? objValue : isIndex(path2[index + 1]) ? [] : {};
              }
            }
            assignValue(nested, key, newValue);
            nested = nested[key];
          }
          return object;
        }
        var baseSetData = !metaMap ? identity : function(func, data) {
          metaMap.set(func, data);
          return func;
        };
        var baseSetToString = !defineProperty ? identity : function(func, string) {
          return defineProperty(func, "toString", {
            "configurable": true,
            "enumerable": false,
            "value": constant(string),
            "writable": true
          });
        };
        function baseShuffle(collection) {
          return shuffleSelf(values(collection));
        }
        function baseSlice(array, start, end) {
          var index = -1, length = array.length;
          if (start < 0) {
            start = -start > length ? 0 : length + start;
          }
          end = end > length ? length : end;
          if (end < 0) {
            end += length;
          }
          length = start > end ? 0 : end - start >>> 0;
          start >>>= 0;
          var result2 = Array2(length);
          while (++index < length) {
            result2[index] = array[index + start];
          }
          return result2;
        }
        function baseSome(collection, predicate) {
          var result2;
          baseEach(collection, function(value, index, collection2) {
            result2 = predicate(value, index, collection2);
            return !result2;
          });
          return !!result2;
        }
        function baseSortedIndex(array, value, retHighest) {
          var low = 0, high = array == null ? low : array.length;
          if (typeof value == "number" && value === value && high <= HALF_MAX_ARRAY_LENGTH) {
            while (low < high) {
              var mid = low + high >>> 1, computed = array[mid];
              if (computed !== null && !isSymbol(computed) && (retHighest ? computed <= value : computed < value)) {
                low = mid + 1;
              } else {
                high = mid;
              }
            }
            return high;
          }
          return baseSortedIndexBy(array, value, identity, retHighest);
        }
        function baseSortedIndexBy(array, value, iteratee2, retHighest) {
          var low = 0, high = array == null ? 0 : array.length;
          if (high === 0) {
            return 0;
          }
          value = iteratee2(value);
          var valIsNaN = value !== value, valIsNull = value === null, valIsSymbol = isSymbol(value), valIsUndefined = value === undefined2;
          while (low < high) {
            var mid = nativeFloor((low + high) / 2), computed = iteratee2(array[mid]), othIsDefined = computed !== undefined2, othIsNull = computed === null, othIsReflexive = computed === computed, othIsSymbol = isSymbol(computed);
            if (valIsNaN) {
              var setLow = retHighest || othIsReflexive;
            } else if (valIsUndefined) {
              setLow = othIsReflexive && (retHighest || othIsDefined);
            } else if (valIsNull) {
              setLow = othIsReflexive && othIsDefined && (retHighest || !othIsNull);
            } else if (valIsSymbol) {
              setLow = othIsReflexive && othIsDefined && !othIsNull && (retHighest || !othIsSymbol);
            } else if (othIsNull || othIsSymbol) {
              setLow = false;
            } else {
              setLow = retHighest ? computed <= value : computed < value;
            }
            if (setLow) {
              low = mid + 1;
            } else {
              high = mid;
            }
          }
          return nativeMin(high, MAX_ARRAY_INDEX);
        }
        function baseSortedUniq(array, iteratee2) {
          var index = -1, length = array.length, resIndex = 0, result2 = [];
          while (++index < length) {
            var value = array[index], computed = iteratee2 ? iteratee2(value) : value;
            if (!index || !eq(computed, seen)) {
              var seen = computed;
              result2[resIndex++] = value === 0 ? 0 : value;
            }
          }
          return result2;
        }
        function baseToNumber(value) {
          if (typeof value == "number") {
            return value;
          }
          if (isSymbol(value)) {
            return NAN;
          }
          return +value;
        }
        function baseToString(value) {
          if (typeof value == "string") {
            return value;
          }
          if (isArray(value)) {
            return arrayMap(value, baseToString) + "";
          }
          if (isSymbol(value)) {
            return symbolToString ? symbolToString.call(value) : "";
          }
          var result2 = value + "";
          return result2 == "0" && 1 / value == -INFINITY ? "-0" : result2;
        }
        function baseUniq(array, iteratee2, comparator) {
          var index = -1, includes2 = arrayIncludes, length = array.length, isCommon = true, result2 = [], seen = result2;
          if (comparator) {
            isCommon = false;
            includes2 = arrayIncludesWith;
          } else if (length >= LARGE_ARRAY_SIZE) {
            var set2 = iteratee2 ? null : createSet(array);
            if (set2) {
              return setToArray(set2);
            }
            isCommon = false;
            includes2 = cacheHas;
            seen = new SetCache();
          } else {
            seen = iteratee2 ? [] : result2;
          }
          outer:
            while (++index < length) {
              var value = array[index], computed = iteratee2 ? iteratee2(value) : value;
              value = comparator || value !== 0 ? value : 0;
              if (isCommon && computed === computed) {
                var seenIndex = seen.length;
                while (seenIndex--) {
                  if (seen[seenIndex] === computed) {
                    continue outer;
                  }
                }
                if (iteratee2) {
                  seen.push(computed);
                }
                result2.push(value);
              } else if (!includes2(seen, computed, comparator)) {
                if (seen !== result2) {
                  seen.push(computed);
                }
                result2.push(value);
              }
            }
          return result2;
        }
        function baseUnset(object, path2) {
          path2 = castPath(path2, object);
          var index = -1, length = path2.length;
          if (!length) {
            return true;
          }
          var isRootPrimitive = object == null || typeof object !== "object" && typeof object !== "function";
          while (++index < length) {
            var key = path2[index];
            if (typeof key !== "string") {
              continue;
            }
            if (key === "__proto__" && !hasOwnProperty.call(object, "__proto__")) {
              return false;
            }
            if (key === "constructor" && index + 1 < length && typeof path2[index + 1] === "string" && path2[index + 1] === "prototype") {
              if (isRootPrimitive && index === 0) {
                continue;
              }
              return false;
            }
          }
          var obj = parent(object, path2);
          return obj == null || delete obj[toKey(last(path2))];
        }
        function baseUpdate(object, path2, updater, customizer) {
          return baseSet(object, path2, updater(baseGet(object, path2)), customizer);
        }
        function baseWhile(array, predicate, isDrop, fromRight) {
          var length = array.length, index = fromRight ? length : -1;
          while ((fromRight ? index-- : ++index < length) && predicate(array[index], index, array)) {
          }
          return isDrop ? baseSlice(array, fromRight ? 0 : index, fromRight ? index + 1 : length) : baseSlice(array, fromRight ? index + 1 : 0, fromRight ? length : index);
        }
        function baseWrapperValue(value, actions) {
          var result2 = value;
          if (result2 instanceof LazyWrapper) {
            result2 = result2.value();
          }
          return arrayReduce(actions, function(result3, action) {
            return action.func.apply(action.thisArg, arrayPush([result3], action.args));
          }, result2);
        }
        function baseXor(arrays, iteratee2, comparator) {
          var length = arrays.length;
          if (length < 2) {
            return length ? baseUniq(arrays[0]) : [];
          }
          var index = -1, result2 = Array2(length);
          while (++index < length) {
            var array = arrays[index], othIndex = -1;
            while (++othIndex < length) {
              if (othIndex != index) {
                result2[index] = baseDifference(result2[index] || array, arrays[othIndex], iteratee2, comparator);
              }
            }
          }
          return baseUniq(baseFlatten(result2, 1), iteratee2, comparator);
        }
        function baseZipObject(props, values2, assignFunc) {
          var index = -1, length = props.length, valsLength = values2.length, result2 = {};
          while (++index < length) {
            var value = index < valsLength ? values2[index] : undefined2;
            assignFunc(result2, props[index], value);
          }
          return result2;
        }
        function castArrayLikeObject(value) {
          return isArrayLikeObject(value) ? value : [];
        }
        function castFunction(value) {
          return typeof value == "function" ? value : identity;
        }
        function castPath(value, object) {
          if (isArray(value)) {
            return value;
          }
          return isKey(value, object) ? [value] : stringToPath(toString(value));
        }
        var castRest = baseRest;
        function castSlice(array, start, end) {
          var length = array.length;
          end = end === undefined2 ? length : end;
          return !start && end >= length ? array : baseSlice(array, start, end);
        }
        var clearTimeout2 = ctxClearTimeout || function(id) {
          return root.clearTimeout(id);
        };
        function cloneBuffer(buffer, isDeep) {
          if (isDeep) {
            return buffer.slice();
          }
          var length = buffer.length, result2 = allocUnsafe ? allocUnsafe(length) : new buffer.constructor(length);
          buffer.copy(result2);
          return result2;
        }
        function cloneArrayBuffer(arrayBuffer) {
          var result2 = new arrayBuffer.constructor(arrayBuffer.byteLength);
          new Uint8Array2(result2).set(new Uint8Array2(arrayBuffer));
          return result2;
        }
        function cloneDataView(dataView, isDeep) {
          var buffer = isDeep ? cloneArrayBuffer(dataView.buffer) : dataView.buffer;
          return new dataView.constructor(buffer, dataView.byteOffset, dataView.byteLength);
        }
        function cloneRegExp(regexp) {
          var result2 = new regexp.constructor(regexp.source, reFlags.exec(regexp));
          result2.lastIndex = regexp.lastIndex;
          return result2;
        }
        function cloneSymbol(symbol) {
          return symbolValueOf ? Object2(symbolValueOf.call(symbol)) : {};
        }
        function cloneTypedArray(typedArray, isDeep) {
          var buffer = isDeep ? cloneArrayBuffer(typedArray.buffer) : typedArray.buffer;
          return new typedArray.constructor(buffer, typedArray.byteOffset, typedArray.length);
        }
        function compareAscending(value, other) {
          if (value !== other) {
            var valIsDefined = value !== undefined2, valIsNull = value === null, valIsReflexive = value === value, valIsSymbol = isSymbol(value);
            var othIsDefined = other !== undefined2, othIsNull = other === null, othIsReflexive = other === other, othIsSymbol = isSymbol(other);
            if (!othIsNull && !othIsSymbol && !valIsSymbol && value > other || valIsSymbol && othIsDefined && othIsReflexive && !othIsNull && !othIsSymbol || valIsNull && othIsDefined && othIsReflexive || !valIsDefined && othIsReflexive || !valIsReflexive) {
              return 1;
            }
            if (!valIsNull && !valIsSymbol && !othIsSymbol && value < other || othIsSymbol && valIsDefined && valIsReflexive && !valIsNull && !valIsSymbol || othIsNull && valIsDefined && valIsReflexive || !othIsDefined && valIsReflexive || !othIsReflexive) {
              return -1;
            }
          }
          return 0;
        }
        function compareMultiple(object, other, orders) {
          var index = -1, objCriteria = object.criteria, othCriteria = other.criteria, length = objCriteria.length, ordersLength = orders.length;
          while (++index < length) {
            var result2 = compareAscending(objCriteria[index], othCriteria[index]);
            if (result2) {
              if (index >= ordersLength) {
                return result2;
              }
              var order = orders[index];
              return result2 * (order == "desc" ? -1 : 1);
            }
          }
          return object.index - other.index;
        }
        function composeArgs(args, partials, holders, isCurried) {
          var argsIndex = -1, argsLength = args.length, holdersLength = holders.length, leftIndex = -1, leftLength = partials.length, rangeLength = nativeMax(argsLength - holdersLength, 0), result2 = Array2(leftLength + rangeLength), isUncurried = !isCurried;
          while (++leftIndex < leftLength) {
            result2[leftIndex] = partials[leftIndex];
          }
          while (++argsIndex < holdersLength) {
            if (isUncurried || argsIndex < argsLength) {
              result2[holders[argsIndex]] = args[argsIndex];
            }
          }
          while (rangeLength--) {
            result2[leftIndex++] = args[argsIndex++];
          }
          return result2;
        }
        function composeArgsRight(args, partials, holders, isCurried) {
          var argsIndex = -1, argsLength = args.length, holdersIndex = -1, holdersLength = holders.length, rightIndex = -1, rightLength = partials.length, rangeLength = nativeMax(argsLength - holdersLength, 0), result2 = Array2(rangeLength + rightLength), isUncurried = !isCurried;
          while (++argsIndex < rangeLength) {
            result2[argsIndex] = args[argsIndex];
          }
          var offset = argsIndex;
          while (++rightIndex < rightLength) {
            result2[offset + rightIndex] = partials[rightIndex];
          }
          while (++holdersIndex < holdersLength) {
            if (isUncurried || argsIndex < argsLength) {
              result2[offset + holders[holdersIndex]] = args[argsIndex++];
            }
          }
          return result2;
        }
        function copyArray(source, array) {
          var index = -1, length = source.length;
          array || (array = Array2(length));
          while (++index < length) {
            array[index] = source[index];
          }
          return array;
        }
        function copyObject(source, props, object, customizer) {
          var isNew = !object;
          object || (object = {});
          var index = -1, length = props.length;
          while (++index < length) {
            var key = props[index];
            var newValue = customizer ? customizer(object[key], source[key], key, object, source) : undefined2;
            if (newValue === undefined2) {
              newValue = source[key];
            }
            if (isNew) {
              baseAssignValue(object, key, newValue);
            } else {
              assignValue(object, key, newValue);
            }
          }
          return object;
        }
        function copySymbols(source, object) {
          return copyObject(source, getSymbols(source), object);
        }
        function copySymbolsIn(source, object) {
          return copyObject(source, getSymbolsIn(source), object);
        }
        function createAggregator(setter, initializer) {
          return function(collection, iteratee2) {
            var func = isArray(collection) ? arrayAggregator : baseAggregator, accumulator = initializer ? initializer() : {};
            return func(collection, setter, getIteratee(iteratee2, 2), accumulator);
          };
        }
        function createAssigner(assigner) {
          return baseRest(function(object, sources) {
            var index = -1, length = sources.length, customizer = length > 1 ? sources[length - 1] : undefined2, guard = length > 2 ? sources[2] : undefined2;
            customizer = assigner.length > 3 && typeof customizer == "function" ? (length--, customizer) : undefined2;
            if (guard && isIterateeCall(sources[0], sources[1], guard)) {
              customizer = length < 3 ? undefined2 : customizer;
              length = 1;
            }
            object = Object2(object);
            while (++index < length) {
              var source = sources[index];
              if (source) {
                assigner(object, source, index, customizer);
              }
            }
            return object;
          });
        }
        function createBaseEach(eachFunc, fromRight) {
          return function(collection, iteratee2) {
            if (collection == null) {
              return collection;
            }
            if (!isArrayLike(collection)) {
              return eachFunc(collection, iteratee2);
            }
            var length = collection.length, index = fromRight ? length : -1, iterable = Object2(collection);
            while (fromRight ? index-- : ++index < length) {
              if (iteratee2(iterable[index], index, iterable) === false) {
                break;
              }
            }
            return collection;
          };
        }
        function createBaseFor(fromRight) {
          return function(object, iteratee2, keysFunc) {
            var index = -1, iterable = Object2(object), props = keysFunc(object), length = props.length;
            while (length--) {
              var key = props[fromRight ? length : ++index];
              if (iteratee2(iterable[key], key, iterable) === false) {
                break;
              }
            }
            return object;
          };
        }
        function createBind(func, bitmask, thisArg) {
          var isBind = bitmask & WRAP_BIND_FLAG, Ctor = createCtor(func);
          function wrapper() {
            var fn = this && this !== root && this instanceof wrapper ? Ctor : func;
            return fn.apply(isBind ? thisArg : this, arguments);
          }
          return wrapper;
        }
        function createCaseFirst(methodName) {
          return function(string) {
            string = toString(string);
            var strSymbols = hasUnicode(string) ? stringToArray(string) : undefined2;
            var chr = strSymbols ? strSymbols[0] : string.charAt(0);
            var trailing = strSymbols ? castSlice(strSymbols, 1).join("") : string.slice(1);
            return chr[methodName]() + trailing;
          };
        }
        function createCompounder(callback) {
          return function(string) {
            return arrayReduce(words(deburr(string).replace(reApos, "")), callback, "");
          };
        }
        function createCtor(Ctor) {
          return function() {
            var args = arguments;
            switch (args.length) {
              case 0:
                return new Ctor();
              case 1:
                return new Ctor(args[0]);
              case 2:
                return new Ctor(args[0], args[1]);
              case 3:
                return new Ctor(args[0], args[1], args[2]);
              case 4:
                return new Ctor(args[0], args[1], args[2], args[3]);
              case 5:
                return new Ctor(args[0], args[1], args[2], args[3], args[4]);
              case 6:
                return new Ctor(args[0], args[1], args[2], args[3], args[4], args[5]);
              case 7:
                return new Ctor(args[0], args[1], args[2], args[3], args[4], args[5], args[6]);
            }
            var thisBinding = baseCreate(Ctor.prototype), result2 = Ctor.apply(thisBinding, args);
            return isObject(result2) ? result2 : thisBinding;
          };
        }
        function createCurry(func, bitmask, arity) {
          var Ctor = createCtor(func);
          function wrapper() {
            var length = arguments.length, args = Array2(length), index = length, placeholder = getHolder(wrapper);
            while (index--) {
              args[index] = arguments[index];
            }
            var holders = length < 3 && args[0] !== placeholder && args[length - 1] !== placeholder ? [] : replaceHolders(args, placeholder);
            length -= holders.length;
            if (length < arity) {
              return createRecurry(
                func,
                bitmask,
                createHybrid,
                wrapper.placeholder,
                undefined2,
                args,
                holders,
                undefined2,
                undefined2,
                arity - length
              );
            }
            var fn = this && this !== root && this instanceof wrapper ? Ctor : func;
            return apply(fn, this, args);
          }
          return wrapper;
        }
        function createFind(findIndexFunc) {
          return function(collection, predicate, fromIndex) {
            var iterable = Object2(collection);
            if (!isArrayLike(collection)) {
              var iteratee2 = getIteratee(predicate, 3);
              collection = keys(collection);
              predicate = function(key) {
                return iteratee2(iterable[key], key, iterable);
              };
            }
            var index = findIndexFunc(collection, predicate, fromIndex);
            return index > -1 ? iterable[iteratee2 ? collection[index] : index] : undefined2;
          };
        }
        function createFlow(fromRight) {
          return flatRest(function(funcs) {
            var length = funcs.length, index = length, prereq = LodashWrapper.prototype.thru;
            if (fromRight) {
              funcs.reverse();
            }
            while (index--) {
              var func = funcs[index];
              if (typeof func != "function") {
                throw new TypeError2(FUNC_ERROR_TEXT);
              }
              if (prereq && !wrapper && getFuncName(func) == "wrapper") {
                var wrapper = new LodashWrapper([], true);
              }
            }
            index = wrapper ? index : length;
            while (++index < length) {
              func = funcs[index];
              var funcName = getFuncName(func), data = funcName == "wrapper" ? getData(func) : undefined2;
              if (data && isLaziable(data[0]) && data[1] == (WRAP_ARY_FLAG | WRAP_CURRY_FLAG | WRAP_PARTIAL_FLAG | WRAP_REARG_FLAG) && !data[4].length && data[9] == 1) {
                wrapper = wrapper[getFuncName(data[0])].apply(wrapper, data[3]);
              } else {
                wrapper = func.length == 1 && isLaziable(func) ? wrapper[funcName]() : wrapper.thru(func);
              }
            }
            return function() {
              var args = arguments, value = args[0];
              if (wrapper && args.length == 1 && isArray(value)) {
                return wrapper.plant(value).value();
              }
              var index2 = 0, result2 = length ? funcs[index2].apply(this, args) : value;
              while (++index2 < length) {
                result2 = funcs[index2].call(this, result2);
              }
              return result2;
            };
          });
        }
        function createHybrid(func, bitmask, thisArg, partials, holders, partialsRight, holdersRight, argPos, ary2, arity) {
          var isAry = bitmask & WRAP_ARY_FLAG, isBind = bitmask & WRAP_BIND_FLAG, isBindKey = bitmask & WRAP_BIND_KEY_FLAG, isCurried = bitmask & (WRAP_CURRY_FLAG | WRAP_CURRY_RIGHT_FLAG), isFlip = bitmask & WRAP_FLIP_FLAG, Ctor = isBindKey ? undefined2 : createCtor(func);
          function wrapper() {
            var length = arguments.length, args = Array2(length), index = length;
            while (index--) {
              args[index] = arguments[index];
            }
            if (isCurried) {
              var placeholder = getHolder(wrapper), holdersCount = countHolders(args, placeholder);
            }
            if (partials) {
              args = composeArgs(args, partials, holders, isCurried);
            }
            if (partialsRight) {
              args = composeArgsRight(args, partialsRight, holdersRight, isCurried);
            }
            length -= holdersCount;
            if (isCurried && length < arity) {
              var newHolders = replaceHolders(args, placeholder);
              return createRecurry(
                func,
                bitmask,
                createHybrid,
                wrapper.placeholder,
                thisArg,
                args,
                newHolders,
                argPos,
                ary2,
                arity - length
              );
            }
            var thisBinding = isBind ? thisArg : this, fn = isBindKey ? thisBinding[func] : func;
            length = args.length;
            if (argPos) {
              args = reorder(args, argPos);
            } else if (isFlip && length > 1) {
              args.reverse();
            }
            if (isAry && ary2 < length) {
              args.length = ary2;
            }
            if (this && this !== root && this instanceof wrapper) {
              fn = Ctor || createCtor(fn);
            }
            return fn.apply(thisBinding, args);
          }
          return wrapper;
        }
        function createInverter(setter, toIteratee) {
          return function(object, iteratee2) {
            return baseInverter(object, setter, toIteratee(iteratee2), {});
          };
        }
        function createMathOperation(operator, defaultValue) {
          return function(value, other) {
            var result2;
            if (value === undefined2 && other === undefined2) {
              return defaultValue;
            }
            if (value !== undefined2) {
              result2 = value;
            }
            if (other !== undefined2) {
              if (result2 === undefined2) {
                return other;
              }
              if (typeof value == "string" || typeof other == "string") {
                value = baseToString(value);
                other = baseToString(other);
              } else {
                value = baseToNumber(value);
                other = baseToNumber(other);
              }
              result2 = operator(value, other);
            }
            return result2;
          };
        }
        function createOver(arrayFunc) {
          return flatRest(function(iteratees) {
            iteratees = arrayMap(iteratees, baseUnary(getIteratee()));
            return baseRest(function(args) {
              var thisArg = this;
              return arrayFunc(iteratees, function(iteratee2) {
                return apply(iteratee2, thisArg, args);
              });
            });
          });
        }
        function createPadding(length, chars) {
          chars = chars === undefined2 ? " " : baseToString(chars);
          var charsLength = chars.length;
          if (charsLength < 2) {
            return charsLength ? baseRepeat(chars, length) : chars;
          }
          var result2 = baseRepeat(chars, nativeCeil(length / stringSize(chars)));
          return hasUnicode(chars) ? castSlice(stringToArray(result2), 0, length).join("") : result2.slice(0, length);
        }
        function createPartial(func, bitmask, thisArg, partials) {
          var isBind = bitmask & WRAP_BIND_FLAG, Ctor = createCtor(func);
          function wrapper() {
            var argsIndex = -1, argsLength = arguments.length, leftIndex = -1, leftLength = partials.length, args = Array2(leftLength + argsLength), fn = this && this !== root && this instanceof wrapper ? Ctor : func;
            while (++leftIndex < leftLength) {
              args[leftIndex] = partials[leftIndex];
            }
            while (argsLength--) {
              args[leftIndex++] = arguments[++argsIndex];
            }
            return apply(fn, isBind ? thisArg : this, args);
          }
          return wrapper;
        }
        function createRange(fromRight) {
          return function(start, end, step) {
            if (step && typeof step != "number" && isIterateeCall(start, end, step)) {
              end = step = undefined2;
            }
            start = toFinite(start);
            if (end === undefined2) {
              end = start;
              start = 0;
            } else {
              end = toFinite(end);
            }
            step = step === undefined2 ? start < end ? 1 : -1 : toFinite(step);
            return baseRange(start, end, step, fromRight);
          };
        }
        function createRelationalOperation(operator) {
          return function(value, other) {
            if (!(typeof value == "string" && typeof other == "string")) {
              value = toNumber(value);
              other = toNumber(other);
            }
            return operator(value, other);
          };
        }
        function createRecurry(func, bitmask, wrapFunc, placeholder, thisArg, partials, holders, argPos, ary2, arity) {
          var isCurry = bitmask & WRAP_CURRY_FLAG, newHolders = isCurry ? holders : undefined2, newHoldersRight = isCurry ? undefined2 : holders, newPartials = isCurry ? partials : undefined2, newPartialsRight = isCurry ? undefined2 : partials;
          bitmask |= isCurry ? WRAP_PARTIAL_FLAG : WRAP_PARTIAL_RIGHT_FLAG;
          bitmask &= ~(isCurry ? WRAP_PARTIAL_RIGHT_FLAG : WRAP_PARTIAL_FLAG);
          if (!(bitmask & WRAP_CURRY_BOUND_FLAG)) {
            bitmask &= ~(WRAP_BIND_FLAG | WRAP_BIND_KEY_FLAG);
          }
          var newData = [
            func,
            bitmask,
            thisArg,
            newPartials,
            newHolders,
            newPartialsRight,
            newHoldersRight,
            argPos,
            ary2,
            arity
          ];
          var result2 = wrapFunc.apply(undefined2, newData);
          if (isLaziable(func)) {
            setData(result2, newData);
          }
          result2.placeholder = placeholder;
          return setWrapToString(result2, func, bitmask);
        }
        function createRound(methodName) {
          var func = Math2[methodName];
          return function(number, precision) {
            number = toNumber(number);
            precision = precision == null ? 0 : nativeMin(toInteger(precision), 292);
            if (precision && nativeIsFinite(number)) {
              var pair = (toString(number) + "e").split("e"), value = func(pair[0] + "e" + (+pair[1] + precision));
              pair = (toString(value) + "e").split("e");
              return +(pair[0] + "e" + (+pair[1] - precision));
            }
            return func(number);
          };
        }
        var createSet = !(Set2 && 1 / setToArray(new Set2([, -0]))[1] == INFINITY) ? noop : function(values2) {
          return new Set2(values2);
        };
        function createToPairs(keysFunc) {
          return function(object) {
            var tag = getTag(object);
            if (tag == mapTag) {
              return mapToArray(object);
            }
            if (tag == setTag) {
              return setToPairs(object);
            }
            return baseToPairs(object, keysFunc(object));
          };
        }
        function createWrap(func, bitmask, thisArg, partials, holders, argPos, ary2, arity) {
          var isBindKey = bitmask & WRAP_BIND_KEY_FLAG;
          if (!isBindKey && typeof func != "function") {
            throw new TypeError2(FUNC_ERROR_TEXT);
          }
          var length = partials ? partials.length : 0;
          if (!length) {
            bitmask &= ~(WRAP_PARTIAL_FLAG | WRAP_PARTIAL_RIGHT_FLAG);
            partials = holders = undefined2;
          }
          ary2 = ary2 === undefined2 ? ary2 : nativeMax(toInteger(ary2), 0);
          arity = arity === undefined2 ? arity : toInteger(arity);
          length -= holders ? holders.length : 0;
          if (bitmask & WRAP_PARTIAL_RIGHT_FLAG) {
            var partialsRight = partials, holdersRight = holders;
            partials = holders = undefined2;
          }
          var data = isBindKey ? undefined2 : getData(func);
          var newData = [
            func,
            bitmask,
            thisArg,
            partials,
            holders,
            partialsRight,
            holdersRight,
            argPos,
            ary2,
            arity
          ];
          if (data) {
            mergeData(newData, data);
          }
          func = newData[0];
          bitmask = newData[1];
          thisArg = newData[2];
          partials = newData[3];
          holders = newData[4];
          arity = newData[9] = newData[9] === undefined2 ? isBindKey ? 0 : func.length : nativeMax(newData[9] - length, 0);
          if (!arity && bitmask & (WRAP_CURRY_FLAG | WRAP_CURRY_RIGHT_FLAG)) {
            bitmask &= ~(WRAP_CURRY_FLAG | WRAP_CURRY_RIGHT_FLAG);
          }
          if (!bitmask || bitmask == WRAP_BIND_FLAG) {
            var result2 = createBind(func, bitmask, thisArg);
          } else if (bitmask == WRAP_CURRY_FLAG || bitmask == WRAP_CURRY_RIGHT_FLAG) {
            result2 = createCurry(func, bitmask, arity);
          } else if ((bitmask == WRAP_PARTIAL_FLAG || bitmask == (WRAP_BIND_FLAG | WRAP_PARTIAL_FLAG)) && !holders.length) {
            result2 = createPartial(func, bitmask, thisArg, partials);
          } else {
            result2 = createHybrid.apply(undefined2, newData);
          }
          var setter = data ? baseSetData : setData;
          return setWrapToString(setter(result2, newData), func, bitmask);
        }
        function customDefaultsAssignIn(objValue, srcValue, key, object) {
          if (objValue === undefined2 || eq(objValue, objectProto[key]) && !hasOwnProperty.call(object, key)) {
            return srcValue;
          }
          return objValue;
        }
        function customDefaultsMerge(objValue, srcValue, key, object, source, stack) {
          if (isObject(objValue) && isObject(srcValue)) {
            stack.set(srcValue, objValue);
            baseMerge(objValue, srcValue, undefined2, customDefaultsMerge, stack);
            stack["delete"](srcValue);
          }
          return objValue;
        }
        function customOmitClone(value) {
          return isPlainObject(value) ? undefined2 : value;
        }
        function equalArrays(array, other, bitmask, customizer, equalFunc, stack) {
          var isPartial = bitmask & COMPARE_PARTIAL_FLAG, arrLength = array.length, othLength = other.length;
          if (arrLength != othLength && !(isPartial && othLength > arrLength)) {
            return false;
          }
          var arrStacked = stack.get(array);
          var othStacked = stack.get(other);
          if (arrStacked && othStacked) {
            return arrStacked == other && othStacked == array;
          }
          var index = -1, result2 = true, seen = bitmask & COMPARE_UNORDERED_FLAG ? new SetCache() : undefined2;
          stack.set(array, other);
          stack.set(other, array);
          while (++index < arrLength) {
            var arrValue = array[index], othValue = other[index];
            if (customizer) {
              var compared = isPartial ? customizer(othValue, arrValue, index, other, array, stack) : customizer(arrValue, othValue, index, array, other, stack);
            }
            if (compared !== undefined2) {
              if (compared) {
                continue;
              }
              result2 = false;
              break;
            }
            if (seen) {
              if (!arraySome(other, function(othValue2, othIndex) {
                if (!cacheHas(seen, othIndex) && (arrValue === othValue2 || equalFunc(arrValue, othValue2, bitmask, customizer, stack))) {
                  return seen.push(othIndex);
                }
              })) {
                result2 = false;
                break;
              }
            } else if (!(arrValue === othValue || equalFunc(arrValue, othValue, bitmask, customizer, stack))) {
              result2 = false;
              break;
            }
          }
          stack["delete"](array);
          stack["delete"](other);
          return result2;
        }
        function equalByTag(object, other, tag, bitmask, customizer, equalFunc, stack) {
          switch (tag) {
            case dataViewTag:
              if (object.byteLength != other.byteLength || object.byteOffset != other.byteOffset) {
                return false;
              }
              object = object.buffer;
              other = other.buffer;
            case arrayBufferTag:
              if (object.byteLength != other.byteLength || !equalFunc(new Uint8Array2(object), new Uint8Array2(other))) {
                return false;
              }
              return true;
            case boolTag:
            case dateTag:
            case numberTag:
              return eq(+object, +other);
            case errorTag:
              return object.name == other.name && object.message == other.message;
            case regexpTag:
            case stringTag:
              return object == other + "";
            case mapTag:
              var convert = mapToArray;
            case setTag:
              var isPartial = bitmask & COMPARE_PARTIAL_FLAG;
              convert || (convert = setToArray);
              if (object.size != other.size && !isPartial) {
                return false;
              }
              var stacked = stack.get(object);
              if (stacked) {
                return stacked == other;
              }
              bitmask |= COMPARE_UNORDERED_FLAG;
              stack.set(object, other);
              var result2 = equalArrays(convert(object), convert(other), bitmask, customizer, equalFunc, stack);
              stack["delete"](object);
              return result2;
            case symbolTag:
              if (symbolValueOf) {
                return symbolValueOf.call(object) == symbolValueOf.call(other);
              }
          }
          return false;
        }
        function equalObjects(object, other, bitmask, customizer, equalFunc, stack) {
          var isPartial = bitmask & COMPARE_PARTIAL_FLAG, objProps = getAllKeys(object), objLength = objProps.length, othProps = getAllKeys(other), othLength = othProps.length;
          if (objLength != othLength && !isPartial) {
            return false;
          }
          var index = objLength;
          while (index--) {
            var key = objProps[index];
            if (!(isPartial ? key in other : hasOwnProperty.call(other, key))) {
              return false;
            }
          }
          var objStacked = stack.get(object);
          var othStacked = stack.get(other);
          if (objStacked && othStacked) {
            return objStacked == other && othStacked == object;
          }
          var result2 = true;
          stack.set(object, other);
          stack.set(other, object);
          var skipCtor = isPartial;
          while (++index < objLength) {
            key = objProps[index];
            var objValue = object[key], othValue = other[key];
            if (customizer) {
              var compared = isPartial ? customizer(othValue, objValue, key, other, object, stack) : customizer(objValue, othValue, key, object, other, stack);
            }
            if (!(compared === undefined2 ? objValue === othValue || equalFunc(objValue, othValue, bitmask, customizer, stack) : compared)) {
              result2 = false;
              break;
            }
            skipCtor || (skipCtor = key == "constructor");
          }
          if (result2 && !skipCtor) {
            var objCtor = object.constructor, othCtor = other.constructor;
            if (objCtor != othCtor && ("constructor" in object && "constructor" in other) && !(typeof objCtor == "function" && objCtor instanceof objCtor && typeof othCtor == "function" && othCtor instanceof othCtor)) {
              result2 = false;
            }
          }
          stack["delete"](object);
          stack["delete"](other);
          return result2;
        }
        function flatRest(func) {
          return setToString(overRest(func, undefined2, flatten), func + "");
        }
        function getAllKeys(object) {
          return baseGetAllKeys(object, keys, getSymbols);
        }
        function getAllKeysIn(object) {
          return baseGetAllKeys(object, keysIn, getSymbolsIn);
        }
        var getData = !metaMap ? noop : function(func) {
          return metaMap.get(func);
        };
        function getFuncName(func) {
          var result2 = func.name + "", array = realNames[result2], length = hasOwnProperty.call(realNames, result2) ? array.length : 0;
          while (length--) {
            var data = array[length], otherFunc = data.func;
            if (otherFunc == null || otherFunc == func) {
              return data.name;
            }
          }
          return result2;
        }
        function getHolder(func) {
          var object = hasOwnProperty.call(lodash, "placeholder") ? lodash : func;
          return object.placeholder;
        }
        function getIteratee() {
          var result2 = lodash.iteratee || iteratee;
          result2 = result2 === iteratee ? baseIteratee : result2;
          return arguments.length ? result2(arguments[0], arguments[1]) : result2;
        }
        function getMapData(map2, key) {
          var data = map2.__data__;
          return isKeyable(key) ? data[typeof key == "string" ? "string" : "hash"] : data.map;
        }
        function getMatchData(object) {
          var result2 = keys(object), length = result2.length;
          while (length--) {
            var key = result2[length], value = object[key];
            result2[length] = [key, value, isStrictComparable(value)];
          }
          return result2;
        }
        function getNative(object, key) {
          var value = getValue(object, key);
          return baseIsNative(value) ? value : undefined2;
        }
        function getRawTag(value) {
          var isOwn = hasOwnProperty.call(value, symToStringTag), tag = value[symToStringTag];
          try {
            value[symToStringTag] = undefined2;
            var unmasked = true;
          } catch (e) {
          }
          var result2 = nativeObjectToString.call(value);
          if (unmasked) {
            if (isOwn) {
              value[symToStringTag] = tag;
            } else {
              delete value[symToStringTag];
            }
          }
          return result2;
        }
        var getSymbols = !nativeGetSymbols ? stubArray : function(object) {
          if (object == null) {
            return [];
          }
          object = Object2(object);
          return arrayFilter(nativeGetSymbols(object), function(symbol) {
            return propertyIsEnumerable.call(object, symbol);
          });
        };
        var getSymbolsIn = !nativeGetSymbols ? stubArray : function(object) {
          var result2 = [];
          while (object) {
            arrayPush(result2, getSymbols(object));
            object = getPrototype(object);
          }
          return result2;
        };
        var getTag = baseGetTag;
        if (DataView && getTag(new DataView(new ArrayBuffer(1))) != dataViewTag || Map && getTag(new Map()) != mapTag || Promise2 && getTag(Promise2.resolve()) != promiseTag || Set2 && getTag(new Set2()) != setTag || WeakMap && getTag(new WeakMap()) != weakMapTag) {
          getTag = function(value) {
            var result2 = baseGetTag(value), Ctor = result2 == objectTag ? value.constructor : undefined2, ctorString = Ctor ? toSource(Ctor) : "";
            if (ctorString) {
              switch (ctorString) {
                case dataViewCtorString:
                  return dataViewTag;
                case mapCtorString:
                  return mapTag;
                case promiseCtorString:
                  return promiseTag;
                case setCtorString:
                  return setTag;
                case weakMapCtorString:
                  return weakMapTag;
              }
            }
            return result2;
          };
        }
        function getView(start, end, transforms) {
          var index = -1, length = transforms.length;
          while (++index < length) {
            var data = transforms[index], size2 = data.size;
            switch (data.type) {
              case "drop":
                start += size2;
                break;
              case "dropRight":
                end -= size2;
                break;
              case "take":
                end = nativeMin(end, start + size2);
                break;
              case "takeRight":
                start = nativeMax(start, end - size2);
                break;
            }
          }
          return { "start": start, "end": end };
        }
        function getWrapDetails(source) {
          var match = source.match(reWrapDetails);
          return match ? match[1].split(reSplitDetails) : [];
        }
        function hasPath(object, path2, hasFunc) {
          path2 = castPath(path2, object);
          var index = -1, length = path2.length, result2 = false;
          while (++index < length) {
            var key = toKey(path2[index]);
            if (!(result2 = object != null && hasFunc(object, key))) {
              break;
            }
            object = object[key];
          }
          if (result2 || ++index != length) {
            return result2;
          }
          length = object == null ? 0 : object.length;
          return !!length && isLength(length) && isIndex(key, length) && (isArray(object) || isArguments(object));
        }
        function initCloneArray(array) {
          var length = array.length, result2 = new array.constructor(length);
          if (length && typeof array[0] == "string" && hasOwnProperty.call(array, "index")) {
            result2.index = array.index;
            result2.input = array.input;
          }
          return result2;
        }
        function initCloneObject(object) {
          return typeof object.constructor == "function" && !isPrototype(object) ? baseCreate(getPrototype(object)) : {};
        }
        function initCloneByTag(object, tag, isDeep) {
          var Ctor = object.constructor;
          switch (tag) {
            case arrayBufferTag:
              return cloneArrayBuffer(object);
            case boolTag:
            case dateTag:
              return new Ctor(+object);
            case dataViewTag:
              return cloneDataView(object, isDeep);
            case float32Tag:
            case float64Tag:
            case int8Tag:
            case int16Tag:
            case int32Tag:
            case uint8Tag:
            case uint8ClampedTag:
            case uint16Tag:
            case uint32Tag:
              return cloneTypedArray(object, isDeep);
            case mapTag:
              return new Ctor();
            case numberTag:
            case stringTag:
              return new Ctor(object);
            case regexpTag:
              return cloneRegExp(object);
            case setTag:
              return new Ctor();
            case symbolTag:
              return cloneSymbol(object);
          }
        }
        function insertWrapDetails(source, details) {
          var length = details.length;
          if (!length) {
            return source;
          }
          var lastIndex = length - 1;
          details[lastIndex] = (length > 1 ? "& " : "") + details[lastIndex];
          details = details.join(length > 2 ? ", " : " ");
          return source.replace(reWrapComment, "{\n/* [wrapped with " + details + "] */\n");
        }
        function isFlattenable(value) {
          return isArray(value) || isArguments(value) || !!(spreadableSymbol && value && value[spreadableSymbol]);
        }
        function isIndex(value, length) {
          var type = typeof value;
          length = length == null ? MAX_SAFE_INTEGER : length;
          return !!length && (type == "number" || type != "symbol" && reIsUint.test(value)) && (value > -1 && value % 1 == 0 && value < length);
        }
        function isIterateeCall(value, index, object) {
          if (!isObject(object)) {
            return false;
          }
          var type = typeof index;
          if (type == "number" ? isArrayLike(object) && isIndex(index, object.length) : type == "string" && index in object) {
            return eq(object[index], value);
          }
          return false;
        }
        function isKey(value, object) {
          if (isArray(value)) {
            return false;
          }
          var type = typeof value;
          if (type == "number" || type == "symbol" || type == "boolean" || value == null || isSymbol(value)) {
            return true;
          }
          return reIsPlainProp.test(value) || !reIsDeepProp.test(value) || object != null && value in Object2(object);
        }
        function isKeyable(value) {
          var type = typeof value;
          return type == "string" || type == "number" || type == "symbol" || type == "boolean" ? value !== "__proto__" : value === null;
        }
        function isLaziable(func) {
          var funcName = getFuncName(func), other = lodash[funcName];
          if (typeof other != "function" || !(funcName in LazyWrapper.prototype)) {
            return false;
          }
          if (func === other) {
            return true;
          }
          var data = getData(other);
          return !!data && func === data[0];
        }
        function isMasked(func) {
          return !!maskSrcKey && maskSrcKey in func;
        }
        var isMaskable = coreJsData ? isFunction : stubFalse;
        function isPrototype(value) {
          var Ctor = value && value.constructor, proto = typeof Ctor == "function" && Ctor.prototype || objectProto;
          return value === proto;
        }
        function isStrictComparable(value) {
          return value === value && !isObject(value);
        }
        function matchesStrictComparable(key, srcValue) {
          return function(object) {
            if (object == null) {
              return false;
            }
            return object[key] === srcValue && (srcValue !== undefined2 || key in Object2(object));
          };
        }
        function memoizeCapped(func) {
          var result2 = memoize(func, function(key) {
            if (cache.size === MAX_MEMOIZE_SIZE) {
              cache.clear();
            }
            return key;
          });
          var cache = result2.cache;
          return result2;
        }
        function mergeData(data, source) {
          var bitmask = data[1], srcBitmask = source[1], newBitmask = bitmask | srcBitmask, isCommon = newBitmask < (WRAP_BIND_FLAG | WRAP_BIND_KEY_FLAG | WRAP_ARY_FLAG);
          var isCombo = srcBitmask == WRAP_ARY_FLAG && bitmask == WRAP_CURRY_FLAG || srcBitmask == WRAP_ARY_FLAG && bitmask == WRAP_REARG_FLAG && data[7].length <= source[8] || srcBitmask == (WRAP_ARY_FLAG | WRAP_REARG_FLAG) && source[7].length <= source[8] && bitmask == WRAP_CURRY_FLAG;
          if (!(isCommon || isCombo)) {
            return data;
          }
          if (srcBitmask & WRAP_BIND_FLAG) {
            data[2] = source[2];
            newBitmask |= bitmask & WRAP_BIND_FLAG ? 0 : WRAP_CURRY_BOUND_FLAG;
          }
          var value = source[3];
          if (value) {
            var partials = data[3];
            data[3] = partials ? composeArgs(partials, value, source[4]) : value;
            data[4] = partials ? replaceHolders(data[3], PLACEHOLDER) : source[4];
          }
          value = source[5];
          if (value) {
            partials = data[5];
            data[5] = partials ? composeArgsRight(partials, value, source[6]) : value;
            data[6] = partials ? replaceHolders(data[5], PLACEHOLDER) : source[6];
          }
          value = source[7];
          if (value) {
            data[7] = value;
          }
          if (srcBitmask & WRAP_ARY_FLAG) {
            data[8] = data[8] == null ? source[8] : nativeMin(data[8], source[8]);
          }
          if (data[9] == null) {
            data[9] = source[9];
          }
          data[0] = source[0];
          data[1] = newBitmask;
          return data;
        }
        function nativeKeysIn(object) {
          var result2 = [];
          if (object != null) {
            for (var key in Object2(object)) {
              result2.push(key);
            }
          }
          return result2;
        }
        function objectToString(value) {
          return nativeObjectToString.call(value);
        }
        function overRest(func, start, transform2) {
          start = nativeMax(start === undefined2 ? func.length - 1 : start, 0);
          return function() {
            var args = arguments, index = -1, length = nativeMax(args.length - start, 0), array = Array2(length);
            while (++index < length) {
              array[index] = args[start + index];
            }
            index = -1;
            var otherArgs = Array2(start + 1);
            while (++index < start) {
              otherArgs[index] = args[index];
            }
            otherArgs[start] = transform2(array);
            return apply(func, this, otherArgs);
          };
        }
        function parent(object, path2) {
          return path2.length < 2 ? object : baseGet(object, baseSlice(path2, 0, -1));
        }
        function reorder(array, indexes) {
          var arrLength = array.length, length = nativeMin(indexes.length, arrLength), oldArray = copyArray(array);
          while (length--) {
            var index = indexes[length];
            array[length] = isIndex(index, arrLength) ? oldArray[index] : undefined2;
          }
          return array;
        }
        function safeGet(object, key) {
          if (key === "constructor" && typeof object[key] === "function") {
            return;
          }
          if (key == "__proto__") {
            return;
          }
          return object[key];
        }
        var setData = shortOut(baseSetData);
        var setTimeout2 = ctxSetTimeout || function(func, wait) {
          return root.setTimeout(func, wait);
        };
        var setToString = shortOut(baseSetToString);
        function setWrapToString(wrapper, reference, bitmask) {
          var source = reference + "";
          return setToString(wrapper, insertWrapDetails(source, updateWrapDetails(getWrapDetails(source), bitmask)));
        }
        function shortOut(func) {
          var count = 0, lastCalled = 0;
          return function() {
            var stamp = nativeNow(), remaining = HOT_SPAN - (stamp - lastCalled);
            lastCalled = stamp;
            if (remaining > 0) {
              if (++count >= HOT_COUNT) {
                return arguments[0];
              }
            } else {
              count = 0;
            }
            return func.apply(undefined2, arguments);
          };
        }
        function shuffleSelf(array, size2) {
          var index = -1, length = array.length, lastIndex = length - 1;
          size2 = size2 === undefined2 ? length : size2;
          while (++index < size2) {
            var rand = baseRandom(index, lastIndex), value = array[rand];
            array[rand] = array[index];
            array[index] = value;
          }
          array.length = size2;
          return array;
        }
        var stringToPath = memoizeCapped(function(string) {
          var result2 = [];
          if (string.charCodeAt(0) === 46) {
            result2.push("");
          }
          string.replace(rePropName, function(match, number, quote, subString) {
            result2.push(quote ? subString.replace(reEscapeChar, "$1") : number || match);
          });
          return result2;
        });
        function toKey(value) {
          if (typeof value == "string" || isSymbol(value)) {
            return value;
          }
          var result2 = value + "";
          return result2 == "0" && 1 / value == -INFINITY ? "-0" : result2;
        }
        function toSource(func) {
          if (func != null) {
            try {
              return funcToString.call(func);
            } catch (e) {
            }
            try {
              return func + "";
            } catch (e) {
            }
          }
          return "";
        }
        function updateWrapDetails(details, bitmask) {
          arrayEach(wrapFlags, function(pair) {
            var value = "_." + pair[0];
            if (bitmask & pair[1] && !arrayIncludes(details, value)) {
              details.push(value);
            }
          });
          return details.sort();
        }
        function wrapperClone(wrapper) {
          if (wrapper instanceof LazyWrapper) {
            return wrapper.clone();
          }
          var result2 = new LodashWrapper(wrapper.__wrapped__, wrapper.__chain__);
          result2.__actions__ = copyArray(wrapper.__actions__);
          result2.__index__ = wrapper.__index__;
          result2.__values__ = wrapper.__values__;
          return result2;
        }
        function chunk(array, size2, guard) {
          if (guard ? isIterateeCall(array, size2, guard) : size2 === undefined2) {
            size2 = 1;
          } else {
            size2 = nativeMax(toInteger(size2), 0);
          }
          var length = array == null ? 0 : array.length;
          if (!length || size2 < 1) {
            return [];
          }
          var index = 0, resIndex = 0, result2 = Array2(nativeCeil(length / size2));
          while (index < length) {
            result2[resIndex++] = baseSlice(array, index, index += size2);
          }
          return result2;
        }
        function compact(array) {
          var index = -1, length = array == null ? 0 : array.length, resIndex = 0, result2 = [];
          while (++index < length) {
            var value = array[index];
            if (value) {
              result2[resIndex++] = value;
            }
          }
          return result2;
        }
        function concat() {
          var length = arguments.length;
          if (!length) {
            return [];
          }
          var args = Array2(length - 1), array = arguments[0], index = length;
          while (index--) {
            args[index - 1] = arguments[index];
          }
          return arrayPush(isArray(array) ? copyArray(array) : [array], baseFlatten(args, 1));
        }
        var difference = baseRest(function(array, values2) {
          return isArrayLikeObject(array) ? baseDifference(array, baseFlatten(values2, 1, isArrayLikeObject, true)) : [];
        });
        var differenceBy = baseRest(function(array, values2) {
          var iteratee2 = last(values2);
          if (isArrayLikeObject(iteratee2)) {
            iteratee2 = undefined2;
          }
          return isArrayLikeObject(array) ? baseDifference(array, baseFlatten(values2, 1, isArrayLikeObject, true), getIteratee(iteratee2, 2)) : [];
        });
        var differenceWith = baseRest(function(array, values2) {
          var comparator = last(values2);
          if (isArrayLikeObject(comparator)) {
            comparator = undefined2;
          }
          return isArrayLikeObject(array) ? baseDifference(array, baseFlatten(values2, 1, isArrayLikeObject, true), undefined2, comparator) : [];
        });
        function drop(array, n, guard) {
          var length = array == null ? 0 : array.length;
          if (!length) {
            return [];
          }
          n = guard || n === undefined2 ? 1 : toInteger(n);
          return baseSlice(array, n < 0 ? 0 : n, length);
        }
        function dropRight(array, n, guard) {
          var length = array == null ? 0 : array.length;
          if (!length) {
            return [];
          }
          n = guard || n === undefined2 ? 1 : toInteger(n);
          n = length - n;
          return baseSlice(array, 0, n < 0 ? 0 : n);
        }
        function dropRightWhile(array, predicate) {
          return array && array.length ? baseWhile(array, getIteratee(predicate, 3), true, true) : [];
        }
        function dropWhile(array, predicate) {
          return array && array.length ? baseWhile(array, getIteratee(predicate, 3), true) : [];
        }
        function fill(array, value, start, end) {
          var length = array == null ? 0 : array.length;
          if (!length) {
            return [];
          }
          if (start && typeof start != "number" && isIterateeCall(array, value, start)) {
            start = 0;
            end = length;
          }
          return baseFill(array, value, start, end);
        }
        function findIndex(array, predicate, fromIndex) {
          var length = array == null ? 0 : array.length;
          if (!length) {
            return -1;
          }
          var index = fromIndex == null ? 0 : toInteger(fromIndex);
          if (index < 0) {
            index = nativeMax(length + index, 0);
          }
          return baseFindIndex(array, getIteratee(predicate, 3), index);
        }
        function findLastIndex(array, predicate, fromIndex) {
          var length = array == null ? 0 : array.length;
          if (!length) {
            return -1;
          }
          var index = length - 1;
          if (fromIndex !== undefined2) {
            index = toInteger(fromIndex);
            index = fromIndex < 0 ? nativeMax(length + index, 0) : nativeMin(index, length - 1);
          }
          return baseFindIndex(array, getIteratee(predicate, 3), index, true);
        }
        function flatten(array) {
          var length = array == null ? 0 : array.length;
          return length ? baseFlatten(array, 1) : [];
        }
        function flattenDeep(array) {
          var length = array == null ? 0 : array.length;
          return length ? baseFlatten(array, INFINITY) : [];
        }
        function flattenDepth(array, depth) {
          var length = array == null ? 0 : array.length;
          if (!length) {
            return [];
          }
          depth = depth === undefined2 ? 1 : toInteger(depth);
          return baseFlatten(array, depth);
        }
        function fromPairs(pairs) {
          var index = -1, length = pairs == null ? 0 : pairs.length, result2 = {};
          while (++index < length) {
            var pair = pairs[index];
            result2[pair[0]] = pair[1];
          }
          return result2;
        }
        function head(array) {
          return array && array.length ? array[0] : undefined2;
        }
        function indexOf(array, value, fromIndex) {
          var length = array == null ? 0 : array.length;
          if (!length) {
            return -1;
          }
          var index = fromIndex == null ? 0 : toInteger(fromIndex);
          if (index < 0) {
            index = nativeMax(length + index, 0);
          }
          return baseIndexOf(array, value, index);
        }
        function initial(array) {
          var length = array == null ? 0 : array.length;
          return length ? baseSlice(array, 0, -1) : [];
        }
        var intersection = baseRest(function(arrays) {
          var mapped = arrayMap(arrays, castArrayLikeObject);
          return mapped.length && mapped[0] === arrays[0] ? baseIntersection(mapped) : [];
        });
        var intersectionBy = baseRest(function(arrays) {
          var iteratee2 = last(arrays), mapped = arrayMap(arrays, castArrayLikeObject);
          if (iteratee2 === last(mapped)) {
            iteratee2 = undefined2;
          } else {
            mapped.pop();
          }
          return mapped.length && mapped[0] === arrays[0] ? baseIntersection(mapped, getIteratee(iteratee2, 2)) : [];
        });
        var intersectionWith = baseRest(function(arrays) {
          var comparator = last(arrays), mapped = arrayMap(arrays, castArrayLikeObject);
          comparator = typeof comparator == "function" ? comparator : undefined2;
          if (comparator) {
            mapped.pop();
          }
          return mapped.length && mapped[0] === arrays[0] ? baseIntersection(mapped, undefined2, comparator) : [];
        });
        function join(array, separator) {
          return array == null ? "" : nativeJoin.call(array, separator);
        }
        function last(array) {
          var length = array == null ? 0 : array.length;
          return length ? array[length - 1] : undefined2;
        }
        function lastIndexOf(array, value, fromIndex) {
          var length = array == null ? 0 : array.length;
          if (!length) {
            return -1;
          }
          var index = length;
          if (fromIndex !== undefined2) {
            index = toInteger(fromIndex);
            index = index < 0 ? nativeMax(length + index, 0) : nativeMin(index, length - 1);
          }
          return value === value ? strictLastIndexOf(array, value, index) : baseFindIndex(array, baseIsNaN, index, true);
        }
        function nth(array, n) {
          return array && array.length ? baseNth(array, toInteger(n)) : undefined2;
        }
        var pull = baseRest(pullAll);
        function pullAll(array, values2) {
          return array && array.length && values2 && values2.length ? basePullAll(array, values2) : array;
        }
        function pullAllBy(array, values2, iteratee2) {
          return array && array.length && values2 && values2.length ? basePullAll(array, values2, getIteratee(iteratee2, 2)) : array;
        }
        function pullAllWith(array, values2, comparator) {
          return array && array.length && values2 && values2.length ? basePullAll(array, values2, undefined2, comparator) : array;
        }
        var pullAt = flatRest(function(array, indexes) {
          var length = array == null ? 0 : array.length, result2 = baseAt(array, indexes);
          basePullAt(array, arrayMap(indexes, function(index) {
            return isIndex(index, length) ? +index : index;
          }).sort(compareAscending));
          return result2;
        });
        function remove(array, predicate) {
          var result2 = [];
          if (!(array && array.length)) {
            return result2;
          }
          var index = -1, indexes = [], length = array.length;
          predicate = getIteratee(predicate, 3);
          while (++index < length) {
            var value = array[index];
            if (predicate(value, index, array)) {
              result2.push(value);
              indexes.push(index);
            }
          }
          basePullAt(array, indexes);
          return result2;
        }
        function reverse(array) {
          return array == null ? array : nativeReverse.call(array);
        }
        function slice(array, start, end) {
          var length = array == null ? 0 : array.length;
          if (!length) {
            return [];
          }
          if (end && typeof end != "number" && isIterateeCall(array, start, end)) {
            start = 0;
            end = length;
          } else {
            start = start == null ? 0 : toInteger(start);
            end = end === undefined2 ? length : toInteger(end);
          }
          return baseSlice(array, start, end);
        }
        function sortedIndex(array, value) {
          return baseSortedIndex(array, value);
        }
        function sortedIndexBy(array, value, iteratee2) {
          return baseSortedIndexBy(array, value, getIteratee(iteratee2, 2));
        }
        function sortedIndexOf(array, value) {
          var length = array == null ? 0 : array.length;
          if (length) {
            var index = baseSortedIndex(array, value);
            if (index < length && eq(array[index], value)) {
              return index;
            }
          }
          return -1;
        }
        function sortedLastIndex(array, value) {
          return baseSortedIndex(array, value, true);
        }
        function sortedLastIndexBy(array, value, iteratee2) {
          return baseSortedIndexBy(array, value, getIteratee(iteratee2, 2), true);
        }
        function sortedLastIndexOf(array, value) {
          var length = array == null ? 0 : array.length;
          if (length) {
            var index = baseSortedIndex(array, value, true) - 1;
            if (eq(array[index], value)) {
              return index;
            }
          }
          return -1;
        }
        function sortedUniq(array) {
          return array && array.length ? baseSortedUniq(array) : [];
        }
        function sortedUniqBy(array, iteratee2) {
          return array && array.length ? baseSortedUniq(array, getIteratee(iteratee2, 2)) : [];
        }
        function tail(array) {
          var length = array == null ? 0 : array.length;
          return length ? baseSlice(array, 1, length) : [];
        }
        function take(array, n, guard) {
          if (!(array && array.length)) {
            return [];
          }
          n = guard || n === undefined2 ? 1 : toInteger(n);
          return baseSlice(array, 0, n < 0 ? 0 : n);
        }
        function takeRight(array, n, guard) {
          var length = array == null ? 0 : array.length;
          if (!length) {
            return [];
          }
          n = guard || n === undefined2 ? 1 : toInteger(n);
          n = length - n;
          return baseSlice(array, n < 0 ? 0 : n, length);
        }
        function takeRightWhile(array, predicate) {
          return array && array.length ? baseWhile(array, getIteratee(predicate, 3), false, true) : [];
        }
        function takeWhile(array, predicate) {
          return array && array.length ? baseWhile(array, getIteratee(predicate, 3)) : [];
        }
        var union = baseRest(function(arrays) {
          return baseUniq(baseFlatten(arrays, 1, isArrayLikeObject, true));
        });
        var unionBy = baseRest(function(arrays) {
          var iteratee2 = last(arrays);
          if (isArrayLikeObject(iteratee2)) {
            iteratee2 = undefined2;
          }
          return baseUniq(baseFlatten(arrays, 1, isArrayLikeObject, true), getIteratee(iteratee2, 2));
        });
        var unionWith = baseRest(function(arrays) {
          var comparator = last(arrays);
          comparator = typeof comparator == "function" ? comparator : undefined2;
          return baseUniq(baseFlatten(arrays, 1, isArrayLikeObject, true), undefined2, comparator);
        });
        function uniq(array) {
          return array && array.length ? baseUniq(array) : [];
        }
        function uniqBy(array, iteratee2) {
          return array && array.length ? baseUniq(array, getIteratee(iteratee2, 2)) : [];
        }
        function uniqWith(array, comparator) {
          comparator = typeof comparator == "function" ? comparator : undefined2;
          return array && array.length ? baseUniq(array, undefined2, comparator) : [];
        }
        function unzip(array) {
          if (!(array && array.length)) {
            return [];
          }
          var length = 0;
          array = arrayFilter(array, function(group) {
            if (isArrayLikeObject(group)) {
              length = nativeMax(group.length, length);
              return true;
            }
          });
          return baseTimes(length, function(index) {
            return arrayMap(array, baseProperty(index));
          });
        }
        function unzipWith(array, iteratee2) {
          if (!(array && array.length)) {
            return [];
          }
          var result2 = unzip(array);
          if (iteratee2 == null) {
            return result2;
          }
          return arrayMap(result2, function(group) {
            return apply(iteratee2, undefined2, group);
          });
        }
        var without = baseRest(function(array, values2) {
          return isArrayLikeObject(array) ? baseDifference(array, values2) : [];
        });
        var xor = baseRest(function(arrays) {
          return baseXor(arrayFilter(arrays, isArrayLikeObject));
        });
        var xorBy = baseRest(function(arrays) {
          var iteratee2 = last(arrays);
          if (isArrayLikeObject(iteratee2)) {
            iteratee2 = undefined2;
          }
          return baseXor(arrayFilter(arrays, isArrayLikeObject), getIteratee(iteratee2, 2));
        });
        var xorWith = baseRest(function(arrays) {
          var comparator = last(arrays);
          comparator = typeof comparator == "function" ? comparator : undefined2;
          return baseXor(arrayFilter(arrays, isArrayLikeObject), undefined2, comparator);
        });
        var zip = baseRest(unzip);
        function zipObject(props, values2) {
          return baseZipObject(props || [], values2 || [], assignValue);
        }
        function zipObjectDeep(props, values2) {
          return baseZipObject(props || [], values2 || [], baseSet);
        }
        var zipWith = baseRest(function(arrays) {
          var length = arrays.length, iteratee2 = length > 1 ? arrays[length - 1] : undefined2;
          iteratee2 = typeof iteratee2 == "function" ? (arrays.pop(), iteratee2) : undefined2;
          return unzipWith(arrays, iteratee2);
        });
        function chain(value) {
          var result2 = lodash(value);
          result2.__chain__ = true;
          return result2;
        }
        function tap(value, interceptor) {
          interceptor(value);
          return value;
        }
        function thru(value, interceptor) {
          return interceptor(value);
        }
        var wrapperAt = flatRest(function(paths) {
          var length = paths.length, start = length ? paths[0] : 0, value = this.__wrapped__, interceptor = function(object) {
            return baseAt(object, paths);
          };
          if (length > 1 || this.__actions__.length || !(value instanceof LazyWrapper) || !isIndex(start)) {
            return this.thru(interceptor);
          }
          value = value.slice(start, +start + (length ? 1 : 0));
          value.__actions__.push({
            "func": thru,
            "args": [interceptor],
            "thisArg": undefined2
          });
          return new LodashWrapper(value, this.__chain__).thru(function(array) {
            if (length && !array.length) {
              array.push(undefined2);
            }
            return array;
          });
        });
        function wrapperChain() {
          return chain(this);
        }
        function wrapperCommit() {
          return new LodashWrapper(this.value(), this.__chain__);
        }
        function wrapperNext() {
          if (this.__values__ === undefined2) {
            this.__values__ = toArray(this.value());
          }
          var done = this.__index__ >= this.__values__.length, value = done ? undefined2 : this.__values__[this.__index__++];
          return { "done": done, "value": value };
        }
        function wrapperToIterator() {
          return this;
        }
        function wrapperPlant(value) {
          var result2, parent2 = this;
          while (parent2 instanceof baseLodash) {
            var clone2 = wrapperClone(parent2);
            clone2.__index__ = 0;
            clone2.__values__ = undefined2;
            if (result2) {
              previous.__wrapped__ = clone2;
            } else {
              result2 = clone2;
            }
            var previous = clone2;
            parent2 = parent2.__wrapped__;
          }
          previous.__wrapped__ = value;
          return result2;
        }
        function wrapperReverse() {
          var value = this.__wrapped__;
          if (value instanceof LazyWrapper) {
            var wrapped = value;
            if (this.__actions__.length) {
              wrapped = new LazyWrapper(this);
            }
            wrapped = wrapped.reverse();
            wrapped.__actions__.push({
              "func": thru,
              "args": [reverse],
              "thisArg": undefined2
            });
            return new LodashWrapper(wrapped, this.__chain__);
          }
          return this.thru(reverse);
        }
        function wrapperValue() {
          return baseWrapperValue(this.__wrapped__, this.__actions__);
        }
        var countBy = createAggregator(function(result2, value, key) {
          if (hasOwnProperty.call(result2, key)) {
            ++result2[key];
          } else {
            baseAssignValue(result2, key, 1);
          }
        });
        function every(collection, predicate, guard) {
          var func = isArray(collection) ? arrayEvery : baseEvery;
          if (guard && isIterateeCall(collection, predicate, guard)) {
            predicate = undefined2;
          }
          return func(collection, getIteratee(predicate, 3));
        }
        function filter(collection, predicate) {
          var func = isArray(collection) ? arrayFilter : baseFilter;
          return func(collection, getIteratee(predicate, 3));
        }
        var find = createFind(findIndex);
        var findLast = createFind(findLastIndex);
        function flatMap(collection, iteratee2) {
          return baseFlatten(map(collection, iteratee2), 1);
        }
        function flatMapDeep(collection, iteratee2) {
          return baseFlatten(map(collection, iteratee2), INFINITY);
        }
        function flatMapDepth(collection, iteratee2, depth) {
          depth = depth === undefined2 ? 1 : toInteger(depth);
          return baseFlatten(map(collection, iteratee2), depth);
        }
        function forEach(collection, iteratee2) {
          var func = isArray(collection) ? arrayEach : baseEach;
          return func(collection, getIteratee(iteratee2, 3));
        }
        function forEachRight(collection, iteratee2) {
          var func = isArray(collection) ? arrayEachRight : baseEachRight;
          return func(collection, getIteratee(iteratee2, 3));
        }
        var groupBy = createAggregator(function(result2, value, key) {
          if (hasOwnProperty.call(result2, key)) {
            result2[key].push(value);
          } else {
            baseAssignValue(result2, key, [value]);
          }
        });
        function includes(collection, value, fromIndex, guard) {
          collection = isArrayLike(collection) ? collection : values(collection);
          fromIndex = fromIndex && !guard ? toInteger(fromIndex) : 0;
          var length = collection.length;
          if (fromIndex < 0) {
            fromIndex = nativeMax(length + fromIndex, 0);
          }
          return isString(collection) ? fromIndex <= length && collection.indexOf(value, fromIndex) > -1 : !!length && baseIndexOf(collection, value, fromIndex) > -1;
        }
        var invokeMap = baseRest(function(collection, path2, args) {
          var index = -1, isFunc = typeof path2 == "function", result2 = isArrayLike(collection) ? Array2(collection.length) : [];
          baseEach(collection, function(value) {
            result2[++index] = isFunc ? apply(path2, value, args) : baseInvoke(value, path2, args);
          });
          return result2;
        });
        var keyBy = createAggregator(function(result2, value, key) {
          baseAssignValue(result2, key, value);
        });
        function map(collection, iteratee2) {
          var func = isArray(collection) ? arrayMap : baseMap;
          return func(collection, getIteratee(iteratee2, 3));
        }
        function orderBy(collection, iteratees, orders, guard) {
          if (collection == null) {
            return [];
          }
          if (!isArray(iteratees)) {
            iteratees = iteratees == null ? [] : [iteratees];
          }
          orders = guard ? undefined2 : orders;
          if (!isArray(orders)) {
            orders = orders == null ? [] : [orders];
          }
          return baseOrderBy(collection, iteratees, orders);
        }
        var partition = createAggregator(function(result2, value, key) {
          result2[key ? 0 : 1].push(value);
        }, function() {
          return [[], []];
        });
        function reduce(collection, iteratee2, accumulator) {
          var func = isArray(collection) ? arrayReduce : baseReduce, initAccum = arguments.length < 3;
          return func(collection, getIteratee(iteratee2, 4), accumulator, initAccum, baseEach);
        }
        function reduceRight(collection, iteratee2, accumulator) {
          var func = isArray(collection) ? arrayReduceRight : baseReduce, initAccum = arguments.length < 3;
          return func(collection, getIteratee(iteratee2, 4), accumulator, initAccum, baseEachRight);
        }
        function reject(collection, predicate) {
          var func = isArray(collection) ? arrayFilter : baseFilter;
          return func(collection, negate(getIteratee(predicate, 3)));
        }
        function sample(collection) {
          var func = isArray(collection) ? arraySample : baseSample;
          return func(collection);
        }
        function sampleSize(collection, n, guard) {
          if (guard ? isIterateeCall(collection, n, guard) : n === undefined2) {
            n = 1;
          } else {
            n = toInteger(n);
          }
          var func = isArray(collection) ? arraySampleSize : baseSampleSize;
          return func(collection, n);
        }
        function shuffle(collection) {
          var func = isArray(collection) ? arrayShuffle : baseShuffle;
          return func(collection);
        }
        function size(collection) {
          if (collection == null) {
            return 0;
          }
          if (isArrayLike(collection)) {
            return isString(collection) ? stringSize(collection) : collection.length;
          }
          var tag = getTag(collection);
          if (tag == mapTag || tag == setTag) {
            return collection.size;
          }
          return baseKeys(collection).length;
        }
        function some(collection, predicate, guard) {
          var func = isArray(collection) ? arraySome : baseSome;
          if (guard && isIterateeCall(collection, predicate, guard)) {
            predicate = undefined2;
          }
          return func(collection, getIteratee(predicate, 3));
        }
        var sortBy = baseRest(function(collection, iteratees) {
          if (collection == null) {
            return [];
          }
          var length = iteratees.length;
          if (length > 1 && isIterateeCall(collection, iteratees[0], iteratees[1])) {
            iteratees = [];
          } else if (length > 2 && isIterateeCall(iteratees[0], iteratees[1], iteratees[2])) {
            iteratees = [iteratees[0]];
          }
          return baseOrderBy(collection, baseFlatten(iteratees, 1), []);
        });
        var now = ctxNow || function() {
          return root.Date.now();
        };
        function after(n, func) {
          if (typeof func != "function") {
            throw new TypeError2(FUNC_ERROR_TEXT);
          }
          n = toInteger(n);
          return function() {
            if (--n < 1) {
              return func.apply(this, arguments);
            }
          };
        }
        function ary(func, n, guard) {
          n = guard ? undefined2 : n;
          n = func && n == null ? func.length : n;
          return createWrap(func, WRAP_ARY_FLAG, undefined2, undefined2, undefined2, undefined2, n);
        }
        function before(n, func) {
          var result2;
          if (typeof func != "function") {
            throw new TypeError2(FUNC_ERROR_TEXT);
          }
          n = toInteger(n);
          return function() {
            if (--n > 0) {
              result2 = func.apply(this, arguments);
            }
            if (n <= 1) {
              func = undefined2;
            }
            return result2;
          };
        }
        var bind = baseRest(function(func, thisArg, partials) {
          var bitmask = WRAP_BIND_FLAG;
          if (partials.length) {
            var holders = replaceHolders(partials, getHolder(bind));
            bitmask |= WRAP_PARTIAL_FLAG;
          }
          return createWrap(func, bitmask, thisArg, partials, holders);
        });
        var bindKey = baseRest(function(object, key, partials) {
          var bitmask = WRAP_BIND_FLAG | WRAP_BIND_KEY_FLAG;
          if (partials.length) {
            var holders = replaceHolders(partials, getHolder(bindKey));
            bitmask |= WRAP_PARTIAL_FLAG;
          }
          return createWrap(key, bitmask, object, partials, holders);
        });
        function curry(func, arity, guard) {
          arity = guard ? undefined2 : arity;
          var result2 = createWrap(func, WRAP_CURRY_FLAG, undefined2, undefined2, undefined2, undefined2, undefined2, arity);
          result2.placeholder = curry.placeholder;
          return result2;
        }
        function curryRight(func, arity, guard) {
          arity = guard ? undefined2 : arity;
          var result2 = createWrap(func, WRAP_CURRY_RIGHT_FLAG, undefined2, undefined2, undefined2, undefined2, undefined2, arity);
          result2.placeholder = curryRight.placeholder;
          return result2;
        }
        function debounce(func, wait, options) {
          var lastArgs, lastThis, maxWait, result2, timerId, lastCallTime, lastInvokeTime = 0, leading = false, maxing = false, trailing = true;
          if (typeof func != "function") {
            throw new TypeError2(FUNC_ERROR_TEXT);
          }
          wait = toNumber(wait) || 0;
          if (isObject(options)) {
            leading = !!options.leading;
            maxing = "maxWait" in options;
            maxWait = maxing ? nativeMax(toNumber(options.maxWait) || 0, wait) : maxWait;
            trailing = "trailing" in options ? !!options.trailing : trailing;
          }
          function invokeFunc(time) {
            var args = lastArgs, thisArg = lastThis;
            lastArgs = lastThis = undefined2;
            lastInvokeTime = time;
            result2 = func.apply(thisArg, args);
            return result2;
          }
          function leadingEdge(time) {
            lastInvokeTime = time;
            timerId = setTimeout2(timerExpired, wait);
            return leading ? invokeFunc(time) : result2;
          }
          function remainingWait(time) {
            var timeSinceLastCall = time - lastCallTime, timeSinceLastInvoke = time - lastInvokeTime, timeWaiting = wait - timeSinceLastCall;
            return maxing ? nativeMin(timeWaiting, maxWait - timeSinceLastInvoke) : timeWaiting;
          }
          function shouldInvoke(time) {
            var timeSinceLastCall = time - lastCallTime, timeSinceLastInvoke = time - lastInvokeTime;
            return lastCallTime === undefined2 || timeSinceLastCall >= wait || timeSinceLastCall < 0 || maxing && timeSinceLastInvoke >= maxWait;
          }
          function timerExpired() {
            var time = now();
            if (shouldInvoke(time)) {
              return trailingEdge(time);
            }
            timerId = setTimeout2(timerExpired, remainingWait(time));
          }
          function trailingEdge(time) {
            timerId = undefined2;
            if (trailing && lastArgs) {
              return invokeFunc(time);
            }
            lastArgs = lastThis = undefined2;
            return result2;
          }
          function cancel() {
            if (timerId !== undefined2) {
              clearTimeout2(timerId);
            }
            lastInvokeTime = 0;
            lastArgs = lastCallTime = lastThis = timerId = undefined2;
          }
          function flush() {
            return timerId === undefined2 ? result2 : trailingEdge(now());
          }
          function debounced() {
            var time = now(), isInvoking = shouldInvoke(time);
            lastArgs = arguments;
            lastThis = this;
            lastCallTime = time;
            if (isInvoking) {
              if (timerId === undefined2) {
                return leadingEdge(lastCallTime);
              }
              if (maxing) {
                clearTimeout2(timerId);
                timerId = setTimeout2(timerExpired, wait);
                return invokeFunc(lastCallTime);
              }
            }
            if (timerId === undefined2) {
              timerId = setTimeout2(timerExpired, wait);
            }
            return result2;
          }
          debounced.cancel = cancel;
          debounced.flush = flush;
          return debounced;
        }
        var defer = baseRest(function(func, args) {
          return baseDelay(func, 1, args);
        });
        var delay = baseRest(function(func, wait, args) {
          return baseDelay(func, toNumber(wait) || 0, args);
        });
        function flip(func) {
          return createWrap(func, WRAP_FLIP_FLAG);
        }
        function memoize(func, resolver) {
          if (typeof func != "function" || resolver != null && typeof resolver != "function") {
            throw new TypeError2(FUNC_ERROR_TEXT);
          }
          var memoized = function() {
            var args = arguments, key = resolver ? resolver.apply(this, args) : args[0], cache = memoized.cache;
            if (cache.has(key)) {
              return cache.get(key);
            }
            var result2 = func.apply(this, args);
            memoized.cache = cache.set(key, result2) || cache;
            return result2;
          };
          memoized.cache = new (memoize.Cache || MapCache)();
          return memoized;
        }
        memoize.Cache = MapCache;
        function negate(predicate) {
          if (typeof predicate != "function") {
            throw new TypeError2(FUNC_ERROR_TEXT);
          }
          return function() {
            var args = arguments;
            switch (args.length) {
              case 0:
                return !predicate.call(this);
              case 1:
                return !predicate.call(this, args[0]);
              case 2:
                return !predicate.call(this, args[0], args[1]);
              case 3:
                return !predicate.call(this, args[0], args[1], args[2]);
            }
            return !predicate.apply(this, args);
          };
        }
        function once(func) {
          return before(2, func);
        }
        var overArgs = castRest(function(func, transforms) {
          transforms = transforms.length == 1 && isArray(transforms[0]) ? arrayMap(transforms[0], baseUnary(getIteratee())) : arrayMap(baseFlatten(transforms, 1), baseUnary(getIteratee()));
          var funcsLength = transforms.length;
          return baseRest(function(args) {
            var index = -1, length = nativeMin(args.length, funcsLength);
            while (++index < length) {
              args[index] = transforms[index].call(this, args[index]);
            }
            return apply(func, this, args);
          });
        });
        var partial = baseRest(function(func, partials) {
          var holders = replaceHolders(partials, getHolder(partial));
          return createWrap(func, WRAP_PARTIAL_FLAG, undefined2, partials, holders);
        });
        var partialRight = baseRest(function(func, partials) {
          var holders = replaceHolders(partials, getHolder(partialRight));
          return createWrap(func, WRAP_PARTIAL_RIGHT_FLAG, undefined2, partials, holders);
        });
        var rearg = flatRest(function(func, indexes) {
          return createWrap(func, WRAP_REARG_FLAG, undefined2, undefined2, undefined2, indexes);
        });
        function rest(func, start) {
          if (typeof func != "function") {
            throw new TypeError2(FUNC_ERROR_TEXT);
          }
          start = start === undefined2 ? start : toInteger(start);
          return baseRest(func, start);
        }
        function spread(func, start) {
          if (typeof func != "function") {
            throw new TypeError2(FUNC_ERROR_TEXT);
          }
          start = start == null ? 0 : nativeMax(toInteger(start), 0);
          return baseRest(function(args) {
            var array = args[start], otherArgs = castSlice(args, 0, start);
            if (array) {
              arrayPush(otherArgs, array);
            }
            return apply(func, this, otherArgs);
          });
        }
        function throttle(func, wait, options) {
          var leading = true, trailing = true;
          if (typeof func != "function") {
            throw new TypeError2(FUNC_ERROR_TEXT);
          }
          if (isObject(options)) {
            leading = "leading" in options ? !!options.leading : leading;
            trailing = "trailing" in options ? !!options.trailing : trailing;
          }
          return debounce(func, wait, {
            "leading": leading,
            "maxWait": wait,
            "trailing": trailing
          });
        }
        function unary(func) {
          return ary(func, 1);
        }
        function wrap(value, wrapper) {
          return partial(castFunction(wrapper), value);
        }
        function castArray() {
          if (!arguments.length) {
            return [];
          }
          var value = arguments[0];
          return isArray(value) ? value : [value];
        }
        function clone(value) {
          return baseClone(value, CLONE_SYMBOLS_FLAG);
        }
        function cloneWith(value, customizer) {
          customizer = typeof customizer == "function" ? customizer : undefined2;
          return baseClone(value, CLONE_SYMBOLS_FLAG, customizer);
        }
        function cloneDeep(value) {
          return baseClone(value, CLONE_DEEP_FLAG | CLONE_SYMBOLS_FLAG);
        }
        function cloneDeepWith(value, customizer) {
          customizer = typeof customizer == "function" ? customizer : undefined2;
          return baseClone(value, CLONE_DEEP_FLAG | CLONE_SYMBOLS_FLAG, customizer);
        }
        function conformsTo(object, source) {
          return source == null || baseConformsTo(object, source, keys(source));
        }
        function eq(value, other) {
          return value === other || value !== value && other !== other;
        }
        var gt = createRelationalOperation(baseGt);
        var gte = createRelationalOperation(function(value, other) {
          return value >= other;
        });
        var isArguments = baseIsArguments(/* @__PURE__ */ (function() {
          return arguments;
        })()) ? baseIsArguments : function(value) {
          return isObjectLike(value) && hasOwnProperty.call(value, "callee") && !propertyIsEnumerable.call(value, "callee");
        };
        var isArray = Array2.isArray;
        var isArrayBuffer = nodeIsArrayBuffer ? baseUnary(nodeIsArrayBuffer) : baseIsArrayBuffer;
        function isArrayLike(value) {
          return value != null && isLength(value.length) && !isFunction(value);
        }
        function isArrayLikeObject(value) {
          return isObjectLike(value) && isArrayLike(value);
        }
        function isBoolean(value) {
          return value === true || value === false || isObjectLike(value) && baseGetTag(value) == boolTag;
        }
        var isBuffer = nativeIsBuffer || stubFalse;
        var isDate = nodeIsDate ? baseUnary(nodeIsDate) : baseIsDate;
        function isElement(value) {
          return isObjectLike(value) && value.nodeType === 1 && !isPlainObject(value);
        }
        function isEmpty(value) {
          if (value == null) {
            return true;
          }
          if (isArrayLike(value) && (isArray(value) || typeof value == "string" || typeof value.splice == "function" || isBuffer(value) || isTypedArray(value) || isArguments(value))) {
            return !value.length;
          }
          var tag = getTag(value);
          if (tag == mapTag || tag == setTag) {
            return !value.size;
          }
          if (isPrototype(value)) {
            return !baseKeys(value).length;
          }
          for (var key in value) {
            if (hasOwnProperty.call(value, key)) {
              return false;
            }
          }
          return true;
        }
        function isEqual(value, other) {
          return baseIsEqual(value, other);
        }
        function isEqualWith(value, other, customizer) {
          customizer = typeof customizer == "function" ? customizer : undefined2;
          var result2 = customizer ? customizer(value, other) : undefined2;
          return result2 === undefined2 ? baseIsEqual(value, other, undefined2, customizer) : !!result2;
        }
        function isError(value) {
          if (!isObjectLike(value)) {
            return false;
          }
          var tag = baseGetTag(value);
          return tag == errorTag || tag == domExcTag || typeof value.message == "string" && typeof value.name == "string" && !isPlainObject(value);
        }
        function isFinite2(value) {
          return typeof value == "number" && nativeIsFinite(value);
        }
        function isFunction(value) {
          if (!isObject(value)) {
            return false;
          }
          var tag = baseGetTag(value);
          return tag == funcTag || tag == genTag || tag == asyncTag || tag == proxyTag;
        }
        function isInteger(value) {
          return typeof value == "number" && value == toInteger(value);
        }
        function isLength(value) {
          return typeof value == "number" && value > -1 && value % 1 == 0 && value <= MAX_SAFE_INTEGER;
        }
        function isObject(value) {
          var type = typeof value;
          return value != null && (type == "object" || type == "function");
        }
        function isObjectLike(value) {
          return value != null && typeof value == "object";
        }
        var isMap = nodeIsMap ? baseUnary(nodeIsMap) : baseIsMap;
        function isMatch(object, source) {
          return object === source || baseIsMatch(object, source, getMatchData(source));
        }
        function isMatchWith(object, source, customizer) {
          customizer = typeof customizer == "function" ? customizer : undefined2;
          return baseIsMatch(object, source, getMatchData(source), customizer);
        }
        function isNaN2(value) {
          return isNumber(value) && value != +value;
        }
        function isNative(value) {
          if (isMaskable(value)) {
            throw new Error2(CORE_ERROR_TEXT);
          }
          return baseIsNative(value);
        }
        function isNull(value) {
          return value === null;
        }
        function isNil(value) {
          return value == null;
        }
        function isNumber(value) {
          return typeof value == "number" || isObjectLike(value) && baseGetTag(value) == numberTag;
        }
        function isPlainObject(value) {
          if (!isObjectLike(value) || baseGetTag(value) != objectTag) {
            return false;
          }
          var proto = getPrototype(value);
          if (proto === null) {
            return true;
          }
          var Ctor = hasOwnProperty.call(proto, "constructor") && proto.constructor;
          return typeof Ctor == "function" && Ctor instanceof Ctor && funcToString.call(Ctor) == objectCtorString;
        }
        var isRegExp = nodeIsRegExp ? baseUnary(nodeIsRegExp) : baseIsRegExp;
        function isSafeInteger(value) {
          return isInteger(value) && value >= -MAX_SAFE_INTEGER && value <= MAX_SAFE_INTEGER;
        }
        var isSet = nodeIsSet ? baseUnary(nodeIsSet) : baseIsSet;
        function isString(value) {
          return typeof value == "string" || !isArray(value) && isObjectLike(value) && baseGetTag(value) == stringTag;
        }
        function isSymbol(value) {
          return typeof value == "symbol" || isObjectLike(value) && baseGetTag(value) == symbolTag;
        }
        var isTypedArray = nodeIsTypedArray ? baseUnary(nodeIsTypedArray) : baseIsTypedArray;
        function isUndefined(value) {
          return value === undefined2;
        }
        function isWeakMap(value) {
          return isObjectLike(value) && getTag(value) == weakMapTag;
        }
        function isWeakSet(value) {
          return isObjectLike(value) && baseGetTag(value) == weakSetTag;
        }
        var lt = createRelationalOperation(baseLt);
        var lte = createRelationalOperation(function(value, other) {
          return value <= other;
        });
        function toArray(value) {
          if (!value) {
            return [];
          }
          if (isArrayLike(value)) {
            return isString(value) ? stringToArray(value) : copyArray(value);
          }
          if (symIterator && value[symIterator]) {
            return iteratorToArray(value[symIterator]());
          }
          var tag = getTag(value), func = tag == mapTag ? mapToArray : tag == setTag ? setToArray : values;
          return func(value);
        }
        function toFinite(value) {
          if (!value) {
            return value === 0 ? value : 0;
          }
          value = toNumber(value);
          if (value === INFINITY || value === -INFINITY) {
            var sign = value < 0 ? -1 : 1;
            return sign * MAX_INTEGER;
          }
          return value === value ? value : 0;
        }
        function toInteger(value) {
          var result2 = toFinite(value), remainder = result2 % 1;
          return result2 === result2 ? remainder ? result2 - remainder : result2 : 0;
        }
        function toLength(value) {
          return value ? baseClamp(toInteger(value), 0, MAX_ARRAY_LENGTH) : 0;
        }
        function toNumber(value) {
          if (typeof value == "number") {
            return value;
          }
          if (isSymbol(value)) {
            return NAN;
          }
          if (isObject(value)) {
            var other = typeof value.valueOf == "function" ? value.valueOf() : value;
            value = isObject(other) ? other + "" : other;
          }
          if (typeof value != "string") {
            return value === 0 ? value : +value;
          }
          value = baseTrim(value);
          var isBinary = reIsBinary.test(value);
          return isBinary || reIsOctal.test(value) ? freeParseInt(value.slice(2), isBinary ? 2 : 8) : reIsBadHex.test(value) ? NAN : +value;
        }
        function toPlainObject(value) {
          return copyObject(value, keysIn(value));
        }
        function toSafeInteger(value) {
          return value ? baseClamp(toInteger(value), -MAX_SAFE_INTEGER, MAX_SAFE_INTEGER) : value === 0 ? value : 0;
        }
        function toString(value) {
          return value == null ? "" : baseToString(value);
        }
        var assign = createAssigner(function(object, source) {
          if (isPrototype(source) || isArrayLike(source)) {
            copyObject(source, keys(source), object);
            return;
          }
          for (var key in source) {
            if (hasOwnProperty.call(source, key)) {
              assignValue(object, key, source[key]);
            }
          }
        });
        var assignIn = createAssigner(function(object, source) {
          copyObject(source, keysIn(source), object);
        });
        var assignInWith = createAssigner(function(object, source, srcIndex, customizer) {
          copyObject(source, keysIn(source), object, customizer);
        });
        var assignWith = createAssigner(function(object, source, srcIndex, customizer) {
          copyObject(source, keys(source), object, customizer);
        });
        var at = flatRest(baseAt);
        function create(prototype, properties) {
          var result2 = baseCreate(prototype);
          return properties == null ? result2 : baseAssign(result2, properties);
        }
        var defaults = baseRest(function(object, sources) {
          object = Object2(object);
          var index = -1;
          var length = sources.length;
          var guard = length > 2 ? sources[2] : undefined2;
          if (guard && isIterateeCall(sources[0], sources[1], guard)) {
            length = 1;
          }
          while (++index < length) {
            var source = sources[index];
            var props = keysIn(source);
            var propsIndex = -1;
            var propsLength = props.length;
            while (++propsIndex < propsLength) {
              var key = props[propsIndex];
              var value = object[key];
              if (value === undefined2 || eq(value, objectProto[key]) && !hasOwnProperty.call(object, key)) {
                object[key] = source[key];
              }
            }
          }
          return object;
        });
        var defaultsDeep = baseRest(function(args) {
          args.push(undefined2, customDefaultsMerge);
          return apply(mergeWith, undefined2, args);
        });
        function findKey(object, predicate) {
          return baseFindKey(object, getIteratee(predicate, 3), baseForOwn);
        }
        function findLastKey(object, predicate) {
          return baseFindKey(object, getIteratee(predicate, 3), baseForOwnRight);
        }
        function forIn(object, iteratee2) {
          return object == null ? object : baseFor(object, getIteratee(iteratee2, 3), keysIn);
        }
        function forInRight(object, iteratee2) {
          return object == null ? object : baseForRight(object, getIteratee(iteratee2, 3), keysIn);
        }
        function forOwn(object, iteratee2) {
          return object && baseForOwn(object, getIteratee(iteratee2, 3));
        }
        function forOwnRight(object, iteratee2) {
          return object && baseForOwnRight(object, getIteratee(iteratee2, 3));
        }
        function functions(object) {
          return object == null ? [] : baseFunctions(object, keys(object));
        }
        function functionsIn(object) {
          return object == null ? [] : baseFunctions(object, keysIn(object));
        }
        function get(object, path2, defaultValue) {
          var result2 = object == null ? undefined2 : baseGet(object, path2);
          return result2 === undefined2 ? defaultValue : result2;
        }
        function has(object, path2) {
          return object != null && hasPath(object, path2, baseHas);
        }
        function hasIn(object, path2) {
          return object != null && hasPath(object, path2, baseHasIn);
        }
        var invert = createInverter(function(result2, value, key) {
          if (value != null && typeof value.toString != "function") {
            value = nativeObjectToString.call(value);
          }
          result2[value] = key;
        }, constant(identity));
        var invertBy = createInverter(function(result2, value, key) {
          if (value != null && typeof value.toString != "function") {
            value = nativeObjectToString.call(value);
          }
          if (hasOwnProperty.call(result2, value)) {
            result2[value].push(key);
          } else {
            result2[value] = [key];
          }
        }, getIteratee);
        var invoke = baseRest(baseInvoke);
        function keys(object) {
          return isArrayLike(object) ? arrayLikeKeys(object) : baseKeys(object);
        }
        function keysIn(object) {
          return isArrayLike(object) ? arrayLikeKeys(object, true) : baseKeysIn(object);
        }
        function mapKeys(object, iteratee2) {
          var result2 = {};
          iteratee2 = getIteratee(iteratee2, 3);
          baseForOwn(object, function(value, key, object2) {
            baseAssignValue(result2, iteratee2(value, key, object2), value);
          });
          return result2;
        }
        function mapValues(object, iteratee2) {
          var result2 = {};
          iteratee2 = getIteratee(iteratee2, 3);
          baseForOwn(object, function(value, key, object2) {
            baseAssignValue(result2, key, iteratee2(value, key, object2));
          });
          return result2;
        }
        var merge = createAssigner(function(object, source, srcIndex) {
          baseMerge(object, source, srcIndex);
        });
        var mergeWith = createAssigner(function(object, source, srcIndex, customizer) {
          baseMerge(object, source, srcIndex, customizer);
        });
        var omit = flatRest(function(object, paths) {
          var result2 = {};
          if (object == null) {
            return result2;
          }
          var isDeep = false;
          paths = arrayMap(paths, function(path2) {
            path2 = castPath(path2, object);
            isDeep || (isDeep = path2.length > 1);
            return path2;
          });
          copyObject(object, getAllKeysIn(object), result2);
          if (isDeep) {
            result2 = baseClone(result2, CLONE_DEEP_FLAG | CLONE_FLAT_FLAG | CLONE_SYMBOLS_FLAG, customOmitClone);
          }
          var length = paths.length;
          while (length--) {
            baseUnset(result2, paths[length]);
          }
          return result2;
        });
        function omitBy(object, predicate) {
          return pickBy(object, negate(getIteratee(predicate)));
        }
        var pick = flatRest(function(object, paths) {
          return object == null ? {} : basePick(object, paths);
        });
        function pickBy(object, predicate) {
          if (object == null) {
            return {};
          }
          var props = arrayMap(getAllKeysIn(object), function(prop) {
            return [prop];
          });
          predicate = getIteratee(predicate);
          return basePickBy(object, props, function(value, path2) {
            return predicate(value, path2[0]);
          });
        }
        function result(object, path2, defaultValue) {
          path2 = castPath(path2, object);
          var index = -1, length = path2.length;
          if (!length) {
            length = 1;
            object = undefined2;
          }
          while (++index < length) {
            var value = object == null ? undefined2 : object[toKey(path2[index])];
            if (value === undefined2) {
              index = length;
              value = defaultValue;
            }
            object = isFunction(value) ? value.call(object) : value;
          }
          return object;
        }
        function set(object, path2, value) {
          return object == null ? object : baseSet(object, path2, value);
        }
        function setWith(object, path2, value, customizer) {
          customizer = typeof customizer == "function" ? customizer : undefined2;
          return object == null ? object : baseSet(object, path2, value, customizer);
        }
        var toPairs = createToPairs(keys);
        var toPairsIn = createToPairs(keysIn);
        function transform(object, iteratee2, accumulator) {
          var isArr = isArray(object), isArrLike = isArr || isBuffer(object) || isTypedArray(object);
          iteratee2 = getIteratee(iteratee2, 4);
          if (accumulator == null) {
            var Ctor = object && object.constructor;
            if (isArrLike) {
              accumulator = isArr ? new Ctor() : [];
            } else if (isObject(object)) {
              accumulator = isFunction(Ctor) ? baseCreate(getPrototype(object)) : {};
            } else {
              accumulator = {};
            }
          }
          (isArrLike ? arrayEach : baseForOwn)(object, function(value, index, object2) {
            return iteratee2(accumulator, value, index, object2);
          });
          return accumulator;
        }
        function unset(object, path2) {
          return object == null ? true : baseUnset(object, path2);
        }
        function update(object, path2, updater) {
          return object == null ? object : baseUpdate(object, path2, castFunction(updater));
        }
        function updateWith(object, path2, updater, customizer) {
          customizer = typeof customizer == "function" ? customizer : undefined2;
          return object == null ? object : baseUpdate(object, path2, castFunction(updater), customizer);
        }
        function values(object) {
          return object == null ? [] : baseValues(object, keys(object));
        }
        function valuesIn(object) {
          return object == null ? [] : baseValues(object, keysIn(object));
        }
        function clamp(number, lower, upper) {
          if (upper === undefined2) {
            upper = lower;
            lower = undefined2;
          }
          if (upper !== undefined2) {
            upper = toNumber(upper);
            upper = upper === upper ? upper : 0;
          }
          if (lower !== undefined2) {
            lower = toNumber(lower);
            lower = lower === lower ? lower : 0;
          }
          return baseClamp(toNumber(number), lower, upper);
        }
        function inRange(number, start, end) {
          start = toFinite(start);
          if (end === undefined2) {
            end = start;
            start = 0;
          } else {
            end = toFinite(end);
          }
          number = toNumber(number);
          return baseInRange(number, start, end);
        }
        function random(lower, upper, floating) {
          if (floating && typeof floating != "boolean" && isIterateeCall(lower, upper, floating)) {
            upper = floating = undefined2;
          }
          if (floating === undefined2) {
            if (typeof upper == "boolean") {
              floating = upper;
              upper = undefined2;
            } else if (typeof lower == "boolean") {
              floating = lower;
              lower = undefined2;
            }
          }
          if (lower === undefined2 && upper === undefined2) {
            lower = 0;
            upper = 1;
          } else {
            lower = toFinite(lower);
            if (upper === undefined2) {
              upper = lower;
              lower = 0;
            } else {
              upper = toFinite(upper);
            }
          }
          if (lower > upper) {
            var temp = lower;
            lower = upper;
            upper = temp;
          }
          if (floating || lower % 1 || upper % 1) {
            var rand = nativeRandom();
            return nativeMin(lower + rand * (upper - lower + freeParseFloat("1e-" + ((rand + "").length - 1))), upper);
          }
          return baseRandom(lower, upper);
        }
        var camelCase = createCompounder(function(result2, word, index) {
          word = word.toLowerCase();
          return result2 + (index ? capitalize(word) : word);
        });
        function capitalize(string) {
          return upperFirst(toString(string).toLowerCase());
        }
        function deburr(string) {
          string = toString(string);
          return string && string.replace(reLatin, deburrLetter).replace(reComboMark, "");
        }
        function endsWith(string, target, position) {
          string = toString(string);
          target = baseToString(target);
          var length = string.length;
          position = position === undefined2 ? length : baseClamp(toInteger(position), 0, length);
          var end = position;
          position -= target.length;
          return position >= 0 && string.slice(position, end) == target;
        }
        function escape(string) {
          string = toString(string);
          return string && reHasUnescapedHtml.test(string) ? string.replace(reUnescapedHtml, escapeHtmlChar) : string;
        }
        function escapeRegExp(string) {
          string = toString(string);
          return string && reHasRegExpChar.test(string) ? string.replace(reRegExpChar, "\\$&") : string;
        }
        var kebabCase = createCompounder(function(result2, word, index) {
          return result2 + (index ? "-" : "") + word.toLowerCase();
        });
        var lowerCase = createCompounder(function(result2, word, index) {
          return result2 + (index ? " " : "") + word.toLowerCase();
        });
        var lowerFirst = createCaseFirst("toLowerCase");
        function pad(string, length, chars) {
          string = toString(string);
          length = toInteger(length);
          var strLength = length ? stringSize(string) : 0;
          if (!length || strLength >= length) {
            return string;
          }
          var mid = (length - strLength) / 2;
          return createPadding(nativeFloor(mid), chars) + string + createPadding(nativeCeil(mid), chars);
        }
        function padEnd(string, length, chars) {
          string = toString(string);
          length = toInteger(length);
          var strLength = length ? stringSize(string) : 0;
          return length && strLength < length ? string + createPadding(length - strLength, chars) : string;
        }
        function padStart(string, length, chars) {
          string = toString(string);
          length = toInteger(length);
          var strLength = length ? stringSize(string) : 0;
          return length && strLength < length ? createPadding(length - strLength, chars) + string : string;
        }
        function parseInt2(string, radix, guard) {
          if (guard || radix == null) {
            radix = 0;
          } else if (radix) {
            radix = +radix;
          }
          return nativeParseInt(toString(string).replace(reTrimStart, ""), radix || 0);
        }
        function repeat(string, n, guard) {
          if (guard ? isIterateeCall(string, n, guard) : n === undefined2) {
            n = 1;
          } else {
            n = toInteger(n);
          }
          return baseRepeat(toString(string), n);
        }
        function replace() {
          var args = arguments, string = toString(args[0]);
          return args.length < 3 ? string : string.replace(args[1], args[2]);
        }
        var snakeCase = createCompounder(function(result2, word, index) {
          return result2 + (index ? "_" : "") + word.toLowerCase();
        });
        function split(string, separator, limit) {
          if (limit && typeof limit != "number" && isIterateeCall(string, separator, limit)) {
            separator = limit = undefined2;
          }
          limit = limit === undefined2 ? MAX_ARRAY_LENGTH : limit >>> 0;
          if (!limit) {
            return [];
          }
          string = toString(string);
          if (string && (typeof separator == "string" || separator != null && !isRegExp(separator))) {
            separator = baseToString(separator);
            if (!separator && hasUnicode(string)) {
              return castSlice(stringToArray(string), 0, limit);
            }
          }
          return string.split(separator, limit);
        }
        var startCase = createCompounder(function(result2, word, index) {
          return result2 + (index ? " " : "") + upperFirst(word);
        });
        function startsWith(string, target, position) {
          string = toString(string);
          position = position == null ? 0 : baseClamp(toInteger(position), 0, string.length);
          target = baseToString(target);
          return string.slice(position, position + target.length) == target;
        }
        function template(string, options, guard) {
          var settings = lodash.templateSettings;
          if (guard && isIterateeCall(string, options, guard)) {
            options = undefined2;
          }
          string = toString(string);
          options = assignInWith({}, options, settings, customDefaultsAssignIn);
          var imports = assignInWith({}, options.imports, settings.imports, customDefaultsAssignIn), importsKeys = keys(imports), importsValues = baseValues(imports, importsKeys);
          var isEscaping, isEvaluating, index = 0, interpolate = options.interpolate || reNoMatch, source = "__p += '";
          var reDelimiters = RegExp2(
            (options.escape || reNoMatch).source + "|" + interpolate.source + "|" + (interpolate === reInterpolate ? reEsTemplate : reNoMatch).source + "|" + (options.evaluate || reNoMatch).source + "|$",
            "g"
          );
          var sourceURL = "//# sourceURL=" + (hasOwnProperty.call(options, "sourceURL") ? (options.sourceURL + "").replace(/\s/g, " ") : "lodash.templateSources[" + ++templateCounter + "]") + "\n";
          string.replace(reDelimiters, function(match, escapeValue, interpolateValue, esTemplateValue, evaluateValue, offset) {
            interpolateValue || (interpolateValue = esTemplateValue);
            source += string.slice(index, offset).replace(reUnescapedString, escapeStringChar);
            if (escapeValue) {
              isEscaping = true;
              source += "' +\n__e(" + escapeValue + ") +\n'";
            }
            if (evaluateValue) {
              isEvaluating = true;
              source += "';\n" + evaluateValue + ";\n__p += '";
            }
            if (interpolateValue) {
              source += "' +\n((__t = (" + interpolateValue + ")) == null ? '' : __t) +\n'";
            }
            index = offset + match.length;
            return match;
          });
          source += "';\n";
          var variable = hasOwnProperty.call(options, "variable") && options.variable;
          if (!variable) {
            source = "with (obj) {\n" + source + "\n}\n";
          } else if (reForbiddenIdentifierChars.test(variable)) {
            throw new Error2(INVALID_TEMPL_VAR_ERROR_TEXT);
          }
          source = (isEvaluating ? source.replace(reEmptyStringLeading, "") : source).replace(reEmptyStringMiddle, "$1").replace(reEmptyStringTrailing, "$1;");
          source = "function(" + (variable || "obj") + ") {\n" + (variable ? "" : "obj || (obj = {});\n") + "var __t, __p = ''" + (isEscaping ? ", __e = _.escape" : "") + (isEvaluating ? ", __j = Array.prototype.join;\nfunction print() { __p += __j.call(arguments, '') }\n" : ";\n") + source + "return __p\n}";
          var result2 = attempt(function() {
            return Function2(importsKeys, sourceURL + "return " + source).apply(undefined2, importsValues);
          });
          result2.source = source;
          if (isError(result2)) {
            throw result2;
          }
          return result2;
        }
        function toLower(value) {
          return toString(value).toLowerCase();
        }
        function toUpper(value) {
          return toString(value).toUpperCase();
        }
        function trim(string, chars, guard) {
          string = toString(string);
          if (string && (guard || chars === undefined2)) {
            return baseTrim(string);
          }
          if (!string || !(chars = baseToString(chars))) {
            return string;
          }
          var strSymbols = stringToArray(string), chrSymbols = stringToArray(chars), start = charsStartIndex(strSymbols, chrSymbols), end = charsEndIndex(strSymbols, chrSymbols) + 1;
          return castSlice(strSymbols, start, end).join("");
        }
        function trimEnd(string, chars, guard) {
          string = toString(string);
          if (string && (guard || chars === undefined2)) {
            return string.slice(0, trimmedEndIndex(string) + 1);
          }
          if (!string || !(chars = baseToString(chars))) {
            return string;
          }
          var strSymbols = stringToArray(string), end = charsEndIndex(strSymbols, stringToArray(chars)) + 1;
          return castSlice(strSymbols, 0, end).join("");
        }
        function trimStart(string, chars, guard) {
          string = toString(string);
          if (string && (guard || chars === undefined2)) {
            return string.replace(reTrimStart, "");
          }
          if (!string || !(chars = baseToString(chars))) {
            return string;
          }
          var strSymbols = stringToArray(string), start = charsStartIndex(strSymbols, stringToArray(chars));
          return castSlice(strSymbols, start).join("");
        }
        function truncate(string, options) {
          var length = DEFAULT_TRUNC_LENGTH, omission = DEFAULT_TRUNC_OMISSION;
          if (isObject(options)) {
            var separator = "separator" in options ? options.separator : separator;
            length = "length" in options ? toInteger(options.length) : length;
            omission = "omission" in options ? baseToString(options.omission) : omission;
          }
          string = toString(string);
          var strLength = string.length;
          if (hasUnicode(string)) {
            var strSymbols = stringToArray(string);
            strLength = strSymbols.length;
          }
          if (length >= strLength) {
            return string;
          }
          var end = length - stringSize(omission);
          if (end < 1) {
            return omission;
          }
          var result2 = strSymbols ? castSlice(strSymbols, 0, end).join("") : string.slice(0, end);
          if (separator === undefined2) {
            return result2 + omission;
          }
          if (strSymbols) {
            end += result2.length - end;
          }
          if (isRegExp(separator)) {
            if (string.slice(end).search(separator)) {
              var match, substring = result2;
              if (!separator.global) {
                separator = RegExp2(separator.source, toString(reFlags.exec(separator)) + "g");
              }
              separator.lastIndex = 0;
              while (match = separator.exec(substring)) {
                var newEnd = match.index;
              }
              result2 = result2.slice(0, newEnd === undefined2 ? end : newEnd);
            }
          } else if (string.indexOf(baseToString(separator), end) != end) {
            var index = result2.lastIndexOf(separator);
            if (index > -1) {
              result2 = result2.slice(0, index);
            }
          }
          return result2 + omission;
        }
        function unescape(string) {
          string = toString(string);
          return string && reHasEscapedHtml.test(string) ? string.replace(reEscapedHtml, unescapeHtmlChar) : string;
        }
        var upperCase = createCompounder(function(result2, word, index) {
          return result2 + (index ? " " : "") + word.toUpperCase();
        });
        var upperFirst = createCaseFirst("toUpperCase");
        function words(string, pattern, guard) {
          string = toString(string);
          pattern = guard ? undefined2 : pattern;
          if (pattern === undefined2) {
            return hasUnicodeWord(string) ? unicodeWords(string) : asciiWords(string);
          }
          return string.match(pattern) || [];
        }
        var attempt = baseRest(function(func, args) {
          try {
            return apply(func, undefined2, args);
          } catch (e) {
            return isError(e) ? e : new Error2(e);
          }
        });
        var bindAll = flatRest(function(object, methodNames) {
          arrayEach(methodNames, function(key) {
            key = toKey(key);
            baseAssignValue(object, key, bind(object[key], object));
          });
          return object;
        });
        function cond(pairs) {
          var length = pairs == null ? 0 : pairs.length, toIteratee = getIteratee();
          pairs = !length ? [] : arrayMap(pairs, function(pair) {
            if (typeof pair[1] != "function") {
              throw new TypeError2(FUNC_ERROR_TEXT);
            }
            return [toIteratee(pair[0]), pair[1]];
          });
          return baseRest(function(args) {
            var index = -1;
            while (++index < length) {
              var pair = pairs[index];
              if (apply(pair[0], this, args)) {
                return apply(pair[1], this, args);
              }
            }
          });
        }
        function conforms(source) {
          return baseConforms(baseClone(source, CLONE_DEEP_FLAG));
        }
        function constant(value) {
          return function() {
            return value;
          };
        }
        function defaultTo(value, defaultValue) {
          return value == null || value !== value ? defaultValue : value;
        }
        var flow = createFlow();
        var flowRight = createFlow(true);
        function identity(value) {
          return value;
        }
        function iteratee(func) {
          return baseIteratee(typeof func == "function" ? func : baseClone(func, CLONE_DEEP_FLAG));
        }
        function matches(source) {
          return baseMatches(baseClone(source, CLONE_DEEP_FLAG));
        }
        function matchesProperty(path2, srcValue) {
          return baseMatchesProperty(path2, baseClone(srcValue, CLONE_DEEP_FLAG));
        }
        var method = baseRest(function(path2, args) {
          return function(object) {
            return baseInvoke(object, path2, args);
          };
        });
        var methodOf = baseRest(function(object, args) {
          return function(path2) {
            return baseInvoke(object, path2, args);
          };
        });
        function mixin(object, source, options) {
          var props = keys(source), methodNames = baseFunctions(source, props);
          if (options == null && !(isObject(source) && (methodNames.length || !props.length))) {
            options = source;
            source = object;
            object = this;
            methodNames = baseFunctions(source, keys(source));
          }
          var chain2 = !(isObject(options) && "chain" in options) || !!options.chain, isFunc = isFunction(object);
          arrayEach(methodNames, function(methodName) {
            var func = source[methodName];
            object[methodName] = func;
            if (isFunc) {
              object.prototype[methodName] = function() {
                var chainAll = this.__chain__;
                if (chain2 || chainAll) {
                  var result2 = object(this.__wrapped__), actions = result2.__actions__ = copyArray(this.__actions__);
                  actions.push({ "func": func, "args": arguments, "thisArg": object });
                  result2.__chain__ = chainAll;
                  return result2;
                }
                return func.apply(object, arrayPush([this.value()], arguments));
              };
            }
          });
          return object;
        }
        function noConflict() {
          if (root._ === this) {
            root._ = oldDash;
          }
          return this;
        }
        function noop() {
        }
        function nthArg(n) {
          n = toInteger(n);
          return baseRest(function(args) {
            return baseNth(args, n);
          });
        }
        var over = createOver(arrayMap);
        var overEvery = createOver(arrayEvery);
        var overSome = createOver(arraySome);
        function property(path2) {
          return isKey(path2) ? baseProperty(toKey(path2)) : basePropertyDeep(path2);
        }
        function propertyOf(object) {
          return function(path2) {
            return object == null ? undefined2 : baseGet(object, path2);
          };
        }
        var range = createRange();
        var rangeRight = createRange(true);
        function stubArray() {
          return [];
        }
        function stubFalse() {
          return false;
        }
        function stubObject() {
          return {};
        }
        function stubString() {
          return "";
        }
        function stubTrue() {
          return true;
        }
        function times(n, iteratee2) {
          n = toInteger(n);
          if (n < 1 || n > MAX_SAFE_INTEGER) {
            return [];
          }
          var index = MAX_ARRAY_LENGTH, length = nativeMin(n, MAX_ARRAY_LENGTH);
          iteratee2 = getIteratee(iteratee2);
          n -= MAX_ARRAY_LENGTH;
          var result2 = baseTimes(length, iteratee2);
          while (++index < n) {
            iteratee2(index);
          }
          return result2;
        }
        function toPath(value) {
          if (isArray(value)) {
            return arrayMap(value, toKey);
          }
          return isSymbol(value) ? [value] : copyArray(stringToPath(toString(value)));
        }
        function uniqueId(prefix) {
          var id = ++idCounter;
          return toString(prefix) + id;
        }
        var add = createMathOperation(function(augend, addend) {
          return augend + addend;
        }, 0);
        var ceil = createRound("ceil");
        var divide = createMathOperation(function(dividend, divisor) {
          return dividend / divisor;
        }, 1);
        var floor = createRound("floor");
        function max(array) {
          return array && array.length ? baseExtremum(array, identity, baseGt) : undefined2;
        }
        function maxBy(array, iteratee2) {
          return array && array.length ? baseExtremum(array, getIteratee(iteratee2, 2), baseGt) : undefined2;
        }
        function mean(array) {
          return baseMean(array, identity);
        }
        function meanBy(array, iteratee2) {
          return baseMean(array, getIteratee(iteratee2, 2));
        }
        function min(array) {
          return array && array.length ? baseExtremum(array, identity, baseLt) : undefined2;
        }
        function minBy(array, iteratee2) {
          return array && array.length ? baseExtremum(array, getIteratee(iteratee2, 2), baseLt) : undefined2;
        }
        var multiply = createMathOperation(function(multiplier, multiplicand) {
          return multiplier * multiplicand;
        }, 1);
        var round = createRound("round");
        var subtract = createMathOperation(function(minuend, subtrahend) {
          return minuend - subtrahend;
        }, 0);
        function sum(array) {
          return array && array.length ? baseSum(array, identity) : 0;
        }
        function sumBy(array, iteratee2) {
          return array && array.length ? baseSum(array, getIteratee(iteratee2, 2)) : 0;
        }
        lodash.after = after;
        lodash.ary = ary;
        lodash.assign = assign;
        lodash.assignIn = assignIn;
        lodash.assignInWith = assignInWith;
        lodash.assignWith = assignWith;
        lodash.at = at;
        lodash.before = before;
        lodash.bind = bind;
        lodash.bindAll = bindAll;
        lodash.bindKey = bindKey;
        lodash.castArray = castArray;
        lodash.chain = chain;
        lodash.chunk = chunk;
        lodash.compact = compact;
        lodash.concat = concat;
        lodash.cond = cond;
        lodash.conforms = conforms;
        lodash.constant = constant;
        lodash.countBy = countBy;
        lodash.create = create;
        lodash.curry = curry;
        lodash.curryRight = curryRight;
        lodash.debounce = debounce;
        lodash.defaults = defaults;
        lodash.defaultsDeep = defaultsDeep;
        lodash.defer = defer;
        lodash.delay = delay;
        lodash.difference = difference;
        lodash.differenceBy = differenceBy;
        lodash.differenceWith = differenceWith;
        lodash.drop = drop;
        lodash.dropRight = dropRight;
        lodash.dropRightWhile = dropRightWhile;
        lodash.dropWhile = dropWhile;
        lodash.fill = fill;
        lodash.filter = filter;
        lodash.flatMap = flatMap;
        lodash.flatMapDeep = flatMapDeep;
        lodash.flatMapDepth = flatMapDepth;
        lodash.flatten = flatten;
        lodash.flattenDeep = flattenDeep;
        lodash.flattenDepth = flattenDepth;
        lodash.flip = flip;
        lodash.flow = flow;
        lodash.flowRight = flowRight;
        lodash.fromPairs = fromPairs;
        lodash.functions = functions;
        lodash.functionsIn = functionsIn;
        lodash.groupBy = groupBy;
        lodash.initial = initial;
        lodash.intersection = intersection;
        lodash.intersectionBy = intersectionBy;
        lodash.intersectionWith = intersectionWith;
        lodash.invert = invert;
        lodash.invertBy = invertBy;
        lodash.invokeMap = invokeMap;
        lodash.iteratee = iteratee;
        lodash.keyBy = keyBy;
        lodash.keys = keys;
        lodash.keysIn = keysIn;
        lodash.map = map;
        lodash.mapKeys = mapKeys;
        lodash.mapValues = mapValues;
        lodash.matches = matches;
        lodash.matchesProperty = matchesProperty;
        lodash.memoize = memoize;
        lodash.merge = merge;
        lodash.mergeWith = mergeWith;
        lodash.method = method;
        lodash.methodOf = methodOf;
        lodash.mixin = mixin;
        lodash.negate = negate;
        lodash.nthArg = nthArg;
        lodash.omit = omit;
        lodash.omitBy = omitBy;
        lodash.once = once;
        lodash.orderBy = orderBy;
        lodash.over = over;
        lodash.overArgs = overArgs;
        lodash.overEvery = overEvery;
        lodash.overSome = overSome;
        lodash.partial = partial;
        lodash.partialRight = partialRight;
        lodash.partition = partition;
        lodash.pick = pick;
        lodash.pickBy = pickBy;
        lodash.property = property;
        lodash.propertyOf = propertyOf;
        lodash.pull = pull;
        lodash.pullAll = pullAll;
        lodash.pullAllBy = pullAllBy;
        lodash.pullAllWith = pullAllWith;
        lodash.pullAt = pullAt;
        lodash.range = range;
        lodash.rangeRight = rangeRight;
        lodash.rearg = rearg;
        lodash.reject = reject;
        lodash.remove = remove;
        lodash.rest = rest;
        lodash.reverse = reverse;
        lodash.sampleSize = sampleSize;
        lodash.set = set;
        lodash.setWith = setWith;
        lodash.shuffle = shuffle;
        lodash.slice = slice;
        lodash.sortBy = sortBy;
        lodash.sortedUniq = sortedUniq;
        lodash.sortedUniqBy = sortedUniqBy;
        lodash.split = split;
        lodash.spread = spread;
        lodash.tail = tail;
        lodash.take = take;
        lodash.takeRight = takeRight;
        lodash.takeRightWhile = takeRightWhile;
        lodash.takeWhile = takeWhile;
        lodash.tap = tap;
        lodash.throttle = throttle;
        lodash.thru = thru;
        lodash.toArray = toArray;
        lodash.toPairs = toPairs;
        lodash.toPairsIn = toPairsIn;
        lodash.toPath = toPath;
        lodash.toPlainObject = toPlainObject;
        lodash.transform = transform;
        lodash.unary = unary;
        lodash.union = union;
        lodash.unionBy = unionBy;
        lodash.unionWith = unionWith;
        lodash.uniq = uniq;
        lodash.uniqBy = uniqBy;
        lodash.uniqWith = uniqWith;
        lodash.unset = unset;
        lodash.unzip = unzip;
        lodash.unzipWith = unzipWith;
        lodash.update = update;
        lodash.updateWith = updateWith;
        lodash.values = values;
        lodash.valuesIn = valuesIn;
        lodash.without = without;
        lodash.words = words;
        lodash.wrap = wrap;
        lodash.xor = xor;
        lodash.xorBy = xorBy;
        lodash.xorWith = xorWith;
        lodash.zip = zip;
        lodash.zipObject = zipObject;
        lodash.zipObjectDeep = zipObjectDeep;
        lodash.zipWith = zipWith;
        lodash.entries = toPairs;
        lodash.entriesIn = toPairsIn;
        lodash.extend = assignIn;
        lodash.extendWith = assignInWith;
        mixin(lodash, lodash);
        lodash.add = add;
        lodash.attempt = attempt;
        lodash.camelCase = camelCase;
        lodash.capitalize = capitalize;
        lodash.ceil = ceil;
        lodash.clamp = clamp;
        lodash.clone = clone;
        lodash.cloneDeep = cloneDeep;
        lodash.cloneDeepWith = cloneDeepWith;
        lodash.cloneWith = cloneWith;
        lodash.conformsTo = conformsTo;
        lodash.deburr = deburr;
        lodash.defaultTo = defaultTo;
        lodash.divide = divide;
        lodash.endsWith = endsWith;
        lodash.eq = eq;
        lodash.escape = escape;
        lodash.escapeRegExp = escapeRegExp;
        lodash.every = every;
        lodash.find = find;
        lodash.findIndex = findIndex;
        lodash.findKey = findKey;
        lodash.findLast = findLast;
        lodash.findLastIndex = findLastIndex;
        lodash.findLastKey = findLastKey;
        lodash.floor = floor;
        lodash.forEach = forEach;
        lodash.forEachRight = forEachRight;
        lodash.forIn = forIn;
        lodash.forInRight = forInRight;
        lodash.forOwn = forOwn;
        lodash.forOwnRight = forOwnRight;
        lodash.get = get;
        lodash.gt = gt;
        lodash.gte = gte;
        lodash.has = has;
        lodash.hasIn = hasIn;
        lodash.head = head;
        lodash.identity = identity;
        lodash.includes = includes;
        lodash.indexOf = indexOf;
        lodash.inRange = inRange;
        lodash.invoke = invoke;
        lodash.isArguments = isArguments;
        lodash.isArray = isArray;
        lodash.isArrayBuffer = isArrayBuffer;
        lodash.isArrayLike = isArrayLike;
        lodash.isArrayLikeObject = isArrayLikeObject;
        lodash.isBoolean = isBoolean;
        lodash.isBuffer = isBuffer;
        lodash.isDate = isDate;
        lodash.isElement = isElement;
        lodash.isEmpty = isEmpty;
        lodash.isEqual = isEqual;
        lodash.isEqualWith = isEqualWith;
        lodash.isError = isError;
        lodash.isFinite = isFinite2;
        lodash.isFunction = isFunction;
        lodash.isInteger = isInteger;
        lodash.isLength = isLength;
        lodash.isMap = isMap;
        lodash.isMatch = isMatch;
        lodash.isMatchWith = isMatchWith;
        lodash.isNaN = isNaN2;
        lodash.isNative = isNative;
        lodash.isNil = isNil;
        lodash.isNull = isNull;
        lodash.isNumber = isNumber;
        lodash.isObject = isObject;
        lodash.isObjectLike = isObjectLike;
        lodash.isPlainObject = isPlainObject;
        lodash.isRegExp = isRegExp;
        lodash.isSafeInteger = isSafeInteger;
        lodash.isSet = isSet;
        lodash.isString = isString;
        lodash.isSymbol = isSymbol;
        lodash.isTypedArray = isTypedArray;
        lodash.isUndefined = isUndefined;
        lodash.isWeakMap = isWeakMap;
        lodash.isWeakSet = isWeakSet;
        lodash.join = join;
        lodash.kebabCase = kebabCase;
        lodash.last = last;
        lodash.lastIndexOf = lastIndexOf;
        lodash.lowerCase = lowerCase;
        lodash.lowerFirst = lowerFirst;
        lodash.lt = lt;
        lodash.lte = lte;
        lodash.max = max;
        lodash.maxBy = maxBy;
        lodash.mean = mean;
        lodash.meanBy = meanBy;
        lodash.min = min;
        lodash.minBy = minBy;
        lodash.stubArray = stubArray;
        lodash.stubFalse = stubFalse;
        lodash.stubObject = stubObject;
        lodash.stubString = stubString;
        lodash.stubTrue = stubTrue;
        lodash.multiply = multiply;
        lodash.nth = nth;
        lodash.noConflict = noConflict;
        lodash.noop = noop;
        lodash.now = now;
        lodash.pad = pad;
        lodash.padEnd = padEnd;
        lodash.padStart = padStart;
        lodash.parseInt = parseInt2;
        lodash.random = random;
        lodash.reduce = reduce;
        lodash.reduceRight = reduceRight;
        lodash.repeat = repeat;
        lodash.replace = replace;
        lodash.result = result;
        lodash.round = round;
        lodash.runInContext = runInContext2;
        lodash.sample = sample;
        lodash.size = size;
        lodash.snakeCase = snakeCase;
        lodash.some = some;
        lodash.sortedIndex = sortedIndex;
        lodash.sortedIndexBy = sortedIndexBy;
        lodash.sortedIndexOf = sortedIndexOf;
        lodash.sortedLastIndex = sortedLastIndex;
        lodash.sortedLastIndexBy = sortedLastIndexBy;
        lodash.sortedLastIndexOf = sortedLastIndexOf;
        lodash.startCase = startCase;
        lodash.startsWith = startsWith;
        lodash.subtract = subtract;
        lodash.sum = sum;
        lodash.sumBy = sumBy;
        lodash.template = template;
        lodash.times = times;
        lodash.toFinite = toFinite;
        lodash.toInteger = toInteger;
        lodash.toLength = toLength;
        lodash.toLower = toLower;
        lodash.toNumber = toNumber;
        lodash.toSafeInteger = toSafeInteger;
        lodash.toString = toString;
        lodash.toUpper = toUpper;
        lodash.trim = trim;
        lodash.trimEnd = trimEnd;
        lodash.trimStart = trimStart;
        lodash.truncate = truncate;
        lodash.unescape = unescape;
        lodash.uniqueId = uniqueId;
        lodash.upperCase = upperCase;
        lodash.upperFirst = upperFirst;
        lodash.each = forEach;
        lodash.eachRight = forEachRight;
        lodash.first = head;
        mixin(lodash, (function() {
          var source = {};
          baseForOwn(lodash, function(func, methodName) {
            if (!hasOwnProperty.call(lodash.prototype, methodName)) {
              source[methodName] = func;
            }
          });
          return source;
        })(), { "chain": false });
        lodash.VERSION = VERSION;
        arrayEach(["bind", "bindKey", "curry", "curryRight", "partial", "partialRight"], function(methodName) {
          lodash[methodName].placeholder = lodash;
        });
        arrayEach(["drop", "take"], function(methodName, index) {
          LazyWrapper.prototype[methodName] = function(n) {
            n = n === undefined2 ? 1 : nativeMax(toInteger(n), 0);
            var result2 = this.__filtered__ && !index ? new LazyWrapper(this) : this.clone();
            if (result2.__filtered__) {
              result2.__takeCount__ = nativeMin(n, result2.__takeCount__);
            } else {
              result2.__views__.push({
                "size": nativeMin(n, MAX_ARRAY_LENGTH),
                "type": methodName + (result2.__dir__ < 0 ? "Right" : "")
              });
            }
            return result2;
          };
          LazyWrapper.prototype[methodName + "Right"] = function(n) {
            return this.reverse()[methodName](n).reverse();
          };
        });
        arrayEach(["filter", "map", "takeWhile"], function(methodName, index) {
          var type = index + 1, isFilter = type == LAZY_FILTER_FLAG || type == LAZY_WHILE_FLAG;
          LazyWrapper.prototype[methodName] = function(iteratee2) {
            var result2 = this.clone();
            result2.__iteratees__.push({
              "iteratee": getIteratee(iteratee2, 3),
              "type": type
            });
            result2.__filtered__ = result2.__filtered__ || isFilter;
            return result2;
          };
        });
        arrayEach(["head", "last"], function(methodName, index) {
          var takeName = "take" + (index ? "Right" : "");
          LazyWrapper.prototype[methodName] = function() {
            return this[takeName](1).value()[0];
          };
        });
        arrayEach(["initial", "tail"], function(methodName, index) {
          var dropName = "drop" + (index ? "" : "Right");
          LazyWrapper.prototype[methodName] = function() {
            return this.__filtered__ ? new LazyWrapper(this) : this[dropName](1);
          };
        });
        LazyWrapper.prototype.compact = function() {
          return this.filter(identity);
        };
        LazyWrapper.prototype.find = function(predicate) {
          return this.filter(predicate).head();
        };
        LazyWrapper.prototype.findLast = function(predicate) {
          return this.reverse().find(predicate);
        };
        LazyWrapper.prototype.invokeMap = baseRest(function(path2, args) {
          if (typeof path2 == "function") {
            return new LazyWrapper(this);
          }
          return this.map(function(value) {
            return baseInvoke(value, path2, args);
          });
        });
        LazyWrapper.prototype.reject = function(predicate) {
          return this.filter(negate(getIteratee(predicate)));
        };
        LazyWrapper.prototype.slice = function(start, end) {
          start = toInteger(start);
          var result2 = this;
          if (result2.__filtered__ && (start > 0 || end < 0)) {
            return new LazyWrapper(result2);
          }
          if (start < 0) {
            result2 = result2.takeRight(-start);
          } else if (start) {
            result2 = result2.drop(start);
          }
          if (end !== undefined2) {
            end = toInteger(end);
            result2 = end < 0 ? result2.dropRight(-end) : result2.take(end - start);
          }
          return result2;
        };
        LazyWrapper.prototype.takeRightWhile = function(predicate) {
          return this.reverse().takeWhile(predicate).reverse();
        };
        LazyWrapper.prototype.toArray = function() {
          return this.take(MAX_ARRAY_LENGTH);
        };
        baseForOwn(LazyWrapper.prototype, function(func, methodName) {
          var checkIteratee = /^(?:filter|find|map|reject)|While$/.test(methodName), isTaker = /^(?:head|last)$/.test(methodName), lodashFunc = lodash[isTaker ? "take" + (methodName == "last" ? "Right" : "") : methodName], retUnwrapped = isTaker || /^find/.test(methodName);
          if (!lodashFunc) {
            return;
          }
          lodash.prototype[methodName] = function() {
            var value = this.__wrapped__, args = isTaker ? [1] : arguments, isLazy = value instanceof LazyWrapper, iteratee2 = args[0], useLazy = isLazy || isArray(value);
            var interceptor = function(value2) {
              var result3 = lodashFunc.apply(lodash, arrayPush([value2], args));
              return isTaker && chainAll ? result3[0] : result3;
            };
            if (useLazy && checkIteratee && typeof iteratee2 == "function" && iteratee2.length != 1) {
              isLazy = useLazy = false;
            }
            var chainAll = this.__chain__, isHybrid = !!this.__actions__.length, isUnwrapped = retUnwrapped && !chainAll, onlyLazy = isLazy && !isHybrid;
            if (!retUnwrapped && useLazy) {
              value = onlyLazy ? value : new LazyWrapper(this);
              var result2 = func.apply(value, args);
              result2.__actions__.push({ "func": thru, "args": [interceptor], "thisArg": undefined2 });
              return new LodashWrapper(result2, chainAll);
            }
            if (isUnwrapped && onlyLazy) {
              return func.apply(this, args);
            }
            result2 = this.thru(interceptor);
            return isUnwrapped ? isTaker ? result2.value()[0] : result2.value() : result2;
          };
        });
        arrayEach(["pop", "push", "shift", "sort", "splice", "unshift"], function(methodName) {
          var func = arrayProto[methodName], chainName = /^(?:push|sort|unshift)$/.test(methodName) ? "tap" : "thru", retUnwrapped = /^(?:pop|shift)$/.test(methodName);
          lodash.prototype[methodName] = function() {
            var args = arguments;
            if (retUnwrapped && !this.__chain__) {
              var value = this.value();
              return func.apply(isArray(value) ? value : [], args);
            }
            return this[chainName](function(value2) {
              return func.apply(isArray(value2) ? value2 : [], args);
            });
          };
        });
        baseForOwn(LazyWrapper.prototype, function(func, methodName) {
          var lodashFunc = lodash[methodName];
          if (lodashFunc) {
            var key = lodashFunc.name + "";
            if (!hasOwnProperty.call(realNames, key)) {
              realNames[key] = [];
            }
            realNames[key].push({ "name": methodName, "func": lodashFunc });
          }
        });
        realNames[createHybrid(undefined2, WRAP_BIND_KEY_FLAG).name] = [{
          "name": "wrapper",
          "func": undefined2
        }];
        LazyWrapper.prototype.clone = lazyClone;
        LazyWrapper.prototype.reverse = lazyReverse;
        LazyWrapper.prototype.value = lazyValue;
        lodash.prototype.at = wrapperAt;
        lodash.prototype.chain = wrapperChain;
        lodash.prototype.commit = wrapperCommit;
        lodash.prototype.next = wrapperNext;
        lodash.prototype.plant = wrapperPlant;
        lodash.prototype.reverse = wrapperReverse;
        lodash.prototype.toJSON = lodash.prototype.valueOf = lodash.prototype.value = wrapperValue;
        lodash.prototype.first = lodash.prototype.head;
        if (symIterator) {
          lodash.prototype[symIterator] = wrapperToIterator;
        }
        return lodash;
      });
      var _ = runInContext();
      if (typeof define == "function" && typeof define.amd == "object" && define.amd) {
        root._ = _;
        define(function() {
          return _;
        });
      } else if (freeModule) {
        (freeModule.exports = _)._ = _;
        freeExports._ = _;
      } else {
        root._ = _;
      }
    }).call(exports2);
  }
});

// node_modules/@darabonba/typescript/dist/func.js
var require_func = __commonJS({
  "node_modules/@darabonba/typescript/dist/func.js"(exports2) {
    "use strict";
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    }) : (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      o[k2] = m[k];
    }));
    var __setModuleDefault = exports2 && exports2.__setModuleDefault || (Object.create ? (function(o, v) {
      Object.defineProperty(o, "default", { enumerable: true, value: v });
    }) : function(o, v) {
      o["default"] = v;
    });
    var __importStar = exports2 && exports2.__importStar || function(mod) {
      if (mod && mod.__esModule) return mod;
      var result = {};
      if (mod != null) {
        for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
      }
      __setModuleDefault(result, mod);
      return result;
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.sleep = exports2.merge = exports2.isNull = void 0;
    var _ = __importStar(require_lodash());
    function isNull(data) {
      if (typeof data === "undefined") {
        return true;
      }
      if (data === null) {
        return true;
      }
      return false;
    }
    exports2.isNull = isNull;
    function merge(source, data) {
      if (!source && !data) {
        return null;
      }
      return _.merge({}, source, data);
    }
    exports2.merge = merge;
    function sleep(ms) {
      return new Promise(function(resolve2) {
        setTimeout(resolve2, ms);
      });
    }
    exports2.sleep = sleep;
  }
});

// node_modules/@darabonba/typescript/dist/stream.js
var require_stream = __commonJS({
  "node_modules/@darabonba/typescript/dist/stream.js"(exports2) {
    "use strict";
    var __awaiter = exports2 && exports2.__awaiter || function(thisArg, _arguments, P, generator) {
      function adopt(value) {
        return value instanceof P ? value : new P(function(resolve2) {
          resolve2(value);
        });
      }
      return new (P || (P = Promise))(function(resolve2, reject) {
        function fulfilled(value) {
          try {
            step(generator.next(value));
          } catch (e) {
            reject(e);
          }
        }
        function rejected(value) {
          try {
            step(generator["throw"](value));
          } catch (e) {
            reject(e);
          }
        }
        function step(result) {
          result.done ? resolve2(result.value) : adopt(result.value).then(fulfilled, rejected);
        }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
      });
    };
    var __generator = exports2 && exports2.__generator || function(thisArg, body) {
      var _ = { label: 0, sent: function() {
        if (t[0] & 1) throw t[1];
        return t[1];
      }, trys: [], ops: [] }, f, y, t, g;
      return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() {
        return this;
      }), g;
      function verb(n) {
        return function(v) {
          return step([n, v]);
        };
      }
      function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
          if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
          if (y = 0, t) op = [op[0] & 2, t.value];
          switch (op[0]) {
            case 0:
            case 1:
              t = op;
              break;
            case 4:
              _.label++;
              return { value: op[1], done: false };
            case 5:
              _.label++;
              y = op[1];
              op = [0];
              continue;
            case 7:
              op = _.ops.pop();
              _.trys.pop();
              continue;
            default:
              if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) {
                _ = 0;
                continue;
              }
              if (op[0] === 3 && (!t || op[1] > t[0] && op[1] < t[3])) {
                _.label = op[1];
                break;
              }
              if (op[0] === 6 && _.label < t[1]) {
                _.label = t[1];
                t = op;
                break;
              }
              if (t && _.label < t[2]) {
                _.label = t[2];
                _.ops.push(op);
                break;
              }
              if (t[2]) _.ops.pop();
              _.trys.pop();
              continue;
          }
          op = body.call(thisArg, _);
        } catch (e) {
          op = [6, e];
          y = 0;
        } finally {
          f = t = 0;
        }
        if (op[0] & 5) throw op[1];
        return { value: op[0] ? op[1] : void 0, done: true };
      }
    };
    var __await = exports2 && exports2.__await || function(v) {
      return this instanceof __await ? (this.v = v, this) : new __await(v);
    };
    var __asyncGenerator = exports2 && exports2.__asyncGenerator || function(thisArg, _arguments, generator) {
      if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
      var g = generator.apply(thisArg, _arguments || []), i, q = [];
      return i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function() {
        return this;
      }, i;
      function verb(n) {
        if (g[n]) i[n] = function(v) {
          return new Promise(function(a, b) {
            q.push([n, v, a, b]) > 1 || resume(n, v);
          });
        };
      }
      function resume(n, v) {
        try {
          step(g[n](v));
        } catch (e) {
          settle(q[0][3], e);
        }
      }
      function step(r) {
        r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r);
      }
      function fulfill(value) {
        resume("next", value);
      }
      function reject(value) {
        resume("throw", value);
      }
      function settle(f, v) {
        if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]);
      }
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.SSEEvent = void 0;
    var DATA_PREFIX = "data:";
    var EVENT_PREFIX = "event:";
    var ID_PREFIX = "id:";
    var RETRY_PREFIX = "retry:";
    function isDigitsOnly(str) {
      for (var i = 0; i < str.length; i++) {
        var c = str.charAt(i);
        if (c < "0" || c > "9") {
          return false;
        }
      }
      return str.length > 0;
    }
    var SSEEvent = (
      /** @class */
      /* @__PURE__ */ (function() {
        function SSEEvent2(data) {
          if (data === void 0) {
            data = {};
          }
          this.data = data.data;
          this.id = data.id;
          this.event = data.event;
          this.retry = data.retry;
        }
        return SSEEvent2;
      })()
    );
    exports2.SSEEvent = SSEEvent;
    function read(readable) {
      return new Promise(function(resolve2, reject) {
        var onData, onError, onEnd;
        var cleanup = function() {
          readable.removeListener("error", onError);
          readable.removeListener("data", onData);
          readable.removeListener("end", onEnd);
        };
        var bufs = [];
        var size = 0;
        onData = function(buf) {
          bufs.push(buf);
          size += buf.length;
        };
        onError = function(err) {
          cleanup();
          reject(err);
        };
        onEnd = function() {
          cleanup();
          resolve2(Buffer.concat(bufs, size));
        };
        readable.on("error", onError);
        readable.on("data", onData);
        readable.on("end", onEnd);
      });
    }
    function readyToRead(readable) {
      return new Promise(function(resolve2, reject) {
        var onReadable, onEnd, onError;
        var cleanup = function() {
          readable.removeListener("error", onError);
          readable.removeListener("end", onEnd);
          readable.removeListener("readable", onReadable);
        };
        onReadable = function() {
          cleanup();
          resolve2(false);
        };
        onEnd = function() {
          cleanup();
          resolve2(true);
        };
        onError = function(err) {
          cleanup();
          reject(err);
        };
        readable.once("readable", onReadable);
        readable.once("end", onEnd);
        readable.once("error", onError);
      });
    }
    function tryGetEvents(head, chunk) {
      var all = head + chunk;
      var start = 0;
      var events = [];
      var _loop_1 = function(i2) {
        var c = all[i2];
        var c2 = all[i2 + 1];
        if (c === "\n" && c2 === "\n") {
          var part = all.substring(start, i2);
          var lines = part.split("\n");
          var event_1 = new SSEEvent();
          lines.forEach(function(line) {
            if (line.startsWith(DATA_PREFIX)) {
              event_1.data = line.substring(DATA_PREFIX.length).trim();
            } else if (line.startsWith(EVENT_PREFIX)) {
              event_1.event = line.substring(EVENT_PREFIX.length).trim();
            } else if (line.startsWith(ID_PREFIX)) {
              event_1.id = line.substring(ID_PREFIX.length).trim();
            } else if (line.startsWith(RETRY_PREFIX)) {
              var retry = line.substring(RETRY_PREFIX.length).trim();
              if (isDigitsOnly(retry)) {
                event_1.retry = parseInt(retry, 10);
              }
            } else if (line.startsWith(":")) {
            }
          });
          events.push(event_1);
          start = i2 + 2;
        }
      };
      for (var i = 0; i < all.length - 1; i++) {
        _loop_1(i);
      }
      var remain = all.substring(start);
      return { events, remain };
    }
    var TeaStream = (
      /** @class */
      (function() {
        function TeaStream2() {
        }
        TeaStream2.readAsBytes = function(stream) {
          return __awaiter(this, void 0, void 0, function() {
            return __generator(this, function(_a) {
              switch (_a.label) {
                case 0:
                  return [4, read(stream)];
                case 1:
                  return [2, _a.sent()];
              }
            });
          });
        };
        TeaStream2.readAsString = function(stream) {
          return __awaiter(this, void 0, void 0, function() {
            var buff;
            return __generator(this, function(_a) {
              switch (_a.label) {
                case 0:
                  return [4, TeaStream2.readAsBytes(stream)];
                case 1:
                  buff = _a.sent();
                  return [2, buff.toString()];
              }
            });
          });
        };
        TeaStream2.readAsJSON = function(stream) {
          return __awaiter(this, void 0, void 0, function() {
            var str;
            return __generator(this, function(_a) {
              switch (_a.label) {
                case 0:
                  return [4, TeaStream2.readAsString(stream)];
                case 1:
                  str = _a.sent();
                  return [2, JSON.parse(str)];
              }
            });
          });
        };
        TeaStream2.readAsSSE = function(stream) {
          return __asyncGenerator(this, arguments, function readAsSSE_1() {
            var rest, ended, chunk, _a, events, remain, _i, events_1, event_2;
            return __generator(this, function(_b) {
              switch (_b.label) {
                case 0:
                  rest = "";
                  _b.label = 1;
                case 1:
                  if (false) return [3, 12];
                  return [4, __await(readyToRead(stream))];
                case 2:
                  ended = _b.sent();
                  if (!ended) return [3, 4];
                  return [4, __await(void 0)];
                case 3:
                  return [2, _b.sent()];
                case 4:
                  chunk = void 0;
                  _b.label = 5;
                case 5:
                  if (!(null !== (chunk = stream.read()))) return [3, 11];
                  _a = tryGetEvents(rest, chunk.toString()), events = _a.events, remain = _a.remain;
                  rest = remain;
                  if (!(events && events.length > 0)) return [3, 10];
                  _i = 0, events_1 = events;
                  _b.label = 6;
                case 6:
                  if (!(_i < events_1.length)) return [3, 10];
                  event_2 = events_1[_i];
                  return [4, __await(event_2)];
                case 7:
                  return [4, _b.sent()];
                case 8:
                  _b.sent();
                  _b.label = 9;
                case 9:
                  _i++;
                  return [3, 6];
                case 10:
                  return [3, 5];
                case 11:
                  return [3, 1];
                case 12:
                  return [
                    2
                    /*return*/
                  ];
              }
            });
          });
        };
        return TeaStream2;
      })()
    );
    exports2.default = TeaStream;
  }
});

// node_modules/@darabonba/typescript/dist/url.js
var require_url = __commonJS({
  "node_modules/@darabonba/typescript/dist/url.js"(exports2) {
    "use strict";
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    }) : (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      o[k2] = m[k];
    }));
    var __setModuleDefault = exports2 && exports2.__setModuleDefault || (Object.create ? (function(o, v) {
      Object.defineProperty(o, "default", { enumerable: true, value: v });
    }) : function(o, v) {
      o["default"] = v;
    });
    var __importStar = exports2 && exports2.__importStar || function(mod) {
      if (mod && mod.__esModule) return mod;
      var result = {};
      if (mod != null) {
        for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
      }
      __setModuleDefault(result, mod);
      return result;
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    var url = __importStar(require("url"));
    var portMap = {
      ftp: "21",
      gopher: "70",
      http: "80",
      https: "443",
      ws: "80",
      wss: "443"
    };
    var TeaURL = (
      /** @class */
      (function() {
        function TeaURL2(str) {
          this._url = new url.URL(str);
        }
        TeaURL2.prototype.path = function() {
          return this._url.pathname + this._url.search;
        };
        TeaURL2.prototype.pathname = function() {
          return this._url.pathname;
        };
        TeaURL2.prototype.protocol = function() {
          return this._url.protocol ? this._url.protocol.replace(":", "") : "";
        };
        TeaURL2.prototype.hostname = function() {
          return this._url.hostname;
        };
        TeaURL2.prototype.host = function() {
          return this._url.host;
        };
        TeaURL2.prototype.port = function() {
          return this._url.port || portMap[this.protocol()];
        };
        TeaURL2.prototype.hash = function() {
          return this._url.hash ? this._url.hash.replace("#", "") : "";
        };
        TeaURL2.prototype.search = function() {
          return this._url.search ? this._url.search.replace("?", "") : "";
        };
        TeaURL2.prototype.href = function() {
          return this._url.href;
        };
        TeaURL2.prototype.auth = function() {
          return "".concat(this._url.username, ":").concat(this._url.password);
        };
        TeaURL2.parse = function(url2) {
          return new TeaURL2(url2);
        };
        TeaURL2.urlEncode = function(url2) {
          return url2 != null ? encodeURIComponent(url2) : "";
        };
        TeaURL2.percentEncode = function(raw) {
          return raw != null ? encodeURIComponent(raw).replace("+", "%20").replace("*", "%2A").replace("%7E", "~") : null;
        };
        TeaURL2.pathEncode = function(path2) {
          if (!path2 || path2 === "/") {
            return path2;
          }
          var paths = path2.split("/");
          var sb = [];
          for (var _i = 0, paths_1 = paths; _i < paths_1.length; _i++) {
            var s = paths_1[_i];
            sb.push(TeaURL2.percentEncode(s));
          }
          return sb.join("/");
        };
        return TeaURL2;
      })()
    );
    exports2.default = TeaURL;
  }
});

// node_modules/xml2js/lib/defaults.js
var require_defaults = __commonJS({
  "node_modules/xml2js/lib/defaults.js"(exports2) {
    (function() {
      exports2.defaults = {
        "0.1": {
          explicitCharkey: false,
          trim: true,
          normalize: true,
          normalizeTags: false,
          attrkey: "@",
          charkey: "#",
          explicitArray: false,
          ignoreAttrs: false,
          mergeAttrs: false,
          explicitRoot: false,
          validator: null,
          xmlns: false,
          explicitChildren: false,
          childkey: "@@",
          charsAsChildren: false,
          includeWhiteChars: false,
          async: false,
          strict: true,
          attrNameProcessors: null,
          attrValueProcessors: null,
          tagNameProcessors: null,
          valueProcessors: null,
          emptyTag: ""
        },
        "0.2": {
          explicitCharkey: false,
          trim: false,
          normalize: false,
          normalizeTags: false,
          attrkey: "$",
          charkey: "_",
          explicitArray: true,
          ignoreAttrs: false,
          mergeAttrs: false,
          explicitRoot: true,
          validator: null,
          xmlns: false,
          explicitChildren: false,
          preserveChildrenOrder: false,
          childkey: "$$",
          charsAsChildren: false,
          includeWhiteChars: false,
          async: false,
          strict: true,
          attrNameProcessors: null,
          attrValueProcessors: null,
          tagNameProcessors: null,
          valueProcessors: null,
          rootName: "root",
          xmldec: {
            "version": "1.0",
            "encoding": "UTF-8",
            "standalone": true
          },
          doctype: null,
          renderOpts: {
            "pretty": true,
            "indent": "  ",
            "newline": "\n"
          },
          headless: false,
          chunkSize: 1e4,
          emptyTag: "",
          cdata: false
        }
      };
    }).call(exports2);
  }
});

// node_modules/xmlbuilder/lib/Utility.js
var require_Utility = __commonJS({
  "node_modules/xmlbuilder/lib/Utility.js"(exports2, module2) {
    (function() {
      var assign, getValue, isArray, isEmpty, isFunction, isObject, isPlainObject, slice = [].slice, hasProp = {}.hasOwnProperty;
      assign = function() {
        var i, key, len, source, sources, target;
        target = arguments[0], sources = 2 <= arguments.length ? slice.call(arguments, 1) : [];
        if (isFunction(Object.assign)) {
          Object.assign.apply(null, arguments);
        } else {
          for (i = 0, len = sources.length; i < len; i++) {
            source = sources[i];
            if (source != null) {
              for (key in source) {
                if (!hasProp.call(source, key)) continue;
                target[key] = source[key];
              }
            }
          }
        }
        return target;
      };
      isFunction = function(val) {
        return !!val && Object.prototype.toString.call(val) === "[object Function]";
      };
      isObject = function(val) {
        var ref;
        return !!val && ((ref = typeof val) === "function" || ref === "object");
      };
      isArray = function(val) {
        if (isFunction(Array.isArray)) {
          return Array.isArray(val);
        } else {
          return Object.prototype.toString.call(val) === "[object Array]";
        }
      };
      isEmpty = function(val) {
        var key;
        if (isArray(val)) {
          return !val.length;
        } else {
          for (key in val) {
            if (!hasProp.call(val, key)) continue;
            return false;
          }
          return true;
        }
      };
      isPlainObject = function(val) {
        var ctor, proto;
        return isObject(val) && (proto = Object.getPrototypeOf(val)) && (ctor = proto.constructor) && typeof ctor === "function" && ctor instanceof ctor && Function.prototype.toString.call(ctor) === Function.prototype.toString.call(Object);
      };
      getValue = function(obj) {
        if (isFunction(obj.valueOf)) {
          return obj.valueOf();
        } else {
          return obj;
        }
      };
      module2.exports.assign = assign;
      module2.exports.isFunction = isFunction;
      module2.exports.isObject = isObject;
      module2.exports.isArray = isArray;
      module2.exports.isEmpty = isEmpty;
      module2.exports.isPlainObject = isPlainObject;
      module2.exports.getValue = getValue;
    }).call(exports2);
  }
});

// node_modules/xmlbuilder/lib/XMLDOMImplementation.js
var require_XMLDOMImplementation = __commonJS({
  "node_modules/xmlbuilder/lib/XMLDOMImplementation.js"(exports2, module2) {
    (function() {
      var XMLDOMImplementation;
      module2.exports = XMLDOMImplementation = (function() {
        function XMLDOMImplementation2() {
        }
        XMLDOMImplementation2.prototype.hasFeature = function(feature, version) {
          return true;
        };
        XMLDOMImplementation2.prototype.createDocumentType = function(qualifiedName, publicId, systemId) {
          throw new Error("This DOM method is not implemented.");
        };
        XMLDOMImplementation2.prototype.createDocument = function(namespaceURI, qualifiedName, doctype) {
          throw new Error("This DOM method is not implemented.");
        };
        XMLDOMImplementation2.prototype.createHTMLDocument = function(title) {
          throw new Error("This DOM method is not implemented.");
        };
        XMLDOMImplementation2.prototype.getFeature = function(feature, version) {
          throw new Error("This DOM method is not implemented.");
        };
        return XMLDOMImplementation2;
      })();
    }).call(exports2);
  }
});

// node_modules/xmlbuilder/lib/XMLDOMErrorHandler.js
var require_XMLDOMErrorHandler = __commonJS({
  "node_modules/xmlbuilder/lib/XMLDOMErrorHandler.js"(exports2, module2) {
    (function() {
      var XMLDOMErrorHandler;
      module2.exports = XMLDOMErrorHandler = (function() {
        function XMLDOMErrorHandler2() {
        }
        XMLDOMErrorHandler2.prototype.handleError = function(error) {
          throw new Error(error);
        };
        return XMLDOMErrorHandler2;
      })();
    }).call(exports2);
  }
});

// node_modules/xmlbuilder/lib/XMLDOMStringList.js
var require_XMLDOMStringList = __commonJS({
  "node_modules/xmlbuilder/lib/XMLDOMStringList.js"(exports2, module2) {
    (function() {
      var XMLDOMStringList;
      module2.exports = XMLDOMStringList = (function() {
        function XMLDOMStringList2(arr) {
          this.arr = arr || [];
        }
        Object.defineProperty(XMLDOMStringList2.prototype, "length", {
          get: function() {
            return this.arr.length;
          }
        });
        XMLDOMStringList2.prototype.item = function(index) {
          return this.arr[index] || null;
        };
        XMLDOMStringList2.prototype.contains = function(str) {
          return this.arr.indexOf(str) !== -1;
        };
        return XMLDOMStringList2;
      })();
    }).call(exports2);
  }
});

// node_modules/xmlbuilder/lib/XMLDOMConfiguration.js
var require_XMLDOMConfiguration = __commonJS({
  "node_modules/xmlbuilder/lib/XMLDOMConfiguration.js"(exports2, module2) {
    (function() {
      var XMLDOMConfiguration, XMLDOMErrorHandler, XMLDOMStringList;
      XMLDOMErrorHandler = require_XMLDOMErrorHandler();
      XMLDOMStringList = require_XMLDOMStringList();
      module2.exports = XMLDOMConfiguration = (function() {
        function XMLDOMConfiguration2() {
          var clonedSelf;
          this.defaultParams = {
            "canonical-form": false,
            "cdata-sections": false,
            "comments": false,
            "datatype-normalization": false,
            "element-content-whitespace": true,
            "entities": true,
            "error-handler": new XMLDOMErrorHandler(),
            "infoset": true,
            "validate-if-schema": false,
            "namespaces": true,
            "namespace-declarations": true,
            "normalize-characters": false,
            "schema-location": "",
            "schema-type": "",
            "split-cdata-sections": true,
            "validate": false,
            "well-formed": true
          };
          this.params = clonedSelf = Object.create(this.defaultParams);
        }
        Object.defineProperty(XMLDOMConfiguration2.prototype, "parameterNames", {
          get: function() {
            return new XMLDOMStringList(Object.keys(this.defaultParams));
          }
        });
        XMLDOMConfiguration2.prototype.getParameter = function(name) {
          if (this.params.hasOwnProperty(name)) {
            return this.params[name];
          } else {
            return null;
          }
        };
        XMLDOMConfiguration2.prototype.canSetParameter = function(name, value) {
          return true;
        };
        XMLDOMConfiguration2.prototype.setParameter = function(name, value) {
          if (value != null) {
            return this.params[name] = value;
          } else {
            return delete this.params[name];
          }
        };
        return XMLDOMConfiguration2;
      })();
    }).call(exports2);
  }
});

// node_modules/xmlbuilder/lib/NodeType.js
var require_NodeType = __commonJS({
  "node_modules/xmlbuilder/lib/NodeType.js"(exports2, module2) {
    (function() {
      module2.exports = {
        Element: 1,
        Attribute: 2,
        Text: 3,
        CData: 4,
        EntityReference: 5,
        EntityDeclaration: 6,
        ProcessingInstruction: 7,
        Comment: 8,
        Document: 9,
        DocType: 10,
        DocumentFragment: 11,
        NotationDeclaration: 12,
        Declaration: 201,
        Raw: 202,
        AttributeDeclaration: 203,
        ElementDeclaration: 204,
        Dummy: 205
      };
    }).call(exports2);
  }
});

// node_modules/xmlbuilder/lib/XMLAttribute.js
var require_XMLAttribute = __commonJS({
  "node_modules/xmlbuilder/lib/XMLAttribute.js"(exports2, module2) {
    (function() {
      var NodeType, XMLAttribute, XMLNode;
      NodeType = require_NodeType();
      XMLNode = require_XMLNode();
      module2.exports = XMLAttribute = (function() {
        function XMLAttribute2(parent, name, value) {
          this.parent = parent;
          if (this.parent) {
            this.options = this.parent.options;
            this.stringify = this.parent.stringify;
          }
          if (name == null) {
            throw new Error("Missing attribute name. " + this.debugInfo(name));
          }
          this.name = this.stringify.name(name);
          this.value = this.stringify.attValue(value);
          this.type = NodeType.Attribute;
          this.isId = false;
          this.schemaTypeInfo = null;
        }
        Object.defineProperty(XMLAttribute2.prototype, "nodeType", {
          get: function() {
            return this.type;
          }
        });
        Object.defineProperty(XMLAttribute2.prototype, "ownerElement", {
          get: function() {
            return this.parent;
          }
        });
        Object.defineProperty(XMLAttribute2.prototype, "textContent", {
          get: function() {
            return this.value;
          },
          set: function(value) {
            return this.value = value || "";
          }
        });
        Object.defineProperty(XMLAttribute2.prototype, "namespaceURI", {
          get: function() {
            return "";
          }
        });
        Object.defineProperty(XMLAttribute2.prototype, "prefix", {
          get: function() {
            return "";
          }
        });
        Object.defineProperty(XMLAttribute2.prototype, "localName", {
          get: function() {
            return this.name;
          }
        });
        Object.defineProperty(XMLAttribute2.prototype, "specified", {
          get: function() {
            return true;
          }
        });
        XMLAttribute2.prototype.clone = function() {
          return Object.create(this);
        };
        XMLAttribute2.prototype.toString = function(options) {
          return this.options.writer.attribute(this, this.options.writer.filterOptions(options));
        };
        XMLAttribute2.prototype.debugInfo = function(name) {
          name = name || this.name;
          if (name == null) {
            return "parent: <" + this.parent.name + ">";
          } else {
            return "attribute: {" + name + "}, parent: <" + this.parent.name + ">";
          }
        };
        XMLAttribute2.prototype.isEqualNode = function(node) {
          if (node.namespaceURI !== this.namespaceURI) {
            return false;
          }
          if (node.prefix !== this.prefix) {
            return false;
          }
          if (node.localName !== this.localName) {
            return false;
          }
          if (node.value !== this.value) {
            return false;
          }
          return true;
        };
        return XMLAttribute2;
      })();
    }).call(exports2);
  }
});

// node_modules/xmlbuilder/lib/XMLNamedNodeMap.js
var require_XMLNamedNodeMap = __commonJS({
  "node_modules/xmlbuilder/lib/XMLNamedNodeMap.js"(exports2, module2) {
    (function() {
      var XMLNamedNodeMap;
      module2.exports = XMLNamedNodeMap = (function() {
        function XMLNamedNodeMap2(nodes) {
          this.nodes = nodes;
        }
        Object.defineProperty(XMLNamedNodeMap2.prototype, "length", {
          get: function() {
            return Object.keys(this.nodes).length || 0;
          }
        });
        XMLNamedNodeMap2.prototype.clone = function() {
          return this.nodes = null;
        };
        XMLNamedNodeMap2.prototype.getNamedItem = function(name) {
          return this.nodes[name];
        };
        XMLNamedNodeMap2.prototype.setNamedItem = function(node) {
          var oldNode;
          oldNode = this.nodes[node.nodeName];
          this.nodes[node.nodeName] = node;
          return oldNode || null;
        };
        XMLNamedNodeMap2.prototype.removeNamedItem = function(name) {
          var oldNode;
          oldNode = this.nodes[name];
          delete this.nodes[name];
          return oldNode || null;
        };
        XMLNamedNodeMap2.prototype.item = function(index) {
          return this.nodes[Object.keys(this.nodes)[index]] || null;
        };
        XMLNamedNodeMap2.prototype.getNamedItemNS = function(namespaceURI, localName) {
          throw new Error("This DOM method is not implemented.");
        };
        XMLNamedNodeMap2.prototype.setNamedItemNS = function(node) {
          throw new Error("This DOM method is not implemented.");
        };
        XMLNamedNodeMap2.prototype.removeNamedItemNS = function(namespaceURI, localName) {
          throw new Error("This DOM method is not implemented.");
        };
        return XMLNamedNodeMap2;
      })();
    }).call(exports2);
  }
});

// node_modules/xmlbuilder/lib/XMLElement.js
var require_XMLElement = __commonJS({
  "node_modules/xmlbuilder/lib/XMLElement.js"(exports2, module2) {
    (function() {
      var NodeType, XMLAttribute, XMLElement, XMLNamedNodeMap, XMLNode, getValue, isFunction, isObject, ref, extend = function(child, parent) {
        for (var key in parent) {
          if (hasProp.call(parent, key)) child[key] = parent[key];
        }
        function ctor() {
          this.constructor = child;
        }
        ctor.prototype = parent.prototype;
        child.prototype = new ctor();
        child.__super__ = parent.prototype;
        return child;
      }, hasProp = {}.hasOwnProperty;
      ref = require_Utility(), isObject = ref.isObject, isFunction = ref.isFunction, getValue = ref.getValue;
      XMLNode = require_XMLNode();
      NodeType = require_NodeType();
      XMLAttribute = require_XMLAttribute();
      XMLNamedNodeMap = require_XMLNamedNodeMap();
      module2.exports = XMLElement = (function(superClass) {
        extend(XMLElement2, superClass);
        function XMLElement2(parent, name, attributes) {
          var child, j, len, ref1;
          XMLElement2.__super__.constructor.call(this, parent);
          if (name == null) {
            throw new Error("Missing element name. " + this.debugInfo());
          }
          this.name = this.stringify.name(name);
          this.type = NodeType.Element;
          this.attribs = {};
          this.schemaTypeInfo = null;
          if (attributes != null) {
            this.attribute(attributes);
          }
          if (parent.type === NodeType.Document) {
            this.isRoot = true;
            this.documentObject = parent;
            parent.rootObject = this;
            if (parent.children) {
              ref1 = parent.children;
              for (j = 0, len = ref1.length; j < len; j++) {
                child = ref1[j];
                if (child.type === NodeType.DocType) {
                  child.name = this.name;
                  break;
                }
              }
            }
          }
        }
        Object.defineProperty(XMLElement2.prototype, "tagName", {
          get: function() {
            return this.name;
          }
        });
        Object.defineProperty(XMLElement2.prototype, "namespaceURI", {
          get: function() {
            return "";
          }
        });
        Object.defineProperty(XMLElement2.prototype, "prefix", {
          get: function() {
            return "";
          }
        });
        Object.defineProperty(XMLElement2.prototype, "localName", {
          get: function() {
            return this.name;
          }
        });
        Object.defineProperty(XMLElement2.prototype, "id", {
          get: function() {
            throw new Error("This DOM method is not implemented." + this.debugInfo());
          }
        });
        Object.defineProperty(XMLElement2.prototype, "className", {
          get: function() {
            throw new Error("This DOM method is not implemented." + this.debugInfo());
          }
        });
        Object.defineProperty(XMLElement2.prototype, "classList", {
          get: function() {
            throw new Error("This DOM method is not implemented." + this.debugInfo());
          }
        });
        Object.defineProperty(XMLElement2.prototype, "attributes", {
          get: function() {
            if (!this.attributeMap || !this.attributeMap.nodes) {
              this.attributeMap = new XMLNamedNodeMap(this.attribs);
            }
            return this.attributeMap;
          }
        });
        XMLElement2.prototype.clone = function() {
          var att, attName, clonedSelf, ref1;
          clonedSelf = Object.create(this);
          if (clonedSelf.isRoot) {
            clonedSelf.documentObject = null;
          }
          clonedSelf.attribs = {};
          ref1 = this.attribs;
          for (attName in ref1) {
            if (!hasProp.call(ref1, attName)) continue;
            att = ref1[attName];
            clonedSelf.attribs[attName] = att.clone();
          }
          clonedSelf.children = [];
          this.children.forEach(function(child) {
            var clonedChild;
            clonedChild = child.clone();
            clonedChild.parent = clonedSelf;
            return clonedSelf.children.push(clonedChild);
          });
          return clonedSelf;
        };
        XMLElement2.prototype.attribute = function(name, value) {
          var attName, attValue;
          if (name != null) {
            name = getValue(name);
          }
          if (isObject(name)) {
            for (attName in name) {
              if (!hasProp.call(name, attName)) continue;
              attValue = name[attName];
              this.attribute(attName, attValue);
            }
          } else {
            if (isFunction(value)) {
              value = value.apply();
            }
            if (this.options.keepNullAttributes && value == null) {
              this.attribs[name] = new XMLAttribute(this, name, "");
            } else if (value != null) {
              this.attribs[name] = new XMLAttribute(this, name, value);
            }
          }
          return this;
        };
        XMLElement2.prototype.removeAttribute = function(name) {
          var attName, j, len;
          if (name == null) {
            throw new Error("Missing attribute name. " + this.debugInfo());
          }
          name = getValue(name);
          if (Array.isArray(name)) {
            for (j = 0, len = name.length; j < len; j++) {
              attName = name[j];
              delete this.attribs[attName];
            }
          } else {
            delete this.attribs[name];
          }
          return this;
        };
        XMLElement2.prototype.toString = function(options) {
          return this.options.writer.element(this, this.options.writer.filterOptions(options));
        };
        XMLElement2.prototype.att = function(name, value) {
          return this.attribute(name, value);
        };
        XMLElement2.prototype.a = function(name, value) {
          return this.attribute(name, value);
        };
        XMLElement2.prototype.getAttribute = function(name) {
          if (this.attribs.hasOwnProperty(name)) {
            return this.attribs[name].value;
          } else {
            return null;
          }
        };
        XMLElement2.prototype.setAttribute = function(name, value) {
          throw new Error("This DOM method is not implemented." + this.debugInfo());
        };
        XMLElement2.prototype.getAttributeNode = function(name) {
          if (this.attribs.hasOwnProperty(name)) {
            return this.attribs[name];
          } else {
            return null;
          }
        };
        XMLElement2.prototype.setAttributeNode = function(newAttr) {
          throw new Error("This DOM method is not implemented." + this.debugInfo());
        };
        XMLElement2.prototype.removeAttributeNode = function(oldAttr) {
          throw new Error("This DOM method is not implemented." + this.debugInfo());
        };
        XMLElement2.prototype.getElementsByTagName = function(name) {
          throw new Error("This DOM method is not implemented." + this.debugInfo());
        };
        XMLElement2.prototype.getAttributeNS = function(namespaceURI, localName) {
          throw new Error("This DOM method is not implemented." + this.debugInfo());
        };
        XMLElement2.prototype.setAttributeNS = function(namespaceURI, qualifiedName, value) {
          throw new Error("This DOM method is not implemented." + this.debugInfo());
        };
        XMLElement2.prototype.removeAttributeNS = function(namespaceURI, localName) {
          throw new Error("This DOM method is not implemented." + this.debugInfo());
        };
        XMLElement2.prototype.getAttributeNodeNS = function(namespaceURI, localName) {
          throw new Error("This DOM method is not implemented." + this.debugInfo());
        };
        XMLElement2.prototype.setAttributeNodeNS = function(newAttr) {
          throw new Error("This DOM method is not implemented." + this.debugInfo());
        };
        XMLElement2.prototype.getElementsByTagNameNS = function(namespaceURI, localName) {
          throw new Error("This DOM method is not implemented." + this.debugInfo());
        };
        XMLElement2.prototype.hasAttribute = function(name) {
          return this.attribs.hasOwnProperty(name);
        };
        XMLElement2.prototype.hasAttributeNS = function(namespaceURI, localName) {
          throw new Error("This DOM method is not implemented." + this.debugInfo());
        };
        XMLElement2.prototype.setIdAttribute = function(name, isId) {
          if (this.attribs.hasOwnProperty(name)) {
            return this.attribs[name].isId;
          } else {
            return isId;
          }
        };
        XMLElement2.prototype.setIdAttributeNS = function(namespaceURI, localName, isId) {
          throw new Error("This DOM method is not implemented." + this.debugInfo());
        };
        XMLElement2.prototype.setIdAttributeNode = function(idAttr, isId) {
          throw new Error("This DOM method is not implemented." + this.debugInfo());
        };
        XMLElement2.prototype.getElementsByTagName = function(tagname) {
          throw new Error("This DOM method is not implemented." + this.debugInfo());
        };
        XMLElement2.prototype.getElementsByTagNameNS = function(namespaceURI, localName) {
          throw new Error("This DOM method is not implemented." + this.debugInfo());
        };
        XMLElement2.prototype.getElementsByClassName = function(classNames) {
          throw new Error("This DOM method is not implemented." + this.debugInfo());
        };
        XMLElement2.prototype.isEqualNode = function(node) {
          var i, j, ref1;
          if (!XMLElement2.__super__.isEqualNode.apply(this, arguments).isEqualNode(node)) {
            return false;
          }
          if (node.namespaceURI !== this.namespaceURI) {
            return false;
          }
          if (node.prefix !== this.prefix) {
            return false;
          }
          if (node.localName !== this.localName) {
            return false;
          }
          if (node.attribs.length !== this.attribs.length) {
            return false;
          }
          for (i = j = 0, ref1 = this.attribs.length - 1; 0 <= ref1 ? j <= ref1 : j >= ref1; i = 0 <= ref1 ? ++j : --j) {
            if (!this.attribs[i].isEqualNode(node.attribs[i])) {
              return false;
            }
          }
          return true;
        };
        return XMLElement2;
      })(XMLNode);
    }).call(exports2);
  }
});

// node_modules/xmlbuilder/lib/XMLCharacterData.js
var require_XMLCharacterData = __commonJS({
  "node_modules/xmlbuilder/lib/XMLCharacterData.js"(exports2, module2) {
    (function() {
      var XMLCharacterData, XMLNode, extend = function(child, parent) {
        for (var key in parent) {
          if (hasProp.call(parent, key)) child[key] = parent[key];
        }
        function ctor() {
          this.constructor = child;
        }
        ctor.prototype = parent.prototype;
        child.prototype = new ctor();
        child.__super__ = parent.prototype;
        return child;
      }, hasProp = {}.hasOwnProperty;
      XMLNode = require_XMLNode();
      module2.exports = XMLCharacterData = (function(superClass) {
        extend(XMLCharacterData2, superClass);
        function XMLCharacterData2(parent) {
          XMLCharacterData2.__super__.constructor.call(this, parent);
          this.value = "";
        }
        Object.defineProperty(XMLCharacterData2.prototype, "data", {
          get: function() {
            return this.value;
          },
          set: function(value) {
            return this.value = value || "";
          }
        });
        Object.defineProperty(XMLCharacterData2.prototype, "length", {
          get: function() {
            return this.value.length;
          }
        });
        Object.defineProperty(XMLCharacterData2.prototype, "textContent", {
          get: function() {
            return this.value;
          },
          set: function(value) {
            return this.value = value || "";
          }
        });
        XMLCharacterData2.prototype.clone = function() {
          return Object.create(this);
        };
        XMLCharacterData2.prototype.substringData = function(offset, count) {
          throw new Error("This DOM method is not implemented." + this.debugInfo());
        };
        XMLCharacterData2.prototype.appendData = function(arg) {
          throw new Error("This DOM method is not implemented." + this.debugInfo());
        };
        XMLCharacterData2.prototype.insertData = function(offset, arg) {
          throw new Error("This DOM method is not implemented." + this.debugInfo());
        };
        XMLCharacterData2.prototype.deleteData = function(offset, count) {
          throw new Error("This DOM method is not implemented." + this.debugInfo());
        };
        XMLCharacterData2.prototype.replaceData = function(offset, count, arg) {
          throw new Error("This DOM method is not implemented." + this.debugInfo());
        };
        XMLCharacterData2.prototype.isEqualNode = function(node) {
          if (!XMLCharacterData2.__super__.isEqualNode.apply(this, arguments).isEqualNode(node)) {
            return false;
          }
          if (node.data !== this.data) {
            return false;
          }
          return true;
        };
        return XMLCharacterData2;
      })(XMLNode);
    }).call(exports2);
  }
});

// node_modules/xmlbuilder/lib/XMLCData.js
var require_XMLCData = __commonJS({
  "node_modules/xmlbuilder/lib/XMLCData.js"(exports2, module2) {
    (function() {
      var NodeType, XMLCData, XMLCharacterData, extend = function(child, parent) {
        for (var key in parent) {
          if (hasProp.call(parent, key)) child[key] = parent[key];
        }
        function ctor() {
          this.constructor = child;
        }
        ctor.prototype = parent.prototype;
        child.prototype = new ctor();
        child.__super__ = parent.prototype;
        return child;
      }, hasProp = {}.hasOwnProperty;
      NodeType = require_NodeType();
      XMLCharacterData = require_XMLCharacterData();
      module2.exports = XMLCData = (function(superClass) {
        extend(XMLCData2, superClass);
        function XMLCData2(parent, text) {
          XMLCData2.__super__.constructor.call(this, parent);
          if (text == null) {
            throw new Error("Missing CDATA text. " + this.debugInfo());
          }
          this.name = "#cdata-section";
          this.type = NodeType.CData;
          this.value = this.stringify.cdata(text);
        }
        XMLCData2.prototype.clone = function() {
          return Object.create(this);
        };
        XMLCData2.prototype.toString = function(options) {
          return this.options.writer.cdata(this, this.options.writer.filterOptions(options));
        };
        return XMLCData2;
      })(XMLCharacterData);
    }).call(exports2);
  }
});

// node_modules/xmlbuilder/lib/XMLComment.js
var require_XMLComment = __commonJS({
  "node_modules/xmlbuilder/lib/XMLComment.js"(exports2, module2) {
    (function() {
      var NodeType, XMLCharacterData, XMLComment, extend = function(child, parent) {
        for (var key in parent) {
          if (hasProp.call(parent, key)) child[key] = parent[key];
        }
        function ctor() {
          this.constructor = child;
        }
        ctor.prototype = parent.prototype;
        child.prototype = new ctor();
        child.__super__ = parent.prototype;
        return child;
      }, hasProp = {}.hasOwnProperty;
      NodeType = require_NodeType();
      XMLCharacterData = require_XMLCharacterData();
      module2.exports = XMLComment = (function(superClass) {
        extend(XMLComment2, superClass);
        function XMLComment2(parent, text) {
          XMLComment2.__super__.constructor.call(this, parent);
          if (text == null) {
            throw new Error("Missing comment text. " + this.debugInfo());
          }
          this.name = "#comment";
          this.type = NodeType.Comment;
          this.value = this.stringify.comment(text);
        }
        XMLComment2.prototype.clone = function() {
          return Object.create(this);
        };
        XMLComment2.prototype.toString = function(options) {
          return this.options.writer.comment(this, this.options.writer.filterOptions(options));
        };
        return XMLComment2;
      })(XMLCharacterData);
    }).call(exports2);
  }
});

// node_modules/xmlbuilder/lib/XMLDeclaration.js
var require_XMLDeclaration = __commonJS({
  "node_modules/xmlbuilder/lib/XMLDeclaration.js"(exports2, module2) {
    (function() {
      var NodeType, XMLDeclaration, XMLNode, isObject, extend = function(child, parent) {
        for (var key in parent) {
          if (hasProp.call(parent, key)) child[key] = parent[key];
        }
        function ctor() {
          this.constructor = child;
        }
        ctor.prototype = parent.prototype;
        child.prototype = new ctor();
        child.__super__ = parent.prototype;
        return child;
      }, hasProp = {}.hasOwnProperty;
      isObject = require_Utility().isObject;
      XMLNode = require_XMLNode();
      NodeType = require_NodeType();
      module2.exports = XMLDeclaration = (function(superClass) {
        extend(XMLDeclaration2, superClass);
        function XMLDeclaration2(parent, version, encoding, standalone) {
          var ref;
          XMLDeclaration2.__super__.constructor.call(this, parent);
          if (isObject(version)) {
            ref = version, version = ref.version, encoding = ref.encoding, standalone = ref.standalone;
          }
          if (!version) {
            version = "1.0";
          }
          this.type = NodeType.Declaration;
          this.version = this.stringify.xmlVersion(version);
          if (encoding != null) {
            this.encoding = this.stringify.xmlEncoding(encoding);
          }
          if (standalone != null) {
            this.standalone = this.stringify.xmlStandalone(standalone);
          }
        }
        XMLDeclaration2.prototype.toString = function(options) {
          return this.options.writer.declaration(this, this.options.writer.filterOptions(options));
        };
        return XMLDeclaration2;
      })(XMLNode);
    }).call(exports2);
  }
});

// node_modules/xmlbuilder/lib/XMLDTDAttList.js
var require_XMLDTDAttList = __commonJS({
  "node_modules/xmlbuilder/lib/XMLDTDAttList.js"(exports2, module2) {
    (function() {
      var NodeType, XMLDTDAttList, XMLNode, extend = function(child, parent) {
        for (var key in parent) {
          if (hasProp.call(parent, key)) child[key] = parent[key];
        }
        function ctor() {
          this.constructor = child;
        }
        ctor.prototype = parent.prototype;
        child.prototype = new ctor();
        child.__super__ = parent.prototype;
        return child;
      }, hasProp = {}.hasOwnProperty;
      XMLNode = require_XMLNode();
      NodeType = require_NodeType();
      module2.exports = XMLDTDAttList = (function(superClass) {
        extend(XMLDTDAttList2, superClass);
        function XMLDTDAttList2(parent, elementName, attributeName, attributeType, defaultValueType, defaultValue) {
          XMLDTDAttList2.__super__.constructor.call(this, parent);
          if (elementName == null) {
            throw new Error("Missing DTD element name. " + this.debugInfo());
          }
          if (attributeName == null) {
            throw new Error("Missing DTD attribute name. " + this.debugInfo(elementName));
          }
          if (!attributeType) {
            throw new Error("Missing DTD attribute type. " + this.debugInfo(elementName));
          }
          if (!defaultValueType) {
            throw new Error("Missing DTD attribute default. " + this.debugInfo(elementName));
          }
          if (defaultValueType.indexOf("#") !== 0) {
            defaultValueType = "#" + defaultValueType;
          }
          if (!defaultValueType.match(/^(#REQUIRED|#IMPLIED|#FIXED|#DEFAULT)$/)) {
            throw new Error("Invalid default value type; expected: #REQUIRED, #IMPLIED, #FIXED or #DEFAULT. " + this.debugInfo(elementName));
          }
          if (defaultValue && !defaultValueType.match(/^(#FIXED|#DEFAULT)$/)) {
            throw new Error("Default value only applies to #FIXED or #DEFAULT. " + this.debugInfo(elementName));
          }
          this.elementName = this.stringify.name(elementName);
          this.type = NodeType.AttributeDeclaration;
          this.attributeName = this.stringify.name(attributeName);
          this.attributeType = this.stringify.dtdAttType(attributeType);
          if (defaultValue) {
            this.defaultValue = this.stringify.dtdAttDefault(defaultValue);
          }
          this.defaultValueType = defaultValueType;
        }
        XMLDTDAttList2.prototype.toString = function(options) {
          return this.options.writer.dtdAttList(this, this.options.writer.filterOptions(options));
        };
        return XMLDTDAttList2;
      })(XMLNode);
    }).call(exports2);
  }
});

// node_modules/xmlbuilder/lib/XMLDTDEntity.js
var require_XMLDTDEntity = __commonJS({
  "node_modules/xmlbuilder/lib/XMLDTDEntity.js"(exports2, module2) {
    (function() {
      var NodeType, XMLDTDEntity, XMLNode, isObject, extend = function(child, parent) {
        for (var key in parent) {
          if (hasProp.call(parent, key)) child[key] = parent[key];
        }
        function ctor() {
          this.constructor = child;
        }
        ctor.prototype = parent.prototype;
        child.prototype = new ctor();
        child.__super__ = parent.prototype;
        return child;
      }, hasProp = {}.hasOwnProperty;
      isObject = require_Utility().isObject;
      XMLNode = require_XMLNode();
      NodeType = require_NodeType();
      module2.exports = XMLDTDEntity = (function(superClass) {
        extend(XMLDTDEntity2, superClass);
        function XMLDTDEntity2(parent, pe, name, value) {
          XMLDTDEntity2.__super__.constructor.call(this, parent);
          if (name == null) {
            throw new Error("Missing DTD entity name. " + this.debugInfo(name));
          }
          if (value == null) {
            throw new Error("Missing DTD entity value. " + this.debugInfo(name));
          }
          this.pe = !!pe;
          this.name = this.stringify.name(name);
          this.type = NodeType.EntityDeclaration;
          if (!isObject(value)) {
            this.value = this.stringify.dtdEntityValue(value);
            this.internal = true;
          } else {
            if (!value.pubID && !value.sysID) {
              throw new Error("Public and/or system identifiers are required for an external entity. " + this.debugInfo(name));
            }
            if (value.pubID && !value.sysID) {
              throw new Error("System identifier is required for a public external entity. " + this.debugInfo(name));
            }
            this.internal = false;
            if (value.pubID != null) {
              this.pubID = this.stringify.dtdPubID(value.pubID);
            }
            if (value.sysID != null) {
              this.sysID = this.stringify.dtdSysID(value.sysID);
            }
            if (value.nData != null) {
              this.nData = this.stringify.dtdNData(value.nData);
            }
            if (this.pe && this.nData) {
              throw new Error("Notation declaration is not allowed in a parameter entity. " + this.debugInfo(name));
            }
          }
        }
        Object.defineProperty(XMLDTDEntity2.prototype, "publicId", {
          get: function() {
            return this.pubID;
          }
        });
        Object.defineProperty(XMLDTDEntity2.prototype, "systemId", {
          get: function() {
            return this.sysID;
          }
        });
        Object.defineProperty(XMLDTDEntity2.prototype, "notationName", {
          get: function() {
            return this.nData || null;
          }
        });
        Object.defineProperty(XMLDTDEntity2.prototype, "inputEncoding", {
          get: function() {
            return null;
          }
        });
        Object.defineProperty(XMLDTDEntity2.prototype, "xmlEncoding", {
          get: function() {
            return null;
          }
        });
        Object.defineProperty(XMLDTDEntity2.prototype, "xmlVersion", {
          get: function() {
            return null;
          }
        });
        XMLDTDEntity2.prototype.toString = function(options) {
          return this.options.writer.dtdEntity(this, this.options.writer.filterOptions(options));
        };
        return XMLDTDEntity2;
      })(XMLNode);
    }).call(exports2);
  }
});

// node_modules/xmlbuilder/lib/XMLDTDElement.js
var require_XMLDTDElement = __commonJS({
  "node_modules/xmlbuilder/lib/XMLDTDElement.js"(exports2, module2) {
    (function() {
      var NodeType, XMLDTDElement, XMLNode, extend = function(child, parent) {
        for (var key in parent) {
          if (hasProp.call(parent, key)) child[key] = parent[key];
        }
        function ctor() {
          this.constructor = child;
        }
        ctor.prototype = parent.prototype;
        child.prototype = new ctor();
        child.__super__ = parent.prototype;
        return child;
      }, hasProp = {}.hasOwnProperty;
      XMLNode = require_XMLNode();
      NodeType = require_NodeType();
      module2.exports = XMLDTDElement = (function(superClass) {
        extend(XMLDTDElement2, superClass);
        function XMLDTDElement2(parent, name, value) {
          XMLDTDElement2.__super__.constructor.call(this, parent);
          if (name == null) {
            throw new Error("Missing DTD element name. " + this.debugInfo());
          }
          if (!value) {
            value = "(#PCDATA)";
          }
          if (Array.isArray(value)) {
            value = "(" + value.join(",") + ")";
          }
          this.name = this.stringify.name(name);
          this.type = NodeType.ElementDeclaration;
          this.value = this.stringify.dtdElementValue(value);
        }
        XMLDTDElement2.prototype.toString = function(options) {
          return this.options.writer.dtdElement(this, this.options.writer.filterOptions(options));
        };
        return XMLDTDElement2;
      })(XMLNode);
    }).call(exports2);
  }
});

// node_modules/xmlbuilder/lib/XMLDTDNotation.js
var require_XMLDTDNotation = __commonJS({
  "node_modules/xmlbuilder/lib/XMLDTDNotation.js"(exports2, module2) {
    (function() {
      var NodeType, XMLDTDNotation, XMLNode, extend = function(child, parent) {
        for (var key in parent) {
          if (hasProp.call(parent, key)) child[key] = parent[key];
        }
        function ctor() {
          this.constructor = child;
        }
        ctor.prototype = parent.prototype;
        child.prototype = new ctor();
        child.__super__ = parent.prototype;
        return child;
      }, hasProp = {}.hasOwnProperty;
      XMLNode = require_XMLNode();
      NodeType = require_NodeType();
      module2.exports = XMLDTDNotation = (function(superClass) {
        extend(XMLDTDNotation2, superClass);
        function XMLDTDNotation2(parent, name, value) {
          XMLDTDNotation2.__super__.constructor.call(this, parent);
          if (name == null) {
            throw new Error("Missing DTD notation name. " + this.debugInfo(name));
          }
          if (!value.pubID && !value.sysID) {
            throw new Error("Public or system identifiers are required for an external entity. " + this.debugInfo(name));
          }
          this.name = this.stringify.name(name);
          this.type = NodeType.NotationDeclaration;
          if (value.pubID != null) {
            this.pubID = this.stringify.dtdPubID(value.pubID);
          }
          if (value.sysID != null) {
            this.sysID = this.stringify.dtdSysID(value.sysID);
          }
        }
        Object.defineProperty(XMLDTDNotation2.prototype, "publicId", {
          get: function() {
            return this.pubID;
          }
        });
        Object.defineProperty(XMLDTDNotation2.prototype, "systemId", {
          get: function() {
            return this.sysID;
          }
        });
        XMLDTDNotation2.prototype.toString = function(options) {
          return this.options.writer.dtdNotation(this, this.options.writer.filterOptions(options));
        };
        return XMLDTDNotation2;
      })(XMLNode);
    }).call(exports2);
  }
});

// node_modules/xmlbuilder/lib/XMLDocType.js
var require_XMLDocType = __commonJS({
  "node_modules/xmlbuilder/lib/XMLDocType.js"(exports2, module2) {
    (function() {
      var NodeType, XMLDTDAttList, XMLDTDElement, XMLDTDEntity, XMLDTDNotation, XMLDocType, XMLNamedNodeMap, XMLNode, isObject, extend = function(child, parent) {
        for (var key in parent) {
          if (hasProp.call(parent, key)) child[key] = parent[key];
        }
        function ctor() {
          this.constructor = child;
        }
        ctor.prototype = parent.prototype;
        child.prototype = new ctor();
        child.__super__ = parent.prototype;
        return child;
      }, hasProp = {}.hasOwnProperty;
      isObject = require_Utility().isObject;
      XMLNode = require_XMLNode();
      NodeType = require_NodeType();
      XMLDTDAttList = require_XMLDTDAttList();
      XMLDTDEntity = require_XMLDTDEntity();
      XMLDTDElement = require_XMLDTDElement();
      XMLDTDNotation = require_XMLDTDNotation();
      XMLNamedNodeMap = require_XMLNamedNodeMap();
      module2.exports = XMLDocType = (function(superClass) {
        extend(XMLDocType2, superClass);
        function XMLDocType2(parent, pubID, sysID) {
          var child, i, len, ref, ref1, ref2;
          XMLDocType2.__super__.constructor.call(this, parent);
          this.type = NodeType.DocType;
          if (parent.children) {
            ref = parent.children;
            for (i = 0, len = ref.length; i < len; i++) {
              child = ref[i];
              if (child.type === NodeType.Element) {
                this.name = child.name;
                break;
              }
            }
          }
          this.documentObject = parent;
          if (isObject(pubID)) {
            ref1 = pubID, pubID = ref1.pubID, sysID = ref1.sysID;
          }
          if (sysID == null) {
            ref2 = [pubID, sysID], sysID = ref2[0], pubID = ref2[1];
          }
          if (pubID != null) {
            this.pubID = this.stringify.dtdPubID(pubID);
          }
          if (sysID != null) {
            this.sysID = this.stringify.dtdSysID(sysID);
          }
        }
        Object.defineProperty(XMLDocType2.prototype, "entities", {
          get: function() {
            var child, i, len, nodes, ref;
            nodes = {};
            ref = this.children;
            for (i = 0, len = ref.length; i < len; i++) {
              child = ref[i];
              if (child.type === NodeType.EntityDeclaration && !child.pe) {
                nodes[child.name] = child;
              }
            }
            return new XMLNamedNodeMap(nodes);
          }
        });
        Object.defineProperty(XMLDocType2.prototype, "notations", {
          get: function() {
            var child, i, len, nodes, ref;
            nodes = {};
            ref = this.children;
            for (i = 0, len = ref.length; i < len; i++) {
              child = ref[i];
              if (child.type === NodeType.NotationDeclaration) {
                nodes[child.name] = child;
              }
            }
            return new XMLNamedNodeMap(nodes);
          }
        });
        Object.defineProperty(XMLDocType2.prototype, "publicId", {
          get: function() {
            return this.pubID;
          }
        });
        Object.defineProperty(XMLDocType2.prototype, "systemId", {
          get: function() {
            return this.sysID;
          }
        });
        Object.defineProperty(XMLDocType2.prototype, "internalSubset", {
          get: function() {
            throw new Error("This DOM method is not implemented." + this.debugInfo());
          }
        });
        XMLDocType2.prototype.element = function(name, value) {
          var child;
          child = new XMLDTDElement(this, name, value);
          this.children.push(child);
          return this;
        };
        XMLDocType2.prototype.attList = function(elementName, attributeName, attributeType, defaultValueType, defaultValue) {
          var child;
          child = new XMLDTDAttList(this, elementName, attributeName, attributeType, defaultValueType, defaultValue);
          this.children.push(child);
          return this;
        };
        XMLDocType2.prototype.entity = function(name, value) {
          var child;
          child = new XMLDTDEntity(this, false, name, value);
          this.children.push(child);
          return this;
        };
        XMLDocType2.prototype.pEntity = function(name, value) {
          var child;
          child = new XMLDTDEntity(this, true, name, value);
          this.children.push(child);
          return this;
        };
        XMLDocType2.prototype.notation = function(name, value) {
          var child;
          child = new XMLDTDNotation(this, name, value);
          this.children.push(child);
          return this;
        };
        XMLDocType2.prototype.toString = function(options) {
          return this.options.writer.docType(this, this.options.writer.filterOptions(options));
        };
        XMLDocType2.prototype.ele = function(name, value) {
          return this.element(name, value);
        };
        XMLDocType2.prototype.att = function(elementName, attributeName, attributeType, defaultValueType, defaultValue) {
          return this.attList(elementName, attributeName, attributeType, defaultValueType, defaultValue);
        };
        XMLDocType2.prototype.ent = function(name, value) {
          return this.entity(name, value);
        };
        XMLDocType2.prototype.pent = function(name, value) {
          return this.pEntity(name, value);
        };
        XMLDocType2.prototype.not = function(name, value) {
          return this.notation(name, value);
        };
        XMLDocType2.prototype.up = function() {
          return this.root() || this.documentObject;
        };
        XMLDocType2.prototype.isEqualNode = function(node) {
          if (!XMLDocType2.__super__.isEqualNode.apply(this, arguments).isEqualNode(node)) {
            return false;
          }
          if (node.name !== this.name) {
            return false;
          }
          if (node.publicId !== this.publicId) {
            return false;
          }
          if (node.systemId !== this.systemId) {
            return false;
          }
          return true;
        };
        return XMLDocType2;
      })(XMLNode);
    }).call(exports2);
  }
});

// node_modules/xmlbuilder/lib/XMLRaw.js
var require_XMLRaw = __commonJS({
  "node_modules/xmlbuilder/lib/XMLRaw.js"(exports2, module2) {
    (function() {
      var NodeType, XMLNode, XMLRaw, extend = function(child, parent) {
        for (var key in parent) {
          if (hasProp.call(parent, key)) child[key] = parent[key];
        }
        function ctor() {
          this.constructor = child;
        }
        ctor.prototype = parent.prototype;
        child.prototype = new ctor();
        child.__super__ = parent.prototype;
        return child;
      }, hasProp = {}.hasOwnProperty;
      NodeType = require_NodeType();
      XMLNode = require_XMLNode();
      module2.exports = XMLRaw = (function(superClass) {
        extend(XMLRaw2, superClass);
        function XMLRaw2(parent, text) {
          XMLRaw2.__super__.constructor.call(this, parent);
          if (text == null) {
            throw new Error("Missing raw text. " + this.debugInfo());
          }
          this.type = NodeType.Raw;
          this.value = this.stringify.raw(text);
        }
        XMLRaw2.prototype.clone = function() {
          return Object.create(this);
        };
        XMLRaw2.prototype.toString = function(options) {
          return this.options.writer.raw(this, this.options.writer.filterOptions(options));
        };
        return XMLRaw2;
      })(XMLNode);
    }).call(exports2);
  }
});

// node_modules/xmlbuilder/lib/XMLText.js
var require_XMLText = __commonJS({
  "node_modules/xmlbuilder/lib/XMLText.js"(exports2, module2) {
    (function() {
      var NodeType, XMLCharacterData, XMLText, extend = function(child, parent) {
        for (var key in parent) {
          if (hasProp.call(parent, key)) child[key] = parent[key];
        }
        function ctor() {
          this.constructor = child;
        }
        ctor.prototype = parent.prototype;
        child.prototype = new ctor();
        child.__super__ = parent.prototype;
        return child;
      }, hasProp = {}.hasOwnProperty;
      NodeType = require_NodeType();
      XMLCharacterData = require_XMLCharacterData();
      module2.exports = XMLText = (function(superClass) {
        extend(XMLText2, superClass);
        function XMLText2(parent, text) {
          XMLText2.__super__.constructor.call(this, parent);
          if (text == null) {
            throw new Error("Missing element text. " + this.debugInfo());
          }
          this.name = "#text";
          this.type = NodeType.Text;
          this.value = this.stringify.text(text);
        }
        Object.defineProperty(XMLText2.prototype, "isElementContentWhitespace", {
          get: function() {
            throw new Error("This DOM method is not implemented." + this.debugInfo());
          }
        });
        Object.defineProperty(XMLText2.prototype, "wholeText", {
          get: function() {
            var next, prev, str;
            str = "";
            prev = this.previousSibling;
            while (prev) {
              str = prev.data + str;
              prev = prev.previousSibling;
            }
            str += this.data;
            next = this.nextSibling;
            while (next) {
              str = str + next.data;
              next = next.nextSibling;
            }
            return str;
          }
        });
        XMLText2.prototype.clone = function() {
          return Object.create(this);
        };
        XMLText2.prototype.toString = function(options) {
          return this.options.writer.text(this, this.options.writer.filterOptions(options));
        };
        XMLText2.prototype.splitText = function(offset) {
          throw new Error("This DOM method is not implemented." + this.debugInfo());
        };
        XMLText2.prototype.replaceWholeText = function(content) {
          throw new Error("This DOM method is not implemented." + this.debugInfo());
        };
        return XMLText2;
      })(XMLCharacterData);
    }).call(exports2);
  }
});

// node_modules/xmlbuilder/lib/XMLProcessingInstruction.js
var require_XMLProcessingInstruction = __commonJS({
  "node_modules/xmlbuilder/lib/XMLProcessingInstruction.js"(exports2, module2) {
    (function() {
      var NodeType, XMLCharacterData, XMLProcessingInstruction, extend = function(child, parent) {
        for (var key in parent) {
          if (hasProp.call(parent, key)) child[key] = parent[key];
        }
        function ctor() {
          this.constructor = child;
        }
        ctor.prototype = parent.prototype;
        child.prototype = new ctor();
        child.__super__ = parent.prototype;
        return child;
      }, hasProp = {}.hasOwnProperty;
      NodeType = require_NodeType();
      XMLCharacterData = require_XMLCharacterData();
      module2.exports = XMLProcessingInstruction = (function(superClass) {
        extend(XMLProcessingInstruction2, superClass);
        function XMLProcessingInstruction2(parent, target, value) {
          XMLProcessingInstruction2.__super__.constructor.call(this, parent);
          if (target == null) {
            throw new Error("Missing instruction target. " + this.debugInfo());
          }
          this.type = NodeType.ProcessingInstruction;
          this.target = this.stringify.insTarget(target);
          this.name = this.target;
          if (value) {
            this.value = this.stringify.insValue(value);
          }
        }
        XMLProcessingInstruction2.prototype.clone = function() {
          return Object.create(this);
        };
        XMLProcessingInstruction2.prototype.toString = function(options) {
          return this.options.writer.processingInstruction(this, this.options.writer.filterOptions(options));
        };
        XMLProcessingInstruction2.prototype.isEqualNode = function(node) {
          if (!XMLProcessingInstruction2.__super__.isEqualNode.apply(this, arguments).isEqualNode(node)) {
            return false;
          }
          if (node.target !== this.target) {
            return false;
          }
          return true;
        };
        return XMLProcessingInstruction2;
      })(XMLCharacterData);
    }).call(exports2);
  }
});

// node_modules/xmlbuilder/lib/XMLDummy.js
var require_XMLDummy = __commonJS({
  "node_modules/xmlbuilder/lib/XMLDummy.js"(exports2, module2) {
    (function() {
      var NodeType, XMLDummy, XMLNode, extend = function(child, parent) {
        for (var key in parent) {
          if (hasProp.call(parent, key)) child[key] = parent[key];
        }
        function ctor() {
          this.constructor = child;
        }
        ctor.prototype = parent.prototype;
        child.prototype = new ctor();
        child.__super__ = parent.prototype;
        return child;
      }, hasProp = {}.hasOwnProperty;
      XMLNode = require_XMLNode();
      NodeType = require_NodeType();
      module2.exports = XMLDummy = (function(superClass) {
        extend(XMLDummy2, superClass);
        function XMLDummy2(parent) {
          XMLDummy2.__super__.constructor.call(this, parent);
          this.type = NodeType.Dummy;
        }
        XMLDummy2.prototype.clone = function() {
          return Object.create(this);
        };
        XMLDummy2.prototype.toString = function(options) {
          return "";
        };
        return XMLDummy2;
      })(XMLNode);
    }).call(exports2);
  }
});

// node_modules/xmlbuilder/lib/XMLNodeList.js
var require_XMLNodeList = __commonJS({
  "node_modules/xmlbuilder/lib/XMLNodeList.js"(exports2, module2) {
    (function() {
      var XMLNodeList;
      module2.exports = XMLNodeList = (function() {
        function XMLNodeList2(nodes) {
          this.nodes = nodes;
        }
        Object.defineProperty(XMLNodeList2.prototype, "length", {
          get: function() {
            return this.nodes.length || 0;
          }
        });
        XMLNodeList2.prototype.clone = function() {
          return this.nodes = null;
        };
        XMLNodeList2.prototype.item = function(index) {
          return this.nodes[index] || null;
        };
        return XMLNodeList2;
      })();
    }).call(exports2);
  }
});

// node_modules/xmlbuilder/lib/DocumentPosition.js
var require_DocumentPosition = __commonJS({
  "node_modules/xmlbuilder/lib/DocumentPosition.js"(exports2, module2) {
    (function() {
      module2.exports = {
        Disconnected: 1,
        Preceding: 2,
        Following: 4,
        Contains: 8,
        ContainedBy: 16,
        ImplementationSpecific: 32
      };
    }).call(exports2);
  }
});

// node_modules/xmlbuilder/lib/XMLNode.js
var require_XMLNode = __commonJS({
  "node_modules/xmlbuilder/lib/XMLNode.js"(exports2, module2) {
    (function() {
      var DocumentPosition, NodeType, XMLCData, XMLComment, XMLDeclaration, XMLDocType, XMLDummy, XMLElement, XMLNamedNodeMap, XMLNode, XMLNodeList, XMLProcessingInstruction, XMLRaw, XMLText, getValue, isEmpty, isFunction, isObject, ref1, hasProp = {}.hasOwnProperty;
      ref1 = require_Utility(), isObject = ref1.isObject, isFunction = ref1.isFunction, isEmpty = ref1.isEmpty, getValue = ref1.getValue;
      XMLElement = null;
      XMLCData = null;
      XMLComment = null;
      XMLDeclaration = null;
      XMLDocType = null;
      XMLRaw = null;
      XMLText = null;
      XMLProcessingInstruction = null;
      XMLDummy = null;
      NodeType = null;
      XMLNodeList = null;
      XMLNamedNodeMap = null;
      DocumentPosition = null;
      module2.exports = XMLNode = (function() {
        function XMLNode2(parent1) {
          this.parent = parent1;
          if (this.parent) {
            this.options = this.parent.options;
            this.stringify = this.parent.stringify;
          }
          this.value = null;
          this.children = [];
          this.baseURI = null;
          if (!XMLElement) {
            XMLElement = require_XMLElement();
            XMLCData = require_XMLCData();
            XMLComment = require_XMLComment();
            XMLDeclaration = require_XMLDeclaration();
            XMLDocType = require_XMLDocType();
            XMLRaw = require_XMLRaw();
            XMLText = require_XMLText();
            XMLProcessingInstruction = require_XMLProcessingInstruction();
            XMLDummy = require_XMLDummy();
            NodeType = require_NodeType();
            XMLNodeList = require_XMLNodeList();
            XMLNamedNodeMap = require_XMLNamedNodeMap();
            DocumentPosition = require_DocumentPosition();
          }
        }
        Object.defineProperty(XMLNode2.prototype, "nodeName", {
          get: function() {
            return this.name;
          }
        });
        Object.defineProperty(XMLNode2.prototype, "nodeType", {
          get: function() {
            return this.type;
          }
        });
        Object.defineProperty(XMLNode2.prototype, "nodeValue", {
          get: function() {
            return this.value;
          }
        });
        Object.defineProperty(XMLNode2.prototype, "parentNode", {
          get: function() {
            return this.parent;
          }
        });
        Object.defineProperty(XMLNode2.prototype, "childNodes", {
          get: function() {
            if (!this.childNodeList || !this.childNodeList.nodes) {
              this.childNodeList = new XMLNodeList(this.children);
            }
            return this.childNodeList;
          }
        });
        Object.defineProperty(XMLNode2.prototype, "firstChild", {
          get: function() {
            return this.children[0] || null;
          }
        });
        Object.defineProperty(XMLNode2.prototype, "lastChild", {
          get: function() {
            return this.children[this.children.length - 1] || null;
          }
        });
        Object.defineProperty(XMLNode2.prototype, "previousSibling", {
          get: function() {
            var i;
            i = this.parent.children.indexOf(this);
            return this.parent.children[i - 1] || null;
          }
        });
        Object.defineProperty(XMLNode2.prototype, "nextSibling", {
          get: function() {
            var i;
            i = this.parent.children.indexOf(this);
            return this.parent.children[i + 1] || null;
          }
        });
        Object.defineProperty(XMLNode2.prototype, "ownerDocument", {
          get: function() {
            return this.document() || null;
          }
        });
        Object.defineProperty(XMLNode2.prototype, "textContent", {
          get: function() {
            var child, j, len, ref2, str;
            if (this.nodeType === NodeType.Element || this.nodeType === NodeType.DocumentFragment) {
              str = "";
              ref2 = this.children;
              for (j = 0, len = ref2.length; j < len; j++) {
                child = ref2[j];
                if (child.textContent) {
                  str += child.textContent;
                }
              }
              return str;
            } else {
              return null;
            }
          },
          set: function(value) {
            throw new Error("This DOM method is not implemented." + this.debugInfo());
          }
        });
        XMLNode2.prototype.setParent = function(parent) {
          var child, j, len, ref2, results;
          this.parent = parent;
          if (parent) {
            this.options = parent.options;
            this.stringify = parent.stringify;
          }
          ref2 = this.children;
          results = [];
          for (j = 0, len = ref2.length; j < len; j++) {
            child = ref2[j];
            results.push(child.setParent(this));
          }
          return results;
        };
        XMLNode2.prototype.element = function(name, attributes, text) {
          var childNode, item, j, k, key, lastChild, len, len1, ref2, ref3, val;
          lastChild = null;
          if (attributes === null && text == null) {
            ref2 = [{}, null], attributes = ref2[0], text = ref2[1];
          }
          if (attributes == null) {
            attributes = {};
          }
          attributes = getValue(attributes);
          if (!isObject(attributes)) {
            ref3 = [attributes, text], text = ref3[0], attributes = ref3[1];
          }
          if (name != null) {
            name = getValue(name);
          }
          if (Array.isArray(name)) {
            for (j = 0, len = name.length; j < len; j++) {
              item = name[j];
              lastChild = this.element(item);
            }
          } else if (isFunction(name)) {
            lastChild = this.element(name.apply());
          } else if (isObject(name)) {
            for (key in name) {
              if (!hasProp.call(name, key)) continue;
              val = name[key];
              if (isFunction(val)) {
                val = val.apply();
              }
              if (!this.options.ignoreDecorators && this.stringify.convertAttKey && key.indexOf(this.stringify.convertAttKey) === 0) {
                lastChild = this.attribute(key.substr(this.stringify.convertAttKey.length), val);
              } else if (!this.options.separateArrayItems && Array.isArray(val) && isEmpty(val)) {
                lastChild = this.dummy();
              } else if (isObject(val) && isEmpty(val)) {
                lastChild = this.element(key);
              } else if (!this.options.keepNullNodes && val == null) {
                lastChild = this.dummy();
              } else if (!this.options.separateArrayItems && Array.isArray(val)) {
                for (k = 0, len1 = val.length; k < len1; k++) {
                  item = val[k];
                  childNode = {};
                  childNode[key] = item;
                  lastChild = this.element(childNode);
                }
              } else if (isObject(val)) {
                if (!this.options.ignoreDecorators && this.stringify.convertTextKey && key.indexOf(this.stringify.convertTextKey) === 0) {
                  lastChild = this.element(val);
                } else {
                  lastChild = this.element(key);
                  lastChild.element(val);
                }
              } else {
                lastChild = this.element(key, val);
              }
            }
          } else if (!this.options.keepNullNodes && text === null) {
            lastChild = this.dummy();
          } else {
            if (!this.options.ignoreDecorators && this.stringify.convertTextKey && name.indexOf(this.stringify.convertTextKey) === 0) {
              lastChild = this.text(text);
            } else if (!this.options.ignoreDecorators && this.stringify.convertCDataKey && name.indexOf(this.stringify.convertCDataKey) === 0) {
              lastChild = this.cdata(text);
            } else if (!this.options.ignoreDecorators && this.stringify.convertCommentKey && name.indexOf(this.stringify.convertCommentKey) === 0) {
              lastChild = this.comment(text);
            } else if (!this.options.ignoreDecorators && this.stringify.convertRawKey && name.indexOf(this.stringify.convertRawKey) === 0) {
              lastChild = this.raw(text);
            } else if (!this.options.ignoreDecorators && this.stringify.convertPIKey && name.indexOf(this.stringify.convertPIKey) === 0) {
              lastChild = this.instruction(name.substr(this.stringify.convertPIKey.length), text);
            } else {
              lastChild = this.node(name, attributes, text);
            }
          }
          if (lastChild == null) {
            throw new Error("Could not create any elements with: " + name + ". " + this.debugInfo());
          }
          return lastChild;
        };
        XMLNode2.prototype.insertBefore = function(name, attributes, text) {
          var child, i, newChild, refChild, removed;
          if (name != null ? name.type : void 0) {
            newChild = name;
            refChild = attributes;
            newChild.setParent(this);
            if (refChild) {
              i = children.indexOf(refChild);
              removed = children.splice(i);
              children.push(newChild);
              Array.prototype.push.apply(children, removed);
            } else {
              children.push(newChild);
            }
            return newChild;
          } else {
            if (this.isRoot) {
              throw new Error("Cannot insert elements at root level. " + this.debugInfo(name));
            }
            i = this.parent.children.indexOf(this);
            removed = this.parent.children.splice(i);
            child = this.parent.element(name, attributes, text);
            Array.prototype.push.apply(this.parent.children, removed);
            return child;
          }
        };
        XMLNode2.prototype.insertAfter = function(name, attributes, text) {
          var child, i, removed;
          if (this.isRoot) {
            throw new Error("Cannot insert elements at root level. " + this.debugInfo(name));
          }
          i = this.parent.children.indexOf(this);
          removed = this.parent.children.splice(i + 1);
          child = this.parent.element(name, attributes, text);
          Array.prototype.push.apply(this.parent.children, removed);
          return child;
        };
        XMLNode2.prototype.remove = function() {
          var i, ref2;
          if (this.isRoot) {
            throw new Error("Cannot remove the root element. " + this.debugInfo());
          }
          i = this.parent.children.indexOf(this);
          [].splice.apply(this.parent.children, [i, i - i + 1].concat(ref2 = [])), ref2;
          return this.parent;
        };
        XMLNode2.prototype.node = function(name, attributes, text) {
          var child, ref2;
          if (name != null) {
            name = getValue(name);
          }
          attributes || (attributes = {});
          attributes = getValue(attributes);
          if (!isObject(attributes)) {
            ref2 = [attributes, text], text = ref2[0], attributes = ref2[1];
          }
          child = new XMLElement(this, name, attributes);
          if (text != null) {
            child.text(text);
          }
          this.children.push(child);
          return child;
        };
        XMLNode2.prototype.text = function(value) {
          var child;
          if (isObject(value)) {
            this.element(value);
          }
          child = new XMLText(this, value);
          this.children.push(child);
          return this;
        };
        XMLNode2.prototype.cdata = function(value) {
          var child;
          child = new XMLCData(this, value);
          this.children.push(child);
          return this;
        };
        XMLNode2.prototype.comment = function(value) {
          var child;
          child = new XMLComment(this, value);
          this.children.push(child);
          return this;
        };
        XMLNode2.prototype.commentBefore = function(value) {
          var child, i, removed;
          i = this.parent.children.indexOf(this);
          removed = this.parent.children.splice(i);
          child = this.parent.comment(value);
          Array.prototype.push.apply(this.parent.children, removed);
          return this;
        };
        XMLNode2.prototype.commentAfter = function(value) {
          var child, i, removed;
          i = this.parent.children.indexOf(this);
          removed = this.parent.children.splice(i + 1);
          child = this.parent.comment(value);
          Array.prototype.push.apply(this.parent.children, removed);
          return this;
        };
        XMLNode2.prototype.raw = function(value) {
          var child;
          child = new XMLRaw(this, value);
          this.children.push(child);
          return this;
        };
        XMLNode2.prototype.dummy = function() {
          var child;
          child = new XMLDummy(this);
          return child;
        };
        XMLNode2.prototype.instruction = function(target, value) {
          var insTarget, insValue, instruction, j, len;
          if (target != null) {
            target = getValue(target);
          }
          if (value != null) {
            value = getValue(value);
          }
          if (Array.isArray(target)) {
            for (j = 0, len = target.length; j < len; j++) {
              insTarget = target[j];
              this.instruction(insTarget);
            }
          } else if (isObject(target)) {
            for (insTarget in target) {
              if (!hasProp.call(target, insTarget)) continue;
              insValue = target[insTarget];
              this.instruction(insTarget, insValue);
            }
          } else {
            if (isFunction(value)) {
              value = value.apply();
            }
            instruction = new XMLProcessingInstruction(this, target, value);
            this.children.push(instruction);
          }
          return this;
        };
        XMLNode2.prototype.instructionBefore = function(target, value) {
          var child, i, removed;
          i = this.parent.children.indexOf(this);
          removed = this.parent.children.splice(i);
          child = this.parent.instruction(target, value);
          Array.prototype.push.apply(this.parent.children, removed);
          return this;
        };
        XMLNode2.prototype.instructionAfter = function(target, value) {
          var child, i, removed;
          i = this.parent.children.indexOf(this);
          removed = this.parent.children.splice(i + 1);
          child = this.parent.instruction(target, value);
          Array.prototype.push.apply(this.parent.children, removed);
          return this;
        };
        XMLNode2.prototype.declaration = function(version, encoding, standalone) {
          var doc, xmldec;
          doc = this.document();
          xmldec = new XMLDeclaration(doc, version, encoding, standalone);
          if (doc.children.length === 0) {
            doc.children.unshift(xmldec);
          } else if (doc.children[0].type === NodeType.Declaration) {
            doc.children[0] = xmldec;
          } else {
            doc.children.unshift(xmldec);
          }
          return doc.root() || doc;
        };
        XMLNode2.prototype.dtd = function(pubID, sysID) {
          var child, doc, doctype, i, j, k, len, len1, ref2, ref3;
          doc = this.document();
          doctype = new XMLDocType(doc, pubID, sysID);
          ref2 = doc.children;
          for (i = j = 0, len = ref2.length; j < len; i = ++j) {
            child = ref2[i];
            if (child.type === NodeType.DocType) {
              doc.children[i] = doctype;
              return doctype;
            }
          }
          ref3 = doc.children;
          for (i = k = 0, len1 = ref3.length; k < len1; i = ++k) {
            child = ref3[i];
            if (child.isRoot) {
              doc.children.splice(i, 0, doctype);
              return doctype;
            }
          }
          doc.children.push(doctype);
          return doctype;
        };
        XMLNode2.prototype.up = function() {
          if (this.isRoot) {
            throw new Error("The root node has no parent. Use doc() if you need to get the document object.");
          }
          return this.parent;
        };
        XMLNode2.prototype.root = function() {
          var node;
          node = this;
          while (node) {
            if (node.type === NodeType.Document) {
              return node.rootObject;
            } else if (node.isRoot) {
              return node;
            } else {
              node = node.parent;
            }
          }
        };
        XMLNode2.prototype.document = function() {
          var node;
          node = this;
          while (node) {
            if (node.type === NodeType.Document) {
              return node;
            } else {
              node = node.parent;
            }
          }
        };
        XMLNode2.prototype.end = function(options) {
          return this.document().end(options);
        };
        XMLNode2.prototype.prev = function() {
          var i;
          i = this.parent.children.indexOf(this);
          if (i < 1) {
            throw new Error("Already at the first node. " + this.debugInfo());
          }
          return this.parent.children[i - 1];
        };
        XMLNode2.prototype.next = function() {
          var i;
          i = this.parent.children.indexOf(this);
          if (i === -1 || i === this.parent.children.length - 1) {
            throw new Error("Already at the last node. " + this.debugInfo());
          }
          return this.parent.children[i + 1];
        };
        XMLNode2.prototype.importDocument = function(doc) {
          var clonedRoot;
          clonedRoot = doc.root().clone();
          clonedRoot.parent = this;
          clonedRoot.isRoot = false;
          this.children.push(clonedRoot);
          return this;
        };
        XMLNode2.prototype.debugInfo = function(name) {
          var ref2, ref3;
          name = name || this.name;
          if (name == null && !((ref2 = this.parent) != null ? ref2.name : void 0)) {
            return "";
          } else if (name == null) {
            return "parent: <" + this.parent.name + ">";
          } else if (!((ref3 = this.parent) != null ? ref3.name : void 0)) {
            return "node: <" + name + ">";
          } else {
            return "node: <" + name + ">, parent: <" + this.parent.name + ">";
          }
        };
        XMLNode2.prototype.ele = function(name, attributes, text) {
          return this.element(name, attributes, text);
        };
        XMLNode2.prototype.nod = function(name, attributes, text) {
          return this.node(name, attributes, text);
        };
        XMLNode2.prototype.txt = function(value) {
          return this.text(value);
        };
        XMLNode2.prototype.dat = function(value) {
          return this.cdata(value);
        };
        XMLNode2.prototype.com = function(value) {
          return this.comment(value);
        };
        XMLNode2.prototype.ins = function(target, value) {
          return this.instruction(target, value);
        };
        XMLNode2.prototype.doc = function() {
          return this.document();
        };
        XMLNode2.prototype.dec = function(version, encoding, standalone) {
          return this.declaration(version, encoding, standalone);
        };
        XMLNode2.prototype.e = function(name, attributes, text) {
          return this.element(name, attributes, text);
        };
        XMLNode2.prototype.n = function(name, attributes, text) {
          return this.node(name, attributes, text);
        };
        XMLNode2.prototype.t = function(value) {
          return this.text(value);
        };
        XMLNode2.prototype.d = function(value) {
          return this.cdata(value);
        };
        XMLNode2.prototype.c = function(value) {
          return this.comment(value);
        };
        XMLNode2.prototype.r = function(value) {
          return this.raw(value);
        };
        XMLNode2.prototype.i = function(target, value) {
          return this.instruction(target, value);
        };
        XMLNode2.prototype.u = function() {
          return this.up();
        };
        XMLNode2.prototype.importXMLBuilder = function(doc) {
          return this.importDocument(doc);
        };
        XMLNode2.prototype.replaceChild = function(newChild, oldChild) {
          throw new Error("This DOM method is not implemented." + this.debugInfo());
        };
        XMLNode2.prototype.removeChild = function(oldChild) {
          throw new Error("This DOM method is not implemented." + this.debugInfo());
        };
        XMLNode2.prototype.appendChild = function(newChild) {
          throw new Error("This DOM method is not implemented." + this.debugInfo());
        };
        XMLNode2.prototype.hasChildNodes = function() {
          return this.children.length !== 0;
        };
        XMLNode2.prototype.cloneNode = function(deep) {
          throw new Error("This DOM method is not implemented." + this.debugInfo());
        };
        XMLNode2.prototype.normalize = function() {
          throw new Error("This DOM method is not implemented." + this.debugInfo());
        };
        XMLNode2.prototype.isSupported = function(feature, version) {
          return true;
        };
        XMLNode2.prototype.hasAttributes = function() {
          return this.attribs.length !== 0;
        };
        XMLNode2.prototype.compareDocumentPosition = function(other) {
          var ref, res;
          ref = this;
          if (ref === other) {
            return 0;
          } else if (this.document() !== other.document()) {
            res = DocumentPosition.Disconnected | DocumentPosition.ImplementationSpecific;
            if (Math.random() < 0.5) {
              res |= DocumentPosition.Preceding;
            } else {
              res |= DocumentPosition.Following;
            }
            return res;
          } else if (ref.isAncestor(other)) {
            return DocumentPosition.Contains | DocumentPosition.Preceding;
          } else if (ref.isDescendant(other)) {
            return DocumentPosition.Contains | DocumentPosition.Following;
          } else if (ref.isPreceding(other)) {
            return DocumentPosition.Preceding;
          } else {
            return DocumentPosition.Following;
          }
        };
        XMLNode2.prototype.isSameNode = function(other) {
          throw new Error("This DOM method is not implemented." + this.debugInfo());
        };
        XMLNode2.prototype.lookupPrefix = function(namespaceURI) {
          throw new Error("This DOM method is not implemented." + this.debugInfo());
        };
        XMLNode2.prototype.isDefaultNamespace = function(namespaceURI) {
          throw new Error("This DOM method is not implemented." + this.debugInfo());
        };
        XMLNode2.prototype.lookupNamespaceURI = function(prefix) {
          throw new Error("This DOM method is not implemented." + this.debugInfo());
        };
        XMLNode2.prototype.isEqualNode = function(node) {
          var i, j, ref2;
          if (node.nodeType !== this.nodeType) {
            return false;
          }
          if (node.children.length !== this.children.length) {
            return false;
          }
          for (i = j = 0, ref2 = this.children.length - 1; 0 <= ref2 ? j <= ref2 : j >= ref2; i = 0 <= ref2 ? ++j : --j) {
            if (!this.children[i].isEqualNode(node.children[i])) {
              return false;
            }
          }
          return true;
        };
        XMLNode2.prototype.getFeature = function(feature, version) {
          throw new Error("This DOM method is not implemented." + this.debugInfo());
        };
        XMLNode2.prototype.setUserData = function(key, data, handler) {
          throw new Error("This DOM method is not implemented." + this.debugInfo());
        };
        XMLNode2.prototype.getUserData = function(key) {
          throw new Error("This DOM method is not implemented." + this.debugInfo());
        };
        XMLNode2.prototype.contains = function(other) {
          if (!other) {
            return false;
          }
          return other === this || this.isDescendant(other);
        };
        XMLNode2.prototype.isDescendant = function(node) {
          var child, isDescendantChild, j, len, ref2;
          ref2 = this.children;
          for (j = 0, len = ref2.length; j < len; j++) {
            child = ref2[j];
            if (node === child) {
              return true;
            }
            isDescendantChild = child.isDescendant(node);
            if (isDescendantChild) {
              return true;
            }
          }
          return false;
        };
        XMLNode2.prototype.isAncestor = function(node) {
          return node.isDescendant(this);
        };
        XMLNode2.prototype.isPreceding = function(node) {
          var nodePos, thisPos;
          nodePos = this.treePosition(node);
          thisPos = this.treePosition(this);
          if (nodePos === -1 || thisPos === -1) {
            return false;
          } else {
            return nodePos < thisPos;
          }
        };
        XMLNode2.prototype.isFollowing = function(node) {
          var nodePos, thisPos;
          nodePos = this.treePosition(node);
          thisPos = this.treePosition(this);
          if (nodePos === -1 || thisPos === -1) {
            return false;
          } else {
            return nodePos > thisPos;
          }
        };
        XMLNode2.prototype.treePosition = function(node) {
          var found, pos;
          pos = 0;
          found = false;
          this.foreachTreeNode(this.document(), function(childNode) {
            pos++;
            if (!found && childNode === node) {
              return found = true;
            }
          });
          if (found) {
            return pos;
          } else {
            return -1;
          }
        };
        XMLNode2.prototype.foreachTreeNode = function(node, func) {
          var child, j, len, ref2, res;
          node || (node = this.document());
          ref2 = node.children;
          for (j = 0, len = ref2.length; j < len; j++) {
            child = ref2[j];
            if (res = func(child)) {
              return res;
            } else {
              res = this.foreachTreeNode(child, func);
              if (res) {
                return res;
              }
            }
          }
        };
        return XMLNode2;
      })();
    }).call(exports2);
  }
});

// node_modules/xmlbuilder/lib/XMLStringifier.js
var require_XMLStringifier = __commonJS({
  "node_modules/xmlbuilder/lib/XMLStringifier.js"(exports2, module2) {
    (function() {
      var XMLStringifier, bind = function(fn, me) {
        return function() {
          return fn.apply(me, arguments);
        };
      }, hasProp = {}.hasOwnProperty;
      module2.exports = XMLStringifier = (function() {
        function XMLStringifier2(options) {
          this.assertLegalName = bind(this.assertLegalName, this);
          this.assertLegalChar = bind(this.assertLegalChar, this);
          var key, ref, value;
          options || (options = {});
          this.options = options;
          if (!this.options.version) {
            this.options.version = "1.0";
          }
          ref = options.stringify || {};
          for (key in ref) {
            if (!hasProp.call(ref, key)) continue;
            value = ref[key];
            this[key] = value;
          }
        }
        XMLStringifier2.prototype.name = function(val) {
          if (this.options.noValidation) {
            return val;
          }
          return this.assertLegalName("" + val || "");
        };
        XMLStringifier2.prototype.text = function(val) {
          if (this.options.noValidation) {
            return val;
          }
          return this.assertLegalChar(this.textEscape("" + val || ""));
        };
        XMLStringifier2.prototype.cdata = function(val) {
          if (this.options.noValidation) {
            return val;
          }
          val = "" + val || "";
          val = val.replace("]]>", "]]]]><![CDATA[>");
          return this.assertLegalChar(val);
        };
        XMLStringifier2.prototype.comment = function(val) {
          if (this.options.noValidation) {
            return val;
          }
          val = "" + val || "";
          if (val.match(/--/)) {
            throw new Error("Comment text cannot contain double-hypen: " + val);
          }
          return this.assertLegalChar(val);
        };
        XMLStringifier2.prototype.raw = function(val) {
          if (this.options.noValidation) {
            return val;
          }
          return "" + val || "";
        };
        XMLStringifier2.prototype.attValue = function(val) {
          if (this.options.noValidation) {
            return val;
          }
          return this.assertLegalChar(this.attEscape(val = "" + val || ""));
        };
        XMLStringifier2.prototype.insTarget = function(val) {
          if (this.options.noValidation) {
            return val;
          }
          return this.assertLegalChar("" + val || "");
        };
        XMLStringifier2.prototype.insValue = function(val) {
          if (this.options.noValidation) {
            return val;
          }
          val = "" + val || "";
          if (val.match(/\?>/)) {
            throw new Error("Invalid processing instruction value: " + val);
          }
          return this.assertLegalChar(val);
        };
        XMLStringifier2.prototype.xmlVersion = function(val) {
          if (this.options.noValidation) {
            return val;
          }
          val = "" + val || "";
          if (!val.match(/1\.[0-9]+/)) {
            throw new Error("Invalid version number: " + val);
          }
          return val;
        };
        XMLStringifier2.prototype.xmlEncoding = function(val) {
          if (this.options.noValidation) {
            return val;
          }
          val = "" + val || "";
          if (!val.match(/^[A-Za-z](?:[A-Za-z0-9._-])*$/)) {
            throw new Error("Invalid encoding: " + val);
          }
          return this.assertLegalChar(val);
        };
        XMLStringifier2.prototype.xmlStandalone = function(val) {
          if (this.options.noValidation) {
            return val;
          }
          if (val) {
            return "yes";
          } else {
            return "no";
          }
        };
        XMLStringifier2.prototype.dtdPubID = function(val) {
          if (this.options.noValidation) {
            return val;
          }
          return this.assertLegalChar("" + val || "");
        };
        XMLStringifier2.prototype.dtdSysID = function(val) {
          if (this.options.noValidation) {
            return val;
          }
          return this.assertLegalChar("" + val || "");
        };
        XMLStringifier2.prototype.dtdElementValue = function(val) {
          if (this.options.noValidation) {
            return val;
          }
          return this.assertLegalChar("" + val || "");
        };
        XMLStringifier2.prototype.dtdAttType = function(val) {
          if (this.options.noValidation) {
            return val;
          }
          return this.assertLegalChar("" + val || "");
        };
        XMLStringifier2.prototype.dtdAttDefault = function(val) {
          if (this.options.noValidation) {
            return val;
          }
          return this.assertLegalChar("" + val || "");
        };
        XMLStringifier2.prototype.dtdEntityValue = function(val) {
          if (this.options.noValidation) {
            return val;
          }
          return this.assertLegalChar("" + val || "");
        };
        XMLStringifier2.prototype.dtdNData = function(val) {
          if (this.options.noValidation) {
            return val;
          }
          return this.assertLegalChar("" + val || "");
        };
        XMLStringifier2.prototype.convertAttKey = "@";
        XMLStringifier2.prototype.convertPIKey = "?";
        XMLStringifier2.prototype.convertTextKey = "#text";
        XMLStringifier2.prototype.convertCDataKey = "#cdata";
        XMLStringifier2.prototype.convertCommentKey = "#comment";
        XMLStringifier2.prototype.convertRawKey = "#raw";
        XMLStringifier2.prototype.assertLegalChar = function(str) {
          var regex, res;
          if (this.options.noValidation) {
            return str;
          }
          regex = "";
          if (this.options.version === "1.0") {
            regex = /[\0-\x08\x0B\f\x0E-\x1F\uFFFE\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF]/;
            if (res = str.match(regex)) {
              throw new Error("Invalid character in string: " + str + " at index " + res.index);
            }
          } else if (this.options.version === "1.1") {
            regex = /[\0\uFFFE\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF]/;
            if (res = str.match(regex)) {
              throw new Error("Invalid character in string: " + str + " at index " + res.index);
            }
          }
          return str;
        };
        XMLStringifier2.prototype.assertLegalName = function(str) {
          var regex;
          if (this.options.noValidation) {
            return str;
          }
          this.assertLegalChar(str);
          regex = /^([:A-Z_a-z\xC0-\xD6\xD8-\xF6\xF8-\u02FF\u0370-\u037D\u037F-\u1FFF\u200C\u200D\u2070-\u218F\u2C00-\u2FEF\u3001-\uD7FF\uF900-\uFDCF\uFDF0-\uFFFD]|[\uD800-\uDB7F][\uDC00-\uDFFF])([\x2D\.0-:A-Z_a-z\xB7\xC0-\xD6\xD8-\xF6\xF8-\u037D\u037F-\u1FFF\u200C\u200D\u203F\u2040\u2070-\u218F\u2C00-\u2FEF\u3001-\uD7FF\uF900-\uFDCF\uFDF0-\uFFFD]|[\uD800-\uDB7F][\uDC00-\uDFFF])*$/;
          if (!str.match(regex)) {
            throw new Error("Invalid character in name");
          }
          return str;
        };
        XMLStringifier2.prototype.textEscape = function(str) {
          var ampregex;
          if (this.options.noValidation) {
            return str;
          }
          ampregex = this.options.noDoubleEncoding ? /(?!&\S+;)&/g : /&/g;
          return str.replace(ampregex, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;").replace(/\r/g, "&#xD;");
        };
        XMLStringifier2.prototype.attEscape = function(str) {
          var ampregex;
          if (this.options.noValidation) {
            return str;
          }
          ampregex = this.options.noDoubleEncoding ? /(?!&\S+;)&/g : /&/g;
          return str.replace(ampregex, "&amp;").replace(/</g, "&lt;").replace(/"/g, "&quot;").replace(/\t/g, "&#x9;").replace(/\n/g, "&#xA;").replace(/\r/g, "&#xD;");
        };
        return XMLStringifier2;
      })();
    }).call(exports2);
  }
});

// node_modules/xmlbuilder/lib/WriterState.js
var require_WriterState = __commonJS({
  "node_modules/xmlbuilder/lib/WriterState.js"(exports2, module2) {
    (function() {
      module2.exports = {
        None: 0,
        OpenTag: 1,
        InsideTag: 2,
        CloseTag: 3
      };
    }).call(exports2);
  }
});

// node_modules/xmlbuilder/lib/XMLWriterBase.js
var require_XMLWriterBase = __commonJS({
  "node_modules/xmlbuilder/lib/XMLWriterBase.js"(exports2, module2) {
    (function() {
      var NodeType, WriterState, XMLCData, XMLComment, XMLDTDAttList, XMLDTDElement, XMLDTDEntity, XMLDTDNotation, XMLDeclaration, XMLDocType, XMLDummy, XMLElement, XMLProcessingInstruction, XMLRaw, XMLText, XMLWriterBase, assign, hasProp = {}.hasOwnProperty;
      assign = require_Utility().assign;
      NodeType = require_NodeType();
      XMLDeclaration = require_XMLDeclaration();
      XMLDocType = require_XMLDocType();
      XMLCData = require_XMLCData();
      XMLComment = require_XMLComment();
      XMLElement = require_XMLElement();
      XMLRaw = require_XMLRaw();
      XMLText = require_XMLText();
      XMLProcessingInstruction = require_XMLProcessingInstruction();
      XMLDummy = require_XMLDummy();
      XMLDTDAttList = require_XMLDTDAttList();
      XMLDTDElement = require_XMLDTDElement();
      XMLDTDEntity = require_XMLDTDEntity();
      XMLDTDNotation = require_XMLDTDNotation();
      WriterState = require_WriterState();
      module2.exports = XMLWriterBase = (function() {
        function XMLWriterBase2(options) {
          var key, ref, value;
          options || (options = {});
          this.options = options;
          ref = options.writer || {};
          for (key in ref) {
            if (!hasProp.call(ref, key)) continue;
            value = ref[key];
            this["_" + key] = this[key];
            this[key] = value;
          }
        }
        XMLWriterBase2.prototype.filterOptions = function(options) {
          var filteredOptions, ref, ref1, ref2, ref3, ref4, ref5, ref6;
          options || (options = {});
          options = assign({}, this.options, options);
          filteredOptions = {
            writer: this
          };
          filteredOptions.pretty = options.pretty || false;
          filteredOptions.allowEmpty = options.allowEmpty || false;
          filteredOptions.indent = (ref = options.indent) != null ? ref : "  ";
          filteredOptions.newline = (ref1 = options.newline) != null ? ref1 : "\n";
          filteredOptions.offset = (ref2 = options.offset) != null ? ref2 : 0;
          filteredOptions.dontPrettyTextNodes = (ref3 = (ref4 = options.dontPrettyTextNodes) != null ? ref4 : options.dontprettytextnodes) != null ? ref3 : 0;
          filteredOptions.spaceBeforeSlash = (ref5 = (ref6 = options.spaceBeforeSlash) != null ? ref6 : options.spacebeforeslash) != null ? ref5 : "";
          if (filteredOptions.spaceBeforeSlash === true) {
            filteredOptions.spaceBeforeSlash = " ";
          }
          filteredOptions.suppressPrettyCount = 0;
          filteredOptions.user = {};
          filteredOptions.state = WriterState.None;
          return filteredOptions;
        };
        XMLWriterBase2.prototype.indent = function(node, options, level) {
          var indentLevel;
          if (!options.pretty || options.suppressPrettyCount) {
            return "";
          } else if (options.pretty) {
            indentLevel = (level || 0) + options.offset + 1;
            if (indentLevel > 0) {
              return new Array(indentLevel).join(options.indent);
            }
          }
          return "";
        };
        XMLWriterBase2.prototype.endline = function(node, options, level) {
          if (!options.pretty || options.suppressPrettyCount) {
            return "";
          } else {
            return options.newline;
          }
        };
        XMLWriterBase2.prototype.attribute = function(att, options, level) {
          var r;
          this.openAttribute(att, options, level);
          r = " " + att.name + '="' + att.value + '"';
          this.closeAttribute(att, options, level);
          return r;
        };
        XMLWriterBase2.prototype.cdata = function(node, options, level) {
          var r;
          this.openNode(node, options, level);
          options.state = WriterState.OpenTag;
          r = this.indent(node, options, level) + "<![CDATA[";
          options.state = WriterState.InsideTag;
          r += node.value;
          options.state = WriterState.CloseTag;
          r += "]]>" + this.endline(node, options, level);
          options.state = WriterState.None;
          this.closeNode(node, options, level);
          return r;
        };
        XMLWriterBase2.prototype.comment = function(node, options, level) {
          var r;
          this.openNode(node, options, level);
          options.state = WriterState.OpenTag;
          r = this.indent(node, options, level) + "<!-- ";
          options.state = WriterState.InsideTag;
          r += node.value;
          options.state = WriterState.CloseTag;
          r += " -->" + this.endline(node, options, level);
          options.state = WriterState.None;
          this.closeNode(node, options, level);
          return r;
        };
        XMLWriterBase2.prototype.declaration = function(node, options, level) {
          var r;
          this.openNode(node, options, level);
          options.state = WriterState.OpenTag;
          r = this.indent(node, options, level) + "<?xml";
          options.state = WriterState.InsideTag;
          r += ' version="' + node.version + '"';
          if (node.encoding != null) {
            r += ' encoding="' + node.encoding + '"';
          }
          if (node.standalone != null) {
            r += ' standalone="' + node.standalone + '"';
          }
          options.state = WriterState.CloseTag;
          r += options.spaceBeforeSlash + "?>";
          r += this.endline(node, options, level);
          options.state = WriterState.None;
          this.closeNode(node, options, level);
          return r;
        };
        XMLWriterBase2.prototype.docType = function(node, options, level) {
          var child, i, len, r, ref;
          level || (level = 0);
          this.openNode(node, options, level);
          options.state = WriterState.OpenTag;
          r = this.indent(node, options, level);
          r += "<!DOCTYPE " + node.root().name;
          if (node.pubID && node.sysID) {
            r += ' PUBLIC "' + node.pubID + '" "' + node.sysID + '"';
          } else if (node.sysID) {
            r += ' SYSTEM "' + node.sysID + '"';
          }
          if (node.children.length > 0) {
            r += " [";
            r += this.endline(node, options, level);
            options.state = WriterState.InsideTag;
            ref = node.children;
            for (i = 0, len = ref.length; i < len; i++) {
              child = ref[i];
              r += this.writeChildNode(child, options, level + 1);
            }
            options.state = WriterState.CloseTag;
            r += "]";
          }
          options.state = WriterState.CloseTag;
          r += options.spaceBeforeSlash + ">";
          r += this.endline(node, options, level);
          options.state = WriterState.None;
          this.closeNode(node, options, level);
          return r;
        };
        XMLWriterBase2.prototype.element = function(node, options, level) {
          var att, child, childNodeCount, firstChildNode, i, j, len, len1, name, prettySuppressed, r, ref, ref1, ref2;
          level || (level = 0);
          prettySuppressed = false;
          r = "";
          this.openNode(node, options, level);
          options.state = WriterState.OpenTag;
          r += this.indent(node, options, level) + "<" + node.name;
          ref = node.attribs;
          for (name in ref) {
            if (!hasProp.call(ref, name)) continue;
            att = ref[name];
            r += this.attribute(att, options, level);
          }
          childNodeCount = node.children.length;
          firstChildNode = childNodeCount === 0 ? null : node.children[0];
          if (childNodeCount === 0 || node.children.every(function(e) {
            return (e.type === NodeType.Text || e.type === NodeType.Raw) && e.value === "";
          })) {
            if (options.allowEmpty) {
              r += ">";
              options.state = WriterState.CloseTag;
              r += "</" + node.name + ">" + this.endline(node, options, level);
            } else {
              options.state = WriterState.CloseTag;
              r += options.spaceBeforeSlash + "/>" + this.endline(node, options, level);
            }
          } else if (options.pretty && childNodeCount === 1 && (firstChildNode.type === NodeType.Text || firstChildNode.type === NodeType.Raw) && firstChildNode.value != null) {
            r += ">";
            options.state = WriterState.InsideTag;
            options.suppressPrettyCount++;
            prettySuppressed = true;
            r += this.writeChildNode(firstChildNode, options, level + 1);
            options.suppressPrettyCount--;
            prettySuppressed = false;
            options.state = WriterState.CloseTag;
            r += "</" + node.name + ">" + this.endline(node, options, level);
          } else {
            if (options.dontPrettyTextNodes) {
              ref1 = node.children;
              for (i = 0, len = ref1.length; i < len; i++) {
                child = ref1[i];
                if ((child.type === NodeType.Text || child.type === NodeType.Raw) && child.value != null) {
                  options.suppressPrettyCount++;
                  prettySuppressed = true;
                  break;
                }
              }
            }
            r += ">" + this.endline(node, options, level);
            options.state = WriterState.InsideTag;
            ref2 = node.children;
            for (j = 0, len1 = ref2.length; j < len1; j++) {
              child = ref2[j];
              r += this.writeChildNode(child, options, level + 1);
            }
            options.state = WriterState.CloseTag;
            r += this.indent(node, options, level) + "</" + node.name + ">";
            if (prettySuppressed) {
              options.suppressPrettyCount--;
            }
            r += this.endline(node, options, level);
            options.state = WriterState.None;
          }
          this.closeNode(node, options, level);
          return r;
        };
        XMLWriterBase2.prototype.writeChildNode = function(node, options, level) {
          switch (node.type) {
            case NodeType.CData:
              return this.cdata(node, options, level);
            case NodeType.Comment:
              return this.comment(node, options, level);
            case NodeType.Element:
              return this.element(node, options, level);
            case NodeType.Raw:
              return this.raw(node, options, level);
            case NodeType.Text:
              return this.text(node, options, level);
            case NodeType.ProcessingInstruction:
              return this.processingInstruction(node, options, level);
            case NodeType.Dummy:
              return "";
            case NodeType.Declaration:
              return this.declaration(node, options, level);
            case NodeType.DocType:
              return this.docType(node, options, level);
            case NodeType.AttributeDeclaration:
              return this.dtdAttList(node, options, level);
            case NodeType.ElementDeclaration:
              return this.dtdElement(node, options, level);
            case NodeType.EntityDeclaration:
              return this.dtdEntity(node, options, level);
            case NodeType.NotationDeclaration:
              return this.dtdNotation(node, options, level);
            default:
              throw new Error("Unknown XML node type: " + node.constructor.name);
          }
        };
        XMLWriterBase2.prototype.processingInstruction = function(node, options, level) {
          var r;
          this.openNode(node, options, level);
          options.state = WriterState.OpenTag;
          r = this.indent(node, options, level) + "<?";
          options.state = WriterState.InsideTag;
          r += node.target;
          if (node.value) {
            r += " " + node.value;
          }
          options.state = WriterState.CloseTag;
          r += options.spaceBeforeSlash + "?>";
          r += this.endline(node, options, level);
          options.state = WriterState.None;
          this.closeNode(node, options, level);
          return r;
        };
        XMLWriterBase2.prototype.raw = function(node, options, level) {
          var r;
          this.openNode(node, options, level);
          options.state = WriterState.OpenTag;
          r = this.indent(node, options, level);
          options.state = WriterState.InsideTag;
          r += node.value;
          options.state = WriterState.CloseTag;
          r += this.endline(node, options, level);
          options.state = WriterState.None;
          this.closeNode(node, options, level);
          return r;
        };
        XMLWriterBase2.prototype.text = function(node, options, level) {
          var r;
          this.openNode(node, options, level);
          options.state = WriterState.OpenTag;
          r = this.indent(node, options, level);
          options.state = WriterState.InsideTag;
          r += node.value;
          options.state = WriterState.CloseTag;
          r += this.endline(node, options, level);
          options.state = WriterState.None;
          this.closeNode(node, options, level);
          return r;
        };
        XMLWriterBase2.prototype.dtdAttList = function(node, options, level) {
          var r;
          this.openNode(node, options, level);
          options.state = WriterState.OpenTag;
          r = this.indent(node, options, level) + "<!ATTLIST";
          options.state = WriterState.InsideTag;
          r += " " + node.elementName + " " + node.attributeName + " " + node.attributeType;
          if (node.defaultValueType !== "#DEFAULT") {
            r += " " + node.defaultValueType;
          }
          if (node.defaultValue) {
            r += ' "' + node.defaultValue + '"';
          }
          options.state = WriterState.CloseTag;
          r += options.spaceBeforeSlash + ">" + this.endline(node, options, level);
          options.state = WriterState.None;
          this.closeNode(node, options, level);
          return r;
        };
        XMLWriterBase2.prototype.dtdElement = function(node, options, level) {
          var r;
          this.openNode(node, options, level);
          options.state = WriterState.OpenTag;
          r = this.indent(node, options, level) + "<!ELEMENT";
          options.state = WriterState.InsideTag;
          r += " " + node.name + " " + node.value;
          options.state = WriterState.CloseTag;
          r += options.spaceBeforeSlash + ">" + this.endline(node, options, level);
          options.state = WriterState.None;
          this.closeNode(node, options, level);
          return r;
        };
        XMLWriterBase2.prototype.dtdEntity = function(node, options, level) {
          var r;
          this.openNode(node, options, level);
          options.state = WriterState.OpenTag;
          r = this.indent(node, options, level) + "<!ENTITY";
          options.state = WriterState.InsideTag;
          if (node.pe) {
            r += " %";
          }
          r += " " + node.name;
          if (node.value) {
            r += ' "' + node.value + '"';
          } else {
            if (node.pubID && node.sysID) {
              r += ' PUBLIC "' + node.pubID + '" "' + node.sysID + '"';
            } else if (node.sysID) {
              r += ' SYSTEM "' + node.sysID + '"';
            }
            if (node.nData) {
              r += " NDATA " + node.nData;
            }
          }
          options.state = WriterState.CloseTag;
          r += options.spaceBeforeSlash + ">" + this.endline(node, options, level);
          options.state = WriterState.None;
          this.closeNode(node, options, level);
          return r;
        };
        XMLWriterBase2.prototype.dtdNotation = function(node, options, level) {
          var r;
          this.openNode(node, options, level);
          options.state = WriterState.OpenTag;
          r = this.indent(node, options, level) + "<!NOTATION";
          options.state = WriterState.InsideTag;
          r += " " + node.name;
          if (node.pubID && node.sysID) {
            r += ' PUBLIC "' + node.pubID + '" "' + node.sysID + '"';
          } else if (node.pubID) {
            r += ' PUBLIC "' + node.pubID + '"';
          } else if (node.sysID) {
            r += ' SYSTEM "' + node.sysID + '"';
          }
          options.state = WriterState.CloseTag;
          r += options.spaceBeforeSlash + ">" + this.endline(node, options, level);
          options.state = WriterState.None;
          this.closeNode(node, options, level);
          return r;
        };
        XMLWriterBase2.prototype.openNode = function(node, options, level) {
        };
        XMLWriterBase2.prototype.closeNode = function(node, options, level) {
        };
        XMLWriterBase2.prototype.openAttribute = function(att, options, level) {
        };
        XMLWriterBase2.prototype.closeAttribute = function(att, options, level) {
        };
        return XMLWriterBase2;
      })();
    }).call(exports2);
  }
});

// node_modules/xmlbuilder/lib/XMLStringWriter.js
var require_XMLStringWriter = __commonJS({
  "node_modules/xmlbuilder/lib/XMLStringWriter.js"(exports2, module2) {
    (function() {
      var XMLStringWriter, XMLWriterBase, extend = function(child, parent) {
        for (var key in parent) {
          if (hasProp.call(parent, key)) child[key] = parent[key];
        }
        function ctor() {
          this.constructor = child;
        }
        ctor.prototype = parent.prototype;
        child.prototype = new ctor();
        child.__super__ = parent.prototype;
        return child;
      }, hasProp = {}.hasOwnProperty;
      XMLWriterBase = require_XMLWriterBase();
      module2.exports = XMLStringWriter = (function(superClass) {
        extend(XMLStringWriter2, superClass);
        function XMLStringWriter2(options) {
          XMLStringWriter2.__super__.constructor.call(this, options);
        }
        XMLStringWriter2.prototype.document = function(doc, options) {
          var child, i, len, r, ref;
          options = this.filterOptions(options);
          r = "";
          ref = doc.children;
          for (i = 0, len = ref.length; i < len; i++) {
            child = ref[i];
            r += this.writeChildNode(child, options, 0);
          }
          if (options.pretty && r.slice(-options.newline.length) === options.newline) {
            r = r.slice(0, -options.newline.length);
          }
          return r;
        };
        return XMLStringWriter2;
      })(XMLWriterBase);
    }).call(exports2);
  }
});

// node_modules/xmlbuilder/lib/XMLDocument.js
var require_XMLDocument = __commonJS({
  "node_modules/xmlbuilder/lib/XMLDocument.js"(exports2, module2) {
    (function() {
      var NodeType, XMLDOMConfiguration, XMLDOMImplementation, XMLDocument, XMLNode, XMLStringWriter, XMLStringifier, isPlainObject, extend = function(child, parent) {
        for (var key in parent) {
          if (hasProp.call(parent, key)) child[key] = parent[key];
        }
        function ctor() {
          this.constructor = child;
        }
        ctor.prototype = parent.prototype;
        child.prototype = new ctor();
        child.__super__ = parent.prototype;
        return child;
      }, hasProp = {}.hasOwnProperty;
      isPlainObject = require_Utility().isPlainObject;
      XMLDOMImplementation = require_XMLDOMImplementation();
      XMLDOMConfiguration = require_XMLDOMConfiguration();
      XMLNode = require_XMLNode();
      NodeType = require_NodeType();
      XMLStringifier = require_XMLStringifier();
      XMLStringWriter = require_XMLStringWriter();
      module2.exports = XMLDocument = (function(superClass) {
        extend(XMLDocument2, superClass);
        function XMLDocument2(options) {
          XMLDocument2.__super__.constructor.call(this, null);
          this.name = "#document";
          this.type = NodeType.Document;
          this.documentURI = null;
          this.domConfig = new XMLDOMConfiguration();
          options || (options = {});
          if (!options.writer) {
            options.writer = new XMLStringWriter();
          }
          this.options = options;
          this.stringify = new XMLStringifier(options);
        }
        Object.defineProperty(XMLDocument2.prototype, "implementation", {
          value: new XMLDOMImplementation()
        });
        Object.defineProperty(XMLDocument2.prototype, "doctype", {
          get: function() {
            var child, i, len, ref;
            ref = this.children;
            for (i = 0, len = ref.length; i < len; i++) {
              child = ref[i];
              if (child.type === NodeType.DocType) {
                return child;
              }
            }
            return null;
          }
        });
        Object.defineProperty(XMLDocument2.prototype, "documentElement", {
          get: function() {
            return this.rootObject || null;
          }
        });
        Object.defineProperty(XMLDocument2.prototype, "inputEncoding", {
          get: function() {
            return null;
          }
        });
        Object.defineProperty(XMLDocument2.prototype, "strictErrorChecking", {
          get: function() {
            return false;
          }
        });
        Object.defineProperty(XMLDocument2.prototype, "xmlEncoding", {
          get: function() {
            if (this.children.length !== 0 && this.children[0].type === NodeType.Declaration) {
              return this.children[0].encoding;
            } else {
              return null;
            }
          }
        });
        Object.defineProperty(XMLDocument2.prototype, "xmlStandalone", {
          get: function() {
            if (this.children.length !== 0 && this.children[0].type === NodeType.Declaration) {
              return this.children[0].standalone === "yes";
            } else {
              return false;
            }
          }
        });
        Object.defineProperty(XMLDocument2.prototype, "xmlVersion", {
          get: function() {
            if (this.children.length !== 0 && this.children[0].type === NodeType.Declaration) {
              return this.children[0].version;
            } else {
              return "1.0";
            }
          }
        });
        Object.defineProperty(XMLDocument2.prototype, "URL", {
          get: function() {
            return this.documentURI;
          }
        });
        Object.defineProperty(XMLDocument2.prototype, "origin", {
          get: function() {
            return null;
          }
        });
        Object.defineProperty(XMLDocument2.prototype, "compatMode", {
          get: function() {
            return null;
          }
        });
        Object.defineProperty(XMLDocument2.prototype, "characterSet", {
          get: function() {
            return null;
          }
        });
        Object.defineProperty(XMLDocument2.prototype, "contentType", {
          get: function() {
            return null;
          }
        });
        XMLDocument2.prototype.end = function(writer) {
          var writerOptions;
          writerOptions = {};
          if (!writer) {
            writer = this.options.writer;
          } else if (isPlainObject(writer)) {
            writerOptions = writer;
            writer = this.options.writer;
          }
          return writer.document(this, writer.filterOptions(writerOptions));
        };
        XMLDocument2.prototype.toString = function(options) {
          return this.options.writer.document(this, this.options.writer.filterOptions(options));
        };
        XMLDocument2.prototype.createElement = function(tagName) {
          throw new Error("This DOM method is not implemented." + this.debugInfo());
        };
        XMLDocument2.prototype.createDocumentFragment = function() {
          throw new Error("This DOM method is not implemented." + this.debugInfo());
        };
        XMLDocument2.prototype.createTextNode = function(data) {
          throw new Error("This DOM method is not implemented." + this.debugInfo());
        };
        XMLDocument2.prototype.createComment = function(data) {
          throw new Error("This DOM method is not implemented." + this.debugInfo());
        };
        XMLDocument2.prototype.createCDATASection = function(data) {
          throw new Error("This DOM method is not implemented." + this.debugInfo());
        };
        XMLDocument2.prototype.createProcessingInstruction = function(target, data) {
          throw new Error("This DOM method is not implemented." + this.debugInfo());
        };
        XMLDocument2.prototype.createAttribute = function(name) {
          throw new Error("This DOM method is not implemented." + this.debugInfo());
        };
        XMLDocument2.prototype.createEntityReference = function(name) {
          throw new Error("This DOM method is not implemented." + this.debugInfo());
        };
        XMLDocument2.prototype.getElementsByTagName = function(tagname) {
          throw new Error("This DOM method is not implemented." + this.debugInfo());
        };
        XMLDocument2.prototype.importNode = function(importedNode, deep) {
          throw new Error("This DOM method is not implemented." + this.debugInfo());
        };
        XMLDocument2.prototype.createElementNS = function(namespaceURI, qualifiedName) {
          throw new Error("This DOM method is not implemented." + this.debugInfo());
        };
        XMLDocument2.prototype.createAttributeNS = function(namespaceURI, qualifiedName) {
          throw new Error("This DOM method is not implemented." + this.debugInfo());
        };
        XMLDocument2.prototype.getElementsByTagNameNS = function(namespaceURI, localName) {
          throw new Error("This DOM method is not implemented." + this.debugInfo());
        };
        XMLDocument2.prototype.getElementById = function(elementId) {
          throw new Error("This DOM method is not implemented." + this.debugInfo());
        };
        XMLDocument2.prototype.adoptNode = function(source) {
          throw new Error("This DOM method is not implemented." + this.debugInfo());
        };
        XMLDocument2.prototype.normalizeDocument = function() {
          throw new Error("This DOM method is not implemented." + this.debugInfo());
        };
        XMLDocument2.prototype.renameNode = function(node, namespaceURI, qualifiedName) {
          throw new Error("This DOM method is not implemented." + this.debugInfo());
        };
        XMLDocument2.prototype.getElementsByClassName = function(classNames) {
          throw new Error("This DOM method is not implemented." + this.debugInfo());
        };
        XMLDocument2.prototype.createEvent = function(eventInterface) {
          throw new Error("This DOM method is not implemented." + this.debugInfo());
        };
        XMLDocument2.prototype.createRange = function() {
          throw new Error("This DOM method is not implemented." + this.debugInfo());
        };
        XMLDocument2.prototype.createNodeIterator = function(root, whatToShow, filter) {
          throw new Error("This DOM method is not implemented." + this.debugInfo());
        };
        XMLDocument2.prototype.createTreeWalker = function(root, whatToShow, filter) {
          throw new Error("This DOM method is not implemented." + this.debugInfo());
        };
        return XMLDocument2;
      })(XMLNode);
    }).call(exports2);
  }
});

// node_modules/xmlbuilder/lib/XMLDocumentCB.js
var require_XMLDocumentCB = __commonJS({
  "node_modules/xmlbuilder/lib/XMLDocumentCB.js"(exports2, module2) {
    (function() {
      var NodeType, WriterState, XMLAttribute, XMLCData, XMLComment, XMLDTDAttList, XMLDTDElement, XMLDTDEntity, XMLDTDNotation, XMLDeclaration, XMLDocType, XMLDocument, XMLDocumentCB, XMLElement, XMLProcessingInstruction, XMLRaw, XMLStringWriter, XMLStringifier, XMLText, getValue, isFunction, isObject, isPlainObject, ref, hasProp = {}.hasOwnProperty;
      ref = require_Utility(), isObject = ref.isObject, isFunction = ref.isFunction, isPlainObject = ref.isPlainObject, getValue = ref.getValue;
      NodeType = require_NodeType();
      XMLDocument = require_XMLDocument();
      XMLElement = require_XMLElement();
      XMLCData = require_XMLCData();
      XMLComment = require_XMLComment();
      XMLRaw = require_XMLRaw();
      XMLText = require_XMLText();
      XMLProcessingInstruction = require_XMLProcessingInstruction();
      XMLDeclaration = require_XMLDeclaration();
      XMLDocType = require_XMLDocType();
      XMLDTDAttList = require_XMLDTDAttList();
      XMLDTDEntity = require_XMLDTDEntity();
      XMLDTDElement = require_XMLDTDElement();
      XMLDTDNotation = require_XMLDTDNotation();
      XMLAttribute = require_XMLAttribute();
      XMLStringifier = require_XMLStringifier();
      XMLStringWriter = require_XMLStringWriter();
      WriterState = require_WriterState();
      module2.exports = XMLDocumentCB = (function() {
        function XMLDocumentCB2(options, onData, onEnd) {
          var writerOptions;
          this.name = "?xml";
          this.type = NodeType.Document;
          options || (options = {});
          writerOptions = {};
          if (!options.writer) {
            options.writer = new XMLStringWriter();
          } else if (isPlainObject(options.writer)) {
            writerOptions = options.writer;
            options.writer = new XMLStringWriter();
          }
          this.options = options;
          this.writer = options.writer;
          this.writerOptions = this.writer.filterOptions(writerOptions);
          this.stringify = new XMLStringifier(options);
          this.onDataCallback = onData || function() {
          };
          this.onEndCallback = onEnd || function() {
          };
          this.currentNode = null;
          this.currentLevel = -1;
          this.openTags = {};
          this.documentStarted = false;
          this.documentCompleted = false;
          this.root = null;
        }
        XMLDocumentCB2.prototype.createChildNode = function(node) {
          var att, attName, attributes, child, i, len, ref1, ref2;
          switch (node.type) {
            case NodeType.CData:
              this.cdata(node.value);
              break;
            case NodeType.Comment:
              this.comment(node.value);
              break;
            case NodeType.Element:
              attributes = {};
              ref1 = node.attribs;
              for (attName in ref1) {
                if (!hasProp.call(ref1, attName)) continue;
                att = ref1[attName];
                attributes[attName] = att.value;
              }
              this.node(node.name, attributes);
              break;
            case NodeType.Dummy:
              this.dummy();
              break;
            case NodeType.Raw:
              this.raw(node.value);
              break;
            case NodeType.Text:
              this.text(node.value);
              break;
            case NodeType.ProcessingInstruction:
              this.instruction(node.target, node.value);
              break;
            default:
              throw new Error("This XML node type is not supported in a JS object: " + node.constructor.name);
          }
          ref2 = node.children;
          for (i = 0, len = ref2.length; i < len; i++) {
            child = ref2[i];
            this.createChildNode(child);
            if (child.type === NodeType.Element) {
              this.up();
            }
          }
          return this;
        };
        XMLDocumentCB2.prototype.dummy = function() {
          return this;
        };
        XMLDocumentCB2.prototype.node = function(name, attributes, text) {
          var ref1;
          if (name == null) {
            throw new Error("Missing node name.");
          }
          if (this.root && this.currentLevel === -1) {
            throw new Error("Document can only have one root node. " + this.debugInfo(name));
          }
          this.openCurrent();
          name = getValue(name);
          if (attributes == null) {
            attributes = {};
          }
          attributes = getValue(attributes);
          if (!isObject(attributes)) {
            ref1 = [attributes, text], text = ref1[0], attributes = ref1[1];
          }
          this.currentNode = new XMLElement(this, name, attributes);
          this.currentNode.children = false;
          this.currentLevel++;
          this.openTags[this.currentLevel] = this.currentNode;
          if (text != null) {
            this.text(text);
          }
          return this;
        };
        XMLDocumentCB2.prototype.element = function(name, attributes, text) {
          var child, i, len, oldValidationFlag, ref1, root;
          if (this.currentNode && this.currentNode.type === NodeType.DocType) {
            this.dtdElement.apply(this, arguments);
          } else {
            if (Array.isArray(name) || isObject(name) || isFunction(name)) {
              oldValidationFlag = this.options.noValidation;
              this.options.noValidation = true;
              root = new XMLDocument(this.options).element("TEMP_ROOT");
              root.element(name);
              this.options.noValidation = oldValidationFlag;
              ref1 = root.children;
              for (i = 0, len = ref1.length; i < len; i++) {
                child = ref1[i];
                this.createChildNode(child);
                if (child.type === NodeType.Element) {
                  this.up();
                }
              }
            } else {
              this.node(name, attributes, text);
            }
          }
          return this;
        };
        XMLDocumentCB2.prototype.attribute = function(name, value) {
          var attName, attValue;
          if (!this.currentNode || this.currentNode.children) {
            throw new Error("att() can only be used immediately after an ele() call in callback mode. " + this.debugInfo(name));
          }
          if (name != null) {
            name = getValue(name);
          }
          if (isObject(name)) {
            for (attName in name) {
              if (!hasProp.call(name, attName)) continue;
              attValue = name[attName];
              this.attribute(attName, attValue);
            }
          } else {
            if (isFunction(value)) {
              value = value.apply();
            }
            if (this.options.keepNullAttributes && value == null) {
              this.currentNode.attribs[name] = new XMLAttribute(this, name, "");
            } else if (value != null) {
              this.currentNode.attribs[name] = new XMLAttribute(this, name, value);
            }
          }
          return this;
        };
        XMLDocumentCB2.prototype.text = function(value) {
          var node;
          this.openCurrent();
          node = new XMLText(this, value);
          this.onData(this.writer.text(node, this.writerOptions, this.currentLevel + 1), this.currentLevel + 1);
          return this;
        };
        XMLDocumentCB2.prototype.cdata = function(value) {
          var node;
          this.openCurrent();
          node = new XMLCData(this, value);
          this.onData(this.writer.cdata(node, this.writerOptions, this.currentLevel + 1), this.currentLevel + 1);
          return this;
        };
        XMLDocumentCB2.prototype.comment = function(value) {
          var node;
          this.openCurrent();
          node = new XMLComment(this, value);
          this.onData(this.writer.comment(node, this.writerOptions, this.currentLevel + 1), this.currentLevel + 1);
          return this;
        };
        XMLDocumentCB2.prototype.raw = function(value) {
          var node;
          this.openCurrent();
          node = new XMLRaw(this, value);
          this.onData(this.writer.raw(node, this.writerOptions, this.currentLevel + 1), this.currentLevel + 1);
          return this;
        };
        XMLDocumentCB2.prototype.instruction = function(target, value) {
          var i, insTarget, insValue, len, node;
          this.openCurrent();
          if (target != null) {
            target = getValue(target);
          }
          if (value != null) {
            value = getValue(value);
          }
          if (Array.isArray(target)) {
            for (i = 0, len = target.length; i < len; i++) {
              insTarget = target[i];
              this.instruction(insTarget);
            }
          } else if (isObject(target)) {
            for (insTarget in target) {
              if (!hasProp.call(target, insTarget)) continue;
              insValue = target[insTarget];
              this.instruction(insTarget, insValue);
            }
          } else {
            if (isFunction(value)) {
              value = value.apply();
            }
            node = new XMLProcessingInstruction(this, target, value);
            this.onData(this.writer.processingInstruction(node, this.writerOptions, this.currentLevel + 1), this.currentLevel + 1);
          }
          return this;
        };
        XMLDocumentCB2.prototype.declaration = function(version, encoding, standalone) {
          var node;
          this.openCurrent();
          if (this.documentStarted) {
            throw new Error("declaration() must be the first node.");
          }
          node = new XMLDeclaration(this, version, encoding, standalone);
          this.onData(this.writer.declaration(node, this.writerOptions, this.currentLevel + 1), this.currentLevel + 1);
          return this;
        };
        XMLDocumentCB2.prototype.doctype = function(root, pubID, sysID) {
          this.openCurrent();
          if (root == null) {
            throw new Error("Missing root node name.");
          }
          if (this.root) {
            throw new Error("dtd() must come before the root node.");
          }
          this.currentNode = new XMLDocType(this, pubID, sysID);
          this.currentNode.rootNodeName = root;
          this.currentNode.children = false;
          this.currentLevel++;
          this.openTags[this.currentLevel] = this.currentNode;
          return this;
        };
        XMLDocumentCB2.prototype.dtdElement = function(name, value) {
          var node;
          this.openCurrent();
          node = new XMLDTDElement(this, name, value);
          this.onData(this.writer.dtdElement(node, this.writerOptions, this.currentLevel + 1), this.currentLevel + 1);
          return this;
        };
        XMLDocumentCB2.prototype.attList = function(elementName, attributeName, attributeType, defaultValueType, defaultValue) {
          var node;
          this.openCurrent();
          node = new XMLDTDAttList(this, elementName, attributeName, attributeType, defaultValueType, defaultValue);
          this.onData(this.writer.dtdAttList(node, this.writerOptions, this.currentLevel + 1), this.currentLevel + 1);
          return this;
        };
        XMLDocumentCB2.prototype.entity = function(name, value) {
          var node;
          this.openCurrent();
          node = new XMLDTDEntity(this, false, name, value);
          this.onData(this.writer.dtdEntity(node, this.writerOptions, this.currentLevel + 1), this.currentLevel + 1);
          return this;
        };
        XMLDocumentCB2.prototype.pEntity = function(name, value) {
          var node;
          this.openCurrent();
          node = new XMLDTDEntity(this, true, name, value);
          this.onData(this.writer.dtdEntity(node, this.writerOptions, this.currentLevel + 1), this.currentLevel + 1);
          return this;
        };
        XMLDocumentCB2.prototype.notation = function(name, value) {
          var node;
          this.openCurrent();
          node = new XMLDTDNotation(this, name, value);
          this.onData(this.writer.dtdNotation(node, this.writerOptions, this.currentLevel + 1), this.currentLevel + 1);
          return this;
        };
        XMLDocumentCB2.prototype.up = function() {
          if (this.currentLevel < 0) {
            throw new Error("The document node has no parent.");
          }
          if (this.currentNode) {
            if (this.currentNode.children) {
              this.closeNode(this.currentNode);
            } else {
              this.openNode(this.currentNode);
            }
            this.currentNode = null;
          } else {
            this.closeNode(this.openTags[this.currentLevel]);
          }
          delete this.openTags[this.currentLevel];
          this.currentLevel--;
          return this;
        };
        XMLDocumentCB2.prototype.end = function() {
          while (this.currentLevel >= 0) {
            this.up();
          }
          return this.onEnd();
        };
        XMLDocumentCB2.prototype.openCurrent = function() {
          if (this.currentNode) {
            this.currentNode.children = true;
            return this.openNode(this.currentNode);
          }
        };
        XMLDocumentCB2.prototype.openNode = function(node) {
          var att, chunk, name, ref1;
          if (!node.isOpen) {
            if (!this.root && this.currentLevel === 0 && node.type === NodeType.Element) {
              this.root = node;
            }
            chunk = "";
            if (node.type === NodeType.Element) {
              this.writerOptions.state = WriterState.OpenTag;
              chunk = this.writer.indent(node, this.writerOptions, this.currentLevel) + "<" + node.name;
              ref1 = node.attribs;
              for (name in ref1) {
                if (!hasProp.call(ref1, name)) continue;
                att = ref1[name];
                chunk += this.writer.attribute(att, this.writerOptions, this.currentLevel);
              }
              chunk += (node.children ? ">" : "/>") + this.writer.endline(node, this.writerOptions, this.currentLevel);
              this.writerOptions.state = WriterState.InsideTag;
            } else {
              this.writerOptions.state = WriterState.OpenTag;
              chunk = this.writer.indent(node, this.writerOptions, this.currentLevel) + "<!DOCTYPE " + node.rootNodeName;
              if (node.pubID && node.sysID) {
                chunk += ' PUBLIC "' + node.pubID + '" "' + node.sysID + '"';
              } else if (node.sysID) {
                chunk += ' SYSTEM "' + node.sysID + '"';
              }
              if (node.children) {
                chunk += " [";
                this.writerOptions.state = WriterState.InsideTag;
              } else {
                this.writerOptions.state = WriterState.CloseTag;
                chunk += ">";
              }
              chunk += this.writer.endline(node, this.writerOptions, this.currentLevel);
            }
            this.onData(chunk, this.currentLevel);
            return node.isOpen = true;
          }
        };
        XMLDocumentCB2.prototype.closeNode = function(node) {
          var chunk;
          if (!node.isClosed) {
            chunk = "";
            this.writerOptions.state = WriterState.CloseTag;
            if (node.type === NodeType.Element) {
              chunk = this.writer.indent(node, this.writerOptions, this.currentLevel) + "</" + node.name + ">" + this.writer.endline(node, this.writerOptions, this.currentLevel);
            } else {
              chunk = this.writer.indent(node, this.writerOptions, this.currentLevel) + "]>" + this.writer.endline(node, this.writerOptions, this.currentLevel);
            }
            this.writerOptions.state = WriterState.None;
            this.onData(chunk, this.currentLevel);
            return node.isClosed = true;
          }
        };
        XMLDocumentCB2.prototype.onData = function(chunk, level) {
          this.documentStarted = true;
          return this.onDataCallback(chunk, level + 1);
        };
        XMLDocumentCB2.prototype.onEnd = function() {
          this.documentCompleted = true;
          return this.onEndCallback();
        };
        XMLDocumentCB2.prototype.debugInfo = function(name) {
          if (name == null) {
            return "";
          } else {
            return "node: <" + name + ">";
          }
        };
        XMLDocumentCB2.prototype.ele = function() {
          return this.element.apply(this, arguments);
        };
        XMLDocumentCB2.prototype.nod = function(name, attributes, text) {
          return this.node(name, attributes, text);
        };
        XMLDocumentCB2.prototype.txt = function(value) {
          return this.text(value);
        };
        XMLDocumentCB2.prototype.dat = function(value) {
          return this.cdata(value);
        };
        XMLDocumentCB2.prototype.com = function(value) {
          return this.comment(value);
        };
        XMLDocumentCB2.prototype.ins = function(target, value) {
          return this.instruction(target, value);
        };
        XMLDocumentCB2.prototype.dec = function(version, encoding, standalone) {
          return this.declaration(version, encoding, standalone);
        };
        XMLDocumentCB2.prototype.dtd = function(root, pubID, sysID) {
          return this.doctype(root, pubID, sysID);
        };
        XMLDocumentCB2.prototype.e = function(name, attributes, text) {
          return this.element(name, attributes, text);
        };
        XMLDocumentCB2.prototype.n = function(name, attributes, text) {
          return this.node(name, attributes, text);
        };
        XMLDocumentCB2.prototype.t = function(value) {
          return this.text(value);
        };
        XMLDocumentCB2.prototype.d = function(value) {
          return this.cdata(value);
        };
        XMLDocumentCB2.prototype.c = function(value) {
          return this.comment(value);
        };
        XMLDocumentCB2.prototype.r = function(value) {
          return this.raw(value);
        };
        XMLDocumentCB2.prototype.i = function(target, value) {
          return this.instruction(target, value);
        };
        XMLDocumentCB2.prototype.att = function() {
          if (this.currentNode && this.currentNode.type === NodeType.DocType) {
            return this.attList.apply(this, arguments);
          } else {
            return this.attribute.apply(this, arguments);
          }
        };
        XMLDocumentCB2.prototype.a = function() {
          if (this.currentNode && this.currentNode.type === NodeType.DocType) {
            return this.attList.apply(this, arguments);
          } else {
            return this.attribute.apply(this, arguments);
          }
        };
        XMLDocumentCB2.prototype.ent = function(name, value) {
          return this.entity(name, value);
        };
        XMLDocumentCB2.prototype.pent = function(name, value) {
          return this.pEntity(name, value);
        };
        XMLDocumentCB2.prototype.not = function(name, value) {
          return this.notation(name, value);
        };
        return XMLDocumentCB2;
      })();
    }).call(exports2);
  }
});

// node_modules/xmlbuilder/lib/XMLStreamWriter.js
var require_XMLStreamWriter = __commonJS({
  "node_modules/xmlbuilder/lib/XMLStreamWriter.js"(exports2, module2) {
    (function() {
      var NodeType, WriterState, XMLStreamWriter, XMLWriterBase, extend = function(child, parent) {
        for (var key in parent) {
          if (hasProp.call(parent, key)) child[key] = parent[key];
        }
        function ctor() {
          this.constructor = child;
        }
        ctor.prototype = parent.prototype;
        child.prototype = new ctor();
        child.__super__ = parent.prototype;
        return child;
      }, hasProp = {}.hasOwnProperty;
      NodeType = require_NodeType();
      XMLWriterBase = require_XMLWriterBase();
      WriterState = require_WriterState();
      module2.exports = XMLStreamWriter = (function(superClass) {
        extend(XMLStreamWriter2, superClass);
        function XMLStreamWriter2(stream, options) {
          this.stream = stream;
          XMLStreamWriter2.__super__.constructor.call(this, options);
        }
        XMLStreamWriter2.prototype.endline = function(node, options, level) {
          if (node.isLastRootNode && options.state === WriterState.CloseTag) {
            return "";
          } else {
            return XMLStreamWriter2.__super__.endline.call(this, node, options, level);
          }
        };
        XMLStreamWriter2.prototype.document = function(doc, options) {
          var child, i, j, k, len, len1, ref, ref1, results;
          ref = doc.children;
          for (i = j = 0, len = ref.length; j < len; i = ++j) {
            child = ref[i];
            child.isLastRootNode = i === doc.children.length - 1;
          }
          options = this.filterOptions(options);
          ref1 = doc.children;
          results = [];
          for (k = 0, len1 = ref1.length; k < len1; k++) {
            child = ref1[k];
            results.push(this.writeChildNode(child, options, 0));
          }
          return results;
        };
        XMLStreamWriter2.prototype.attribute = function(att, options, level) {
          return this.stream.write(XMLStreamWriter2.__super__.attribute.call(this, att, options, level));
        };
        XMLStreamWriter2.prototype.cdata = function(node, options, level) {
          return this.stream.write(XMLStreamWriter2.__super__.cdata.call(this, node, options, level));
        };
        XMLStreamWriter2.prototype.comment = function(node, options, level) {
          return this.stream.write(XMLStreamWriter2.__super__.comment.call(this, node, options, level));
        };
        XMLStreamWriter2.prototype.declaration = function(node, options, level) {
          return this.stream.write(XMLStreamWriter2.__super__.declaration.call(this, node, options, level));
        };
        XMLStreamWriter2.prototype.docType = function(node, options, level) {
          var child, j, len, ref;
          level || (level = 0);
          this.openNode(node, options, level);
          options.state = WriterState.OpenTag;
          this.stream.write(this.indent(node, options, level));
          this.stream.write("<!DOCTYPE " + node.root().name);
          if (node.pubID && node.sysID) {
            this.stream.write(' PUBLIC "' + node.pubID + '" "' + node.sysID + '"');
          } else if (node.sysID) {
            this.stream.write(' SYSTEM "' + node.sysID + '"');
          }
          if (node.children.length > 0) {
            this.stream.write(" [");
            this.stream.write(this.endline(node, options, level));
            options.state = WriterState.InsideTag;
            ref = node.children;
            for (j = 0, len = ref.length; j < len; j++) {
              child = ref[j];
              this.writeChildNode(child, options, level + 1);
            }
            options.state = WriterState.CloseTag;
            this.stream.write("]");
          }
          options.state = WriterState.CloseTag;
          this.stream.write(options.spaceBeforeSlash + ">");
          this.stream.write(this.endline(node, options, level));
          options.state = WriterState.None;
          return this.closeNode(node, options, level);
        };
        XMLStreamWriter2.prototype.element = function(node, options, level) {
          var att, child, childNodeCount, firstChildNode, j, len, name, prettySuppressed, ref, ref1;
          level || (level = 0);
          this.openNode(node, options, level);
          options.state = WriterState.OpenTag;
          this.stream.write(this.indent(node, options, level) + "<" + node.name);
          ref = node.attribs;
          for (name in ref) {
            if (!hasProp.call(ref, name)) continue;
            att = ref[name];
            this.attribute(att, options, level);
          }
          childNodeCount = node.children.length;
          firstChildNode = childNodeCount === 0 ? null : node.children[0];
          if (childNodeCount === 0 || node.children.every(function(e) {
            return (e.type === NodeType.Text || e.type === NodeType.Raw) && e.value === "";
          })) {
            if (options.allowEmpty) {
              this.stream.write(">");
              options.state = WriterState.CloseTag;
              this.stream.write("</" + node.name + ">");
            } else {
              options.state = WriterState.CloseTag;
              this.stream.write(options.spaceBeforeSlash + "/>");
            }
          } else if (options.pretty && childNodeCount === 1 && (firstChildNode.type === NodeType.Text || firstChildNode.type === NodeType.Raw) && firstChildNode.value != null) {
            this.stream.write(">");
            options.state = WriterState.InsideTag;
            options.suppressPrettyCount++;
            prettySuppressed = true;
            this.writeChildNode(firstChildNode, options, level + 1);
            options.suppressPrettyCount--;
            prettySuppressed = false;
            options.state = WriterState.CloseTag;
            this.stream.write("</" + node.name + ">");
          } else {
            this.stream.write(">" + this.endline(node, options, level));
            options.state = WriterState.InsideTag;
            ref1 = node.children;
            for (j = 0, len = ref1.length; j < len; j++) {
              child = ref1[j];
              this.writeChildNode(child, options, level + 1);
            }
            options.state = WriterState.CloseTag;
            this.stream.write(this.indent(node, options, level) + "</" + node.name + ">");
          }
          this.stream.write(this.endline(node, options, level));
          options.state = WriterState.None;
          return this.closeNode(node, options, level);
        };
        XMLStreamWriter2.prototype.processingInstruction = function(node, options, level) {
          return this.stream.write(XMLStreamWriter2.__super__.processingInstruction.call(this, node, options, level));
        };
        XMLStreamWriter2.prototype.raw = function(node, options, level) {
          return this.stream.write(XMLStreamWriter2.__super__.raw.call(this, node, options, level));
        };
        XMLStreamWriter2.prototype.text = function(node, options, level) {
          return this.stream.write(XMLStreamWriter2.__super__.text.call(this, node, options, level));
        };
        XMLStreamWriter2.prototype.dtdAttList = function(node, options, level) {
          return this.stream.write(XMLStreamWriter2.__super__.dtdAttList.call(this, node, options, level));
        };
        XMLStreamWriter2.prototype.dtdElement = function(node, options, level) {
          return this.stream.write(XMLStreamWriter2.__super__.dtdElement.call(this, node, options, level));
        };
        XMLStreamWriter2.prototype.dtdEntity = function(node, options, level) {
          return this.stream.write(XMLStreamWriter2.__super__.dtdEntity.call(this, node, options, level));
        };
        XMLStreamWriter2.prototype.dtdNotation = function(node, options, level) {
          return this.stream.write(XMLStreamWriter2.__super__.dtdNotation.call(this, node, options, level));
        };
        return XMLStreamWriter2;
      })(XMLWriterBase);
    }).call(exports2);
  }
});

// node_modules/xmlbuilder/lib/index.js
var require_lib2 = __commonJS({
  "node_modules/xmlbuilder/lib/index.js"(exports2, module2) {
    (function() {
      var NodeType, WriterState, XMLDOMImplementation, XMLDocument, XMLDocumentCB, XMLStreamWriter, XMLStringWriter, assign, isFunction, ref;
      ref = require_Utility(), assign = ref.assign, isFunction = ref.isFunction;
      XMLDOMImplementation = require_XMLDOMImplementation();
      XMLDocument = require_XMLDocument();
      XMLDocumentCB = require_XMLDocumentCB();
      XMLStringWriter = require_XMLStringWriter();
      XMLStreamWriter = require_XMLStreamWriter();
      NodeType = require_NodeType();
      WriterState = require_WriterState();
      module2.exports.create = function(name, xmldec, doctype, options) {
        var doc, root;
        if (name == null) {
          throw new Error("Root element needs a name.");
        }
        options = assign({}, xmldec, doctype, options);
        doc = new XMLDocument(options);
        root = doc.element(name);
        if (!options.headless) {
          doc.declaration(options);
          if (options.pubID != null || options.sysID != null) {
            doc.dtd(options);
          }
        }
        return root;
      };
      module2.exports.begin = function(options, onData, onEnd) {
        var ref1;
        if (isFunction(options)) {
          ref1 = [options, onData], onData = ref1[0], onEnd = ref1[1];
          options = {};
        }
        if (onData) {
          return new XMLDocumentCB(options, onData, onEnd);
        } else {
          return new XMLDocument(options);
        }
      };
      module2.exports.stringWriter = function(options) {
        return new XMLStringWriter(options);
      };
      module2.exports.streamWriter = function(stream, options) {
        return new XMLStreamWriter(stream, options);
      };
      module2.exports.implementation = new XMLDOMImplementation();
      module2.exports.nodeType = NodeType;
      module2.exports.writerState = WriterState;
    }).call(exports2);
  }
});

// node_modules/xml2js/lib/builder.js
var require_builder = __commonJS({
  "node_modules/xml2js/lib/builder.js"(exports2) {
    (function() {
      "use strict";
      var builder, defaults, escapeCDATA, requiresCDATA, wrapCDATA, hasProp = {}.hasOwnProperty;
      builder = require_lib2();
      defaults = require_defaults().defaults;
      requiresCDATA = function(entry) {
        return typeof entry === "string" && (entry.indexOf("&") >= 0 || entry.indexOf(">") >= 0 || entry.indexOf("<") >= 0);
      };
      wrapCDATA = function(entry) {
        return "<![CDATA[" + escapeCDATA(entry) + "]]>";
      };
      escapeCDATA = function(entry) {
        return entry.replace("]]>", "]]]]><![CDATA[>");
      };
      exports2.Builder = (function() {
        function Builder(opts) {
          var key, ref, value;
          this.options = {};
          ref = defaults["0.2"];
          for (key in ref) {
            if (!hasProp.call(ref, key)) continue;
            value = ref[key];
            this.options[key] = value;
          }
          for (key in opts) {
            if (!hasProp.call(opts, key)) continue;
            value = opts[key];
            this.options[key] = value;
          }
        }
        Builder.prototype.buildObject = function(rootObj) {
          var attrkey, charkey, render, rootElement, rootName;
          attrkey = this.options.attrkey;
          charkey = this.options.charkey;
          if (Object.keys(rootObj).length === 1 && this.options.rootName === defaults["0.2"].rootName) {
            rootName = Object.keys(rootObj)[0];
            rootObj = rootObj[rootName];
          } else {
            rootName = this.options.rootName;
          }
          render = /* @__PURE__ */ (function(_this) {
            return function(element, obj) {
              var attr, child, entry, index, key, value;
              if (typeof obj !== "object") {
                if (_this.options.cdata && requiresCDATA(obj)) {
                  element.raw(wrapCDATA(obj));
                } else {
                  element.txt(obj);
                }
              } else if (Array.isArray(obj)) {
                for (index in obj) {
                  if (!hasProp.call(obj, index)) continue;
                  child = obj[index];
                  for (key in child) {
                    entry = child[key];
                    element = render(element.ele(key), entry).up();
                  }
                }
              } else {
                for (key in obj) {
                  if (!hasProp.call(obj, key)) continue;
                  child = obj[key];
                  if (key === attrkey) {
                    if (typeof child === "object") {
                      for (attr in child) {
                        value = child[attr];
                        element = element.att(attr, value);
                      }
                    }
                  } else if (key === charkey) {
                    if (_this.options.cdata && requiresCDATA(child)) {
                      element = element.raw(wrapCDATA(child));
                    } else {
                      element = element.txt(child);
                    }
                  } else if (Array.isArray(child)) {
                    for (index in child) {
                      if (!hasProp.call(child, index)) continue;
                      entry = child[index];
                      if (typeof entry === "string") {
                        if (_this.options.cdata && requiresCDATA(entry)) {
                          element = element.ele(key).raw(wrapCDATA(entry)).up();
                        } else {
                          element = element.ele(key, entry).up();
                        }
                      } else {
                        element = render(element.ele(key), entry).up();
                      }
                    }
                  } else if (typeof child === "object") {
                    element = render(element.ele(key), child).up();
                  } else {
                    if (typeof child === "string" && _this.options.cdata && requiresCDATA(child)) {
                      element = element.ele(key).raw(wrapCDATA(child)).up();
                    } else {
                      if (child == null) {
                        child = "";
                      }
                      element = element.ele(key, child.toString()).up();
                    }
                  }
                }
              }
              return element;
            };
          })(this);
          rootElement = builder.create(rootName, this.options.xmldec, this.options.doctype, {
            headless: this.options.headless,
            allowSurrogateChars: this.options.allowSurrogateChars
          });
          return render(rootElement, rootObj).end(this.options.renderOpts);
        };
        return Builder;
      })();
    }).call(exports2);
  }
});

// node_modules/sax/lib/sax.js
var require_sax = __commonJS({
  "node_modules/sax/lib/sax.js"(exports2) {
    (function(sax) {
      sax.parser = function(strict, opt) {
        return new SAXParser(strict, opt);
      };
      sax.SAXParser = SAXParser;
      sax.SAXStream = SAXStream;
      sax.createStream = createStream;
      sax.MAX_BUFFER_LENGTH = 64 * 1024;
      var buffers = [
        "comment",
        "sgmlDecl",
        "textNode",
        "tagName",
        "doctype",
        "procInstName",
        "procInstBody",
        "entity",
        "attribName",
        "attribValue",
        "cdata",
        "script"
      ];
      sax.EVENTS = [
        "text",
        "processinginstruction",
        "sgmldeclaration",
        "doctype",
        "comment",
        "opentagstart",
        "attribute",
        "opentag",
        "closetag",
        "opencdata",
        "cdata",
        "closecdata",
        "error",
        "end",
        "ready",
        "script",
        "opennamespace",
        "closenamespace"
      ];
      function SAXParser(strict, opt) {
        if (!(this instanceof SAXParser)) {
          return new SAXParser(strict, opt);
        }
        var parser = this;
        clearBuffers(parser);
        parser.q = parser.c = "";
        parser.bufferCheckPosition = sax.MAX_BUFFER_LENGTH;
        parser.opt = opt || {};
        parser.opt.lowercase = parser.opt.lowercase || parser.opt.lowercasetags;
        parser.looseCase = parser.opt.lowercase ? "toLowerCase" : "toUpperCase";
        parser.tags = [];
        parser.closed = parser.closedRoot = parser.sawRoot = false;
        parser.tag = parser.error = null;
        parser.strict = !!strict;
        parser.noscript = !!(strict || parser.opt.noscript);
        parser.state = S.BEGIN;
        parser.strictEntities = parser.opt.strictEntities;
        parser.ENTITIES = parser.strictEntities ? Object.create(sax.XML_ENTITIES) : Object.create(sax.ENTITIES);
        parser.attribList = [];
        if (parser.opt.xmlns) {
          parser.ns = Object.create(rootNS);
        }
        if (parser.opt.unquotedAttributeValues === void 0) {
          parser.opt.unquotedAttributeValues = !strict;
        }
        parser.trackPosition = parser.opt.position !== false;
        if (parser.trackPosition) {
          parser.position = parser.line = parser.column = 0;
        }
        emit(parser, "onready");
      }
      if (!Object.create) {
        Object.create = function(o) {
          function F() {
          }
          F.prototype = o;
          var newf = new F();
          return newf;
        };
      }
      if (!Object.keys) {
        Object.keys = function(o) {
          var a = [];
          for (var i in o) if (o.hasOwnProperty(i)) a.push(i);
          return a;
        };
      }
      function checkBufferLength(parser) {
        var maxAllowed = Math.max(sax.MAX_BUFFER_LENGTH, 10);
        var maxActual = 0;
        for (var i = 0, l = buffers.length; i < l; i++) {
          var len = parser[buffers[i]].length;
          if (len > maxAllowed) {
            switch (buffers[i]) {
              case "textNode":
                closeText(parser);
                break;
              case "cdata":
                emitNode(parser, "oncdata", parser.cdata);
                parser.cdata = "";
                break;
              case "script":
                emitNode(parser, "onscript", parser.script);
                parser.script = "";
                break;
              default:
                error(parser, "Max buffer length exceeded: " + buffers[i]);
            }
          }
          maxActual = Math.max(maxActual, len);
        }
        var m = sax.MAX_BUFFER_LENGTH - maxActual;
        parser.bufferCheckPosition = m + parser.position;
      }
      function clearBuffers(parser) {
        for (var i = 0, l = buffers.length; i < l; i++) {
          parser[buffers[i]] = "";
        }
      }
      function flushBuffers(parser) {
        closeText(parser);
        if (parser.cdata !== "") {
          emitNode(parser, "oncdata", parser.cdata);
          parser.cdata = "";
        }
        if (parser.script !== "") {
          emitNode(parser, "onscript", parser.script);
          parser.script = "";
        }
      }
      SAXParser.prototype = {
        end: function() {
          end(this);
        },
        write,
        resume: function() {
          this.error = null;
          return this;
        },
        close: function() {
          return this.write(null);
        },
        flush: function() {
          flushBuffers(this);
        }
      };
      var Stream;
      try {
        Stream = require("stream").Stream;
      } catch (ex) {
        Stream = function() {
        };
      }
      if (!Stream) Stream = function() {
      };
      var streamWraps = sax.EVENTS.filter(function(ev) {
        return ev !== "error" && ev !== "end";
      });
      function createStream(strict, opt) {
        return new SAXStream(strict, opt);
      }
      function SAXStream(strict, opt) {
        if (!(this instanceof SAXStream)) {
          return new SAXStream(strict, opt);
        }
        Stream.apply(this);
        this._parser = new SAXParser(strict, opt);
        this.writable = true;
        this.readable = true;
        var me = this;
        this._parser.onend = function() {
          me.emit("end");
        };
        this._parser.onerror = function(er) {
          me.emit("error", er);
          me._parser.error = null;
        };
        this._decoder = null;
        streamWraps.forEach(function(ev) {
          Object.defineProperty(me, "on" + ev, {
            get: function() {
              return me._parser["on" + ev];
            },
            set: function(h) {
              if (!h) {
                me.removeAllListeners(ev);
                me._parser["on" + ev] = h;
                return h;
              }
              me.on(ev, h);
            },
            enumerable: true,
            configurable: false
          });
        });
      }
      SAXStream.prototype = Object.create(Stream.prototype, {
        constructor: {
          value: SAXStream
        }
      });
      SAXStream.prototype.write = function(data) {
        if (typeof Buffer === "function" && typeof Buffer.isBuffer === "function" && Buffer.isBuffer(data)) {
          if (!this._decoder) {
            this._decoder = new TextDecoder("utf8");
          }
          data = this._decoder.decode(data, { stream: true });
        }
        this._parser.write(data.toString());
        this.emit("data", data);
        return true;
      };
      SAXStream.prototype.end = function(chunk) {
        if (chunk && chunk.length) {
          this.write(chunk);
        }
        if (this._decoder) {
          var remaining = this._decoder.decode();
          if (remaining) {
            this._parser.write(remaining);
            this.emit("data", remaining);
          }
        }
        this._parser.end();
        return true;
      };
      SAXStream.prototype.on = function(ev, handler) {
        var me = this;
        if (!me._parser["on" + ev] && streamWraps.indexOf(ev) !== -1) {
          me._parser["on" + ev] = function() {
            var args = arguments.length === 1 ? [arguments[0]] : Array.apply(null, arguments);
            args.splice(0, 0, ev);
            me.emit.apply(me, args);
          };
        }
        return Stream.prototype.on.call(me, ev, handler);
      };
      var CDATA = "[CDATA[";
      var DOCTYPE = "DOCTYPE";
      var XML_NAMESPACE = "http://www.w3.org/XML/1998/namespace";
      var XMLNS_NAMESPACE = "http://www.w3.org/2000/xmlns/";
      var rootNS = { xml: XML_NAMESPACE, xmlns: XMLNS_NAMESPACE };
      var nameStart = /[:_A-Za-z\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u02FF\u0370-\u037D\u037F-\u1FFF\u200C-\u200D\u2070-\u218F\u2C00-\u2FEF\u3001-\uD7FF\uF900-\uFDCF\uFDF0-\uFFFD]/;
      var nameBody = /[:_A-Za-z\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u02FF\u0370-\u037D\u037F-\u1FFF\u200C-\u200D\u2070-\u218F\u2C00-\u2FEF\u3001-\uD7FF\uF900-\uFDCF\uFDF0-\uFFFD\u00B7\u0300-\u036F\u203F-\u2040.\d-]/;
      var entityStart = /[#:_A-Za-z\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u02FF\u0370-\u037D\u037F-\u1FFF\u200C-\u200D\u2070-\u218F\u2C00-\u2FEF\u3001-\uD7FF\uF900-\uFDCF\uFDF0-\uFFFD]/;
      var entityBody = /[#:_A-Za-z\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u02FF\u0370-\u037D\u037F-\u1FFF\u200C-\u200D\u2070-\u218F\u2C00-\u2FEF\u3001-\uD7FF\uF900-\uFDCF\uFDF0-\uFFFD\u00B7\u0300-\u036F\u203F-\u2040.\d-]/;
      function isWhitespace(c) {
        return c === " " || c === "\n" || c === "\r" || c === "	";
      }
      function isQuote(c) {
        return c === '"' || c === "'";
      }
      function isAttribEnd(c) {
        return c === ">" || isWhitespace(c);
      }
      function isMatch(regex, c) {
        return regex.test(c);
      }
      function notMatch(regex, c) {
        return !isMatch(regex, c);
      }
      var S = 0;
      sax.STATE = {
        BEGIN: S++,
        // leading byte order mark or whitespace
        BEGIN_WHITESPACE: S++,
        // leading whitespace
        TEXT: S++,
        // general stuff
        TEXT_ENTITY: S++,
        // &amp and such.
        OPEN_WAKA: S++,
        // <
        SGML_DECL: S++,
        // <!BLARG
        SGML_DECL_QUOTED: S++,
        // <!BLARG foo "bar
        DOCTYPE: S++,
        // <!DOCTYPE
        DOCTYPE_QUOTED: S++,
        // <!DOCTYPE "//blah
        DOCTYPE_DTD: S++,
        // <!DOCTYPE "//blah" [ ...
        DOCTYPE_DTD_QUOTED: S++,
        // <!DOCTYPE "//blah" [ "foo
        COMMENT_STARTING: S++,
        // <!-
        COMMENT: S++,
        // <!--
        COMMENT_ENDING: S++,
        // <!-- blah -
        COMMENT_ENDED: S++,
        // <!-- blah --
        CDATA: S++,
        // <![CDATA[ something
        CDATA_ENDING: S++,
        // ]
        CDATA_ENDING_2: S++,
        // ]]
        PROC_INST: S++,
        // <?hi
        PROC_INST_BODY: S++,
        // <?hi there
        PROC_INST_ENDING: S++,
        // <?hi "there" ?
        OPEN_TAG: S++,
        // <strong
        OPEN_TAG_SLASH: S++,
        // <strong /
        ATTRIB: S++,
        // <a
        ATTRIB_NAME: S++,
        // <a foo
        ATTRIB_NAME_SAW_WHITE: S++,
        // <a foo _
        ATTRIB_VALUE: S++,
        // <a foo=
        ATTRIB_VALUE_QUOTED: S++,
        // <a foo="bar
        ATTRIB_VALUE_CLOSED: S++,
        // <a foo="bar"
        ATTRIB_VALUE_UNQUOTED: S++,
        // <a foo=bar
        ATTRIB_VALUE_ENTITY_Q: S++,
        // <foo bar="&quot;"
        ATTRIB_VALUE_ENTITY_U: S++,
        // <foo bar=&quot
        CLOSE_TAG: S++,
        // </a
        CLOSE_TAG_SAW_WHITE: S++,
        // </a   >
        SCRIPT: S++,
        // <script> ...
        SCRIPT_ENDING: S++
        // <script> ... <
      };
      sax.XML_ENTITIES = {
        amp: "&",
        gt: ">",
        lt: "<",
        quot: '"',
        apos: "'"
      };
      sax.ENTITIES = {
        amp: "&",
        gt: ">",
        lt: "<",
        quot: '"',
        apos: "'",
        AElig: 198,
        Aacute: 193,
        Acirc: 194,
        Agrave: 192,
        Aring: 197,
        Atilde: 195,
        Auml: 196,
        Ccedil: 199,
        ETH: 208,
        Eacute: 201,
        Ecirc: 202,
        Egrave: 200,
        Euml: 203,
        Iacute: 205,
        Icirc: 206,
        Igrave: 204,
        Iuml: 207,
        Ntilde: 209,
        Oacute: 211,
        Ocirc: 212,
        Ograve: 210,
        Oslash: 216,
        Otilde: 213,
        Ouml: 214,
        THORN: 222,
        Uacute: 218,
        Ucirc: 219,
        Ugrave: 217,
        Uuml: 220,
        Yacute: 221,
        aacute: 225,
        acirc: 226,
        aelig: 230,
        agrave: 224,
        aring: 229,
        atilde: 227,
        auml: 228,
        ccedil: 231,
        eacute: 233,
        ecirc: 234,
        egrave: 232,
        eth: 240,
        euml: 235,
        iacute: 237,
        icirc: 238,
        igrave: 236,
        iuml: 239,
        ntilde: 241,
        oacute: 243,
        ocirc: 244,
        ograve: 242,
        oslash: 248,
        otilde: 245,
        ouml: 246,
        szlig: 223,
        thorn: 254,
        uacute: 250,
        ucirc: 251,
        ugrave: 249,
        uuml: 252,
        yacute: 253,
        yuml: 255,
        copy: 169,
        reg: 174,
        nbsp: 160,
        iexcl: 161,
        cent: 162,
        pound: 163,
        curren: 164,
        yen: 165,
        brvbar: 166,
        sect: 167,
        uml: 168,
        ordf: 170,
        laquo: 171,
        not: 172,
        shy: 173,
        macr: 175,
        deg: 176,
        plusmn: 177,
        sup1: 185,
        sup2: 178,
        sup3: 179,
        acute: 180,
        micro: 181,
        para: 182,
        middot: 183,
        cedil: 184,
        ordm: 186,
        raquo: 187,
        frac14: 188,
        frac12: 189,
        frac34: 190,
        iquest: 191,
        times: 215,
        divide: 247,
        OElig: 338,
        oelig: 339,
        Scaron: 352,
        scaron: 353,
        Yuml: 376,
        fnof: 402,
        circ: 710,
        tilde: 732,
        Alpha: 913,
        Beta: 914,
        Gamma: 915,
        Delta: 916,
        Epsilon: 917,
        Zeta: 918,
        Eta: 919,
        Theta: 920,
        Iota: 921,
        Kappa: 922,
        Lambda: 923,
        Mu: 924,
        Nu: 925,
        Xi: 926,
        Omicron: 927,
        Pi: 928,
        Rho: 929,
        Sigma: 931,
        Tau: 932,
        Upsilon: 933,
        Phi: 934,
        Chi: 935,
        Psi: 936,
        Omega: 937,
        alpha: 945,
        beta: 946,
        gamma: 947,
        delta: 948,
        epsilon: 949,
        zeta: 950,
        eta: 951,
        theta: 952,
        iota: 953,
        kappa: 954,
        lambda: 955,
        mu: 956,
        nu: 957,
        xi: 958,
        omicron: 959,
        pi: 960,
        rho: 961,
        sigmaf: 962,
        sigma: 963,
        tau: 964,
        upsilon: 965,
        phi: 966,
        chi: 967,
        psi: 968,
        omega: 969,
        thetasym: 977,
        upsih: 978,
        piv: 982,
        ensp: 8194,
        emsp: 8195,
        thinsp: 8201,
        zwnj: 8204,
        zwj: 8205,
        lrm: 8206,
        rlm: 8207,
        ndash: 8211,
        mdash: 8212,
        lsquo: 8216,
        rsquo: 8217,
        sbquo: 8218,
        ldquo: 8220,
        rdquo: 8221,
        bdquo: 8222,
        dagger: 8224,
        Dagger: 8225,
        bull: 8226,
        hellip: 8230,
        permil: 8240,
        prime: 8242,
        Prime: 8243,
        lsaquo: 8249,
        rsaquo: 8250,
        oline: 8254,
        frasl: 8260,
        euro: 8364,
        image: 8465,
        weierp: 8472,
        real: 8476,
        trade: 8482,
        alefsym: 8501,
        larr: 8592,
        uarr: 8593,
        rarr: 8594,
        darr: 8595,
        harr: 8596,
        crarr: 8629,
        lArr: 8656,
        uArr: 8657,
        rArr: 8658,
        dArr: 8659,
        hArr: 8660,
        forall: 8704,
        part: 8706,
        exist: 8707,
        empty: 8709,
        nabla: 8711,
        isin: 8712,
        notin: 8713,
        ni: 8715,
        prod: 8719,
        sum: 8721,
        minus: 8722,
        lowast: 8727,
        radic: 8730,
        prop: 8733,
        infin: 8734,
        ang: 8736,
        and: 8743,
        or: 8744,
        cap: 8745,
        cup: 8746,
        int: 8747,
        there4: 8756,
        sim: 8764,
        cong: 8773,
        asymp: 8776,
        ne: 8800,
        equiv: 8801,
        le: 8804,
        ge: 8805,
        sub: 8834,
        sup: 8835,
        nsub: 8836,
        sube: 8838,
        supe: 8839,
        oplus: 8853,
        otimes: 8855,
        perp: 8869,
        sdot: 8901,
        lceil: 8968,
        rceil: 8969,
        lfloor: 8970,
        rfloor: 8971,
        lang: 9001,
        rang: 9002,
        loz: 9674,
        spades: 9824,
        clubs: 9827,
        hearts: 9829,
        diams: 9830
      };
      Object.keys(sax.ENTITIES).forEach(function(key) {
        var e = sax.ENTITIES[key];
        var s2 = typeof e === "number" ? String.fromCharCode(e) : e;
        sax.ENTITIES[key] = s2;
      });
      for (var s in sax.STATE) {
        sax.STATE[sax.STATE[s]] = s;
      }
      S = sax.STATE;
      function emit(parser, event, data) {
        parser[event] && parser[event](data);
      }
      function emitNode(parser, nodeType, data) {
        if (parser.textNode) closeText(parser);
        emit(parser, nodeType, data);
      }
      function closeText(parser) {
        parser.textNode = textopts(parser.opt, parser.textNode);
        if (parser.textNode) emit(parser, "ontext", parser.textNode);
        parser.textNode = "";
      }
      function textopts(opt, text) {
        if (opt.trim) text = text.trim();
        if (opt.normalize) text = text.replace(/\s+/g, " ");
        return text;
      }
      function error(parser, er) {
        closeText(parser);
        if (parser.trackPosition) {
          er += "\nLine: " + parser.line + "\nColumn: " + parser.column + "\nChar: " + parser.c;
        }
        er = new Error(er);
        parser.error = er;
        emit(parser, "onerror", er);
        return parser;
      }
      function end(parser) {
        if (parser.sawRoot && !parser.closedRoot)
          strictFail(parser, "Unclosed root tag");
        if (parser.state !== S.BEGIN && parser.state !== S.BEGIN_WHITESPACE && parser.state !== S.TEXT) {
          error(parser, "Unexpected end");
        }
        closeText(parser);
        parser.c = "";
        parser.closed = true;
        emit(parser, "onend");
        SAXParser.call(parser, parser.strict, parser.opt);
        return parser;
      }
      function strictFail(parser, message) {
        if (typeof parser !== "object" || !(parser instanceof SAXParser)) {
          throw new Error("bad call to strictFail");
        }
        if (parser.strict) {
          error(parser, message);
        }
      }
      function newTag(parser) {
        if (!parser.strict) parser.tagName = parser.tagName[parser.looseCase]();
        var parent = parser.tags[parser.tags.length - 1] || parser;
        var tag = parser.tag = { name: parser.tagName, attributes: {} };
        if (parser.opt.xmlns) {
          tag.ns = parent.ns;
        }
        parser.attribList.length = 0;
        emitNode(parser, "onopentagstart", tag);
      }
      function qname(name, attribute) {
        var i = name.indexOf(":");
        var qualName = i < 0 ? ["", name] : name.split(":");
        var prefix = qualName[0];
        var local = qualName[1];
        if (attribute && name === "xmlns") {
          prefix = "xmlns";
          local = "";
        }
        return { prefix, local };
      }
      function attrib(parser) {
        if (!parser.strict) {
          parser.attribName = parser.attribName[parser.looseCase]();
        }
        if (parser.attribList.indexOf(parser.attribName) !== -1 || parser.tag.attributes.hasOwnProperty(parser.attribName)) {
          parser.attribName = parser.attribValue = "";
          return;
        }
        if (parser.opt.xmlns) {
          var qn = qname(parser.attribName, true);
          var prefix = qn.prefix;
          var local = qn.local;
          if (prefix === "xmlns") {
            if (local === "xml" && parser.attribValue !== XML_NAMESPACE) {
              strictFail(
                parser,
                "xml: prefix must be bound to " + XML_NAMESPACE + "\nActual: " + parser.attribValue
              );
            } else if (local === "xmlns" && parser.attribValue !== XMLNS_NAMESPACE) {
              strictFail(
                parser,
                "xmlns: prefix must be bound to " + XMLNS_NAMESPACE + "\nActual: " + parser.attribValue
              );
            } else {
              var tag = parser.tag;
              var parent = parser.tags[parser.tags.length - 1] || parser;
              if (tag.ns === parent.ns) {
                tag.ns = Object.create(parent.ns);
              }
              tag.ns[local] = parser.attribValue;
            }
          }
          parser.attribList.push([parser.attribName, parser.attribValue]);
        } else {
          parser.tag.attributes[parser.attribName] = parser.attribValue;
          emitNode(parser, "onattribute", {
            name: parser.attribName,
            value: parser.attribValue
          });
        }
        parser.attribName = parser.attribValue = "";
      }
      function openTag(parser, selfClosing) {
        if (parser.opt.xmlns) {
          var tag = parser.tag;
          var qn = qname(parser.tagName);
          tag.prefix = qn.prefix;
          tag.local = qn.local;
          tag.uri = tag.ns[qn.prefix] || "";
          if (tag.prefix && !tag.uri) {
            strictFail(
              parser,
              "Unbound namespace prefix: " + JSON.stringify(parser.tagName)
            );
            tag.uri = qn.prefix;
          }
          var parent = parser.tags[parser.tags.length - 1] || parser;
          if (tag.ns && parent.ns !== tag.ns) {
            Object.keys(tag.ns).forEach(function(p) {
              emitNode(parser, "onopennamespace", {
                prefix: p,
                uri: tag.ns[p]
              });
            });
          }
          for (var i = 0, l = parser.attribList.length; i < l; i++) {
            var nv = parser.attribList[i];
            var name = nv[0];
            var value = nv[1];
            var qualName = qname(name, true);
            var prefix = qualName.prefix;
            var local = qualName.local;
            var uri = prefix === "" ? "" : tag.ns[prefix] || "";
            var a = {
              name,
              value,
              prefix,
              local,
              uri
            };
            if (prefix && prefix !== "xmlns" && !uri) {
              strictFail(
                parser,
                "Unbound namespace prefix: " + JSON.stringify(prefix)
              );
              a.uri = prefix;
            }
            parser.tag.attributes[name] = a;
            emitNode(parser, "onattribute", a);
          }
          parser.attribList.length = 0;
        }
        parser.tag.isSelfClosing = !!selfClosing;
        parser.sawRoot = true;
        parser.tags.push(parser.tag);
        emitNode(parser, "onopentag", parser.tag);
        if (!selfClosing) {
          if (!parser.noscript && parser.tagName.toLowerCase() === "script") {
            parser.state = S.SCRIPT;
          } else {
            parser.state = S.TEXT;
          }
          parser.tag = null;
          parser.tagName = "";
        }
        parser.attribName = parser.attribValue = "";
        parser.attribList.length = 0;
      }
      function closeTag(parser) {
        if (!parser.tagName) {
          strictFail(parser, "Weird empty close tag.");
          parser.textNode += "</>";
          parser.state = S.TEXT;
          return;
        }
        if (parser.script) {
          if (parser.tagName !== "script") {
            parser.script += "</" + parser.tagName + ">";
            parser.tagName = "";
            parser.state = S.SCRIPT;
            return;
          }
          emitNode(parser, "onscript", parser.script);
          parser.script = "";
        }
        var t = parser.tags.length;
        var tagName = parser.tagName;
        if (!parser.strict) {
          tagName = tagName[parser.looseCase]();
        }
        var closeTo = tagName;
        while (t--) {
          var close = parser.tags[t];
          if (close.name !== closeTo) {
            strictFail(parser, "Unexpected close tag");
          } else {
            break;
          }
        }
        if (t < 0) {
          strictFail(parser, "Unmatched closing tag: " + parser.tagName);
          parser.textNode += "</" + parser.tagName + ">";
          parser.state = S.TEXT;
          return;
        }
        parser.tagName = tagName;
        var s2 = parser.tags.length;
        while (s2-- > t) {
          var tag = parser.tag = parser.tags.pop();
          parser.tagName = parser.tag.name;
          emitNode(parser, "onclosetag", parser.tagName);
          var x = {};
          for (var i in tag.ns) {
            x[i] = tag.ns[i];
          }
          var parent = parser.tags[parser.tags.length - 1] || parser;
          if (parser.opt.xmlns && tag.ns !== parent.ns) {
            Object.keys(tag.ns).forEach(function(p) {
              var n = tag.ns[p];
              emitNode(parser, "onclosenamespace", { prefix: p, uri: n });
            });
          }
        }
        if (t === 0) parser.closedRoot = true;
        parser.tagName = parser.attribValue = parser.attribName = "";
        parser.attribList.length = 0;
        parser.state = S.TEXT;
      }
      function parseEntity(parser) {
        var entity = parser.entity;
        var entityLC = entity.toLowerCase();
        var num;
        var numStr = "";
        if (parser.ENTITIES[entity]) {
          return parser.ENTITIES[entity];
        }
        if (parser.ENTITIES[entityLC]) {
          return parser.ENTITIES[entityLC];
        }
        entity = entityLC;
        if (entity.charAt(0) === "#") {
          if (entity.charAt(1) === "x") {
            entity = entity.slice(2);
            num = parseInt(entity, 16);
            numStr = num.toString(16);
          } else {
            entity = entity.slice(1);
            num = parseInt(entity, 10);
            numStr = num.toString(10);
          }
        }
        entity = entity.replace(/^0+/, "");
        if (isNaN(num) || numStr.toLowerCase() !== entity || num < 0 || num > 1114111) {
          strictFail(parser, "Invalid character entity");
          return "&" + parser.entity + ";";
        }
        return String.fromCodePoint(num);
      }
      function beginWhiteSpace(parser, c) {
        if (c === "<") {
          parser.state = S.OPEN_WAKA;
          parser.startTagPosition = parser.position;
        } else if (!isWhitespace(c)) {
          strictFail(parser, "Non-whitespace before first tag.");
          parser.textNode = c;
          parser.state = S.TEXT;
        }
      }
      function charAt(chunk, i) {
        var result = "";
        if (i < chunk.length) {
          result = chunk.charAt(i);
        }
        return result;
      }
      function write(chunk) {
        var parser = this;
        if (this.error) {
          throw this.error;
        }
        if (parser.closed) {
          return error(
            parser,
            "Cannot write after close. Assign an onready handler."
          );
        }
        if (chunk === null) {
          return end(parser);
        }
        if (typeof chunk === "object") {
          chunk = chunk.toString();
        }
        var i = 0;
        var c = "";
        while (true) {
          c = charAt(chunk, i++);
          parser.c = c;
          if (!c) {
            break;
          }
          if (parser.trackPosition) {
            parser.position++;
            if (c === "\n") {
              parser.line++;
              parser.column = 0;
            } else {
              parser.column++;
            }
          }
          switch (parser.state) {
            case S.BEGIN:
              parser.state = S.BEGIN_WHITESPACE;
              if (c === "\uFEFF") {
                continue;
              }
              beginWhiteSpace(parser, c);
              continue;
            case S.BEGIN_WHITESPACE:
              beginWhiteSpace(parser, c);
              continue;
            case S.TEXT:
              if (parser.sawRoot && !parser.closedRoot) {
                var starti = i - 1;
                while (c && c !== "<" && c !== "&") {
                  c = charAt(chunk, i++);
                  if (c && parser.trackPosition) {
                    parser.position++;
                    if (c === "\n") {
                      parser.line++;
                      parser.column = 0;
                    } else {
                      parser.column++;
                    }
                  }
                }
                parser.textNode += chunk.substring(starti, i - 1);
              }
              if (c === "<" && !(parser.sawRoot && parser.closedRoot && !parser.strict)) {
                parser.state = S.OPEN_WAKA;
                parser.startTagPosition = parser.position;
              } else {
                if (!isWhitespace(c) && (!parser.sawRoot || parser.closedRoot)) {
                  strictFail(parser, "Text data outside of root node.");
                }
                if (c === "&") {
                  parser.state = S.TEXT_ENTITY;
                } else {
                  parser.textNode += c;
                }
              }
              continue;
            case S.SCRIPT:
              if (c === "<") {
                parser.state = S.SCRIPT_ENDING;
              } else {
                parser.script += c;
              }
              continue;
            case S.SCRIPT_ENDING:
              if (c === "/") {
                parser.state = S.CLOSE_TAG;
              } else {
                parser.script += "<" + c;
                parser.state = S.SCRIPT;
              }
              continue;
            case S.OPEN_WAKA:
              if (c === "!") {
                parser.state = S.SGML_DECL;
                parser.sgmlDecl = "";
              } else if (isWhitespace(c)) {
              } else if (isMatch(nameStart, c)) {
                parser.state = S.OPEN_TAG;
                parser.tagName = c;
              } else if (c === "/") {
                parser.state = S.CLOSE_TAG;
                parser.tagName = "";
              } else if (c === "?") {
                parser.state = S.PROC_INST;
                parser.procInstName = parser.procInstBody = "";
              } else {
                strictFail(parser, "Unencoded <");
                if (parser.startTagPosition + 1 < parser.position) {
                  var pad = parser.position - parser.startTagPosition;
                  c = new Array(pad).join(" ") + c;
                }
                parser.textNode += "<" + c;
                parser.state = S.TEXT;
              }
              continue;
            case S.SGML_DECL:
              if (parser.sgmlDecl + c === "--") {
                parser.state = S.COMMENT;
                parser.comment = "";
                parser.sgmlDecl = "";
                continue;
              }
              if (parser.doctype && parser.doctype !== true && parser.sgmlDecl) {
                parser.state = S.DOCTYPE_DTD;
                parser.doctype += "<!" + parser.sgmlDecl + c;
                parser.sgmlDecl = "";
              } else if ((parser.sgmlDecl + c).toUpperCase() === CDATA) {
                emitNode(parser, "onopencdata");
                parser.state = S.CDATA;
                parser.sgmlDecl = "";
                parser.cdata = "";
              } else if ((parser.sgmlDecl + c).toUpperCase() === DOCTYPE) {
                parser.state = S.DOCTYPE;
                if (parser.doctype || parser.sawRoot) {
                  strictFail(
                    parser,
                    "Inappropriately located doctype declaration"
                  );
                }
                parser.doctype = "";
                parser.sgmlDecl = "";
              } else if (c === ">") {
                emitNode(parser, "onsgmldeclaration", parser.sgmlDecl);
                parser.sgmlDecl = "";
                parser.state = S.TEXT;
              } else if (isQuote(c)) {
                parser.state = S.SGML_DECL_QUOTED;
                parser.sgmlDecl += c;
              } else {
                parser.sgmlDecl += c;
              }
              continue;
            case S.SGML_DECL_QUOTED:
              if (c === parser.q) {
                parser.state = S.SGML_DECL;
                parser.q = "";
              }
              parser.sgmlDecl += c;
              continue;
            case S.DOCTYPE:
              if (c === ">") {
                parser.state = S.TEXT;
                emitNode(parser, "ondoctype", parser.doctype);
                parser.doctype = true;
              } else {
                parser.doctype += c;
                if (c === "[") {
                  parser.state = S.DOCTYPE_DTD;
                } else if (isQuote(c)) {
                  parser.state = S.DOCTYPE_QUOTED;
                  parser.q = c;
                }
              }
              continue;
            case S.DOCTYPE_QUOTED:
              parser.doctype += c;
              if (c === parser.q) {
                parser.q = "";
                parser.state = S.DOCTYPE;
              }
              continue;
            case S.DOCTYPE_DTD:
              if (c === "]") {
                parser.doctype += c;
                parser.state = S.DOCTYPE;
              } else if (c === "<") {
                parser.state = S.OPEN_WAKA;
                parser.startTagPosition = parser.position;
              } else if (isQuote(c)) {
                parser.doctype += c;
                parser.state = S.DOCTYPE_DTD_QUOTED;
                parser.q = c;
              } else {
                parser.doctype += c;
              }
              continue;
            case S.DOCTYPE_DTD_QUOTED:
              parser.doctype += c;
              if (c === parser.q) {
                parser.state = S.DOCTYPE_DTD;
                parser.q = "";
              }
              continue;
            case S.COMMENT:
              if (c === "-") {
                parser.state = S.COMMENT_ENDING;
              } else {
                parser.comment += c;
              }
              continue;
            case S.COMMENT_ENDING:
              if (c === "-") {
                parser.state = S.COMMENT_ENDED;
                parser.comment = textopts(parser.opt, parser.comment);
                if (parser.comment) {
                  emitNode(parser, "oncomment", parser.comment);
                }
                parser.comment = "";
              } else {
                parser.comment += "-" + c;
                parser.state = S.COMMENT;
              }
              continue;
            case S.COMMENT_ENDED:
              if (c !== ">") {
                strictFail(parser, "Malformed comment");
                parser.comment += "--" + c;
                parser.state = S.COMMENT;
              } else if (parser.doctype && parser.doctype !== true) {
                parser.state = S.DOCTYPE_DTD;
              } else {
                parser.state = S.TEXT;
              }
              continue;
            case S.CDATA:
              var starti = i - 1;
              while (c && c !== "]") {
                c = charAt(chunk, i++);
                if (c && parser.trackPosition) {
                  parser.position++;
                  if (c === "\n") {
                    parser.line++;
                    parser.column = 0;
                  } else {
                    parser.column++;
                  }
                }
              }
              parser.cdata += chunk.substring(starti, i - 1);
              if (c === "]") {
                parser.state = S.CDATA_ENDING;
              }
              continue;
            case S.CDATA_ENDING:
              if (c === "]") {
                parser.state = S.CDATA_ENDING_2;
              } else {
                parser.cdata += "]" + c;
                parser.state = S.CDATA;
              }
              continue;
            case S.CDATA_ENDING_2:
              if (c === ">") {
                if (parser.cdata) {
                  emitNode(parser, "oncdata", parser.cdata);
                }
                emitNode(parser, "onclosecdata");
                parser.cdata = "";
                parser.state = S.TEXT;
              } else if (c === "]") {
                parser.cdata += "]";
              } else {
                parser.cdata += "]]" + c;
                parser.state = S.CDATA;
              }
              continue;
            case S.PROC_INST:
              if (c === "?") {
                parser.state = S.PROC_INST_ENDING;
              } else if (isWhitespace(c)) {
                parser.state = S.PROC_INST_BODY;
              } else {
                parser.procInstName += c;
              }
              continue;
            case S.PROC_INST_BODY:
              if (!parser.procInstBody && isWhitespace(c)) {
                continue;
              } else if (c === "?") {
                parser.state = S.PROC_INST_ENDING;
              } else {
                parser.procInstBody += c;
              }
              continue;
            case S.PROC_INST_ENDING:
              if (c === ">") {
                emitNode(parser, "onprocessinginstruction", {
                  name: parser.procInstName,
                  body: parser.procInstBody
                });
                parser.procInstName = parser.procInstBody = "";
                parser.state = S.TEXT;
              } else {
                parser.procInstBody += "?" + c;
                parser.state = S.PROC_INST_BODY;
              }
              continue;
            case S.OPEN_TAG:
              if (isMatch(nameBody, c)) {
                parser.tagName += c;
              } else {
                newTag(parser);
                if (c === ">") {
                  openTag(parser);
                } else if (c === "/") {
                  parser.state = S.OPEN_TAG_SLASH;
                } else {
                  if (!isWhitespace(c)) {
                    strictFail(parser, "Invalid character in tag name");
                  }
                  parser.state = S.ATTRIB;
                }
              }
              continue;
            case S.OPEN_TAG_SLASH:
              if (c === ">") {
                openTag(parser, true);
                closeTag(parser);
              } else {
                strictFail(
                  parser,
                  "Forward-slash in opening tag not followed by >"
                );
                parser.state = S.ATTRIB;
              }
              continue;
            case S.ATTRIB:
              if (isWhitespace(c)) {
                continue;
              } else if (c === ">") {
                openTag(parser);
              } else if (c === "/") {
                parser.state = S.OPEN_TAG_SLASH;
              } else if (isMatch(nameStart, c)) {
                parser.attribName = c;
                parser.attribValue = "";
                parser.state = S.ATTRIB_NAME;
              } else {
                strictFail(parser, "Invalid attribute name");
              }
              continue;
            case S.ATTRIB_NAME:
              if (c === "=") {
                parser.state = S.ATTRIB_VALUE;
              } else if (c === ">") {
                strictFail(parser, "Attribute without value");
                parser.attribValue = parser.attribName;
                attrib(parser);
                openTag(parser);
              } else if (isWhitespace(c)) {
                parser.state = S.ATTRIB_NAME_SAW_WHITE;
              } else if (isMatch(nameBody, c)) {
                parser.attribName += c;
              } else {
                strictFail(parser, "Invalid attribute name");
              }
              continue;
            case S.ATTRIB_NAME_SAW_WHITE:
              if (c === "=") {
                parser.state = S.ATTRIB_VALUE;
              } else if (isWhitespace(c)) {
                continue;
              } else {
                strictFail(parser, "Attribute without value");
                parser.tag.attributes[parser.attribName] = "";
                parser.attribValue = "";
                emitNode(parser, "onattribute", {
                  name: parser.attribName,
                  value: ""
                });
                parser.attribName = "";
                if (c === ">") {
                  openTag(parser);
                } else if (isMatch(nameStart, c)) {
                  parser.attribName = c;
                  parser.state = S.ATTRIB_NAME;
                } else {
                  strictFail(parser, "Invalid attribute name");
                  parser.state = S.ATTRIB;
                }
              }
              continue;
            case S.ATTRIB_VALUE:
              if (isWhitespace(c)) {
                continue;
              } else if (isQuote(c)) {
                parser.q = c;
                parser.state = S.ATTRIB_VALUE_QUOTED;
              } else {
                if (!parser.opt.unquotedAttributeValues) {
                  error(parser, "Unquoted attribute value");
                }
                parser.state = S.ATTRIB_VALUE_UNQUOTED;
                parser.attribValue = c;
              }
              continue;
            case S.ATTRIB_VALUE_QUOTED:
              if (c !== parser.q) {
                if (c === "&") {
                  parser.state = S.ATTRIB_VALUE_ENTITY_Q;
                } else {
                  parser.attribValue += c;
                }
                continue;
              }
              attrib(parser);
              parser.q = "";
              parser.state = S.ATTRIB_VALUE_CLOSED;
              continue;
            case S.ATTRIB_VALUE_CLOSED:
              if (isWhitespace(c)) {
                parser.state = S.ATTRIB;
              } else if (c === ">") {
                openTag(parser);
              } else if (c === "/") {
                parser.state = S.OPEN_TAG_SLASH;
              } else if (isMatch(nameStart, c)) {
                strictFail(parser, "No whitespace between attributes");
                parser.attribName = c;
                parser.attribValue = "";
                parser.state = S.ATTRIB_NAME;
              } else {
                strictFail(parser, "Invalid attribute name");
              }
              continue;
            case S.ATTRIB_VALUE_UNQUOTED:
              if (!isAttribEnd(c)) {
                if (c === "&") {
                  parser.state = S.ATTRIB_VALUE_ENTITY_U;
                } else {
                  parser.attribValue += c;
                }
                continue;
              }
              attrib(parser);
              if (c === ">") {
                openTag(parser);
              } else {
                parser.state = S.ATTRIB;
              }
              continue;
            case S.CLOSE_TAG:
              if (!parser.tagName) {
                if (isWhitespace(c)) {
                  continue;
                } else if (notMatch(nameStart, c)) {
                  if (parser.script) {
                    parser.script += "</" + c;
                    parser.state = S.SCRIPT;
                  } else {
                    strictFail(parser, "Invalid tagname in closing tag.");
                  }
                } else {
                  parser.tagName = c;
                }
              } else if (c === ">") {
                closeTag(parser);
              } else if (isMatch(nameBody, c)) {
                parser.tagName += c;
              } else if (parser.script) {
                parser.script += "</" + parser.tagName + c;
                parser.tagName = "";
                parser.state = S.SCRIPT;
              } else {
                if (!isWhitespace(c)) {
                  strictFail(parser, "Invalid tagname in closing tag");
                }
                parser.state = S.CLOSE_TAG_SAW_WHITE;
              }
              continue;
            case S.CLOSE_TAG_SAW_WHITE:
              if (isWhitespace(c)) {
                continue;
              }
              if (c === ">") {
                closeTag(parser);
              } else {
                strictFail(parser, "Invalid characters in closing tag");
              }
              continue;
            case S.TEXT_ENTITY:
            case S.ATTRIB_VALUE_ENTITY_Q:
            case S.ATTRIB_VALUE_ENTITY_U:
              var returnState;
              var buffer;
              switch (parser.state) {
                case S.TEXT_ENTITY:
                  returnState = S.TEXT;
                  buffer = "textNode";
                  break;
                case S.ATTRIB_VALUE_ENTITY_Q:
                  returnState = S.ATTRIB_VALUE_QUOTED;
                  buffer = "attribValue";
                  break;
                case S.ATTRIB_VALUE_ENTITY_U:
                  returnState = S.ATTRIB_VALUE_UNQUOTED;
                  buffer = "attribValue";
                  break;
              }
              if (c === ";") {
                var parsedEntity = parseEntity(parser);
                if (parser.opt.unparsedEntities && !Object.values(sax.XML_ENTITIES).includes(parsedEntity)) {
                  parser.entity = "";
                  parser.state = returnState;
                  parser.write(parsedEntity);
                } else {
                  parser[buffer] += parsedEntity;
                  parser.entity = "";
                  parser.state = returnState;
                }
              } else if (isMatch(parser.entity.length ? entityBody : entityStart, c)) {
                parser.entity += c;
              } else {
                strictFail(parser, "Invalid character in entity name");
                parser[buffer] += "&" + parser.entity + c;
                parser.entity = "";
                parser.state = returnState;
              }
              continue;
            default: {
              throw new Error(parser, "Unknown state: " + parser.state);
            }
          }
        }
        if (parser.position >= parser.bufferCheckPosition) {
          checkBufferLength(parser);
        }
        return parser;
      }
      if (!String.fromCodePoint) {
        ;
        (function() {
          var stringFromCharCode = String.fromCharCode;
          var floor = Math.floor;
          var fromCodePoint = function() {
            var MAX_SIZE = 16384;
            var codeUnits = [];
            var highSurrogate;
            var lowSurrogate;
            var index = -1;
            var length = arguments.length;
            if (!length) {
              return "";
            }
            var result = "";
            while (++index < length) {
              var codePoint = Number(arguments[index]);
              if (!isFinite(codePoint) || // `NaN`, `+Infinity`, or `-Infinity`
              codePoint < 0 || // not a valid Unicode code point
              codePoint > 1114111 || // not a valid Unicode code point
              floor(codePoint) !== codePoint) {
                throw RangeError("Invalid code point: " + codePoint);
              }
              if (codePoint <= 65535) {
                codeUnits.push(codePoint);
              } else {
                codePoint -= 65536;
                highSurrogate = (codePoint >> 10) + 55296;
                lowSurrogate = codePoint % 1024 + 56320;
                codeUnits.push(highSurrogate, lowSurrogate);
              }
              if (index + 1 === length || codeUnits.length > MAX_SIZE) {
                result += stringFromCharCode.apply(null, codeUnits);
                codeUnits.length = 0;
              }
            }
            return result;
          };
          if (Object.defineProperty) {
            Object.defineProperty(String, "fromCodePoint", {
              value: fromCodePoint,
              configurable: true,
              writable: true
            });
          } else {
            String.fromCodePoint = fromCodePoint;
          }
        })();
      }
    })(typeof exports2 === "undefined" ? exports2.sax = {} : exports2);
  }
});

// node_modules/xml2js/lib/bom.js
var require_bom = __commonJS({
  "node_modules/xml2js/lib/bom.js"(exports2) {
    (function() {
      "use strict";
      exports2.stripBOM = function(str) {
        if (str[0] === "\uFEFF") {
          return str.substring(1);
        } else {
          return str;
        }
      };
    }).call(exports2);
  }
});

// node_modules/xml2js/lib/processors.js
var require_processors = __commonJS({
  "node_modules/xml2js/lib/processors.js"(exports2) {
    (function() {
      "use strict";
      var prefixMatch;
      prefixMatch = new RegExp(/(?!xmlns)^.*:/);
      exports2.normalize = function(str) {
        return str.toLowerCase();
      };
      exports2.firstCharLowerCase = function(str) {
        return str.charAt(0).toLowerCase() + str.slice(1);
      };
      exports2.stripPrefix = function(str) {
        return str.replace(prefixMatch, "");
      };
      exports2.parseNumbers = function(str) {
        if (!isNaN(str)) {
          str = str % 1 === 0 ? parseInt(str, 10) : parseFloat(str);
        }
        return str;
      };
      exports2.parseBooleans = function(str) {
        if (/^(?:true|false)$/i.test(str)) {
          str = str.toLowerCase() === "true";
        }
        return str;
      };
    }).call(exports2);
  }
});

// node_modules/xml2js/lib/parser.js
var require_parser = __commonJS({
  "node_modules/xml2js/lib/parser.js"(exports2) {
    (function() {
      "use strict";
      var bom, defaults, defineProperty, events, isEmpty, processItem, processors, sax, setImmediate, bind = function(fn, me) {
        return function() {
          return fn.apply(me, arguments);
        };
      }, extend = function(child, parent) {
        for (var key in parent) {
          if (hasProp.call(parent, key)) child[key] = parent[key];
        }
        function ctor() {
          this.constructor = child;
        }
        ctor.prototype = parent.prototype;
        child.prototype = new ctor();
        child.__super__ = parent.prototype;
        return child;
      }, hasProp = {}.hasOwnProperty;
      sax = require_sax();
      events = require("events");
      bom = require_bom();
      processors = require_processors();
      setImmediate = require("timers").setImmediate;
      defaults = require_defaults().defaults;
      isEmpty = function(thing) {
        return typeof thing === "object" && thing != null && Object.keys(thing).length === 0;
      };
      processItem = function(processors2, item, key) {
        var i, len, process2;
        for (i = 0, len = processors2.length; i < len; i++) {
          process2 = processors2[i];
          item = process2(item, key);
        }
        return item;
      };
      defineProperty = function(obj, key, value) {
        var descriptor;
        descriptor = /* @__PURE__ */ Object.create(null);
        descriptor.value = value;
        descriptor.writable = true;
        descriptor.enumerable = true;
        descriptor.configurable = true;
        return Object.defineProperty(obj, key, descriptor);
      };
      exports2.Parser = (function(superClass) {
        extend(Parser, superClass);
        function Parser(opts) {
          this.parseStringPromise = bind(this.parseStringPromise, this);
          this.parseString = bind(this.parseString, this);
          this.reset = bind(this.reset, this);
          this.assignOrPush = bind(this.assignOrPush, this);
          this.processAsync = bind(this.processAsync, this);
          var key, ref, value;
          if (!(this instanceof exports2.Parser)) {
            return new exports2.Parser(opts);
          }
          this.options = {};
          ref = defaults["0.2"];
          for (key in ref) {
            if (!hasProp.call(ref, key)) continue;
            value = ref[key];
            this.options[key] = value;
          }
          for (key in opts) {
            if (!hasProp.call(opts, key)) continue;
            value = opts[key];
            this.options[key] = value;
          }
          if (this.options.xmlns) {
            this.options.xmlnskey = this.options.attrkey + "ns";
          }
          if (this.options.normalizeTags) {
            if (!this.options.tagNameProcessors) {
              this.options.tagNameProcessors = [];
            }
            this.options.tagNameProcessors.unshift(processors.normalize);
          }
          this.reset();
        }
        Parser.prototype.processAsync = function() {
          var chunk, err;
          try {
            if (this.remaining.length <= this.options.chunkSize) {
              chunk = this.remaining;
              this.remaining = "";
              this.saxParser = this.saxParser.write(chunk);
              return this.saxParser.close();
            } else {
              chunk = this.remaining.substr(0, this.options.chunkSize);
              this.remaining = this.remaining.substr(this.options.chunkSize, this.remaining.length);
              this.saxParser = this.saxParser.write(chunk);
              return setImmediate(this.processAsync);
            }
          } catch (error1) {
            err = error1;
            if (!this.saxParser.errThrown) {
              this.saxParser.errThrown = true;
              return this.emit(err);
            }
          }
        };
        Parser.prototype.assignOrPush = function(obj, key, newValue) {
          if (!(key in obj)) {
            if (!this.options.explicitArray) {
              return defineProperty(obj, key, newValue);
            } else {
              return defineProperty(obj, key, [newValue]);
            }
          } else {
            if (!(obj[key] instanceof Array)) {
              defineProperty(obj, key, [obj[key]]);
            }
            return obj[key].push(newValue);
          }
        };
        Parser.prototype.reset = function() {
          var attrkey, charkey, ontext, stack;
          this.removeAllListeners();
          this.saxParser = sax.parser(this.options.strict, {
            trim: false,
            normalize: false,
            xmlns: this.options.xmlns
          });
          this.saxParser.errThrown = false;
          this.saxParser.onerror = /* @__PURE__ */ (function(_this) {
            return function(error) {
              _this.saxParser.resume();
              if (!_this.saxParser.errThrown) {
                _this.saxParser.errThrown = true;
                return _this.emit("error", error);
              }
            };
          })(this);
          this.saxParser.onend = /* @__PURE__ */ (function(_this) {
            return function() {
              if (!_this.saxParser.ended) {
                _this.saxParser.ended = true;
                return _this.emit("end", _this.resultObject);
              }
            };
          })(this);
          this.saxParser.ended = false;
          this.EXPLICIT_CHARKEY = this.options.explicitCharkey;
          this.resultObject = null;
          stack = [];
          attrkey = this.options.attrkey;
          charkey = this.options.charkey;
          this.saxParser.onopentag = /* @__PURE__ */ (function(_this) {
            return function(node) {
              var key, newValue, obj, processedKey, ref;
              obj = {};
              obj[charkey] = "";
              if (!_this.options.ignoreAttrs) {
                ref = node.attributes;
                for (key in ref) {
                  if (!hasProp.call(ref, key)) continue;
                  if (!(attrkey in obj) && !_this.options.mergeAttrs) {
                    obj[attrkey] = {};
                  }
                  newValue = _this.options.attrValueProcessors ? processItem(_this.options.attrValueProcessors, node.attributes[key], key) : node.attributes[key];
                  processedKey = _this.options.attrNameProcessors ? processItem(_this.options.attrNameProcessors, key) : key;
                  if (_this.options.mergeAttrs) {
                    _this.assignOrPush(obj, processedKey, newValue);
                  } else {
                    defineProperty(obj[attrkey], processedKey, newValue);
                  }
                }
              }
              obj["#name"] = _this.options.tagNameProcessors ? processItem(_this.options.tagNameProcessors, node.name) : node.name;
              if (_this.options.xmlns) {
                obj[_this.options.xmlnskey] = {
                  uri: node.uri,
                  local: node.local
                };
              }
              return stack.push(obj);
            };
          })(this);
          this.saxParser.onclosetag = /* @__PURE__ */ (function(_this) {
            return function() {
              var cdata, emptyStr, key, node, nodeName, obj, objClone, old, s, xpath;
              obj = stack.pop();
              nodeName = obj["#name"];
              if (!_this.options.explicitChildren || !_this.options.preserveChildrenOrder) {
                delete obj["#name"];
              }
              if (obj.cdata === true) {
                cdata = obj.cdata;
                delete obj.cdata;
              }
              s = stack[stack.length - 1];
              if (obj[charkey].match(/^\s*$/) && !cdata) {
                emptyStr = obj[charkey];
                delete obj[charkey];
              } else {
                if (_this.options.trim) {
                  obj[charkey] = obj[charkey].trim();
                }
                if (_this.options.normalize) {
                  obj[charkey] = obj[charkey].replace(/\s{2,}/g, " ").trim();
                }
                obj[charkey] = _this.options.valueProcessors ? processItem(_this.options.valueProcessors, obj[charkey], nodeName) : obj[charkey];
                if (Object.keys(obj).length === 1 && charkey in obj && !_this.EXPLICIT_CHARKEY) {
                  obj = obj[charkey];
                }
              }
              if (isEmpty(obj)) {
                if (typeof _this.options.emptyTag === "function") {
                  obj = _this.options.emptyTag();
                } else {
                  obj = _this.options.emptyTag !== "" ? _this.options.emptyTag : emptyStr;
                }
              }
              if (_this.options.validator != null) {
                xpath = "/" + (function() {
                  var i, len, results;
                  results = [];
                  for (i = 0, len = stack.length; i < len; i++) {
                    node = stack[i];
                    results.push(node["#name"]);
                  }
                  return results;
                })().concat(nodeName).join("/");
                (function() {
                  var err;
                  try {
                    return obj = _this.options.validator(xpath, s && s[nodeName], obj);
                  } catch (error1) {
                    err = error1;
                    return _this.emit("error", err);
                  }
                })();
              }
              if (_this.options.explicitChildren && !_this.options.mergeAttrs && typeof obj === "object") {
                if (!_this.options.preserveChildrenOrder) {
                  node = {};
                  if (_this.options.attrkey in obj) {
                    node[_this.options.attrkey] = obj[_this.options.attrkey];
                    delete obj[_this.options.attrkey];
                  }
                  if (!_this.options.charsAsChildren && _this.options.charkey in obj) {
                    node[_this.options.charkey] = obj[_this.options.charkey];
                    delete obj[_this.options.charkey];
                  }
                  if (Object.getOwnPropertyNames(obj).length > 0) {
                    node[_this.options.childkey] = obj;
                  }
                  obj = node;
                } else if (s) {
                  s[_this.options.childkey] = s[_this.options.childkey] || [];
                  objClone = {};
                  for (key in obj) {
                    if (!hasProp.call(obj, key)) continue;
                    defineProperty(objClone, key, obj[key]);
                  }
                  s[_this.options.childkey].push(objClone);
                  delete obj["#name"];
                  if (Object.keys(obj).length === 1 && charkey in obj && !_this.EXPLICIT_CHARKEY) {
                    obj = obj[charkey];
                  }
                }
              }
              if (stack.length > 0) {
                return _this.assignOrPush(s, nodeName, obj);
              } else {
                if (_this.options.explicitRoot) {
                  old = obj;
                  obj = {};
                  defineProperty(obj, nodeName, old);
                }
                _this.resultObject = obj;
                _this.saxParser.ended = true;
                return _this.emit("end", _this.resultObject);
              }
            };
          })(this);
          ontext = /* @__PURE__ */ (function(_this) {
            return function(text) {
              var charChild, s;
              s = stack[stack.length - 1];
              if (s) {
                s[charkey] += text;
                if (_this.options.explicitChildren && _this.options.preserveChildrenOrder && _this.options.charsAsChildren && (_this.options.includeWhiteChars || text.replace(/\\n/g, "").trim() !== "")) {
                  s[_this.options.childkey] = s[_this.options.childkey] || [];
                  charChild = {
                    "#name": "__text__"
                  };
                  charChild[charkey] = text;
                  if (_this.options.normalize) {
                    charChild[charkey] = charChild[charkey].replace(/\s{2,}/g, " ").trim();
                  }
                  s[_this.options.childkey].push(charChild);
                }
                return s;
              }
            };
          })(this);
          this.saxParser.ontext = ontext;
          return this.saxParser.oncdata = /* @__PURE__ */ (function(_this) {
            return function(text) {
              var s;
              s = ontext(text);
              if (s) {
                return s.cdata = true;
              }
            };
          })(this);
        };
        Parser.prototype.parseString = function(str, cb) {
          var err;
          if (cb != null && typeof cb === "function") {
            this.on("end", function(result) {
              this.reset();
              return cb(null, result);
            });
            this.on("error", function(err2) {
              this.reset();
              return cb(err2);
            });
          }
          try {
            str = str.toString();
            if (str.trim() === "") {
              this.emit("end", null);
              return true;
            }
            str = bom.stripBOM(str);
            if (this.options.async) {
              this.remaining = str;
              setImmediate(this.processAsync);
              return this.saxParser;
            }
            return this.saxParser.write(str).close();
          } catch (error1) {
            err = error1;
            if (!(this.saxParser.errThrown || this.saxParser.ended)) {
              this.emit("error", err);
              return this.saxParser.errThrown = true;
            } else if (this.saxParser.ended) {
              throw err;
            }
          }
        };
        Parser.prototype.parseStringPromise = function(str) {
          return new Promise(/* @__PURE__ */ (function(_this) {
            return function(resolve2, reject) {
              return _this.parseString(str, function(err, value) {
                if (err) {
                  return reject(err);
                } else {
                  return resolve2(value);
                }
              });
            };
          })(this));
        };
        return Parser;
      })(events);
      exports2.parseString = function(str, a, b) {
        var cb, options, parser;
        if (b != null) {
          if (typeof b === "function") {
            cb = b;
          }
          if (typeof a === "object") {
            options = a;
          }
        } else {
          if (typeof a === "function") {
            cb = a;
          }
          options = {};
        }
        parser = new exports2.Parser(options);
        return parser.parseString(str, cb);
      };
      exports2.parseStringPromise = function(str, a) {
        var options, parser;
        if (typeof a === "object") {
          options = a;
        }
        parser = new exports2.Parser(options);
        return parser.parseStringPromise(str);
      };
    }).call(exports2);
  }
});

// node_modules/xml2js/lib/xml2js.js
var require_xml2js = __commonJS({
  "node_modules/xml2js/lib/xml2js.js"(exports2) {
    (function() {
      "use strict";
      var builder, defaults, parser, processors, extend = function(child, parent) {
        for (var key in parent) {
          if (hasProp.call(parent, key)) child[key] = parent[key];
        }
        function ctor() {
          this.constructor = child;
        }
        ctor.prototype = parent.prototype;
        child.prototype = new ctor();
        child.__super__ = parent.prototype;
        return child;
      }, hasProp = {}.hasOwnProperty;
      defaults = require_defaults();
      builder = require_builder();
      parser = require_parser();
      processors = require_processors();
      exports2.defaults = defaults.defaults;
      exports2.processors = processors;
      exports2.ValidationError = (function(superClass) {
        extend(ValidationError, superClass);
        function ValidationError(message) {
          this.message = message;
        }
        return ValidationError;
      })(Error);
      exports2.Builder = builder.Builder;
      exports2.Parser = parser.Parser;
      exports2.parseString = parser.parseString;
      exports2.parseStringPromise = parser.parseStringPromise;
    }).call(exports2);
  }
});

// node_modules/@darabonba/typescript/dist/xml.js
var require_xml = __commonJS({
  "node_modules/@darabonba/typescript/dist/xml.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var xml2js_1 = require_xml2js();
    var TeaXML = (
      /** @class */
      (function() {
        function TeaXML2() {
        }
        TeaXML2.parseXml = function(body, response) {
          var ret = this._parseXML(body);
          if (response !== null && typeof response !== "undefined") {
            ret = this._xmlCast(ret, response);
          }
          return ret;
        };
        TeaXML2.toXML = function(body) {
          var builder = new xml2js_1.Builder();
          return builder.buildObject(body);
        };
        TeaXML2._parseXML = function(body) {
          var parser = new xml2js_1.Parser({ explicitArray: false });
          var result = {};
          parser.parseString(body, function(err, output) {
            result.err = err;
            result.output = output;
          });
          if (result.err) {
            throw result.err;
          }
          return result.output;
        };
        TeaXML2._xmlCast = function(obj, clazz) {
          var _this = this;
          obj = obj || {};
          var ret = {};
          var clz = clazz;
          var names = clz.names();
          var types = clz.types();
          Object.keys(names).forEach(function(key) {
            var originName = names[key];
            var value = obj[originName];
            var type = types[key];
            switch (type) {
              case "boolean":
                if (!value) {
                  ret[originName] = false;
                  return;
                }
                ret[originName] = value === "false" ? false : true;
                return;
              case "number":
                if (value != 0 && !value) {
                  ret[originName] = NaN;
                  return;
                }
                ret[originName] = +value;
                return;
              case "string":
                if (!value) {
                  ret[originName] = "";
                  return;
                }
                ret[originName] = value.toString();
                return;
              default:
                if (type.type === "array") {
                  if (!value) {
                    ret[originName] = [];
                    return;
                  }
                  if (!Array.isArray(value)) {
                    value = [value];
                  }
                  if (typeof type.itemType === "function") {
                    ret[originName] = value.map(function(d) {
                      return _this._xmlCast(d, type.itemType);
                    });
                  } else {
                    ret[originName] = value;
                  }
                } else if (typeof type === "function") {
                  if (!value) {
                    value = {};
                  }
                  ret[originName] = _this._xmlCast(value, type);
                } else {
                  ret[originName] = value;
                }
            }
          });
          return ret;
        };
        return TeaXML2;
      })()
    );
    exports2.default = TeaXML;
  }
});

// node_modules/@darabonba/typescript/dist/index.js
var require_dist = __commonJS({
  "node_modules/@darabonba/typescript/dist/index.js"(exports2) {
    "use strict";
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    }) : (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      o[k2] = m[k];
    }));
    var __exportStar = exports2 && exports2.__exportStar || function(m, exports3) {
      for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports3, p)) __createBinding(exports3, m, p);
    };
    var __importDefault = exports2 && exports2.__importDefault || function(mod) {
      return mod && mod.__esModule ? mod : { "default": mod };
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.XML = exports2.URL = exports2.SSEEvent = exports2.Stream = exports2.FileFormStream = exports2.Form = exports2.File = exports2.Date = void 0;
    __exportStar(require_core(), exports2);
    var date_1 = require_date();
    Object.defineProperty(exports2, "Date", { enumerable: true, get: function() {
      return __importDefault(date_1).default;
    } });
    __exportStar(require_error(), exports2);
    var file_1 = require_file();
    Object.defineProperty(exports2, "File", { enumerable: true, get: function() {
      return __importDefault(file_1).default;
    } });
    var form_1 = require_form();
    Object.defineProperty(exports2, "Form", { enumerable: true, get: function() {
      return __importDefault(form_1).default;
    } });
    Object.defineProperty(exports2, "FileFormStream", { enumerable: true, get: function() {
      return form_1.FileFormStream;
    } });
    __exportStar(require_func(), exports2);
    __exportStar(require_retry(), exports2);
    var stream_1 = require_stream();
    Object.defineProperty(exports2, "Stream", { enumerable: true, get: function() {
      return __importDefault(stream_1).default;
    } });
    Object.defineProperty(exports2, "SSEEvent", { enumerable: true, get: function() {
      return stream_1.SSEEvent;
    } });
    var url_1 = require_url();
    Object.defineProperty(exports2, "URL", { enumerable: true, get: function() {
      return __importDefault(url_1).default;
    } });
    var xml_1 = require_xml();
    Object.defineProperty(exports2, "XML", { enumerable: true, get: function() {
      return __importDefault(xml_1).default;
    } });
  }
});

// node_modules/@alicloud/credentials/dist/src/credential_model.js
var require_credential_model = __commonJS({
  "node_modules/@alicloud/credentials/dist/src/credential_model.js"(exports2) {
    "use strict";
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    }) : (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      o[k2] = m[k];
    }));
    var __setModuleDefault = exports2 && exports2.__setModuleDefault || (Object.create ? (function(o, v) {
      Object.defineProperty(o, "default", { enumerable: true, value: v });
    }) : function(o, v) {
      o["default"] = v;
    });
    var __importStar = exports2 && exports2.__importStar || function(mod) {
      if (mod && mod.__esModule) return mod;
      var result = {};
      if (mod != null) {
        for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
      }
      __setModuleDefault(result, mod);
      return result;
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    var $tea = __importStar(require_tea());
    var CredentialModel = class extends $tea.Model {
      static names() {
        return {
          accessKeyId: "accessKeyId",
          accessKeySecret: "accessKeySecret",
          securityToken: "securityToken",
          bearerToken: "bearerToken",
          type: "type",
          providerName: "providerName"
        };
      }
      static types() {
        return {
          accessKeyId: "string",
          accessKeySecret: "string",
          securityToken: "string",
          bearerToken: "string",
          type: "string",
          providerName: "string"
        };
      }
      constructor(map) {
        super(map);
      }
    };
    exports2.default = CredentialModel;
  }
});

// node_modules/@alicloud/credentials/dist/src/default_credential.js
var require_default_credential = __commonJS({
  "node_modules/@alicloud/credentials/dist/src/default_credential.js"(exports2) {
    "use strict";
    var __importDefault = exports2 && exports2.__importDefault || function(mod) {
      return mod && mod.__esModule ? mod : { "default": mod };
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    var credential_model_1 = __importDefault(require_credential_model());
    var DefaultCredential = class {
      constructor(config2) {
        this.accessKeyId = config2.accessKeyId || "";
        this.accessKeySecret = config2.accessKeySecret || "";
        this.securityToken = config2.securityToken || "";
        this.bearerToken = config2.bearerToken || "";
        this.type = config2.type || "";
      }
      async getAccessKeyId() {
        return this.accessKeyId;
      }
      async getAccessKeySecret() {
        return this.accessKeySecret;
      }
      async getSecurityToken() {
        return this.securityToken;
      }
      getBearerToken() {
        return this.bearerToken;
      }
      getType() {
        return this.type;
      }
      async getCredential() {
        return new credential_model_1.default({
          accessKeyId: this.accessKeyId,
          accessKeySecret: this.accessKeySecret,
          securityToken: this.securityToken,
          bearerToken: this.bearerToken,
          type: this.type
        });
      }
    };
    exports2.default = DefaultCredential;
  }
});

// node_modules/ini/ini.js
var require_ini = __commonJS({
  "node_modules/ini/ini.js"(exports2) {
    exports2.parse = exports2.decode = decode;
    exports2.stringify = exports2.encode = encode;
    exports2.safe = safe;
    exports2.unsafe = unsafe;
    var eol = typeof process !== "undefined" && process.platform === "win32" ? "\r\n" : "\n";
    function encode(obj, opt) {
      var children2 = [];
      var out = "";
      if (typeof opt === "string") {
        opt = {
          section: opt,
          whitespace: false
        };
      } else {
        opt = opt || {};
        opt.whitespace = opt.whitespace === true;
      }
      var separator = opt.whitespace ? " = " : "=";
      Object.keys(obj).forEach(function(k, _, __) {
        var val = obj[k];
        if (val && Array.isArray(val)) {
          val.forEach(function(item) {
            out += safe(k + "[]") + separator + safe(item) + "\n";
          });
        } else if (val && typeof val === "object")
          children2.push(k);
        else
          out += safe(k) + separator + safe(val) + eol;
      });
      if (opt.section && out.length)
        out = "[" + safe(opt.section) + "]" + eol + out;
      children2.forEach(function(k, _, __) {
        var nk = dotSplit(k).join("\\.");
        var section = (opt.section ? opt.section + "." : "") + nk;
        var child = encode(obj[k], {
          section,
          whitespace: opt.whitespace
        });
        if (out.length && child.length)
          out += eol;
        out += child;
      });
      return out;
    }
    function dotSplit(str) {
      return str.replace(/\1/g, "LITERAL\\1LITERAL").replace(/\\\./g, "").split(/\./).map(function(part) {
        return part.replace(/\1/g, "\\.").replace(/\2LITERAL\\1LITERAL\2/g, "");
      });
    }
    function decode(str) {
      var out = {};
      var p = out;
      var section = null;
      var re = /^\[([^\]]*)\]$|^([^=]+)(=(.*))?$/i;
      var lines = str.split(/[\r\n]+/g);
      lines.forEach(function(line, _, __) {
        if (!line || line.match(/^\s*[;#]/))
          return;
        var match = line.match(re);
        if (!match)
          return;
        if (match[1] !== void 0) {
          section = unsafe(match[1]);
          if (section === "__proto__") {
            p = {};
            return;
          }
          p = out[section] = out[section] || {};
          return;
        }
        var key = unsafe(match[2]);
        if (key === "__proto__")
          return;
        var value = match[3] ? unsafe(match[4]) : true;
        switch (value) {
          case "true":
          case "false":
          case "null":
            value = JSON.parse(value);
        }
        if (key.length > 2 && key.slice(-2) === "[]") {
          key = key.substring(0, key.length - 2);
          if (key === "__proto__")
            return;
          if (!p[key])
            p[key] = [];
          else if (!Array.isArray(p[key]))
            p[key] = [p[key]];
        }
        if (Array.isArray(p[key]))
          p[key].push(value);
        else
          p[key] = value;
      });
      Object.keys(out).filter(function(k, _, __) {
        if (!out[k] || typeof out[k] !== "object" || Array.isArray(out[k]))
          return false;
        var parts = dotSplit(k);
        var p2 = out;
        var l = parts.pop();
        var nl = l.replace(/\\\./g, ".");
        parts.forEach(function(part, _2, __2) {
          if (part === "__proto__")
            return;
          if (!p2[part] || typeof p2[part] !== "object")
            p2[part] = {};
          p2 = p2[part];
        });
        if (p2 === out && nl === l)
          return false;
        p2[nl] = out[k];
        return true;
      }).forEach(function(del, _, __) {
        delete out[del];
      });
      return out;
    }
    function isQuoted(val) {
      return val.charAt(0) === '"' && val.slice(-1) === '"' || val.charAt(0) === "'" && val.slice(-1) === "'";
    }
    function safe(val) {
      return typeof val !== "string" || val.match(/[=\r\n]/) || val.match(/^\[/) || val.length > 1 && isQuoted(val) || val !== val.trim() ? JSON.stringify(val) : val.replace(/;/g, "\\;").replace(/#/g, "\\#");
    }
    function unsafe(val, doUnesc) {
      val = (val || "").trim();
      if (isQuoted(val)) {
        if (val.charAt(0) === "'")
          val = val.substr(1, val.length - 2);
        try {
          val = JSON.parse(val);
        } catch (_) {
        }
      } else {
        var esc = false;
        var unesc = "";
        for (var i = 0, l = val.length; i < l; i++) {
          var c = val.charAt(i);
          if (esc) {
            if ("\\;#".indexOf(c) !== -1)
              unesc += c;
            else
              unesc += "\\" + c;
            esc = false;
          } else if (";#".indexOf(c) !== -1)
            break;
          else if (c === "\\")
            esc = true;
          else
            unesc += c;
        }
        if (esc)
          unesc += "\\";
        return unesc.trim();
      }
      return val;
    }
  }
});

// node_modules/kitx/lib/index.js
var require_lib3 = __commonJS({
  "node_modules/kitx/lib/index.js"(exports2) {
    "use strict";
    var fs2 = require("fs");
    var os = require("os");
    var crypto = require("crypto");
    exports2.loadJSONSync = function(filename) {
      var content = fs2.readFileSync(filename, "utf8");
      if (content.charCodeAt(0) === 65279) {
        content = content.slice(1);
      }
      try {
        return JSON.parse(content);
      } catch (err) {
        err.message = filename + ": " + err.message;
        throw err;
      }
    };
    exports2.encode = function(str, encoding) {
      if (typeof str !== "string") {
        str = "" + str;
      }
      return Buffer.from(str, encoding);
    };
    exports2.makeHasher = function(algorithm) {
      return function(data, encoding) {
        var shasum = crypto.createHash(algorithm);
        shasum.update(data);
        return shasum.digest(encoding);
      };
    };
    exports2.createHash = exports2.makeHasher;
    exports2.md5 = exports2.makeHasher("md5");
    exports2.createHmac = function(algorithm) {
      return function(data, key, encoding) {
        return crypto.createHmac(algorithm, key).update(data).digest(encoding);
      };
    };
    exports2.sha1 = exports2.createHmac("sha1");
    exports2.random = function(min, max) {
      return Math.floor(min + Math.random() * (max - min));
    };
    exports2.makeNonce = (function() {
      var counter = 0;
      var last;
      const machine = os.hostname();
      const pid = process.pid;
      return function() {
        var val = Math.floor(Math.random() * 1e12);
        if (val === last) {
          counter++;
        } else {
          counter = 0;
        }
        last = val;
        var uid = `${machine}${pid}${val}${counter}`;
        return exports2.md5(uid, "hex");
      };
    })();
    exports2.pad2 = function(num) {
      if (num < 10) {
        return "0" + num;
      }
      return "" + num;
    };
    exports2.pad3 = function(num) {
      if (num < 10) {
        return "00" + num;
      } else if (num < 100) {
        return "0" + num;
      }
      return "" + num;
    };
    exports2.getYYYYMMDD = function(date) {
      var YYYY = date.getFullYear();
      var MM = exports2.pad2(date.getMonth() + 1);
      var DD = exports2.pad2(date.getDate());
      return "" + YYYY + MM + DD;
    };
    exports2.sleep = function(ms) {
      return new Promise((resolve2) => {
        setTimeout(resolve2, ms);
      });
    };
    exports2.getIPv4 = function() {
      var interfaces = os.networkInterfaces();
      var keys = Object.keys(interfaces);
      for (var i = 0; i < keys.length; i++) {
        var key = keys[i];
        var addresses = interfaces[key];
        for (var j = 0; j < addresses.length; j++) {
          var item = addresses[j];
          if (!item.internal && item.family === "IPv4") {
            return item.address;
          }
        }
      }
      return "";
    };
    exports2.getMac = function() {
      var interfaces = os.networkInterfaces();
      var keys = Object.keys(interfaces);
      for (var i = 0; i < keys.length; i++) {
        var key = keys[i];
        var addresses = interfaces[key];
        for (var j = 0; j < addresses.length; j++) {
          var item = addresses[j];
          if (!item.internal && item.family === "IPv4") {
            return item.mac;
          }
        }
      }
      return "00:00:00:00:00:00";
    };
    exports2.readAll = function(readable) {
      return new Promise((resolve2, reject) => {
        var onError, onData, onEnd;
        var cleanup = function(err) {
          readable.removeListener("error", onError);
          readable.removeListener("data", onData);
          readable.removeListener("end", onEnd);
        };
        var bufs = [];
        var size = 0;
        onData = function(buf) {
          bufs.push(buf);
          size += buf.length;
        };
        onError = function(err) {
          cleanup();
          reject(err);
        };
        onEnd = function() {
          cleanup();
          resolve2(Buffer.concat(bufs, size));
        };
        readable.on("error", onError);
        readable.on("data", onData);
        readable.on("end", onEnd);
      });
    };
    var SimpleCryptoHelper = class {
      constructor(algorithm, key, iv) {
        this.algorithm = algorithm;
        this.key = key;
        this.iv = iv;
      }
      encrypt(data, inputEncoding, outputEncoding) {
        const cipher = crypto.createCipheriv(this.algorithm, this.key, this.iv);
        let output = cipher.update(data, inputEncoding, outputEncoding);
        output += cipher.final(outputEncoding);
        return output;
      }
      decrypt(encrypted, inputEncoding, outputEncoding) {
        const decipher = crypto.createDecipheriv(this.algorithm, this.key, this.iv);
        let output = decipher.update(encrypted, inputEncoding, outputEncoding);
        output += decipher.final(outputEncoding);
        return output;
      }
    };
    var helper = new SimpleCryptoHelper(
      "aes-192-cbc",
      Buffer.from("keykeykeykeykeykeykeykey"),
      // 24 bytes, 192 bits
      Buffer.from("abcdefghijklmnop")
      // 16 bytes
    );
    exports2.encrypt = function(data, inputEncoding, outputEncoding) {
      return helper.encrypt(data, inputEncoding, outputEncoding);
    };
    exports2.decrypt = function(encrypted, inputEncoding, outputEncoding) {
      return helper.decrypt(encrypted, inputEncoding, outputEncoding);
    };
  }
});

// node_modules/@alicloud/credentials/dist/src/util/utils.js
var require_utils = __commonJS({
  "node_modules/@alicloud/credentials/dist/src/util/utils.js"(exports2) {
    "use strict";
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    }) : (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      o[k2] = m[k];
    }));
    var __setModuleDefault = exports2 && exports2.__setModuleDefault || (Object.create ? (function(o, v) {
      Object.defineProperty(o, "default", { enumerable: true, value: v });
    }) : function(o, v) {
      o["default"] = v;
    });
    var __importStar = exports2 && exports2.__importStar || function(mod) {
      if (mod && mod.__esModule) return mod;
      var result = {};
      if (mod != null) {
        for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
      }
      __setModuleDefault(result, mod);
      return result;
    };
    var __importDefault = exports2 && exports2.__importDefault || function(mod) {
      return mod && mod.__esModule ? mod : { "default": mod };
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.getRandomInt = exports2.loadIni = exports2.parseFile = exports2.timestamp = void 0;
    var ini = __importStar(require_ini());
    var kitx = __importStar(require_lib3());
    var fs_1 = __importDefault(require("fs"));
    var util_1 = require("util");
    var readFileAsync = (0, util_1.promisify)(fs_1.default.readFile);
    var accessAsync = (0, util_1.promisify)(fs_1.default.access);
    function timestamp(dateStr, timeChange) {
      let date = new Date(dateStr);
      if (!dateStr || isNaN(date.getTime())) {
        date = /* @__PURE__ */ new Date();
      }
      if (timeChange) {
        date.setTime(date.getTime() + timeChange);
      }
      const YYYY = date.getUTCFullYear();
      const MM = kitx.pad2(date.getUTCMonth() + 1);
      const DD = kitx.pad2(date.getUTCDate());
      const HH = kitx.pad2(date.getUTCHours());
      const mm = kitx.pad2(date.getUTCMinutes());
      const ss = kitx.pad2(date.getUTCSeconds());
      return `${YYYY}-${MM}-${DD}T${HH}:${mm}:${ss}Z`;
    }
    exports2.timestamp = timestamp;
    function parseFile(file, ignoreErr = false) {
      try {
        fs_1.default.accessSync(file, fs_1.default.constants.R_OK);
      } catch (e) {
        if (ignoreErr) {
          return null;
        }
        throw new Error("Has no read permission to credentials file");
      }
      return ini.parse(fs_1.default.readFileSync(file, "utf-8"));
    }
    exports2.parseFile = parseFile;
    async function loadIni(filePath) {
      await accessAsync(filePath, fs_1.default.constants.R_OK);
      const content = await readFileAsync(filePath, "utf-8");
      return ini.parse(content);
    }
    exports2.loadIni = loadIni;
    function getRandomInt(max) {
      return Math.floor(Math.random() * (max + 1));
    }
    exports2.getRandomInt = getRandomInt;
  }
});

// node_modules/@alicloud/credentials/dist/src/config.js
var require_config = __commonJS({
  "node_modules/@alicloud/credentials/dist/src/config.js"(exports2) {
    "use strict";
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    }) : (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      o[k2] = m[k];
    }));
    var __setModuleDefault = exports2 && exports2.__setModuleDefault || (Object.create ? (function(o, v) {
      Object.defineProperty(o, "default", { enumerable: true, value: v });
    }) : function(o, v) {
      o["default"] = v;
    });
    var __importStar = exports2 && exports2.__importStar || function(mod) {
      if (mod && mod.__esModule) return mod;
      var result = {};
      if (mod != null) {
        for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
      }
      __setModuleDefault(result, mod);
      return result;
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    var $tea = __importStar(require_tea());
    var Config2 = class extends $tea.Model {
      static names() {
        return {
          accessKeyId: "accessKeyId",
          accessKeySecret: "accessKeySecret",
          securityToken: "securityToken",
          bearerToken: "bearerToken",
          durationSeconds: "durationSeconds",
          roleArn: "roleArn",
          policy: "policy",
          roleSessionExpiration: "roleSessionExpiration",
          roleSessionName: "roleSessionName",
          externalId: "externalId",
          stsEndpoint: "stsEndpoint",
          stsRegionId: "stsRegionId",
          enableVpc: "enableVpc",
          timeout: "readTimeout",
          connectTimeout: "connectTimeout",
          publicKeyId: "publicKeyId",
          privateKeyFile: "privateKeyFile",
          roleName: "roleName",
          enableIMDSv2: "enableIMDSv2",
          disableIMDSv1: "disableIMDSv1",
          asyncCredentialUpdateEnabled: "asyncCredentialUpdateEnabled",
          metadataTokenDuration: "metadataTokenDuration",
          credentialsURI: "credentialsURI",
          oidcProviderArn: "oidcProviderArn",
          oidcTokenFilePath: "oidcTokenFilePath",
          type: "type"
        };
      }
      static types() {
        return {
          accessKeyId: "string",
          accessKeySecret: "string",
          securityToken: "string",
          bearerToken: "string",
          durationSeconds: "number",
          roleArn: "string",
          policy: "string",
          roleSessionExpiration: "number",
          roleSessionName: "string",
          externalId: "string",
          stsEndpoint: "string",
          stsRegionId: "string",
          enableVpc: "string",
          timeout: "number",
          connectTimeout: "number",
          publicKeyId: "string",
          privateKeyFile: "string",
          roleName: "string",
          enableIMDSv2: "boolean",
          disableIMDSv1: "boolean",
          asyncCredentialUpdateEnabled: "boolean",
          metadataTokenDuration: "number",
          credentialsURI: "string",
          oidcProviderArn: "string",
          oidcTokenFilePath: "string",
          type: "string"
        };
      }
      constructor(config2) {
        super(config2);
      }
    };
    exports2.default = Config2;
  }
});

// node_modules/@alicloud/credentials/dist/src/session_credential.js
var require_session_credential = __commonJS({
  "node_modules/@alicloud/credentials/dist/src/session_credential.js"(exports2) {
    "use strict";
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    }) : (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      o[k2] = m[k];
    }));
    var __setModuleDefault = exports2 && exports2.__setModuleDefault || (Object.create ? (function(o, v) {
      Object.defineProperty(o, "default", { enumerable: true, value: v });
    }) : function(o, v) {
      o["default"] = v;
    });
    var __importStar = exports2 && exports2.__importStar || function(mod) {
      if (mod && mod.__esModule) return mod;
      var result = {};
      if (mod != null) {
        for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
      }
      __setModuleDefault(result, mod);
      return result;
    };
    var __importDefault = exports2 && exports2.__importDefault || function(mod) {
      return mod && mod.__esModule ? mod : { "default": mod };
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    var default_credential_1 = __importDefault(require_default_credential());
    var utils = __importStar(require_utils());
    var config_1 = __importDefault(require_config());
    var credential_model_1 = __importDefault(require_credential_model());
    var SessionCredential = class extends default_credential_1.default {
      constructor(config2) {
        const conf = new config_1.default({
          type: config2.type,
          accessKeyId: config2.accessKeyId,
          accessKeySecret: config2.accessKeySecret,
          securityToken: config2.securityToken
        });
        super(conf);
        this.sessionCredential = null;
        this.durationSeconds = config2.durationSeconds || 3600;
      }
      async updateCredential() {
        throw new Error("need implemented in sub-class");
      }
      async ensureCredential() {
        const needUpdate = this.needUpdateCredential();
        if (needUpdate) {
          await this.updateCredential();
        }
      }
      async getAccessKeyId() {
        await this.ensureCredential();
        return this.sessionCredential.AccessKeyId;
      }
      async getAccessKeySecret() {
        await this.ensureCredential();
        return this.sessionCredential.AccessKeySecret;
      }
      async getSecurityToken() {
        await this.ensureCredential();
        return this.sessionCredential.SecurityToken;
      }
      needUpdateCredential() {
        if (!this.sessionCredential || !this.sessionCredential.Expiration || !this.sessionCredential.AccessKeyId || !this.sessionCredential.AccessKeySecret || !this.sessionCredential.SecurityToken) {
          return true;
        }
        const expireTime = utils.timestamp(/* @__PURE__ */ new Date(), this.durationSeconds * 0.05 * 1e3);
        if (this.sessionCredential.Expiration < expireTime) {
          return true;
        }
        return false;
      }
      async getCredential() {
        await this.ensureCredential();
        return new credential_model_1.default({
          accessKeyId: this.sessionCredential.AccessKeyId,
          accessKeySecret: this.sessionCredential.AccessKeySecret,
          securityToken: this.sessionCredential.SecurityToken,
          bearerToken: this.bearerToken,
          type: this.type
        });
      }
    };
    exports2.default = SessionCredential;
  }
});

// node_modules/@alicloud/credentials/dist/package.json
var require_package = __commonJS({
  "node_modules/@alicloud/credentials/dist/package.json"(exports2, module2) {
    module2.exports = {
      name: "@alicloud/credentials",
      version: "2.4.4",
      description: "alibaba cloud node.js sdk credentials",
      main: "dist/src/client.js",
      scripts: {
        prepublishOnly: "tsc",
        build: "tsc",
        lint: "eslint --fix ./src --ext .ts",
        test: "mocha -b -r ts-node/register test/**/*.test.ts test/*.test.ts --timeout 15000",
        "test-dev": "nyc -e .ts -r=html -r=text -r=lcov mocha -b -r ts-node/register",
        cov: "nyc -e .ts -r=html -r=text -r=lcov npm run test",
        ci: "npm run cov",
        integration: "mocha -b -r ts-node/register -R spec integration/*.test.ts",
        clean: "rm -rf coverage"
      },
      repository: {
        type: "git",
        url: "git+https://github.com/aliyun/nodejs-credentials.git"
      },
      keywords: [
        "alibaba cloud",
        "sdk",
        "credentials"
      ],
      author: "Alibaba Cloud SDK",
      license: "MIT",
      devDependencies: {
        "@types/debug": "^4.1.12",
        "@types/expect.js": "^0.3.29",
        "@types/ini": "^1.3.30",
        "@types/mocha": "^10.0.6",
        "@types/node": "^20.11.10",
        "@types/rewire": "^2.5.28",
        "@typescript-eslint/eslint-plugin": "^6.18.1",
        "@typescript-eslint/parser": "^6.18.1",
        eslint: "^8.56.0",
        "expect.js": "^0.3.1",
        mm: "^2.4.1",
        mocha: "^10.1.0",
        nyc: "^15.1.0",
        rewire: "^7.0.0",
        "ts-node": "^10.9.2",
        typescript: "^4.7.4"
      },
      dependencies: {
        "@alicloud/tea-typescript": "^1.8.0",
        httpx: "^2.3.3",
        ini: "^1.3.5",
        kitx: "^2.0.0"
      },
      bugs: {
        url: "https://github.com/aliyun/nodejs-credentials/issues"
      },
      homepage: "https://github.com/aliyun/nodejs-credentials#readme",
      files: [
        "src",
        "dist"
      ]
    };
  }
});

// node_modules/@alicloud/credentials/dist/src/util/helper.js
var require_helper = __commonJS({
  "node_modules/@alicloud/credentials/dist/src/util/helper.js"(exports2) {
    "use strict";
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    }) : (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      o[k2] = m[k];
    }));
    var __setModuleDefault = exports2 && exports2.__setModuleDefault || (Object.create ? (function(o, v) {
      Object.defineProperty(o, "default", { enumerable: true, value: v });
    }) : function(o, v) {
      o["default"] = v;
    });
    var __importStar = exports2 && exports2.__importStar || function(mod) {
      if (mod && mod.__esModule) return mod;
      var result = {};
      if (mod != null) {
        for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
      }
      __setModuleDefault(result, mod);
      return result;
    };
    var __importDefault = exports2 && exports2.__importDefault || function(mod) {
      return mod && mod.__esModule ? mod : { "default": mod };
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.DEFAULT_CLIENT = exports2.DEFAULT_UA = void 0;
    var os = __importStar(require("os"));
    var package_json_1 = __importDefault(require_package());
    exports2.DEFAULT_UA = `AlibabaCloud (${os.platform()}; ${os.arch()}) Node.js/${process.version} Core/${package_json_1.default.version}`;
    exports2.DEFAULT_CLIENT = `Node.js(${process.version}), ${package_json_1.default.name}: ${package_json_1.default.version}`;
  }
});

// node_modules/@alicloud/credentials/dist/src/util/http.js
var require_http = __commonJS({
  "node_modules/@alicloud/credentials/dist/src/util/http.js"(exports2) {
    "use strict";
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    }) : (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      o[k2] = m[k];
    }));
    var __setModuleDefault = exports2 && exports2.__setModuleDefault || (Object.create ? (function(o, v) {
      Object.defineProperty(o, "default", { enumerable: true, value: v });
    }) : function(o, v) {
      o["default"] = v;
    });
    var __importStar = exports2 && exports2.__importStar || function(mod) {
      if (mod && mod.__esModule) return mod;
      var result = {};
      if (mod != null) {
        for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
      }
      __setModuleDefault(result, mod);
      return result;
    };
    var __importDefault = exports2 && exports2.__importDefault || function(mod) {
      return mod && mod.__esModule ? mod : { "default": mod };
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.request = void 0;
    var httpx_1 = __importDefault(require_lib());
    var kitx = __importStar(require_lib3());
    var helper = __importStar(require_helper());
    var utils = __importStar(require_utils());
    var STATUS_CODE = /* @__PURE__ */ new Set([200, "200", "OK", "Success"]);
    function firstLetterUpper(str) {
      return str.slice(0, 1).toUpperCase() + str.slice(1);
    }
    function formatParams(params) {
      const keys = Object.keys(params);
      const newParams = {};
      for (const key of keys) {
        newParams[firstLetterUpper(key)] = params[key];
      }
      return newParams;
    }
    function encode(str) {
      const result = encodeURIComponent(str);
      return result.replace(/!/g, "%21").replace(/'/g, "%27").replace(/\(/g, "%28").replace(/\)/g, "%29").replace(/\*/g, "%2A");
    }
    function replaceRepeatList(target, key, repeat) {
      for (let i = 0; i < repeat.length; i++) {
        const item = repeat[i];
        if (item && typeof item === "object") {
          const keys = Object.keys(item);
          for (const itemKey of keys) {
            target[`${key}.${i + 1}.${itemKey}`] = item[itemKey];
          }
        } else {
          target[`${key}.${i + 1}`] = item;
        }
      }
    }
    function flatParams(params) {
      const target = {};
      const keys = Object.keys(params);
      for (const key of keys) {
        const value = params[key];
        if (Array.isArray(value)) {
          replaceRepeatList(target, key, value);
        } else {
          target[key] = value;
        }
      }
      return target;
    }
    function normalize(params) {
      const list = [];
      const flated = flatParams(params);
      const keys = Object.keys(flated).sort();
      for (const key of keys) {
        const value = flated[key];
        list.push([encode(key), encode(value)]);
      }
      return list;
    }
    function canonicalize(normalized) {
      const fields = [];
      for (const [key, value] of normalized) {
        fields.push(key + "=" + value);
      }
      return fields.join("&");
    }
    function _buildParams() {
      const defaultParams = {
        Format: "JSON",
        SignatureMethod: "HMAC-SHA1",
        SignatureNonce: kitx.makeNonce(),
        SignatureVersion: "1.0",
        Timestamp: utils.timestamp(),
        Version: "2015-04-01",
        RegionId: "cn-hangzhou"
      };
      return defaultParams;
    }
    async function request(host, params = {}, opts = {}, accessKeySecret) {
      let options = Object.assign({ headers: {
        "x-sdk-client": helper.DEFAULT_CLIENT,
        "user-agent": helper.DEFAULT_UA
      } }, opts);
      if (options.formatParams !== false) {
        params = formatParams(params);
      }
      params = Object.assign(Object.assign({}, _buildParams()), params);
      const method = (opts.method || "GET").toUpperCase();
      const normalized = normalize(params);
      if (!options.anonymous) {
        const canonicalized = canonicalize(normalized);
        const stringToSign = `${method}&${encode("/")}&${encode(canonicalized)}`;
        const key = accessKeySecret + "&";
        const signature = kitx.sha1(stringToSign, key, "base64");
        normalized.push(["Signature", encode(signature)]);
      }
      const url = opts.method === "POST" ? `${host}/` : `${host}/?${canonicalize(normalized)}`;
      if (opts.method === "POST") {
        opts.headers = opts.headers || {};
        opts.headers["content-type"] = "application/x-www-form-urlencoded";
        opts.data = canonicalize(normalized);
      }
      const response = await httpx_1.default.request(url, opts);
      const buffer = await httpx_1.default.read(response, "utf8");
      const json = JSON.parse(buffer);
      if (json.Code && !STATUS_CODE.has(json.Code)) {
        const err = new Error(`${json.Message}`);
        err.name = json.Code + "Error";
        err.data = json;
        err.code = json.Code;
        err.url = url;
        throw err;
      }
      return json;
    }
    exports2.request = request;
  }
});

// node_modules/@alicloud/credentials/dist/src/rsa_key_pair_credential.js
var require_rsa_key_pair_credential = __commonJS({
  "node_modules/@alicloud/credentials/dist/src/rsa_key_pair_credential.js"(exports2) {
    "use strict";
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    }) : (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      o[k2] = m[k];
    }));
    var __setModuleDefault = exports2 && exports2.__setModuleDefault || (Object.create ? (function(o, v) {
      Object.defineProperty(o, "default", { enumerable: true, value: v });
    }) : function(o, v) {
      o["default"] = v;
    });
    var __importStar = exports2 && exports2.__importStar || function(mod) {
      if (mod && mod.__esModule) return mod;
      var result = {};
      if (mod != null) {
        for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
      }
      __setModuleDefault(result, mod);
      return result;
    };
    var __importDefault = exports2 && exports2.__importDefault || function(mod) {
      return mod && mod.__esModule ? mod : { "default": mod };
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    var fs_1 = __importDefault(require("fs"));
    var session_credential_1 = __importDefault(require_session_credential());
    var utils = __importStar(require_utils());
    var http_1 = require_http();
    var config_1 = __importDefault(require_config());
    var SECURITY_CRED_URL = "http://100.100.100.200/latest/meta-data/ram/security-credentials/";
    var RsaKeyPairCredential = class extends session_credential_1.default {
      constructor(publicKeyId, privateKeyFile) {
        if (!publicKeyId) {
          throw new Error("Missing required publicKeyId option in config for rsa_key_pair");
        }
        if (!privateKeyFile) {
          throw new Error("Missing required privateKeyFile option in config for rsa_key_pair");
        }
        if (!fs_1.default.existsSync(privateKeyFile)) {
          throw new Error(`privateKeyFile ${privateKeyFile} cannot be empty`);
        }
        const conf = new config_1.default({
          type: "rsa_key_pair"
        });
        super(conf);
        this.privateKey = utils.parseFile(privateKeyFile);
        this.publicKeyId = publicKeyId;
      }
      async updateCredential() {
        const url = SECURITY_CRED_URL + this.roleName;
        const json = await (0, http_1.request)(url, {
          accessKeyId: this.publicKeyId,
          action: "GenerateSessionAccessKey",
          durationSeconds: 3600,
          signatureMethod: "SHA256withRSA",
          signatureType: "PRIVATEKEY"
        }, {}, this.privateKey);
        this.sessionCredential = json.Credentials;
      }
    };
    exports2.default = RsaKeyPairCredential;
  }
});

// node_modules/@alicloud/credentials/dist/src/bearer_token_credential.js
var require_bearer_token_credential = __commonJS({
  "node_modules/@alicloud/credentials/dist/src/bearer_token_credential.js"(exports2) {
    "use strict";
    var __importDefault = exports2 && exports2.__importDefault || function(mod) {
      return mod && mod.__esModule ? mod : { "default": mod };
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    var default_credential_1 = __importDefault(require_default_credential());
    var config_1 = __importDefault(require_config());
    var BearerTokenCredential = class extends default_credential_1.default {
      constructor(bearerToken) {
        if (!bearerToken) {
          throw new Error("Missing required bearerToken option in config for bearer");
        }
        const conf = new config_1.default({
          type: "bearer"
        });
        super(conf);
        this.bearerToken = bearerToken;
      }
    };
    exports2.default = BearerTokenCredential;
  }
});

// node_modules/@alicloud/credentials/dist/src/credentials.js
var require_credentials = __commonJS({
  "node_modules/@alicloud/credentials/dist/src/credentials.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.CredentialsBuilder = void 0;
    var Credentials = class {
      constructor(builder) {
        this.accessKeyId = builder.accessKeyId;
        this.accessKeySecret = builder.accessKeySecret;
        this.securityToken = builder.securityToken;
        this.providerName = builder.providerName;
      }
      static builder() {
        return new CredentialsBuilder();
      }
    };
    exports2.default = Credentials;
    var CredentialsBuilder = class {
      withAccessKeyId(value) {
        this.accessKeyId = value;
        return this;
      }
      withAccessKeySecret(value) {
        this.accessKeySecret = value;
        return this;
      }
      withSecurityToken(value) {
        this.securityToken = value;
        return this;
      }
      withProviderName(value) {
        this.providerName = value;
        return this;
      }
      build() {
        return new Credentials(this);
      }
    };
    exports2.CredentialsBuilder = CredentialsBuilder;
  }
});

// node_modules/@alicloud/credentials/dist/src/providers/static_ak.js
var require_static_ak = __commonJS({
  "node_modules/@alicloud/credentials/dist/src/providers/static_ak.js"(exports2) {
    "use strict";
    var __importDefault = exports2 && exports2.__importDefault || function(mod) {
      return mod && mod.__esModule ? mod : { "default": mod };
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.StaticAKCredentialsProviderBuilder = void 0;
    var credentials_1 = __importDefault(require_credentials());
    var StaticAKCredentialsProviderBuilder = class {
      withAccessKeyId(accessKeyId) {
        this.accessKeyId = accessKeyId;
        return this;
      }
      withAccessKeySecret(accessKeySecret) {
        this.accessKeySecret = accessKeySecret;
        return this;
      }
      build() {
        if (!this.accessKeyId) {
          this.accessKeyId = process.env["ALIBABA_CLOUD_ACCESS_KEY_ID"];
        }
        if (!this.accessKeyId) {
          throw new Error("the access key id is empty");
        }
        if (!this.accessKeySecret) {
          this.accessKeySecret = process.env["ALIBABA_CLOUD_ACCESS_KEY_SECRET"];
        }
        if (!this.accessKeySecret) {
          throw new Error("the access key secret is empty");
        }
        return new StaticAKCredentialsProvider(this);
      }
    };
    exports2.StaticAKCredentialsProviderBuilder = StaticAKCredentialsProviderBuilder;
    var StaticAKCredentialsProvider = class {
      static builder() {
        return new StaticAKCredentialsProviderBuilder();
      }
      constructor(builder) {
        this.accessKeyId = builder.accessKeyId;
        this.accessKeySecret = builder.accessKeySecret;
      }
      getProviderName() {
        return "static_ak";
      }
      async getCredentials() {
        const credentials = credentials_1.default.builder().withAccessKeyId(this.accessKeyId).withAccessKeySecret(this.accessKeySecret).withProviderName("static_ak").build();
        return credentials;
      }
    };
    exports2.default = StaticAKCredentialsProvider;
  }
});

// node_modules/@alicloud/credentials/dist/src/providers/static_sts.js
var require_static_sts = __commonJS({
  "node_modules/@alicloud/credentials/dist/src/providers/static_sts.js"(exports2) {
    "use strict";
    var __importDefault = exports2 && exports2.__importDefault || function(mod) {
      return mod && mod.__esModule ? mod : { "default": mod };
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.StaticSTSCredentialsProviderBuilder = void 0;
    var credentials_1 = __importDefault(require_credentials());
    var StaticSTSCredentialsProviderBuilder = class {
      withAccessKeyId(accessKeyId) {
        this.accessKeyId = accessKeyId;
        return this;
      }
      withAccessKeySecret(accessKeySecret) {
        this.accessKeySecret = accessKeySecret;
        return this;
      }
      withSecurityToken(securityToken) {
        this.securityToken = securityToken;
        return this;
      }
      build() {
        if (!this.accessKeyId) {
          this.accessKeyId = process.env["ALIBABA_CLOUD_ACCESS_KEY_ID"];
        }
        if (!this.accessKeyId) {
          throw new Error("the access key id is empty");
        }
        if (!this.accessKeySecret) {
          this.accessKeySecret = process.env["ALIBABA_CLOUD_ACCESS_KEY_SECRET"];
        }
        if (!this.accessKeySecret) {
          throw new Error("the access key secret is empty");
        }
        if (!this.securityToken) {
          this.securityToken = process.env["ALIBABA_CLOUD_SECURITY_TOKEN"];
        }
        if (!this.securityToken) {
          throw new Error("the security token is empty");
        }
        return new StaticSTSCredentialsProvider(this);
      }
    };
    exports2.StaticSTSCredentialsProviderBuilder = StaticSTSCredentialsProviderBuilder;
    var StaticSTSCredentialsProvider = class {
      static builder() {
        return new StaticSTSCredentialsProviderBuilder();
      }
      constructor(builder) {
        this.accessKeyId = builder.accessKeyId;
        this.accessKeySecret = builder.accessKeySecret;
        this.securityToken = builder.securityToken;
      }
      getProviderName() {
        return "static_sts";
      }
      async getCredentials() {
        return credentials_1.default.builder().withAccessKeyId(this.accessKeyId).withAccessKeySecret(this.accessKeySecret).withSecurityToken(this.securityToken).withProviderName(this.getProviderName()).build();
      }
    };
    exports2.default = StaticSTSCredentialsProvider;
  }
});

// node_modules/@alicloud/credentials/dist/src/providers/http.js
var require_http2 = __commonJS({
  "node_modules/@alicloud/credentials/dist/src/providers/http.js"(exports2) {
    "use strict";
    var __importDefault = exports2 && exports2.__importDefault || function(mod) {
      return mod && mod.__esModule ? mod : { "default": mod };
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.doRequest = exports2.Response = exports2.RequestBuilder = exports2.Request = void 0;
    var httpx_1 = __importDefault(require_lib());
    var Request = class {
      static builder() {
        return new RequestBuilder();
      }
      constructor(builder) {
        this.method = builder.method;
        this.protocol = builder.protocol;
        this.host = builder.host;
        this.path = builder.path;
        this.queries = builder.queries;
        this.headers = builder.headers;
        this.bodyForm = builder.bodyForm;
        this.bodyBytes = builder.bodyBytes;
        this.url = builder.url;
        this.readTimeout = builder.readTimeout;
        this.connectTimeout = builder.connectTimeout;
      }
      toRequestURL() {
        if (this.url) {
          return this.url;
        }
        let url = `${this.protocol}://${this.host}${this.path}`;
        if (this.queries && Object.keys(this.queries).length > 0) {
          url += `?` + querystringify(this.queries);
        }
        return url;
      }
    };
    exports2.Request = Request;
    var RequestBuilder = class {
      build() {
        if (!this.protocol) {
          this.protocol = "https";
        }
        if (!this.path) {
          this.path = "/";
        }
        if (!this.headers) {
          this.headers = {};
        }
        if (!this.queries) {
          this.queries = {};
        }
        return new Request(this);
      }
      withMethod(method) {
        this.method = method;
        return this;
      }
      withProtocol(protocol) {
        this.protocol = protocol;
        return this;
      }
      withHost(host) {
        this.host = host;
        return this;
      }
      withPath(path2) {
        this.path = path2;
        return this;
      }
      withQueries(queries) {
        this.queries = queries;
        return this;
      }
      withHeaders(headers) {
        this.headers = headers;
        return this;
      }
      withBodyForm(bodyForm) {
        this.bodyForm = bodyForm;
        return this;
      }
      withURL(url) {
        this.url = url;
        return this;
      }
      withReadTimeout(readTimeout) {
        this.readTimeout = readTimeout;
        return this;
      }
      withConnectTimeout(connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
      }
    };
    exports2.RequestBuilder = RequestBuilder;
    var Response = class {
      static builder() {
        return new ResponseBuilder();
      }
      constructor(builder) {
        this.statusCode = builder.statusCode;
        this.headers = builder.headers;
        this.body = builder.body;
      }
    };
    exports2.Response = Response;
    var ResponseBuilder = class {
      withStatusCode(statusCode) {
        this.statusCode = statusCode;
        return this;
      }
      withHeaders(headers) {
        this.headers = headers;
        return this;
      }
      withBody(body) {
        this.body = body;
        return this;
      }
      constructor() {
        this.headers = {};
      }
      build() {
        return new Response(this);
      }
    };
    function querystringify(queries) {
      const fields = [];
      for (const [key, value] of Object.entries(queries)) {
        fields.push(key + "=" + encodeURIComponent(value));
      }
      return fields.join("&");
    }
    async function doRequest(req) {
      const url = req.toRequestURL();
      let body;
      if (req.bodyForm && Object.keys(req.bodyForm).length > 0) {
        body = querystringify(req.bodyForm);
        if (!req.headers["Content-Type"]) {
          req.headers["Content-Type"] = "application/x-www-form-urlencoded";
        }
      }
      const response = await httpx_1.default.request(url, {
        method: req.method,
        data: body,
        headers: req.headers,
        readTimeout: req.readTimeout,
        connectTimeout: req.connectTimeout
      });
      const responseBody = await httpx_1.default.read(response, "");
      return Response.builder().withStatusCode(response.statusCode).withHeaders(response.headers).withBody(responseBody).build();
    }
    exports2.doRequest = doRequest;
  }
});

// node_modules/@alicloud/credentials/dist/src/providers/time.js
var require_time = __commonJS({
  "node_modules/@alicloud/credentials/dist/src/providers/time.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.parseUTC = void 0;
    function parseUTC(value) {
      if (!value) {
        throw new Error("invalid UTC format time string");
      }
      if (value.length === 20) {
        if (value[4] !== "-" || value[7] !== "-" || value[10] !== "T" || value[13] !== ":" || value[16] !== ":" || value[19] !== "Z") {
          throw new Error("invalid UTC format date string");
        }
      } else if (value.length === 24) {
        if (value[4] !== "-" || value[7] !== "-" || value[10] !== "T" || value[13] !== ":" || value[16] !== ":" || value[19] !== "." || value[23] !== "Z") {
          throw new Error("invalid UTC format date string");
        }
      } else {
        throw new Error("invalid UTC format time string");
      }
      const yearStr = value.slice(0, 4);
      const year = Number.parseInt(yearStr, 10);
      if (isNaN(year)) {
        throw new Error("invalid year string");
      }
      const monthStr = value.slice(5, 7);
      const month = Number.parseInt(monthStr, 10);
      if (isNaN(month)) {
        throw new Error("invalid month string");
      }
      if (month < 1 || month > 12) {
        throw new Error("invalid month value");
      }
      const dateStr = value.slice(8, 10);
      const date = Number.parseInt(dateStr, 10);
      if (isNaN(date)) {
        throw new Error("invalid date string");
      }
      if (date < 1 || date > 31) {
        throw new Error("invalid date value");
      }
      const hoursStr = value.slice(11, 13);
      const hours = Number.parseInt(hoursStr, 10);
      if (isNaN(hours)) {
        throw new Error("invalid hours string");
      }
      if (hours < 0 || hours > 24) {
        throw new Error("invalid hours value");
      }
      const minutesStr = value.slice(14, 16);
      const minutes = Number.parseInt(minutesStr, 10);
      if (isNaN(minutes)) {
        throw new Error("invalid minutes string");
      }
      if (minutes < 0 || minutes > 60) {
        throw new Error("invalid minutes value");
      }
      const secondsStr = value.slice(17, 19);
      const seconds = Number.parseInt(secondsStr, 10);
      if (isNaN(seconds)) {
        throw new Error("invalid seconds string");
      }
      if (seconds < 0 || seconds > 60) {
        throw new Error("invalid seconds value");
      }
      if (value.length === 24) {
        const msStr = value.slice(20, 23);
        const ms = Number.parseInt(msStr, 10);
        if (isNaN(ms)) {
          throw new Error("invalid ms string");
        }
        return Date.UTC(year, month - 1, date, hours, minutes, seconds, ms);
      }
      return Date.UTC(year, month - 1, date, hours, minutes, seconds);
    }
    exports2.parseUTC = parseUTC;
  }
});

// node_modules/@alicloud/credentials/dist/src/providers/session.js
var require_session = __commonJS({
  "node_modules/@alicloud/credentials/dist/src/providers/session.js"(exports2) {
    "use strict";
    var __importDefault = exports2 && exports2.__importDefault || function(mod) {
      return mod && mod.__esModule ? mod : { "default": mod };
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.SessionCredentialProvider = exports2.Session = exports2.STALE_TIME = void 0;
    var time_1 = require_time();
    var utils_1 = require_utils();
    var credentials_1 = __importDefault(require_credentials());
    exports2.STALE_TIME = 15 * 60;
    var Session = class {
      constructor(accessKeyId, accessKeySecret, securityToken, expiration) {
        this.accessKeyId = accessKeyId;
        this.accessKeySecret = accessKeySecret;
        this.securityToken = securityToken;
        this.expiration = expiration;
      }
    };
    exports2.Session = Session;
    var SessionCredentialProvider = class {
      constructor(staleTime = 0, prefetchTime = 0) {
        this.staleTime = staleTime || exports2.STALE_TIME;
        if (prefetchTime) {
          this.prefetchTime = prefetchTime;
          this.prefetchTimestamp = Date.now() + prefetchTime * 1e3;
        }
        this.refreshFaliure = 0;
      }
      async getCredentials() {
        this.session = await this.getSession();
        return credentials_1.default.builder().withAccessKeyId(this.session.accessKeyId).withAccessKeySecret(this.session.accessKeySecret).withSecurityToken(this.session.securityToken).withProviderName(this.getProviderName()).build();
      }
      refreshTimestamp() {
        this.staleTimestamp = this.expirationTimestamp - this.staleTime;
        if (this.prefetchTimestamp) {
          this.prefetchTimestamp = (Date.now() + this.prefetchTime * 1e3) / 1e3;
        }
      }
      maxStaleFailureJitter() {
        const exponentialBackoffMillis = 1 << this.refreshFaliure - 1;
        return exponentialBackoffMillis > 10 ? exponentialBackoffMillis : 10;
      }
      jitterTime(time, jitterStart, jitterEnd) {
        const jitterRange = jitterEnd - jitterStart;
        const jitterAmount = Math.abs(Math.floor(Math.random() * jitterRange));
        return time + jitterStart + jitterAmount;
      }
      async refreshSession() {
        try {
          const session = await this.refresher();
          const now = Date.now() / 1e3;
          const oldSessionAvailable = this.staleTimestamp > now;
          const oldSession = this.session;
          this.expirationTimestamp = (0, time_1.parseUTC)(session.expiration) / 1e3;
          this.session = session;
          this.refreshFaliure = 0;
          this.refreshTimestamp();
          if (this.staleTimestamp > now) {
            return;
          }
          if (now < this.staleTimestamp + this.staleTime) {
            this.expirationTimestamp = now + this.staleTime;
          }
          if (now > this.staleTimestamp + this.staleTime) {
            if (oldSessionAvailable) {
              this.session = oldSession;
              this.expirationTimestamp = (0, time_1.parseUTC)(oldSession.expiration) / 1e3;
              this.refreshTimestamp();
              return;
            }
            const waitUntilNextRefresh = 50 + (0, utils_1.getRandomInt)(20);
            this.expirationTimestamp = now + waitUntilNextRefresh + this.staleTime;
          }
        } catch (err) {
          if (!this.session) {
            throw err;
          }
          const now = Date.now() / 1e3;
          if (now < this.staleTimestamp) {
            return;
          }
          this.refreshFaliure++;
          this.expirationTimestamp = this.jitterTime(now, 1, this.maxStaleFailureJitter()) + this.staleTime;
        }
      }
      async getSession() {
        if (this.needUpdateCredential() || this.shouldPrefetchCredential()) {
          await this.refreshSession();
          this.refreshTimestamp();
        }
        return this.session;
      }
      needUpdateCredential() {
        if (!this.session || !this.expirationTimestamp) {
          return true;
        }
        return Date.now() / 1e3 >= this.staleTimestamp;
      }
      shouldPrefetchCredential() {
        if (!this.prefetchTimestamp) {
          return false;
        }
        return this.expirationTimestamp - Date.now() / 1e3 <= this.prefetchTime;
      }
      getProviderName() {
        return "session";
      }
    };
    exports2.SessionCredentialProvider = SessionCredentialProvider;
  }
});

// node_modules/@alicloud/credentials/dist/src/providers/ram_role_arn.js
var require_ram_role_arn = __commonJS({
  "node_modules/@alicloud/credentials/dist/src/providers/ram_role_arn.js"(exports2) {
    "use strict";
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    }) : (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      o[k2] = m[k];
    }));
    var __setModuleDefault = exports2 && exports2.__setModuleDefault || (Object.create ? (function(o, v) {
      Object.defineProperty(o, "default", { enumerable: true, value: v });
    }) : function(o, v) {
      o["default"] = v;
    });
    var __importStar = exports2 && exports2.__importStar || function(mod) {
      if (mod && mod.__esModule) return mod;
      var result = {};
      if (mod != null) {
        for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
      }
      __setModuleDefault(result, mod);
      return result;
    };
    var __importDefault = exports2 && exports2.__importDefault || function(mod) {
      return mod && mod.__esModule ? mod : { "default": mod };
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    var kitx = __importStar(require_lib3());
    var debug_1 = __importDefault(require_src());
    var utils = __importStar(require_utils());
    var http_1 = require_http2();
    var session_1 = require_session();
    var log = (0, debug_1.default)("sign");
    var RAMRoleARNCredentialsProviderBuilder = class {
      build() {
        if (!this.credentialsProvider) {
          throw new Error("must specify a previous credentials provider to asssume role");
        }
        if (!(this.roleArn = this.roleArn || process.env.ALIBABA_CLOUD_ROLE_ARN))
          throw new Error("the RoleArn is empty");
        if (!this.roleSessionName) {
          this.roleSessionName = process.env.ALIBABA_CLOUD_ROLE_SESSION_NAME || "credentials-nodejs-" + Date.now();
        }
        if (!this.stsRegionId) {
          this.stsRegionId = process.env.ALIBABA_CLOUD_STS_REGION;
        }
        if (!this.enableVpc) {
          this.enableVpc = process.env.ALIBABA_CLOUD_VPC_ENDPOINT_ENABLED && process.env.ALIBABA_CLOUD_VPC_ENDPOINT_ENABLED.toLowerCase() === "true" || false;
        }
        if (!this.durationSeconds) {
          this.durationSeconds = 3600;
        }
        if (this.durationSeconds < 900) {
          throw new Error("session duration should be in the range of 900s - max session duration");
        }
        if (!this.stsEndpoint) {
          if (this.stsRegionId) {
            if (this.enableVpc) {
              this.stsEndpoint = `sts-vpc.${this.stsRegionId}.aliyuncs.com`;
            } else {
              this.stsEndpoint = `sts.${this.stsRegionId}.aliyuncs.com`;
            }
          } else {
            this.stsEndpoint = "sts.aliyuncs.com";
          }
        }
        return new RAMRoleARNCredentialsProvider(this);
      }
      withCredentialsProvider(credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
        return this;
      }
      withRoleArn(roleArn) {
        this.roleArn = roleArn;
        return this;
      }
      withStsRegionId(regionId) {
        this.stsRegionId = regionId;
        return this;
      }
      withStsEndpoint(endpoint) {
        this.stsEndpoint = endpoint;
        return this;
      }
      withRoleSessionName(roleSessionName) {
        this.roleSessionName = roleSessionName;
        return this;
      }
      withPolicy(policy) {
        this.policy = policy;
        return this;
      }
      withExternalId(externalId) {
        this.externalId = externalId;
        return this;
      }
      withDurationSeconds(durationSeconds) {
        this.durationSeconds = durationSeconds;
        return this;
      }
      withEnableVpc(enableVpc) {
        this.enableVpc = enableVpc;
        return this;
      }
      withReadTimeout(readTimeout) {
        this.readTimeout = readTimeout;
        return this;
      }
      withConnectTimeout(connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
      }
    };
    function encode(str) {
      const result = encodeURIComponent(str);
      return result.replace(/!/g, "%21").replace(/'/g, "%27").replace(/\(/g, "%28").replace(/\)/g, "%29").replace(/\*/g, "%2A");
    }
    var RAMRoleARNCredentialsProvider = class extends session_1.SessionCredentialProvider {
      static builder() {
        return new RAMRoleARNCredentialsProviderBuilder();
      }
      constructor(builder) {
        super(session_1.STALE_TIME);
        this.doRequest = http_1.doRequest;
        this.refresher = this.getCredentialsInternal;
        this.credentialsProvider = builder.credentialsProvider;
        this.stsEndpoint = builder.stsEndpoint;
        this.roleSessionName = builder.roleSessionName;
        this.policy = builder.policy;
        this.durationSeconds = builder.durationSeconds;
        this.roleArn = builder.roleArn;
        this.externalId = builder.externalId;
        this.readTimeout = builder.readTimeout;
        this.connectTimeout = builder.connectTimeout;
      }
      async getCredentialsInternal() {
        const credentials = await this.credentialsProvider.getCredentials();
        const method = "POST";
        const builder = http_1.Request.builder().withMethod(method).withProtocol("https").withHost(this.stsEndpoint).withReadTimeout(this.readTimeout || 1e4).withConnectTimeout(this.connectTimeout || 5e3);
        const queries = /* @__PURE__ */ Object.create(null);
        queries["Version"] = "2015-04-01";
        queries["Action"] = "AssumeRole";
        queries["Format"] = "JSON";
        queries["Timestamp"] = utils.timestamp();
        queries["SignatureMethod"] = "HMAC-SHA1";
        queries["SignatureVersion"] = "1.0";
        queries["SignatureNonce"] = kitx.makeNonce();
        queries["AccessKeyId"] = credentials.accessKeyId;
        if (credentials.securityToken) {
          queries["SecurityToken"] = credentials.securityToken;
        }
        const bodyForm = /* @__PURE__ */ Object.create(null);
        bodyForm["RoleArn"] = this.roleArn;
        if (this.policy) {
          bodyForm["Policy"] = this.policy;
        }
        if (this.externalId) {
          bodyForm["ExternalId"] = this.externalId;
        }
        bodyForm["RoleSessionName"] = this.roleSessionName;
        bodyForm["DurationSeconds"] = `${this.durationSeconds}`;
        builder.withBodyForm(bodyForm);
        const signParams = /* @__PURE__ */ Object.create(null);
        for (const [key, value] of Object.entries(queries)) {
          signParams[key] = value;
        }
        for (const [key, value] of Object.entries(bodyForm)) {
          signParams[key] = value;
        }
        const keys = Object.keys(signParams).sort();
        const stringToSign = `${method}&${encode("/")}&${encode(keys.map((key) => {
          return `${encode(key)}=${encode(signParams[key])}`;
        }).join("&"))}`;
        log("stringToSign[Client]:");
        log(stringToSign);
        const secret = credentials.accessKeySecret + "&";
        const signature = kitx.sha1(stringToSign, secret, "base64");
        queries["Signature"] = signature;
        builder.withQueries(queries);
        const headers = /* @__PURE__ */ Object.create(null);
        headers["Content-Type"] = "application/x-www-form-urlencoded";
        headers["x-acs-credentials-provider"] = credentials.providerName;
        builder.withHeaders(headers);
        const request = builder.build();
        const response = await this.doRequest(request);
        if (response.statusCode != 200) {
          if (response.headers["content-type"] && response.headers["content-type"].startsWith("application/json")) {
            const body = JSON.parse(response.body.toString("utf8"));
            const serverStringToSign = body.Message.slice("Specified signature is not matched with our calculation. server string to sign is:".length);
            log("stringToSign[Server]:");
            log(stringToSign);
            if (body.Code === "SignatureDoesNotMatch" && serverStringToSign === stringToSign) {
              throw new Error(`the access key secret is invalid`);
            }
          }
          throw new Error(`refresh session token failed: ${response.body.toString("utf8")}`);
        }
        let data;
        try {
          data = JSON.parse(response.body.toString("utf8"));
        } catch (ex) {
          throw new Error(`refresh RoleArn sts token err, unmarshal fail: ${response.body.toString("utf8")}`);
        }
        if (!data || !data.Credentials) {
          throw new Error(`refresh RoleArn sts token err, fail to get credentials`);
        }
        if (!data.Credentials.AccessKeyId || !data.Credentials.AccessKeySecret || !data.Credentials.SecurityToken) {
          throw new Error("refresh RoleArn sts token err, fail to get credentials");
        }
        const { AccessKeyId, AccessKeySecret, SecurityToken, Expiration } = data.Credentials;
        return new session_1.Session(AccessKeyId, AccessKeySecret, SecurityToken, Expiration);
      }
      getProviderName() {
        return `ram_role_arn/${this.credentialsProvider.getProviderName()}`;
      }
    };
    exports2.default = RAMRoleARNCredentialsProvider;
  }
});

// node_modules/@alicloud/credentials/dist/src/providers/oidc_role_arn.js
var require_oidc_role_arn = __commonJS({
  "node_modules/@alicloud/credentials/dist/src/providers/oidc_role_arn.js"(exports2) {
    "use strict";
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    }) : (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      o[k2] = m[k];
    }));
    var __setModuleDefault = exports2 && exports2.__setModuleDefault || (Object.create ? (function(o, v) {
      Object.defineProperty(o, "default", { enumerable: true, value: v });
    }) : function(o, v) {
      o["default"] = v;
    });
    var __importStar = exports2 && exports2.__importStar || function(mod) {
      if (mod && mod.__esModule) return mod;
      var result = {};
      if (mod != null) {
        for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
      }
      __setModuleDefault(result, mod);
      return result;
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    var fs_1 = require("fs");
    var util_1 = require("util");
    var session_1 = require_session();
    var utils = __importStar(require_utils());
    var http_1 = require_http2();
    var readFileAsync = (0, util_1.promisify)(fs_1.readFile);
    var OIDCRoleArnCredentialsProviderBuilder = class {
      withOIDCProviderArn(oidcProviderArn) {
        this.oidcProviderArn = oidcProviderArn;
        return this;
      }
      withOIDCTokenFilePath(path2) {
        this.oidcTokenFilePath = path2;
        return this;
      }
      withRoleArn(roleArn) {
        this.roleArn = roleArn;
        return this;
      }
      withRoleSessionName(roleSessionName) {
        this.roleSessionName = roleSessionName;
        return this;
      }
      withDurationSeconds(durationSeconds) {
        this.durationSeconds = durationSeconds;
        return this;
      }
      withStsEndpoint(stsEndpoint) {
        this.stsEndpoint = stsEndpoint;
        return this;
      }
      withStsRegionId(regionId) {
        this.stsRegionId = regionId;
        return this;
      }
      withPolicy(policy) {
        this.policy = policy;
        return this;
      }
      withEnableVpc(enableVpc) {
        this.enableVpc = enableVpc;
        return this;
      }
      withReadTimeout(readTimeout) {
        this.readTimeout = readTimeout;
        return this;
      }
      withConnectTimeout(connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
      }
      build() {
        if (!this.oidcProviderArn) {
          this.oidcProviderArn = process.env.ALIBABA_CLOUD_OIDC_PROVIDER_ARN;
        }
        if (!this.oidcTokenFilePath) {
          this.oidcTokenFilePath = process.env.ALIBABA_CLOUD_OIDC_TOKEN_FILE;
        }
        if (!this.roleSessionName) {
          this.roleSessionName = process.env.ALIBABA_CLOUD_ROLE_SESSION_NAME;
        }
        if (!this.durationSeconds) {
          this.durationSeconds = 3600;
        }
        if (!this.roleArn) {
          this.roleArn = process.env.ALIBABA_CLOUD_ROLE_ARN;
        }
        if (!this.roleArn) {
          throw new Error("roleArn does not exist and env ALIBABA_CLOUD_ROLE_ARN is null.");
        }
        if (!this.oidcProviderArn) {
          throw new Error("oidcProviderArn does not exist and env ALIBABA_CLOUD_OIDC_PROVIDER_ARN is null.");
        }
        if (!this.oidcTokenFilePath) {
          throw new Error("oidcTokenFilePath is not exists and env ALIBABA_CLOUD_OIDC_TOKEN_FILE is null.");
        }
        if (!this.roleSessionName) {
          this.roleSessionName = "credentials-nodejs-" + Date.now();
        }
        if (this.durationSeconds < 900) {
          throw new Error("session duration should be in the range of 900s - max session duration");
        }
        if (!this.stsRegionId) {
          this.stsRegionId = process.env.ALIBABA_CLOUD_STS_REGION;
        }
        if (!this.enableVpc) {
          this.enableVpc = process.env.ALIBABA_CLOUD_VPC_ENDPOINT_ENABLED && process.env.ALIBABA_CLOUD_VPC_ENDPOINT_ENABLED.toLowerCase() === "true" || false;
        }
        if (!this.stsEndpoint) {
          if (this.stsRegionId) {
            if (this.enableVpc) {
              this.stsEndpoint = `sts-vpc.${this.stsRegionId}.aliyuncs.com`;
            } else {
              this.stsEndpoint = `sts.${this.stsRegionId}.aliyuncs.com`;
            }
          } else {
            this.stsEndpoint = "sts.aliyuncs.com";
          }
        }
        return new OIDCRoleArnCredentialsProvider(this);
      }
    };
    var OIDCRoleArnCredentialsProvider = class extends session_1.SessionCredentialProvider {
      static builder() {
        return new OIDCRoleArnCredentialsProviderBuilder();
      }
      constructor(builder) {
        super(session_1.STALE_TIME);
        this.doRequest = http_1.doRequest;
        this.refresher = this.getCredentialsInternal;
        this.roleArn = builder.roleArn;
        this.oidcProviderArn = builder.oidcProviderArn;
        this.oidcTokenFilePath = builder.oidcTokenFilePath;
        this.policy = builder.policy;
        this.durationSeconds = builder.durationSeconds;
        this.roleSessionName = builder.roleSessionName;
        this.stsEndpoint = builder.stsEndpoint;
        this.readTimeout = builder.readTimeout;
        this.connectTimeout = builder.connectTimeout;
        this.doRequest = http_1.doRequest;
      }
      getProviderName() {
        return "oidc_role_arn";
      }
      async getCredentialsInternal() {
        const oidcToken = await readFileAsync(this.oidcTokenFilePath, "utf8");
        const builder = http_1.Request.builder().withMethod("POST").withProtocol("https").withHost(this.stsEndpoint).withReadTimeout(this.readTimeout || 1e4).withConnectTimeout(this.connectTimeout || 5e3);
        const queries = /* @__PURE__ */ Object.create(null);
        queries["Version"] = "2015-04-01";
        queries["Action"] = "AssumeRoleWithOIDC";
        queries["Format"] = "JSON";
        queries["Timestamp"] = utils.timestamp();
        builder.withQueries(queries);
        const bodyForm = /* @__PURE__ */ Object.create(null);
        bodyForm["OIDCProviderArn"] = this.oidcProviderArn;
        bodyForm["OIDCToken"] = oidcToken;
        bodyForm["RoleArn"] = this.roleArn;
        if (this.policy) {
          bodyForm["Policy"] = this.policy;
        }
        bodyForm["RoleSessionName"] = this.roleSessionName;
        bodyForm["DurationSeconds"] = `${this.durationSeconds}`;
        builder.withBodyForm(bodyForm);
        const headers = /* @__PURE__ */ Object.create(null);
        headers["Content-Type"] = "application/x-www-form-urlencoded";
        builder.withHeaders(headers);
        const request = builder.build();
        const response = await this.doRequest(request);
        if (response.statusCode !== 200) {
          throw new Error(`get sts token failed with OIDC: ${response.body.toString("utf8")}`);
        }
        let data;
        try {
          data = JSON.parse(response.body.toString("utf8"));
        } catch (ex) {
          throw new Error(`get sts token failed with OIDC, unmarshal fail: ${response.body.toString("utf8")}`);
        }
        if (!data || !data.Credentials) {
          throw new Error(`get sts token failed with OIDC`);
        }
        const { AccessKeyId, AccessKeySecret, SecurityToken, Expiration } = data.Credentials;
        if (!AccessKeyId || !AccessKeySecret || !SecurityToken) {
          throw new Error("get sts token failed with OIDC");
        }
        return new session_1.Session(AccessKeyId, AccessKeySecret, SecurityToken, Expiration);
      }
    };
    exports2.default = OIDCRoleArnCredentialsProvider;
  }
});

// node_modules/@alicloud/credentials/dist/src/providers/ecs_ram_role.js
var require_ecs_ram_role = __commonJS({
  "node_modules/@alicloud/credentials/dist/src/providers/ecs_ram_role.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var http_1 = require_http2();
    var session_1 = require_session();
    var PREFETCH_TIME = 60 * 60;
    var defaultMetadataTokenDuration = 21600;
    var ECSRAMRoleCredentialsProvider = class extends session_1.SessionCredentialProvider {
      static builder() {
        return new ECSRAMRoleCredentialsProviderBuilder();
      }
      constructor(builder) {
        super(session_1.STALE_TIME, PREFETCH_TIME);
        this.doRequest = http_1.doRequest;
        this.refresher = this.getCredentialsInternal;
        this.roleName = builder.roleName;
        this.disableIMDSv1 = builder.disableIMDSv1;
        this.readTimeout = builder.readTimeout;
        this.connectTimeout = builder.connectTimeout;
        this.checker = null;
        this.shouldRefreshCred = false;
        if (builder.asyncCredentialUpdateEnabled) {
          this.checker = this.checkCredentialsUpdateAsynchronously();
        }
      }
      checkCredentialsUpdateAsynchronously() {
        return setTimeout(async () => {
          try {
            if (this.shouldRefreshCred) {
              await this.getCredentials();
            }
          } catch (err) {
            console.error("CheckCredentialsUpdateAsynchronously Error:", err);
          } finally {
            this.checker = this.checkCredentialsUpdateAsynchronously();
          }
        }, 1e3 * 60);
      }
      close() {
        if (this.checker != null) {
          clearTimeout(this.checker);
          this.checker = null;
        }
      }
      async getMetadataToken() {
        const request = http_1.Request.builder().withMethod("PUT").withProtocol("http").withHost("100.100.100.200").withPath("/latest/api/token").withHeaders({
          "x-aliyun-ecs-metadata-token-ttl-seconds": `${defaultMetadataTokenDuration}`
        }).withReadTimeout(this.readTimeout || 1e3).withConnectTimeout(this.connectTimeout || 1e3).build();
        try {
          const response = await this.doRequest(request);
          if (response.statusCode !== 200) {
            throw new Error(`get metadata token failed with ${response.statusCode}`);
          }
          return response.body.toString("utf8");
        } catch (error) {
          if (this.disableIMDSv1) {
            throw error;
          }
          return null;
        }
      }
      async getRoleName() {
        const builder = http_1.Request.builder().withMethod("GET").withProtocol("http").withHost("100.100.100.200").withPath("/latest/meta-data/ram/security-credentials/").withReadTimeout(this.readTimeout || 1e3).withConnectTimeout(this.connectTimeout || 1e3);
        const metadataToken = await this.getMetadataToken();
        if (metadataToken !== null) {
          builder.withHeaders({
            "x-aliyun-ecs-metadata-token": metadataToken
          });
        }
        const request = builder.build();
        const response = await this.doRequest(request);
        if (response.statusCode !== 200) {
          throw new Error(`get role name failed: ${request.method} ${request.toRequestURL()} ${response.statusCode}`);
        }
        return response.body.toString().trim();
      }
      async getCredentialsInternal() {
        let roleName = this.roleName;
        if (!roleName) {
          roleName = await this.getRoleName();
        }
        const builder = http_1.Request.builder().withMethod("GET").withProtocol("http").withHost("100.100.100.200").withPath(`/latest/meta-data/ram/security-credentials/${roleName}`).withReadTimeout(this.readTimeout || 1e3).withConnectTimeout(this.connectTimeout || 1e3);
        const metadataToken = await this.getMetadataToken();
        if (metadataToken !== null) {
          builder.withHeaders({
            "x-aliyun-ecs-metadata-token": metadataToken
          });
        }
        const request = builder.build();
        const response = await this.doRequest(request);
        if (response.statusCode !== 200) {
          throw new Error(`get sts token failed, httpStatus: ${response.statusCode}, message = ${response.body.toString()}`);
        }
        let data;
        try {
          data = JSON.parse(response.body.toString());
        } catch (ex) {
          throw new Error(`get sts token failed, json parse failed: ${ex.message}`);
        }
        if (!data || !data.AccessKeyId || !data.AccessKeySecret || !data.SecurityToken) {
          throw new Error("get sts token failed");
        }
        if (data.Code !== "Success") {
          throw new Error("refresh Ecs sts token err, Code is not Success");
        }
        this.shouldRefreshCred = true;
        return new session_1.Session(data.AccessKeyId, data.AccessKeySecret, data.SecurityToken, data.Expiration);
      }
      getProviderName() {
        return "ecs_ram_role";
      }
    };
    exports2.default = ECSRAMRoleCredentialsProvider;
    var ECSRAMRoleCredentialsProviderBuilder = class {
      constructor() {
        this.disableIMDSv1 = false;
        this.asyncCredentialUpdateEnabled = false;
      }
      withRoleName(roleName) {
        this.roleName = roleName;
        return this;
      }
      withDisableIMDSv1(disableIMDSv1) {
        this.disableIMDSv1 = disableIMDSv1;
        return this;
      }
      withReadTimeout(readTimeout) {
        this.readTimeout = readTimeout;
        return this;
      }
      withConnectTimeout(connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
      }
      withAsyncCredentialUpdateEnabled(asyncCredentialUpdateEnabled) {
        this.asyncCredentialUpdateEnabled = asyncCredentialUpdateEnabled;
        return this;
      }
      build() {
        if (process.env.ALIBABA_CLOUD_ECS_METADATA_DISABLED && process.env.ALIBABA_CLOUD_ECS_METADATA_DISABLED.toLowerCase() === "true") {
          throw new Error("IMDS credentials is disabled");
        }
        if (!this.roleName) {
          this.roleName = process.env.ALIBABA_CLOUD_ECS_METADATA;
        }
        if (process.env.ALIBABA_CLOUD_IMDSV1_DISABLED && process.env.ALIBABA_CLOUD_IMDSV1_DISABLED.toLowerCase() === "true") {
          this.disableIMDSv1 = true;
        }
        return new ECSRAMRoleCredentialsProvider(this);
      }
    };
  }
});

// node_modules/@alicloud/credentials/dist/src/providers/cli_profile.js
var require_cli_profile = __commonJS({
  "node_modules/@alicloud/credentials/dist/src/providers/cli_profile.js"(exports2) {
    "use strict";
    var __importDefault = exports2 && exports2.__importDefault || function(mod) {
      return mod && mod.__esModule ? mod : { "default": mod };
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.getProfile = exports2.getConfiguration = void 0;
    var fs_1 = require("fs");
    var util_1 = require("util");
    var path_1 = __importDefault(require("path"));
    var os_1 = __importDefault(require("os"));
    var credentials_1 = __importDefault(require_credentials());
    var static_ak_1 = __importDefault(require_static_ak());
    var static_sts_1 = __importDefault(require_static_sts());
    var ram_role_arn_1 = __importDefault(require_ram_role_arn());
    var oidc_role_arn_1 = __importDefault(require_oidc_role_arn());
    var ecs_ram_role_1 = __importDefault(require_ecs_ram_role());
    var readFileAsync = (0, util_1.promisify)(fs_1.readFile);
    var CLIProfileCredentialsProviderBuilder = class {
      build() {
        if (!this.profileName) {
          this.profileName = process.env.ALIBABA_CLOUD_PROFILE;
        }
        if (process.env.ALIBABA_CLOUD_CLI_PROFILE_DISABLED && process.env.ALIBABA_CLOUD_CLI_PROFILE_DISABLED.toLowerCase() === "true") {
          throw new Error("the CLI profile is disabled");
        }
        return new CLIProfileCredentialsProvider(this);
      }
      withProfileName(profileName) {
        this.profileName = profileName;
        return this;
      }
    };
    async function getConfiguration(cfgPath) {
      let content;
      try {
        content = await readFileAsync(cfgPath, "utf8");
      } catch (ex) {
        throw new Error(`reading aliyun cli config from '${cfgPath}' failed.`);
      }
      let conf;
      try {
        conf = JSON.parse(content);
      } catch (ex) {
        throw new Error(`parse aliyun cli config from '${cfgPath}' failed: ${content}`);
      }
      if (!conf || !conf.profiles || conf.profiles.length === 0) {
        throw new Error(`no any configured profiles in '${cfgPath}'`);
      }
      return conf;
    }
    exports2.getConfiguration = getConfiguration;
    function getProfile(conf, profileName) {
      for (const p of conf.profiles) {
        if (p.name === profileName) {
          return p;
        }
      }
      throw new Error(`unable to get profile with '${profileName}'`);
    }
    exports2.getProfile = getProfile;
    var CLIProfileCredentialsProvider = class {
      static builder() {
        return new CLIProfileCredentialsProviderBuilder();
      }
      constructor(builder) {
        this.homedir = os_1.default.homedir();
        this.profileName = builder.profileName;
      }
      getCredentialsProvider(conf, profileName) {
        const p = getProfile(conf, profileName);
        switch (p.mode) {
          case "AK":
            return static_ak_1.default.builder().withAccessKeyId(p.access_key_id).withAccessKeySecret(p.access_key_secret).build();
          case "StsToken":
            return static_sts_1.default.builder().withAccessKeyId(p.access_key_id).withAccessKeySecret(p.access_key_secret).withSecurityToken(p.sts_token).build();
          case "RamRoleArn": {
            const previousProvider = static_ak_1.default.builder().withAccessKeyId(p.access_key_id).withAccessKeySecret(p.access_key_secret).build();
            return ram_role_arn_1.default.builder().withCredentialsProvider(previousProvider).withRoleArn(p.ram_role_arn).withRoleSessionName(p.ram_session_name).withDurationSeconds(p.expired_seconds).withStsRegionId(p.sts_region).withStsEndpoint(p.sts_endpoint).withEnableVpc(p.enable_vpc).build();
          }
          case "EcsRamRole":
            return ecs_ram_role_1.default.builder().withRoleName(p.ram_role_name).build();
          case "OIDC":
            return oidc_role_arn_1.default.builder().withOIDCTokenFilePath(p.oidc_token_file).withOIDCProviderArn(p.oidc_provider_arn).withRoleArn(p.ram_role_arn).withStsRegionId(p.sts_region).withDurationSeconds(p.expired_seconds).withRoleSessionName(p.ram_session_name).withDurationSeconds(p.duration_seconds).withEnableVpc(p.enable_vpc).build();
          case "ChainableRamRoleArn": {
            const previousProvider = this.getCredentialsProvider(conf, p.source_profile);
            return ram_role_arn_1.default.builder().withCredentialsProvider(previousProvider).withRoleArn(p.ram_role_arn).withRoleSessionName(p.ram_session_name).withDurationSeconds(p.expired_seconds).withStsRegionId(p.sts_region).build();
          }
          default:
            throw new Error(`unsupported profile mode '${p.mode}'`);
        }
      }
      async getCredentials() {
        if (!this.innerProvider) {
          if (!this.homedir) {
            throw new Error("cannot found home dir");
          }
          const cfgPath = path_1.default.join(this.homedir, ".aliyun/config.json");
          const conf = await getConfiguration(cfgPath);
          const profileName = this.profileName || conf.current;
          this.innerProvider = this.getCredentialsProvider(conf, profileName);
        }
        const credentials = await this.innerProvider.getCredentials();
        return credentials_1.default.builder().withAccessKeyId(credentials.accessKeyId).withAccessKeySecret(credentials.accessKeySecret).withSecurityToken(credentials.securityToken).withProviderName(`${this.getProviderName()}/${this.innerProvider.getProviderName()}`).build();
      }
      getProviderName() {
        return "cli_profile";
      }
    };
    exports2.default = CLIProfileCredentialsProvider;
  }
});

// node_modules/@alicloud/credentials/dist/src/providers/env.js
var require_env = __commonJS({
  "node_modules/@alicloud/credentials/dist/src/providers/env.js"(exports2) {
    "use strict";
    var __importDefault = exports2 && exports2.__importDefault || function(mod) {
      return mod && mod.__esModule ? mod : { "default": mod };
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    var credentials_1 = __importDefault(require_credentials());
    var EnvironmentVariableCredentialsProvider = class {
      static builder() {
        return new EnvironmentVariableCredentialsProviderBuilder();
      }
      async getCredentials() {
        const accessKeyId = process.env.ALIBABA_CLOUD_ACCESS_KEY_ID;
        if (!accessKeyId) {
          throw new Error("unable to get credentials from enviroment variables, Access key ID must be specified via environment variable (ALIBABA_CLOUD_ACCESS_KEY_ID)");
        }
        const accessKeySecret = process.env.ALIBABA_CLOUD_ACCESS_KEY_SECRET;
        if (!accessKeySecret) {
          throw new Error("unable to get credentials from enviroment variables, Access key secret must be specified via environment variable (ALIBABA_CLOUD_ACCESS_KEY_SECRET)");
        }
        const securityToken = process.env.ALIBABA_CLOUD_SECURITY_TOKEN;
        return credentials_1.default.builder().withAccessKeyId(accessKeyId).withAccessKeySecret(accessKeySecret).withSecurityToken(securityToken).withProviderName(this.getProviderName()).build();
      }
      getProviderName() {
        return "env";
      }
      constructor(builder) {
      }
    };
    exports2.default = EnvironmentVariableCredentialsProvider;
    var EnvironmentVariableCredentialsProviderBuilder = class {
      build() {
        return new EnvironmentVariableCredentialsProvider(this);
      }
    };
  }
});

// node_modules/@alicloud/credentials/dist/src/providers/uri.js
var require_uri = __commonJS({
  "node_modules/@alicloud/credentials/dist/src/providers/uri.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.URICredentialsProviderBuilder = void 0;
    var session_1 = require_session();
    var http_1 = require_http2();
    var URICredentialsProvider = class extends session_1.SessionCredentialProvider {
      static builder() {
        return new URICredentialsProviderBuilder();
      }
      constructor(builder) {
        super(session_1.STALE_TIME);
        this.doRequest = http_1.doRequest;
        this.refresher = this.getCredentialsUri;
        this.credentialsURI = builder.credentialsURI;
        this.readTimeout = builder.readTimeout;
        this.connectTimeout = builder.connectTimeout;
      }
      getProviderName() {
        return "credential_uri";
      }
      async getCredentialsUri() {
        const builder = http_1.Request.builder().withMethod("GET").withURL(this.credentialsURI).withReadTimeout(this.readTimeout || 1e4).withConnectTimeout(this.connectTimeout || 5e3);
        const request = builder.build();
        const response = await this.doRequest(request);
        if (response.statusCode !== 200) {
          throw new Error(`get sts token failed, httpStatus: ${response.statusCode}, message = ${response.body.toString("utf8")}.`);
        }
        let data;
        try {
          data = JSON.parse(response.body.toString("utf8"));
        } catch (ex) {
          throw new Error(`get sts token failed, json parse failed: ${ex.message}, result: ${response.body.toString("utf8")}.`);
        }
        if (!data || !data.AccessKeyId || !data.AccessKeySecret || !data.SecurityToken) {
          throw new Error(`error retrieving credentials from credentialsURI result: ${JSON.stringify(data)}.`);
        }
        return new session_1.Session(data.AccessKeyId, data.AccessKeySecret, data.SecurityToken, data.Expiration);
      }
    };
    exports2.default = URICredentialsProvider;
    var URICredentialsProviderBuilder = class {
      withCredentialsURI(credentialsURI) {
        this.credentialsURI = credentialsURI;
        return this;
      }
      withReadTimeout(readTimeout) {
        this.readTimeout = readTimeout;
        return this;
      }
      withConnectTimeout(connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
      }
      build() {
        if (!this.credentialsURI) {
          this.credentialsURI = process.env.ALIBABA_CLOUD_CREDENTIALS_URI;
        }
        return new URICredentialsProvider(this);
      }
    };
    exports2.URICredentialsProviderBuilder = URICredentialsProviderBuilder;
  }
});

// node_modules/@alicloud/credentials/dist/src/providers/profile.js
var require_profile = __commonJS({
  "node_modules/@alicloud/credentials/dist/src/providers/profile.js"(exports2) {
    "use strict";
    var __importDefault = exports2 && exports2.__importDefault || function(mod) {
      return mod && mod.__esModule ? mod : { "default": mod };
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    var path_1 = __importDefault(require("path"));
    var os_1 = __importDefault(require("os"));
    var credentials_1 = __importDefault(require_credentials());
    var utils_1 = require_utils();
    var static_ak_1 = __importDefault(require_static_ak());
    var ecs_ram_role_1 = __importDefault(require_ecs_ram_role());
    var ram_role_arn_1 = __importDefault(require_ram_role_arn());
    var ProfileCredentialsProvider = class {
      async getCredentials() {
        if (!this.innerProvider) {
          let sharedCfgPath = process.env.ALIBABA_CLOUD_CREDENTIALS_FILE;
          if (!sharedCfgPath) {
            if (!this.homedir) {
              throw new Error("cannot found home dir");
            }
            sharedCfgPath = path_1.default.join(this.homedir, ".alibabacloud/credentials");
          }
          const ini = await (0, utils_1.loadIni)(sharedCfgPath);
          this.innerProvider = this.getCredentialsProvider(ini);
        }
        const credentials = await this.innerProvider.getCredentials();
        return credentials_1.default.builder().withAccessKeyId(credentials.accessKeyId).withAccessKeySecret(credentials.accessKeySecret).withSecurityToken(credentials.securityToken).withProviderName(`${this.getProviderName()}/${this.innerProvider.getProviderName()}`).build();
      }
      getCredentialsProvider(ini) {
        const config2 = ini[this.profileName] || {};
        if (!config2.type) {
          throw new Error(`Can not find credential type for "${this.profileName}"`);
        }
        switch (config2.type) {
          case "access_key":
            return static_ak_1.default.builder().withAccessKeyId(config2.access_key_id).withAccessKeySecret(config2.access_key_secret).build();
          case "ecs_ram_role":
            return ecs_ram_role_1.default.builder().withRoleName(config2.role_name).build();
          case "ram_role_arn": {
            const previous = static_ak_1.default.builder().withAccessKeyId(config2.access_key_id).withAccessKeySecret(config2.access_key_secret).build();
            return ram_role_arn_1.default.builder().withCredentialsProvider(previous).withRoleArn(config2.role_arn).withRoleSessionName(config2.role_session_name).withPolicy(config2.policy).build();
          }
          default:
            throw new Error("Invalid type option, support: access_key, ecs_ram_role, ram_role_arn");
        }
      }
      getProviderName() {
        return "profile";
      }
      static builder() {
        return new ProfileCredentialsProviderBuilder();
      }
      constructor(builder) {
        this.homedir = os_1.default.homedir();
        this.profileName = builder.profileName;
      }
    };
    exports2.default = ProfileCredentialsProvider;
    var ProfileCredentialsProviderBuilder = class {
      withProfileName(profileName) {
        this.profileName = profileName;
        return this;
      }
      build() {
        if (!this.profileName) {
          this.profileName = process.env.ALIBABA_CLOUD_PROFILE || "default";
        }
        return new ProfileCredentialsProvider(this);
      }
    };
  }
});

// node_modules/@alicloud/credentials/dist/src/providers/default.js
var require_default = __commonJS({
  "node_modules/@alicloud/credentials/dist/src/providers/default.js"(exports2) {
    "use strict";
    var __importDefault = exports2 && exports2.__importDefault || function(mod) {
      return mod && mod.__esModule ? mod : { "default": mod };
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    var credentials_1 = __importDefault(require_credentials());
    var cli_profile_1 = __importDefault(require_cli_profile());
    var ecs_ram_role_1 = __importDefault(require_ecs_ram_role());
    var env_1 = __importDefault(require_env());
    var oidc_role_arn_1 = __importDefault(require_oidc_role_arn());
    var uri_1 = __importDefault(require_uri());
    var profile_1 = __importDefault(require_profile());
    var DefaultCredentialsProvider = class {
      static builder() {
        return new DefaultCredentialsProviderBuilder();
      }
      constructor(builder) {
        this.providers = [];
        try {
          const envProvider = env_1.default.builder().build();
          this.providers.push(envProvider);
        } catch (ex) {
        }
        try {
          const oidcProvider = oidc_role_arn_1.default.builder().build();
          this.providers.push(oidcProvider);
        } catch (ex) {
        }
        try {
          const cliProfileProvider = cli_profile_1.default.builder().build();
          this.providers.push(cliProfileProvider);
        } catch (ex) {
        }
        try {
          const profileProvider = profile_1.default.builder().build();
          this.providers.push(profileProvider);
        } catch (ex) {
        }
        try {
          const ecsRamRoleProvider = ecs_ram_role_1.default.builder().withRoleName(process.env.ALIBABA_CLOUD_ECS_METADATA).build();
          this.providers.push(ecsRamRoleProvider);
        } catch (ex) {
        }
        try {
          const uriProvider = uri_1.default.builder().withCredentialsURI(process.env.ALIBABA_CLOUD_CREDENTIALS_URI).build();
          this.providers.push(uriProvider);
        } catch (ex) {
        }
      }
      async getCredentials() {
        if (this.lastUsedProvider) {
          const inner = await this.lastUsedProvider.getCredentials();
          return credentials_1.default.builder().withAccessKeyId(inner.accessKeyId).withAccessKeySecret(inner.accessKeySecret).withSecurityToken(inner.securityToken).withProviderName(`${this.getProviderName()}/${this.lastUsedProvider.getProviderName()}`).build();
        }
        const errors = [];
        for (const provider of this.providers) {
          this.lastUsedProvider = provider;
          let inner;
          try {
            inner = await provider.getCredentials();
          } catch (ex) {
            errors.push(ex);
            continue;
          }
          if (inner) {
            return credentials_1.default.builder().withAccessKeyId(inner.accessKeyId).withAccessKeySecret(inner.accessKeySecret).withSecurityToken(inner.securityToken).withProviderName(`${this.getProviderName()}/${this.lastUsedProvider.getProviderName()}`).build();
          }
        }
        throw new Error(`unable to get credentials from any of the providers in the chain: ${errors.map((e) => {
          return e.message;
        }).join(", ")}`);
      }
      getProviderName() {
        return "default";
      }
    };
    exports2.default = DefaultCredentialsProvider;
    var DefaultCredentialsProviderBuilder = class {
      build() {
        return new DefaultCredentialsProvider(this);
      }
    };
  }
});

// node_modules/@alicloud/credentials/dist/src/client.js
var require_client = __commonJS({
  "node_modules/@alicloud/credentials/dist/src/client.js"(exports2) {
    "use strict";
    var __importDefault = exports2 && exports2.__importDefault || function(mod) {
      return mod && mod.__esModule ? mod : { "default": mod };
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.CLIProfileCredentialsProvider = exports2.ProfileCredentialsProvider = exports2.EnvironmentVariableCredentialsProvider = exports2.URICredentialsProvider = exports2.ECSRAMRoleCredentialsProvider = exports2.OIDCRoleArnCredentialsProvider = exports2.RAMRoleARNCredentialsProvider = exports2.StaticSTSCredentialsProvider = exports2.StaticAKCredentialsProvider = exports2.DefaultCredentialsProvider = exports2.Config = exports2.CredentialModel = void 0;
    var rsa_key_pair_credential_1 = __importDefault(require_rsa_key_pair_credential());
    var bearer_token_credential_1 = __importDefault(require_bearer_token_credential());
    var config_1 = __importDefault(require_config());
    exports2.Config = config_1.default;
    var credential_model_1 = __importDefault(require_credential_model());
    exports2.CredentialModel = credential_model_1.default;
    var static_ak_1 = __importDefault(require_static_ak());
    exports2.StaticAKCredentialsProvider = static_ak_1.default;
    var static_sts_1 = __importDefault(require_static_sts());
    exports2.StaticSTSCredentialsProvider = static_sts_1.default;
    var ram_role_arn_1 = __importDefault(require_ram_role_arn());
    exports2.RAMRoleARNCredentialsProvider = ram_role_arn_1.default;
    var oidc_role_arn_1 = __importDefault(require_oidc_role_arn());
    exports2.OIDCRoleArnCredentialsProvider = oidc_role_arn_1.default;
    var ecs_ram_role_1 = __importDefault(require_ecs_ram_role());
    exports2.ECSRAMRoleCredentialsProvider = ecs_ram_role_1.default;
    var default_1 = __importDefault(require_default());
    exports2.DefaultCredentialsProvider = default_1.default;
    var uri_1 = __importDefault(require_uri());
    exports2.URICredentialsProvider = uri_1.default;
    var cli_profile_1 = __importDefault(require_cli_profile());
    exports2.CLIProfileCredentialsProvider = cli_profile_1.default;
    var profile_1 = __importDefault(require_profile());
    exports2.ProfileCredentialsProvider = profile_1.default;
    var env_1 = __importDefault(require_env());
    exports2.EnvironmentVariableCredentialsProvider = env_1.default;
    var InnerCredentialsClient = class {
      constructor(type, provider) {
        this.type = type;
        this.provider = provider;
      }
      /**
       * @deprecated use getCredential() instead of
       * @returns the access key id of credentials
       */
      async getAccessKeyId() {
        const credentials = await this.provider.getCredentials();
        return credentials.accessKeyId;
      }
      /**
       * @deprecated use getCredential() instead of
       * @returns the access key secret of credentials
       */
      async getAccessKeySecret() {
        const credentials = await this.provider.getCredentials();
        return credentials.accessKeySecret;
      }
      /**
       * @deprecated use getCredential() instead of
       * @returns the security token of credentials
       */
      async getSecurityToken() {
        const credentials = await this.provider.getCredentials();
        return credentials.securityToken;
      }
      getBearerToken() {
        return;
      }
      getType() {
        return this.type;
      }
      async getCredential() {
        const credentials = await this.provider.getCredentials();
        return new credential_model_1.default({
          accessKeyId: credentials.accessKeyId,
          accessKeySecret: credentials.accessKeySecret,
          securityToken: credentials.securityToken,
          bearerToken: void 0,
          type: this.getType(),
          providerName: credentials.providerName
        });
      }
    };
    function isCredentialsProviderClass(t) {
      if (!t) {
        return false;
      }
      return typeof t.getCredentials === "function" && typeof t.getProviderName === "function";
    }
    var Credential2 = class {
      constructor(config2 = null, provider = null) {
        if (isCredentialsProviderClass(provider)) {
          this.load(null, provider);
        } else {
          this.load(config2, null);
        }
      }
      /**
       * @deprecated Use getCredential() instead of
       */
      getAccessKeyId() {
        return this.credential.getAccessKeyId();
      }
      /**
       * @deprecated Use getCredential() instead of
       */
      getAccessKeySecret() {
        return this.credential.getAccessKeySecret();
      }
      /**
       * @deprecated Use getCredential() instead of
       */
      getSecurityToken() {
        return this.credential.getSecurityToken();
      }
      /**
       * @deprecated Use getCredential() instead of
       */
      getBearerToken() {
        return this.credential.getBearerToken();
      }
      /**
       * @deprecated Use getCredential() instead of
       */
      getType() {
        return this.credential.getType();
      }
      getCredential() {
        return this.credential.getCredential();
      }
      load(config2, provider) {
        if (provider) {
          this.credential = new InnerCredentialsClient(provider.getProviderName(), provider);
          return;
        }
        if (!config2) {
          this.credential = new InnerCredentialsClient("default", default_1.default.builder().build());
          return;
        }
        if (!config2.type) {
          throw new Error("Missing required type option");
        }
        switch (config2.type) {
          case "access_key":
            this.credential = new InnerCredentialsClient("access_key", static_ak_1.default.builder().withAccessKeyId(config2.accessKeyId).withAccessKeySecret(config2.accessKeySecret).build());
            break;
          case "sts":
            this.credential = new InnerCredentialsClient("sts", static_sts_1.default.builder().withAccessKeyId(config2.accessKeyId).withAccessKeySecret(config2.accessKeySecret).withSecurityToken(config2.securityToken).build());
            break;
          case "ecs_ram_role":
            this.credential = new InnerCredentialsClient("ecs_ram_role", ecs_ram_role_1.default.builder().withRoleName(config2.roleName).withDisableIMDSv1(config2.disableIMDSv1).withAsyncCredentialUpdateEnabled(config2.asyncCredentialUpdateEnabled).withReadTimeout(config2.timeout).withConnectTimeout(config2.connectTimeout).build());
            break;
          case "ram_role_arn":
            {
              let credentialsProvider;
              if (config2.securityToken) {
                credentialsProvider = static_sts_1.default.builder().withAccessKeyId(config2.accessKeyId).withAccessKeySecret(config2.accessKeySecret).withSecurityToken(config2.securityToken).build();
              } else {
                credentialsProvider = static_ak_1.default.builder().withAccessKeyId(config2.accessKeyId).withAccessKeySecret(config2.accessKeySecret).build();
              }
              this.credential = new InnerCredentialsClient("ram_role_arn", ram_role_arn_1.default.builder().withCredentialsProvider(credentialsProvider).withRoleArn(config2.roleArn).withPolicy(config2.policy).withDurationSeconds(config2.roleSessionExpiration).withRoleSessionName(config2.roleSessionName).withReadTimeout(config2.timeout).withConnectTimeout(config2.connectTimeout).withEnableVpc(config2.enableVpc).withStsEndpoint(config2.stsEndpoint).withStsRegionId(config2.stsRegionId).withExternalId(config2.externalId).build());
            }
            break;
          case "oidc_role_arn":
            this.credential = new InnerCredentialsClient("oidc_role_arn", oidc_role_arn_1.default.builder().withRoleArn(config2.roleArn).withOIDCProviderArn(config2.oidcProviderArn).withOIDCTokenFilePath(config2.oidcTokenFilePath).withRoleSessionName(config2.roleSessionName).withPolicy(config2.policy).withDurationSeconds(config2.roleSessionExpiration).withStsEndpoint(config2.stsEndpoint).withStsRegionId(config2.stsRegionId).withEnableVpc(config2.enableVpc).withReadTimeout(config2.timeout).withConnectTimeout(config2.connectTimeout).build());
            break;
          case "rsa_key_pair":
            this.credential = new rsa_key_pair_credential_1.default(config2.publicKeyId, config2.privateKeyFile);
            break;
          case "bearer":
            this.credential = new bearer_token_credential_1.default(config2.bearerToken);
            break;
          case "credentials_uri":
            this.credential = new InnerCredentialsClient("credentials_uri", uri_1.default.builder().withCredentialsURI(config2.credentialsURI).withReadTimeout(config2.timeout).withConnectTimeout(config2.connectTimeout).build());
            break;
          default:
            throw new Error("Invalid type option, support: access_key, sts, ecs_ram_role, ram_role_arn, rsa_key_pair, credentials_uri");
        }
      }
    };
    exports2.default = Credential2;
  }
});

// node_modules/@alicloud/openapi-core/dist/utils.js
var require_utils2 = __commonJS({
  "node_modules/@alicloud/openapi-core/dist/utils.js"(exports2) {
    "use strict";
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      Object.defineProperty(o, k2, { enumerable: true, get: function() {
        return m[k];
      } });
    }) : (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      o[k2] = m[k];
    }));
    var __setModuleDefault = exports2 && exports2.__setModuleDefault || (Object.create ? (function(o, v) {
      Object.defineProperty(o, "default", { enumerable: true, value: v });
    }) : function(o, v) {
      o["default"] = v;
    });
    var __importStar = exports2 && exports2.__importStar || function(mod) {
      if (mod && mod.__esModule) return mod;
      var result = {};
      if (mod != null) {
        for (var k in mod) if (k !== "default" && Object.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
      }
      __setModuleDefault(result, mod);
      return result;
    };
    var __importDefault = exports2 && exports2.__importDefault || function(mod) {
      return mod && mod.__esModule ? mod : { "default": mod };
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.Params = exports2.OpenApiRequest = exports2.Config = exports2.GlobalParameters = void 0;
    var $tea = __importStar(require_tea());
    var $dara2 = __importStar(require_dist());
    var credentials_1 = __importDefault(require_client());
    var querystring_1 = __importDefault(require("querystring"));
    var crypto_1 = __importDefault(require("crypto"));
    var os_1 = __importDefault(require("os"));
    var PEM_BEGIN = "-----BEGIN PRIVATE KEY-----\n";
    var PEM_END = "\n-----END PRIVATE KEY-----";
    var DEFAULT_USER_AGENT = `AlibabaCloud (${os_1.default.platform()}; ${os_1.default.arch()}) Node.js/${process.version} Core/1.0.1 TeaDSL/2`;
    var GlobalParameters = class extends $tea.Model {
      constructor(map) {
        super(map);
      }
      static names() {
        return {
          headers: "headers",
          queries: "queries"
        };
      }
      static types() {
        return {
          headers: { "type": "map", "keyType": "string", "valueType": "string" },
          queries: { "type": "map", "keyType": "string", "valueType": "string" }
        };
      }
    };
    exports2.GlobalParameters = GlobalParameters;
    var Config2 = class extends $tea.Model {
      constructor(map) {
        super(map);
      }
      static names() {
        return {
          accessKeyId: "accessKeyId",
          accessKeySecret: "accessKeySecret",
          securityToken: "securityToken",
          bearerToken: "bearerToken",
          protocol: "protocol",
          method: "method",
          regionId: "regionId",
          readTimeout: "readTimeout",
          connectTimeout: "connectTimeout",
          httpProxy: "httpProxy",
          httpsProxy: "httpsProxy",
          credential: "credential",
          endpoint: "endpoint",
          noProxy: "noProxy",
          maxIdleConns: "maxIdleConns",
          network: "network",
          userAgent: "userAgent",
          suffix: "suffix",
          socks5Proxy: "socks5Proxy",
          socks5NetWork: "socks5NetWork",
          endpointType: "endpointType",
          openPlatformEndpoint: "openPlatformEndpoint",
          type: "type",
          signatureVersion: "signatureVersion",
          signatureAlgorithm: "signatureAlgorithm",
          globalParameters: "globalParameters",
          key: "key",
          cert: "cert",
          ca: "ca",
          disableHttp2: "disableHttp2",
          tlsMinVersion: "tlsMinVersion",
          retryOptions: "retryOptions"
        };
      }
      static types() {
        return {
          accessKeyId: "string",
          accessKeySecret: "string",
          securityToken: "string",
          bearerToken: "string",
          protocol: "string",
          method: "string",
          regionId: "string",
          readTimeout: "number",
          connectTimeout: "number",
          httpProxy: "string",
          httpsProxy: "string",
          credential: credentials_1.default,
          endpoint: "string",
          noProxy: "string",
          maxIdleConns: "number",
          network: "string",
          userAgent: "string",
          suffix: "string",
          socks5Proxy: "string",
          socks5NetWork: "string",
          endpointType: "string",
          openPlatformEndpoint: "string",
          type: "string",
          signatureVersion: "string",
          signatureAlgorithm: "string",
          globalParameters: GlobalParameters,
          key: "string",
          cert: "string",
          ca: "string",
          disableHttp2: "boolean",
          tlsMinVersion: "string",
          retryOptions: $dara2.RetryOptions
        };
      }
    };
    exports2.Config = Config2;
    var OpenApiRequest = class extends $tea.Model {
      constructor(map) {
        super(map);
      }
      static names() {
        return {
          headers: "headers",
          query: "query",
          body: "body",
          stream: "stream",
          hostMap: "hostMap",
          endpointOverride: "endpointOverride"
        };
      }
      static types() {
        return {
          headers: { "type": "map", "keyType": "string", "valueType": "string" },
          query: { "type": "map", "keyType": "string", "valueType": "string" },
          body: "any",
          stream: "Readable",
          hostMap: { "type": "map", "keyType": "string", "valueType": "string" },
          endpointOverride: "string"
        };
      }
    };
    exports2.OpenApiRequest = OpenApiRequest;
    var Params = class extends $tea.Model {
      constructor(map) {
        super(map);
      }
      static names() {
        return {
          action: "action",
          version: "version",
          protocol: "protocol",
          pathname: "pathname",
          method: "method",
          authType: "authType",
          bodyType: "bodyType",
          reqBodyType: "reqBodyType",
          style: "style"
        };
      }
      static types() {
        return {
          action: "string",
          version: "string",
          protocol: "string",
          pathname: "string",
          method: "string",
          authType: "string",
          bodyType: "string",
          reqBodyType: "string",
          style: "string"
        };
      }
    };
    exports2.Params = Params;
    function replaceRepeatList(target, repeat, prefix) {
      if (prefix) {
        prefix = prefix + ".";
      }
      for (var i = 0; i < repeat.length; i++) {
        var item = repeat[i];
        let key = prefix + (i + 1);
        if (typeof item === "undefined" || item == null) {
          continue;
        }
        if (Array.isArray(item)) {
          replaceRepeatList(target, item, key);
        } else if (item instanceof Object) {
          flatMap(target, item, key);
        } else {
          target[key] = item.toString();
        }
      }
    }
    function flatMap(target, params, prefix = "") {
      if (prefix) {
        prefix = prefix + ".";
      }
      params = toMap(params);
      let keys = Object.keys(params);
      for (let i = 0; i < keys.length; i++) {
        let key = keys[i];
        let value = params[key];
        key = prefix + key;
        if (typeof value === "undefined" || value == null) {
          continue;
        }
        if (Array.isArray(value)) {
          replaceRepeatList(target, value, key);
        } else if (value instanceof Object) {
          flatMap(target, value, key);
        } else {
          target[key] = value.toString();
        }
      }
      return target;
    }
    function filter(value) {
      return value.replace(/[\t\n\r\f]/g, " ");
    }
    function getCanonicalizedHeaders(headers) {
      const prefix = "x-acs-";
      const keys = Object.keys(headers);
      const canonicalizedKeys = [];
      for (let i = 0; i < keys.length; i++) {
        const key = keys[i];
        if (key.startsWith(prefix)) {
          canonicalizedKeys.push(key);
        }
      }
      canonicalizedKeys.sort();
      var result = "";
      for (let i = 0; i < canonicalizedKeys.length; i++) {
        const key = canonicalizedKeys[i];
        result += `${key}:${filter(headers[key]).trim()}
`;
      }
      return result;
    }
    function getCanonicalizedResource(uriPattern, query) {
      const keys = !query ? [] : Object.keys(query).sort();
      if (keys.length === 0) {
        return uriPattern;
      }
      var result = [];
      for (var i = 0; i < keys.length; i++) {
        const key = keys[i];
        result.push(`${key}=${query[key]}`);
      }
      return `${uriPattern}?${result.join("&")}`;
    }
    function getAuthorizationQueryString(query) {
      let canonicalQueryArray = [];
      const keys = !query ? [] : Object.keys(query).sort();
      for (let i = 0; i < keys.length; i++) {
        const key = keys[i];
        let param = key + "=";
        if (typeof query[key] !== "undefined" && query[key] !== null) {
          param = param + encode(query[key]);
        }
        canonicalQueryArray.push(param);
      }
      return canonicalQueryArray.join("&");
    }
    function getAuthorizationHeaders(header) {
      let canonicalheaders = "";
      let tmp = {};
      const keys = !header ? [] : Object.keys(header);
      for (let i = 0; i < keys.length; i++) {
        const key = keys[i];
        const lowerKey = keys[i].toLowerCase();
        if (lowerKey.startsWith("x-acs-") || lowerKey === "host" || lowerKey === "content-type") {
          if (tmp[lowerKey]) {
            tmp[lowerKey].push((header[key] || "").trim());
          } else {
            tmp[lowerKey] = [(header[key] || "").trim()];
          }
        }
      }
      var hsKeys = Object.keys(tmp).sort();
      for (let i = 0; i < hsKeys.length; i++) {
        const hsKey = hsKeys[i];
        let listSort = tmp[hsKey].sort();
        canonicalheaders += `${hsKey}:${listSort.join(",")}
`;
      }
      return { canonicalheaders, hsKeys };
    }
    function encode(str) {
      var result = encodeURIComponent(str);
      return result.replace(/!/g, "%21").replace(/'/g, "%27").replace(/\(/g, "%28").replace(/\)/g, "%29").replace(/\*/g, "%2A");
    }
    function normalize(params) {
      var list = [];
      var flated = {};
      flatMap(flated, params);
      var keys = Object.keys(flated).sort();
      for (let i = 0; i < keys.length; i++) {
        var key = keys[i];
        var value = flated[key];
        list.push([encode(key), encode(value)]);
      }
      return list;
    }
    function canonicalize(normalized) {
      var fields = [];
      for (var i = 0; i < normalized.length; i++) {
        var [key, value] = normalized[i];
        fields.push(key + "=" + value);
      }
      return fields.join("&");
    }
    function isModelClass(t) {
      if (!t) {
        return false;
      }
      return typeof t.types === "function" && typeof t.names === "function";
    }
    function isObjectOrArray(t) {
      return Array.isArray(t) || t instanceof Object && typeof t !== "function";
    }
    function getTimeLeft(rateLimit) {
      if (rateLimit) {
        const pairs = rateLimit.split(",");
        for (const pair of pairs) {
          const kv = pair.split(":");
          if (kv.length === 2) {
            const key = kv[0].trim();
            const value = kv[1].trim();
            if (key === "TimeLeft") {
              const timeLeftValue = parseInt(value, 10);
              if (isNaN(timeLeftValue)) {
                return null;
              }
              return timeLeftValue;
            }
          }
        }
      }
      return null;
    }
    function toMap(input) {
      if (!isObjectOrArray(input)) {
        return null;
      } else if (input instanceof $tea.Model) {
        return $tea.toMap(input);
      } else if (input && input.toMap && typeof input.toMap === "function") {
        return input.toMap();
      } else if (Array.isArray(input)) {
        const result = [];
        input.forEach((value) => {
          if (isObjectOrArray(value)) {
            result.push(toMap(value));
          } else {
            result.push(value);
          }
        });
        return result;
      } else if (input instanceof Object) {
        const result = {};
        Object.entries(input).forEach(([key, value]) => {
          if (isObjectOrArray(value)) {
            result[key] = toMap(value);
          } else {
            result[key] = value;
          }
        });
        return result;
      }
    }
    var Client = class _Client {
      /**
       * Convert all params of body other than type of readable into content
       * @param body source Model
       * @param content target Model
       * @return void
       */
      static convert(input, output) {
        if (!output) {
          return;
        }
        let inputModel = Object.assign({}, input);
        let constructor = output.constructor;
        let types = constructor.types();
        for (let key of Object.keys(constructor.names())) {
          if (inputModel[key] !== null && inputModel[key] !== void 0) {
            if (isModelClass(types[key])) {
              output[key] = new types[key](output[key]);
              _Client.convert(inputModel[key], output[key]);
            } else if (types[key] && types[key].type === "array") {
              output[key] = inputModel[key].map(function(d) {
                if (isModelClass(types[key].itemType)) {
                  var item = new types[key].itemType({});
                  _Client.convert(d, item);
                  return item;
                }
                return d;
              });
            } else if (types[key] && types[key].type === "map") {
              output[key] = {};
              Object.keys(inputModel[key]).map(function(d) {
                if (isModelClass(types[key].valueType)) {
                  var item = new types[key].valueType({});
                  _Client.convert(inputModel[key][d], item);
                  output[key][d] = item;
                } else {
                  output[key][d] = inputModel[key][d];
                }
              });
            } else {
              output[key] = inputModel[key];
            }
          }
        }
      }
      /**
       * If endpointType is internal, use internal endpoint
       * If serverUse is true and endpointType is accelerate, use accelerate endpoint
       * Default return endpoint
       * @param serverUse whether use accelerate endpoint
       * @param endpointType value must be internal or accelerate
       * @return the final endpoint
       */
      static getEndpoint(endpoint, serverUse, endpointType) {
        if (endpointType == "internal") {
          let strs = endpoint.split(".");
          strs[0] += "-internal";
          endpoint = strs.join(".");
        }
        if (serverUse && endpointType == "accelerate") {
          return "oss-accelerate.aliyuncs.com";
        }
        return endpoint;
      }
      /**
       * Get throttling param
       * @param the response headers
       * @return time left
       */
      static getThrottlingTimeLeft(headers) {
        const rateLimitForUserApi = headers["x-ratelimit-user-api"];
        const rateLimitForUser = headers["x-ratelimit-user"];
        const timeLeftForUserApi = getTimeLeft(rateLimitForUserApi);
        const timeLeftForUser = getTimeLeft(rateLimitForUser);
        if (timeLeftForUserApi > timeLeftForUser) {
          return timeLeftForUserApi;
        } else {
          return timeLeftForUser;
        }
      }
      /**
       * Hash the raw data with signatureAlgorithm
       * @param raw hashing data
       * @param signatureAlgorithm the autograph method
       * @return hashed bytes
       */
      static hash(raw, signatureAlgorithm) {
        if (signatureAlgorithm === "ACS3-HMAC-SHA256" || signatureAlgorithm === "ACS3-RSA-SHA256") {
          const obj = crypto_1.default.createHash("sha256");
          obj.update(raw);
          return obj.digest();
        } else if (signatureAlgorithm == "ACS3-HMAC-SM3") {
          const obj = crypto_1.default.createHash("sm3");
          obj.update(raw);
          return obj.digest();
        }
      }
      /**
       * Generate a nonce string
       * @return the nonce string
       */
      static getNonce() {
        let counter = 0;
        let last;
        const machine = os_1.default.hostname();
        const pid = process.pid;
        var val = Math.floor(Math.random() * 1e12);
        if (val === last) {
          counter++;
        } else {
          counter = 0;
        }
        last = val;
        var uid = `${machine}${pid}${val}${counter}`;
        var shasum = crypto_1.default.createHash("md5");
        shasum.update(uid);
        return shasum.digest("hex");
      }
      /**
       * Get the string to be signed according to request
       * @param request  which contains signed messages
       * @return the signed string
       */
      static getStringToSign(request) {
        const method = request.method;
        const accept = request.headers["accept"];
        const contentMD5 = request.headers["content-md5"] || "";
        const contentType = request.headers["content-type"] || "";
        const date = request.headers["date"] || "";
        const header = `${method}
${accept}
${contentMD5}
${contentType}
${date}
`;
        const canonicalizedHeaders = getCanonicalizedHeaders(request.headers);
        const canonicalizedResource = getCanonicalizedResource(request.pathname, request.query);
        return `${header}${canonicalizedHeaders}${canonicalizedResource}`;
      }
      /**
       * Get signature according to stringToSign, secret
       * @param stringToSign  the signed string
       * @param secret accesskey secret
       * @return the signature
       */
      static getROASignature(stringToSign, secret) {
        const utf8Buff = Buffer.from(stringToSign, "utf8");
        return crypto_1.default.createHmac("sha1", secret).update(utf8Buff).digest("base64");
      }
      /**
       * Parse filter into a form string
       * @param filter object
       * @return the string
       */
      static toForm(filter2) {
        if (!filter2) {
          return "";
        }
        let target = {};
        flatMap(target, filter2);
        return $dara2.Form.toFormString(target);
      }
      /**
       * Get timestamp
       * @return the timestamp string
       */
      static getTimestamp() {
        let date = /* @__PURE__ */ new Date();
        let YYYY = date.getUTCFullYear();
        let MM = `${date.getUTCMonth() + 1}`.padStart(2, "0");
        let DD = `${date.getUTCDate()}`.padStart(2, "0");
        let HH = `${date.getUTCHours()}`.padStart(2, "0");
        let mm = `${date.getUTCMinutes()}`.padStart(2, "0");
        let ss = `${date.getUTCSeconds()}`.padStart(2, "0");
        return `${YYYY}-${MM}-${DD}T${HH}:${mm}:${ss}Z`;
      }
      /**
       * Get UTC string
       * @return the UTC string
       */
      static getDateUTCString() {
        const now = /* @__PURE__ */ new Date();
        return now.toUTCString();
      }
      /**
       * Parse filter into a object which's type is map[string]string
       * @param filter query param
       * @return the object
       */
      static query(filter2) {
        if (!filter2) {
          return {};
        }
        let ret = {};
        flatMap(ret, filter2);
        return ret;
      }
      /**
       * Get signature according to signedParams, method and secret
       * @param signedParams params which need to be signed
       * @param method http method e.g. GET
       * @param secret AccessKeySecret
       * @return the signature
       */
      static getRPCSignature(signedParams, method, secret) {
        var normalized = normalize(signedParams);
        var canonicalized = canonicalize(normalized);
        var stringToSign = `${method}&${encode("/")}&${encode(canonicalized)}`;
        const key = secret + "&";
        return crypto_1.default.createHmac("sha1", key).update(stringToSign).digest("base64");
      }
      /**
       * Parse array into a string with specified style
       * @param array the array
       * @param prefix the prefix string
       * @style specified style e.g. repeatList
       * @return the string
       */
      static arrayToStringWithSpecifiedStyle(array, prefix, style) {
        if (!array) {
          return "";
        }
        if (style === "repeatList") {
          let target = {};
          replaceRepeatList(target, array, prefix);
          return querystring_1.default.stringify(target, "&&");
        } else if (style === "json") {
          return JSON.stringify(toMap(array));
        } else if (style === "simple") {
          return array.join(",");
        } else if (style === "spaceDelimited") {
          return array.join(" ");
        } else if (style === "pipeDelimited") {
          return array.join("|");
        } else {
          return "";
        }
      }
      static stringifyMapValue(m) {
        if (!m) {
          return m;
        }
        const result = {};
        for (const [key, value] of Object.entries(m)) {
          if (typeof value === "undefined" || value === null) {
            continue;
          }
          result[key] = String(value);
        }
        return result;
      }
      static toArray(input) {
        if (!(input instanceof Array)) {
          return null;
        }
        let ret = [];
        input.forEach((model) => {
          if (!model) {
            return;
          }
          ret.push($tea.toMap(model));
        });
        return ret;
      }
      static getEndpointRules(product, regionId, endpointType, network, suffix) {
        let result;
        if (network && network.length && network != "public") {
          network = "-" + network;
        } else {
          network = "";
        }
        suffix = suffix || "";
        if (suffix.length) {
          suffix = "-" + suffix;
        }
        if (endpointType == "regional") {
          if (!regionId || !regionId.length) {
            throw new Error("RegionId is empty, please set a valid RegionId");
          }
          result = `${product}${suffix}${network}.${regionId}.aliyuncs.com`;
        } else {
          result = `${product}${suffix}${network}.aliyuncs.com`;
        }
        return result;
      }
      /**
       * Transform input as map.
       */
      static parseToMap(input) {
        return toMap(input);
      }
      /**
       * Get the authorization
       * @param request request params
       * @param signatureAlgorithm the autograph method
       * @param payload the hashed request
       * @param accessKey the accessKey string
       * @param accessKeySecret the accessKeySecret string
       * @return authorization string
       */
      static getAuthorization(request, signatureAlgorithm, payload, accessKey, accessKeySecret) {
        const canonicalURI = (request.pathname || "").replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
        const method = request.method;
        const canonicalQueryString = getAuthorizationQueryString(request.query);
        const tuple = getAuthorizationHeaders(request.headers);
        const canonicalheaders = tuple["canonicalheaders"];
        const signedHeaders = tuple["hsKeys"];
        const canonicalRequest = method + "\n" + canonicalURI + "\n" + canonicalQueryString + "\n" + canonicalheaders + "\n" + signedHeaders.join(";") + "\n" + payload;
        let raw = Buffer.from(canonicalRequest);
        const stringToSign = signatureAlgorithm + "\n" + _Client.hash(raw, signatureAlgorithm).toString("hex");
        const signature = _Client.signatureMethod(accessKeySecret, stringToSign, signatureAlgorithm).toString("hex");
        const auth = `${signatureAlgorithm} Credential=${accessKey},SignedHeaders=${signedHeaders.join(";")},Signature=${signature}`;
        return auth;
      }
      static getUserAgent(userAgent) {
        if (!userAgent || !userAgent.length) {
          return DEFAULT_USER_AGENT;
        }
        return DEFAULT_USER_AGENT + " " + userAgent;
      }
      static signatureMethod(secret, source, signatureAlgorithm) {
        if (signatureAlgorithm === "ACS3-HMAC-SHA256") {
          const obj = crypto_1.default.createHmac("sha256", secret);
          obj.update(source);
          return obj.digest();
        } else if (signatureAlgorithm === "ACS3-HMAC-SM3") {
          const obj = crypto_1.default.createHmac("sm3", secret);
          obj.update(source);
          return obj.digest();
        } else if (signatureAlgorithm === "ACS3-RSA-SHA256") {
          if (!secret.startsWith(PEM_BEGIN)) {
            secret = PEM_BEGIN + secret;
          }
          if (!secret.endsWith(PEM_END)) {
            secret = secret + PEM_END;
          }
          var signerObject = crypto_1.default.createSign("RSA-SHA256");
          signerObject.update(source);
          var signature = signerObject.sign({ key: secret, padding: crypto_1.default.constants.RSA_PKCS1_PADDING });
          return signature;
        }
      }
      /**
       * Transform a map to a flat style map where keys are prefixed with length info.
       * Map keys are transformed from "key" to "#length#key" format.
       * @param input the input object (can be an object, array, or primitive type)
       * @return the transformed object
       */
      static mapToFlatStyle(input) {
        if (input === null || input === void 0) {
          return input;
        }
        if (Array.isArray(input)) {
          const result = [];
          for (const item of input) {
            result.push(_Client.mapToFlatStyle(item));
          }
          return result;
        }
        if (input instanceof $tea.Model) {
          for (const [key, value] of Object.entries(input)) {
            if (value !== null && value !== void 0 && typeof value === "object" && !Array.isArray(value) && !(value instanceof $tea.Model)) {
              const flatMap2 = {};
              for (const [nestedKey, nestedValue] of Object.entries(value)) {
                const flatKey = `#${nestedKey.length}#${nestedKey}`;
                flatMap2[flatKey] = _Client.mapToFlatStyle(nestedValue);
              }
              input[key] = flatMap2;
            } else {
              input[key] = _Client.mapToFlatStyle(value);
            }
          }
          return input;
        }
        if (typeof input === "object" && !Array.isArray(input)) {
          const flatMap2 = {};
          for (const [key, value] of Object.entries(input)) {
            const flatKey = `#${key.length}#${key}`;
            flatMap2[flatKey] = _Client.mapToFlatStyle(value);
          }
          return flatMap2;
        }
        return input;
      }
    };
    exports2.default = Client;
  }
});

// node_modules/@alicloud/gateway-spi/dist/client.js
var require_client2 = __commonJS({
  "node_modules/@alicloud/gateway-spi/dist/client.js"(exports2) {
    "use strict";
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      Object.defineProperty(o, k2, { enumerable: true, get: function() {
        return m[k];
      } });
    }) : (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      o[k2] = m[k];
    }));
    var __setModuleDefault = exports2 && exports2.__setModuleDefault || (Object.create ? (function(o, v) {
      Object.defineProperty(o, "default", { enumerable: true, value: v });
    }) : function(o, v) {
      o["default"] = v;
    });
    var __importStar = exports2 && exports2.__importStar || function(mod) {
      if (mod && mod.__esModule) return mod;
      var result = {};
      if (mod != null) {
        for (var k in mod) if (k !== "default" && Object.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
      }
      __setModuleDefault(result, mod);
      return result;
    };
    var __importDefault = exports2 && exports2.__importDefault || function(mod) {
      return mod && mod.__esModule ? mod : { "default": mod };
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.InterceptorContextResponse = exports2.InterceptorContextConfiguration = exports2.InterceptorContextRequest = exports2.AttributeMap = exports2.InterceptorContext = void 0;
    var credentials_1 = __importDefault(require_client());
    var $tea = __importStar(require_tea());
    var InterceptorContext = class extends $tea.Model {
      constructor(map) {
        super(map);
      }
      static names() {
        return {
          request: "request",
          configuration: "configuration",
          response: "response"
        };
      }
      static types() {
        return {
          request: InterceptorContextRequest,
          configuration: InterceptorContextConfiguration,
          response: InterceptorContextResponse
        };
      }
    };
    exports2.InterceptorContext = InterceptorContext;
    var AttributeMap = class extends $tea.Model {
      constructor(map) {
        super(map);
      }
      static names() {
        return {
          attributes: "attributes",
          key: "key"
        };
      }
      static types() {
        return {
          attributes: { "type": "map", "keyType": "string", "valueType": "any" },
          key: { "type": "map", "keyType": "string", "valueType": "string" }
        };
      }
    };
    exports2.AttributeMap = AttributeMap;
    var InterceptorContextRequest = class extends $tea.Model {
      constructor(map) {
        super(map);
      }
      static names() {
        return {
          headers: "headers",
          query: "query",
          body: "body",
          stream: "stream",
          hostMap: "hostMap",
          pathname: "pathname",
          productId: "productId",
          action: "action",
          version: "version",
          protocol: "protocol",
          method: "method",
          authType: "authType",
          bodyType: "bodyType",
          reqBodyType: "reqBodyType",
          style: "style",
          credential: "credential",
          signatureVersion: "signatureVersion",
          signatureAlgorithm: "signatureAlgorithm",
          userAgent: "userAgent"
        };
      }
      static types() {
        return {
          headers: { "type": "map", "keyType": "string", "valueType": "string" },
          query: { "type": "map", "keyType": "string", "valueType": "string" },
          body: "any",
          stream: "Readable",
          hostMap: { "type": "map", "keyType": "string", "valueType": "string" },
          pathname: "string",
          productId: "string",
          action: "string",
          version: "string",
          protocol: "string",
          method: "string",
          authType: "string",
          bodyType: "string",
          reqBodyType: "string",
          style: "string",
          credential: credentials_1.default,
          signatureVersion: "string",
          signatureAlgorithm: "string",
          userAgent: "string"
        };
      }
    };
    exports2.InterceptorContextRequest = InterceptorContextRequest;
    var InterceptorContextConfiguration = class extends $tea.Model {
      constructor(map) {
        super(map);
      }
      static names() {
        return {
          regionId: "regionId",
          endpoint: "endpoint",
          endpointRule: "endpointRule",
          endpointMap: "endpointMap",
          endpointType: "endpointType",
          network: "network",
          suffix: "suffix"
        };
      }
      static types() {
        return {
          regionId: "string",
          endpoint: "string",
          endpointRule: "string",
          endpointMap: { "type": "map", "keyType": "string", "valueType": "string" },
          endpointType: "string",
          network: "string",
          suffix: "string"
        };
      }
    };
    exports2.InterceptorContextConfiguration = InterceptorContextConfiguration;
    var InterceptorContextResponse = class extends $tea.Model {
      constructor(map) {
        super(map);
      }
      static names() {
        return {
          statusCode: "statusCode",
          headers: "headers",
          body: "body",
          deserializedBody: "deserializedBody"
        };
      }
      static types() {
        return {
          statusCode: "number",
          headers: { "type": "map", "keyType": "string", "valueType": "string" },
          body: "Readable",
          deserializedBody: "any"
        };
      }
    };
    exports2.InterceptorContextResponse = InterceptorContextResponse;
    var Client = class {
      constructor() {
      }
    };
    exports2.default = Client;
  }
});

// node_modules/@alicloud/openapi-core/dist/exceptions/AlibabaCloudError.js
var require_AlibabaCloudError = __commonJS({
  "node_modules/@alicloud/openapi-core/dist/exceptions/AlibabaCloudError.js"(exports2) {
    "use strict";
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      Object.defineProperty(o, k2, { enumerable: true, get: function() {
        return m[k];
      } });
    }) : (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      o[k2] = m[k];
    }));
    var __setModuleDefault = exports2 && exports2.__setModuleDefault || (Object.create ? (function(o, v) {
      Object.defineProperty(o, "default", { enumerable: true, value: v });
    }) : function(o, v) {
      o["default"] = v;
    });
    var __importStar = exports2 && exports2.__importStar || function(mod) {
      if (mod && mod.__esModule) return mod;
      var result = {};
      if (mod != null) {
        for (var k in mod) if (k !== "default" && Object.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
      }
      __setModuleDefault(result, mod);
      return result;
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.AlibabaCloudError = void 0;
    var $dara2 = __importStar(require_dist());
    var AlibabaCloudError = class _AlibabaCloudError extends $dara2.ResponseError {
      constructor(map) {
        super(map);
        this.name = "AlibabaCloudError";
        Object.setPrototypeOf(this, _AlibabaCloudError.prototype);
        this.statusCode = map.statusCode;
        this.code = map.code;
        this.description = map.description;
        this.requestId = map.requestId;
      }
    };
    exports2.AlibabaCloudError = AlibabaCloudError;
  }
});

// node_modules/@alicloud/openapi-core/dist/exceptions/ClientError.js
var require_ClientError = __commonJS({
  "node_modules/@alicloud/openapi-core/dist/exceptions/ClientError.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.ClientError = void 0;
    var AlibabaCloudError_1 = require_AlibabaCloudError();
    var ClientError = class _ClientError extends AlibabaCloudError_1.AlibabaCloudError {
      constructor(map) {
        super(map);
        this.name = "ClientError";
        Object.setPrototypeOf(this, _ClientError.prototype);
        this.accessDeniedDetail = map.accessDeniedDetail;
      }
    };
    exports2.ClientError = ClientError;
  }
});

// node_modules/@alicloud/openapi-core/dist/exceptions/ServerError.js
var require_ServerError = __commonJS({
  "node_modules/@alicloud/openapi-core/dist/exceptions/ServerError.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.ServerError = void 0;
    var AlibabaCloudError_1 = require_AlibabaCloudError();
    var ServerError = class _ServerError extends AlibabaCloudError_1.AlibabaCloudError {
      constructor(map) {
        super(map);
        this.name = "ServerError";
        Object.setPrototypeOf(this, _ServerError.prototype);
      }
    };
    exports2.ServerError = ServerError;
  }
});

// node_modules/@alicloud/openapi-core/dist/exceptions/ThrottlingError.js
var require_ThrottlingError = __commonJS({
  "node_modules/@alicloud/openapi-core/dist/exceptions/ThrottlingError.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.ThrottlingError = void 0;
    var AlibabaCloudError_1 = require_AlibabaCloudError();
    var ThrottlingError = class _ThrottlingError extends AlibabaCloudError_1.AlibabaCloudError {
      constructor(map) {
        super(map);
        this.name = "ThrottlingError";
        Object.setPrototypeOf(this, _ThrottlingError.prototype);
        this.retryAfter = map.retryAfter;
      }
    };
    exports2.ThrottlingError = ThrottlingError;
  }
});

// node_modules/@alicloud/openapi-core/dist/exceptions/error.js
var require_error2 = __commonJS({
  "node_modules/@alicloud/openapi-core/dist/exceptions/error.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var AlibabaCloudError_1 = require_AlibabaCloudError();
    Object.defineProperty(exports2, "AlibabaCloudError", { enumerable: true, get: function() {
      return AlibabaCloudError_1.AlibabaCloudError;
    } });
    var ClientError_1 = require_ClientError();
    Object.defineProperty(exports2, "ClientError", { enumerable: true, get: function() {
      return ClientError_1.ClientError;
    } });
    var ServerError_1 = require_ServerError();
    Object.defineProperty(exports2, "ServerError", { enumerable: true, get: function() {
      return ServerError_1.ServerError;
    } });
    var ThrottlingError_1 = require_ThrottlingError();
    Object.defineProperty(exports2, "ThrottlingError", { enumerable: true, get: function() {
      return ThrottlingError_1.ThrottlingError;
    } });
  }
});

// node_modules/@alicloud/openapi-core/dist/models/Sseresponse.js
var require_Sseresponse = __commonJS({
  "node_modules/@alicloud/openapi-core/dist/models/Sseresponse.js"(exports2) {
    "use strict";
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      Object.defineProperty(o, k2, { enumerable: true, get: function() {
        return m[k];
      } });
    }) : (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      o[k2] = m[k];
    }));
    var __setModuleDefault = exports2 && exports2.__setModuleDefault || (Object.create ? (function(o, v) {
      Object.defineProperty(o, "default", { enumerable: true, value: v });
    }) : function(o, v) {
      o["default"] = v;
    });
    var __importStar = exports2 && exports2.__importStar || function(mod) {
      if (mod && mod.__esModule) return mod;
      var result = {};
      if (mod != null) {
        for (var k in mod) if (k !== "default" && Object.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
      }
      __setModuleDefault(result, mod);
      return result;
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.SSEResponse = void 0;
    var $dara2 = __importStar(require_dist());
    var SSEResponse = class extends $dara2.Model {
      constructor(map) {
        super(map);
      }
      static names() {
        return {
          headers: "headers",
          statusCode: "statusCode",
          event: "event"
        };
      }
      static types() {
        return {
          headers: { "type": "map", "keyType": "string", "valueType": "string" },
          statusCode: "number",
          event: $dara2.SSEEvent
        };
      }
      validate() {
        if (this.headers) {
          $dara2.Model.validateMap(this.headers);
        }
        $dara2.Model.validateRequired("headers", this.headers);
        $dara2.Model.validateRequired("statusCode", this.statusCode);
        $dara2.Model.validateRequired("event", this.event);
        super.validate();
      }
    };
    exports2.SSEResponse = SSEResponse;
  }
});

// node_modules/@alicloud/openapi-core/dist/models/model.js
var require_model = __commonJS({
  "node_modules/@alicloud/openapi-core/dist/models/model.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var Sseresponse_1 = require_Sseresponse();
    Object.defineProperty(exports2, "SSEResponse", { enumerable: true, get: function() {
      return Sseresponse_1.SSEResponse;
    } });
  }
});

// node_modules/@alicloud/openapi-core/dist/client.js
var require_client3 = __commonJS({
  "node_modules/@alicloud/openapi-core/dist/client.js"(exports2) {
    "use strict";
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      Object.defineProperty(o, k2, { enumerable: true, get: function() {
        return m[k];
      } });
    }) : (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      o[k2] = m[k];
    }));
    var __setModuleDefault = exports2 && exports2.__setModuleDefault || (Object.create ? (function(o, v) {
      Object.defineProperty(o, "default", { enumerable: true, value: v });
    }) : function(o, v) {
      o["default"] = v;
    });
    var __importStar = exports2 && exports2.__importStar || function(mod) {
      if (mod && mod.__esModule) return mod;
      var result = {};
      if (mod != null) {
        for (var k in mod) if (k !== "default" && Object.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
      }
      __setModuleDefault(result, mod);
      return result;
    };
    var __exportStar = exports2 && exports2.__exportStar || function(m, exports3) {
      for (var p in m) if (p !== "default" && !exports3.hasOwnProperty(p)) __createBinding(exports3, m, p);
    };
    var __await = exports2 && exports2.__await || function(v) {
      return this instanceof __await ? (this.v = v, this) : new __await(v);
    };
    var __asyncValues = exports2 && exports2.__asyncValues || function(o) {
      if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
      var m = o[Symbol.asyncIterator], i;
      return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function() {
        return this;
      }, i);
      function verb(n) {
        i[n] = o[n] && function(v) {
          return new Promise(function(resolve2, reject) {
            v = o[n](v), settle(resolve2, reject, v.done, v.value);
          });
        };
      }
      function settle(resolve2, reject, d, v) {
        Promise.resolve(v).then(function(v2) {
          resolve2({ value: v2, done: d });
        }, reject);
      }
    };
    var __asyncGenerator = exports2 && exports2.__asyncGenerator || function(thisArg, _arguments, generator) {
      if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
      var g = generator.apply(thisArg, _arguments || []), i, q = [];
      return i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function() {
        return this;
      }, i;
      function verb(n) {
        if (g[n]) i[n] = function(v) {
          return new Promise(function(a, b) {
            q.push([n, v, a, b]) > 1 || resume(n, v);
          });
        };
      }
      function resume(n, v) {
        try {
          step(g[n](v));
        } catch (e) {
          settle(q[0][3], e);
        }
      }
      function step(r) {
        r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r);
      }
      function fulfill(value) {
        resume("next", value);
      }
      function reject(value) {
        resume("throw", value);
      }
      function settle(f, v) {
        if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]);
      }
    };
    var __importDefault = exports2 && exports2.__importDefault || function(mod) {
      return mod && mod.__esModule ? mod : { "default": mod };
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    var $dara2 = __importStar(require_dist());
    var utils_1 = __importDefault(require_utils2());
    var credentials_1 = __importStar(require_client());
    var $Credential = credentials_1;
    var $SPI = __importStar(require_client2());
    exports2.$OpenApiUtil = __importStar(require_utils2());
    var utils_2 = require_utils2();
    Object.defineProperty(exports2, "OpenApiUtil", { enumerable: true, get: function() {
      return utils_2.default;
    } });
    var $_error = __importStar(require_error2());
    __exportStar(require_error2(), exports2);
    var $_model = __importStar(require_model());
    __exportStar(require_model(), exports2);
    var Client = class {
      /**
       * @remarks
       * Init client with Config
       *
       * @param config - config contains the necessary information to create a client
       */
      constructor(config2) {
        if ($dara2.isNull(config2)) {
          throw new $_error.ClientError({
            code: "ParameterMissing",
            message: "'config' can not be unset"
          });
        }
        if (!$dara2.isNull(config2.accessKeyId) && config2.accessKeyId != "" && (!$dara2.isNull(config2.accessKeySecret) && config2.accessKeySecret != "")) {
          if (!$dara2.isNull(config2.securityToken) && config2.securityToken != "") {
            config2.type = "sts";
          } else {
            config2.type = "access_key";
          }
          let credentialConfig = new $Credential.Config({
            accessKeyId: config2.accessKeyId,
            type: config2.type,
            accessKeySecret: config2.accessKeySecret
          });
          credentialConfig.securityToken = config2.securityToken;
          this._credential = new credentials_1.default(credentialConfig);
        } else if (!$dara2.isNull(config2.bearerToken) && config2.bearerToken != "") {
          let cc = new $Credential.Config({
            type: "bearer",
            bearerToken: config2.bearerToken
          });
          this._credential = new credentials_1.default(cc);
        } else if (!$dara2.isNull(config2.credential)) {
          this._credential = config2.credential;
        }
        this._endpoint = config2.endpoint;
        this._endpointType = config2.endpointType;
        this._network = config2.network;
        this._suffix = config2.suffix;
        this._protocol = config2.protocol;
        this._method = config2.method;
        this._regionId = config2.regionId;
        this._userAgent = config2.userAgent;
        this._readTimeout = config2.readTimeout;
        this._connectTimeout = config2.connectTimeout;
        this._httpProxy = config2.httpProxy;
        this._httpsProxy = config2.httpsProxy;
        this._noProxy = config2.noProxy;
        this._socks5Proxy = config2.socks5Proxy;
        this._socks5NetWork = config2.socks5NetWork;
        this._maxIdleConns = config2.maxIdleConns;
        this._signatureVersion = config2.signatureVersion;
        this._signatureAlgorithm = config2.signatureAlgorithm;
        this._globalParameters = config2.globalParameters;
        this._key = config2.key;
        this._cert = config2.cert;
        this._ca = config2.ca;
        this._disableHttp2 = config2.disableHttp2;
        this._retryOptions = config2.retryOptions;
        this._tlsMinVersion = config2.tlsMinVersion;
      }
      /**
       * @remarks
       * Encapsulate the request and invoke the network
       *
       * @param action - api name
       * @param version - product version
       * @param protocol - http or https
       * @param method - e.g. GET
       * @param authType - authorization type e.g. AK
       * @param bodyType - response body type e.g. String
       * @param request - object of OpenApiRequest
       * @param runtime - which controls some details of call api, such as retry times
       * @returns the response
       */
      async doRPCRequest(action, version, protocol, method, authType, bodyType, request, runtime) {
        let _runtime = {
          key: runtime.key || this._key,
          cert: runtime.cert || this._cert,
          ca: runtime.ca || this._ca,
          readTimeout: runtime.readTimeout || this._readTimeout,
          connectTimeout: runtime.connectTimeout || this._connectTimeout,
          httpProxy: runtime.httpProxy || this._httpProxy,
          httpsProxy: runtime.httpsProxy || this._httpsProxy,
          noProxy: runtime.noProxy || this._noProxy,
          socks5Proxy: runtime.socks5Proxy || this._socks5Proxy,
          socks5NetWork: runtime.socks5NetWork || this._socks5NetWork,
          maxIdleConns: runtime.maxIdleConns || this._maxIdleConns,
          retryOptions: this._retryOptions,
          ignoreSSL: runtime.ignoreSSL,
          tlsMinVersion: this._tlsMinVersion
        };
        let _retriesAttempted = 0;
        let _lastRequest = null, _lastResponse = null;
        let _context = new $dara2.RetryPolicyContext({
          retriesAttempted: _retriesAttempted
        });
        while ($dara2.shouldRetry(_runtime["retryOptions"], _context)) {
          if (_retriesAttempted > 0) {
            let _backoffTime = $dara2.getBackoffDelay(_runtime["retryOptions"], _context);
            if (_backoffTime > 0) {
              await $dara2.sleep(_backoffTime);
            }
          }
          _retriesAttempted = _retriesAttempted + 1;
          try {
            let request_ = new $dara2.Request();
            request_.protocol = this._protocol || protocol;
            request_.method = method;
            request_.pathname = "/";
            let globalQueries = {};
            let globalHeaders = {};
            if (!$dara2.isNull(this._globalParameters)) {
              let globalParams = this._globalParameters;
              if (!$dara2.isNull(globalParams.queries)) {
                globalQueries = globalParams.queries;
              }
              if (!$dara2.isNull(globalParams.headers)) {
                globalHeaders = globalParams.headers;
              }
            }
            let extendsHeaders = {};
            let extendsQueries = {};
            if (!$dara2.isNull(runtime.extendsParameters)) {
              let extendsParameters = runtime.extendsParameters;
              if (!$dara2.isNull(extendsParameters.headers)) {
                extendsHeaders = extendsParameters.headers;
              }
              if (!$dara2.isNull(extendsParameters.queries)) {
                extendsQueries = extendsParameters.queries;
              }
            }
            request_.query = Object.assign(Object.assign(Object.assign({ Action: action, Format: "json", Version: version, Timestamp: utils_1.default.getTimestamp(), SignatureNonce: utils_1.default.getNonce() }, globalQueries), extendsQueries), request.query);
            let headers = this.getRpcHeaders();
            if ($dara2.isNull(headers)) {
              request_.headers = Object.assign(Object.assign(Object.assign({ host: this._endpoint, "x-acs-version": version, "x-acs-action": action, "user-agent": utils_1.default.getUserAgent(this._userAgent) }, globalHeaders), extendsHeaders), request.headers);
            } else {
              request_.headers = Object.assign(Object.assign(Object.assign(Object.assign({ host: this._endpoint, "x-acs-version": version, "x-acs-action": action, "user-agent": utils_1.default.getUserAgent(this._userAgent) }, globalHeaders), extendsHeaders), request.headers), headers);
            }
            if (!$dara2.isNull(request.body)) {
              let m = request.body;
              let tmp = utils_1.default.query(m);
              request_.body = new $dara2.BytesReadable($dara2.Form.toFormString(tmp));
              request_.headers["content-type"] = "application/x-www-form-urlencoded";
            }
            if (authType != "Anonymous") {
              if ($dara2.isNull(this._credential)) {
                throw new $_error.ClientError({
                  code: `InvalidCredentials`,
                  message: `Please set up the credentials correctly. If you are setting them through environment variables, please ensure that ALIBABA_CLOUD_ACCESS_KEY_ID and ALIBABA_CLOUD_ACCESS_KEY_SECRET are set correctly. See https://help.aliyun.com/zh/sdk/developer-reference/configure-the-alibaba-cloud-accesskey-environment-variable-on-linux-macos-and-windows-systems for more details.`
                });
              }
              let credentialModel = await this._credential.getCredential();
              if (!$dara2.isNull(credentialModel.providerName)) {
                request_.headers["x-acs-credentials-provider"] = credentialModel.providerName;
              }
              let credentialType = credentialModel.type;
              if (credentialType == "bearer") {
                let bearerToken = credentialModel.bearerToken;
                request_.query["BearerToken"] = bearerToken;
                request_.query["SignatureType"] = "BEARERTOKEN";
              } else if (credentialType == "id_token") {
                let idToken = credentialModel.securityToken;
                request_.headers["x-acs-zero-trust-idtoken"] = idToken;
              } else {
                let accessKeyId = credentialModel.accessKeyId;
                let accessKeySecret = credentialModel.accessKeySecret;
                let securityToken = credentialModel.securityToken;
                if (!$dara2.isNull(securityToken) && securityToken != "") {
                  request_.query["SecurityToken"] = securityToken;
                }
                request_.query["SignatureMethod"] = "HMAC-SHA1";
                request_.query["SignatureVersion"] = "1.0";
                request_.query["AccessKeyId"] = accessKeyId;
                let t = null;
                if (!$dara2.isNull(request.body)) {
                  t = request.body;
                }
                let signedParam = Object.assign(Object.assign({}, request_.query), utils_1.default.query(t));
                request_.query["Signature"] = utils_1.default.getRPCSignature(signedParam, request_.method, accessKeySecret);
              }
            }
            _lastRequest = request_;
            let response_ = await $dara2.doAction(request_, _runtime);
            _lastResponse = response_;
            if (response_.statusCode >= 400 && response_.statusCode < 600) {
              let _res = await $dara2.Stream.readAsJSON(response_.body);
              let err = _res;
              let requestId = err["RequestId"] || err["requestId"];
              let code = err["Code"] || err["code"];
              if (`${code}` == "Throttling" || `${code}` == "Throttling.User" || `${code}` == "Throttling.Api") {
                throw new $_error.ThrottlingError({
                  statusCode: response_.statusCode,
                  code: `${code}`,
                  message: `code: ${response_.statusCode}, ${err["Message"] || err["message"]} request id: ${requestId}`,
                  description: `${err["Description"] || err["description"]}`,
                  retryAfter: utils_1.default.getThrottlingTimeLeft(response_.headers),
                  data: err,
                  requestId: `${requestId}`
                });
              } else if (response_.statusCode >= 400 && response_.statusCode < 500) {
                throw new $_error.ClientError({
                  statusCode: response_.statusCode,
                  code: `${code}`,
                  message: `code: ${response_.statusCode}, ${err["Message"] || err["message"]} request id: ${requestId}`,
                  description: `${err["Description"] || err["description"]}`,
                  data: err,
                  accessDeniedDetail: this.getAccessDeniedDetail(err),
                  requestId: `${requestId}`
                });
              } else {
                throw new $_error.ServerError({
                  statusCode: response_.statusCode,
                  code: `${code}`,
                  message: `code: ${response_.statusCode}, ${err["Message"] || err["message"]} request id: ${requestId}`,
                  description: `${err["Description"] || err["description"]}`,
                  data: err,
                  requestId: `${requestId}`
                });
              }
            }
            if (bodyType == "binary") {
              let resp = {
                body: response_.body,
                headers: response_.headers,
                statusCode: response_.statusCode
              };
              return resp;
            } else if (bodyType == "byte") {
              let byt = await $dara2.Stream.readAsBytes(response_.body);
              return {
                body: byt,
                headers: response_.headers,
                statusCode: response_.statusCode
              };
            } else if (bodyType == "string") {
              let _str = await $dara2.Stream.readAsString(response_.body);
              return {
                body: _str,
                headers: response_.headers,
                statusCode: response_.statusCode
              };
            } else if (bodyType == "json") {
              let obj = await $dara2.Stream.readAsJSON(response_.body);
              let res = obj;
              return {
                body: res,
                headers: response_.headers,
                statusCode: response_.statusCode
              };
            } else if (bodyType == "array") {
              let arr = await $dara2.Stream.readAsJSON(response_.body);
              return {
                body: arr,
                headers: response_.headers,
                statusCode: response_.statusCode
              };
            } else {
              return {
                headers: response_.headers,
                statusCode: response_.statusCode
              };
            }
          } catch (ex) {
            _context = new $dara2.RetryPolicyContext({
              retriesAttempted: _retriesAttempted,
              httpRequest: _lastRequest,
              httpResponse: _lastResponse,
              exception: ex
            });
            continue;
          }
        }
        throw $dara2.newUnretryableError(_context);
      }
      /**
       * @remarks
       * Encapsulate the request and invoke the network
       *
       * @param action - api name
       * @param version - product version
       * @param protocol - http or https
       * @param method - e.g. GET
       * @param authType - authorization type e.g. AK
       * @param pathname - pathname of every api
       * @param bodyType - response body type e.g. String
       * @param request - object of OpenApiRequest
       * @param runtime - which controls some details of call api, such as retry times
       * @returns the response
       */
      async doROARequest(action, version, protocol, method, authType, pathname, bodyType, request, runtime) {
        let _runtime = {
          key: runtime.key || this._key,
          cert: runtime.cert || this._cert,
          ca: runtime.ca || this._ca,
          readTimeout: runtime.readTimeout || this._readTimeout,
          connectTimeout: runtime.connectTimeout || this._connectTimeout,
          httpProxy: runtime.httpProxy || this._httpProxy,
          httpsProxy: runtime.httpsProxy || this._httpsProxy,
          noProxy: runtime.noProxy || this._noProxy,
          socks5Proxy: runtime.socks5Proxy || this._socks5Proxy,
          socks5NetWork: runtime.socks5NetWork || this._socks5NetWork,
          maxIdleConns: runtime.maxIdleConns || this._maxIdleConns,
          retryOptions: this._retryOptions,
          ignoreSSL: runtime.ignoreSSL,
          tlsMinVersion: this._tlsMinVersion
        };
        let _retriesAttempted = 0;
        let _lastRequest = null, _lastResponse = null;
        let _context = new $dara2.RetryPolicyContext({
          retriesAttempted: _retriesAttempted
        });
        while ($dara2.shouldRetry(_runtime["retryOptions"], _context)) {
          if (_retriesAttempted > 0) {
            let _backoffTime = $dara2.getBackoffDelay(_runtime["retryOptions"], _context);
            if (_backoffTime > 0) {
              await $dara2.sleep(_backoffTime);
            }
          }
          _retriesAttempted = _retriesAttempted + 1;
          try {
            let request_ = new $dara2.Request();
            request_.protocol = this._protocol || protocol;
            request_.method = method;
            request_.pathname = pathname;
            let globalQueries = {};
            let globalHeaders = {};
            if (!$dara2.isNull(this._globalParameters)) {
              let globalParams = this._globalParameters;
              if (!$dara2.isNull(globalParams.queries)) {
                globalQueries = globalParams.queries;
              }
              if (!$dara2.isNull(globalParams.headers)) {
                globalHeaders = globalParams.headers;
              }
            }
            let extendsHeaders = {};
            let extendsQueries = {};
            if (!$dara2.isNull(runtime.extendsParameters)) {
              let extendsParameters = runtime.extendsParameters;
              if (!$dara2.isNull(extendsParameters.headers)) {
                extendsHeaders = extendsParameters.headers;
              }
              if (!$dara2.isNull(extendsParameters.queries)) {
                extendsQueries = extendsParameters.queries;
              }
            }
            request_.headers = Object.assign(Object.assign(Object.assign({ date: utils_1.default.getDateUTCString(), host: this._endpoint, accept: "application/json", "x-acs-signature-nonce": utils_1.default.getNonce(), "x-acs-signature-method": "HMAC-SHA1", "x-acs-signature-version": "1.0", "x-acs-version": version, "x-acs-action": action, "user-agent": utils_1.default.getUserAgent(this._userAgent) }, globalHeaders), extendsHeaders), request.headers);
            if (!$dara2.isNull(request.body)) {
              request_.body = new $dara2.BytesReadable(typeof request.body === "string" ? request.body : JSON.stringify(request.body));
              request_.headers["content-type"] = "application/json; charset=utf-8";
            }
            request_.query = Object.assign(Object.assign({}, globalQueries), extendsQueries);
            if (!$dara2.isNull(request.query)) {
              request_.query = Object.assign(Object.assign({}, request_.query), request.query);
            }
            if (authType != "Anonymous") {
              if ($dara2.isNull(this._credential)) {
                throw new $_error.ClientError({
                  code: `InvalidCredentials`,
                  message: `Please set up the credentials correctly. If you are setting them through environment variables, please ensure that ALIBABA_CLOUD_ACCESS_KEY_ID and ALIBABA_CLOUD_ACCESS_KEY_SECRET are set correctly. See https://help.aliyun.com/zh/sdk/developer-reference/configure-the-alibaba-cloud-accesskey-environment-variable-on-linux-macos-and-windows-systems for more details.`
                });
              }
              let credentialModel = await this._credential.getCredential();
              if (!$dara2.isNull(credentialModel.providerName)) {
                request_.headers["x-acs-credentials-provider"] = credentialModel.providerName;
              }
              let credentialType = credentialModel.type;
              if (credentialType == "bearer") {
                let bearerToken = credentialModel.bearerToken;
                request_.headers["x-acs-bearer-token"] = bearerToken;
                request_.headers["x-acs-signature-type"] = "BEARERTOKEN";
              } else if (credentialType == "id_token") {
                let idToken = credentialModel.securityToken;
                request_.headers["x-acs-zero-trust-idtoken"] = idToken;
              } else {
                let accessKeyId = credentialModel.accessKeyId;
                let accessKeySecret = credentialModel.accessKeySecret;
                let securityToken = credentialModel.securityToken;
                if (!$dara2.isNull(securityToken) && securityToken != "") {
                  request_.headers["x-acs-accesskey-id"] = accessKeyId;
                  request_.headers["x-acs-security-token"] = securityToken;
                }
                let stringToSign = utils_1.default.getStringToSign(request_);
                request_.headers["authorization"] = `acs ${accessKeyId}:${utils_1.default.getROASignature(stringToSign, accessKeySecret)}`;
              }
            }
            _lastRequest = request_;
            let response_ = await $dara2.doAction(request_, _runtime);
            _lastResponse = response_;
            if (response_.statusCode == 204) {
              return {
                headers: response_.headers
              };
            }
            if (response_.statusCode >= 400 && response_.statusCode < 600) {
              let _res = await $dara2.Stream.readAsJSON(response_.body);
              let err = _res;
              let requestId = err["RequestId"] || err["requestId"];
              requestId = requestId || err["requestid"];
              let code = err["Code"] || err["code"];
              if (`${code}` == "Throttling" || `${code}` == "Throttling.User" || `${code}` == "Throttling.Api") {
                throw new $_error.ThrottlingError({
                  statusCode: response_.statusCode,
                  code: `${code}`,
                  message: `code: ${response_.statusCode}, ${err["Message"] || err["message"]} request id: ${requestId}`,
                  description: `${err["Description"] || err["description"]}`,
                  retryAfter: utils_1.default.getThrottlingTimeLeft(response_.headers),
                  data: err,
                  requestId: `${requestId}`
                });
              } else if (response_.statusCode >= 400 && response_.statusCode < 500) {
                throw new $_error.ClientError({
                  statusCode: response_.statusCode,
                  code: `${code}`,
                  message: `code: ${response_.statusCode}, ${err["Message"] || err["message"]} request id: ${requestId}`,
                  description: `${err["Description"] || err["description"]}`,
                  data: err,
                  accessDeniedDetail: this.getAccessDeniedDetail(err),
                  requestId: `${requestId}`
                });
              } else {
                throw new $_error.ServerError({
                  statusCode: response_.statusCode,
                  code: `${code}`,
                  message: `code: ${response_.statusCode}, ${err["Message"] || err["message"]} request id: ${requestId}`,
                  description: `${err["Description"] || err["description"]}`,
                  data: err,
                  requestId: `${requestId}`
                });
              }
            }
            if (bodyType == "binary") {
              let resp = {
                body: response_.body,
                headers: response_.headers,
                statusCode: response_.statusCode
              };
              return resp;
            } else if (bodyType == "byte") {
              let byt = await $dara2.Stream.readAsBytes(response_.body);
              return {
                body: byt,
                headers: response_.headers,
                statusCode: response_.statusCode
              };
            } else if (bodyType == "string") {
              let _str = await $dara2.Stream.readAsString(response_.body);
              return {
                body: _str,
                headers: response_.headers,
                statusCode: response_.statusCode
              };
            } else if (bodyType == "json") {
              let obj = await $dara2.Stream.readAsJSON(response_.body);
              let res = obj;
              return {
                body: res,
                headers: response_.headers,
                statusCode: response_.statusCode
              };
            } else if (bodyType == "array") {
              let arr = await $dara2.Stream.readAsJSON(response_.body);
              return {
                body: arr,
                headers: response_.headers,
                statusCode: response_.statusCode
              };
            } else {
              return {
                headers: response_.headers,
                statusCode: response_.statusCode
              };
            }
          } catch (ex) {
            _context = new $dara2.RetryPolicyContext({
              retriesAttempted: _retriesAttempted,
              httpRequest: _lastRequest,
              httpResponse: _lastResponse,
              exception: ex
            });
            continue;
          }
        }
        throw $dara2.newUnretryableError(_context);
      }
      /**
       * @remarks
       * Encapsulate the request and invoke the network with form body
       *
       * @param action - api name
       * @param version - product version
       * @param protocol - http or https
       * @param method - e.g. GET
       * @param authType - authorization type e.g. AK
       * @param pathname - pathname of every api
       * @param bodyType - response body type e.g. String
       * @param request - object of OpenApiRequest
       * @param runtime - which controls some details of call api, such as retry times
       * @returns the response
       */
      async doROARequestWithForm(action, version, protocol, method, authType, pathname, bodyType, request, runtime) {
        let _runtime = {
          key: runtime.key || this._key,
          cert: runtime.cert || this._cert,
          ca: runtime.ca || this._ca,
          readTimeout: runtime.readTimeout || this._readTimeout,
          connectTimeout: runtime.connectTimeout || this._connectTimeout,
          httpProxy: runtime.httpProxy || this._httpProxy,
          httpsProxy: runtime.httpsProxy || this._httpsProxy,
          noProxy: runtime.noProxy || this._noProxy,
          socks5Proxy: runtime.socks5Proxy || this._socks5Proxy,
          socks5NetWork: runtime.socks5NetWork || this._socks5NetWork,
          maxIdleConns: runtime.maxIdleConns || this._maxIdleConns,
          retryOptions: this._retryOptions,
          ignoreSSL: runtime.ignoreSSL,
          tlsMinVersion: this._tlsMinVersion
        };
        let _retriesAttempted = 0;
        let _lastRequest = null, _lastResponse = null;
        let _context = new $dara2.RetryPolicyContext({
          retriesAttempted: _retriesAttempted
        });
        while ($dara2.shouldRetry(_runtime["retryOptions"], _context)) {
          if (_retriesAttempted > 0) {
            let _backoffTime = $dara2.getBackoffDelay(_runtime["retryOptions"], _context);
            if (_backoffTime > 0) {
              await $dara2.sleep(_backoffTime);
            }
          }
          _retriesAttempted = _retriesAttempted + 1;
          try {
            let request_ = new $dara2.Request();
            request_.protocol = this._protocol || protocol;
            request_.method = method;
            request_.pathname = pathname;
            let globalQueries = {};
            let globalHeaders = {};
            if (!$dara2.isNull(this._globalParameters)) {
              let globalParams = this._globalParameters;
              if (!$dara2.isNull(globalParams.queries)) {
                globalQueries = globalParams.queries;
              }
              if (!$dara2.isNull(globalParams.headers)) {
                globalHeaders = globalParams.headers;
              }
            }
            let extendsHeaders = {};
            let extendsQueries = {};
            if (!$dara2.isNull(runtime.extendsParameters)) {
              let extendsParameters = runtime.extendsParameters;
              if (!$dara2.isNull(extendsParameters.headers)) {
                extendsHeaders = extendsParameters.headers;
              }
              if (!$dara2.isNull(extendsParameters.queries)) {
                extendsQueries = extendsParameters.queries;
              }
            }
            request_.headers = Object.assign(Object.assign(Object.assign({ date: utils_1.default.getDateUTCString(), host: this._endpoint, accept: "application/json", "x-acs-signature-nonce": utils_1.default.getNonce(), "x-acs-signature-method": "HMAC-SHA1", "x-acs-signature-version": "1.0", "x-acs-version": version, "x-acs-action": action, "user-agent": utils_1.default.getUserAgent(this._userAgent) }, globalHeaders), extendsHeaders), request.headers);
            if (!$dara2.isNull(request.body)) {
              let m = request.body;
              request_.body = new $dara2.BytesReadable(utils_1.default.toForm(m));
              request_.headers["content-type"] = "application/x-www-form-urlencoded";
            }
            request_.query = Object.assign(Object.assign({}, globalQueries), extendsQueries);
            if (!$dara2.isNull(request.query)) {
              request_.query = Object.assign(Object.assign({}, request_.query), request.query);
            }
            if (authType != "Anonymous") {
              if ($dara2.isNull(this._credential)) {
                throw new $_error.ClientError({
                  code: `InvalidCredentials`,
                  message: `Please set up the credentials correctly. If you are setting them through environment variables, please ensure that ALIBABA_CLOUD_ACCESS_KEY_ID and ALIBABA_CLOUD_ACCESS_KEY_SECRET are set correctly. See https://help.aliyun.com/zh/sdk/developer-reference/configure-the-alibaba-cloud-accesskey-environment-variable-on-linux-macos-and-windows-systems for more details.`
                });
              }
              let credentialModel = await this._credential.getCredential();
              if (!$dara2.isNull(credentialModel.providerName)) {
                request_.headers["x-acs-credentials-provider"] = credentialModel.providerName;
              }
              let credentialType = credentialModel.type;
              if (credentialType == "bearer") {
                let bearerToken = credentialModel.bearerToken;
                request_.headers["x-acs-bearer-token"] = bearerToken;
                request_.headers["x-acs-signature-type"] = "BEARERTOKEN";
              } else if (credentialType == "id_token") {
                let idToken = credentialModel.securityToken;
                request_.headers["x-acs-zero-trust-idtoken"] = idToken;
              } else {
                let accessKeyId = credentialModel.accessKeyId;
                let accessKeySecret = credentialModel.accessKeySecret;
                let securityToken = credentialModel.securityToken;
                if (!$dara2.isNull(securityToken) && securityToken != "") {
                  request_.headers["x-acs-accesskey-id"] = accessKeyId;
                  request_.headers["x-acs-security-token"] = securityToken;
                }
                let stringToSign = utils_1.default.getStringToSign(request_);
                request_.headers["authorization"] = `acs ${accessKeyId}:${utils_1.default.getROASignature(stringToSign, accessKeySecret)}`;
              }
            }
            _lastRequest = request_;
            let response_ = await $dara2.doAction(request_, _runtime);
            _lastResponse = response_;
            if (response_.statusCode == 204) {
              return {
                headers: response_.headers
              };
            }
            if (response_.statusCode >= 400 && response_.statusCode < 600) {
              let _res = await $dara2.Stream.readAsJSON(response_.body);
              let err = _res;
              let requestId = err["RequestId"] || err["requestId"];
              let code = err["Code"] || err["code"];
              if (`${code}` == "Throttling" || `${code}` == "Throttling.User" || `${code}` == "Throttling.Api") {
                throw new $_error.ThrottlingError({
                  statusCode: response_.statusCode,
                  code: `${code}`,
                  message: `code: ${response_.statusCode}, ${err["Message"] || err["message"]} request id: ${requestId}`,
                  description: `${err["Description"] || err["description"]}`,
                  retryAfter: utils_1.default.getThrottlingTimeLeft(response_.headers),
                  data: err,
                  requestId: `${requestId}`
                });
              } else if (response_.statusCode >= 400 && response_.statusCode < 500) {
                throw new $_error.ClientError({
                  statusCode: response_.statusCode,
                  code: `${code}`,
                  message: `code: ${response_.statusCode}, ${err["Message"] || err["message"]} request id: ${requestId}`,
                  description: `${err["Description"] || err["description"]}`,
                  data: err,
                  accessDeniedDetail: this.getAccessDeniedDetail(err),
                  requestId: `${requestId}`
                });
              } else {
                throw new $_error.ServerError({
                  statusCode: response_.statusCode,
                  code: `${code}`,
                  message: `code: ${response_.statusCode}, ${err["Message"] || err["message"]} request id: ${requestId}`,
                  description: `${err["Description"] || err["description"]}`,
                  data: err,
                  requestId: `${requestId}`
                });
              }
            }
            if (bodyType == "binary") {
              let resp = {
                body: response_.body,
                headers: response_.headers,
                statusCode: response_.statusCode
              };
              return resp;
            } else if (bodyType == "byte") {
              let byt = await $dara2.Stream.readAsBytes(response_.body);
              return {
                body: byt,
                headers: response_.headers,
                statusCode: response_.statusCode
              };
            } else if (bodyType == "string") {
              let _str = await $dara2.Stream.readAsString(response_.body);
              return {
                body: _str,
                headers: response_.headers,
                statusCode: response_.statusCode
              };
            } else if (bodyType == "json") {
              let obj = await $dara2.Stream.readAsJSON(response_.body);
              let res = obj;
              return {
                body: res,
                headers: response_.headers,
                statusCode: response_.statusCode
              };
            } else if (bodyType == "array") {
              let arr = await $dara2.Stream.readAsJSON(response_.body);
              return {
                body: arr,
                headers: response_.headers,
                statusCode: response_.statusCode
              };
            } else {
              return {
                headers: response_.headers,
                statusCode: response_.statusCode
              };
            }
          } catch (ex) {
            _context = new $dara2.RetryPolicyContext({
              retriesAttempted: _retriesAttempted,
              httpRequest: _lastRequest,
              httpResponse: _lastResponse,
              exception: ex
            });
            continue;
          }
        }
        throw $dara2.newUnretryableError(_context);
      }
      /**
       * @remarks
       * Encapsulate the request and invoke the network
       *
       * @param action - api name
       * @param version - product version
       * @param protocol - http or https
       * @param method - e.g. GET
       * @param authType - authorization type e.g. AK
       * @param bodyType - response body type e.g. String
       * @param request - object of OpenApiRequest
       * @param runtime - which controls some details of call api, such as retry times
       * @returns the response
       */
      async doRequest(params, request, runtime) {
        let _runtime = {
          key: runtime.key || this._key,
          cert: runtime.cert || this._cert,
          ca: runtime.ca || this._ca,
          readTimeout: runtime.readTimeout || this._readTimeout,
          connectTimeout: runtime.connectTimeout || this._connectTimeout,
          httpProxy: runtime.httpProxy || this._httpProxy,
          httpsProxy: runtime.httpsProxy || this._httpsProxy,
          noProxy: runtime.noProxy || this._noProxy,
          socks5Proxy: runtime.socks5Proxy || this._socks5Proxy,
          socks5NetWork: runtime.socks5NetWork || this._socks5NetWork,
          maxIdleConns: runtime.maxIdleConns || this._maxIdleConns,
          retryOptions: this._retryOptions,
          ignoreSSL: runtime.ignoreSSL,
          tlsMinVersion: this._tlsMinVersion
        };
        let _retriesAttempted = 0;
        let _lastRequest = null, _lastResponse = null;
        let _context = new $dara2.RetryPolicyContext({
          retriesAttempted: _retriesAttempted
        });
        while ($dara2.shouldRetry(_runtime["retryOptions"], _context)) {
          if (_retriesAttempted > 0) {
            let _backoffTime = $dara2.getBackoffDelay(_runtime["retryOptions"], _context);
            if (_backoffTime > 0) {
              await $dara2.sleep(_backoffTime);
            }
          }
          _retriesAttempted = _retriesAttempted + 1;
          try {
            let request_ = new $dara2.Request();
            request_.protocol = this._protocol || params.protocol;
            request_.method = params.method;
            request_.pathname = params.pathname;
            let globalQueries = {};
            let globalHeaders = {};
            if (!$dara2.isNull(this._globalParameters)) {
              let globalParams = this._globalParameters;
              if (!$dara2.isNull(globalParams.queries)) {
                globalQueries = globalParams.queries;
              }
              if (!$dara2.isNull(globalParams.headers)) {
                globalHeaders = globalParams.headers;
              }
            }
            let extendsHeaders = {};
            let extendsQueries = {};
            if (!$dara2.isNull(runtime.extendsParameters)) {
              let extendsParameters = runtime.extendsParameters;
              if (!$dara2.isNull(extendsParameters.headers)) {
                extendsHeaders = extendsParameters.headers;
              }
              if (!$dara2.isNull(extendsParameters.queries)) {
                extendsQueries = extendsParameters.queries;
              }
            }
            request_.query = Object.assign(Object.assign(Object.assign({}, globalQueries), extendsQueries), request.query);
            request_.headers = Object.assign(Object.assign(Object.assign({ host: this._endpoint, "x-acs-version": params.version, "x-acs-action": params.action, "user-agent": utils_1.default.getUserAgent(this._userAgent), "x-acs-date": utils_1.default.getTimestamp(), "x-acs-signature-nonce": utils_1.default.getNonce(), accept: "application/json" }, globalHeaders), extendsHeaders), request.headers);
            if (params.style == "RPC") {
              let headers = this.getRpcHeaders();
              if (!$dara2.isNull(headers)) {
                request_.headers = Object.assign(Object.assign({}, request_.headers), headers);
              }
            }
            let signatureAlgorithm = this._signatureAlgorithm || "ACS3-HMAC-SHA256";
            let hashedRequestPayload = utils_1.default.hash(Buffer.from("", "utf-8"), signatureAlgorithm);
            if (!$dara2.isNull(request.stream)) {
              let tmp = await $dara2.Stream.readAsBytes(request.stream);
              hashedRequestPayload = utils_1.default.hash(tmp, signatureAlgorithm);
              request_.body = new $dara2.BytesReadable(tmp);
              request_.headers["content-type"] = "application/octet-stream";
            } else {
              if (!$dara2.isNull(request.body)) {
                if (params.reqBodyType == "byte") {
                  let byteObj = Buffer.from(request.body);
                  hashedRequestPayload = utils_1.default.hash(byteObj, signatureAlgorithm);
                  request_.body = new $dara2.BytesReadable(byteObj);
                } else if (params.reqBodyType == "json") {
                  let jsonObj = typeof request.body === "string" ? request.body : JSON.stringify(request.body);
                  hashedRequestPayload = utils_1.default.hash(Buffer.from(jsonObj, "utf8"), signatureAlgorithm);
                  request_.body = new $dara2.BytesReadable(jsonObj);
                  request_.headers["content-type"] = "application/json; charset=utf-8";
                } else {
                  let m = request.body;
                  let formObj = utils_1.default.toForm(m);
                  hashedRequestPayload = utils_1.default.hash(Buffer.from(formObj, "utf8"), signatureAlgorithm);
                  request_.body = new $dara2.BytesReadable(formObj);
                  request_.headers["content-type"] = "application/x-www-form-urlencoded";
                }
              }
            }
            request_.headers["x-acs-content-sha256"] = hashedRequestPayload.toString("hex");
            if (params.authType != "Anonymous") {
              if ($dara2.isNull(this._credential)) {
                throw new $_error.ClientError({
                  code: `InvalidCredentials`,
                  message: `Please set up the credentials correctly. If you are setting them through environment variables, please ensure that ALIBABA_CLOUD_ACCESS_KEY_ID and ALIBABA_CLOUD_ACCESS_KEY_SECRET are set correctly. See https://help.aliyun.com/zh/sdk/developer-reference/configure-the-alibaba-cloud-accesskey-environment-variable-on-linux-macos-and-windows-systems for more details.`
                });
              }
              let credentialModel = await this._credential.getCredential();
              if (!$dara2.isNull(credentialModel.providerName)) {
                request_.headers["x-acs-credentials-provider"] = credentialModel.providerName;
              }
              let authType = credentialModel.type;
              if (authType == "bearer") {
                let bearerToken = credentialModel.bearerToken;
                request_.headers["x-acs-bearer-token"] = bearerToken;
                if (params.style == "RPC") {
                  request_.query["SignatureType"] = "BEARERTOKEN";
                } else {
                  request_.headers["x-acs-signature-type"] = "BEARERTOKEN";
                }
              } else if (authType == "id_token") {
                let idToken = credentialModel.securityToken;
                request_.headers["x-acs-zero-trust-idtoken"] = idToken;
              } else {
                let accessKeyId = credentialModel.accessKeyId;
                let accessKeySecret = credentialModel.accessKeySecret;
                let securityToken = credentialModel.securityToken;
                if (!$dara2.isNull(securityToken) && securityToken != "") {
                  request_.headers["x-acs-accesskey-id"] = accessKeyId;
                  request_.headers["x-acs-security-token"] = securityToken;
                }
                request_.headers["Authorization"] = utils_1.default.getAuthorization(request_, signatureAlgorithm, hashedRequestPayload.toString("hex"), accessKeyId, accessKeySecret);
              }
            }
            _lastRequest = request_;
            let response_ = await $dara2.doAction(request_, _runtime);
            _lastResponse = response_;
            if (response_.statusCode >= 400 && response_.statusCode < 600) {
              let err = {};
              if (!$dara2.isNull(response_.headers["content-type"]) && response_.headers["content-type"] == "text/xml;charset=utf-8") {
                let _str = await $dara2.Stream.readAsString(response_.body);
                let respMap = $dara2.XML.parseXml(_str, null);
                err = respMap["Error"];
              } else {
                let _res = await $dara2.Stream.readAsJSON(response_.body);
                err = _res;
              }
              let requestId = err["RequestId"] || err["requestId"];
              let code = err["Code"] || err["code"];
              if (`${code}` == "Throttling" || `${code}` == "Throttling.User" || `${code}` == "Throttling.Api") {
                throw new $_error.ThrottlingError({
                  statusCode: response_.statusCode,
                  code: `${code}`,
                  message: `code: ${response_.statusCode}, ${err["Message"] || err["message"]} request id: ${requestId}`,
                  description: `${err["Description"] || err["description"]}`,
                  retryAfter: utils_1.default.getThrottlingTimeLeft(response_.headers),
                  data: err,
                  requestId: `${requestId}`
                });
              } else if (response_.statusCode >= 400 && response_.statusCode < 500) {
                throw new $_error.ClientError({
                  statusCode: response_.statusCode,
                  code: `${code}`,
                  message: `code: ${response_.statusCode}, ${err["Message"] || err["message"]} request id: ${requestId}`,
                  description: `${err["Description"] || err["description"]}`,
                  data: err,
                  accessDeniedDetail: this.getAccessDeniedDetail(err),
                  requestId: `${requestId}`
                });
              } else {
                throw new $_error.ServerError({
                  statusCode: response_.statusCode,
                  code: `${code}`,
                  message: `code: ${response_.statusCode}, ${err["Message"] || err["message"]} request id: ${requestId}`,
                  description: `${err["Description"] || err["description"]}`,
                  data: err,
                  requestId: `${requestId}`
                });
              }
            }
            if (params.bodyType == "binary") {
              let resp = {
                body: response_.body,
                headers: response_.headers,
                statusCode: response_.statusCode
              };
              return resp;
            } else if (params.bodyType == "byte") {
              let byt = await $dara2.Stream.readAsBytes(response_.body);
              return {
                body: byt,
                headers: response_.headers,
                statusCode: response_.statusCode
              };
            } else if (params.bodyType == "string") {
              let respStr = await $dara2.Stream.readAsString(response_.body);
              return {
                body: respStr,
                headers: response_.headers,
                statusCode: response_.statusCode
              };
            } else if (params.bodyType == "json") {
              let obj = await $dara2.Stream.readAsJSON(response_.body);
              let res = obj;
              return {
                body: res,
                headers: response_.headers,
                statusCode: response_.statusCode
              };
            } else if (params.bodyType == "array") {
              let arr = await $dara2.Stream.readAsJSON(response_.body);
              return {
                body: arr,
                headers: response_.headers,
                statusCode: response_.statusCode
              };
            } else {
              let anything = await $dara2.Stream.readAsString(response_.body);
              return {
                body: anything,
                headers: response_.headers,
                statusCode: response_.statusCode
              };
            }
          } catch (ex) {
            _context = new $dara2.RetryPolicyContext({
              retriesAttempted: _retriesAttempted,
              httpRequest: _lastRequest,
              httpResponse: _lastResponse,
              exception: ex
            });
            continue;
          }
        }
        throw $dara2.newUnretryableError(_context);
      }
      /**
       * @remarks
       * Encapsulate the request and invoke the network
       *
       * @param action - api name
       * @param version - product version
       * @param protocol - http or https
       * @param method - e.g. GET
       * @param authType - authorization type e.g. AK
       * @param bodyType - response body type e.g. String
       * @param request - object of OpenApiRequest
       * @param runtime - which controls some details of call api, such as retry times
       * @returns the response
       */
      async execute(params, request, runtime) {
        let _runtime = {
          key: runtime.key || this._key,
          cert: runtime.cert || this._cert,
          ca: runtime.ca || this._ca,
          readTimeout: runtime.readTimeout || this._readTimeout,
          connectTimeout: runtime.connectTimeout || this._connectTimeout,
          httpProxy: runtime.httpProxy || this._httpProxy,
          httpsProxy: runtime.httpsProxy || this._httpsProxy,
          noProxy: runtime.noProxy || this._noProxy,
          socks5Proxy: runtime.socks5Proxy || this._socks5Proxy,
          socks5NetWork: runtime.socks5NetWork || this._socks5NetWork,
          maxIdleConns: runtime.maxIdleConns || this._maxIdleConns,
          retryOptions: this._retryOptions,
          ignoreSSL: runtime.ignoreSSL,
          tlsMinVersion: this._tlsMinVersion,
          disableHttp2: this._disableHttp2 || false
        };
        let _retriesAttempted = 0;
        let _lastRequest = null, _lastResponse = null;
        let _context = new $dara2.RetryPolicyContext({
          retriesAttempted: _retriesAttempted
        });
        while ($dara2.shouldRetry(_runtime["retryOptions"], _context)) {
          if (_retriesAttempted > 0) {
            let _backoffTime = $dara2.getBackoffDelay(_runtime["retryOptions"], _context);
            if (_backoffTime > 0) {
              await $dara2.sleep(_backoffTime);
            }
          }
          _retriesAttempted = _retriesAttempted + 1;
          try {
            let request_ = new $dara2.Request();
            let headers = this.getRpcHeaders();
            let globalQueries = {};
            let globalHeaders = {};
            if (!$dara2.isNull(this._globalParameters)) {
              let globalParams = this._globalParameters;
              if (!$dara2.isNull(globalParams.queries)) {
                globalQueries = globalParams.queries;
              }
              if (!$dara2.isNull(globalParams.headers)) {
                globalHeaders = globalParams.headers;
              }
            }
            let extendsHeaders = {};
            let extendsQueries = {};
            if (!$dara2.isNull(runtime.extendsParameters)) {
              let extendsParameters = runtime.extendsParameters;
              if (!$dara2.isNull(extendsParameters.headers)) {
                extendsHeaders = extendsParameters.headers;
              }
              if (!$dara2.isNull(extendsParameters.queries)) {
                extendsQueries = extendsParameters.queries;
              }
            }
            let requestContext = new $SPI.InterceptorContextRequest({
              headers: Object.assign(Object.assign(Object.assign(Object.assign({}, globalHeaders), extendsHeaders), request.headers), headers),
              query: Object.assign(Object.assign(Object.assign({}, globalQueries), extendsQueries), request.query),
              body: request.body,
              stream: request.stream,
              hostMap: request.hostMap,
              pathname: params.pathname,
              productId: this._productId,
              action: params.action,
              version: params.version,
              protocol: this._protocol || params.protocol,
              method: this._method || params.method,
              authType: params.authType,
              bodyType: params.bodyType,
              reqBodyType: params.reqBodyType,
              style: params.style,
              credential: this._credential,
              signatureVersion: this._signatureVersion,
              signatureAlgorithm: this._signatureAlgorithm,
              userAgent: utils_1.default.getUserAgent(this._userAgent)
            });
            let configurationContext = new $SPI.InterceptorContextConfiguration({
              regionId: this._regionId,
              endpoint: request.endpointOverride || this._endpoint,
              endpointRule: this._endpointRule,
              endpointMap: this._endpointMap,
              endpointType: this._endpointType,
              network: this._network,
              suffix: this._suffix
            });
            let interceptorContext = new $SPI.InterceptorContext({
              request: requestContext,
              configuration: configurationContext
            });
            let attributeMap = new $SPI.AttributeMap({});
            if (!$dara2.isNull(this._attributeMap)) {
              attributeMap = this._attributeMap;
            }
            await this._spi.modifyConfiguration(interceptorContext, attributeMap);
            await this._spi.modifyRequest(interceptorContext, attributeMap);
            request_.protocol = interceptorContext.request.protocol;
            request_.method = interceptorContext.request.method;
            request_.pathname = interceptorContext.request.pathname;
            request_.query = interceptorContext.request.query;
            request_.body = interceptorContext.request.stream;
            request_.headers = interceptorContext.request.headers;
            _lastRequest = request_;
            let response_ = await $dara2.doAction(request_, _runtime);
            _lastResponse = response_;
            let responseContext = new $SPI.InterceptorContextResponse({
              statusCode: response_.statusCode,
              headers: response_.headers,
              body: response_.body
            });
            interceptorContext.response = responseContext;
            await this._spi.modifyResponse(interceptorContext, attributeMap);
            return {
              headers: interceptorContext.response.headers,
              statusCode: interceptorContext.response.statusCode,
              body: interceptorContext.response.deserializedBody
            };
          } catch (ex) {
            _context = new $dara2.RetryPolicyContext({
              retriesAttempted: _retriesAttempted,
              httpRequest: _lastRequest,
              httpResponse: _lastResponse,
              exception: ex
            });
            continue;
          }
        }
        throw $dara2.newUnretryableError(_context);
      }
      callSSEApi(params, request, runtime) {
        return __asyncGenerator(this, arguments, function* callSSEApi_1() {
          var e_1, _a;
          let _runtime = {
            key: runtime.key || this._key,
            cert: runtime.cert || this._cert,
            ca: runtime.ca || this._ca,
            readTimeout: runtime.readTimeout || this._readTimeout,
            connectTimeout: runtime.connectTimeout || this._connectTimeout,
            httpProxy: runtime.httpProxy || this._httpProxy,
            httpsProxy: runtime.httpsProxy || this._httpsProxy,
            noProxy: runtime.noProxy || this._noProxy,
            socks5Proxy: runtime.socks5Proxy || this._socks5Proxy,
            socks5NetWork: runtime.socks5NetWork || this._socks5NetWork,
            maxIdleConns: runtime.maxIdleConns || this._maxIdleConns,
            retryOptions: this._retryOptions,
            ignoreSSL: runtime.ignoreSSL,
            tlsMinVersion: this._tlsMinVersion
          };
          let _retriesAttempted = 0;
          let _lastRequest = null, _lastResponse = null;
          let _context = new $dara2.RetryPolicyContext({
            retriesAttempted: _retriesAttempted
          });
          while ($dara2.shouldRetry(_runtime["retryOptions"], _context)) {
            if (_retriesAttempted > 0) {
              let _backoffTime = $dara2.getBackoffDelay(_runtime["retryOptions"], _context);
              if (_backoffTime > 0) {
                yield __await($dara2.sleep(_backoffTime));
              }
            }
            _retriesAttempted = _retriesAttempted + 1;
            try {
              let request_ = new $dara2.Request();
              request_.protocol = this._protocol || params.protocol;
              request_.method = params.method;
              request_.pathname = params.pathname;
              let globalQueries = {};
              let globalHeaders = {};
              if (!$dara2.isNull(this._globalParameters)) {
                let globalParams = this._globalParameters;
                if (!$dara2.isNull(globalParams.queries)) {
                  globalQueries = globalParams.queries;
                }
                if (!$dara2.isNull(globalParams.headers)) {
                  globalHeaders = globalParams.headers;
                }
              }
              let extendsHeaders = {};
              let extendsQueries = {};
              if (!$dara2.isNull(runtime.extendsParameters)) {
                let extendsParameters = runtime.extendsParameters;
                if (!$dara2.isNull(extendsParameters.headers)) {
                  extendsHeaders = extendsParameters.headers;
                }
                if (!$dara2.isNull(extendsParameters.queries)) {
                  extendsQueries = extendsParameters.queries;
                }
              }
              request_.query = Object.assign(Object.assign(Object.assign({}, globalQueries), extendsQueries), request.query);
              request_.headers = Object.assign(Object.assign(Object.assign({ host: this._endpoint, "x-acs-version": params.version, "x-acs-action": params.action, "user-agent": utils_1.default.getUserAgent(this._userAgent), "x-acs-date": utils_1.default.getTimestamp(), "x-acs-signature-nonce": utils_1.default.getNonce(), accept: "application/json" }, extendsHeaders), globalHeaders), request.headers);
              if (params.style == "RPC") {
                let headers = this.getRpcHeaders();
                if (!$dara2.isNull(headers)) {
                  request_.headers = Object.assign(Object.assign({}, request_.headers), headers);
                }
              }
              let signatureAlgorithm = this._signatureAlgorithm || "ACS3-HMAC-SHA256";
              let hashedRequestPayload = utils_1.default.hash(Buffer.from("", "utf-8"), signatureAlgorithm);
              if (!$dara2.isNull(request.stream)) {
                let tmp = yield __await($dara2.Stream.readAsBytes(request.stream));
                hashedRequestPayload = utils_1.default.hash(tmp, signatureAlgorithm);
                request_.body = new $dara2.BytesReadable(tmp);
                request_.headers["content-type"] = "application/octet-stream";
              } else {
                if (!$dara2.isNull(request.body)) {
                  if (params.reqBodyType == "byte") {
                    let byteObj = Buffer.from(request.body);
                    hashedRequestPayload = utils_1.default.hash(byteObj, signatureAlgorithm);
                    request_.body = new $dara2.BytesReadable(byteObj);
                  } else if (params.reqBodyType == "json") {
                    let jsonObj = typeof request.body === "string" ? request.body : JSON.stringify(request.body);
                    hashedRequestPayload = utils_1.default.hash(Buffer.from(jsonObj, "utf8"), signatureAlgorithm);
                    request_.body = new $dara2.BytesReadable(jsonObj);
                    request_.headers["content-type"] = "application/json; charset=utf-8";
                  } else {
                    let m = request.body;
                    let formObj = utils_1.default.toForm(m);
                    hashedRequestPayload = utils_1.default.hash(Buffer.from(formObj, "utf8"), signatureAlgorithm);
                    request_.body = new $dara2.BytesReadable(formObj);
                    request_.headers["content-type"] = "application/x-www-form-urlencoded";
                  }
                }
              }
              request_.headers["x-acs-content-sha256"] = hashedRequestPayload.toString("hex");
              if (params.authType != "Anonymous") {
                let credentialModel = yield __await(this._credential.getCredential());
                if (!$dara2.isNull(credentialModel.providerName)) {
                  request_.headers["x-acs-credentials-provider"] = credentialModel.providerName;
                }
                let authType = credentialModel.type;
                if (authType == "bearer") {
                  let bearerToken = credentialModel.bearerToken;
                  request_.headers["x-acs-bearer-token"] = bearerToken;
                } else if (authType == "id_token") {
                  let idToken = credentialModel.securityToken;
                  request_.headers["x-acs-zero-trust-idtoken"] = idToken;
                } else {
                  let accessKeyId = credentialModel.accessKeyId;
                  let accessKeySecret = credentialModel.accessKeySecret;
                  let securityToken = credentialModel.securityToken;
                  if (!$dara2.isNull(securityToken) && securityToken != "") {
                    request_.headers["x-acs-accesskey-id"] = accessKeyId;
                    request_.headers["x-acs-security-token"] = securityToken;
                  }
                  request_.headers["Authorization"] = utils_1.default.getAuthorization(request_, signatureAlgorithm, hashedRequestPayload.toString("hex"), accessKeyId, accessKeySecret);
                }
              }
              _lastRequest = request_;
              let response_ = yield __await($dara2.doAction(request_, _runtime));
              _lastResponse = response_;
              if (response_.statusCode >= 400 && response_.statusCode < 600) {
                let err = {};
                if (!$dara2.isNull(response_.headers["content-type"]) && response_.headers["content-type"] == "text/xml;charset=utf-8") {
                  let _str = yield __await($dara2.Stream.readAsString(response_.body));
                  let respMap = $dara2.XML.parseXml(_str, null);
                  err = respMap["Error"];
                } else {
                  let _res = yield __await($dara2.Stream.readAsJSON(response_.body));
                  err = _res;
                }
                err["statusCode"] = response_.statusCode;
                throw $dara2.newError({
                  code: `${err["Code"] || err["code"]}`,
                  message: `code: ${response_.statusCode}, ${err["Message"] || err["message"]} request id: ${err["RequestId"] || err["requestId"]}`,
                  data: err,
                  description: `${err["Description"] || err["description"]}`,
                  accessDeniedDetail: err["AccessDeniedDetail"] || err["accessDeniedDetail"]
                });
              }
              let events = yield __await($dara2.Stream.readAsSSE(response_.body));
              try {
                for (var events_1 = (e_1 = void 0, __asyncValues(events)), events_1_1; events_1_1 = yield __await(events_1.next()), !events_1_1.done; ) {
                  let event = events_1_1.value;
                  yield yield __await(new $_model.SSEResponse({
                    statusCode: response_.statusCode,
                    headers: response_.headers,
                    event
                  }));
                }
              } catch (e_1_1) {
                e_1 = { error: e_1_1 };
              } finally {
                try {
                  if (events_1_1 && !events_1_1.done && (_a = events_1.return)) yield __await(_a.call(events_1));
                } finally {
                  if (e_1) throw e_1.error;
                }
              }
              return yield __await(null);
            } catch (ex) {
              _context = new $dara2.RetryPolicyContext({
                retriesAttempted: _retriesAttempted,
                httpRequest: _lastRequest,
                httpResponse: _lastResponse,
                exception: ex
              });
              continue;
            }
          }
          throw $dara2.newUnretryableError(_context);
        });
      }
      async callApi(params, request, runtime) {
        if ($dara2.isNull(params)) {
          throw new $_error.ClientError({
            code: "ParameterMissing",
            message: "'params' can not be unset"
          });
        }
        if ($dara2.isNull(this._signatureVersion) || this._signatureVersion != "v4") {
          if ($dara2.isNull(this._signatureAlgorithm) || this._signatureAlgorithm != "v2") {
            return await this.doRequest(params, request, runtime);
          } else if (params.style == "ROA" && params.reqBodyType == "json") {
            return await this.doROARequest(params.action, params.version, params.protocol, params.method, params.authType, params.pathname, params.bodyType, request, runtime);
          } else if (params.style == "ROA") {
            return await this.doROARequestWithForm(params.action, params.version, params.protocol, params.method, params.authType, params.pathname, params.bodyType, request, runtime);
          } else {
            return await this.doRPCRequest(params.action, params.version, params.protocol, params.method, params.authType, params.bodyType, request, runtime);
          }
        } else {
          return await this.execute(params, request, runtime);
        }
      }
      /**
       * @remarks
       * Get accesskey id by using credential
       * @returns accesskey id
       */
      async getAccessKeyId() {
        if ($dara2.isNull(this._credential)) {
          return "";
        }
        let accessKeyId = await this._credential.getAccessKeyId();
        return accessKeyId;
      }
      /**
       * @remarks
       * Get accesskey secret by using credential
       * @returns accesskey secret
       */
      async getAccessKeySecret() {
        if ($dara2.isNull(this._credential)) {
          return "";
        }
        let secret = await this._credential.getAccessKeySecret();
        return secret;
      }
      /**
       * @remarks
       * Get security token by using credential
       * @returns security token
       */
      async getSecurityToken() {
        if ($dara2.isNull(this._credential)) {
          return "";
        }
        let token = await this._credential.getSecurityToken();
        return token;
      }
      /**
       * @remarks
       * Get bearer token by credential
       * @returns bearer token
       */
      async getBearerToken() {
        if ($dara2.isNull(this._credential)) {
          return "";
        }
        let token = this._credential.getBearerToken();
        return token;
      }
      /**
       * @remarks
       * Get credential type by credential
       * @returns credential type e.g. access_key
       */
      async getType() {
        if ($dara2.isNull(this._credential)) {
          return "";
        }
        let authType = this._credential.getType();
        return authType;
      }
      /**
       * @remarks
       * If the endpointRule and config.endpoint are empty, throw error
       *
       * @param config - config contains the necessary information to create a client
       */
      checkConfig(config2) {
        if ($dara2.isNull(this._endpointRule) && $dara2.isNull(config2.endpoint)) {
          throw new $_error.ClientError({
            code: "ParameterMissing",
            message: "'config.endpoint' can not be empty"
          });
        }
      }
      /**
       * @remarks
       * set gateway client
       *
       * @param spi - .
       */
      setGatewayClient(spi) {
        this._spi = spi;
      }
      /**
       * @remarks
       * set RPC header for debug
       *
       * @param headers - headers for debug, this header can be used only once.
       */
      setRpcHeaders(headers) {
        this._headers = headers;
      }
      /**
       * @remarks
       * get RPC header for debug
       */
      getRpcHeaders() {
        let headers = this._headers;
        this._headers = null;
        return headers;
      }
      getAccessDeniedDetail(err) {
        let accessDeniedDetail = null;
        if (!$dara2.isNull(err["AccessDeniedDetail"])) {
          let detail1 = err["AccessDeniedDetail"];
          accessDeniedDetail = detail1;
        } else if (!$dara2.isNull(err["accessDeniedDetail"])) {
          let detail2 = err["accessDeniedDetail"];
          accessDeniedDetail = detail2;
        }
        return accessDeniedDetail;
      }
    };
    exports2.default = Client;
  }
});

// node_modules/@alicloud/outboundbot20191226/dist/models/CreateAgentProfileResponseBody.js
var require_CreateAgentProfileResponseBody = __commonJS({
  "node_modules/@alicloud/outboundbot20191226/dist/models/CreateAgentProfileResponseBody.js"(exports2) {
    "use strict";
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    }) : (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      o[k2] = m[k];
    }));
    var __setModuleDefault = exports2 && exports2.__setModuleDefault || (Object.create ? (function(o, v) {
      Object.defineProperty(o, "default", { enumerable: true, value: v });
    }) : function(o, v) {
      o["default"] = v;
    });
    var __importStar = exports2 && exports2.__importStar || /* @__PURE__ */ (function() {
      var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function(o2) {
          var ar = [];
          for (var k in o2) if (Object.prototype.hasOwnProperty.call(o2, k)) ar[ar.length] = k;
          return ar;
        };
        return ownKeys(o);
      };
      return function(mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) {
          for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        }
        __setModuleDefault(result, mod);
        return result;
      };
    })();
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.CreateAgentProfileResponseBody = exports2.CreateAgentProfileResponseBodyData = void 0;
    var $dara2 = __importStar(require_dist());
    var CreateAgentProfileResponseBodyData = class extends $dara2.Model {
      static names() {
        return {
          agentProfileId: "AgentProfileId",
          agentProfileTemplateId: "AgentProfileTemplateId",
          agentType: "AgentType",
          createTime: "CreateTime",
          description: "Description",
          instanceId: "InstanceId",
          instructionJson: "InstructionJson",
          labelsJson: "LabelsJson",
          model: "Model",
          modelConfig: "ModelConfig",
          prompt: "Prompt",
          promptJson: "PromptJson",
          scenario: "Scenario",
          scriptId: "ScriptId",
          system: "System",
          updateTime: "UpdateTime",
          variablesJson: "VariablesJson"
        };
      }
      static types() {
        return {
          agentProfileId: "string",
          agentProfileTemplateId: "string",
          agentType: "string",
          createTime: "string",
          description: "string",
          instanceId: "string",
          instructionJson: "string",
          labelsJson: "string",
          model: "string",
          modelConfig: "string",
          prompt: "string",
          promptJson: "string",
          scenario: "string",
          scriptId: "string",
          system: "boolean",
          updateTime: "string",
          variablesJson: "string"
        };
      }
      validate() {
        super.validate();
      }
      constructor(map) {
        super(map);
      }
    };
    exports2.CreateAgentProfileResponseBodyData = CreateAgentProfileResponseBodyData;
    var CreateAgentProfileResponseBody = class extends $dara2.Model {
      static names() {
        return {
          code: "Code",
          data: "Data",
          httpStatusCode: "HttpStatusCode",
          message: "Message",
          requestId: "RequestId",
          success: "Success"
        };
      }
      static types() {
        return {
          code: "string",
          data: CreateAgentProfileResponseBodyData,
          httpStatusCode: "number",
          message: "string",
          requestId: "string",
          success: "boolean"
        };
      }
      validate() {
        if (this.data && typeof this.data.validate === "function") {
          this.data.validate();
        }
        super.validate();
      }
      constructor(map) {
        super(map);
      }
    };
    exports2.CreateAgentProfileResponseBody = CreateAgentProfileResponseBody;
  }
});

// node_modules/@alicloud/outboundbot20191226/dist/models/CreateAnnotationMissionResponseBody.js
var require_CreateAnnotationMissionResponseBody = __commonJS({
  "node_modules/@alicloud/outboundbot20191226/dist/models/CreateAnnotationMissionResponseBody.js"(exports2) {
    "use strict";
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    }) : (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      o[k2] = m[k];
    }));
    var __setModuleDefault = exports2 && exports2.__setModuleDefault || (Object.create ? (function(o, v) {
      Object.defineProperty(o, "default", { enumerable: true, value: v });
    }) : function(o, v) {
      o["default"] = v;
    });
    var __importStar = exports2 && exports2.__importStar || /* @__PURE__ */ (function() {
      var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function(o2) {
          var ar = [];
          for (var k in o2) if (Object.prototype.hasOwnProperty.call(o2, k)) ar[ar.length] = k;
          return ar;
        };
        return ownKeys(o);
      };
      return function(mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) {
          for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        }
        __setModuleDefault(result, mod);
        return result;
      };
    })();
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.CreateAnnotationMissionResponseBody = exports2.CreateAnnotationMissionResponseBodyData = void 0;
    var $dara2 = __importStar(require_dist());
    var CreateAnnotationMissionResponseBodyData = class extends $dara2.Model {
      static names() {
        return {
          message: "Message",
          success: "Success"
        };
      }
      static types() {
        return {
          message: "string",
          success: "boolean"
        };
      }
      validate() {
        super.validate();
      }
      constructor(map) {
        super(map);
      }
    };
    exports2.CreateAnnotationMissionResponseBodyData = CreateAnnotationMissionResponseBodyData;
    var CreateAnnotationMissionResponseBody = class extends $dara2.Model {
      static names() {
        return {
          code: "Code",
          data: "Data",
          httpStatusCode: "HttpStatusCode",
          message: "Message",
          requestId: "RequestId",
          success: "Success"
        };
      }
      static types() {
        return {
          code: "string",
          data: CreateAnnotationMissionResponseBodyData,
          httpStatusCode: "number",
          message: "string",
          requestId: "string",
          success: "boolean"
        };
      }
      validate() {
        if (this.data && typeof this.data.validate === "function") {
          this.data.validate();
        }
        super.validate();
      }
      constructor(map) {
        super(map);
      }
    };
    exports2.CreateAnnotationMissionResponseBody = CreateAnnotationMissionResponseBody;
  }
});

// node_modules/@alicloud/outboundbot20191226/dist/models/CreateBatchJobsResponseBody.js
var require_CreateBatchJobsResponseBody = __commonJS({
  "node_modules/@alicloud/outboundbot20191226/dist/models/CreateBatchJobsResponseBody.js"(exports2) {
    "use strict";
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    }) : (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      o[k2] = m[k];
    }));
    var __setModuleDefault = exports2 && exports2.__setModuleDefault || (Object.create ? (function(o, v) {
      Object.defineProperty(o, "default", { enumerable: true, value: v });
    }) : function(o, v) {
      o["default"] = v;
    });
    var __importStar = exports2 && exports2.__importStar || /* @__PURE__ */ (function() {
      var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function(o2) {
          var ar = [];
          for (var k in o2) if (Object.prototype.hasOwnProperty.call(o2, k)) ar[ar.length] = k;
          return ar;
        };
        return ownKeys(o);
      };
      return function(mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) {
          for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        }
        __setModuleDefault(result, mod);
        return result;
      };
    })();
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.CreateBatchJobsResponseBody = exports2.CreateBatchJobsResponseBodyBatchJob = exports2.CreateBatchJobsResponseBodyBatchJobStrategy = exports2.CreateBatchJobsResponseBodyBatchJobStrategyWorkingTime = void 0;
    var $dara2 = __importStar(require_dist());
    var CreateBatchJobsResponseBodyBatchJobStrategyWorkingTime = class extends $dara2.Model {
      static names() {
        return {
          beginTime: "BeginTime",
          endTime: "EndTime"
        };
      }
      static types() {
        return {
          beginTime: "string",
          endTime: "string"
        };
      }
      validate() {
        super.validate();
      }
      constructor(map) {
        super(map);
      }
    };
    exports2.CreateBatchJobsResponseBodyBatchJobStrategyWorkingTime = CreateBatchJobsResponseBodyBatchJobStrategyWorkingTime;
    var CreateBatchJobsResponseBodyBatchJobStrategy = class extends $dara2.Model {
      static names() {
        return {
          customized: "Customized",
          endTime: "EndTime",
          followUpStrategy: "FollowUpStrategy",
          isTemplate: "IsTemplate",
          maxAttemptsPerDay: "MaxAttemptsPerDay",
          minAttemptInterval: "MinAttemptInterval",
          repeatBy: "RepeatBy",
          repeatDays: "RepeatDays",
          routingStrategy: "RoutingStrategy",
          startTime: "StartTime",
          strategyDescription: "StrategyDescription",
          strategyId: "StrategyId",
          strategyName: "StrategyName",
          type: "Type",
          workingTime: "WorkingTime"
        };
      }
      static types() {
        return {
          customized: "string",
          endTime: "number",
          followUpStrategy: "string",
          isTemplate: "boolean",
          maxAttemptsPerDay: "number",
          minAttemptInterval: "number",
          repeatBy: "string",
          repeatDays: { "type": "array", "itemType": "string" },
          routingStrategy: "string",
          startTime: "number",
          strategyDescription: "string",
          strategyId: "string",
          strategyName: "string",
          type: "string",
          workingTime: { "type": "array", "itemType": CreateBatchJobsResponseBodyBatchJobStrategyWorkingTime }
        };
      }
      validate() {
        if (Array.isArray(this.repeatDays)) {
          $dara2.Model.validateArray(this.repeatDays);
        }
        if (Array.isArray(this.workingTime)) {
          $dara2.Model.validateArray(this.workingTime);
        }
        super.validate();
      }
      constructor(map) {
        super(map);
      }
    };
    exports2.CreateBatchJobsResponseBodyBatchJobStrategy = CreateBatchJobsResponseBodyBatchJobStrategy;
    var CreateBatchJobsResponseBodyBatchJob = class extends $dara2.Model {
      static names() {
        return {
          batchJobId: "BatchJobId",
          callingNumbers: "CallingNumbers",
          creationTime: "CreationTime",
          jobFilePath: "JobFilePath",
          jobGroupDescription: "JobGroupDescription",
          jobGroupName: "JobGroupName",
          scenarioId: "ScenarioId",
          strategy: "Strategy"
        };
      }
      static types() {
        return {
          batchJobId: "string",
          callingNumbers: { "type": "array", "itemType": "string" },
          creationTime: "number",
          jobFilePath: "string",
          jobGroupDescription: "string",
          jobGroupName: "string",
          scenarioId: "string",
          strategy: CreateBatchJobsResponseBodyBatchJobStrategy
        };
      }
      validate() {
        if (Array.isArray(this.callingNumbers)) {
          $dara2.Model.validateArray(this.callingNumbers);
        }
        if (this.strategy && typeof this.strategy.validate === "function") {
          this.strategy.validate();
        }
        super.validate();
      }
      constructor(map) {
        super(map);
      }
    };
    exports2.CreateBatchJobsResponseBodyBatchJob = CreateBatchJobsResponseBodyBatchJob;
    var CreateBatchJobsResponseBody = class extends $dara2.Model {
      static names() {
        return {
          batchJob: "BatchJob",
          code: "Code",
          httpStatusCode: "HttpStatusCode",
          message: "Message",
          requestId: "RequestId",
          success: "Success"
        };
      }
      static types() {
        return {
          batchJob: CreateBatchJobsResponseBodyBatchJob,
          code: "string",
          httpStatusCode: "number",
          message: "string",
          requestId: "string",
          success: "boolean"
        };
      }
      validate() {
        if (this.batchJob && typeof this.batchJob.validate === "function") {
          this.batchJob.validate();
        }
        super.validate();
      }
      constructor(map) {
        super(map);
      }
    };
    exports2.CreateBatchJobsResponseBody = CreateBatchJobsResponseBody;
  }
});

// node_modules/@alicloud/outboundbot20191226/dist/models/CreateBatchRepeatJobResponseBody.js
var require_CreateBatchRepeatJobResponseBody = __commonJS({
  "node_modules/@alicloud/outboundbot20191226/dist/models/CreateBatchRepeatJobResponseBody.js"(exports2) {
    "use strict";
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    }) : (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      o[k2] = m[k];
    }));
    var __setModuleDefault = exports2 && exports2.__setModuleDefault || (Object.create ? (function(o, v) {
      Object.defineProperty(o, "default", { enumerable: true, value: v });
    }) : function(o, v) {
      o["default"] = v;
    });
    var __importStar = exports2 && exports2.__importStar || /* @__PURE__ */ (function() {
      var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function(o2) {
          var ar = [];
          for (var k in o2) if (Object.prototype.hasOwnProperty.call(o2, k)) ar[ar.length] = k;
          return ar;
        };
        return ownKeys(o);
      };
      return function(mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) {
          for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        }
        __setModuleDefault(result, mod);
        return result;
      };
    })();
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.CreateBatchRepeatJobResponseBody = exports2.CreateBatchRepeatJobResponseBodyJobGroup = void 0;
    var $dara2 = __importStar(require_dist());
    var CreateBatchRepeatJobResponseBodyJobGroup = class extends $dara2.Model {
      static names() {
        return {
          id: "Id",
          minConcurrency: "MinConcurrency",
          priority: "Priority",
          ringingDuration: "RingingDuration"
        };
      }
      static types() {
        return {
          id: "string",
          minConcurrency: "number",
          priority: "string",
          ringingDuration: "number"
        };
      }
      validate() {
        super.validate();
      }
      constructor(map) {
        super(map);
      }
    };
    exports2.CreateBatchRepeatJobResponseBodyJobGroup = CreateBatchRepeatJobResponseBodyJobGroup;
    var CreateBatchRepeatJobResponseBody = class extends $dara2.Model {
      static names() {
        return {
          code: "Code",
          httpStatusCode: "HttpStatusCode",
          jobGroup: "JobGroup",
          message: "Message",
          requestId: "RequestId",
          success: "Success"
        };
      }
      static types() {
        return {
          code: "string",
          httpStatusCode: "number",
          jobGroup: CreateBatchRepeatJobResponseBodyJobGroup,
          message: "string",
          requestId: "string",
          success: "boolean"
        };
      }
      validate() {
        if (this.jobGroup && typeof this.jobGroup.validate === "function") {
          this.jobGroup.validate();
        }
        super.validate();
      }
      constructor(map) {
        super(map);
      }
    };
    exports2.CreateBatchRepeatJobResponseBody = CreateBatchRepeatJobResponseBody;
  }
});

// node_modules/@alicloud/outboundbot20191226/dist/models/CreateBeebotIntentRequest.js
var require_CreateBeebotIntentRequest = __commonJS({
  "node_modules/@alicloud/outboundbot20191226/dist/models/CreateBeebotIntentRequest.js"(exports2) {
    "use strict";
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    }) : (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      o[k2] = m[k];
    }));
    var __setModuleDefault = exports2 && exports2.__setModuleDefault || (Object.create ? (function(o, v) {
      Object.defineProperty(o, "default", { enumerable: true, value: v });
    }) : function(o, v) {
      o["default"] = v;
    });
    var __importStar = exports2 && exports2.__importStar || /* @__PURE__ */ (function() {
      var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function(o2) {
          var ar = [];
          for (var k in o2) if (Object.prototype.hasOwnProperty.call(o2, k)) ar[ar.length] = k;
          return ar;
        };
        return ownKeys(o);
      };
      return function(mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) {
          for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        }
        __setModuleDefault(result, mod);
        return result;
      };
    })();
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.CreateBeebotIntentRequest = exports2.CreateBeebotIntentRequestIntentDefinition = void 0;
    var $dara2 = __importStar(require_dist());
    var CreateBeebotIntentRequestIntentDefinition = class extends $dara2.Model {
      static names() {
        return {
          aliasName: "AliasName",
          intentName: "IntentName"
        };
      }
      static types() {
        return {
          aliasName: "string",
          intentName: "string"
        };
      }
      validate() {
        super.validate();
      }
      constructor(map) {
        super(map);
      }
    };
    exports2.CreateBeebotIntentRequestIntentDefinition = CreateBeebotIntentRequestIntentDefinition;
    var CreateBeebotIntentRequest = class extends $dara2.Model {
      static names() {
        return {
          instanceId: "InstanceId",
          intentDefinition: "IntentDefinition",
          scriptId: "ScriptId"
        };
      }
      static types() {
        return {
          instanceId: "string",
          intentDefinition: CreateBeebotIntentRequestIntentDefinition,
          scriptId: "string"
        };
      }
      validate() {
        if (this.intentDefinition && typeof this.intentDefinition.validate === "function") {
          this.intentDefinition.validate();
        }
        super.validate();
      }
      constructor(map) {
        super(map);
      }
    };
    exports2.CreateBeebotIntentRequest = CreateBeebotIntentRequest;
  }
});

// node_modules/@alicloud/outboundbot20191226/dist/models/CreateBeebotIntentLgfRequest.js
var require_CreateBeebotIntentLgfRequest = __commonJS({
  "node_modules/@alicloud/outboundbot20191226/dist/models/CreateBeebotIntentLgfRequest.js"(exports2) {
    "use strict";
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    }) : (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      o[k2] = m[k];
    }));
    var __setModuleDefault = exports2 && exports2.__setModuleDefault || (Object.create ? (function(o, v) {
      Object.defineProperty(o, "default", { enumerable: true, value: v });
    }) : function(o, v) {
      o["default"] = v;
    });
    var __importStar = exports2 && exports2.__importStar || /* @__PURE__ */ (function() {
      var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function(o2) {
          var ar = [];
          for (var k in o2) if (Object.prototype.hasOwnProperty.call(o2, k)) ar[ar.length] = k;
          return ar;
        };
        return ownKeys(o);
      };
      return function(mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) {
          for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        }
        __setModuleDefault(result, mod);
        return result;
      };
    })();
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.CreateBeebotIntentLgfRequest = exports2.CreateBeebotIntentLgfRequestLgfDefinition = void 0;
    var $dara2 = __importStar(require_dist());
    var CreateBeebotIntentLgfRequestLgfDefinition = class extends $dara2.Model {
      static names() {
        return {
          intentId: "IntentId",
          ruleText: "RuleText"
        };
      }
      static types() {
        return {
          intentId: "number",
          ruleText: "string"
        };
      }
      validate() {
        super.validate();
      }
      constructor(map) {
        super(map);
      }
    };
    exports2.CreateBeebotIntentLgfRequestLgfDefinition = CreateBeebotIntentLgfRequestLgfDefinition;
    var CreateBeebotIntentLgfRequest = class extends $dara2.Model {
      static names() {
        return {
          instanceId: "InstanceId",
          lgfDefinition: "LgfDefinition",
          scriptId: "ScriptId"
        };
      }
      static types() {
        return {
          instanceId: "string",
          lgfDefinition: CreateBeebotIntentLgfRequestLgfDefinition,
          scriptId: "string"
        };
      }
      validate() {
        if (this.lgfDefinition && typeof this.lgfDefinition.validate === "function") {
          this.lgfDefinition.validate();
        }
        super.validate();
      }
      constructor(map) {
        super(map);
      }
    };
    exports2.CreateBeebotIntentLgfRequest = CreateBeebotIntentLgfRequest;
  }
});

// node_modules/@alicloud/outboundbot20191226/dist/models/CreateBeebotIntentUserSayRequest.js
var require_CreateBeebotIntentUserSayRequest = __commonJS({
  "node_modules/@alicloud/outboundbot20191226/dist/models/CreateBeebotIntentUserSayRequest.js"(exports2) {
    "use strict";
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    }) : (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      o[k2] = m[k];
    }));
    var __setModuleDefault = exports2 && exports2.__setModuleDefault || (Object.create ? (function(o, v) {
      Object.defineProperty(o, "default", { enumerable: true, value: v });
    }) : function(o, v) {
      o["default"] = v;
    });
    var __importStar = exports2 && exports2.__importStar || /* @__PURE__ */ (function() {
      var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function(o2) {
          var ar = [];
          for (var k in o2) if (Object.prototype.hasOwnProperty.call(o2, k)) ar[ar.length] = k;
          return ar;
        };
        return ownKeys(o);
      };
      return function(mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) {
          for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        }
        __setModuleDefault(result, mod);
        return result;
      };
    })();
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.CreateBeebotIntentUserSayRequest = exports2.CreateBeebotIntentUserSayRequestUserSayDefinition = void 0;
    var $dara2 = __importStar(require_dist());
    var CreateBeebotIntentUserSayRequestUserSayDefinition = class extends $dara2.Model {
      static names() {
        return {
          content: "Content",
          intentId: "IntentId"
        };
      }
      static types() {
        return {
          content: "string",
          intentId: "number"
        };
      }
      validate() {
        super.validate();
      }
      constructor(map) {
        super(map);
      }
    };
    exports2.CreateBeebotIntentUserSayRequestUserSayDefinition = CreateBeebotIntentUserSayRequestUserSayDefinition;
    var CreateBeebotIntentUserSayRequest = class extends $dara2.Model {
      static names() {
        return {
          instanceId: "InstanceId",
          scriptId: "ScriptId",
          userSayDefinition: "UserSayDefinition"
        };
      }
      static types() {
        return {
          instanceId: "string",
          scriptId: "string",
          userSayDefinition: CreateBeebotIntentUserSayRequestUserSayDefinition
        };
      }
      validate() {
        if (this.userSayDefinition && typeof this.userSayDefinition.validate === "function") {
          this.userSayDefinition.validate();
        }
        super.validate();
      }
      constructor(map) {
        super(map);
      }
    };
    exports2.CreateBeebotIntentUserSayRequest = CreateBeebotIntentUserSayRequest;
  }
});

// node_modules/@alicloud/outboundbot20191226/dist/models/CreateInstanceResponseBody.js
var require_CreateInstanceResponseBody = __commonJS({
  "node_modules/@alicloud/outboundbot20191226/dist/models/CreateInstanceResponseBody.js"(exports2) {
    "use strict";
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    }) : (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      o[k2] = m[k];
    }));
    var __setModuleDefault = exports2 && exports2.__setModuleDefault || (Object.create ? (function(o, v) {
      Object.defineProperty(o, "default", { enumerable: true, value: v });
    }) : function(o, v) {
      o["default"] = v;
    });
    var __importStar = exports2 && exports2.__importStar || /* @__PURE__ */ (function() {
      var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function(o2) {
          var ar = [];
          for (var k in o2) if (Object.prototype.hasOwnProperty.call(o2, k)) ar[ar.length] = k;
          return ar;
        };
        return ownKeys(o);
      };
      return function(mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) {
          for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        }
        __setModuleDefault(result, mod);
        return result;
      };
    })();
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.CreateInstanceResponseBody = exports2.CreateInstanceResponseBodyInstance = void 0;
    var $dara2 = __importStar(require_dist());
    var CreateInstanceResponseBodyInstance = class extends $dara2.Model {
      static names() {
        return {
          creationTime: "CreationTime",
          creatorId: "CreatorId",
          creatorName: "CreatorName",
          instanceDescription: "InstanceDescription",
          instanceId: "InstanceId",
          instanceName: "InstanceName",
          maxConcurrentConversation: "MaxConcurrentConversation",
          ownerName: "OwnerName",
          resourceGroupId: "ResourceGroupId"
        };
      }
      static types() {
        return {
          creationTime: "number",
          creatorId: "number",
          creatorName: "string",
          instanceDescription: "string",
          instanceId: "string",
          instanceName: "string",
          maxConcurrentConversation: "number",
          ownerName: "string",
          resourceGroupId: "string"
        };
      }
      validate() {
        super.validate();
      }
      constructor(map) {
        super(map);
      }
    };
    exports2.CreateInstanceResponseBodyInstance = CreateInstanceResponseBodyInstance;
    var CreateInstanceResponseBody = class extends $dara2.Model {
      static names() {
        return {
          code: "Code",
          httpStatusCode: "HttpStatusCode",
          instance: "Instance",
          message: "Message",
          requestId: "RequestId",
          success: "Success"
        };
      }
      static types() {
        return {
          code: "string",
          httpStatusCode: "number",
          instance: CreateInstanceResponseBodyInstance,
          message: "string",
          requestId: "string",
          success: "boolean"
        };
      }
      validate() {
        if (this.instance && typeof this.instance.validate === "function") {
          this.instance.validate();
        }
        super.validate();
      }
      constructor(map) {
        super(map);
      }
    };
    exports2.CreateInstanceResponseBody = CreateInstanceResponseBody;
  }
});

// node_modules/@alicloud/outboundbot20191226/dist/models/CreateInstanceBindNumberResponseBody.js
var require_CreateInstanceBindNumberResponseBody = __commonJS({
  "node_modules/@alicloud/outboundbot20191226/dist/models/CreateInstanceBindNumberResponseBody.js"(exports2) {
    "use strict";
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    }) : (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      o[k2] = m[k];
    }));
    var __setModuleDefault = exports2 && exports2.__setModuleDefault || (Object.create ? (function(o, v) {
      Object.defineProperty(o, "default", { enumerable: true, value: v });
    }) : function(o, v) {
      o["default"] = v;
    });
    var __importStar = exports2 && exports2.__importStar || /* @__PURE__ */ (function() {
      var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function(o2) {
          var ar = [];
          for (var k in o2) if (Object.prototype.hasOwnProperty.call(o2, k)) ar[ar.length] = k;
          return ar;
        };
        return ownKeys(o);
      };
      return function(mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) {
          for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        }
        __setModuleDefault(result, mod);
        return result;
      };
    })();
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.CreateInstanceBindNumberResponseBody = exports2.CreateInstanceBindNumberResponseBodyData = exports2.CreateInstanceBindNumberResponseBodyDataList = void 0;
    var $dara2 = __importStar(require_dist());
    var CreateInstanceBindNumberResponseBodyDataList = class extends $dara2.Model {
      static names() {
        return {
          instanceId: "InstanceId",
          success: "Success"
        };
      }
      static types() {
        return {
          instanceId: "string",
          success: "boolean"
        };
      }
      validate() {
        super.validate();
      }
      constructor(map) {
        super(map);
      }
    };
    exports2.CreateInstanceBindNumberResponseBodyDataList = CreateInstanceBindNumberResponseBodyDataList;
    var CreateInstanceBindNumberResponseBodyData = class extends $dara2.Model {
      static names() {
        return {
          list: "List"
        };
      }
      static types() {
        return {
          list: { "type": "array", "itemType": CreateInstanceBindNumberResponseBodyDataList }
        };
      }
      validate() {
        if (Array.isArray(this.list)) {
          $dara2.Model.validateArray(this.list);
        }
        super.validate();
      }
      constructor(map) {
        super(map);
      }
    };
    exports2.CreateInstanceBindNumberResponseBodyData = CreateInstanceBindNumberResponseBodyData;
    var CreateInstanceBindNumberResponseBody = class extends $dara2.Model {
      static names() {
        return {
          code: "Code",
          data: "Data",
          httpStatusCode: "HttpStatusCode",
          message: "Message",
          requestId: "RequestId",
          success: "Success"
        };
      }
      static types() {
        return {
          code: "string",
          data: CreateInstanceBindNumberResponseBodyData,
          httpStatusCode: "number",
          message: "string",
          requestId: "string",
          success: "boolean"
        };
      }
      validate() {
        if (this.data && typeof this.data.validate === "function") {
          this.data.validate();
        }
        super.validate();
      }
      constructor(map) {
        super(map);
      }
    };
    exports2.CreateInstanceBindNumberResponseBody = CreateInstanceBindNumberResponseBody;
  }
});

// node_modules/@alicloud/outboundbot20191226/dist/models/CreateJobGroupResponseBody.js
var require_CreateJobGroupResponseBody = __commonJS({
  "node_modules/@alicloud/outboundbot20191226/dist/models/CreateJobGroupResponseBody.js"(exports2) {
    "use strict";
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    }) : (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      o[k2] = m[k];
    }));
    var __setModuleDefault = exports2 && exports2.__setModuleDefault || (Object.create ? (function(o, v) {
      Object.defineProperty(o, "default", { enumerable: true, value: v });
    }) : function(o, v) {
      o["default"] = v;
    });
    var __importStar = exports2 && exports2.__importStar || /* @__PURE__ */ (function() {
      var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function(o2) {
          var ar = [];
          for (var k in o2) if (Object.prototype.hasOwnProperty.call(o2, k)) ar[ar.length] = k;
          return ar;
        };
        return ownKeys(o);
      };
      return function(mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) {
          for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        }
        __setModuleDefault(result, mod);
        return result;
      };
    })();
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.CreateJobGroupResponseBody = exports2.CreateJobGroupResponseBodyJobGroup = exports2.CreateJobGroupResponseBodyJobGroupStrategy = exports2.CreateJobGroupResponseBodyJobGroupStrategyWorkingTime = exports2.CreateJobGroupResponseBodyJobGroupRecallStrategy = exports2.CreateJobGroupResponseBodyJobGroupExportProgress = void 0;
    var $dara2 = __importStar(require_dist());
    var CreateJobGroupResponseBodyJobGroupExportProgress = class extends $dara2.Model {
      static names() {
        return {
          fileHttpUrl: "FileHttpUrl",
          progress: "Progress",
          status: "Status"
        };
      }
      static types() {
        return {
          fileHttpUrl: "string",
          progress: "string",
          status: "string"
        };
      }
      validate() {
        super.validate();
      }
      constructor(map) {
        super(map);
      }
    };
    exports2.CreateJobGroupResponseBodyJobGroupExportProgress = CreateJobGroupResponseBodyJobGroupExportProgress;
    var CreateJobGroupResponseBodyJobGroupRecallStrategy = class extends $dara2.Model {
      static names() {
        return {
          emptyNumberIgnore: "EmptyNumberIgnore",
          inArrearsIgnore: "InArrearsIgnore",
          outOfServiceIgnore: "OutOfServiceIgnore"
        };
      }
      static types() {
        return {
          emptyNumberIgnore: "boolean",
          inArrearsIgnore: "boolean",
          outOfServiceIgnore: "boolean"
        };
      }
      validate() {
        super.validate();
      }
      constructor(map) {
        super(map);
      }
    };
    exports2.CreateJobGroupResponseBodyJobGroupRecallStrategy = CreateJobGroupResponseBodyJobGroupRecallStrategy;
    var CreateJobGroupResponseBodyJobGroupStrategyWorkingTime = class extends $dara2.Model {
      static names() {
        return {
          beginTime: "BeginTime",
          endTime: "EndTime"
        };
      }
      static types() {
        return {
          beginTime: "string",
          endTime: "string"
        };
      }
      validate() {
        super.validate();
      }
      constructor(map) {
        super(map);
      }
    };
    exports2.CreateJobGroupResponseBodyJobGroupStrategyWorkingTime = CreateJobGroupResponseBodyJobGroupStrategyWorkingTime;
    var CreateJobGroupResponseBodyJobGroupStrategy = class extends $dara2.Model {
      static names() {
        return {
          customized: "Customized",
          endTime: "EndTime",
          followUpStrategy: "FollowUpStrategy",
          isTemplate: "IsTemplate",
          maxAttemptsPerDay: "MaxAttemptsPerDay",
          minAttemptInterval: "MinAttemptInterval",
          repeatBy: "RepeatBy",
          repeatDays: "RepeatDays",
          routingStrategy: "RoutingStrategy",
          startTime: "StartTime",
          strategyDescription: "StrategyDescription",
          strategyId: "StrategyId",
          strategyName: "StrategyName",
          type: "Type",
          workingTime: "WorkingTime"
        };
      }
      static types() {
        return {
          customized: "string",
          endTime: "number",
          followUpStrategy: "string",
          isTemplate: "boolean",
          maxAttemptsPerDay: "number",
          minAttemptInterval: "number",
          repeatBy: "string",
          repeatDays: { "type": "array", "itemType": "string" },
          routingStrategy: "string",
          startTime: "number",
          strategyDescription: "string",
          strategyId: "string",
          strategyName: "string",
          type: "string",
          workingTime: { "type": "array", "itemType": CreateJobGroupResponseBodyJobGroupStrategyWorkingTime }
        };
      }
      validate() {
        if (Array.isArray(this.repeatDays)) {
          $dara2.Model.validateArray(this.repeatDays);
        }
        if (Array.isArray(this.workingTime)) {
          $dara2.Model.validateArray(this.workingTime);
        }
        super.validate();
      }
      constructor(map) {
        super(map);
      }
    };
    exports2.CreateJobGroupResponseBodyJobGroupStrategy = CreateJobGroupResponseBodyJobGroupStrategy;
    var CreateJobGroupResponseBodyJobGroup = class extends $dara2.Model {
      static names() {
        return {
          callingNumbers: "CallingNumbers",
          creationTime: "CreationTime",
          exportProgress: "ExportProgress",
          jobDataParsingTaskId: "JobDataParsingTaskId",
          jobFilePath: "JobFilePath",
          jobGroupDescription: "JobGroupDescription",
          jobGroupId: "JobGroupId",
          jobGroupName: "JobGroupName",
          minConcurrency: "MinConcurrency",
          modifyTime: "ModifyTime",
          priority: "Priority",
          recallCallingNumbers: "RecallCallingNumbers",
          recallStrategy: "RecallStrategy",
          ringingDuration: "RingingDuration",
          scenarioId: "ScenarioId",
          scriptName: "ScriptName",
          scriptVersion: "ScriptVersion",
          status: "Status",
          strategy: "Strategy"
        };
      }
      static types() {
        return {
          callingNumbers: { "type": "array", "itemType": "string" },
          creationTime: "number",
          exportProgress: CreateJobGroupResponseBodyJobGroupExportProgress,
          jobDataParsingTaskId: "string",
          jobFilePath: "string",
          jobGroupDescription: "string",
          jobGroupId: "string",
          jobGroupName: "string",
          minConcurrency: "number",
          modifyTime: "string",
          priority: "string",
          recallCallingNumbers: { "type": "array", "itemType": "string" },
          recallStrategy: CreateJobGroupResponseBodyJobGroupRecallStrategy,
          ringingDuration: "number",
          scenarioId: "string",
          scriptName: "string",
          scriptVersion: "string",
          status: "string",
          strategy: CreateJobGroupResponseBodyJobGroupStrategy
        };
      }
      validate() {
        if (Array.isArray(this.callingNumbers)) {
          $dara2.Model.validateArray(this.callingNumbers);
        }
        if (this.exportProgress && typeof this.exportProgress.validate === "function") {
          this.exportProgress.validate();
        }
        if (Array.isArray(this.recallCallingNumbers)) {
          $dara2.Model.validateArray(this.recallCallingNumbers);
        }
        if (this.recallStrategy && typeof this.recallStrategy.validate === "function") {
          this.recallStrategy.validate();
        }
        if (this.strategy && typeof this.strategy.validate === "function") {
          this.strategy.validate();
        }
        super.validate();
      }
      constructor(map) {
        super(map);
      }
    };
    exports2.CreateJobGroupResponseBodyJobGroup = CreateJobGroupResponseBodyJobGroup;
    var CreateJobGroupResponseBody = class extends $dara2.Model {
      static names() {
        return {
          code: "Code",
          httpStatusCode: "HttpStatusCode",
          jobGroup: "JobGroup",
          message: "Message",
          requestId: "RequestId",
          success: "Success"
        };
      }
      static types() {
        return {
          code: "string",
          httpStatusCode: "number",
          jobGroup: CreateJobGroupResponseBodyJobGroup,
          message: "string",
          requestId: "string",
          success: "boolean"
        };
      }
      validate() {
        if (this.jobGroup && typeof this.jobGroup.validate === "function") {
          this.jobGroup.validate();
        }
        super.validate();
      }
      constructor(map) {
        super(map);
      }
    };
    exports2.CreateJobGroupResponseBody = CreateJobGroupResponseBody;
  }
});

// node_modules/@alicloud/outboundbot20191226/dist/models/CreateScriptResponseBody.js
var require_CreateScriptResponseBody = __commonJS({
  "node_modules/@alicloud/outboundbot20191226/dist/models/CreateScriptResponseBody.js"(exports2) {
    "use strict";
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    }) : (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      o[k2] = m[k];
    }));
    var __setModuleDefault = exports2 && exports2.__setModuleDefault || (Object.create ? (function(o, v) {
      Object.defineProperty(o, "default", { enumerable: true, value: v });
    }) : function(o, v) {
      o["default"] = v;
    });
    var __importStar = exports2 && exports2.__importStar || /* @__PURE__ */ (function() {
      var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function(o2) {
          var ar = [];
          for (var k in o2) if (Object.prototype.hasOwnProperty.call(o2, k)) ar[ar.length] = k;
          return ar;
        };
        return ownKeys(o);
      };
      return function(mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) {
          for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        }
        __setModuleDefault(result, mod);
        return result;
      };
    })();
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.CreateScriptResponseBody = exports2.CreateScriptResponseBodyScript = void 0;
    var $dara2 = __importStar(require_dist());
    var CreateScriptResponseBodyScript = class extends $dara2.Model {
      static names() {
        return {
          debugStatus: "DebugStatus",
          industry: "Industry",
          isDebugDrafted: "IsDebugDrafted",
          isDrafted: "IsDrafted",
          nluAccessType: "NluAccessType",
          nluEngine: "NluEngine",
          scene: "Scene",
          scriptDescription: "ScriptDescription",
          scriptId: "ScriptId",
          scriptName: "ScriptName",
          status: "Status",
          updateTime: "UpdateTime"
        };
      }
      static types() {
        return {
          debugStatus: "string",
          industry: "string",
          isDebugDrafted: "boolean",
          isDrafted: "boolean",
          nluAccessType: "string",
          nluEngine: "string",
          scene: "string",
          scriptDescription: "string",
          scriptId: "string",
          scriptName: "string",
          status: "string",
          updateTime: "number"
        };
      }
      validate() {
        super.validate();
      }
      constructor(map) {
        super(map);
      }
    };
    exports2.CreateScriptResponseBodyScript = CreateScriptResponseBodyScript;
    var CreateScriptResponseBody = class extends $dara2.Model {
      static names() {
        return {
          code: "Code",
          httpStatusCode: "HttpStatusCode",
          message: "Message",
          requestId: "RequestId",
          script: "Script",
          success: "Success"
        };
      }
      static types() {
        return {
          code: "string",
          httpStatusCode: "number",
          message: "string",
          requestId: "string",
          script: CreateScriptResponseBodyScript,
          success: "boolean"
        };
      }
      validate() {
        if (this.script && typeof this.script.validate === "function") {
          this.script.validate();
        }
        super.validate();
      }
      constructor(map) {
        super(map);
      }
    };
    exports2.CreateScriptResponseBody = CreateScriptResponseBody;
  }
});

// node_modules/@alicloud/outboundbot20191226/dist/models/DescribeBeebotIntentResponseBody.js
var require_DescribeBeebotIntentResponseBody = __commonJS({
  "node_modules/@alicloud/outboundbot20191226/dist/models/DescribeBeebotIntentResponseBody.js"(exports2) {
    "use strict";
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    }) : (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      o[k2] = m[k];
    }));
    var __setModuleDefault = exports2 && exports2.__setModuleDefault || (Object.create ? (function(o, v) {
      Object.defineProperty(o, "default", { enumerable: true, value: v });
    }) : function(o, v) {
      o["default"] = v;
    });
    var __importStar = exports2 && exports2.__importStar || /* @__PURE__ */ (function() {
      var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function(o2) {
          var ar = [];
          for (var k in o2) if (Object.prototype.hasOwnProperty.call(o2, k)) ar[ar.length] = k;
          return ar;
        };
        return ownKeys(o);
      };
      return function(mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) {
          for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        }
        __setModuleDefault(result, mod);
        return result;
      };
    })();
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.DescribeBeebotIntentResponseBody = exports2.DescribeBeebotIntentResponseBodyIntent = void 0;
    var $dara2 = __importStar(require_dist());
    var DescribeBeebotIntentResponseBodyIntent = class extends $dara2.Model {
      static names() {
        return {
          aliasName: "AliasName",
          createTime: "CreateTime",
          createUserId: "CreateUserId",
          createUserName: "CreateUserName",
          intentId: "IntentId",
          intentName: "IntentName",
          modifyTime: "ModifyTime",
          modifyUserId: "ModifyUserId",
          modifyUserName: "ModifyUserName"
        };
      }
      static types() {
        return {
          aliasName: "string",
          createTime: "string",
          createUserId: "string",
          createUserName: "string",
          intentId: "number",
          intentName: "string",
          modifyTime: "string",
          modifyUserId: "string",
          modifyUserName: "string"
        };
      }
      validate() {
        super.validate();
      }
      constructor(map) {
        super(map);
      }
    };
    exports2.DescribeBeebotIntentResponseBodyIntent = DescribeBeebotIntentResponseBodyIntent;
    var DescribeBeebotIntentResponseBody = class extends $dara2.Model {
      static names() {
        return {
          beebotRequestId: "BeebotRequestId",
          code: "Code",
          httpStatusCode: "HttpStatusCode",
          intent: "Intent",
          intentId: "IntentId",
          message: "Message",
          requestId: "RequestId",
          success: "Success"
        };
      }
      static types() {
        return {
          beebotRequestId: "string",
          code: "string",
          httpStatusCode: "number",
          intent: DescribeBeebotIntentResponseBodyIntent,
          intentId: "number",
          message: "string",
          requestId: "string",
          success: "boolean"
        };
      }
      validate() {
        if (this.intent && typeof this.intent.validate === "function") {
          this.intent.validate();
        }
        super.validate();
      }
      constructor(map) {
        super(map);
      }
    };
    exports2.DescribeBeebotIntentResponseBody = DescribeBeebotIntentResponseBody;
  }
});

// node_modules/@alicloud/outboundbot20191226/dist/models/DescribeDialogueNodeStatisticsResponseBody.js
var require_DescribeDialogueNodeStatisticsResponseBody = __commonJS({
  "node_modules/@alicloud/outboundbot20191226/dist/models/DescribeDialogueNodeStatisticsResponseBody.js"(exports2) {
    "use strict";
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    }) : (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      o[k2] = m[k];
    }));
    var __setModuleDefault = exports2 && exports2.__setModuleDefault || (Object.create ? (function(o, v) {
      Object.defineProperty(o, "default", { enumerable: true, value: v });
    }) : function(o, v) {
      o["default"] = v;
    });
    var __importStar = exports2 && exports2.__importStar || /* @__PURE__ */ (function() {
      var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function(o2) {
          var ar = [];
          for (var k in o2) if (Object.prototype.hasOwnProperty.call(o2, k)) ar[ar.length] = k;
          return ar;
        };
        return ow