---
name: xiaohongshu-writing
version: "1.1.0"
description: "小红书爆款内容写作助手，帮助生成高点击率、**像人写**的笔记。包含去AI味检查、7种标题公式、5种开头模板、3种结尾模板、SEO优化。Use when user wants to write XiaoHongShu content, generate viral post titles, or needs help with RedNote writing. Trigger on: 写小红书笔记、小红书文案、爆款标题、种草笔记、学习日记、干货分享。"
---

# 小红书爆款写作 Skill

帮你写出高点击率、高互动、**像人写**的小红书笔记！

---

## ⚠️ 重要：去AI味检查（写之前必看）

AI生成的文本有明显特征，一眼就能看出来。写小红书笔记时，**必须避免**以下问题：

### 🚫 AI文本的16种死罪

#### 致命特征（一眼AI）
| 问题 | AI写法 | 人类写法 |
|------|--------|----------|
| 三段式结构 | "首先...其次...最后..." | 直接说事，不用套路 |
| 机械连接词 | "值得注意的是"、"综上所述"、"不难发现" | "说实话"、"其实"、"真的" |
| 空洞大词 | "赋能"、"闭环"、"数字化转型"、"智慧时代" | "帮忙"、"完整流程"、"升级" |
| 均匀段落 | 每段都差不多长 | 长短不一，有节奏感 |

#### 高频问题
| 问题 | 表现 |
|------|------|
| AI高频词 | "助力"、"彰显"、"凸显"、"焕发"、"深度剖析" |
| 修辞堆砌 | 对偶句>2个、排比句>1个、引用句>4个 |
| 技术词滥用 | 在非技术内容里用"解构"、"光谱"、"量子纠缠" |
| 标点滥用 | 破折号太多、分号太密 |

#### 风格问题
| 问题 | 表现 |
|------|------|
| 句子太规整 | 每句话结构都差不多 |
| 用词单一 | 来回就那几个词 |
| 没情绪 | 整篇都很"平"，没有喜怒哀乐 |
| 开头重复 | 每段开头都是"这个..."、"那..." |

### ✅ 人类化重写规则

```
1. 去掉"首先其次最后" → 直接说事
2. "值得注意的是" → "注意" / "说真的"
3. "综上所述" → "所以" / "总之"
4. "赋能" → "帮" / "让...更好"
5. 打破均匀段落 → 长短搭配
6. 加入个人口吻 → "我觉得"、"亲测"
7. 句子长短不一 → 有短有长
8. 适当"不完美" → 口语化、有语气词
```

---

## 🦞 小红书风格核心特征

小红书不是写作文，是**跟朋友聊天**。

### 必须做到
- ✅ **热情开场** - "姐妹们！"、"兄弟们！"、"宝子们！"
- ✅ **高密度emoji** - 但不是乱堆，要有节奏
- ✅ **短段落** - 1-3句话一段，别写长文
- ✅ **口语化** - 像说话，不像写论文
- ✅ **个人视角** - "我"、"我觉得"、"亲测"
- ✅ **情绪词** - "绝了"、"太可了"、"yyds"、"踩雷"

### 绝对禁止
- ❌ "首先、其次、最后"的三段式
- ❌ "值得注意的是"、"综上所述"
- ❌ 大段文字（超过5行就太长）
- ❌ 没有任何emoji的干文字
- ❌ 像说明书一样的列表

---

## 🚀 使用流程

### 第一步：了解需求
问用户：
1. 写什么内容？
2. 给谁看？
3. 想达到什么效果？

### 第二步：生成标题
用下面的标题公式，生成3-5个备选。

### 第三步：写正文
1. 选一个开头模板
2. 用口语化语言写内容
3. 加入emoji和情绪词
4. 短段落，有节奏

### 第四步：去AI味检查
对照上面的"AI文本16种死罪"，逐条检查并修改。

### 第五步：输出成品
- 标题（3-5个备选）
- 正文（已去AI味）
- 建议标签

---

## 🎯 爆款标题公式

### 7种高转化标题类型

#### 1. 画饼型（美好愿景）
```
公式：行动 + 美好结果
示例：
- "坚持这个习惯，皮肤好到发光"
- "学会这招，气质提升一个档次"
- "每天10分钟，30天练出马甲线"
```

#### 2. 不看会亏型（损失厌恶）
```
公式：后悔/不知道 + 核心信息
示例：
- "后悔没早知道的护肤真相"
- "90%的人都不知道的省钱技巧"
- "千万别这样洗脸，难怪皮肤越来越差"
```

#### 3. 数字型（具体可信）
```
公式：数字 + 核心内容 + 结果
示例：
- "3步搞定日常妆容，新手也能学会"
- "收藏这10个穿搭公式，一周不重样"
- "25套初秋显瘦穿搭总结"
```

#### 4. 反认知型（打破常识）
```
公式：否定词 + 常见行为 + 负面结果/真相
示例：
- "千万别这样护肤，难怪越来越差"
- "原来一直用错了，怪不得没效果"
- "你以为的护肤，其实是在伤肤"
```

#### 5. 提问型（引发好奇）
```
公式：问题 + 痛点
示例：
- "为什么你的妆容总是不持久？"
- "小个子怎么穿才显高？"
- "同样是护肤，为什么她比你白？"
```

#### 6. 参照物型（借势）
```
公式：学/跟着 + 名人/热门 + 效果
示例：
- "学白鹿的穿搭，轻松穿出女团感"
- "照着韩剧女主这样化妆，素颜也好看"
- "跟着大厂程序员学AI，3个月入门"
```

#### 7. 圈定人群型（精准定位）
```
公式：人群标签 + 必看/必做 + 核心价值
示例：
- "学生党必看的平价护肤好物"
- "新手妈妈一定要知道的育儿技巧"
- "半吊子工程师的AI学习日记"
```

### 万能标题公式

```
用户收益 + 关键词 + 解决方案

示例：
- "毛孔粗大怎么办？美容师教我这样做，效果惊人"
- "小个子穿搭｜这样搭配显高10cm"
- "AI入门难？程序员教你3个月从小白到实战"
```

### 五大品类标题公式

| 品类 | 公式 | 示例 |
|------|------|------|
| 穿搭 | 痛点/场景 + 解决方案 + 结果 | "微胖女生这样穿，显瘦20斤" |
| 美妆 | 目标人群 + 问题 + 效果词 | "黄皮必入！这支口红显白到离谱" |
| 母婴 | 目标人群 + 解决方案 + 状态词 | "新手妈妈必看，宝宝一觉睡到天亮" |
| 美食 | 场景 + 特点 + 情绪词 | "一人食晚餐｜10分钟搞定，好吃到哭" |
| 干货/知识 | 人群 + 问题 + 解决方案 | "程序员学AI｜3个月从小白到实战" |

---

## 📝 开头模板（5种）

### 1. 打招呼式（最常用）
```
像老朋友聊天一样

✅ 好的写法：
"姐妹们！今天又来分享好物了～"
"哈喽大家好，我是xx，今天想聊聊..."
"宝子们！这个必须安利给你们！"

❌ AI写法：
"大家好，今天我想和大家分享..."
```

### 2. 与我相关型（引发共鸣）
```
让读者觉得"这说的就是我"

✅ 好的写法：
"身高156，体重110，梨形身材的我，终于开窍了..."
"作为一个半吊子工程师，我踩过的坑能写本书"
"如果你也是____，那这篇一定要看！"

❌ AI写法：
"作为一个____，我想分享一下我的经验..."
```

### 3. 痛点切入型（直击要害）
```
直接点出读者的困扰

✅ 好的写法：
"你是不是也有这种情况：想学AI但不知道从哪开始？"
"皮肤暗沉、毛孔粗大？我之前也是！"
"每天加班到很晚，根本没时间运动对吧？"

❌ AI写法：
"很多人都会遇到这样的问题：____"
```

### 4. 告诫劝机型（听我的没错）
```
✅ 好的写法：
"说真的，如果你正在学AI，这几个坑千万别踩！"
"真心建议，新手学编程前先看看这篇"
"听我一句劝，别再____了"

❌ AI写法：
"以下是一些需要注意的事项..."
```

### 5. 社会热点型（蹭热度）
```
✅ 好的写法：
"最近AI特别火，作为业内人士我想说..."
"2026年了，这些技能真的要学起来"
"趁着xx的热度，来聊聊..."

❌ AI写法：
"随着xx的发展，越来越多的人开始关注..."
```

---

## 📝 结尾模板（3种）

### 1. 互动式（提升互动率）
```
"觉得有用的话，记得点赞收藏哦～"
"你们有什么好方法吗？评论区聊聊！"
"想看更多内容的记得关注我～"
"你们有没有踩过类似的坑？来聊聊"
```

### 2. 结论式（总结观点）
```
"所以啊，学AI最重要的就是____"
"总结一下，这3点是关键：..."
"最后想说，____真的很重要"
```

### 3. 行动号召式（引导转化）
```
"赶紧试试吧，效果真的很好！"
"从今天开始，一起____吧"
"别再犹豫了，现在就开始！"
```

---

## 🎨 情绪词库

### 正面情绪词（激发向往）
```
绝美 / 氛围感 / 治愈 / 太绝了 / 爱了爱了
好用到哭 / 必入 / 无限回购 / 真香
yyds / 绝绝子 / 太可了 / 拿捏了 / 巨好用
```

### 负面情绪词（制造焦虑）
```
后悔 / 踩雷 / 避坑 / 千万别 / 别再XX了
血泪教训 / 真的很坑 / 谁买谁后悔
```

### 悬念词（引发好奇）
```
竟然 / 原来如此 / 没想到 / 真相是
秘密 / 隐藏 / 不为人知 / 悄悄告诉你
```

---

## 🔍 SEO优化技巧

### 关键词布局原则

```
小红书对关键词抓取主要在：标题、开头、结尾、标签

布局方法：
1. 标题：包含1-2个核心关键词
2. 开头：出现2-3次关键词
3. 结尾：出现1-2次关键词 + 话题标签
4. 标签：3-5个相关话题

注意：不要堆砌关键词，保持自然
```

---

## 📊 不同内容类型的写作要点

### 干货分享类
```
结构：问题 → 分析 → 解决方案 → 总结
特点：实用、具体、可操作
标题：数字型 + 人群型
结尾：引导收藏
```

### 种草测评类
```
结构：痛点 → 产品介绍 → 使用体验 → 效果展示
特点：真实、有对比、有细节
标题：不看会亏型 + 参照物型
结尾：引导互动讨论
```

### 学习日记类
```
结构：背景 → 过程 → 收获/踩坑 → 下一步计划
特点：真实、有共鸣、可持续
标题：圈定人群型 + 与我相关型
结尾：邀请一起学习
```

---

## ⚠️ 避坑指南

### 内容禁忌
```
- 不要过度美化/夸大效果（如"7天瘦20斤"）
- 不要出现微信号、店铺名等导流信息
- 不要硬广植入，容易被举报
- 不要抄袭搬运，坚持原创
- AI生成内容必须标注（2026年2月新规）
```

### 标题禁忌
```
- 不要做标题党，标题与内容要一致
- 不要堆砌关键词，保持自然
- 标题字数控制在20字以内，16-18字最佳
```

---

## 📝 示例输出格式

### ❌ AI味的写法（不要这样写）

```
【标题】机器学习的三层理解

【正文】

大家好，今天我想和大家分享一下我对机器学习的理解。

首先，我想介绍一下函数层。函数层是机器学习的基础，它定义了模型的结构。

其次，损失层非常重要。它决定了我们如何衡量模型的好坏。

最后，优化层是让模型不断改进的关键。

综上所述，这三层结构帮助我们理解机器学习的本质。

【标签】#机器学习 #AI
```

### ✅ 人类化的写法（要这样写）

```
【标题备选】
1. 学ML踩了半年坑，终于悟出3层框架🧠
2. 别再背概念了！机器学习就这3层🔥
3. 半吊子工程师｜我悟了，ML其实很简单✨

【正文】

兄弟们！👋

学机器学习最痛苦的是什么？

不是数学难，是概念太多太乱！神经网络、梯度下降、损失函数...感觉每个都要学，学着学着就懵了。

我折腾了大半年，最后发现——**就3层**。

不多废话，直接说：

---

### 🧱 第一层：函数层（Model）

**模型长啥样？**

就是在找一个 **f(x)**

- 线性回归：就是 y = wx + b（高中数学对吧）
- 神经网络：就是好多 wx+b 叠在一起
- 决策树：就是一堆 if-else

别被名字吓到，本质上都是**函数**。

---

### 📉 第二层：损失层（Objective）

**怎么判断模型好不好？**

先定义单样本损失 **L**（比如分类用交叉熵，回归用MSE）

然后汇总成目标函数 **J(θ)**

**关键来了：J(θ) 决定了优化的方向！**

就像开车，你得先知道目的地在哪，才能往那边开对吧。

---

### 🎯 第三层：优化层（Optimization）

**怎么让模型越来越好？**

就是不断调整 θ，让 J(θ) 变小。

方法很多：
- 梯度下降（神经网络标配）
- 贪心分裂（决策树）
- Boosting（XGBoost、LightGBM）

说白了就是：**下山怎么走最快？**

---

### 💡 所以呢？

以后学任何新模型，就问自己3个问题：
1. f(x) 是什么？（函数层）
2. L 和 J(θ) 是什么？（损失层）
3. 怎么更新 θ？（优化层）

答上来就说明真懂了。

---

觉得有点用？点个赞呗👍

评论区聊聊你们学ML踩过什么坑，我踩过的坑能写一本书了😂

【建议标签】
#机器学习 #AI学习 #程序员日常 #学习笔记
```

---

## 🔧 写完后的检查清单

写完笔记后，逐条检查：

- [ ] 开头是不是热情的打招呼？
- [ ] 有没有用"首先其次最后"？→ 删掉
- [ ] 有没有"值得注意的是"？→ 改成"说真的"
- [ ] 段落是不是太均匀？→ 打乱节奏
- [ ] 有没有个人口吻？（"我觉得"、"亲测"）
- [ ] emoji够不够？（但不能乱堆）
- [ ] 句子长短有没有变化？
- [ ] 结尾有没有引导互动？

---

*这个 Skill 会持续更新，祝你的笔记篇篇爆款！🔥*
