# 小红书 Content Guide

## Post Structure

Every post follows this structure:

```
[Emoji] [标题]（≤20字，吸睛）

开头段（1-2句话，设置场景/痛点）

---

[Emoji] 小标题一

内容段落（短句为主，3-5行）
▸ 要点用 ▸ 符号
▸ 代码用 ``` 包裹
▸ 关键词用 **加粗**

---

[Emoji] 小标题二
...

---

💡 总结/建议段

实用建议，1-3 条，编号列出

互动问题 + CTA 👇

#标签1 #标签2 #标签3 ...（8-12个）
```

## Writing Style Rules

1. **口语化** — 像跟朋友聊天，不是写论文。用「你」不用「您」
2. **短段落** — 每段 3-5 行，手机阅读友好
3. **Emoji 引导** — 每个大标题前放 emoji，但不要满屏 emoji
4. **技术但通俗** — 有深度但能让非专家看懂。专业术语要解释
5. **真实感** — 用亲身经历、实际截图、真实数据。不要泛泛而谈
6. **互动结尾** — 最后一句用问句，引导评论

## Title Formula

好标题 = Emoji + 数字/对比/悬念 + 关键词

Examples:
- 🔥 我是AI助手，一周帮程序员干了这些活
- 📱 手机秒变AI的眼睛和手脚
- 🔐 你的AI助手正在被投毒？
- 🧩 5分钟写一个AI能力包
- ⚡ 4个AI模型实测对比

## Section Separators

Use `---` between major sections. Within a section:
- ▸ for bullet points
- 1️⃣ 2️⃣ 3️⃣ for ordered steps
- **Bold** for key terms
- \`code\` for inline code
- ``` for code blocks (keep short, ≤5 lines if possible)

## Hashtag Strategy

Place at the very end. Include:
- 2-3 broad tags (#AI助手 #效率工具 #自动化)
- 2-3 product tags (#OpenClaw #ClaudeCode etc.)
- 2-3 topic-specific tags (related to the post content)
- 1-2 audience tags (#程序员 #开发者)

## Content Length

- Ideal: 800-1500 字
- Minimum: 500 字
- Maximum: 2000 字 (小红书 truncates long posts)

## Cover Image Text

Cover image should have:
- **Main title**: 2-4 大字，核心信息
- **Subtitle**: 1 行补充说明
- **Badge**: Series/brand identifier (e.g., "Day 6 | OpenClaw")
- **Feature tags**: 3-4 关键词 pills

Cover text should be different from (but related to) the post title — it's the visual hook.
