# XHS Comment Ops

本文件定义小红书评论检查与回复的标准流程，优先通知页，强调对位校验与风控节奏。

## 0. 目标与原则

- 目标：先准确检查，再按用户指令回复。
- 默认：**检查不等于自动回复**。
- 回复动作必须遵循：先对位、再输入、后发送。
- 一次默认只发 1 条（除非用户明确要求批量）。

## 1. 检查流程（默认执行）

1. 打开 `/notification`，进入「评论和@」
2. 抓取最新评论：用户名、评论文本、时间
3. 输出检查结果：
   - 新评论条数
   - 最新 3-5 条摘要
   - 高风险信号（辱骂、钓鱼、诱导外链、明显违规）
4. 等待用户确认是否回复

## 2. 通知页回复 SOP（优先）

1. 在目标通知行点击「回复」入口（不要点顶部搜索框）
2. 校验输入框 placeholder 为 `回复 <用户名>`（唯一对位凭证）
3. 输入文案（逐字输入优先）
4. 发送前再次确认 placeholder 未漂移
5. 点击红色「发送」按钮（不使用 Enter）
6. 发送后确认输入框消失/清空

## 3. 帖子内回复 SOP（降级）

适用：通知页无法回复时。

1. 打开帖子详情评论区
2. 锁定目标评论（用户名 + 评论关键片段）
3. 点击该条评论下的「回复」
4. 校验出现 `回复 <用户名>`
5. 输入并发送
6. 校验已发成功，再处理下一条

## 4. 风控与节奏

- 默认 one-send-per-turn：每轮只发送 1 条
- 连续回复间隔 8-15 秒（用户明确加速时可降到约 5 秒）
- 命中以下提示立即停止并汇报：
  - 评论过于频繁
  - 操作过快/操作频繁
  - 请稍后再试
  - 发送失败/网络异常

## 5. 长度与内容约束

- 回复建议 <= 280 字（平台约 300 字上限）
- 超长先缩写，再考虑拆分多条
- 禁止虚构个人经历
- 禁止隐性承诺（如“我后续一定整理教程”）
- 仅在用户明确要求时做额外交付承诺

## 6. 常见故障

- 误点搜索框：点击空白处收起，重新定位通知行
- 回复对象漂移：placeholder 不匹配时立刻取消重来
- 连续两次发送失败：停止自动化，转人工确认
