---
name: xiaohongshu-extract
description: Extract metadata from Xiaohongshu (XHS) share or discovery URLs by parsing window.__INITIAL_STATE__ and returning note details. Use when asked to fetch XHS page content, note metadata, video info, or engagement stats from a public XHS link.
---

# Xiaohongshu Extract

## Overview

Extract note metadata (title, desc, type, time, user, engagement, tags, video stream info) from an XHS share or discovery URL using the bundled script.

## Quick Start

Run the extractor and print JSON to stdout:

```bash
python scripts/xiaohongshu_extract.py "<xhs_url>" --pretty
```

Write JSON to a file:

```bash
python scripts/xiaohongshu_extract.py "<xhs_url>" --output /tmp/xhs_note.json
```

Output only the flattened record:

```bash
python scripts/xiaohongshu_extract.py "<xhs_url>" --flat-only --pretty
```

Write only the flattened record to a file:

```bash
python scripts/xiaohongshu_extract.py "<xhs_url>" --flat-only --output /tmp/xhs_flat.json
```

Emit errors as JSON:

```bash
python scripts/xiaohongshu_extract.py "<xhs_url>" --error-json
```

Emit errors as JSON to a file:

```bash
python scripts/xiaohongshu_extract.py "<xhs_url>" --error-json --output /tmp/xhs_error.json
```

## Workflow

1. Run `scripts/xiaohongshu_extract.py` with the user-provided URL.
2. If the script fails to find `window.__INITIAL_STATE__`, ask the user for a direct discovery URL.
3. Use the JSON output to summarize note metadata or to feed downstream analysis.

## Output Notes

The script returns a JSON object with:

- `note_id`, `title`, `desc`, `type`, `time`, `ip_location`
- `user` (nickname, user_id, avatar)
- `interact` (liked/collected/comment/share counts, plus normalized *_num values)
- `tags`
- `video` (video_id, duration, width, height, fps, size, stream_url)
- `field_mapping` (nested-to-flat field name map)
- `flat` (flattened record with normalized counts and ISO timestamp)

If the stream list is empty, `video` fields may be null or empty.

If `--flat-only` is set, only `flat` is printed. If `--error-json` is set, errors are emitted as JSON and may include `final_url` and `status_code` when available.

## Resources

### scripts/

- `scripts/xiaohongshu_extract.py` extracts note metadata from XHS share/discovery URLs.
