# X Algorithm Reference

Understanding how X ranks, filters, and distributes content.

## Engagement Signal Weights

Relative weights in ranking algorithm (Like = baseline 0.5x):

| Signal | Weight | Impact |
|--------|--------|--------|
| Like | 0.5x | Low value, easy to get |
| Reply | 13-27x | High value, shows engagement |
| Reply loop (back-and-forth) | 75x | Extremely high value |
| Quote tweet | High | Borrowed audience + engagement |
| Profile click | Medium | Curiosity signal |
| Follow | High | Long-term value signal |
| Dwell time | High | Separate metric, quality indicator |
| Block | -148x | Destroys reach (~148 likes to undo) |
| Mute | Negative | Less severe than block |
| "Not interested" | Negative | Suppresses content |
| Report | Negative | Spam/quality signal |

**Key insight:** One block undoes ~148 likes. One reply loop = 150 likes. Chasing likes is inefficient.

## Ranking Systems

### Thunder (In-Network)

Retrieves content from accounts you follow.

**Characteristics:**
- Full algorithmic consideration
- No penalty multiplier
- Primary content source
- Engagement signals matter most

### Phoenix (Out-of-Network)

Discovers content from accounts you don't follow via ML similarity search.

**Characteristics:**
- Content multiplied by weight factor (likely <1.0)
- Requires strong in-network engagement first
- Harder to break into
- Interest embeddings drive matching

**Breaking out of follower bubble:**
1. Get followers to engage first (in-network signals)
2. Quote tweets from larger accounts (borrowed audience)
3. High-value replies to viral posts (piggyback discovery)
4. Match interest embeddings of target audience

## Author Diversity Penalty

Algorithm downranks multiple posts from same author in short time:

```
multiplier = (1 - floor) × decay_factor^position + floor
```

**Effects:**
- First post: full score
- Each subsequent: exponentially reduced
- Floor prevents complete suppression

**Implications:**
- Space posts 2-4 hours apart
- Quality > quantity (each post competes with previous)
- Burst posting actively hurts reach
- Multiple replies to same thread: diminishing returns

## Dwell Time

Separate signal tracking how long users stay on your post.

**Optimization:**
- Posts worth re-reading rank higher
- Density of value > pure brevity
- Threads: each post should deliver value, not just tease
- Substantive replies > quick agreements
- Don't bury the lede, but reward reading to the end

**Dwell vs Engagement Bait:**
- Engagement bait: quick scroll-past (low dwell)
- Quality content: multiple re-reads (high dwell)
- Algorithm learns the difference

## Content Filtering

Never shown regardless of engagement:

- Duplicate posts
- Old/stale content
- Previously served content (to same user)
- Paywalled content user can't access
- Content from blocked/muted accounts
- Posts matching muted keywords

## Video Engagement

Video views only count after minimum duration threshold.

**Optimization:**
- Hook must beat the scroll
- Don't front-load all value in first second
- Reward viewers who stick around
- Minimum meaningful duration required
- Autoplay skip doesn't count

**What doesn't count:**
- Quick scroll-past
- Views below duration threshold
- Autoplay immediately skipped

## Negative Signal Impact

Negative signals undo positive signals faster than you can build them.

**Cascade effect:**
- Block → suppresses your content in blocker's network
- Multiple blocks → broader suppression signal
- "Not interested" → trains algorithm on what to avoid
- Reports → quality/spam indicator

**Avoidance:**
- No aggressive/inflammatory content without substance
- No persistent self-promotion
- No repetitive patterns
- No spam-like behavior
- No replying too frequently to same person

## Premium/Premium+ Effects

**What Premium+ provides:**
- Initial distribution boost
- Larger character limits (25,000)
- Higher visibility in replies

**What it doesn't fix:**
- Spam patterns still get flagged
- Negative signals still apply
- Quality still matters
- Author diversity penalty still applies

Premium gives you more runway, not immunity.

## Spam Detection Triggers

**Volume-based:**
- >5 replies per hour
- >15-20 total posts/replies per day
- Burst activity (10+ in 30 min)
- Multiple posts <2 hours apart

**Pattern-based:**
- Same opener across multiple posts
- Template structures reused
- Cookie-cutter replies
- Systematic engagement patterns

**Content-based:**
- Promotional language in every post
- "DM me" or contact requests
- Unnatural CTAs
- Too many links/mentions

**Result:** Shadowban, suppression, or complete filtering.

## Recovery from Flags

If flagged or shadowbanned:

1. **Stop the pattern** that triggered it
2. **Reduce volume** to safe limits (3-5 replies/hour max)
3. **Diversify content** (no repetition)
4. **Wait 2+ weeks** for signals to decay
5. **Gradually increase** activity if no issues

**Prevention > recovery:** Once flagged, harder to rebuild reach.

## Optimization Strategy

**Priority order:**
1. Avoid blocks at all costs (-148x)
2. Generate replies and reply loops (13-75x)
3. Maximize dwell time (quality content)
4. Space posts 2-4 hours apart (author diversity)
5. Stay within volume limits (spam prevention)
6. Avoid negative signals (not interested, mutes)

**Wrong strategy:**
- Chasing likes (0.5x value)
- High-volume posting (author diversity penalty + spam risk)
- Engagement bait (low dwell time)
- Repetitive patterns (spam detection)

**Right strategy:**
- Fewer, higher-quality posts
- Focus on generating replies
- Respond fast to create loops
- Optimize for dwell time
- Stay well under volume limits

## Measurement

**What matters:**
- Reply rate (not just like count)
- Reply loops (back-and-forth count)
- Profile clicks (curiosity generated)
- Follower growth rate
- Dwell time (inferred from engagement depth)

**What's misleading:**
- Like count alone (lowest-value signal)
- View count without engagement
- Follower count without engagement rate

**Track over time:**
- Engagement rate (replies/views)
- Reply loop frequency
- Negative signal rate (blocks, unfollows)
- Reach per post (views/followers)

## Algorithm Updates

X updates ranking algorithm periodically. Core principles remain:

- Engagement signals matter (replies > likes)
- Negative signals are powerful
- Quality > quantity
- Author diversity enforced
- Spam patterns detected

**Stay current:**
- Monitor X Engineering blog/account
- Test new content approaches
- Track performance changes
- Adjust strategy based on data
