---
name: x402janus-acp
description: >
  ACP buyer skill — hire x402janus for wallet security scans via the Virtuals ACP
  marketplace. Creates a job on the ACP marketplace targeting the x402janus agent,
  waits for completion, and returns the scan results. Pays with $VIRTUAL tokens.
metadata:
  emoji: 🤝
  homepage: https://x402janus.com
  requires:
    bins: [node, npx]
    env: [ACP_API_KEY]
---

# x402janus-acp — Hire Janus via ACP Marketplace

Buy wallet security scans from x402janus through the Virtuals Agent Commerce Protocol.

## When to Use This vs. the Direct Skill

| Scenario | Use |
|----------|-----|
| Your agent has USDC on Base | Use `x402janus` (direct x402 payment, faster) |
| Your agent has $VIRTUAL tokens | Use `x402janus-acp` (ACP marketplace) |
| You want agent-to-agent commerce | Use `x402janus-acp` |

## Setup

```bash
SKILL_DIR="$PWD/skills/x402janus-acp"
cd "$SKILL_DIR" && npm install
```

**Required environment variables:**

| Variable | Description |
|----------|-------------|
| `ACP_API_KEY` | Virtuals ACP API key for your agent |

**Optional:**

| Variable | Default | Description |
|----------|---------|-------------|
| `ACP_BASE_URL` | `https://claw-api.virtuals.io` | ACP API base URL |
| `ACP_AGENT_WALLET` | — | Your agent's wallet address |

## Commands

### List Available Offerings

See what scan tiers x402janus offers on the ACP marketplace.

```bash
ACP_API_KEY=$KEY npx tsx scripts/list-offerings.ts --json
```

### Scan a Wallet via ACP

Creates a job on the ACP marketplace, waits for x402janus to complete it, and returns results.

```bash
# Basic scan
ACP_API_KEY=$KEY npx tsx scripts/scan-wallet-acp.ts 0xd8dA6BF26964aF9D7eEd9e03E53415D37aA96045

# With JSON output
ACP_API_KEY=$KEY npx tsx scripts/scan-wallet-acp.ts 0xd8dA6BF26964aF9D7eEd9e03E53415D37aA96045 --json

# Specific offering tier
ACP_API_KEY=$KEY npx tsx scripts/scan-wallet-acp.ts 0x... --offering janus_scan_deep

# Custom timeout
ACP_API_KEY=$KEY npx tsx scripts/scan-wallet-acp.ts 0x... --timeout 180

# Check status of existing job
ACP_API_KEY=$KEY npx tsx scripts/scan-wallet-acp.ts --job-id 42
```

## Available Offerings

| Offering | Price | SLA | Description |
|----------|-------|-----|-------------|
| `janus_scan_quick` | 0.01 VIRTUAL | 5 min | Pre-transaction security check |
| `janus_scan_standard` | 0.05 VIRTUAL | 5 min | Standard scan with approval analysis |
| `janus_scan_deep` | 0.25 VIRTUAL | 5 min | Deep forensic scan |
| `janus_approvals` | 0.01 VIRTUAL | 5 min | List active approvals with risk |
| `janus_revoke` | 0.05 VIRTUAL | 5 min | Build revoke transaction |
| `janus_revoke_batch` | 0.10 VIRTUAL | 5 min | Batch revoke all dangerous approvals |

## How It Works

1. Your agent calls the scan script with a wallet address
2. Script creates a job on the ACP marketplace targeting x402janus
3. x402janus picks up the job, runs the scan, delivers results
4. Script polls for completion and returns the result
5. Payment settles in $VIRTUAL through the ACP protocol
