# X Post Types & Frameworks

Common post structures and frameworks for Twitter/X content generation.

## Post Type Categories

### 1. Observations
Simple commentary on what's happening.

**Structure:**
- State the observation
- Optional: Add personal reaction
- Keep it casual

**Examples:**
- "watching AI agents slowly take over social media while I'm still manually shitposting"
- "everyone's a genius in a bull market"
- "Saturday morning: check portfolio, see red, close app"

---

### 2. Hot Takes
Controversial or strong opinions designed for engagement.

**Structure:**
- Bold statement
- Optional: Brief reasoning
- Let people react

**Examples:**
- "unpopular opinion: [controversial take]"
- "[Thing] is [adjective] and nobody wants to admit it"
- "if you [x], you're [y]"

**Engagement triggers:**
- "change my mind"
- "prove me wrong"
- "controversial but true"

---

### 3. Self-Deprecating Humor
Making fun of yourself, your situation, or your decisions.

**Structure:**
- Set up expectation
- Reveal the reality
- Self-aware punchline

**Examples:**
- "me: *checks portfolio 50 times* / also me: *surprised when it's still red*"
- "hit a 40x and round tripped the entire bag / almost time to do it again"
- "my AI agent has better engagement than I do / this is fine"

**Common themes:**
- Bad trades/rugs
- Checking portfolio too much
- Missing obvious signals
- Being late to trends

---

### 4. Reaction Posts (QT)
Responding to others' tweets with commentary.

**Structure:**
- Quote the tweet
- Add your take (1-2 sentences)
- Keep it punchy

**Styles:**
- Agreement: "exactly this" / "based" / "fr"
- Disagreement: "nah" / "miss me with this"
- Sarcasm: "totally" / "sure"
- Relate: "literally me" / "just like me fr"

---

### 5. Questions
Engagement bait through curiosity.

**Structure:**
- Ask clear question
- Optional: Add context
- Make it easy to answer

**Examples:**
- "what's your biggest [x]?"
- "be honest: [scenario]"
- "fill in the blank: [prompt]"

**Engagement boosters:**
- "honest answers only"
- "no judgment"
- "be real"

---

### 6. Meta Commentary
Talking about Twitter/crypto/life itself.

**Structure:**
- Identify pattern
- Comment on it
- Usually includes irony

**Examples:**
- "crypto twitter in a nutshell: [pattern]"
- "the [group] to [outcome] pipeline"
- "nothing worse than [relatable situation]"

---

### 7. Current Events React
Fast reaction to breaking news.

**Structure:**
- Reference the event
- Add immediate take
- Keep it topical

**Speed matters:** First reactions get the most engagement.

---

### 8. Meme/Humor
Pure entertainment value.

**Structure:**
- Setup
- Punchline
- Visual if possible

**Common formats:**
- "POV: [scenario]"
- "me: [x] / also me: [y]"
- "[group] when [event]"
- Image with caption

---

## Voice Matching Rules

When generating posts in someone's voice:

1. **Length matters**: Don't make short-post people write essays
2. **Phrase naturally**: Use their actual signature words, not synonyms
3. **Topic alignment**: Stay in their wheelhouse
4. **Tone consistency**: Edgy accounts stay edgy, casual stays casual
5. **Emoji strategy**: Match their usage (heavy/moderate/minimal)
6. **Caps discipline**: If they're lowercase, stay lowercase
7. **Authenticity check**: Would someone believe they wrote this?

---

## Anti-Patterns

Things that BREAK voice matching:

❌ **Forced slang**: Using their signature phrase 5 times in one tweet
❌ **Tone shift**: Suddenly being formal when they're always casual
❌ **Length mismatch**: Writing a thread for someone who does one-liners
❌ **Topic jump**: Talking about yoga when they only tweet about crypto
❌ **Try-hard energy**: Obvious attempt to sound cool/edgy/funny
❌ **Corporate voice**: "Excited to announce" when they'd say "yo check this"
❌ **Over-explanation**: Explaining the joke ruins the joke

---

## Generation Checklist

Before finalizing a generated post:

- [ ] Length matches their average (±20 chars)
- [ ] Uses 1-2 of their signature phrases naturally
- [ ] Tone matches (humor, sarcasm, edge level)
- [ ] Topic is something they'd actually post about
- [ ] Capitalization matches their style
- [ ] Emoji usage matches (count and style)
- [ ] Punctuation matches (casual vs expressive)
- [ ] Sounds authentic (could fool someone)
- [ ] No forced elements (everything feels natural)
- [ ] Passes the "would they actually tweet this?" test

---

## Confidence Scoring

Rate generated posts 0-100:

**90-100**: Perfect match, indistinguishable from their real tweets  
**80-89**: Very strong match, minor adjustments possible  
**70-79**: Good match, clearly their voice but room for improvement  
**60-69**: Decent attempt, some elements feel off  
**Below 60**: Doesn't match their voice, needs rework

Aim for 80+ before presenting to user.
