# X/Twitter 推文收集技能

## 技能名称
`x-twitter-collector`

## 功能描述
自动收集指定 X/Twitter 用户在过去 24 小时内的所有推文（原创 + 转帖），生成包含中英双语、截图、链接和数据分析的完整报告。

## 使用场景
- 监控公众人物/企业的社交媒体动态
- 收集特定用户的推文用于分析或存档
- 生成每日/每周推文摘要报告
- 多语言团队需要了解 X 内容

## 前置条件
1. **浏览器已配置**：OpenClaw 浏览器工具可用
2. **X 账号登录**：建议登录 X 账号以获取完整内容（未登录可能有内容限制）
3. **目标用户公开**：目标 X 账号必须是公开账号

## 使用方法

### 基础用法
```
收集 @用户名 过去 24 小时的推文
```

### 完整命令示例
```
帮我收集 @elonmusk 过去 24 小时的推文，要中英双语和截图
```

```
整理 @NASA 昨天的所有推文，带链接
```

### 参数说明
| 参数 | 说明 | 默认值 |
|------|------|--------|
| `@用户名` | X 账号用户名（不含 @ 也可） | 必填 |
| `时间范围` | 过去多少小时的内容 | 24 小时 |
| `语言` | 报告语言 | 中英双语 |
| `截图` | 是否包含页面截图 | 是 |
| `链接` | 是否包含推文直链 | 是 |

## 输出内容

### 报告结构
1. **数据概览** - 推文数量统计表格
2. **原创推文** - 每条包含：
   - 中英双语对照表格
   - 发布时间和内容
   - 互动数据（回复/转帖/点赞/浏览）
   - 推文直链
3. **转帖列表** - 表格形式展示
4. **主题分析** - 按内容分类统计
5. **数据汇总** - 总计数据
6. **页面截图** - 完整长截图

### 输出格式
- Markdown 格式，支持表格和中英对照
- 截图以附件形式提供
- 所有推文链接可点击跳转

## 操作流程

### 步骤 1: 打开浏览器
```javascript
browser.start({ profile: "openclaw" })
```

### 步骤 2: 访问用户主页
```javascript
browser.open({ 
  profile: "openclaw", 
  targetUrl: "https://x.com/{username}" 
})
```

### 步骤 3: 等待页面加载
```javascript
browser.act({ 
  profile: "openclaw",
  request: { kind: "wait", timeMs: 5000 },
  targetId: "{targetId}"
})
```

### 步骤 4: 获取页面快照
```javascript
browser.snapshot({ 
  profile: "openclaw", 
  refs: "aria", 
  targetId: "{targetId}" 
})
```

### 步骤 5: 滚动加载更多内容
```javascript
browser.act({ 
  profile: "openclaw",
  request: { kind: "evaluate", fn: "window.scrollTo(0, document.body.scrollHeight)" },
  targetId: "{targetId}"
})
```

### 步骤 6: 获取页面截图
```javascript
browser.screenshot({ 
  profile: "openclaw", 
  fullPage: true, 
  targetId: "{targetId}",
  type: "png"
})
```

### 步骤 7: 解析和整理数据
从快照中提取：
- 推文内容（中英文）
- 发布时间
- 互动数据
- 推文链接
- 区分原创/转帖

### 步骤 8: 生成报告
按照预设模板生成完整的中英双语报告。

## 数据解析规则

### 原创推文识别
- 不包含 "已转帖" / "Retweeted" 标识
- 用户头像和名称直接显示

### 转帖识别
- 包含 "已转帖" / "Retweeted" 标识
- 显示原始推文作者

### 时间解析
- "X 小时前" → 过去 X 小时
- "XX 月 XX 日" → 具体日期
- "202X 年 X 月 X 日" → 具体日期

### 互动数据解析
- 回复数：💬 或 "回复"
- 转帖数：🔄 或 "转帖"
- 点赞数：❤️ 或 "喜欢"
- 浏览数：👁️ 或 "次浏览"

## 注意事项

### 内容限制
- X.com 对未登录用户有限制，建议登录
- 受保护账号的内容无法访问
- 被删除的推文无法获取

### 性能优化
- 大量推文时可能需要多次滚动
- 截图文件较大，注意存储空间
- 建议定期清理 media 目录

### 隐私和合规
- 仅收集公开账号内容
- 遵守 X 平台服务条款
- 不用于商业爬虫用途

## 扩展功能

### 可添加的增强功能
1. **定时收集** - 设置 cron 定时任务
2. **多用户对比** - 同时收集多个账号对比分析
3. **情感分析** - 对推文内容进行情感分析
4. **趋势统计** - 统计推文主题趋势变化
5. **导出格式** - 支持导出为 PDF/Excel/JSON

### 自定义模板
可以根据需求修改报告模板：
- 仅中文或仅英文
- 简化版（不含截图）
- 详细版（包含引用推文的完整内容）

## 故障排除

### 常见问题

| 问题 | 原因 | 解决方案 |
|------|------|----------|
| 浏览器无法启动 | 浏览器配置问题 | 检查 `browser status` |
| 内容加载不全 | 页面未完全加载 | 增加等待时间或手动滚动 |
| 截图失败 | 内存不足 | 关闭 fullPage 或分屏截图 |
| 链接无效 | 推文已删除 | 标注为"不可用" |

### 错误处理
- 浏览器启动失败 → 提示用户检查浏览器配置
- 页面访问受限 → 提示用户登录 X 账号
- 快照解析失败 → 尝试重新加载页面

## 相关文件

- `SKILL.md` - 技能说明文档（本文件）
- `collect.sh` - 可选的命令行脚本
- `template.md` - 报告模板文件
- `config.json` - 配置文件（可选）

## 版本历史

- **v1.0** (2026-02-27) - 初始版本
  - 基础推文收集功能
  - 中英双语报告
  - 页面截图支持
  - 数据分析表格

## 作者
Generated for OpenClaw workspace

## 许可证
遵循 OpenClaw 技能许可协议
