# X/Twitter 推文收集器 - 快速使用指南

## 🚀 快速开始

### 最简单的用法
```
收集 @用户名 的推文
```

**示例：**
```
收集 @elonmusk 的推文
帮我看看 @NASA 昨天发了什么
整理 @OpenAI 最近 24 小时的推文
```

---

## 📋 完整命令格式

```
[动词] [@用户名] [时间范围] [要求]
```

### 动词选项
- 收集 / Collect
- 整理 / Summarize
- 获取 / Get
- 分析 / Analyze
- 监控 / Monitor

### 时间范围选项
- 过去 24 小时（默认）
- 昨天
- 过去 12 小时
- 过去 7 天
- 最近 48 小时

### 要求选项
- 中英双语（默认）
- 带截图
- 带链接
- 只要原创
- 只要转帖
- 详细版
- 简化版

---

## 💡 常用命令示例

### 基础用法
```bash
# 收集马斯克最近 24 小时推文
收集 @elonmusk 的推文

# 整理 NASA 昨天的推文
整理 @NASA 昨天的推文

# 获取 OpenAI 的推文（带截图）
获取 @OpenAI 的推文，要带截图
```

### 进阶用法
```bash
# 中英双语 + 截图 + 链接（完整报告）
收集 @elonmusk 过去 24 小时的推文，要中英双语、截图和链接

# 只要原创推文
收集 @Tesla 的推文，只要原创

# 简化版（不要截图）
整理 @SpaceX 的推文，简化版

# 分析推文主题
分析 @OpenAI 最近的推文主题
```

### 多用户对比
```bash
# 分别收集多个账号
收集 @elonmusk 的推文
收集 @JeffBezos 的推文
收集 @satyanadella 的推文
```

---

## 📊 输出内容说明

### 标准报告包含
✅ **数据概览** - 推文数量统计  
✅ **原创推文** - 中英双语对照  
✅ **转帖列表** - 完整链接  
✅ **互动数据** - 点赞/转帖/浏览数  
✅ **主题分析** - 内容分类统计  
✅ **页面截图** - 完整长截图  

### 可选内容
- 情感分析（需额外请求）
- 趋势图表（需额外请求）
- 导出为 PDF/Excel（需额外请求）

---

## 🔧 配置选项

编辑 `config.json` 可以自定义：

```json
{
  "report": {
    "language": "bilingual",  // 或 "chinese" / "english"
    "includeScreenshot": true,
    "includeLinks": true
  },
  "timeRange": {
    "default": "24h"  // 默认时间范围
  }
}
```

---

## ⚠️ 注意事项

### 必须条件
- ✅ X 账号已登录（建议）
- ✅ 目标账号是公开账号
- ✅ 浏览器工具可用

### 可能的问题
- ❌ 受保护账号无法访问
- ❌ 未登录可能有内容限制
- ❌ 被删除的推文无法获取

### 性能提示
- 大量推文可能需要多次滚动
- 截图文件较大（约 1-5MB）
- 建议定期清理 media 目录

---

## 🛠️ 故障排除

### 浏览器无法启动
```bash
# 检查浏览器状态
browser status

# 重启浏览器
browser stop
browser start
```

### 内容加载不全
- 等待更长时间（页面可能需要 5-10 秒加载）
- 手动要求滚动：`向下滚动页面`
- 刷新页面重试：`刷新页面`

### 截图失败
- 关闭全屏截图：`只要内容，不要截图`
- 检查磁盘空间
- 尝试分屏截图

---

## 📁 文件结构

```
skills/x-twitter-collector/
├── SKILL.md          # 技能详细说明
├── template.md       # 报告模板
├── config.json       # 配置文件
├── README.md         # 本文件（快速指南）
└── examples/         # 示例报告（可选）
```

---

## 🎯 最佳实践

### 推荐用法
1. **每日监控** - 设置定时任务收集关键账号
2. **竞品分析** - 对比多个竞品账号
3. **舆情监控** - 跟踪公众人物的发声
4. **内容归档** - 定期备份重要账号推文

### 时间选择
- **早上 9 点** - 收集前一天的内容
- **下午 6 点** - 收集当天的内容
- **避免高峰** - X 服务器高峰期可能较慢

### 报告保存
```bash
# 建议保存路径
/Users/chendongtao/.openclaw/workspace/reports/
  ├── elonmusk-2026-02-27.md
  ├── NASA-2026-02-27.md
  └── weekly-summary-2026-W09.md
```

---

## 📞 需要帮助？

如果遇到问题：
1. 查看 `SKILL.md` 详细说明
2. 检查 `config.json` 配置
3. 尝试简化命令（去掉可选参数）
4. 联系 OpenClaw 支持

---

**版本：** v1.0.0  
**更新日期：** 2026-02-27  
**作者：** OpenClaw Skills
