---
name: x-to-kindle
description: Send X/Twitter posts to Kindle for distraction-free reading. Use when user shares an X/Twitter link and wants to read it on Kindle, or asks to send a tweet/thread to their Kindle device.
---

# X to Kindle

Convert X/Twitter posts into Kindle-readable documents via email.

## Requirements

- Gmail account with App Password (or other SMTP setup)
- Kindle email address (found in Amazon account settings)

## Workflow

When user shares an X link:

1. **Extract content** via fxtwitter API:
   ```
   https://api.fxtwitter.com/status/<tweet_id>
   ```
   Extract from URL: `twitter.com/*/status/<id>` or `x.com/*/status/<id>`

2. **Format as HTML file** (save to /tmp):
   ```html
   <!DOCTYPE html>
   <html>
   <head><meta charset="UTF-8"><title>{title}</title></head>
   <body style="font-family: Georgia, serif; max-width: 600px; margin: 0 auto; padding: 20px; line-height: 1.6;">
     <h1>@{author_handle}</h1>
     <p>{tweet_text}</p>
     <p><em>{timestamp}</em></p>
     <p><a href="{original_url}">View on X</a></p>
   </body>
   </html>
   ```

3. **Send via SMTP with HTML as ATTACHMENT** (Kindle requires attachment, not inline HTML):
   ```python
   from email.mime.multipart import MIMEMultipart
   from email.mime.text import MIMEText
   from email.mime.base import MIMEBase
   from email import encoders
   
   msg = MIMEMultipart()
   msg['Subject'] = "Tweet from @handle"
   msg['From'] = from_email
   msg['To'] = kindle_email
   
   # Plain text body (not the content)
   msg.attach(MIMEText("Article attached.", 'plain'))
   
   # HTML file as attachment - THIS IS REQUIRED
   with open("/tmp/article.html", "rb") as f:
       attachment = MIMEBase('text', 'html')
       attachment.set_payload(f.read())
       encoders.encode_base64(attachment)
       attachment.add_header('Content-Disposition', 'attachment', filename='article.html')
       msg.attach(attachment)
   ```

## Tools
- `send_to_kindle`: Send a local file to the configured Kindle email.

## Configuration

Set the following environment variables in your Clawdbot configuration (or `.env` file):

- `SMTP_EMAIL`: Your sender email (e.g., gmail)
- `SMTP_PASSWORD`: Your app password
- `KINDLE_EMAIL`: Your Kindle email address
- `SMTP_SERVER`: (Optional) Default: smtp.gmail.com
- `SMTP_PORT`: (Optional) Default: 587

## Tool Definitions

### send_to_kindle
Send a local file (PDF, HTML, TXT) to the Kindle.
- **Run:** `python3 skills/x-to-kindle/send_to_kindle.py <file_path>`


## Configuration

Store in TOOLS.md:
```markdown
## Kindle
- Address: user@kindle.com

## Email (Gmail SMTP)
- From: your@gmail.com
- App Password: xxxx xxxx xxxx xxxx
- Host: smtp.gmail.com
- Port: 587
```

## Example

User sends: `https://x.com/elonmusk/status/1234567890`

1. Fetch `https://api.fxtwitter.com/status/1234567890`
2. Extract author, text, timestamp
3. Send HTML email to Kindle address
4. Confirm: "Sent to Kindle 📚"
