# x-reader\n\nUniversal content reader — fetch, transcribe, and digest content from any platform.\n\n## Trigger\n\nWhen user sends content (URL, text, or transcript) with analysis intent:\n- 「analyze [URL]》\n- "Analyze this article"\n- "What are the key takeaways?"\n- Auto-triggered after video/podcast transcription (from video skill)\n\n## Pipeline\n\n### Step 1: Get Content\n\nChoose tool based on input type:\n\n| Input | Tool |\n|-------|------|\n| Tweet URL |  or Jina Reader |\n| Web URL |  or Jina Reader |\n| Local file | Read file directly |\n| Transcript from video skill | Use directly |\n\n### Step 2: Multi-Dimensional Analysis\n\nScan content across these dimensions. Only output dimensions with actual content — skip empty ones.\n\n\n\n### Step 3: Personalized Relevance (Customizable)\n\nMap insights to YOUR context. Edit the dimensions below to match your own projects, interests, and systems.\n\n\n\n> **Customization**: Edit the dimensions in Step 2 and Step 3 to match your own\n> domain. A trader might add "Market Impact" and "Risk Assessment". A developer\n> might add "Architecture Patterns" and "Tech Debt". Make it yours.\n\n## Output Modes\n\n| Mode | Trigger | Output |\n|------|---------|--------|\n| **Full** (default) |  | All dimensions |\n| **Sparse** |  | Only hit dimensions, skip empty |\n| **Brief** |  | Action items only |\n\n## Best Practices\n\n1. **Scan all dimensions, but don't force-fill** — skip empty dimensions cleanly\n2. **Actions must be specific** — not "learn about X" but "read X docs chapter Y"\n3. **Distinguish fact from opinion** — mark the author's claims vs verified facts\n4. **Source everything** — tag where each insight comes from in the original content\n5. **ROI awareness** — not every action is worth doing, assess effort vs impact\n\n## Supported Platforms\n\n| Platform | Text Fetch | Video/Audio Transcript |\n|----------|-----------|----------------------|\n| YouTube | ✅ Jina | ✅ yt-dlp subtitles → Groq Whisper fallback |\n| Bilibili (B屏) | ✅ API | ✅ via Claude Code skill |\n| X / Twitter | ✅ Jina → Playwright | — |\n| WeChat (微信公众号) | ✅ Jina → Playwright | — |\n| Xiaohongshu (小红书) | ✅ Jina → Playwright* | — |\n| Telegram | ✅ Telethon | — |\n| RSS | ✅ feedparser | — |\n| 小宇舟 (Xiaoyuzhou) | — | ✅ via Claude Code skill |\n| Apple Podcasts | — | ✅ via Claude Code skill |\n| Any web page | ✅ Jina fallback | — |\n\n> \*XHS requires a one-time login:  (saves session for Playwright fallback)\n>\n> YouTube Whisper transcription requires  — get a free key from [Groq](https://console.groq.com/keys)\n\n## Dependencies\n\n-  Python package (provides core content fetching)\n- Optional:  for Whisper transcription\n- Optional:  +  for Telegram support\n- Optional: Playwright for browser-based scraping\n\n## Source & Issues\n\n- **Source:** https://github.com/runesleo/x-reader\n- **Issues:** https://github.com/runesleo/x-reader/issues\n- **Author:** [@runes_leo](https://x.com/runes_leo)
