---
name: x-monitor
description: Monitor specific X/Twitter accounts and surface noteworthy tweets on a configurable schedule. Filters for high-value content about technology and trends, excluding political rage bait. Use when user wants to manage their X account list, run a manual check, or update filtering criteria.
---

# X Monitor

Automated Twitter/X monitoring with intelligent filtering for high-value content.

## Setup

### 1. X API Credentials

Save your X API credentials to `~/.openclaw/workspace/x-monitor/credentials.json`:

```json
{
  "bearer_token": "YOUR_BEARER_TOKEN_HERE"
}
```

### 2. Handles to Monitor

Configure accounts in `~/.openclaw/workspace/x-monitor/handles.json`:

```json
{
  "handles": [
    "naval",
    "paul_graham",
    "balajis",
    "vitalikbuterin"
  ]
}
```

**Limit:** 10-20 handles recommended for API quota management.

### 3. Schedule Configuration

Configure check frequency in `~/.openclaw/workspace/skills/x-monitor/config/schedule.json`:

```json
{
  "timezone": "America/Los_Angeles",
  "check_times": ["08:00", "12:00", "16:00", "20:00"],
  "enabled": true
}
```

**Options:**
- `timezone`: IANA timezone string (e.g., "America/New_York", "Europe/London", "Asia/Tokyo")
- `check_times`: Array of 24-hour times for daily checks (e.g., ["09:00", "18:00"] for twice daily)
- `enabled`: Set to false to pause scheduled checks

**Common schedules:**
- 4x daily (default): `["08:00", "12:00", "16:00", "20:00"]`
- 3x daily: `["09:00", "14:00", "20:00"]`
- 2x daily: `["09:00", "18:00"]`
- 1x daily: `["09:00"]`

### 4. Setup Cron Jobs

After configuring your schedule, ask the agent to set up the cron jobs:
- "set up x monitor cron jobs" — creates cron jobs based on your schedule.json
- "update x monitor schedule" — updates cron jobs after changing schedule.json

### 5. Noteworthy Criteria

Edit `~/.openclaw/workspace/x-monitor/noteworthy-criteria.md` to customize what gets surfaced.

## Scheduled Reports

Reports run at the times specified in `config/schedule.json`. Each report includes:
1. **Executive summary** — high-level overview of noteworthy items
2. **Filtered tweets** — chronological list with author, content, metrics

## Commands

**Manage handles:**
- "add @username to x monitor" — add a new handle
- "remove @username from x monitor" — remove a handle
- "show x monitor handles" — list current handles

**Manual check:**
- "check x now" — run immediate report

**Schedule management:**
- "show x monitor schedule" — display current schedule config
- "set x monitor to check at 9am and 6pm" — update check times
- "set x monitor timezone to America/New_York" — update timezone
- "set up x monitor cron jobs" — create/update cron jobs from schedule.json

**Update criteria:**
- "show noteworthy criteria" — display current filter rules
- "update noteworthy criteria" — help edit the criteria

## What Counts as Noteworthy (Default)

**Include:**
- Insights on technology trends, AI, crypto, product design
- First-person experiences building/shipping
- Novel frameworks, metaphors, or mental models
- Data-driven observations with concrete examples
- Contrarian but well-argued takes

**Exclude:**
- Political rage bait or partisan content
- Generic motivational quotes
- Pure engagement farming

## API Details

Uses X API v2 `tweets/search/recent` endpoint:
- Max results: 10 per handle per check
- Fields: `created_at`, `public_metrics`, `author_id`, `lang`
- Expansions: `author_id` for full user info
- Query pattern: `from:{handle}`

## Storage

- **Credentials:** `~/.openclaw/workspace/x-monitor/credentials.json`
- **Handles:** `~/.openclaw/workspace/x-monitor/handles.json`
- **Schedule:** `~/.openclaw/workspace/skills/x-monitor/config/schedule.json`
- **Criteria:** `~/.openclaw/workspace/x-monitor/noteworthy-criteria.md`
- **Last check:** `~/.openclaw/workspace/x-monitor/last-check.json` (timestamp tracking)

## Cron Job Setup

When setting up cron jobs, the agent will:
1. Read `config/schedule.json` for timezone and times
2. Create isolated cron jobs using `agentTurn` payloads
3. Each job runs: fetch tweets → filter for noteworthy → deliver summary

Example cron expression for 8am in America/Los_Angeles:
```json
{
  "schedule": { "kind": "cron", "expr": "0 8 * * *", "tz": "America/Los_Angeles" },
  "payload": { "kind": "agentTurn", "message": "Run x-monitor check and report noteworthy tweets" }
}
```

## Error Handling

- Rate limits: Backs off and logs warning
- Invalid handles: Skips and reports
- API errors: Logs and continues with remaining handles
