---
name: x-manual-surf-notes
description: 手动操控浏览器（Chrome Extension Relay）在 X 首页 For You 冲浪：下滑加载、点进帖子详情、将推文内容翻译/转述成中文并去重，按“时间｜内容｜链接｜评论”追加到笔记文档。触发词：手动刷X、浏览器刷X、X冲浪、写刷帖笔记、For You。 / Manual browser-driven X (Twitter) surfing via Chrome Extension Relay: scroll the For You feed, open tweet details, translate/summarize into Chinese, dedupe, and append notes in the format Time | Content | Link | Comment.
---

# X 手动冲浪 → 中文笔记（浏览器模拟）

## 适用场景
- 用户明确要求：**不要爬取 / 不要搜索**，而是**像人一样用浏览器刷 X 首页推荐（For You）**。
- 产出：把刷到的帖子以中文记录到文档中（持续追加），并**去重**。

## 前置条件（必须满足）
- 使用 `browser` 工具，`profile="chrome"`（Chrome 扩展 relay）。
- 用户已在目标 tab 点击扩展图标，徽标 **ON**（已附加）。
- 用户已登录 X（否则 For You 没意义/内容不完整）。

## 输出文件（默认）
- 追加到：`/home/makai/.openclaw/workspace/projects/x-ai-surf/x-ai-notes.md`
- 每次追加一个批次区块：
  - 批次时间（GMT+8）
  - 来源：X Home / For You
  - 操作：下滑加载 + 点进详情
  - 条目数：N

## 工作流（低 token 版，推荐）
> 默认测试 N=5；正式刷 N>=50。

1) **聚焦 tab**：确认当前是 `https://x.com/home`。
2) **下滑加载**：滚动 1~3 次（每次 ~800-1400px），等内容加载。
3) **采样候选帖子**：从当前视窗抽取若干 `status` 链接，做 base-url 归一化（去掉 `/photo/1`、`/analytics` 等后缀）。
4) **逐条点进详情**（模拟人）：
   - 打开 status URL
   - 如有 “Show more/显示更多” 则点击展开
   - 抓取：作者、时间（datetime）、正文（含 thread 则只取主帖 + 明显的第一条自回复，别贪多）
   - 返回 Home（或直接打开下一条）
5) **中文化**：
   - 如果正文是英文：用模型生成 **一条中文转述**（不要逐字硬翻；保留关键信息、产品名、数字、链接）。
   - 如果已包含中文：可轻微润色，但别改意思。
6) **去重规则**：
   - 以 `https://x.com/<user>/status/<id>` 为唯一键；同批次、跨批次都不重复写。
   - 如果是同一事件不同人转发：允许记录，但评论要标“转述/二手”。
7) **写入文档**：追加一个批次，格式固定：

```
### 运行批次：YYYY-MM-DD HH:mm（GMT+8）
- 本批来源：浏览器模拟（X 首页 For You）
- 操作：Home → 下滑加载 → 点击帖子详情 → 采集 → 中文转述 → 去重 → 追加
- 本批条目：N

#### 条目
1) 时间：YYYY-MM-DD HH:mm:ss
   内容：@handle｜中文转述（1-3 句）
   链接：https://x.com/.../status/...
   评论：一句话判断价值/可信度/下一步跟踪

---
```

## 评论写法（强约束，省 token）
每条评论只写一句，三选一：
- **值得跟**：为什么（发布/开源/论文/产品更新/一手信号）
- **待核验**：缺什么信息，下一步点哪里（引用/原文/链接）
- **噪音**：为什么噪音（梗/情绪/无细节）

## 常见坑
- X 页面频繁导航会导致 evaluate 上下文丢失：优先用 `browser.navigate` + `wait`，每条独立抓取。
- 抓正文时别把“浏览量/按钮文案”当正文；以 `article` 的主要文本为准，必要时清洗。

## 运行参数建议
- 测试：N=5
- 正式：每批 N=50~80（保证信息密度；避免无意义灌水）
