---
name: x-hot-topics-daily
description: 每日追踪并推送 X（x.com）热点话题新闻简报。用于用户要求“每天定时看 X 热点”“按指定话题抓取热门帖”“用 browser 方式监控 X 趋势”时。默认覆盖 AI、LLM、社会热点（中国/新加坡/美国）五个主题。重点输出“最低成本 know-what 版”：2 条必知 + 3 条可忽略 + 10 分钟行动，帮助用户抗 FOMO，而不是只罗列标题。
---

# X Hot Topics Daily

## 核心目标

每天按固定话题抓取 X 热帖，产出“可快速决策”的中文简报：
- 只保留信息密度高、互动高、可行动的信息
- 去掉重复话题和低质量灌水
- 强制过滤常见营销诈骗与谣言型内容（送币抽奖、评论 done、无来源爆料等）
- 默认给出“最低成本 know-what”结论，减少 FOMO

## 固定工作流

### 1) 使用 browser 打开 X

优先使用 `browser` + `profile=chrome`：
- `browser action=open profile=chrome target=host targetUrl=https://x.com/explore/tabs/for_you`

若无法连接浏览器控制服务，直接说明失败原因并提示重试，不改用无关工具链。

### 2) 按主题抓取（默认 5 个）

默认主题：`AI`、`LLM`、`中国社会热点`、`新加坡社会热点`、`美国社会热点`

建议查询页（Top）：
- AI：`https://x.com/search?q=AI%20(lang%3Aen%20OR%20lang%3Azh)&src=typed_query&f=top`
- LLM：`https://x.com/search?q=LLM%20(lang%3Aen%20OR%20lang%3Azh)&src=typed_query&f=top`
- 中国社会热点：`https://x.com/search?q=(中国%20OR%20China)%20(社会%20OR%20热点%20OR%20新闻)%20(lang%3Azh%20OR%20lang%3Aen)&src=typed_query&f=top`
- 新加坡社会热点：`https://x.com/search?q=(Singapore%20OR%20新加坡)%20(news%20OR%20breaking%20OR%20热点)%20(lang%3Aen%20OR%20lang%3Azh)&src=typed_query&f=top`
- 美国社会热点：`https://x.com/search?q=(US%20OR%20United%20States%20OR%20美国)%20(news%20OR%20breaking%20OR%20热点)%20(lang%3Aen%20OR%20lang%3Azh)&src=typed_query&f=top`

然后：
- `browser action=snapshot profile=chrome refs=aria`
- 从快照提取前排 `article` 的：作者、发布时间、正文核心句、互动量（至少 likes/views）
- 每个主题先抓 3-5 条候选，再筛到 1-2 条入选

### 3) 过滤与去重（强制）

先过滤再总结：

1. 营销诈骗与低质过滤
   - 丢弃包含以下模式的帖子：
     - `giving away` / `random winner` / `like + repost + comment done`
     - 夸张收益承诺、领奖导流、异常短链落地页
     - 无可靠来源却宣称“突发/独家”的截图搬运
     - 明显广告帖伪装成新闻或分析

2. 去重
   - 相同新闻事件跨多个主题重复出现时，只保留一次主条目
   - 其余主题写“同一事件延伸讨论”一句话即可

3. 新鲜度
   - 优先过去 24 小时内容
   - 若不足，再补充 48 小时内高价值帖并标注

4. 区域平衡（社会热点专用）
   - 中国/新加坡/美国三个区域尽量各保留 1 条有效信息
   - 若某区域有效信息不足，明确写“该区域今天有效热点较少”

### 4) 内容提炼（强制，不可只列标题）

每条入选热点必须补齐以下信息：
- 发生了什么（1 句）
- 为什么值得现在关注（1 句，强调时效/影响）
- 谁最该关心（开发者/普通公众/投资者/出行者）
- 是否可执行（给“可做/可观望/可忽略”）

写法要求：
- 不复读标题，不堆链接
- 用“结论先行”写法，最多 3 句讲透
- 面向“最低成本 know-what”

### 5) 输出格式（默认：反 FOMO 速览）

默认按下列结构输出：

```text
【X 热点追踪｜最低成本 know-what】
日期：YYYY-MM-DD (Asia/Singapore)
主题：AI / LLM / 中国社会热点 / 新加坡社会热点 / 美国社会热点

A) 今天真正要知道的（2条必知）
- [事件1]：发生了什么；为什么现在重要；你该怎么理解
- [事件2]：发生了什么；为什么现在重要；你该怎么理解

B) 你可以直接忽略的（3条）
- [噪音类型/话题1]：忽略原因
- [噪音类型/话题2]：忽略原因
- [噪音类型/话题3]：忽略原因

C) 10分钟最低成本行动
- 1) 先看：...
- 2) 再看：...
- 3) 最后判断：...

D) 风险提醒
- 今日过滤掉的疑似诈骗/低质信息类型：...
```

## 兼容输出（用户明确要求时）

若用户明确说“按旧版日报格式”，再使用旧结构：
- 今日总览
- 分主题热点
- 风险提醒
- 给 hmzo 的一句建议

## 质量标准

- 全文中文，简洁但信息完整
- 每日总条目建议 5-10 条（最终只保留最有用信息）
- 不能输出“我无法保证准确”这类空话；要给明确结论
- 信息不足时明确写“今天该主题有效热点较少”
- 社会热点优先公共影响（政策、公共安全、交通民生、重大公共事件），避免娱乐八卦
- 重点是“可读、可判断、可行动”
- 若热点质量明显偏低，必须直说“今天噪音占比高，建议降低信息摄入”

## 快速触发语句

可用以下指令触发：
- `执行 x-hot-topics-daily，抓取今天 X 上 AI/LLM/中国/新加坡/美国社会热点并推送`
- `给我今天 X 五个主题的热点新闻速览（browser方式）`
- `给我反 FOMO 版本：2条必知+3条可忽略+10分钟行动`
