# Thread Playbook

Threads are the single highest-leverage growth mechanism on X. A well-crafted thread can generate 5,000-10,000 new followers and 100,000+ impressions, compared to 0-2 followers from a typical single tweet.

---

## Thread Architecture

Every high-performing thread follows this structure:

```
Tweet 1: HOOK (stop the scroll, create curiosity)
    ↓
Tweet 2: CONTEXT (set the stage, establish credibility)
    ↓
Tweets 3-N: VALUE DELIVERY (the meat — one point per tweet)
    ↓
Tweet N+1: SUMMARY (key takeaway, tie it together)
    ↓
Final Tweet: CTA (what you want the reader to do next)
```

### Optimal Thread Length

| Length | Best For | Performance |
|--------|----------|-------------|
| 3-5 tweets | Quick insights, reactions | Good engagement, lower viral potential |
| 5-7 tweets | Tutorials, analyses | Best balance of engagement and completion rate |
| 8-12 tweets | Deep-dives, comprehensive guides | Highest viral potential, lower completion rate |
| 12+ tweets | Only for exceptional content | Risk of drop-off; use sparingly |

The sweet spot for most founders is **5-7 tweets**. Long enough to deliver substantial value, short enough to maintain attention.

---

## Hook Formulas

The hook (Tweet 1) determines 90% of your thread's performance. If it doesn't stop the scroll, nothing else matters.

### Proven Hook Types

**1. Bold Claim**
```
[Specific, surprising claim that challenges conventional wisdom]

Here's why → 🧵
```
Example: "90% of AI startups are solving the wrong problem. Here's what they're missing →"

**2. Specific Number**
```
I [did/analyzed/spent] [specific number] [thing].

Here's what I learned → 🧵
```
Example: "I analyzed 500 viral tech tweets. Here are the 7 patterns they all share →"

**3. Contrarian Take**
```
Unpopular opinion: [contrarian statement]

Before you disagree, hear me out → 🧵
```
Example: "Unpopular opinion: You don't need more followers. You need better followers."

**4. Personal Story**
```
[Specific, relatable scenario with tension]

Here's what happened → 🧵
```
Example: "Last month our main server went down during a demo with our biggest potential customer. What I did next saved the deal."

**5. Curiosity Gap**
```
[Intriguing question or statement that creates information gap]

The answer surprised me → 🧵
```
Example: "Why do some founders with 500 followers close more deals from X than others with 50K?"

**6. List Tease**
```
[N] [valuable things] that [benefit]:

↓ 🧵
```
Example: "7 developer tools I use daily that most people haven't heard of:"

**7. Before/After**
```
6 months ago: [painful state]
Today: [improved state]

Here's exactly what changed → 🧵
```

### Hook Anti-Patterns

- Starting with "Thread:" or "🧵" without a hook (no one will read further)
- Vague promises ("Great stuff coming up...")
- Too much context in the hook (save it for tweet 2)
- Hooks that over-promise and under-deliver (erodes trust)

---

## Body Tweet Guidelines

Each body tweet (tweets 2 through N) should:

1. **Make one clear point** — Don't cram multiple ideas into one tweet
2. **Be standalone-worthy** — Each tweet should make sense even if read in isolation
3. **Include a visual when possible** — Images increase dwell time and engagement (see [multimodal guide](multimodal-guide.md))
4. **Use formatting for scanability** — Line breaks, bullet points, numbered lists
5. **Build on the previous tweet** — Create a narrative flow that compels reading the next one

### Transition Techniques

Between tweets, use connective phrases:
- "But here's what most people miss:"
- "The second pattern is even more interesting:"
- "Now, this is where it gets counterintuitive:"
- "The data confirms this:"
- Use numbered points for list threads (makes position clear)

### Body Tweet Templates

**For tutorial/how-to threads:**
```
Step [N]: [Clear action]

[Brief explanation of what to do and why]

[Screenshot or code snippet]
```

**For analysis/insight threads:**
```
[Finding/Pattern N]:

[What the data/evidence shows]

[Why this matters / what it means]

[Optional: supporting image]
```

**For story threads:**
```
[Next event in the narrative]

[Key detail or dialogue that makes it vivid]

[Brief reflection or lesson from this moment]
```

---

## CTA (Final Tweet)

The final tweet converts engagement into lasting value. Options:

**For follower growth:**
```
If you found this useful:

1. Follow me @[handle] for more [topic]
2. Retweet the first tweet to help others find this
3. Bookmark the thread for reference

I write about [topic] every [frequency].
```

**For product awareness:**
```
This is exactly the problem we're solving at [Product].

[Brief product context — one sentence]

[Link in reply if they want to check it out]

Follow for more [topic] insights.
```

**For email list:**
```
I share deeper analysis like this in my weekly newsletter.

[Brief value proposition — what subscribers get]

Link to subscribe → [in first reply to this tweet]
```

**For engagement:**
```
What's your experience with [thread topic]?

Drop your thoughts below — I'll reply to everyone.
```

---

## Thread Scheduling

### Best Times to Post Threads

- **08:00-10:00 in target audience timezone** — morning focus time, people are browsing
- **Tuesday through Thursday** — highest professional engagement days
- **Avoid weekends** for professional threads (lower reach, save for lighter content)

### Preparation Timeline

| When | Action |
|------|--------|
| 2-3 days before | Draft full thread, identify visuals needed |
| Day before | Revise, prepare images, finalize |
| Morning of | Final review, post during optimal window |
| Post 30 min | Reply to every comment, retweet the hook |
| 24 hours later | Share key insight from thread as standalone tweet with link to thread |

---

## Thread Types

### 1. Tutorial Thread
**Goal**: Teach something specific and actionable
**Structure**: Hook → Steps → Summary → CTA
**Example topic**: "How to set up [X] in 10 minutes"
**Typical length**: 7-10 tweets

### 2. Analysis Thread
**Goal**: Provide unique insight or breakdown
**Structure**: Hook → Findings → Implications → CTA
**Example topic**: "I analyzed [N] [things]. Here's what the data shows."
**Typical length**: 5-8 tweets

### 3. Story Thread
**Goal**: Share a compelling narrative with a lesson
**Structure**: Hook → Setup → Conflict → Resolution → Lesson → CTA
**Example topic**: "How we almost lost our biggest customer (and what I learned)"
**Typical length**: 5-7 tweets

### 4. Resource Thread
**Goal**: Curate valuable resources for your audience
**Structure**: Hook → Resources (one per tweet) → Summary → CTA
**Example topic**: "10 tools every [role] should know about"
**Typical length**: 8-12 tweets

### 5. Contrarian Thread
**Goal**: Challenge popular thinking with evidence
**Structure**: Hook (contrarian claim) → Evidence → Reframing → What to do instead → CTA
**Example topic**: "Why [popular approach] is actually hurting your [outcome]"
**Typical length**: 5-7 tweets

### 6. Build-in-Public Thread
**Goal**: Share your journey with transparency
**Structure**: Hook (milestone/turning point) → Context → What happened → Metrics → Lessons → CTA
**Example topic**: "Month 6 of building [Product]: from 0 to [metric]"
**Typical length**: 5-8 tweets

---

## Thread Metrics

Track these to optimize future threads:

| Metric | What It Tells You |
|--------|-------------------|
| Impressions (first tweet) | Hook effectiveness |
| Engagement rate (first tweet) | Overall hook + topic appeal |
| Completion rate (last tweet impressions / first tweet impressions) | Thread quality |
| Bookmark count | Save-worthy value |
| Reply count | Conversation-worthy content |
| New followers (day of posting vs average) | Thread's growth impact |
| Quote tweets | Content worth amplifying |

**Benchmarks** (for 1K-10K follower accounts):
- Good thread: 20K+ impressions, 50+ engagements
- Great thread: 50K+ impressions, 200+ engagements
- Viral thread: 100K+ impressions, 500+ engagements, 100+ new followers

---

## Thread Repurposing

Extract maximum value from every thread:

| Source | Repurpose Into | Timing |
|--------|---------------|--------|
| Full thread | 5-7 standalone tweets (one per body tweet, rephrased) | Over the following week |
| Thread hook | Standalone tweet with different hook format | 2-3 weeks later |
| Full thread | Blog post or newsletter edition | Within 1 week |
| Thread insights | Replies to related discussions | Ongoing |
| Full thread | X Space topic | Next scheduled Space |
| Thread topic | Follow-up thread (deeper dive or part 2) | 2-4 weeks later |

---

*Thread Playbook v1.0*
