# Persona & Voice Guide

How to develop, maintain, and evolve an authentic online persona that feels human, builds recognition, and serves your goals.

---

## Why Persona Matters

People don't follow accounts. They follow people. Your persona is the answer to "Why should I pay attention to this person specifically?" in a sea of similar content.

A well-defined persona:
- Makes your content instantly recognizable (even before reading your name)
- Builds trust through consistency (people know what to expect)
- Creates emotional connection (people relate to people, not brands)
- Differentiates you from others sharing similar insights

---

## Persona Discovery Framework

Answer these questions to define your authentic persona. The key word is **authentic** — your persona should be a focused version of who you really are, not a character you play.

### Identity Questions

1. **What do you know deeply that most people don't?** (Your unique expertise)
2. **What are you building and why does it matter to you personally?** (Your mission)
3. **What's your origin story?** (How you got here — the human version, not the LinkedIn version)
4. **What opinions do you hold that are unpopular in your space?** (Your contrarian edges)
5. **What are you genuinely passionate about outside of work?** (Your dimensionality)

### Voice Questions

6. **How do you talk to smart friends about your work?** (Your natural register)
7. **What makes you laugh in your industry?** (Your humor style)
8. **How do you handle disagreement?** (Your conflict style)
9. **What are you comfortable being vulnerable about?** (Your authenticity boundaries)
10. **What would you NEVER post about?** (Your red lines)

Record your answers in [profile config](../config/profile.example.json) under the `voice` section.

---

## Voice Attributes Matrix

Rate yourself on each dimension (these become your voice guardrails):

| Attribute | Spectrum | Your Setting |
|-----------|----------|-------------|
| Technical Depth | Surface ←→ Deep | e.g., "High — I explain the 'why' behind technical decisions" |
| Humor | Serious ←→ Playful | e.g., "Moderate — self-deprecating, occasional tech memes" |
| Formality | Casual ←→ Formal | e.g., "Casual-professional — like speaking at a conference afterparty" |
| Vulnerability | Guarded ←→ Open | e.g., "Moderate — share failures and struggles, keep personal life private" |
| Boldness | Cautious ←→ Provocative | e.g., "High — willing to take contrarian positions with reasoning" |
| Warmth | Distant ←→ Approachable | e.g., "Approachable — reply to everyone, use inclusive language" |

### Voice Consistency Rules

Once you define your attributes, maintain them:

**Always do**:
- Use your natural speaking rhythm (short sentences if that's how you talk, long if that's your style)
- Maintain consistent humor level (don't suddenly become funny if you're normally serious)
- Keep technical depth consistent (don't dumb down or suddenly become academic)
- React to news/events in your characteristic way

**Never do**:
- Switch between radically different tones (confuses followers and algorithm)
- Use language that doesn't sound like you (corporate-speak if you're casual, slang if you're formal)
- Pretend to know things you don't (authenticity is the foundation)
- Copy someone else's voice (your audience will notice, and it won't feel natural)

---

## Language Mix Strategy

For bilingual or multilingual operators:

### When to Use English
- Technical content targeting international audiences
- Industry commentary and predictions
- Engaging with English-speaking thought leaders
- Thread hooks (English reaches wider audience on X)

### When to Use Native Language
- Personal reflections and emotional content (feels more authentic)
- Content targeting your home market
- Cultural references and humor that don't translate
- Community-specific discussions

### Mixing Within Posts
- Code-switching (mixing languages naturally) can be a persona differentiator
- Use it intentionally: English for technical terms, native language for emotional emphasis
- Some accounts build recognition through their specific language mix pattern
- Ensure the mix feels natural, not forced

---

## Personality Anchors

Personality anchors are recurring elements that build recognition. They're the equivalent of a signature style.

### Types of Anchors

**Recurring themes**: Topics you always come back to
- "The discovery problem in AI" (always analyzing through this lens)
- "Founder survival tactics" (always grounding advice in survival reality)

**Catchphrases or frameworks**: Distinctive language you coin
- A specific metaphor you use repeatedly
- A framework name you've created
- A way of phrasing things that's distinctively yours

**Running jokes**: Self-aware humor that loyal followers get
- A recurring complaint about a specific technology
- A running joke about your build process
- A meme format you've made your own

**Format signatures**: Consistent structural choices
- Always starting threads with a specific format
- A particular emoji usage pattern
- A consistent sign-off style

### Building Anchors

- Don't manufacture anchors — notice what naturally recurs in your content
- When something gets positive response, lean into it
- Reference your own previous content occasionally ("As I keep saying...")
- Let anchors evolve naturally — forcing them feels fake

---

## Adaptation Rules

Your core persona stays constant, but tone adapts to context:

| Context | Adaptation |
|---------|-----------|
| Technical thread | Deeper, more precise language; less humor |
| Industry hot take | More assertive, bolder claims; personality through conviction |
| Build-in-public update | More vulnerable, honest about difficulties |
| Reply to thought leader | Slightly more formal, ensure value-add is clear |
| Community question | Warmer, more inclusive, teaching mode |
| Product launch | More energetic, but still authentically you (not marketing-speak) |
| Handling criticism | Calm, curious, open to being wrong — never defensive |

---

## The "活人感" (Human Feel) Checklist

Before posting, check:

- [ ] Would I say this out loud to a smart friend? (if yes, the voice is right)
- [ ] Does this sound like ME specifically, or could any account in my space have posted this?
- [ ] Is there any personality in this post? (insight alone isn't enough — add the human layer)
- [ ] Am I being authentic, or performing? (audiences can tell the difference)
- [ ] Would I be embarrassed by this in 5 years? (authenticity ≠ recklessness)

### Signals That Your Persona Is Working

- People reply with personality (not just "great point" but genuine reactions)
- Followers reference your specific ideas/frameworks/jokes
- New followers say "I've been reading your stuff for a while" (recognition)
- People describe you in specific terms ("the person who always talks about X in a Y way")
- You get invited to Spaces, podcasts, and conversations because of your perspective

### Signals That Something's Off

- Engagement feels hollow (likes but no replies or conversations)
- You feel exhausted maintaining your online presence (you're performing, not being yourself)
- Followers are confused by inconsistent tone
- You're getting engagement but from the wrong audience
- You feel unable to share certain genuine thoughts (voice too constrained)

---

## Persona Evolution

Your persona should evolve as you grow. Schedule quarterly persona reviews:

1. **Re-read your voice attributes**: Do they still match how you naturally communicate?
2. **Check your anchors**: Which ones still resonate? Any new ones emerging?
3. **Assess audience alignment**: Is your persona attracting the right people?
4. **Update profile**: Does your bio, photo, and pinned tweet reflect who you are now?
5. **Update config**: Refresh `config/profile.json` with any evolved attributes

Evolution should be gradual, not sudden. Sharp persona pivots confuse your audience and disrupt algorithm relationship signals.

---

*Persona & Voice Guide v1.0*
