# Multimodal Content Guide

How to use images, video, diagrams, and other visual elements to make your X content more engaging, more memorable, and more human.

---

## Why Multimodal Matters

- Native video gets **~10x more distribution** than text-only posts
- Tweets with images receive **2-3x more engagement** than text-only
- Visual content increases **dwell time** (a key algorithm signal)
- Multimodal posts feel more like a real person sharing, less like a bot or corporate account
- The "活人感" (human feel) is largely created through visual authenticity

---

## Visual Types and When to Use Each

### 1. Screenshots

**When**: Showing real results, product demos, data, code output, conversations.

**Why it works**: Screenshots are inherently authentic. They prove you're not making things up. They're the visual equivalent of "show, don't tell."

**Best practices**:
- Crop to show only the relevant portion (no full desktop screenshots)
- Use device frames for product screenshots (makes them look polished)
- Annotate with arrows or highlights when drawing attention to specific areas
- Ensure text is readable on mobile (zoom in if needed)
- Dark mode screenshots perform well in tech audiences

**Types of screenshots**:
- Terminal output showing a cool result
- Product UI demonstrating a feature
- Dashboard metrics showing growth/progress
- Code snippets in an editor with syntax highlighting
- Chat/conversation screenshots (with permission)
- Error messages with your fix (educational)

### 2. Diagrams and Architecture Drawings

**When**: Explaining systems, workflows, mental models, comparisons.

**Why it works**: Complex ideas become instantly accessible. Diagrams get bookmarked (high algorithm value). They demonstrate deep understanding.

**Best practices**:
- Keep diagrams simple — 5-7 elements maximum
- Use clean, high-contrast colors (readable on both light and dark backgrounds)
- Include a brief text explanation alongside the diagram
- Hand-drawn style diagrams often feel more authentic than polished corporate diagrams
- Use tools: Excalidraw (hand-drawn style), Mermaid (code-generated), tldraw, Figma

**Diagram types**:
- Architecture diagrams (how things connect)
- Flow charts (how things work step by step)
- Comparison matrices (A vs B)
- Mental model visualizations
- Before/after illustrations

### 3. Code Snippets

**When**: Sharing technical insights, tutorials, debugging stories.

**Why it works**: Developers and technical audiences love scannable code. It's immediately actionable and bookmark-worthy.

**Best practices**:
- Use a code screenshot tool (Carbon, Ray.so, Snappify) for beautiful formatting
- Keep snippets short (10-20 lines max per image)
- Use syntax highlighting appropriate to the language
- Include brief context text above the code image
- For longer code: break into multiple images (one per concept)

### 4. Memes and Humor Images

**When**: Adding personality to industry commentary, celebrating/commiserating shared experiences, reacting to news.

**Why it works**: Memes are the lingua franca of X. They show you're part of the community, not above it. They're highly shareable.

**Best practices**:
- Use well-known meme templates that your audience will recognize
- The humor should come from the tech insight, not just the meme format
- Self-deprecating > mocking others
- Don't force it — if the humor isn't natural, skip the meme
- Create memes using: imgflip, Figma, or simple image editors
- Original memes (your own photos/screenshots turned into memes) feel more authentic

**Anti-patterns**:
- Overusing memes (dilutes your authority)
- Memes that punch down or mock specific people
- Corporate/forced humor that feels inauthentic
- Memes that only work if you explain them

### 5. Data Visualizations

**When**: Sharing research, trends, comparisons, build-in-public metrics.

**Why it works**: Data visualizations stop the scroll because they pack dense information into a glanceable format. They position you as someone who does rigorous analysis.

**Best practices**:
- Clean, minimal charts (no chartjunk)
- Clear labels and a title that states the insight, not just the topic
- Highlight the key data point or trend
- Use contrasting colors for the most important data
- Source your data (adds credibility)

### 6. Video and GIF

**When**: Product demos, quick tutorials, reactions, explainers.

**Why it works**: Native video gets the highest distribution from the algorithm. Short-form video (30-90 seconds) is particularly effective.

**Video types**:
- Screen recording with voiceover (product demo, tutorial)
- Talking head (personal takes, reactions — highest authenticity)
- Animated explainer (architecture, workflows)
- Short clips from X Spaces or podcasts

**Best practices**:
- Hook in the first 3 seconds (autoplay means no time to waste)
- Add captions/subtitles (most people watch without sound)
- Keep under 2 minutes for highest completion rate
- Native upload only (external links are penalized)
- Vertical or square format for mobile viewing

**GIF usage**:
- Reaction GIFs in replies add personality
- Short screen recordings as GIFs for quick product demos
- Use sparingly in original posts (they don't get the same algorithm boost as video)

---

## Multimodal Strategy by Content Pillar

| Content Pillar | Primary Visual | Secondary Visual |
|---------------|---------------|-----------------|
| Technical Depth | Code screenshots, diagrams | Screen recordings, data viz |
| Industry Pulse | Data visualizations, comparison diagrams | Memes, reaction images |
| Builder's Journey | Dashboard screenshots, product screenshots | Selfie/workspace photos, memes |
| Community Value | Resource screenshots, comparison tables | Polls (built-in X feature) |
| Personal Touch | Personal photos, memes | GIFs, hand-drawn sketches |

---

## The "活人感" (Human Feel) Checklist

Before posting any multimodal content, check:

- [ ] Does this feel like a real person made it, or does it look AI-generated / stock-photo / corporate?
- [ ] Would I send this in a group chat with friends? (if yes, the vibe is right)
- [ ] Is there any imperfection that makes it feel authentic? (perfect is suspicious)
- [ ] Does the visual add genuine value, or is it decoration?
- [ ] Is the tone consistent with my voice? (see [persona guide](persona-voice.md))

### Authenticity Signals
- Slightly imperfect screenshots (real workspace, real data)
- Hand-drawn or sketch-style diagrams
- Photos from your actual workspace or life
- Screenshots with your actual browser/editor/terminal
- Memes that reference your specific experience

### Red Flags (feels fake/corporate)
- Stock photos
- Over-designed graphics with gradients and drop shadows
- AI-generated images used as "real" content (obvious to most audiences)
- Perfectly polished everything (no human would be this consistent)
- Generic visuals that could belong to any account

---

## Thread Visual Strategy

Threads with images in each tweet get significantly more engagement. Plan visuals for each thread position:

| Tweet Position | Visual Strategy |
|---------------|----------------|
| Hook (Tweet 1) | Eye-catching image that creates curiosity: before/after, surprising data, or a compelling screenshot |
| Body (Tweets 2-N) | One relevant visual per tweet: diagram, code, screenshot, or data supporting that tweet's point |
| CTA (Final Tweet) | Summary image, your product screenshot, or a visual bookmark reminder |

Not every thread tweet needs an image, but aim for visuals in at least 60-70% of thread tweets.

---

## Tools Recommended

| Purpose | Tools |
|---------|-------|
| Code screenshots | Carbon (carbon.now.sh), Ray.so, Snappify |
| Diagrams | Excalidraw, tldraw, Mermaid, Figma |
| Memes | imgflip, Figma, Canva |
| Data visualization | Observable, Datawrapper, simple charting libraries |
| Screen recording | CleanShot X (macOS), OBS, Loom |
| Image editing | Figma, Canva, Preview (macOS) |
| Video editing | CapCut, Descript, iMovie |

---

*Multimodal Guide v1.0*
