# Growth Benchmarks

Industry benchmarks and realistic expectations for X account growth. Use these to calibrate your goals and assess progress.

---

## Engagement Rate Benchmarks

### By Account Size

| Follower Count | Good ER | Great ER | Exceptional ER |
|---------------|---------|----------|----------------|
| 0-500 | 2% | 5% | 10%+ |
| 500-1K | 1.5% | 3% | 7%+ |
| 1K-5K | 1% | 2.5% | 5%+ |
| 5K-10K | 0.8% | 2% | 4%+ |
| 10K-50K | 0.5% | 1.5% | 3%+ |
| 50K-100K | 0.3% | 1% | 2%+ |
| 100K+ | 0.2% | 0.7% | 1.5%+ |

**Note**: Engagement rate naturally decreases as accounts grow because larger accounts have a higher percentage of inactive or low-engagement followers. A declining ER with growing follower count is normal and expected.

### By Content Type

| Content Type | Typical ER | Notes |
|-------------|-----------|-------|
| Threads (educational) | 2-5% | Highest for accounts under 10K |
| Hot takes / contrarian | 1.5-4% | High reply rate, sometimes polarizing |
| Technical insights | 1-3% | High bookmark rate |
| Build-in-public updates | 1-3% | Strong from loyal followers |
| Questions / polls | 2-4% | High reply rate by design |
| Product announcements | 0.5-2% | Lower unless very engaged audience |
| Generic commentary | 0.2-0.5% | Avoid this content type |

---

## Follower Growth Benchmarks

### Monthly Growth Rate by Stage

| Stage | Followers | Realistic Monthly Growth | Accelerated Growth |
|-------|-----------|------------------------|--------------------|
| Cold Start | 0-100 | 20-50 new followers | 50-100 |
| Early | 100-500 | 30-80 | 80-200 |
| Building | 500-1K | 50-150 | 150-500 |
| Growth | 1K-5K | 100-500 | 500-2K |
| Scaling | 5K-10K | 200-800 | 800-3K |
| Established | 10K-50K | 500-2K | 2K-10K |

**Key insight**: Growth is non-linear. The first 1,000 followers are the hardest. After 1K, network effects and algorithm signals start compounding.

### Growth Catalysts

Events that typically cause step-function follower growth:
- Viral thread (single thread can add 1K-10K followers)
- Engagement from a very large account (reply, retweet, or quote tweet)
- Industry event or news where you provide timely, valuable commentary
- Product launch that gets organic coverage
- X Spaces with notable guests
- Being featured in a newsletter or podcast

---

## Content Performance Benchmarks

### Impressions per Post (by follower count)

| Follower Count | Low | Average | High |
|---------------|-----|---------|------|
| 0-500 | 20-50 | 50-200 | 200-1K |
| 500-1K | 50-200 | 200-500 | 500-5K |
| 1K-5K | 200-500 | 500-2K | 2K-20K |
| 5K-10K | 500-2K | 2K-5K | 5K-50K |
| 10K-50K | 1K-5K | 5K-20K | 20K-200K |

### Thread Impressions (by follower count)

Threads typically get 3-10x the impressions of single tweets:

| Follower Count | Average Thread | Great Thread | Viral Thread |
|---------------|---------------|-------------|-------------|
| 0-1K | 500-2K | 2K-10K | 10K-100K |
| 1K-10K | 2K-20K | 20K-100K | 100K-1M |
| 10K-50K | 10K-50K | 50K-500K | 500K-5M |

---

## Business Conversion Benchmarks

### X Activity → Business Outcomes

These are rough benchmarks. Actual results vary widely by industry, product, and audience:

| Metric | Typical Range | Notes |
|--------|--------------|-------|
| Profile visit → Follow rate | 10-30% | With optimized profile |
| Follower → Bio link click (ever) | 5-15% | Over lifetime of following |
| Bio link click → Signup/Subscribe | 10-30% | Depends on landing page |
| X follower → Paying customer | 0.1-1% | Over 6+ months |
| X mention → Inbound inquiry | Variable | Higher for B2B/services |

### Founder-Specific Benchmarks

| Goal | X Signals That Indicate Progress |
|------|----------------------------------|
| Brand awareness | Increasing impressions, mentions, profile visits |
| Lead generation | Bio link clicks, DM inquiries, "how did you hear about us" = X |
| Fundraising | Engagement from investor accounts, DMs from investors, meeting requests |
| Hiring | Applications mentioning your X content, DMs from candidates |
| Thought leadership | Quoted by others, invited to Spaces/podcasts, media mentions |

---

## Timeline Expectations

### From Zero to Traction

Realistic timelines (with consistent daily effort):

| Milestone | Timeline | Required Effort |
|-----------|----------|----------------|
| First 100 followers | 2-4 weeks | Daily posting + replies |
| First 500 followers | 1-3 months | Consistent posting + engagement |
| First 1,000 followers | 2-5 months | Content strategy + core circle |
| First viral thread | 1-6 months | Weekly threads + iteration |
| First inbound lead from X | 1-3 months | Product integration + value content |
| Recognized in your niche | 3-6 months | Consistent voice + quality content |
| First 5,000 followers | 6-12 months | Full operations + thread strategy |

**Important**: These assume consistent, daily effort with strategic content. Posting sporadically or without strategy will take significantly longer.

---

## How to Use These Benchmarks

1. **Set goals**: Use the benchmarks for your follower count range to set realistic targets in [goals config](../config/goals.example.json)
2. **Diagnose problems**: If you're consistently below "Low" benchmarks, something fundamental needs to change (content quality, timing, niche focus)
3. **Calibrate expectations**: Don't compare your 500-follower account to a 50K-follower account
4. **Track progress**: Weekly comparison against benchmarks shows if you're improving
5. **Celebrate wins**: If you're hitting "Great" or "Exceptional" benchmarks, your strategy is working

---

*Growth Benchmarks v1.0*
