# Engagement Playbook

Systematic community building, relationship development, and growth through genuine interaction.

---

## The Engagement Funnel

Every person on X exists somewhere on this spectrum relative to you. Your engagement strategy should move people down the funnel:

```
Stranger → Sees your content (impression)
    ↓
Lurker → Reads regularly but doesn't follow (dwell time)
    ↓
Follower → Follows, occasionally likes (passive engagement)
    ↓
Fan → Regularly engages, replies, bookmarks (active engagement)
    ↓
Advocate → Quotes, retweets, recommends you to others (amplification)
    ↓
Customer/Partner → Uses your product, invests, collaborates (conversion)
```

Different content types move people through different stages:
- **Value content** (technical, tutorials) moves strangers → lurkers → followers
- **Personality content** (humor, stories) moves followers → fans
- **Engagement content** (questions, conversations) moves fans → advocates
- **Product content** (demos, launches) moves advocates → customers

---

## Core Circle Strategy

The highest-leverage engagement tactic: identify and nurture 20-30 key accounts in your space.

### Building Your Core Circle

Configure in [watchlist](../config/watchlist.example.json). Include:

**Tier 1 — Daily Engagement (5-10 accounts)**
- Accounts with 2-10x your follower count in your niche
- Active posters who reply to comments
- People whose audience overlaps with your target audience
- Goal: build genuine reciprocal engagement

**Tier 2 — Regular Engagement (10-15 accounts)**
- Thought leaders in your space
- Peer founders/builders at a similar stage
- Industry analysts or media accounts
- Goal: become a recognized name in their reply sections

**Tier 3 — Opportunistic Engagement (5-10 accounts)**
- Investors active in your space
- Potential customers or partners
- Very large accounts where a great reply can get massive reach
- Goal: strategic visibility when the opportunity is right

### Engagement Cadence

| Tier | Frequency | Time Investment |
|------|-----------|----------------|
| Tier 1 | Daily | 15 min/day |
| Tier 2 | 3-4x per week | 10 min/day |
| Tier 3 | When opportunity arises | 5 min/day |

---

## Reply Strategy

Replies are the most powerful engagement tool. They have the highest algorithm weight, build relationships fastest, and expose you to new audiences.

### Reply Quality Framework

From best to worst:

| Level | Type | Example | Impact |
|-------|------|---------|--------|
| S | Data/Evidence | "This matches what we've seen — our data shows [specific number]" | Very high |
| A | Novel Perspective | "What if we think about this differently: [new angle]" | High |
| B | Personal Story | "I experienced exactly this when [brief relevant story]" | High |
| C | Thoughtful Question | "Curious about [specific aspect] — have you tested [alternative]?" | Medium |
| D | Agreement + Extension | "This is spot on. I'd add that [new related point]" | Medium |
| F | Empty Agreement | "So true!" / "Great point!" / "This 🔥" | Zero/Negative |

**Rules**:
- Never post Level F replies. They waste the opportunity and make you look like a bot.
- Aim for Level A-B on Tier 1 accounts (where you want relationship depth)
- Level C-D is fine for Tier 2-3 (maintain visibility without massive time investment)
- Respond within 30 minutes of the original post when possible (early replies get more visibility)

### Replying to Your Own Posts

When people reply to YOUR content:
- Reply to every comment in the first hour (signals active conversation to the algorithm)
- Be selective after the first hour (respond to quality comments, questions, and disagreements)
- Add new information in replies (makes the thread more valuable)
- Ask follow-up questions (keeps the conversation going)
- Never be defensive about disagreements — engage with curiosity

---

## Quote Tweet Strategy

Quote tweets let you amplify others' content while adding your own perspective. Use them strategically:

**When to quote tweet**:
- You have a genuine, value-adding perspective on someone else's post
- You want to signal-boost a smaller account's great content
- You're reacting to industry news with analysis
- You want to start a conversation branching from someone else's idea

**When NOT to quote tweet**:
- Just to agree (use a reply instead)
- To attack or mock (creates negative signals)
- To self-promote without adding value

**Template**:
```
[Your unique take on the quoted content]

[Why you agree/disagree, with reasoning or evidence]

[Optional: what this means for your space]
```

---

## DM Strategy

Direct messages build the deepest relationships on X. Use them intentionally, not spammily.

### When to DM

- After 3+ meaningful public interactions with someone
- When someone shows genuine interest in your work
- When you have something specific and valuable to offer them
- When they explicitly invite DMs ("DM me if...")
- When a public conversation would benefit from going private

### DM Anti-Patterns

- Cold DMs pitching your product (spam)
- Generic messages ("Hey, love your content!")
- Sending DMs before any public interaction history
- Asking for favors before building any relationship
- Copy-paste messages sent to multiple people

### DM Templates

**After good public exchanges**:
> Hey [name] — enjoyed our exchange on [topic]. I'm working on [brief, relevant context]. Would love to stay connected and swap notes on [shared interest].

**Offering genuine value**:
> [Name] — saw you're dealing with [specific challenge they mentioned]. We ran into the same thing and found [solution]. Happy to share details if useful.

**Networking for collaboration**:
> [Name] — been following your work on [specific topic]. I'm building [Product] which touches on similar themes. Would be great to compare notes sometime.

---

## X Spaces Strategy

X Spaces (live audio) build deeper relationships than text ever can.

### As a Host

- **Frequency**: Start with bi-weekly, move to weekly as audience grows
- **Format**: 30-60 min focused discussion on a specific topic
- **Guests**: Invite 2-3 speakers from your core circle or industry
- **Promotion**: Announce 2-3 days in advance, remind 1 hour before
- **Repurpose**: Record and turn into thread summaries, clips, or blog posts

### As a Participant

- Join Spaces hosted by accounts in your core circle
- Request to speak when you have a genuine contribution
- Use the chat feature to add value even if not speaking
- Follow up with speakers/hosts via DM after the Space

### Spaces Topics That Work

- Industry trends and predictions
- Technical deep-dives (e.g., "How we built X")
- Founder roundtables (shared challenges)
- Q&A sessions on your domain expertise
- Hot take debates (respectful disagreement)

---

## X Communities Strategy

X Communities are topic-specific groups that can dramatically expand your reach.

### Finding Communities

- Search for communities in your niche (X's community discovery)
- Check which communities thought leaders in your space are active in
- Look for communities with 1K-100K members (big enough for reach, small enough for visibility)

### Community Engagement Rules

- **Provide value first**: Post helpful content, answer questions, share resources
- **Follow community norms**: Each community has its own culture and rules
- **Don't cross-post everything**: Curate what you share in communities
- **Engage with other community posts**: Don't just broadcast
- **Moderate self-promotion**: Communities penalize or ban promotional accounts

---

## X Lists for Intelligence

Create private X Lists to organize your monitoring and engagement:

| List Name | Purpose | Check Frequency |
|-----------|---------|-----------------|
| Core Circle | Daily engagement targets | Daily, first thing |
| Competitors | Content strategy intelligence | 2-3x per week |
| Industry Leaders | Trend awareness, reply opportunities | Daily |
| Investors | Fundraising-relevant signals | 2-3x per week |
| Potential Customers | Pain points, buying signals | Weekly |
| Media/Press | Breaking news, PR opportunities | Daily |

### Using Lists Effectively

- Check your "Core Circle" list before your main feed (more focused engagement)
- Set notifications for key accounts (never miss their posts)
- Review "Competitors" list during weekly review for strategy insights
- Use lists to avoid the noise of the main algorithm feed

---

## Engagement Metrics to Track

### Relationship Quality Metrics

| Metric | What It Measures | How to Track |
|--------|-----------------|-------------|
| Reply rate to your posts | Content quality + community engagement | X Analytics |
| Reply-back rate from core circle | Relationship depth | Manual observation |
| DM conversations initiated | Networking effectiveness | Count weekly |
| X Spaces participations | Community involvement | Count weekly |
| Mentions by others | Organic advocacy | X Search alerts |
| Quote tweets of your content | Content worth amplifying | X Analytics |

### Health Signals

- **Healthy**: Increasing replies, more substantive conversations, DM relationships forming
- **Stagnant**: Likes without replies, same people always engaging, no new connections
- **Declining**: Fewer impressions, lower engagement rates, unfollows increasing

---

*Engagement Playbook v1.0*
