# Competitor Analysis Framework

How to systematically analyze other X accounts in your space, extract actionable insights, and adapt their successful tactics to your own voice.

---

## Purpose

Competitor analysis is not about copying. It's about:
1. Understanding what content patterns work in your niche
2. Identifying engagement formulas you can adapt
3. Finding gaps that no one else is filling
4. Calibrating your benchmarks against reality

---

## Selecting Benchmark Accounts

Choose 5-8 accounts across three categories:

### Category 1: Aspirational (2-3 accounts)
Accounts 10-100x your size in your niche. They show what's possible and what content resonates at scale.

**Selection criteria**: Same industry/topic, high engagement rate (not just follower count), content you genuinely respect.

### Category 2: Peer (2-3 accounts)
Accounts at a similar size and growth stage. They show what's realistic and what tactics work at your scale.

**Selection criteria**: Similar follower count (+/- 50%), same niche, actively growing (not dormant).

### Category 3: Emerging (1-2 accounts)
Accounts smaller than you but growing fast. They show innovative tactics and untapped angles.

**Selection criteria**: Rapid growth (50%+ monthly), novel content approaches, high engagement-to-follower ratio.

Configure these in [watchlist](../config/watchlist.example.json) under `competitors`.

---

## Analysis Framework

For each benchmark account, analyze these dimensions monthly:

### 1. Content Strategy Analysis

| Dimension | What to Track |
|-----------|--------------|
| Content pillars | What topics do they cover? What's their mix? |
| Content formats | Single tweets, threads, videos, images, polls? |
| Posting frequency | How many tweets/day? Threads/week? |
| Posting times | When do they post? What timezone do they optimize for? |
| Thread strategy | How often? What topics? What hook styles? |
| Multimodal usage | How do they use images, video, screenshots? |

### 2. Engagement Pattern Analysis

| Dimension | What to Track |
|-----------|--------------|
| Engagement rate | Total engagement / impressions for recent posts |
| Reply vs like ratio | Higher reply ratio = deeper engagement |
| Top-performing content | What gets the most engagement? Why? |
| Worst-performing content | What falls flat? What can you avoid? |
| Reply behavior | Do they reply to comments? How? What tone? |
| Community interaction | Do they engage with others' content? How often? |

### 3. Content Formula Extraction

For each benchmark account's top 3 performing posts, extract:

```
Post: [Brief description]
Performance: [Likes, Retweets, Replies, Impressions, Engagement Rate]
Format: [Single tweet / Thread / Quote tweet / Image / Video]
Structure:
  1. Hook type: [Bold claim / Question / Story / etc.]
  2. Value delivery: [How they deliver the core insight]
  3. Visual element: [What image/video/screenshot they used]
  4. CTA: [What they asked readers to do]
Why it worked: [Your analysis]
What you can adapt: [Specific takeaway for your content]
```

---

## Monthly Competitor Report Template

```markdown
# Competitor Analysis — [Month Year]

## Benchmark Accounts
- Aspirational: @account1, @account2
- Peer: @account3, @account4
- Emerging: @account5

## Key Findings

### Content Trends
- [What content types are performing well across benchmark accounts]
- [Any new formats or approaches emerging]

### Top-Performing Content (across all benchmarks)
1. [Account] — [Content description] — [Performance metrics]
   - Why it worked: [Analysis]
   - Adaptable insight: [What you can use]

2. [Account] — [Content description] — [Performance metrics]
   - Why it worked: [Analysis]
   - Adaptable insight: [What you can use]

3. [Account] — [Content description] — [Performance metrics]
   - Why it worked: [Analysis]
   - Adaptable insight: [What you can use]

### Content Gaps
- [Topics no one is covering well — opportunities for you]
- [Formats no one is using — first-mover advantage]

### Strategy Insights
- [Timing patterns worth testing]
- [Engagement tactics worth adopting]
- [Persona/voice elements worth adapting]

## Action Items for Next Month
1. [Specific tactic to test]
2. [Content angle to try]
3. [Engagement pattern to adopt]
```

---

## Competitive Intelligence Cadence

| Frequency | Action |
|-----------|--------|
| Daily | Quick scan of competitor posts via X Lists |
| Weekly | Note any standout content from competitors |
| Monthly | Full competitor analysis using framework above |
| Quarterly | Re-evaluate benchmark account selection |

---

## Rules of Engagement

- **Adapt, don't copy**: Take the formula, use your own voice and examples
- **Analyze the structure, not the content**: "Bold claim + evidence + CTA" is a formula; their specific tweet is their content
- **Stay in your lane**: Don't try to be @karpathy if you're not @karpathy. Extract the principles, apply as yourself
- **Watch for declining accounts too**: Learn what stops working
- **Don't obsess**: 30 minutes per month of analysis is enough. Spend 95% of your time creating, not watching

---

*Competitor Analysis Framework v1.0*
