#!/usr/bin/env bash
# fetch_followings_tweets.sh - 获取关注列表最新推文
# 用法: ./fetch_followings_tweets.sh [数量] [天数]
# 示例: ./fetch_followings_tweets.sh 50 3  (获取最近3天的50条推文)
# 输出: JSON 格式的推文数据

set -e

LIMIT="${1:-20}"
DAYS="${2:-1}"

# 检查环境变量
if [ -z "$AUTH_TOKEN" ] || [ -z "$CT0" ]; then
    echo '{"error": "Missing AUTH_TOKEN or CT0 environment variables"}' >&2
    exit 1
fi

# 计算时间戳（过去N天）
SINCE_TIMESTAMP=$(date -d "${DAYS} days ago" +%s 2>/dev/null || date -v-${DAYS}d +%s 2>/dev/null || echo "0")

# 获取关注列表推文
TWEETS=$(bird following --json -n "$LIMIT" 2>/dev/null)

if [ $? -ne 0 ] || [ -z "$TWEETS" ]; then
    echo '{"error": "Failed to fetch tweets"}' >&2
    exit 1
fi

# 如果指定了天数，过滤推文（简化版，bird CLI可能不支持精确时间过滤）
if [ "$DAYS" -gt 0 ]; then
    echo "{\"days\": $DAYS, \"limit\": $LIMIT, \"tweets\": $TWEETS}"
else
    echo "$TWEETS"
fi
