# X (Twitter) Automation Skill

Automate X posts via browser control - bypass $200/month API costs.

## What It Does

- **Scrape trending topics** from your personalized "For You" feed
- **Generate tweet ideas** based on trends (crypto/Web3/tech focused)
- **Schedule tweets** throughout the day for natural posting
- **Post via browser automation** - no API keys needed
- **Queue management** for approval workflows

## Why This Exists

X API pricing is insane:
- Free tier: Write-only, can't read anything
- Basic: $200/month for 15k tweets read
- Pro: $5,000/month

This skill uses browser automation instead. Zero API costs.

## Features

✅ **Trend Scraping**
- Navigates to X.com/explore
- Extracts trending topics from "For You" tab
- Saves to JSON for AI processing

✅ **Tweet Generation**
- AI generates 3-5 tweet ideas based on trends
- Customizable tone/voice
- Length optimization (150-250 chars for engagement)

✅ **Scheduled Posting**
- Space tweets throughout the day
- Human-like delays between posts
- Approval queue workflow

✅ **Browser Automation**
- Uses OpenClaw browser control
- Requires one-time login
- Session persists across runs

## Installation

```bash
cd ~/.openclaw/workspace/skills/x-automation
npm install
```

## Usage

### 1. Manual Tweet Generation

Ask your agent:
```
"Check X trends and generate 3 tweet ideas"
```

The agent will:
1. Navigate to X.com/explore
2. Scrape trending topics
3. Generate tweet ideas
4. Send to you for approval
5. Post approved tweets

### 2. Automated Posting (Cron)

Set up a cron job to run every 4 hours:

```json
{
  "schedule": { "kind": "every", "everyMs": 14400000 },
  "payload": {
    "kind": "agentTurn",
    "message": "Check X trends, generate 2-3 tweet ideas, send to Telegram for approval"
  },
  "sessionTarget": "isolated"
}
```

### 3. Direct Posting

```
"Post this tweet: <your text>"
```

## Configuration

No API keys needed! Just:

1. **Log in to X.com** in OpenClaw browser
2. **Keep browser session active** (or re-login when needed)
3. **Customize tweet voice** in your SOUL.md or prompt

## Tweet Generation Guidelines

Default focus areas (customize in your prompts):
- Crypto trends (ETH, Base L2, DeFi)
- Web3 development
- Tech commentary
- Product updates (if applicable)

Default tone:
- Direct, opinionated
- No corporate speak
- Short & punchy (150-250 chars)
- Engagement-focused

## File Structure

```
x-automation/
├── scripts/
│   ├── auto-tweet.js       # Main automation
│   ├── post.js             # Single tweet posting
│   ├── post-approved.js    # Post from queue
│   └── check-trends.js     # View current trends
├── data/                   # Created on first run
│   ├── latest-trends.json
│   ├── approved-queue.json
│   └── tweet-history.json
├── SKILL.md
├── README.md
└── package.json
```

## Safety Features

- **No auto-posting without approval** (unless you configure it)
- **Human-like delays** (30-60s between tweets)
- **Daily limits** (configurable, default 10/day)
- **Queue review** before posting

## Anti-Detection

- Uses real browser session (not headless)
- Random delays between actions
- Natural posting schedule
- Human-like mouse movements (Playwright)

## Limitations

- Requires browser to stay logged in
- Can be detected if too aggressive
- Manual login required (can't automate 2FA)

## Legal Note

This automates YOUR account via YOUR browser. You're not violating X ToS any more than using the website normally. Just don't spam.

## Pro Tips

**Optimal posting times (adjust for your timezone):**
- Morning: 9-10 AM (commute browsing)
- Lunch: 1-2 PM (break time)
- Evening: 7-9 PM (peak Twitter hours)
- Late: 11 PM-12 AM (night crew)

**Posting frequency:**
- 2-4 tweets/day is natural
- Space out by 3-4 hours minimum
- Don't post all at once

**Content strategy:**
- Comment on trends (show you're plugged in)
- Share insights (demonstrate expertise)
- Mention your product (subtle, 1 in 5 tweets)
- Engage with replies (build community)

## Examples

See `WORKFLOW.md` for detailed examples of:
- Trend scraping output
- Generated tweet samples
- Approval workflows
- Scheduling strategies

## Support

This skill is credential-free and safe to share. No API keys, no passwords, no private data.

Issues? Check:
1. Is browser logged into X?
2. Is OpenClaw browser control running?
3. Are cron jobs properly configured?

---

Built for crypto devs who refuse to pay $200/month for an API that should be free.
