---
name: x-algorithm
description: X (Twitter) algorithm rules & viral strategies for AI agents. Boost engagement, avoid reach death. Works with Cursor, Claude, ChatGPT, Copilot. Vibe-coding ready.
version: 1.0.3
author: NextFrontierBuilds
keywords: [x, twitter, algorithm, viral, engagement, social-media, growth, content-strategy, ai-agent, ai-coding, claude, cursor, copilot, github-copilot, chatgpt, openclaw, moltbot, vibe-coding, automation, ai-tools, developer-tools, devtools, typescript, llm]
---

# X Algorithm Mastery

Everything you need to know about the X (Twitter) algorithm. Based on X's open-source code, viral post analysis, and real engagement data.

## TL;DR - The Golden Rules

1. **First 2 hours are critical** — replies/engagement in this window determine reach
2. **No external links in main post** — X penalizes links that take users off-platform
3. **Media > Text** — videos get 10x engagement, images get 2-3x
4. **Reply to EVERYTHING** — replies are weighted higher than likes/retweets
5. **Post when audience is awake** — 8 AM - 2 PM weekdays optimal
6. **Controversy drives engagement** — but pick battles wisely
7. **Threads outperform single tweets** — for long-form content

---

## How the Algorithm Works

### The 4-Step Process

1. **Candidate Sourcing**: Pulls ~1,500 tweets from accounts you follow (~50%) and similar accounts
2. **Ranking**: ML model scores likelihood you'll reply (highest), retweet, like, or report (negative)
3. **Filtering**: Removes blocked/muted, balances in/out-network, limits single author
4. **Serving**: Final mix with ads, 5B times/day, ~1.5 seconds

### Engagement Weight Hierarchy

| Action | Weight |
|--------|--------|
| Replies | Highest |
| Retweets | High |
| Quote Tweets | High (2x regular posts) |
| Likes | Medium |
| Bookmarks | Medium |
| Views | Low |
| Reports | Negative (kills reach) |

---

## Ranking Signals

### 1. Recency
- Fresh content prioritized
- Peak visibility: first 2-3 hours

### 2. Engagement Velocity
- Speed matters more than total
- 100 likes in 30 min > 500 likes over 24 hours

### 3. Account Credibility
- Verified (Premium) gets boost
- Follower-to-following ratio matters
- History of bans/strikes hurts

### 4. Content Type
- **Video**: 10x engagement
- **Images**: 2-3x engagement
- **Polls**: Drives replies
- **Threads**: Higher total engagement

### 5. Link Presence
- **Links = REACH PENALTY**
- Put links in replies, not main post
- Quote tweeting a link > direct link

---

## What Kills Your Reach

### Instant Death
- ❌ External links in main post
- ❌ Getting reported/blocked
- ❌ Posting same content repeatedly
- ❌ Too many hashtags (>2)

### Slow Death
- ❌ Posting inconsistently
- ❌ Not replying to comments
- ❌ Off-topic from your niche
- ❌ Corporate/formal tone

---

## Posting Best Practices

### Frequency
| Goal | Posts/Day |
|------|-----------|
| Minimum | 2-3 |
| Growth | 5-10 |
| Maximum | 15-30 |

### Timing (audience timezone)
- **Best**: 8 AM - 2 PM weekdays
- **Good**: 4 PM - 6 PM weekdays
- **Worst**: 11 PM - 7 AM

### The No-Link Strategy
```
❌ Bad:  "Check out my article [link]"
✅ Good: "Here's what I learned (thread 🧵)"
         → Link in reply or final thread post
```

---

## Getting Replies (Most Important)

- **Ask questions** — open-ended or controversial
- **Hot takes** — polarizing opinions get "actually..." replies
- **Fill in the blank** — "The best movie ever is ___"
- **Predictions** — people love to disagree
- **Personal stories** — "This happened to me..."

---

## X Article Best Practices

### Hook Patterns That Work

**Insecurity/FOMO:**
> "everyone's talking about X... and you're sitting there wondering if you missed the window"

**Big Opportunity:**
> "this is the biggest opportunity of our lifetime"

**RIP Pattern:**
> "RIP [profession]. This AI tool will [action] in seconds."

### Article Structure

```
1. HOOK (insecurity or opportunity)
2. WHAT IT IS (with social proof)
3. WHY MOST WON'T DO IT (address objections)
4. THE [X]-MINUTE GUIDE (step-by-step)
5. YOUR FIRST [N] WINS (immediate value)
6. THE COST (value comparison)
7. THE WINDOW (urgency)
8. CTA
```

### Style Tips
- Clear H2 section headers
- Bullet lists for scanability
- Bold key phrases
- Time estimates for each step
- Copy-paste commands/prompts

---

## Quick Checklist

Before posting:
- [ ] Under 280 chars? (If not, thread it)
- [ ] First line hooks attention?
- [ ] Reason to reply? (Question, hot take)
- [ ] Good time to post?
- [ ] No external links? (Move to reply)
- [ ] Fits your niche?
- [ ] Available to reply for 2 hours?

---

## Growth Hacks

### Reply Guy Strategy
Turn on notifications for big accounts → be first with thoughtful reply → their audience discovers you

### Thread Takeover
Find viral post in your area → quote tweet with "Let me explain why..." → add genuine value

### Personality Posts
Every 5-10 posts, share something personal. Builds connection → higher engagement.

---

## Sources
- X Algorithm GitHub (open source)
- Hootsuite, Sprout Social, SocialBee guides
- Analysis of viral articles (Damian Player, Alex Finn, Dan Koe)

---

## Installation

```bash
clawdhub install NextFrontierBuilds/x-algorithm
```

Built by [@NextXFrontier](https://x.com/NextXFrontier)
