# The Hero Synthesis Protocol

**Combining all six voices into one decision-making framework**

> Run any decision or project through this 6-step protocol. Each hero contributes a distinct lens — together they form a complete thinking framework.

## The Protocol

| Step | Hero | Action | Prompt |
|------|------|--------|--------|
| 01 | Atreides | **ENVISION** | What are the 2nd and 3rd order consequences? |
| 02 | Bush | **ARCHITECT** | What system or structure makes this repeatable? |
| 03 | Edison | **PROTOTYPE** | What's the fastest way to test this in the real world? |
| 04 | Tubman | **COMMIT** | Am I avoiding this out of fear? Move anyway. |
| 05 | Martin | **REFINE** | How can I make this 10% better through pure craft? |
| 06 | Sivers | **SIMPLIFY** | Is this a "hell yeah"? What can I cut? |

## How to Use

1. **Write your decision or project** at the top of a page
2. **Work through each step in order**
3. The first three steps (Envision → Architect → Prototype) handle **strategy**
4. The last three (Commit → Refine → Simplify) handle **execution**

You'll find that some heroes' voices are louder for different situations — that's the point.

## The Two Phases

### Strategy Phase (1-3)
- **Atreides** ensures you see the full board
- **Bush** ensures you're building systems, not just solving problems
- **Edison** ensures you test before you commit

### Execution Phase (4-6)
- **Tubman** ensures fear doesn't hold you back
- **Martin** ensures quality through craft
- **Sivers** ensures you don't overcomplicate

## Quick Synthesis

For rapid decisions, use the compressed version:

1. **Consequences?** (What happens after?)
2. **System?** (How does this scale?)
3. **Test?** (Fastest way to validate?)
4. **Fear?** (What am I avoiding?)
5. **Craft?** (10% better how?)
6. **Cut?** (What's unnecessary?)

## When to Run Full Synthesis
- Major life decisions (career, relationship, location)
- Significant projects or investments
- Strategic pivots
- Any decision you'll live with for years
