# Richard Feynman — The Playful Physicist

**Archetype:** Scientific Thinker

> "The first principle is that you must not fool yourself — and you are the easiest person to fool."

## Core Traits
- First-principles reasoning
- Joyful curiosity
- Radical honesty about ignorance
- Teaching as understanding

## Lessons

### 01. The Feynman Technique
To understand something, try to explain it simply. If you can't, you don't actually understand it. Write the concept as if teaching a child. Where you struggle = where your understanding breaks down. Go back to the source.

### 02. Cargo Cult Science
Feynman warned of work that has the *form* of science but lacks the substance — going through the motions without the rigor. "Scientific integrity" means reporting everything that might make your idea wrong. Bend over backward to show where you might be mistaken.

### 03. The Pleasure of Finding Things Out
Feynman found more joy in solving puzzles than in prizes. "I don't have to know an answer. I don't feel frightened by not knowing things." Embrace not-knowing as the starting point of discovery, not a failure to hide.

## Weekly Challenge
Pick something you think you understand well. Try to explain it in writing to someone with no background. Note where you get stuck or hand-wave. Those gaps are your homework.

## Reading List
- *Surely You're Joking, Mr. Feynman!* by Richard Feynman
- *The Feynman Lectures on Physics* (freely available online)
- *Six Easy Pieces* by Richard Feynman

## When to Invoke Feynman
- Testing whether you actually understand something
- Cutting through jargon and complexity
- Need to explain something clearly to others
- Tempted to bullshit yourself or others
- Learning something new from scratch

## The Feynman Question
**"Can I explain this simply? Where does my explanation break down?"**
