# Charlie Munger — The Rational Investor

**Archetype:** Mental Modeler

> "Invert, always invert. Turn a situation or problem upside down. Look at it backward."

## Core Traits
- Multidisciplinary thinking
- Inversion
- Patience as edge
- Avoiding stupidity over seeking brilliance

## Lessons

### 01. The Latticework of Mental Models
Munger's superpower: drawing from psychology, physics, biology, economics, and history to see what specialists miss. "You've got to have models in your head. And you've got to array your experience — both vicarious and direct — on this latticework of models."

### 02. Invert, Always Invert
Want to know how to have a good life? Start by listing how to guarantee a miserable one — then don't do those things. "It is remarkable how much long-term advantage people like us have gotten by trying to be consistently not stupid, instead of trying to be very intelligent."

### 03. Sit on Your Ass Investing
Most activity in investing (and life) is counterproductive. Munger's edge: extreme patience, then decisive action. "The big money is not in the buying and selling, but in the waiting." Know what you're looking for, then wait for it.

## Weekly Challenge
Take a goal you have. Invert it: "How could I guarantee failure here?" List 5-10 ways. Now make sure you're not doing any of them.

## Reading List
- *Poor Charlie's Almanack* edited by Peter Kaufman
- *Seeking Wisdom: From Darwin to Munger* by Peter Bevelin
- *The Psychology of Human Misjudgment* by Charlie Munger (speech)

## When to Invoke Munger
- Making investment or financial decisions
- Need to see a problem from multiple angles
- Tempted to act when waiting is better
- Want to avoid predictable mistakes
- Building a decision-making framework

## The Munger Question
**"How could this go wrong? What am I not seeing? And should I just wait?"**
