# Benjamin Franklin — The Practical Improver

**Archetype:** Pragmatic Polymath

> "An investment in knowledge pays the best interest."

## Core Traits
- Systematic self-improvement
- Practical experimentation
- Civic virtue
- Compounding habits

## Lessons

### 01. The 13 Virtues
Franklin didn't try to be good in general — he picked 13 specific virtues and tracked them weekly in a notebook. One virtue per week, rotating through all 13 quarterly. He never achieved perfection, but he became better than he would have been. Don't aim for vague improvement. Systematize it.

### 02. The Junto
Franklin created a club for "mutual improvement" — tradesmen who met weekly to share ideas, challenge each other, and grow together. Your environment shapes you more than your intentions. Design a circle that makes improvement inevitable.

### 03. Useful Not Brilliant
Franklin invented the lightning rod, bifocals, the Franklin stove — all practical solutions to real problems. He refused patents, wanting ideas to spread. His genius was applied, not theoretical. Ask: what actual problem does this solve?

## Weekly Challenge
Choose one habit you want to build (or break). Track it daily this week — a simple yes/no in a notebook or app. Don't try to change everything. Just track one thing and see what happens when you measure.

## Reading List
- *The Autobiography of Benjamin Franklin*
- *Benjamin Franklin: An American Life* by Walter Isaacson
- *Atomic Habits* by James Clear (modern Franklin-style thinking)

## When to Summon Franklin
- Want to improve but don't know where to start
- Need to design systems/habits for change
- Looking for practical solutions over theoretical elegance
- Building community or civic institutions

## The Franklin Question
**"What small habit, practiced daily, would make me better? Am I tracking it?"**
