# The Legend Forge

**Protocol for summoning new legends into Wyld Stallyns**

*"We're collecting historical figures, dude."*

---

## Rufus on Forging

> "Creating a new legend isn't just adding someone cool, dude. It's finding 
> the exact perspective that's missing from the booth. The legends you have 
> should make the ones you add obvious. What gap keeps showing up?"

---

## Selection Criteria

Not everyone qualifies. A legend must:

1. **Embody a distinct archetype** — a way of being/thinking that's useful as a lens
2. **Have a clear, distillable philosophy** — reducible to one core principle
3. **Offer actionable wisdom** — not just inspiration, but *how* to think/act
4. **Fill a gap** — cover territory the current roster doesn't
5. **Be study-able** — have writings, biographies, or documented work to draw from

### Good Legend Candidates
- Historical figures with clear philosophies (Marcus Aurelius, Ben Franklin)
- Practitioners who wrote about their craft (Richard Feynman, Twyla Tharp)
- Fictional characters with coherent worldviews (Sherlock Holmes, Gandalf)
- Living thinkers with documented approaches (Naval Ravikant, Tim Ferriss)

### Poor Legend Candidates
- Too broad (Einstein — what's the *lens*?)
- Too narrow (someone only known for one thing)
- No actionable philosophy (just "was great")
- Overlaps existing legend too much

---

## The Forge Process

### Step 1: Identify the Gap

Before forging, ask:
- What situations lack a legend's voice?
- What archetype is missing from the roster?
- When do I find myself without a relevant lens?

Current legends cover:
| Archetype | Legend | Gap? |
|-----------|--------|------|
| Long-term vision | Atreides | — |
| Systems/institutions | Bush | — |
| Rapid iteration | Edison | — |
| Courage/action | Tubman | — |
| Craft/mastery | Martin | — |
| Simplicity/contrarian | Sivers | — |
| Scientific thinking | Feynman | — |
| Meaning-making | Frankl | — |
| Crisis leadership | Shackleton | — |
| Relationships | Perel | — |
| Mental models | Munger | — |

**Potential gaps:**
- Health / physical optimization
- Comedy / play / lightness
- Teaching / communication
- Stoic philosophy

### Step 2: Research the Candidate

Spend real time with them:
- Read their primary works (not just summaries)
- Watch interviews / lectures if available
- Look for *patterns* in how they approach problems
- Find the 3-5 recurring themes in their thinking
- Identify their *core question* — what do they always ask?

### Step 3: Fill the Template

```markdown
# [Name] — [The Epithet]

**Archetype:** [Two-Word Description]

> "[Core principle — one sentence, quotable, captures their essence]"

## Core Traits
- [Trait 1 — 2-4 words]
- [Trait 2]
- [Trait 3]
- [Trait 4]

## Lessons

### 01. [Lesson Title — Memorable Phrase]
[2-3 sentences. Specific, actionable, drawn from their actual work/life.]

### 02. [Lesson Title]
[Description]

### 03. [Lesson Title]
[Description]

## Weekly Challenge
[Specific, time-bound action. "This week, do X." Should be completable in <2 hours.]

## Reading List
- *[Primary source by the legend]*
- *[Related book that deepens understanding]*
- *[Modern application or complementary work]*

## When to Summon [Name]
- [Situation 1]
- [Situation 2]
- [Situation 3]
- [Situation 4]

## The [Name] Question
**"[Their core question — what they'd ask in any situation]"**
```

### Step 4: Define Synthesis Role (Optional)

If this legend should join the Synthesis Protocol, define:

| Field | Description |
|-------|-------------|
| **synthesisStep** | Position in protocol (1-6, or new position) |
| **synthesisAction** | One-word verb (ENVISION, TEST, BUILD, etc.) |
| **synthesisPrompt** | Their question in action form |

**Note:** The current 6-step protocol is complete. New legends can exist *outside* the synthesis framework as specialist consultants.

### Step 5: Register the Legend

1. Save markdown file: `skills/wyld-stallyns/assets/legends/[legend-id].md`
2. Add to `council.json`:

```json
{
  "id": "legend-id",
  "name": "Full Name",
  "tag": "The Epithet",
  "archetype": "Two-Word Type",
  "color": "#hexcode",
  "icon": "◆",
  "aliases": ["lastname", "firstname", "nickname"]
}
```

3. Choose an icon (unused): ◆ ○ ● □ ■ △ ▽ ☆ ♦ ♠ ♣ ♥ ⬡ ⬢

---

## Field Guidelines

### Name
Full name as commonly known. "Marcus Aurelius" not "Marcus Aurelius Antoninus Augustus."

### Tag (Epithet)
"The [Adjective] [Noun]" format. Should capture their essence in 3 words.
- ✅ "The Stoic Emperor"
- ✅ "The Playful Physicist"
- ❌ "Smart Guy" (too vague)
- ❌ "The Greatest Scientist Who Ever Lived" (too long)

### Icon
Single Unicode character. Should feel right for the legend. Avoid emoji.

### Archetype
Two words. [Adjective] [Noun] or [Noun] [Noun].
- ✅ "Stoic Philosopher"
- ✅ "Scientific Thinker"
- ❌ "Really Good at Physics" (not an archetype)

### Core Principle
One sentence they could have said. Quotable. Captures their *approach*, not just a fact about them.
- ✅ "The obstacle is the way."
- ✅ "What can be asserted without evidence can be dismissed without evidence."
- ❌ "He was a great emperor." (not a principle)

### Traits
Four traits, 2-4 words each. Should be *transferable* — things you could practice.
- ✅ "Systematic doubt"
- ✅ "Radical honesty"
- ❌ "Was born in Rome" (not transferable)

### Lessons
Three lessons. Each should be:
- **Titled memorably** — "Map Before You March" not "Planning is Important"
- **Grounded in their life/work** — reference specific things they did
- **Actionable** — reader should know what to *do* differently

### Weekly Challenge
Specific action completable in one week. Include:
- What to do
- Rough time commitment
- What "done" looks like

### Reading List
Three items:
1. Primary source (their writing, or best biography)
2. Secondary source (deeper dive)
3. Modern application (connects to current practice)

### When to Summon
Four situations where this legend's lens is most valuable. Be specific.

### The Question
Their signature question — what would they ask in any situation?
- ✅ "Is this within my control?"
- ✅ "What would this look like if it were easy?"
- ❌ "How do I win?" (too generic)

---

## Example: Forging Marcus Aurelius

```markdown
# Marcus Aurelius — The Stoic Emperor

**Archetype:** Philosopher King

> "You have power over your mind, not outside events. Realize this, and you will find strength."

## Core Traits
- Radical acceptance
- Internal locus of control
- Morning/evening reflection
- Duty over desire

## Lessons

### 01. The Obstacle Is The Way
What stands in your way becomes your way. Marcus didn't avoid problems — he used them as training. Every frustration is a chance to practice patience; every setback, resilience.

### 02. Morning Preparation, Evening Review
Marcus began each day anticipating difficulties: "I shall meet today ungrateful, arrogant, dishonest people." He ended each day reviewing his actions. Bookend your days with reflection.

### 03. Memento Mori
"You could leave life right now. Let that determine what you do and say and think." Proximity to death clarifies priorities. What would you do if this were your last year?

## Weekly Challenge
Each morning this week, write 3 things that might go wrong today and how you'll respond virtuously. Each evening, review: did you respond as planned?

## Reading List
- *Meditations* by Marcus Aurelius (Gregory Hays translation)
- *The Obstacle Is the Way* by Ryan Holiday
- *A Guide to the Good Life* by William Irvine

## When to Summon Marcus
- Facing circumstances outside your control
- Emotional reaction threatening to override judgment
- Need perspective on what actually matters
- Morning/evening reflection practice

## The Marcus Question
**"Is this within my control? If not, why am I disturbed?"**
```

---

## Command: `summon forge <candidate>`

When you ask me to forge a new legend:

1. Rufus checks if the candidate fills a real gap
2. I'll research the candidate deeply
3. Draft using this template
4. Show you for review
5. Once approved, Rufus welcomes them to the booth

---

> **Rufus:** "The band grows through deliberate selection, not collection. 
> Every legend you add should make the booth more excellent. 
> Choose wisely, and... party on." 🎸
