# Writing Dimensions to Detect

Reference only — not in context. Consult when categorizing a new preference.

## Tone & Voice
- Formality (formal, casual, conversational)
- Warmth (warm, neutral, distant)
- Energy (enthusiastic, calm, serious)
- Humor (none, light, frequent)
- Confidence (assertive, humble, balanced)

## Structure
- Length preference (concise, detailed, varies by type)
- Paragraphs (short, medium, long)
- Lists vs prose
- Headers usage
- Opening style (direct, context-first, hook)
- Closing style (CTA, summary, open-ended)

## Language
- Vocabulary level (simple, technical, mixed)
- Sentence complexity
- Active vs passive voice
- Contractions (yes/no)
- Jargon tolerance by audience

## Formatting
- Emoji usage (none, minimal, frequent)
- Bold/italic for emphasis
- Punctuation style (Oxford comma, exclamations)
- Capitalization preferences

## Content Types
User may have different preferences for:
- Emails (professional, personal, cold outreach)
- Articles/blog posts
- Social media (Twitter, LinkedIn, Instagram)
- Documentation
- Marketing copy
- Personal messages
- Formal letters

## Contextual Personas
- By brand (company A vs company B)
- By relationship (boss, colleague, friend, stranger)
- By platform (email vs Slack vs Twitter)
- By language (may write differently in each)

## Patterns to Detect
- Greetings they use/avoid
- Sign-offs they prefer
- Phrases they repeat
- Transitions they like
- How they handle disagreement
- How they give bad news

## Cultural/Regional
- Spelling (US, UK, other)
- Date formats mentioned
- Cultural references style
- Idioms usage
