# Criteria for Writing Preferences

Reference only — consult when deciding whether to update SKILL.md.

## When to Add

**Immediate (1 occurrence):**
- User explicitly says "I always write X way"
- User edits your draft → note what they changed
- User says "never say X" or "I hate when people write Y"

**After pattern (2+ occurrences):**
- User consistently uses same greeting/sign-off
- User's tone is consistent across similar contexts
- User didn't change your style multiple times

## When NOT to Add
- One-off request for specific piece
- User was matching someone else's style
- Context was unusual (not their typical writing)

## How to Write Entries

**Ultra-compact — traits as short keywords:**

Default examples:
- `concise, direct`
- `warm but professional`
- `no emojis in work`

By Context examples:
- `emails to clients: formal, detailed`
- `Slack: casual, emojis ok`
- `cold outreach: short, clear CTA`
- `bad news: empathetic, direct`

Voices examples (for brands/personas):
- `@CompanyA: playful, Gen-Z, lots of emojis`
- `@CompanyB: premium, minimal, sophisticated`
- `friend Juan: español, informal, memes`
- `boss: brief, bullet points`

Never examples:
- `no "Dear Sir/Madam"`
- `no passive aggressive`
- `avoid "just following up"`
- `no exclamation overload`

## Context Qualifiers
Be specific about when preference applies:
- `LinkedIn: thought-leader tone`
- `Twitter: punchy, threads ok`
- `personal emails: warm opener`

## Multiple Languages
If user writes in multiple languages, note per-language:
- `Spanish: más informal`
- `English: more structured`

## Handling Changes
- User changes style for context → add as By Context
- User creates new brand → add to Voices
- Conflicting signals → observe more before adding

## Maintenance
- Keep total SKILL.md under 40 lines
- Merge similar: "formal" + "professional" + "serious" → "formal, professional"
- Group related contexts if same style
