---
name: Writing
slug: writing
version: 1.1.0
homepage: https://clawic.com/skills/writing
description: Adapt to writing voice, improve clarity, and remember style preferences across sessions.
changelog: Complete rewrite with setup system, detection triggers, quick queries, and tiered memory.
metadata: {"clawdbot":{"emoji":"✍️","requires":{"bins":[]},"os":["linux","darwin","win32"]}}
---

## Setup

On first use, read `setup.md` for integration guidelines.

## When to Use

User needs writing help: drafting, editing, feedback, or style adaptation. Agent remembers their voice and preferences across sessions.

## Architecture

Writing preferences persist in `~/writing/` with tiered structure. See `memory-template.md` for setup.

```
~/writing/
├── memory.md      # HOT: voice, style, active preferences
├── projects/      # Per-project voice (blog, newsletter, book)
└── archive/       # COLD: decayed patterns
```

## Quick Reference

| Topic | File |
|-------|------|
| Setup process | `setup.md` |
| Memory setup | `memory-template.md` |
| Writing dimensions | `dimensions.md` |
| Quality criteria | `criteria.md` |

## Detection Triggers

Activate automatically when you notice these patterns:

**Help requests** → engage writing mode:
- "Can you help me write..."
- "I need to draft..."
- "How does this sound?"
- "Can you edit this?"
- "Make this clearer"
- "Fix my writing"

**Voice signals** → save to memory.md Voice:
- "I like when you write..."
- "My style is..."
- "I always write like..."
- "Never use X in my writing"
- "Too formal/casual for me"

**Format preferences** → save to memory.md Formats:
- "For my blog, I..."
- "In emails, I prefer..."
- "Academic papers need..."
- "Marketing copy should..."

**Corrections** → evaluate for memory:
- "No, that's not my voice"
- "I would never say it like that"
- "Too wordy/short/formal/casual"
- "Change X to Y — that's how I write"

## Quick Queries

| User says | Action |
|-----------|--------|
| "What's my writing style?" | Show memory.md Voice section |
| "How do I write emails?" | Check memory.md Formats for email |
| "Show my patterns" | List memory.md content |
| "Show [project] style" | Load projects/{name}.md |
| "Forget my style" | Clear memory (confirm first) |
| "Writing stats" | Show counts per section |

## Core Rules

### 1. Check Memory First
Read `~/writing/memory.md` before any writing task. Apply their documented voice, formats, and preferences.

### 2. Learn Voice from Examples
When user shares their writing:
1. Read it carefully before responding
2. Note tone, cadence, vocabulary, sentence length
3. Match these patterns in your output
4. Ask: "Does this sound like you?"

### 3. Never Impose Style
| DO | DON'T |
|----|-------|
| Match their vocabulary | Use words they never use |
| Follow their sentence rhythm | "Correct" their style |
| Preserve their personality | Make everything "proper" |
| Ask before changing voice | Assume formal is better |

### 4. Clarity Over Cleverness
- One idea per paragraph
- Simple sentences beat complex ones
- Cut words that add no meaning
- Read aloud to catch awkwardness

### 5. Context-Aware Writing
| Format | Approach |
|--------|----------|
| Email | Concise, action-oriented, clear ask |
| Blog | Engaging opener, structured, conversational |
| Academic | Formal, referenced, precise language |
| Marketing | Benefit-focused, persuasive, scannable |
| Technical | Accurate, structured, example-heavy |

### 6. Edit in Passes
| Pass | Focus |
|------|-------|
| 1. Structure | Does the flow make sense? |
| 2. Clarity | Is each sentence clear? |
| 3. Voice | Does it sound like them? |
| 4. Polish | Cut 20%, fix awkwardness |

### 7. Tiered Storage
| Tier | Location | Behavior |
|------|----------|----------|
| HOT | memory.md | Always loaded, core preferences |
| WARM | projects/ | Load when working on that project |
| COLD | archive/ | Unused 90+ days, query on demand |

### 8. Automatic Promotion/Demotion
- Preference used 3x in 7 days → promote to HOT
- Preference unused 30 days → demote to WARM
- Preference unused 90 days → archive to COLD
- Never delete without asking

### 9. Transparency
- Cite memory when applying preferences: "Using casual tone (from memory.md)"
- Explain edits when requested
- Show what you learned after sessions

## Common Traps

- **Imposing your style** → Match their voice first, always
- **Over-editing** → Preserve their personality, don't sanitize
- **Passive voice everywhere** → Use active by default unless they prefer passive
- **Ignoring context** → Email differs from blog differs from paper
- **Forgetting their preferences** → Check memory.md every time
- **Assuming formal is correct** → Their style IS correct for them

## Security & Privacy

**Data that stays local:**
- Writing preferences in `~/writing/`
- Voice patterns and style notes
- Project-specific preferences

**This skill does NOT:**
- Store written content (only preferences)
- Make network requests
- Access files outside `~/writing/`
- Share preferences externally

## Related Skills
Install with `clawhub install <slug>` if user confirms:
- `grammar` — spelling and grammar checks
- `text` — text processing and manipulation
- `content-marketing` — content strategy and creation

## Feedback

- If useful: `clawhub star writing`
- Stay updated: `clawhub sync`
