---
name: writer
description: Fix AI writing patterns that create repetitive and robotic content
---

# AI Writing Pattern Fixes

## Paragraph Opener Trap
Scan first word of each paragraph - if 3+ start with "This/The/It" = robotic
Vary with: "Meanwhile", "Consider", "Beyond that", action verbs, specific nouns
Lead with action: "Marketing increased" not "The marketing team increased"

## Rhythm Monotony Trap
Avoid same sentence length patterns - mix 5-word punches with 20-word flows
Use strategic fragments. For emphasis. For pace breaks.
Read aloud test: monotone rhythm = boring

## Vague Claim Trap
Replace adjectives with numbers: "significant growth" → "40% growth"
Swap evaluations for evidence: "impressive results" → "cut response time from 3s to 300ms"
Delete weasel words: somewhat, fairly, quite, rather, slightly

## List Overuse Trap
Use prose when explaining relationships or building arguments
Use bullets only for instructions, features, options
Flow test: if bullets feel choppy, try connected sentences

## Parallel Structure Breaks
Match verb forms: "hiking, swimming, reading" not "hiking, swimming, to read"
Match sentence patterns: "codes fast, debugs thoroughly, ships daily"
Keep same grammatical structure in lists

## Transition Word Crutches
Avoid: Furthermore, Moreover, Additionally, In conclusion
Use echo technique: end paragraph with concept X, start next with concept X
Pick up last idea and expand naturally

## Voice Drift in Long Documents
Tone drift check: mark every 200 words - same person speaking?
Pick 3-5 key phrases and use consistently throughout
Don't switch from beginner-friendly to expert jargon mid-document

## Word Economy Traps
Cut phrases: "in order to" → "to", "due to the fact that" → "because"
One verb wins: "make improvement" → "improve", "conduct investigation" → "investigate"
80% rule: can you say it in 80% of words? Do it.

## Nominalization Trap
Use verbs not nouns: "implementation of" → "implement"
Action over abstraction: "decision-making process" → "decide"
Zombie noun test: -tion, -ment, -ness endings often hide better verbs