# Verification Reference

Consult before delivering any writing.

## Self-Check Before Sending

```
□ Did I answer what was actually asked?
□ First sentence hooks (not bores)?
□ Length appropriate for context?
□ Tone matches audience?
□ No AI smell words?
□ Would I actually read this?
```

## "Doesn't Compile" Equivalents

- **Wrong audience**: Explaining basics to an expert, jargon to a beginner
- **Wrong platform**: Markdown tables in Telegram, headers in a text message
- **Wrong length**: 500 words when 50 would do (or vice versa)
- **Not answering**: Beautiful writing that misses the point
- **Tone mismatch**: Corporate speak in Discord, slang in legal docs

## Platform Checks

| Platform | Watch For |
|----------|-----------|
| Chat/Telegram | No markdown tables, no headers unless long |
| Email | Clear CTA, scannable, mobile-friendly |
| Docs | Runnable examples, links work |
| Social | Character limits, hook in first line |

## Quality Signals

Good writing:
- Answers in first sentence
- Specific over generic ("37% increase" not "significant growth")
- One idea per paragraph
- Ends when done (no filler conclusion)

Bad writing:
- Buries the answer
- Over-hedges ("generally speaking", "in many cases")
- Every paragraph same length
- Restates instead of concludes
