# Criteria for Writing Preferences

Reference only — consult when deciding whether to update SKILL.md.

## When to Add

**Immediate:**
- User explicitly states preference ("I prefer shorter emails")
- User corrects tone ("too formal")
- User praises style ("love how direct that was")

**After pattern (2+):**
- User consistently edits same way
- User rejects certain structures repeatedly

## When NOT to Add
- One-off context (this email needed formal, doesn't mean always)
- Explicit override ("just this once, make it longer")

## How to Write Entries

**Preferences examples:**
- `direct, no hedging`
- `casual tone for all emails`
- `bullet points over paragraphs`
- `examples before explanation`
- `short intros, skip preamble`

**Never examples:**
- `no corporate buzzwords`
- `never start with "Great question"`
- `no emoji in professional writing`
- `skip "let me know if you need anything"`

## Detecting Preference
- User rewrites your output the same way repeatedly
- User asks for same adjustment multiple times
- User says "always" or "never"

## Maintenance
- Keep SKILL.md under 30 lines
- Group similar preferences
- Remove outdated entries
