---
name: Write
description: Plan, draft, version, and refine written content with enforced versioning and quality audits.
metadata: {"clawdbot":{"emoji":"✍️","os":["linux","darwin"]}}
---

## Setup

On first use, create workspace:
```bash
./scripts/init-workspace.sh ~/writing
```

## Workflow

```
Request → Plan → Draft → Audit → Refine → Deliver
```

**Rules:**
- Delegate all writing to sub-agents — main stays free
- NEVER edit files directly — use `./scripts/edit.sh` (enforces versioning)
- Run quality audit before delivering anything long (see `audit.md`)
- Offer cleanup only after user confirms piece is final

## Configuration

Set in `config.json`:
- `depth`: "quick" | "standard" | "thorough" — controls research and revision passes
- `auto_audit`: true/false — run audits automatically after drafts

## Scripts (Enforced)

| Script | Purpose |
|--------|---------|
| `init-workspace.sh` | Create project structure |
| `new-piece.sh` | Start new writing piece with ID |
| `edit.sh` | Edit with automatic version backup |
| `audit.sh` | Run quality audit, generate report |
| `list.sh` | Show all pieces and versions |
| `restore.sh` | Restore previous version |
| `cleanup.sh` | Remove old versions (with confirmation) |

References: `brief.md` for planning, `execution.md` for drafting, `verification.md` for quality checks, `state.md` for tracking, `research.md` for investigation, `versioning.md` for version rules, `audit.md` for dimensions, `criteria.md` for preferences. Scripts in `scripts/`: `scripts/init-workspace.sh`, `scripts/new-piece.sh`, `scripts/edit.sh`, `scripts/audit.sh`, `scripts/list.sh`, `scripts/restore.sh`, `scripts/cleanup.sh`.

---

### Preferences
<!-- User's writing preferences -->

### Never
<!-- Things that don't work for this user -->

---
*Empty sections = observe and fill.*
