# WPS Skill 本地部署指南

## 部署状态

✅ **部署完成** - WPS Skill 已成功在本地部署

## 环境信息

- **Python 版本**: 3.9.6
- **操作系统**: macOS
- **安装路径**: `/Users/usali/Documents/GitHub/Maxstorm/wps-skill`

## 已安装依赖

- ✅ python-docx 1.2.0
- ✅ Pillow (最新版)
- ✅ markdown
- ✅ pyautogui 0.9.54
- ✅ pyperclip 1.11.0

## 快速开始

### 1. 基本命令

```bash
# 进入项目目录
cd /Users/usali/Documents/GitHub/Maxstorm/wps-skill

# 查看文档列表
python3 scripts/main.py list

# 创建 Word 文档
python3 scripts/main.py create type=writer filename=我的文档.docx
```

### 2. Markdown 转换功能

```bash
# Markdown 转 Word（完整版）
python3 scripts/main.py md_to_docx file=文档.md output=文档.docx title="标题"

# Word 转 Markdown
python3 scripts/main.py docx_to_md file=文档.docx output=文档.md

# Markdown 转 Word（含图片）
python3 scripts/main.py md_with_images_to_docx file=文档.md output=文档.docx
```

### 3. 图片处理功能

```bash
# 插入图片到 Word
python3 scripts/main.py insert_image docx=文档.docx image=图片.png width=4 align=center

# 创建图片网格
python3 scripts/main.py insert_image_grid images="1.png,2.png,3.png" cols=2 output=相册.docx

# 图文混排
python3 scripts/main.py create_text_image_layout text="说明文字" image=图片.png layout=left output=图文.docx
```

## 配置说明

配置文件: `config.json`

```json
{
  "default_save_path": "~/Documents/WPS",
  "wps_path": "",
  "app_id": "",
  "app_secret": ""
}
```

- `default_save_path`: 默认文档保存路径
- `wps_path`: WPS 安装路径（可选，自动检测）
- `app_id` / `app_secret`: WPS 365 云端功能凭证（可选）

## 测试文件

测试文件位于 `test/` 目录:
- `test_md.md` - Markdown 测试文件
- `test_output.docx` - 生成的 Word 文档
- `test_image.jpg` - 测试图片
- `layout_test.docx` - 图文混排测试文档

## 功能清单

### 本地文档操作
- ✅ 创建文档 (Word/Excel/PPT)
- ✅ 打开文档
- ✅ 文档列表
- ✅ 格式转换

### Markdown 转换（新增）
- ✅ MD → Word（完整格式支持）
- ✅ Word → MD
- ✅ 支持图片的 Markdown 转换

### 图片处理（新增）
- ✅ 插入图片
- ✅ 图片网格
- ✅ 图文混排（4种布局）
- ✅ 图片尺寸调整

### WPS 365 云端功能
- ⏸️ 智能表单（需配置 app_id）
- ⏸️ 智能文档（需配置 app_id）
- ⏸️ 多维表格（需配置 app_id）

## 使用示例

### 示例 1: 创建带格式的 Word 文档

```bash
# 创建 Markdown 文件
cat > /tmp/demo.md << 'EOF'
# 产品说明书

## 产品特性

- **高性能**: 采用最新技术
- *易用性*: 简单上手
- 多平台支持

## 规格参数

| 参数 | 值 |
|------|------|
| 尺寸 | 10x10cm |
| 重量 | 200g |

## 使用说明

```
1. 开箱检查
2. 连接电源
3. 开始使用
```
EOF

# 转换为 Word
python3 scripts/main.py md_to_docx file=/tmp/demo.md output=/tmp/demo.docx title="产品说明书"
```

### 示例 2: 创建图文混排文档

```bash
# 创建图文混排
python3 scripts/main.py create_text_image_layout \
  text="这是一个展示图文混排功能的示例。图片在左侧，文字在右侧显示。支持多种布局方式。" \
  image=test/test_image.jpg \
  layout=left \
  output=/tmp/图文混排.docx
```

## 故障排除

### 问题 1: 找不到模块
```bash
# 重新安装依赖
pip3 install python-docx Pillow markdown pyautogui pyperclip
```

### 问题 2: 权限错误
```bash
# 检查目录权限
ls -la ~/Documents/WPS

# 修复权限
chmod 755 ~/Documents/WPS
```

### 问题 3: WPS 无法打开
- 确保 WPS Office 已安装
- 检查 `wps_path` 配置

## 下一步

1. 试用 Markdown 转换功能
2. 测试图文混排功能
3. 根据需要配置 WPS 365 云端功能

---

**部署时间**: 2026-02-17
**版本**: 1.0.1
