# WPS Office Skill v1.3.0 发布：全格式图文混排 + Markdown 三件套转换

> 让 WPS 文档处理更智能，Word/Excel/PPT 全格式图文混排来了！

## 🎉 版本亮点

WPS Office Skill 迎来重大更新！v1.3.0 版本带来了四大核心功能：

1. **全格式图文混排** - Word/Excel/PPT 全部支持图文混排
2. **完整的 Markdown 三件套转换** - Word/Excel/PPT 全覆盖
3. **强大的图片处理功能** - 插入、排版、布局一站式解决
4. **双向转换支持** - MD ↔ Office 互转

---

## ✨ 新功能详解

### 一、Markdown 三件套转换

v1.2.0 版本最大的升级是支持 Markdown 一键转换为 Word、Excel、PPT 三种格式！

#### 1. Markdown 转 Word

之前版本只能将 Markdown 转为 RTF 或 HTML，现在可以直接生成完美的 Word 文档！

#### 支持特性

| 特性 | 支持程度 | 说明 |
|------|----------|------|
| 标题 | ✅ 完整 | H1-H6 完美转换 |
| 列表 | ✅ 完整 | 有序/无序列表 |
| 表格 | ✅ 完整 | 带表头样式 |
| 代码块 | ✅ 完整 | 灰色背景 + 等宽字体 |
| 行内格式 | ✅ 完整 | 粗体、斜体、代码、链接 |
| 引用块 | ✅ 完整 | 缩进 + 斜体 |
| 图片 | ✅ 完整 | 自动提取并插入 |

#### 2. Markdown 转 Excel（新增）

Markdown 表格一键转换为 Excel 工作表，列表转换为数据列！

**支持特性：**
- 表格 → Excel 工作表（带样式）
- 列表 → 单列数据
- 多表格 → 多工作表
- 表头蓝色背景 + 边框

**使用示例：**

```bash
# Markdown 转 Excel
python3 scripts/main.py md_to_xlsx file=销售数据.md output=销售数据.xlsx title="销售数据"

# Excel 转 Markdown
python3 scripts/main.py xlsx_to_md file=销售数据.xlsx output=销售数据.md
```

**效果展示：**

Markdown 表格：
```markdown
| 产品 | 一月 | 二月 | 三月 |
|------|------|------|------|
| 产品A | 100 | 150 | 200 |
| 产品B | 80 | 120 | 160 |
```

转换后 Excel：
- 蓝色表头背景
- 自动列宽
- 完整边框
- 多个表格生成多个工作表

#### 3. Markdown 转 PPT（新增）

Markdown 标题和内容一键生成演示文稿！

**支持特性：**
- H1 → 标题幻灯片
- H2 → 内容幻灯片
- 表格 → 表格幻灯片
- 代码块 → 代码幻灯片
- 列表 → 项目符号列表

**使用示例：**

```bash
# Markdown 转 PPT
python3 scripts/main.py md_to_pptx file=项目汇报.md output=项目汇报.pptx title="项目汇报"

# PPT 转 Markdown
python3 scripts/main.py pptx_to_md file=项目汇报.pptx output=项目汇报.md
```

**效果展示：**

Markdown 内容：
```markdown
# 项目汇报

## 项目概述

本项目旨在开发一款智能文档处理工具。

## 核心功能

- 文档自动转换
- 智能格式识别
- 批量处理能力
```

转换后 PPT：
- 第一张：标题页 "项目汇报"
- 第二张："项目概述" + 段落内容
- 第三张："核心功能" + 项目符号列表

#### 使用示例

```bash
# Markdown 转 Word（基础版）
python3 scripts/main.py md_to_docx file=文档.md output=文档.docx title="我的文档"

# Markdown 转 Word（含图片）
python3 scripts/main.py md_with_images_to_docx file=文档.md output=文档.docx image_width=4

# Word 转 Markdown
python3 scripts/main.py docx_to_md file=文档.docx output=文档.md

# Markdown 转 Excel
python3 scripts/main.py md_to_xlsx file=数据.md output=数据.xlsx title="销售数据"

# Markdown 转 PPT
python3 scripts/main.py md_to_pptx file=汇报.md output=汇报.pptx title="项目汇报"
```

#### 效果展示

**Markdown 原文：**
```markdown
# 产品说明书

## 功能特性

- **高性能**：采用最新技术
- *易用性*：简单上手

## 规格参数

| 参数 | 值 |
|------|------|
| 尺寸 | 10x10cm |
| 重量 | 200g |

## 代码示例

```python
print("Hello World")
```
```

**转换后的 Word：**
- 标题层级清晰
- 表格带网格线
- 代码块有灰色背景
- 粗体斜体完美保留

---

### 二、图文混排功能

四種布局方式，满足各种排版需求：

#### 1. 左图右文（layout=left）
适合：产品说明、图文教程

```bash
python3 scripts/main.py create_text_image_layout \
  text="这是产品说明文字，详细介绍产品特性和使用方法..." \
  image=产品图.jpg \
  layout=left \
  output=产品介绍.docx
```

#### 2. 右图左文（layout=right）
适合：新闻稿、报告

```bash
python3 scripts/main.py create_text_image_layout \
  text="这是报告正文内容..." \
  image=图表.png \
  layout=right \
  output=报告.docx
```

#### 3. 上图下文（layout=top）
适合：海报、封面

```bash
python3 scripts/main.py create_text_image_layout \
  text="这是图片下方的说明文字..." \
  image=封面.jpg \
  layout=top \
  output=封面.docx
```

#### 4. 文字上图（layout=bottom）
适合：图文解说

```bash
python3 scripts/main.py create_text_image_layout \
  text="这是图片上方的说明文字..." \
  image=示意图.png \
  layout=bottom \
  output=说明文档.docx
```

---

### 三、图片网格布局

批量插入图片，自动排版成网格：

```bash
python3 scripts/main.py insert_image_grid \
  images="1.jpg,2.jpg,3.jpg,4.jpg,5.jpg,6.jpg" \
  cols=3 \
  width=2.5 \
  output=相册.docx
```

效果：6 张图片自动排成 2 行 3 列的网格布局。

---

## 🚀 快速开始

### 安装

```bash
npx clawhub install wps-office
```

### 依赖安装

```bash
pip3 install python-docx Pillow markdown pyautogui pyperclip openpyxl python-pptx
```

### 配置

编辑 `~/.openclaw/workspace/skills/wps-office/config.json`：

```json
{
  "default_save_path": "~/Documents/WPS",
  "wps_path": "",
  "app_id": "",
  "app_secret": ""
}
```

---

## 📊 功能对比

| 功能 | v1.0.0 | v1.1.0 | v1.2.0 | 提升 |
|------|--------|--------|--------|------|
| Markdown 转 Word | ⚠️ 仅 RTF/HTML | ✅ 完整 .docx | ✅ 完整 .docx | 质的飞跃 |
| Markdown 转 Excel | ❌ 无 | ❌ 无 | ✅ 完整支持 | 新增 |
| Markdown 转 PPT | ❌ 无 | ❌ 无 | ✅ 完整支持 | 新增 |
| 图片支持 | ❌ 无 | ✅ 完整支持 | ✅ 完整支持 | - |
| 图文混排 | ❌ 无 | ✅ 4 种布局 | ✅ 4 种布局 | - |
| 图片网格 | ❌ 无 | ✅ 自动排版 | ✅ 自动排版 | - |
| Word 转 MD | ❌ 无 | ✅ 支持 | ✅ 支持 | - |
| Excel 转 MD | ❌ 无 | ❌ 无 | ✅ 支持 | 新增 |
| PPT 转 MD | ❌ 无 | ❌ 无 | ✅ 支持 | 新增 |

---

## 💡 实际应用场景

### 场景 1：技术文档编写

程序员写技术文档，用 Markdown 编辑，一键转为 Word 给产品经理。

```bash
python3 scripts/main.py md_to_docx \
  file=API文档.md \
  output=API文档.docx \
  title="API 接口文档"
```

### 场景 2：产品说明书制作

左图右文布局，产品图片 + 详细说明，专业美观。

```bash
python3 scripts/main.py create_text_image_layout \
  text="本产品采用最新技术，具有以下特点：\n1. 高性能\n2. 低功耗\n3. 易使用" \
  image=产品主图.jpg \
  layout=left \
  output=产品说明书.docx
```

### 场景 3：项目汇报

Markdown 写汇报内容，转为 Word 后插入图表，完美排版。

```bash
# 先转 Markdown
python3 scripts/main.py md_to_docx file=汇报.md output=汇报.docx

# 再插入图表
python3 scripts/main.py insert_image \
  docx=汇报.docx \
  image=数据图表.png \
  width=5 \
  align=center \
  caption="图 1：销售数据趋势"
```

---

## 🔧 技术实现

### 核心技术栈

- **python-docx**：Word 文档操作
- **Pillow**：图片处理
- **markdown**：Markdown 解析
- **pyautogui**：GUI 自动化（WPS 控制）

### 代码结构

```
wps-skill/
├── scripts/
│   ├── main.py              # 主入口
│   ├── md_converter.py      # Markdown 转 Word（594行）
│   ├── excel_converter.py   # Markdown 转 Excel（314行）
│   ├── ppt_converter.py     # Markdown 转 PPT（494行）
│   └── image_handler.py     # 图片处理器（631行）
├── skill.json               # Skill 配置
├── SKILL.md                 # 使用文档
└── config.json              # 用户配置
```

---

## 📝 更新日志

### v1.3.0 (2026-02-17)

**新增功能：**
- ✅ PPT 图文混排（4 种布局：左图右文、右图左文、上图下文、文字上图）
- ✅ Excel 图文混排（单元格图片插入、图文布局）
- ✅ PPT 图片插入（指定幻灯片位置插入图片）
- ✅ Excel 图片插入（单元格图片插入）

### v1.2.0 (2026-02-17)

**新增功能：**
- ✅ Markdown 转 Excel（表格变工作表，列表变数据）
- ✅ Excel 转 Markdown
- ✅ Markdown 转 PPT（标题变幻灯片）
- ✅ PPT 转 Markdown

**技术升级：**
- 新增 openpyxl 依赖（Excel 处理）
- 新增 python-pptx 依赖（PPT 处理）

### v1.1.0 (2026-02-17)

**新增功能：**
- ✅ Markdown 完整转 Word（支持所有格式）
- ✅ Word 转 Markdown
- ✅ 图片插入（支持对齐和标题）
- ✅ 图片网格布局
- ✅ 图文混排（4 种布局方式）
- ✅ Markdown 图片自动提取和插入

**优化：**
- 改进中文字体支持
- 优化表格样式
- 代码块添加背景色

### v1.0.0 (2026-02-15)

**基础功能：**
- ✅ 本地文档操作：创建、打开、列表 Word/Excel/PPT 文档
- ✅ 格式转换：Markdown 转 RTF/HTML
- ✅ 批量处理：批量转换文档格式

**WPS 365 云端功能（需配置 app_id 和 app_secret）：**
- ✅ 智能表单：表单列表、获取数据、提交数据、创建表单
- ✅ 智能文档：文档列表、创建文档、获取内容、分享
- ✅ 多维表格：表格列表、创建、数据读写、视图管理
- ✅ 流程图：列表、创建、导出
- ✅ 思维导图：列表、创建、导出

---

## 🤝 参与贡献

欢迎提交 Issue 和 PR！

- GitHub：https://github.com/lilei0311/wps-skill
- 问题反馈：请在 GitHub Issues 中提交

---

## 📄 许可证

MIT License

---

## 💬 讨论

你平时用什么工具写文档？Markdown 还是 Word？欢迎在评论区分享你的经验！

---

**标签：** #WPS #Markdown #Python #自动化 #办公效率 #开源工具 #Excel #PPT #图文混排

**作者：** MaxStorm Team

**发布时间：** 2026-02-17

---

> 💡 **提示**：v1.3.0 版本已发布到 ClawHub，可通过 `npx clawhub install wps-office` 安装体验！
> 
> 全格式图文混排功能现已上线，Word/Excel/PPT 全部支持！
