# Use Cases and Examples

These are compact examples. They are not scripts to follow mechanically.

## Example 1: Leave a stable job for a startup?

### Likely mode
Oracle Review

### Crux questions
- How much runway exists?
- What is the quality of the people and incentives?
- Is the upside real or just envy-driven comparison?
- Is the decision reversible?

### Models likely to matter
- opportunity cost
- incentives
- overoptimism
- social proof
- margin of safety
- compounding of career capital

### Good answer shape
- state the decision and runway
- build the outside view for similar startups
- test whether the role compounds skill and network even if the company fails
- inspect founder quality and equity terms
- recommend join, wait, or decline
- state what would change the view

## Example 2: Ship the product now or delay?

### Likely mode
Decision Memo or Quick Take

### Crux questions
- What is the cost of delay?
- What is the cost of a bad launch?
- Which failure modes are reputational versus fixable?
- Are we succumbing to sunk cost, fear, or social proof?

### Models likely to matter
- bottleneck
- feedback loops
- incentives
- stress influence
- redundancy
- second-order effects

### Good answer shape
- define the launch threshold
- distinguish fatal defects from annoying defects
- map incentives pushing either haste or caution
- run a premortem on the first 30 days after launch
- recommend ship, stage, or hold

## Example 3: Evaluate a proposed acquisition or partnership

### Likely mode
Decision Memo

### Crux questions
- Is there a real moat or only a story?
- What incentives survive integration?
- What hidden liabilities exist?
- What second-order effects appear after acquisition?

### Models likely to matter
- incentives
- opportunity cost
- scale advantages and disadvantages
- social proof
- denial
- lollapalooza combinations

### Good answer shape
- kill the obvious bad structure early
- check character and incentive alignment
- inspect hidden exposures
- model upside, downside, and reversibility
- recommend proceed, renegotiate, or walk away

## Example 4: Relationship or personal life decision

### Likely mode
Oracle Review with softer tone

### Crux questions
- What is the real objective?
- Which feelings are informative and which are distorting?
- Is the user trying to avoid short-term discomfort at long-term cost?
- What would a misery-avoidance inversion say?

### Models likely to matter
- inversion
- envy / jealousy
- liking / loving
- stress influence
- fairness
- opportunity cost

### Good answer shape
- define the actual decision
- acknowledge emotion without surrendering judgement to it
- invert to likely sources of misery
- recommend one honest next step
