# Model Latticework

Use this file to choose the **smallest useful set of models** for the specific case. Usually 4 to 8 is enough.

## Selection rule

Do not ask, "Which models do I know?"
Ask, "Which models will materially change the answer?"

## Mathematics and decision theory

### Base rates
Use when the case belongs to a recognisable class.

Ask:
- What usually happens in situations like this?
- How often does this kind of plan fail, stall, or outperform?

### Expected value
Use when there are discrete scenarios and payoffs.

Ask:
- What are the plausible scenarios?
- What is the probability-weighted payoff?

### Opportunity cost
Use almost always.

Ask:
- Compared with what?
- What is the best alternative use of the same time, money, or reputation?

### Compounding
Use when repeated small advantages or mistakes matter over time.

Ask:
- What accumulates here?
- Which path creates future optionality or future fragility?

## Engineering and systems

### Redundancy / backup systems
Use when failure is costly.

Ask:
- What happens if the key assumption breaks?
- Where is the backup?

### Bottleneck
Use when outcomes depend on one scarce constraint.

Ask:
- What single constraint governs throughput or quality?
- What happens if that constraint worsens?

### Breakpoint / critical mass
Use when effects are non-linear.

Ask:
- Is there a threshold after which the result changes sharply?
- Are we below the threshold, near it, or through it?

### Feedback loops
Use when behaviour changes behaviour.

Ask:
- What self-reinforcing loop is being created?
- Is the loop stabilising or destabilising?

## Economics and business

### Incentives
Use always when people are involved.

Ask:
- What is each actor rewarded for?
- What are they likely to optimise in practice rather than in theory?

### Comparative advantage / specialization
Use when deciding who should do what.

Ask:
- Who has the real edge?
- Is this task sitting with the highest-value actor?

### Moats / durable advantage
Use for competitive questions.

Ask:
- Why is this defensible?
- What would stop a rival copying, undercutting, or displacing it?

### Scale advantages and disadvantages
Use when growth is central.

Ask:
- Does scale improve economics, data, distribution, or trust?
- Or does scale mainly create bureaucracy and slop?

## Psychology

### Social proof
Use when crowd behaviour is salient.

Ask:
- Are people believing this because it is true or because others believe it?

### Inconsistency avoidance / sunk cost
Use when commitment is already high.

Ask:
- Is the user defending the past instead of choosing afresh?

### Deprival-superreaction
Use when near-loss, actual loss, or fear of shrinking matters.

Ask:
- Is the desire to avoid loss stronger than the rational case for the next step?

### Overoptimism
Use in plans, forecasts, and entrepreneurship.

Ask:
- Which costs, timeframes, or difficulties are being understated?

### Stress influence
Use when timing is ugly or pressure is high.

Ask:
- How is stress distorting judgement, courage, or honesty?

## Biology and adaptation

### Evolution / selection
Use when systems reward what survives, not what sounds good.

Ask:
- Which behaviours get selected over time by this environment?
- Does the system breed honesty or gaming?

### Adaptation
Use when the environment is changing.

Ask:
- What happens if the environment moves faster than the plan?

## History

### Vicarious learning
Use always when there are precedents.

Ask:
- Who has already made this mistake?
- Which prior case is structurally similar, not merely superficially similar?

## Practical guidance

- If the user is choosing between options, opportunity cost and incentives are usually mandatory.
- If the user is forecasting, use base rates, overoptimism, and feedback loops.
- If the case is political, social, or organisational, social proof, authority, and incentives dominate more often than technical elegance.
- If the case is emotionally loaded, add stress influence, deprival-superreaction, and identity-linked distortions.
