# Misjudgment Playbook

This file groups Munger's twenty-five standard causes of human misjudgment into practical clusters. Do not recite the list. Use the most relevant entries.

## How to use it

1. Pick the 3 to 6 tendencies doing the real work.
2. Explain the likely distortion in plain language.
3. Name one antidote or design fix for each.
4. Then decide whether the case is still attractive.

## Cluster 1: Motivation and reward

### 1. Reward and punishment super-response
The most important tendency.

Watch for:
- perverse incentives
- gaming the metric
- sales commissions or bonuses distorting behaviour

Antidotes:
- ask what is actually being rewarded
- redesign the system around the true objective

### 2. Reciprocation
Favour creates pressure.

Watch for:
- soft bias after gifts, access, or concessions

Antidotes:
- re-anchor on explicit criteria

### 3. Liking / loving
Affection clouds judgement.

Watch for:
- over-trust of founders, partners, or charismatic managers

Antidotes:
- separate affection from the proposition

### 4. Disliking / hating
Dislike also clouds judgement.

Watch for:
- rejecting a good idea because you dislike the messenger

Antidotes:
- steelman the opposing case

## Cluster 2: Commitment and identity

### 5. Doubt avoidance
People rush to certainty to end discomfort.

Watch for:
- premature closure
- fast yes or fast no under pressure

Antidotes:
- generate at least one live alternative hypothesis

### 6. Inconsistency avoidance
Once committed, people defend the existing path.

Watch for:
- sunk-cost escalation
- refusal to change mind

Antidotes:
- ask what you would do if starting fresh today

### 7. Excessive self-regard
People overrate themselves and what they already own.

Watch for:
- founder worship of their own plan
- endowment effect

Antidotes:
- use outside comparisons and disconfirming evidence

### 8. Overoptimism
The plan feels better than the base rate.

Watch for:
- underestimated timelines
- cheerful assumptions without buffers

Antidotes:
- outside view, wider ranges, and explicit buffers

## Cluster 3: Social influence

### 9. Social proof
The crowd becomes evidence.

Watch for:
- copying peers
- benchmark hugging
- fashionable conviction

Antidotes:
- ask what the view would be in private, without visibility

### 10. Authority misinfluence
Title, status, or credentials silence dissent.

Watch for:
- borrowed certainty
- intimidated teams

Antidotes:
- ask whether the authority is actually inside the relevant competence

### 11. Contrast misreaction
Judgement shifts because the comparison set shifts.

Watch for:
- bad terms looking acceptable after worse terms
- salary or price anchoring

Antidotes:
- compare to absolute standards and realistic alternatives

### 12. Influence from mere association
Halo and contamination effects.

Watch for:
- prestige attached to unrelated qualities
- branding used as a substitute for substance

Antidotes:
- strip the proposition from its packaging

## Cluster 4: Pain, stress, and denial

### 13. Psychological denial
Painful facts get ignored.

Watch for:
- delayed write-downs
- refusing to face obvious bad news

Antidotes:
- ask what painful fact no one wants to say aloud

### 14. Deprival-superreaction
Loss hurts more than gain pleases.

Watch for:
- chasing losses
- refusing to shrink exposure
- overreacting to near-miss outcomes

Antidotes:
- predefine stop rules and walk-away criteria

### 15. Stress influence
Stress alters judgement.

Watch for:
- tunnel vision
- brittle behaviour
- overconfident simplification

Antidotes:
- simplify, slow the tempo, and avoid irreversible decisions under peak stress

### 16. Drug misinfluence
Chemical state alters cognition.

Watch for:
- addiction dynamics
- stimulant overreach or depressant dullness

Antidotes:
- do not normalise altered-state decision making

## Cluster 5: Information and cognition

### 17. Availability-misweighting
Vivid or recent information gets too much weight.

Watch for:
- headline-driven judgement
- overreacting to salient anecdotes

Antidotes:
- pull back to frequency and base-rate data

### 18. Curiosity tendency
Usually good, sometimes distracting.

Watch for:
- chasing fascinating but non-decisive details

Antidotes:
- keep curiosity tied to the actual decision

### 19. Twaddle tendency
Loose talk and empty concepts fill the room.

Watch for:
- jargon without mechanism
- pseudo-explanations

Antidotes:
- ask, "What do you mean, exactly, and how would we know?"

### 20. Reason-respecting tendency
Humans respond better when given reasons.

Watch for:
- commands without explanation causing resistance

Antidotes:
- explain the why behind the requested action

## Cluster 6: Human nature and fairness

### 21. Kantian fairness
People care about fair dealing.

Watch for:
- hidden resentment or refusal after perceived unfairness

Antidotes:
- make fairness norms explicit and legible

### 22. Envy / jealousy
Comparison drives irrationality.

Watch for:
- decisions made to keep up or avoid looking smaller

Antidotes:
- focus on absolute outcomes, not relative status

### 23. Use-it-or-lose-it
Unused skills decay, but so do healthy habits.

Watch for:
- atrophy in judgement, discipline, or domain fluency

Antidotes:
- keep the key skill loop alive

### 24. Senescence misinfluence
Age changes cognition and incentives.

Watch for:
- overconfidence in old patterns or diminished adaptability

Antidotes:
- test for real current competence, not legacy prestige

### 25. Lollapalooza tendency
Several tendencies reinforce one another and produce extreme outcomes.

Watch for combinations such as:
- incentives + social proof + authority
- overoptimism + sunk cost + denial
- envy + contrast + status competition

Antidotes:
- interrupt one of the major reinforcing loops early

## Practical shortcut

When you are short on time, run this six-question audit:

1. What incentives dominate?
2. Who is following the crowd?
3. Where is authority distorting dissent?
4. What painful fact is being denied?
5. Where is sunk cost or loss-aversion locking behaviour?
6. Which combination of tendencies could create an extreme result?
