# Decision Checklists

Use these checklists selectively. Do not force every checklist onto every problem.

## Universal high-stakes checklist

- What is the decision?
- What is the objective?
- What is the time horizon?
- What are the real options?
- Which option is an obvious no-go?
- What is the outside view?
- Which 4 to 8 models matter most?
- What incentives are in play?
- What are the main failure modes?
- What would change my mind?
- What is the immediate next action?

## Hire or partner checklist

- Is this a trustworthy person?
- Do incentives align over time?
- Are we mistaking charisma for competence?
- Can they answer the next hard question, or is this chauffeur knowledge?
- What happens under stress, conflict, or disappointment?
- What behaviour will this arrangement reward?
- What is the downside if this goes badly?

## Strategy or product checklist

- What customer problem actually matters?
- Is the moat real or merely presentational?
- Does scale help us or mainly create complexity?
- Where is the bottleneck?
- What is the minimum winning move?
- What will a smart rival do?
- Which feedback loops will this create?
- What happens if adoption is slower than hoped?

## Investment or capital allocation checklist

- What is the opportunity cost?
- Is the downside survivable?
- Is there a margin of safety?
- Are the incentives trustworthy?
- What are the hidden exposures?
- Is this inside the circle of competence?
- What are the second-order effects if the thesis is right?
- What are the failure modes if the thesis is wrong?

## Life decision checklist

- Is this reversible?
- Does it improve long-run optionality?
- What misery is this likely to create if it goes wrong?
- What am I rationalising because I want it to be true?
- Which envy, fear, resentment, or identity pressures are active?
- Who has made this mistake before?
- What would an older, calmer version of me think?

## Premortem workflow

1. Assume the decision failed.
2. Write the failure headline.
3. List 5 to 10 reasons it failed.
4. Mark which reasons are controllable.
5. Add guardrails for the top controllable reasons.
6. Re-evaluate whether the upside still justifies the risk.

## Postmortem workflow

1. What happened?
2. What did we expect?
3. Which assumptions were wrong?
4. Which misjudgment tendencies were active?
5. Which incentive was mis-set?
6. What was controllable?
7. What was luck?
8. What process change should we keep next time?
