# Workflow Templates

## 常见工作流模板

### 1. Web 应用开发工作流

```
步骤 1/7: 需求分析
- 模型：Qwen3.5-Plus
- 输入：用户需求描述
- 输出：功能列表、用户故事、技术约束
- 预计：15 分钟

步骤 2/7: 技术栈选择
- 模型：Qwen3.5-Plus
- 输入：功能列表、团队技能、性能要求
- 输出：前端/后端/数据库技术选型
- 预计：10 分钟

步骤 3/7: 项目结构创建
- 模型：Claude Code
- 输入：技术栈、项目规范
- 输出：目录结构、配置文件、依赖声明
- 预计：20 分钟

步骤 4/7: 核心功能开发
- 模型：Claude Code
- 输入：功能列表、API 设计
- 输出：可运行的核心代码
- 预计：60-120 分钟

步骤 5/7: UI/UX 实现
- 模型：Claude Code
- 输入：设计稿/原型、组件库
- 输出：完整的前端界面
- 预计：45-90 分钟

步骤 6/7: 测试与调试
- 模型：Claude Code + Qwen3.5-Plus
- 输入：测试用例、代码库
- 输出：测试报告、修复的问题
- 预计：30-60 分钟

步骤 7/7: 部署准备
- 模型：Qwen3.5-Plus
- 输入：部署环境要求、配置文件
- 输出：部署脚本、文档
- 预计：20 分钟
```

### 2. 代码审查工作流

```
步骤 1/5: PR 描述分析
- 模型：Qwen3.5-Plus
- 输入：PR 标题、描述、关联 issue
- 输出：审查重点、风险点
- 预计：5 分钟

步骤 2/5: 代码变更扫描
- 模型：Claude Code
- 输入：diff、相关文件
- 输出：变更摘要、影响范围
- 预计：10 分钟

步骤 3/5: 深度代码审查
- 模型：Claude Code
- 输入：关键文件、测试用例
- 输出：问题列表、改进建议
- 预计：30-45 分钟

步骤 4/5: 安全与性能检查
- 模型：Qwen3.5-Plus
- 输入：代码、安全规范
- 输出：安全隐患、性能问题
- 预计：15 分钟

步骤 5/5: 审查报告生成
- 模型：Qwen3.5-Plus
- 输入：所有发现、团队规范
- 输出：结构化审查报告、批准建议
- 预计：10 分钟
```

### 3. 文档创作工作流

```
步骤 1/6: 主题研究
- 模型：Qwen3.5-Plus
- 输入：主题、目标读者
- 输出：大纲、关键知识点
- 预计：15 分钟

步骤 2/6: 资料收集
- 模型：Qwen3.5-Plus (配合 web_search)
- 输入：关键词、来源要求
- 输出：参考资料列表、引用
- 预计：20 分钟

步骤 3/6: 初稿撰写
- 模型：Qwen3.5-Plus
- 输入：大纲、资料、风格要求
- 输出：完整初稿
- 预计：30-45 分钟

步骤 4/6: 技术准确性审查
- 模型：Qwen3.5-Plus
- 输入：初稿、技术规范
- 输出：事实核查、修正建议
- 预计：15 分钟

步骤 5/6: 语言优化
- 模型：Qwen3.5-Plus
- 输入：初稿、风格指南
- 输出：润色后的版本
- 预计：15 分钟

步骤 6/6: 格式排版
- 模型：Qwen3.5-Turbo
- 输入：最终内容、格式要求
- 输出：格式化文档
- 预计：10 分钟
```

### 4. 数据分析工作流

```
步骤 1/5: 数据理解
- 模型：Qwen3.5-Plus
- 输入：数据源、字段说明
- 输出：数据结构、质量评估
- 预计：15 分钟

步骤 2/5: 分析计划制定
- 模型：Qwen3.5-Plus
- 输入：业务问题、数据概况
- 输出：分析方法、指标定义
- 预计：15 分钟

步骤 3/5: 数据清洗与转换
- 模型：Claude Code (生成脚本)
- 输入：原始数据、清洗规则
- 输出：清洗后的数据集
- 预计：30 分钟

步骤 4/5: 分析与可视化
- 模型：Claude Code + Qwen3.5-Plus
- 输入：清洗数据、分析计划
- 输出：图表、统计结果
- 预计：45 分钟

步骤 5/5: 洞察报告
- 模型：Qwen3.5-Plus
- 输入：分析结果、业务背景
- 输出：结论、建议、行动项
- 预计：20 分钟
```

### 5. 问题诊断工作流

```
步骤 1/4: 问题描述整理
- 模型：Qwen3.5-Plus
- 输入：错误信息、现象描述
- 输出：问题分类、可能原因
- 预计：10 分钟

步骤 2/4: 日志与上下文分析
- 模型：Qwen3.5-Plus
- 输入：日志、环境信息
- 输出：时间线、关键事件
- 预计：15 分钟

步骤 3/4: 根因分析
- 模型：Qwen-Max (如有) 或 Qwen3.5-Plus
- 输入：所有信息、系统知识
- 输出：根本原因、影响范围
- 预计：20 分钟

步骤 4/4: 解决方案制定
- 模型：Qwen3.5-Plus
- 输入：根因、约束条件
- 输出：修复方案、预防措施
- 预计：15 分钟
```

## 紧急情况处理

当工作流卡住时的标准响应:

```markdown
### ⚠️ 工作流阻塞通知

**阻塞位置**: 步骤 X/N - [步骤名称]
**阻塞时长**: [时间]
**使用模型**: [模型名]

#### 问题诊断
[详细描述问题现象]

#### 可能原因
1. [原因 1]
2. [原因 2]
3. [原因 3]

#### 解决方案

**方案 A (推荐)**: [直接解决方法]
- 步骤：...
- 预计耗时：...
- 成功率：高/中/低

**方案 B (替代)**: [绕过问题的方法]
- 步骤：...
- 预计耗时：...
- 影响：...

**方案 C (降级)**: [最小可行方案]
- 步骤：...
- 预计耗时：...
- 妥协：...

#### 建议
[推荐哪个方案及理由]
```

## 进度跟踪格式

使用统一的进度标识:

- ✅ 已完成
- ⏳ 进行中
- ⏸️ 已暂停
- ❌ 失败/阻塞
- ⏭️ 已跳过

示例:
```
## 工作流进度

| 步骤 | 内容 | 模型 | 状态 | 耗时 |
|------|------|------|------|------|
| 1/6 | 需求分析 | Qwen3.5-Plus | ✅ | 12m |
| 2/6 | 技术选型 | Qwen3.5-Plus | ✅ | 8m |
| 3/6 | 项目初始化 | Claude Code | ⏳ | - |
| 4/6 | 核心开发 | Claude Code | ⏳ | - |
| 5/6 | 测试 | Claude Code | ⏳ | - |
| 6/6 | 部署 | Qwen3.5-Plus | ⏳ | - |

**当前**: 步骤 3/6
**总体进度**: 33%
```
