# Model Capabilities Reference

## 当前可用模型

### 阿里系 (Qwen 系列)

#### Qwen3.5-Plus
- **类型**: 强推理模型
- **擅长**: 复杂推理、任务拆解、代码分析、多步骤规划
- **上下文**: 256K
- **速度**: 中等
- **使用场景**: 任务拆解、复杂分析、架构设计

#### Qwen3.5-Turbo
- **类型**: 快速模型
- **擅长**: 快速响应、简单任务、日常对话
- **上下文**: 128K
- **速度**: 快
- **使用场景**: 快速查询、简单编辑、即时反馈

#### Qwen-Max
- **类型**: 最强推理模型
- **擅长**: 极复杂推理、深度分析、专业领域
- **上下文**: 256K
- **速度**: 较慢
- **使用场景**: 高难度推理、专业咨询、深度研究

### 其他模型

#### Claude Code
- **类型**: 代码专用模型
- **擅长**: 代码生成、重构、调试、PR 审查
- **上下文**: 200K
- **速度**: 中等
- **使用场景**: 编码任务、代码审查、技术文档

#### GPT-4 系列
- **类型**: 通用强模型
- **擅长**: 创作、分析、多模态
- **上下文**: 128K
- **速度**: 中等
- **使用场景**: 内容创作、图像分析、综合任务

## 模型选择决策树

```
任务类型？
├─ 复杂推理/任务拆解 → Qwen3.5-Plus 或 Qwen-Max
├─ 编码任务 → Claude Code
├─ 快速响应 → Qwen3.5-Turbo
├─ 内容创作 → GPT-4 或 Qwen3.5-Plus
└─ 专业分析 → Qwen-Max

是否有多个强推理模型可用？
├─ 是 → 选择最新模型
│   └─ 仍有多选 → 优先阿里系 (Qwen)
└─ 否 → 使用唯一可用模型
```

## 模型优化提示

### 对强推理模型 (Qwen3.5-Plus, Qwen-Max)
- 提供完整的背景信息
- 明确输出格式要求
- 允许逐步推理
- 可以处理复杂约束

### 对快速模型 (Qwen3.5-Turbo)
- 指令简洁明了
- 减少不必要的上下文
- 明确期望的输出长度
- 避免多重嵌套任务

### 对代码模型 (Claude Code)
- 提供清晰的输入输出规范
- 说明技术栈和约束
- 包含相关代码片段
- 明确测试要求
