---
name: workflow-decomposer
version: 1.0.0
description: 工作流任务拆解与模型编排技能。使用场景：(1) 收到复杂工作任务需要拆解为可执行步骤，(2) 需要为不同步骤选择最合适的模型，(3) 需要跟踪工作流进度和模型使用情况，(4) 长时间任务卡住需要问题诊断和解决方案。
---

# Workflow Decomposer - 工作流任务拆解与模型编排

## 核心功能

本技能负责将复杂工作任务拆解为详细、可执行的步骤，并为每个步骤选择最合适的模型进行执行。

## 模型选择策略

### 推理模型优先级

1. **首选**: 当前可用的最强推理模型
2. **次选**: 如果有多个强推理模型，优先使用最新模型
3. **再次**: 如果仍有多个，优先使用阿里系模型 (Qwen 系列)
4. **最后**: 任意选择一个

### 模型输出要求

每次任务拆解后必须输出:
1. **任务拆解使用的模型**: 明确告知使用的是哪个模型
2. **当前工作流进度**: 清晰标识进行到了哪一步 (如: 步骤 2/8)
3. **当前步骤使用的模型**: 说明该步骤由哪个模型执行

## 任务拆解流程

### 步骤 1: 接收任务
- 理解用户的核心需求
- 识别任务的复杂度和范围

### 步骤 2: 任务分析
- 分析任务需要的技能类型 (编码、写作、分析、创作等)
- 识别潜在的依赖关系和前置条件

### 步骤 3: 步骤拆解
- 将任务拆解为详细、可执行的子步骤
- 确保每个步骤都是可实现的，不胡编乱造
- 为每个步骤估算所需时间和复杂度

### 步骤 4: 模型匹配
- 根据每个步骤的特性选择最合适的模型
- 考虑因素: 模型专长、上下文长度、推理能力、速度

### 步骤 5: 执行与跟踪
- 按顺序执行每个步骤
- 跟踪进度并记录使用的模型
- 生成适合当前模型理解的内容格式

### 步骤 6: 问题处理
- 如果某步骤卡住超过合理时间，诊断问题
- 提供问题分析和至少 2 个解决方案
- 必要时调整后续步骤

## 输出格式模板

```markdown
## 📋 任务拆解报告

**拆解模型**: [模型名称]
**任务**: [任务简述]
**总步骤数**: N

### 步骤概览
| 步骤 | 内容 | 使用模型 | 状态 |
|------|------|----------|------|
| 1/5 | [步骤描述] | [模型名] | ✅/⏳/❌ |
| 2/5 | [步骤描述] | [模型名] | ✅/⏳/❌ |
...

### 当前进度
**进行到**: 步骤 X/N
**当前步骤**: [详细描述]
**使用模型**: [模型名]
**预计耗时**: [时间]

### 步骤详情

#### 步骤 X: [步骤名称]
**目标**: [要完成什么]
**输入**: [需要什么信息/文件]
**输出**: [产生什么结果]
**模型提示**: [为该模型优化的执行指令]
```

## 问题诊断与解决

当工作流卡在某一步时:

1. **识别问题类型**:
   - 模型理解错误
   - 工具/资源不可用
   - 依赖缺失
   - 超时/性能问题

2. **提供解决方案**:
   - 方案 A: [直接解决方法]
   - 方案 B: [替代路径]
   - 方案 C: [降级方案]

3. **记录与学习**:
   - 记录问题原因
   - 更新后续步骤的预防措施

## 模型内容优化

为不同模型生成适合其理解的内容:

- **强推理模型**: 提供详细逻辑链和推理步骤
- **快速模型**: 提供清晰、简洁的指令
- **代码模型**: 提供明确的输入输出格式
- **创作模型**: 提供风格参考和约束条件

## 使用示例

### 示例 1: 开发任务
```
用户: 帮我创建一个待办事项 Web 应用

拆解后:
- 步骤 1/6: 需求分析 (Qwen3.5-Plus)
- 步骤 2/6: 技术栈选择 (Qwen3.5-Plus)
- 步骤 3/6: 项目结构创建 (Claude Code)
- 步骤 4/6: 前端开发 (Claude Code)
- 步骤 5/6: 后端开发 (Claude Code)
- 步骤 6/6: 测试与部署 (Qwen3.5-Plus)
```

### 示例 2: 分析任务
```
用户: 分析这个项目的代码质量

拆解后:
- 步骤 1/4: 代码库扫描 (Qwen3.5-Plus)
- 步骤 2/4: 静态分析 (专用工具)
- 步骤 3/4: 问题分类 (Qwen3.5-Plus)
- 步骤 4/4: 报告生成 (Qwen3.5-Plus)
```

## 注意事项

1. **步骤粒度**: 每个步骤应该在 5-30 分钟内可完成
2. **依赖检查**: 确保前置步骤完成后才能执行后续步骤
3. **灵活调整**: 根据实际情况动态调整步骤和模型选择
4. **透明沟通**: 始终让用户知道当前进度和使用的模型

## 相关文件

- `references/model-capabilities.md` - 各模型能力对比
- `references/workflow-templates.md` - 常见工作流模板
- `scripts/progress-tracker.py` - 进度跟踪脚本 (可选)
