# Workflow Decomposer - 使用说明

## 技能位置
`skills/public/workflow-decomposer/`

## 核心功能

本技能用于将复杂工作任务拆解为详细、可执行的步骤，并为每个步骤选择最合适的模型。

## 使用方式

### 1. 自动触发
当收到复杂工作任务时，技能会自动触发并进行任务拆解。

### 2. 输出格式
每次拆解后输出:
- **拆解模型**: 当前使用的推理模型
- **工作流进度**: 步骤 X/N
- **当前步骤模型**: 该步骤的执行模型

### 3. 进度跟踪
使用 `scripts/progress-tracker.py` 跟踪工作流进度:
```bash
python scripts/progress-tracker.py status
```

## 模型选择策略

1. **强推理任务**: Qwen3.5-Plus (当前默认)
2. **编码任务**: Claude Code
3. **快速响应**: Qwen3.5-Turbo
4. **极复杂推理**: Qwen-Max (如可用)

## 示例输出

```markdown
## 📋 任务拆解报告

**拆解模型**: Qwen3.5-Plus
**任务**: [任务描述]
**总步骤数**: N

### 步骤概览
| 步骤 | 内容 | 使用模型 | 状态 |
|------|------|----------|------|
| 1/N | ... | ... | ✅/⏳ |

### 当前进度
**进行到**: 步骤 X/N
**当前步骤**: [描述]
**使用模型**: [模型名]
```

## 问题处理

当步骤卡住时，自动提供:
- 问题诊断
- 至少 2 个解决方案
- 推荐方案及理由
