# Visibility & Recognition

## The Visibility Problem

Good work ≠ recognized work. You must actively make your contributions visible.

**Why it matters:**
- Promotions go to people leadership knows
- "Heads down" workers get overlooked
- Your manager can't advocate for what they don't see

## Visibility Tactics

### 1. Written Trail
- Send status updates (don't wait to be asked)
- Summarize verbal conversations in email
- Share learnings with the team (positions you as expert)

### 2. Strategic Presence
- Speak in meetings (even briefly)
- Volunteer for cross-functional projects
- Present your own work when possible

### 3. Relationship Building
- Build relationships with influential people
- Help others (creates advocates)
- Be known for something specific

### 4. Self-Promotion That Doesn't Feel Sleazy
- Focus on outcomes and learnings, not "look at me"
- Share credit generously (makes you look good)
- Frame as "sharing what worked" not "I'm great"

## The Brag Document

Keep a running doc of your wins. Update weekly.

**Format:**
```
## [Month/Quarter]

### Projects
- [Project]: [your specific contribution] → [outcome/metric]

### Impact
- [Saved X hours by doing Y]
- [Influenced decision on Z]

### Recognition
- [Feedback received from who]
- [Mentions/thanks in meetings]

### Learning
- [New skill/knowledge gained]
```

**Use it for:**
- Performance reviews
- Promotion conversations
- Resume updates
- Reminding yourself you're doing well

## Perception Gaps

**Signs you're invisible:**
- Manager surprised by your accomplishments
- Passed over for opportunities you qualified for
- "I didn't know you were working on that"

**Signs you're over-promoting:**
- Eye rolls in meetings
- People avoid working with you
- Feedback about being "self-promotional"

**The sweet spot:**
- Make work visible through artifacts, not announcements
- Let others discover your wins through shared work
- Credit your team (makes you look like a leader)

## Getting Recognition from Your Manager

**Ask explicitly:**
- "I'd like to be considered for [opportunity]. What would I need to demonstrate?"
- "Who should know about this project? Should I present it somewhere?"

**Make their job easy:**
- Write your own performance review bullets
- Send them your brag doc before review time
- Suggest talking points for their leadership meetings

## When You're Overlooked

**First:** Check if it's a visibility problem or a performance problem (ask for feedback).

**If visibility:**
1. Increase communication frequency
2. Ask to present your work
3. Build relationships with skip-levels
4. Find advocates who will speak for you

**If pattern persists:**
Consider whether this environment values what you offer.
