# Professional Communication

## Email Principles

**Structure:** Most important thing first. Details below for those who need them.

```
[One-line summary/ask]

[2-3 sentences of context]

[Details/options if needed]

[Clear next step + deadline if applicable]
```

**Tone calibration:**
- To executives: ultra-concise, action-focused
- To peers: direct but friendly
- To external: more formal, no jargon
- When asking for something: respect their time, be specific

## Email Templates

### Status Update
```
Subject: [Project] Weekly Update - [Date]

TL;DR: On track for [deadline]. Need decision on [one thing].

DONE:
• [Item 1 with outcome]
• [Item 2 with outcome]

IN PROGRESS:
• [Current focus] - ETA [date]

BLOCKED/NEED INPUT:
• [Specific question/decision needed from who]
```

### Requesting Something
```
Subject: Request: [Specific thing] by [date]

Hi [Name],

I need [specific thing] for [brief reason].

Could you [specific action] by [date]?

[One line of context if needed]

Thanks,
```

### Declining a Meeting
```
Subject: Re: [Meeting]

Thanks for including me. I don't think I need to be there since [brief reason].

Happy to [review notes after / join if X topic comes up / contribute async].
```

### Following Up
```
Subject: Re: [Original subject]

Hi [Name],

Following up on this — any update?

[Restate the specific ask]

Happy to [make it easier/provide more context/jump on a quick call].
```

## Meeting Communication

**Before:**
- Review agenda and previous context
- Prepare your one contribution/question
- Have your "any updates?" one-liner ready

**During:**
- Speak early (gets harder as meeting progresses)
- If you have nothing to add, say so: "Nothing from me"
- Take notes on action items

**After:**
- Send summary of your action items
- Follow up on others' commitments

## Saying No

**To your manager:**
"I can do that, but I'd need to deprioritize [X]. Which would you prefer?"

**To peers:**
"I can't take this on right now because [reason]. Could you try [alternative]?"

**To more meetings:**
"I'm not sure I'm needed here — could you send notes instead?"

## Tone Guide

| Situation | Tone | Example |
|-----------|------|---------|
| Urgent request | Direct, short | "Need X by EOD. Can you confirm?" |
| Bad news | Facts first, no softening | "The project is delayed. Here's why and the new plan." |
| Disagreement | Curious, not confrontational | "Help me understand — I was thinking X because Y" |
| Thanks | Specific, not generic | "Thanks for [specific thing] — it helped because [impact]" |
