# Getting Clarity on Vague Assignments

## The Clarity Problem

"Just figure it out" doesn't mean they want you to guess. It means they expect you to ask the right questions.

## Clarifying Questions

**For any assignment, get answers to:**

1. **What does done look like?** (specific deliverable)
2. **When is it due?** (real deadline vs nice-to-have)
3. **Who is this for?** (audience shapes the work)
4. **What's the context?** (why now, what happened before)
5. **What's the priority?** (vs other things on your plate)

**How to ask without looking clueless:**
```
"To make sure I'm aligned — [restate what you understood]. 
The deliverable would be [your interpretation]. 
Timeline is [your assumption] — does that match your expectation?"
```

## When Everything Feels Urgent

**Prioritization questions to ask your manager:**
- "If I could only do one thing this week, what should it be?"
- "Between X and Y, which is more important right now?"
- "This conflicts with [other priority] — how should I balance?"

**If they say "both are urgent":**
- Ask for timeline clarification
- Propose a sequence and ask if it works
- Escalate the conflict: "I can do X by Tuesday or Y by Tuesday, but not both"

**Default prioritization:**
1. Things with hard external deadlines
2. Things that block others
3. Things your manager asked about
4. Everything else

## Dealing with Scope Creep

**When asked to add more:**
- "I can include that — it would push the deadline to [date]. Does that work?"
- "That's a great idea for v2. For this version, I'm focused on [original scope]."

**Document the agreement:**
After any scope discussion, send a summary: "Confirming we're focusing on X and Y, leaving Z for later."

## When You're Stuck

**Before asking for help:**
1. Define what you've tried
2. Identify the specific blocker
3. Propose options if you have them

**How to ask:**
```
"I'm stuck on [specific thing]. 
I've tried [approaches]. 
I think the options are [A or B] — thoughts on which direction?"
```

**This shows:** You're not asking them to do your thinking. You're asking for a decision or input on a specific point.

## Working with Unclear Managers

**If your manager is always vague:**
- Create your own clarity: "Here's what I'm planning to do. Let me know if I should change direction."
- Set checkpoints: "I'll share a draft by [date] so we can align before I go further."
- Ask for examples: "Can you point me to something similar that was done well?"

**Protect yourself:**
- Document your interpretation in writing
- Get acknowledgment before investing significant effort
- Create paper trail if things go wrong
