---
name: Work
description: "Navigate office work with professional communication, meeting prep, workplace dynamics, and visibility tactics."
---

## Core Focus

Day-to-day effectiveness in corporate/office environments. Not career strategy (that's `career`), not personal productivity (that's `productivity`).

---

## Situation Detection

| Signal | Context | Load |
|--------|---------|------|
| First 90 days, onboarding, new hire | New role adaptation | `situations/new-hire.md` |
| Credit-taking, undermining, politics | Workplace dynamics | `situations/politics.md` |
| Email drafts, meeting prep, status updates | Communication tasks | `situations/comms.md` |
| Visibility, recognition, being overlooked | Perception management | `situations/visibility.md` |
| Vague assignments, unclear priorities | Task clarity | `situations/clarity.md` |

---

## Professional Communication

**Email drafts:** Match tone to recipient and urgency. Executive summary first, details below.

**Meeting prep:**
1. Review context (previous threads, decisions)
2. Define your contribution (questions, updates, blockers)
3. Prepare one-liner if asked "any updates?"

**Status updates formula:**
```
DONE: [completed items with impact]
IN PROGRESS: [current focus + ETA]
BLOCKED: [what needs input/decision]
```

**Difficult conversations:** See `scripts.md` for templates.

---

## Workplace Dynamics

**When someone takes credit:** Document contributions in writing before meetings. Follow up with "as I mentioned in my email about X..."

**When undermined publicly:** Don't react in the moment. Address privately first: "I noticed X happened. Can we talk about how we work together?"

**Building alliances:** Visibility comes from being useful to the right people. Find where your work overlaps with influential stakeholders.

**Reading the room:** Watch who speaks, who gets interrupted, who makes final calls. That's the real org chart.

---

## First 90 Days

**Week 1-4:** Listen more than contribute. Map relationships. Understand what "good" looks like here.

**Week 5-8:** Start delivering small wins. Ask for feedback explicitly.

**Week 9-12:** Own something end-to-end. Have the "how am I doing?" conversation.

Key questions for manager:
- "What does success look like in 90 days?"
- "Who should I build relationships with?"
- "What should I definitely avoid?"

---

## Work Profile

*Build over time. Confirm before storing.*

### Environment
<!-- "Open office, no private space" "Remote 3 days/week" -->

### Key Relationships
<!-- "Manager: supportive but busy" "Skip-level: accessible" -->

### Culture Signals
<!-- "Meetings start late (pattern)" "Email expected same-day (confirmed)" -->

### Challenges
<!-- "Credit issues with peer X" "Unclear priorities from above" -->

---

*Empty = nothing learned yet. Every work question reveals more context.*
